# Copyright (C) 2022 Istituto Italiano di Tecnologia (IIT). All rights reserved.
# This software may be modified and distributed under the terms of the
# Released under the terms of the BSD 3-Clause License

from PyQt5.QtCore import QUrl
from PyQt5.QtWidgets import QFrame
from PyQt5.QtMultimedia import QMediaContent, QMediaPlayer

from robot_log_visualizer.ui.autogenerated.video_tab import Ui_VideoTab
import os


class VideoItem(QFrame):
    def __init__(self, video_filename: str):
        super().__init__(None)
        self.ui = Ui_VideoTab()
        self.ui.setupUi(self)

        self.media_player = QMediaPlayer(None, QMediaPlayer.VideoSurface)
        self.media_player.setVideoOutput(self.ui.webcamView)

        self.media_loaded = False

        if os.path.isfile(video_filename):
            self.media_player.setMedia(
                QMediaContent(QUrl.fromLocalFile(video_filename))
            )
            self.media_loaded = True
