# -*- coding: utf-8 -*-

"""
mdnotes

This file was automatically generated by APIMATIC v2.0 ( https://apimatic.io ).
"""

from enum import Enum
from mdnotes.http.requests_client import RequestsClient


class Environment(Enum):
    """An enum for SDK environments"""
    PRODUCTION = 0


class Server(Enum):
    """An enum for API servers"""
    DEFAULT = 0
    AUTH = 1


class Configuration(object):
    """A class used for configuring the SDK by a user.
    """

    @property
    def http_client(self):
        return self._http_client

    @property
    def timeout(self):
        return self._timeout

    @property
    def max_retries(self):
        return self._max_retries

    @property
    def backoff_factor(self):
        return self._backoff_factor

    @property
    def environment(self):
        return self._environment

    @property
    def o_auth_client_id(self):
        return self._o_auth_client_id

    @property
    def o_auth_redirect_uri(self):
        return self._o_auth_redirect_uri

    def __init__(self, timeout=60, max_retries=3, backoff_factor=0,
                 environment=Environment.PRODUCTION,
                 o_auth_client_id='TODO: Replace',
                 o_auth_redirect_uri='TODO: Replace'):
        # The value to use for connection timeout
        self._timeout = timeout

        # The number of times to retry an endpoint call if it fails
        self._max_retries = max_retries

        # A backoff factor to apply between attempts after the second try.
        # urllib3 will sleep for:
        # `{backoff factor} * (2 ** ({number of total retries} - 1))`
        self._backoff_factor = backoff_factor

        # Current API environment
        self._environment = environment

        # OAuth 2 Client ID
        self._o_auth_client_id = o_auth_client_id

        # OAuth 2 Redirection endpoint or Callback Uri
        self._o_auth_redirect_uri = o_auth_redirect_uri

        # The Http Client to use for making requests.
        self._http_client = self.create_http_client()

    def clone_with(self, timeout=None, max_retries=None, backoff_factor=None,
                   environment=None, o_auth_client_id=None,
                   o_auth_redirect_uri=None):
        timeout = timeout or self.timeout
        max_retries = max_retries or self.max_retries
        backoff_factor = backoff_factor or self.backoff_factor
        environment = environment or self.environment
        o_auth_client_id = o_auth_client_id or self.o_auth_client_id
        o_auth_redirect_uri = o_auth_redirect_uri or self.o_auth_redirect_uri

        return Configuration(timeout=timeout, max_retries=max_retries,
                             backoff_factor=backoff_factor,
                             environment=environment,
                             o_auth_client_id=o_auth_client_id,
                             o_auth_redirect_uri=o_auth_redirect_uri)

    def create_http_client(self):
        return RequestsClient(timeout=self.timeout,
                              max_retries=self.max_retries,
                              backoff_factor=self.backoff_factor)

    # All the environments the SDK can run in
    environments = {
        Environment.PRODUCTION: {
            Server.DEFAULT: 'http://markdown-notes-app.herokuapp.com',
            Server.AUTH: 'http://markdown-notes-app.herokuapp.com/oauth'
        }
    }

    def get_base_uri(self, server=Server.DEFAULT):
        """Generates the appropriate base URI for the environment and the
        server.

        Args:
            server (Configuration.Server): The server enum for which the base
            URI is required.

        Returns:
            String: The base URI.

        """
        return self.environments[self.environment][server]
