"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GeneratedJavaClientSourceCode = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const log4js_1 = require("log4js");
const projen_1 = require("projen");
const utils_1 = require("./utils");
const languages_1 = require("../../languages");
const logger = log4js_1.getLogger();
/**
 * Generates the java client using OpenAPI Generator
 */
class GeneratedJavaClientSourceCode extends projen_1.Component {
    constructor(project, options) {
        super(project);
        this.options = options;
    }
    /**
     * @inheritDoc
     */
    synthesize() {
        super.synthesize();
        if (this.options.invokeGenerator) {
            const javaProject = this.project;
            const invokerPackage = `${javaProject.pom.groupId}.${javaProject.name}.client`;
            // Generate the java client
            logger.debug("Generating java client...");
            utils_1.invokeOpenApiGenerator({
                generator: "java",
                specPath: this.options.specPath,
                outputPath: this.project.outdir,
                generatorDirectory: languages_1.ClientLanguage.JAVA,
                additionalProperties: {
                    useSingleRequestParameter: "true",
                    groupId: javaProject.pom.groupId,
                    artifactId: javaProject.pom.artifactId,
                    artifactVersion: javaProject.pom.version,
                    invokerPackage,
                    apiPackage: `${invokerPackage}.api`,
                    modelPackage: `${invokerPackage}.model`,
                    hideGenerationTimestamp: "true",
                    additionalModelTypeAnnotations: [
                        "@lombok.AllArgsConstructor",
                        // Regular lombok builder is not used since an abstract base schema class is also annotated
                        "@lombok.experimental.SuperBuilder",
                    ].join("\\ "),
                },
            });
        }
    }
}
exports.GeneratedJavaClientSourceCode = GeneratedJavaClientSourceCode;
//# sourceMappingURL=data:application/json;base64,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