import { EnvironmentVariablesService as CommonEnvironmentVariablesService } from '@aws-lambda-powertools/commons';
import type { ConfigServiceInterface } from '../types/ConfigServiceInterface.js';
/**
 * Class EnvironmentVariablesService
 *
 * This class is used to return environment variables that are available in the runtime of
 * the current Lambda invocation.
 */
declare class EnvironmentVariablesService extends CommonEnvironmentVariablesService implements ConfigServiceInterface {
    private namespaceVariable;
    private readonly disabledVariable;
    /**
     * Get the value of the `POWERTOOLS_METRICS_NAMESPACE` environment variable.
     */
    getNamespace(): string;
    /**
     * Get the value of the `POWERTOOLS_METRICS_DISABLED` or `POWERTOOLS_DEV` environment variables.
     *
     * The `POWERTOOLS_METRICS_DISABLED` environment variable takes precedence over `POWERTOOLS_DEV`.
     */
    getMetricsDisabled(): boolean;
}
export { EnvironmentVariablesService };
//# sourceMappingURL=EnvironmentVariablesService.d.ts.map