type Anything = any[];
/**
 * Interface for a generic logger object.
 *
 * This interface is used to define the shape of a logger object that can be passed to a Powertools for AWS utility.
 *
 * It can be an instance of Logger from Powertools for AWS, or any other logger that implements the same methods.
 */
export interface GenericLogger {
    trace?: (...content: Anything) => void;
    debug: (...content: Anything) => void;
    info: (...content: Anything) => void;
    warn: (...content: Anything) => void;
    error: (...content: Anything) => void;
}
export {};
//# sourceMappingURL=GenericLogger.d.ts.map