"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IDEMPOTENCY_KEY = exports.LOGGER_KEY = exports.METRICS_KEY = exports.TRACER_KEY = exports.PREFIX = void 0;
/**
 * These constants are used to store cleanup functions in Middy's `request.internal` object.
 * They are used by the `cleanupPowertools` function to check if any cleanup function
 * is present and execute it.
 */
const PREFIX = 'powertools-for-aws';
exports.PREFIX = PREFIX;
/**
 * Key to store the tracer instance in the `request.internal` object.
 *
 * @see {@link cleanupMiddlewares}
 */
const TRACER_KEY = `${PREFIX}.tracer`;
exports.TRACER_KEY = TRACER_KEY;
/**
 * Key to store the metrics instance in the `request.internal` object.
 *
 * @see {@link cleanupMiddlewares}
 */
const METRICS_KEY = `${PREFIX}.metrics`;
exports.METRICS_KEY = METRICS_KEY;
/**
 * Key to store the logger instance in the `request.internal` object.
 *
 * @see {@link cleanupMiddlewares}
 */
const LOGGER_KEY = `${PREFIX}.logger`;
exports.LOGGER_KEY = LOGGER_KEY;
/**
 * Key to store the idempotency instance in the `request.internal` object.
 *
 * @see {@link cleanupMiddlewares}
 */
const IDEMPOTENCY_KEY = `${PREFIX}.idempotency`;
exports.IDEMPOTENCY_KEY = IDEMPOTENCY_KEY;
