from typing_extensions import Annotated, Any, Dict, List, TypedDict

from patchwork.common.utils.step_typing import StepTypeConfig
from patchwork.steps.CallLLM.CallLLM import TOKEN_URL


class __SimplifiedLLMOnceInputsRequired(TypedDict):
    # PreparePromptInputs
    prompt_user: Annotated[str, StepTypeConfig(is_config=True)]
    prompt_value: Dict[str, Any]


class SimplifiedLLMOnceInputs(__SimplifiedLLMOnceInputsRequired, total=False):
    prompt_system: Annotated[str, StepTypeConfig(is_config=True)]
    # CallLLMInputs
    model: Annotated[str, StepTypeConfig(is_config=True)]
    openai_api_key: Annotated[
        str, StepTypeConfig(is_config=True, or_op=["patched_api_key", "google_api_key", "anthropic_api_key"])
    ]
    anthropic_api_key: Annotated[
        str, StepTypeConfig(is_config=True, or_op=["patched_api_key", "google_api_key", "openai_api_key"])
    ]
    patched_api_key: Annotated[
        str,
        StepTypeConfig(
            is_config=True,
            or_op=["openai_api_key", "google_api_key", "anthropic_api_key"],
            msg=f"""\
Model API key not found.
Please login at: "{TOKEN_URL}"
Please go to the Integration's tab and generate an API key.
Please copy the access token that is generated, and add `--patched_api_key=<token>` to the command line.

If you are using a OpenAI API Key, please set `--openai_api_key=<token>`.""",
        ),
    ]
    google_api_key: Annotated[
        str, StepTypeConfig(is_config=True, or_op=["patched_api_key", "openai_api_key", "anthropic_api_key"])
    ]
    json: Annotated[bool, StepTypeConfig(is_config=True)]
    # ExtractModelResponseInputs
    response_partitions: Annotated[Dict[str, List[str]], StepTypeConfig(is_config=True)]


class SimplifiedLLMOnceOutputs(TypedDict):
    # PreparePromptOutputs
    prompt: Dict
    # CallLLMOutputs
    openai_response: str
    # ExtractModelResponseOutputs
    extracted_response: Dict[str, str]
