"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SmithyModelProject = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const projen_1 = require("projen");
/**
 * A project which contains a hello-world Smithy model
 */
class SmithyModelProject extends projen_1.Project {
    constructor(options) {
        super(options);
        // HACK: remove all components but the ones we are registering - removes .gitignore, tasks, etc since these are
        // unused and a distraction for end-users!
        // @ts-ignore
        this._components = [];
        new projen_1.SampleFile(this, "main.smithy", {
            contents: `$version: "2"
namespace ${options.serviceNamespace}

use aws.protocols#restJson1

@title("A Sample Hello World API")

/// A sample smithy api
@restJson1
service ${options.serviceName} {
    version: "1.0"
    operations: [SayHello]
}

@readonly
@http(method: "GET", uri: "/hello")
operation SayHello {
    input: SayHelloInput
    output: SayHelloOutput
    errors: [ApiError]
}

string Name
string Message

@input
structure SayHelloInput {
    @httpQuery("name")
    @required
    name: Name
}

@output
structure SayHelloOutput {
    @required
    message: Message
}

@error("client")
structure ApiError {
    @required
    errorMessage: Message
}
`,
        });
    }
}
exports.SmithyModelProject = SmithyModelProject;
//# sourceMappingURL=data:application/json;base64,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