"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DocsProject = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const log4js_1 = require("log4js");
const projen_1 = require("projen");
const generated_html_redoc_docs_1 = require("./components/docs/generated-html-redoc-docs");
const generated_html2_docs_1 = require("./components/docs/generated-html2-docs");
const generated_markdown_docs_1 = require("./components/docs/generated-markdown-docs");
const generated_plantuml_docs_1 = require("./components/docs/generated-plantuml-docs");
const languages_1 = require("../languages");
const logger = log4js_1.getLogger();
/**
 * Project containing generated OpenApi docs
 */
class DocsProject extends projen_1.Project {
    constructor(options) {
        super(options);
        // HACK: remove all components but the ones we are registering - removes .gitignore, tasks, etc since these are
        // unused and a distraction for end-users!
        // @ts-ignore
        this._components = [];
        // Generate docs in all specified formats
        options.formatConfigs.forEach((formatConfig) => {
            logger.trace(`${formatConfig.documentationFormat} :: generate = ${formatConfig.generate}`);
            if (formatConfig.generate) {
                this.generateDocs(formatConfig.documentationFormat, options.specPath);
            }
        });
    }
    /**
     * Generates the docs in the given format
     */
    generateDocs(format, specPath) {
        switch (format) {
            case languages_1.DocumentationFormat.HTML2:
                return new generated_html2_docs_1.GeneratedHtml2Docs(this, { specPath });
            case languages_1.DocumentationFormat.MARKDOWN:
                return new generated_markdown_docs_1.GeneratedMarkdownDocs(this, { specPath });
            case languages_1.DocumentationFormat.PLANTUML:
                return new generated_plantuml_docs_1.GeneratedPlantUmlDocs(this, { specPath });
            case languages_1.DocumentationFormat.HTML_REDOC:
                return new generated_html_redoc_docs_1.GeneratedHtmlRedocDocs(this, { specPath });
            default:
                throw new Error(`Unsupported documentation format ${format}`);
        }
    }
}
exports.DocsProject = DocsProject;
//# sourceMappingURL=data:application/json;base64,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