import { Component } from "projen";
import { JavaProject } from "projen/lib/java";
/**
 * Configuration for the GeneratedJavaClient component
 */
export interface GeneratedJavaClientSourceCodeOptions {
    /**
     * Absolute path to the OpenAPI specification (spec.yaml)
     */
    readonly specPath: string;
    /**
     * Control if generator needs to be invoked
     */
    readonly invokeGenerator: boolean;
}
/**
 * Generates the java client using OpenAPI Generator
 */
export declare class GeneratedJavaClientSourceCode extends Component {
    private options;
    constructor(project: JavaProject, options: GeneratedJavaClientSourceCodeOptions);
    /**
     * @inheritDoc
     */
    synthesize(): void;
}
