"""
    Accounts & Users Service - Public API

    IN PROGRESS->This is the guide to use the different endpoints to manage the clusters.  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from swx_sdk.api_client import ApiClient, Endpoint as _Endpoint
from swx_sdk.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from swx_sdk.model.token_response import TokenResponse


class OAuth2Api(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __get_oauth2_auth(
            self,
            client_id,
            response_type,
            response_mode,
            redirect_uri,
            state,
            scope,
            code_challenge_method,
            code_challenge,
            **kwargs
        ):
            """OAuth 2.0 Authorize Endpoint  # noqa: E501

            To learn more about this flow please refer to the specification: [RFC-6749](https://tools.ietf.org/html/rfc6749)   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_oauth2_auth(client_id, response_type, response_mode, redirect_uri, state, scope, code_challenge_method, code_challenge, async_req=True)
            >>> result = thread.get()

            Args:
                client_id (str): Every client (**Website (MVC)**, **Website (SPA)**, **Mobile App**, **Client (Service)**...) is identified by a client ID. <br/> Unlike a client secret, the client ID is a public value that does not have to be protected. 
                response_type (str): Expected response type: - `code` - `token` - `id_token` - ***hybrid*** (The follow keys are admitted):   - `code` + `token`   - `code` + `token` + `id_token`   - `code` + `id_token` 
                response_mode (str): Expected response mode (`query`, `form_post`, `fragment`)
                redirect_uri (str): It tells the issuer where to redirect the browser back to when the flow is done.
                state (str): The `state` is an value that is carried through the whole flow and returned to the client.<br/> This is used to prevent [CSRF attacks](https://www.owasp.org/index.php/Cross-Site_Request_Forgery_%28CSRF%29).
                scope (str): Clients can request **additional information** or **'permissions'** via `scopes`.<br/> Additionally, ORY Hydra has pre-defined OAuth 2.0 Scope values: - `offline_access`: Include this scope if you wish to receive a refresh token. - `offline`: alias for `offline_access`. - `openid`: Include this scope if you wish to perform an OpenID Connect request. 
                code_challenge_method (str): For [**PKCE**](https://tools.ietf.org/html/rfc7636) is **required**!!, can be `plain` (raw [***code_verifier***](https://tools.ietf.org/html/rfc7636#page-8) **NOT** recommended) or `S256` (***BASE64URL-ENCODE(SHA256(ASCII(code_verifier)))***).
                code_challenge (str): For [**PKCE**](https://tools.ietf.org/html/rfc7636) is **required**!!, a challenge derived from the [***code_verifier***](https://tools.ietf.org/html/rfc7636#page-8) to be verified against later:   <br/>   - `code_verifier`: ***High-entropy cryptographic random STRING using the unreserved characters [A-Z] / [a-z] / [0-9] / \"-\" / \".\" / \"_\" / \"~\",     <br/>with a minimum length of 43 characters and a maximum length of 128 characters.*** 

            Keyword Args:
                nonce (str): A **nonce** (or number used once) is a random value that is used to prevent [replay attacks](https://en.wikipedia.org/wiki/Replay_attack).. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['client_id'] = \
                client_id
            kwargs['response_type'] = \
                response_type
            kwargs['response_mode'] = \
                response_mode
            kwargs['redirect_uri'] = \
                redirect_uri
            kwargs['state'] = \
                state
            kwargs['scope'] = \
                scope
            kwargs['code_challenge_method'] = \
                code_challenge_method
            kwargs['code_challenge'] = \
                code_challenge
            return self.call_with_http_info(**kwargs)

        self.get_oauth2_auth = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/oauth2/auth',
                'operation_id': 'get_oauth2_auth',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'client_id',
                    'response_type',
                    'response_mode',
                    'redirect_uri',
                    'state',
                    'scope',
                    'code_challenge_method',
                    'code_challenge',
                    'nonce',
                ],
                'required': [
                    'client_id',
                    'response_type',
                    'response_mode',
                    'redirect_uri',
                    'state',
                    'scope',
                    'code_challenge_method',
                    'code_challenge',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'client_id':
                        (str,),
                    'response_type':
                        (str,),
                    'response_mode':
                        (str,),
                    'redirect_uri':
                        (str,),
                    'state':
                        (str,),
                    'scope':
                        (str,),
                    'code_challenge_method':
                        (str,),
                    'code_challenge':
                        (str,),
                    'nonce':
                        (str,),
                },
                'attribute_map': {
                    'client_id': 'client_id',
                    'response_type': 'response_type',
                    'response_mode': 'response_mode',
                    'redirect_uri': 'redirect_uri',
                    'state': 'state',
                    'scope': 'scope',
                    'code_challenge_method': 'code_challenge_method',
                    'code_challenge': 'code_challenge',
                    'nonce': 'nonce',
                },
                'location_map': {
                    'client_id': 'query',
                    'response_type': 'query',
                    'response_mode': 'query',
                    'redirect_uri': 'query',
                    'state': 'query',
                    'scope': 'query',
                    'code_challenge_method': 'query',
                    'code_challenge': 'query',
                    'nonce': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_oauth2_auth
        )

        def __get_oauth2_token(
            self,
            client_id,
            client_secret,
            code,
            code_verifier,
            grant_type,
            redirect_uri,
            refresh_token,
            scope,
            **kwargs
        ):
            """OAuth 2.0 Token Endpoint  # noqa: E501

            The client makes a request to the token endpoint by sending the following parameters using the `application/x-www-form-urlencoded` HTTP request entity-body.<br/> To perform this operation, you must be authenticated by means of one of the following methods: `basic`, `oauth2`.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_oauth2_token(client_id, client_secret, code, code_verifier, grant_type, redirect_uri, refresh_token, scope, async_req=True)
            >>> result = thread.get()

            Args:
                client_id (str): Need for **Authorization Code**, **PKCE** and **Client Credentials**!!<br/> Every client (**Website (MVC)**, **Website (SPA)**, **Mobile App**, **Client (Service)**...) is identified by a client ID.<br/> Unlike a client secret, the client ID is a public value that does not have to be protected. 
                client_secret (str): Need for **Client Credentials**!!<br/> The `client_secret` is a secret known only to the application and the authorization server. It must be sufficiently random to not be guessable. 
                code (str): Need for **Authorization Code** and **PKCE**!!<br/> It is the authorization code generated by the authorization server with **\\\"Authorization Code\\\"** & **\\\"PKCE\\\"** flows.<br/> This code is relatively short-lived depending on the OAuth service config. 
                code_verifier (str): Need for **Authorization Code** and **PKCE**!!<br/> `code_verifier` = ***high-entropy cryptographic random STRING using the                     unreserved characters [A-Z] / [a-z] / [0-9] / \\\"-\\\" / \\\".\\\" / \\\"_\\\" / \\\"~\\\", with a minimum length                     of 43 characters and a maximum length of 128 characters.*** 
                grant_type (str): Grants Types according to Flows: - For **Authorization Code** and **PKCE** is required `authorization_code`.<br/> - For **Client Credentials** is required `client_credentials`.<br/> - For **Refresh Grant** is required `refresh_token`. 
                redirect_uri (str): Need for **Authorization Code** and **PKCE**!!<br/> Tells the authorization server where to send the user back to after they approve the request. ***If the client does not have it enabled, an error is returned.*** 
                refresh_token (str): Need for **Refresh Grant**!!<br/> The presence of the refresh token means that the access token will expire and you’ll be able to get a new one without the user’s interaction.<br/> To use the refresh token, make a POST request to the service’s token endpoint with `grant_type=refresh_token`, and include the refresh token as well as the client credentials. 
                scope (str): Need for **Authorization Code**, **PKCE** and **Client Credentials**!!<br/> Scope is a way to limit an app’s access to a user’s data. Rather than granting complete access to a user’s space, it is often useful to give apps a way to request a more limited scope of what they are allowed to do on behalf of a user.<br/> Additionally, ORY Hydra has pre-defined OAuth 2.0 Scope values: - `offline_access`: Include this scope if you wish to receive a refresh token. - `offline`: alias for `offline_access`. - `openid`: Include this scope if you wish to perform an OpenID Connect request. 

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                TokenResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['client_id'] = \
                client_id
            kwargs['client_secret'] = \
                client_secret
            kwargs['code'] = \
                code
            kwargs['code_verifier'] = \
                code_verifier
            kwargs['grant_type'] = \
                grant_type
            kwargs['redirect_uri'] = \
                redirect_uri
            kwargs['refresh_token'] = \
                refresh_token
            kwargs['scope'] = \
                scope
            return self.call_with_http_info(**kwargs)

        self.get_oauth2_token = _Endpoint(
            settings={
                'response_type': (TokenResponse,),
                'auth': [],
                'endpoint_path': '/oauth2/token',
                'operation_id': 'get_oauth2_token',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'client_id',
                    'client_secret',
                    'code',
                    'code_verifier',
                    'grant_type',
                    'redirect_uri',
                    'refresh_token',
                    'scope',
                ],
                'required': [
                    'client_id',
                    'client_secret',
                    'code',
                    'code_verifier',
                    'grant_type',
                    'redirect_uri',
                    'refresh_token',
                    'scope',
                ],
                'nullable': [
                ],
                'enum': [
                    'grant_type',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('grant_type',): {

                        "AUTHORIZATION_CODE": "authorization_code",
                        "CLIENT_CREDENTIALS": "client_credentials",
                        "REFRESH_TOKEN": "refresh_token"
                    },
                },
                'openapi_types': {
                    'client_id':
                        (str,),
                    'client_secret':
                        (str,),
                    'code':
                        (str,),
                    'code_verifier':
                        (str,),
                    'grant_type':
                        (str,),
                    'redirect_uri':
                        (str,),
                    'refresh_token':
                        (str,),
                    'scope':
                        (str,),
                },
                'attribute_map': {
                    'client_id': 'client_id',
                    'client_secret': 'client_secret',
                    'code': 'code',
                    'code_verifier': 'code_verifier',
                    'grant_type': 'grant_type',
                    'redirect_uri': 'redirect_uri',
                    'refresh_token': 'refresh_token',
                    'scope': 'scope',
                },
                'location_map': {
                    'client_id': 'form',
                    'client_secret': 'form',
                    'code': 'form',
                    'code_verifier': 'form',
                    'grant_type': 'form',
                    'redirect_uri': 'form',
                    'refresh_token': 'form',
                    'scope': 'form',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/x-www-form-urlencoded'
                ]
            },
            api_client=api_client,
            callable=__get_oauth2_token
        )

        def __post_oauth2_revoke(
            self,
            client_id,
            client_secret,
            token,
            **kwargs
        ):
            """Revoke a token (Access or Refresh)  # noqa: E501

            Revoking a token (both `access` and `refresh`) means that the tokens will be ***invalid***.<br/> A revoked access token can no longer be used to make access requests, and a revoked refresh token can no longer be used to refresh an access token.<br/> Revoking a refresh token also invalidates the access token that was created with it.<br/> **A token may only be revoked by the client the token was generated for!!**   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.post_oauth2_revoke(client_id, client_secret, token, async_req=True)
            >>> result = thread.get()

            Args:
                client_id (str): The client ID for the token to revoke. 
                client_secret (str): The client secret for the client ID 
                token (str): Token to revoke and invalidate. 

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['client_id'] = \
                client_id
            kwargs['client_secret'] = \
                client_secret
            kwargs['token'] = \
                token
            return self.call_with_http_info(**kwargs)

        self.post_oauth2_revoke = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/oauth2/revoke',
                'operation_id': 'post_oauth2_revoke',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'client_id',
                    'client_secret',
                    'token',
                ],
                'required': [
                    'client_id',
                    'client_secret',
                    'token',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'client_id':
                        (str,),
                    'client_secret':
                        (str,),
                    'token':
                        (str,),
                },
                'attribute_map': {
                    'client_id': 'client_id',
                    'client_secret': 'client_secret',
                    'token': 'token',
                },
                'location_map': {
                    'client_id': 'form',
                    'client_secret': 'form',
                    'token': 'form',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/x-www-form-urlencoded'
                ]
            },
            api_client=api_client,
            callable=__post_oauth2_revoke
        )
