# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['gist']

package_data = \
{'': ['*']}

install_requires = \
['python-gnupg>=0.4.7,<0.5.0', 'requests>=2.25.1,<3.0.0']

entry_points = \
{'console_scripts': ['gist = gist.client:main']}

setup_kwargs = {
    'name': 'python-gist',
    'version': '0.10.4',
    'description': 'Manage github gists',
    'long_description': '==================================================\nGIST\n==================================================\n\n\'gist\' is a command line interface for working with github gists. It provides\nseveral methods for inspecting a users gists, and the ability to easily create\nthem.\n\n.. image:: https://github.com/jdowner/gist/workflows/gist%20continuous%20integration/badge.svg\n    :target: https://github.com/jdowner/gist\n\n\nRequirements\n--------------------------------------------------\nPython 3.6, 3.7, 3.8, or 3.9 is required.\n\n\nInstallation\n--------------------------------------------------\n\nThe preferred way to install \'gist\' is from pypi.org using pip (or pip3),\n\n::\n\n  $ pip install python-gist\n\nAlternatively, you can clone the repository and install it manually,\n\n::\n\n  $ pip install .\n\nThe \'share\' directory contains a set of shell scripts that provide tab\ncompletion and fuzzy search for gist. There are 3 different scripts for\ntab-completion in bash: gist.bash, gist-fzf.bash, and gist-fzsl.bash. The first\nprovides simple tab completion and can be enable by adding the following to\nyour .bashrc file,\n\n::\n\n  source /usr/local/share/gist/gist.bash\n\nThe other scripts, gist-fzf.bash and fist-fzsl.bash, provide fuzzy matching of\ngists using an ncurses interface (NB: these scripts require\n`fzf <https://github.com/junegunn/fzf>`_ and `fzsl <https://github.com/jsbronder/fzsl>`_,\nrespectively).\n\nThe gist.fish script provides tab completion for the fish shell, and should be\ncopied to ~/.config/fish/completions.\n\nThe gist.zsh script provides tab completion for the zsh shell, and should be\ncopied to ~/.zsh as _gist. If not already in your ~/.zshrc file, you should add\n\n::\n\n  fpath=(${HOME}/.zsh $fpath)\n\nTo check that \'gist\' is operating correctly, you can run the unit tests with,\n\n::\n\n  $ make test\n\nNote that running the unit tests requires `poetry <https://python-poetry.org/>`_\nto be available on your PATH.\n\n\nGetting started\n--------------------------------------------------\n\n\'gist\' requires a personal access token for authentication. To create a token,\ngo to https://github.com/settings/tokens. The token needs to then be added\nto a \'gist\' configuration file that should have the form,\n\n::\n\n  [gist]\n  token: <enter token here>\n  editor: <path to editor>\n\nThe editor field is optional. If the default editor is specified through some\nother mechanism \'gist\' will try to infer it. Otherwise, you can use the config\nfile to ensure that \'gist\' uses the editor you want it to use.\n\nIf the token string begins with ``!`` the text following is interpreted as a\nshell command which, when executed, prints the token to stdout. For example::\n\n  [gist]\n  token: !gpg --decrypt github-token.gpg\n\nThe configuration file must be in one of the following,\n\n::\n\n  ${XDG_DATA_HOME}/gist\n  ${HOME}/.config/gist\n  ${HOME}/.gist\n\nIf more than one of these files exist, this is also the order of preference,\ni.e. a configuration that is found in the ``${XDG_DATA_HOME}`` directory will be\ntaken in preference to ``${HOME}/.config/gist``.\n\nAlso, \'gist\' assumes that you have set up your github account to use SSH keys so\nthat you can access your repositories without needing to provide a password.\nHere__ is a link on setting up SSH keys with github.\n\n__ https://help.github.com/articles/connecting-to-github-with-ssh/\n\n\nUsage\n--------------------------------------------------\n\n\'gist\' is intended to make it easy to manage and use github gists from the\ncommand line. There are several commands available:\n\n::\n\n  gist create      - creates a new gist\n  gist edit        - edit the files in your gist\n  gist description - updates the description of your gist\n  gist list        - prints a list of your gists\n  gist clone       - clones a gist\n  gist delete      - deletes a gist or list of gists from github\n  gist files       - prints a list of the files in a gist\n  gist archive     - downloads a gist and creates a tarball\n  gist content     - prints the content of the gist to stdout\n  gist info        - prints detailed information about a gist\n  gist version     - prints the current version\n  gist help        - prints the help documentation\n\n\n**gist create**\n\nMost of the \'gist\' commands are pretty simple and limited in what they can do.\n\'gist create\' is a little different and offers more flexibility in how the user\ncan create the gist.\n\nIf you have a set of existing files that you want to turn into a gist,\n\n::\n\n  $ gist create "divide et impera" foo.txt bar.txt\n\nwhere the quoted string is the description of the gist. Or, you may find it\nuseful to create a gist from content on your clipboard (say, using xclip),\n\n::\n\n  $ xclip -o | gist create "ipsa scientia potestas est"\n\nAnother option is to pipe the input into \'gist create\' and have it automatically\nput the content on github,\n\n::\n\n  $ echo $(cat) | gist create "credo quia absurdum est"\n\nFinally, you can just call,\n\n::\n\n  $ gist create "a posse ad esse"\n\nwhich will launch your default editor (defined by the EDITOR environment\nvariable).\n\nIn addition to creating gists using the above methods, it is also possible to\nencrypt a gist if you have gnupg installed. Any of the above methods can be used\nto create encrypted gists by simply adding the --encrypt flag to invocation.\nFor example,\n\n::\n\n  $ gist create "arcana imperii" --encrypt\n\nwill open the editor allowing you to create the content of the gist, which is\nthen encrypted and added to github. See the Configuration section for\ninformation on how to enable gnupg support.\n\n\n**gist edit**\n\nYou can edit your gists directly with the \'edit\' command. This command will\nclone the gist to a temporary directory and open up the default editor (defined\nby the EDITOR environment variable) to edit the files in the gist. When the\neditor is exited the user is prompted to commit the changes, which are then\npushed back to the remote.\n\n**gist description**\n\nYou can update the description of your gist with the \'description\' command.\nYou need to supply the gist ID and the new description. For example -\n\n::\n\n  $ gist description e1f5e95a1705cbfde144 "This is a new description"\n\n\n**gist list**\n\nReturns a list of your gists. The gists are returned as,\n\n::\n\n  2b1823252e8433ef8682 - mathematical divagations\n  a485ee9ddf6828d697be - notes on defenestration\n  589071c7a02b1823252e + abecedarian pericombobulations\n\nThe first column is the gists unique identifier; The second column indicates\nwhether the gist is public (\'+\') or private (\'-\'); The third column is the\ndescription in the gist, which may be empty.\n\n\n**gist clone**\n\nClones a gist to the current directory. This command will clone any gist based\non its unique identifier (i.e. not just the users) to the current directory.\n\n\n**gist delete**\n\nDeletes the specified gists from github.\n\n\n**gist files**\n\nReturns a list of the files in the specified gist.\n\n\n**gist archive**\n\nDownloads the specified gist to a temporary directory and adds it to a tarball,\nwhich is then moved to the current directory.\n\n\n**gist content**\n\nWrites the content of each file in the specified gist to the terminal, e.g.\n\n::\n\n  $ gist content c971fca7997aed65ddc9\n  foo.txt:\n  this is foo\n\n\n  bar.txt:\n  this is bar\n\n\nFor each file in the gist the first line is the name of the file followed by a\ncolon, and then the content of that file is written to the terminal.\n\nIf a filename is given, only the content of the specified filename will be\nprinted.\n\n::\n\n  $ gist content de42344a4ecb6250d6cea00d9da6d83a file1\n  content of file 1\n\n\nIf the contents of the gist is encrypted, it can be viewed in its decrypted\nform by adding the --decrypt flag, e.g.\n\n::\n\n  $ gist content --decrypt 8fe557fb3771aa74edfd\n  foo.txt.asc (decrypted):\n  this is a secret\n\n\nSee the Configuration section for information on how to enable gnupg support.\n\n\n**gist info**\n\nThis command provides a complete dump of the information about the gist as a\nJSON object. It is mostly useful for debugging.\n\n\n**gist version**\n\nSimply prints the current version.\n\n\n**gist help**\n\nPrints out the help documentation.\n\n\nConfiguration\n--------------------------------------------------\n\nThere are several parameters that can be added to a configuration file to\ndetermine the behavior of gist. The configuration file itself is expected to\nbe one of the following paths,\n\n::\n\n  ${HOME}/.gist\n  ${HOME}/.config/gist\n  ${XDG_DATA_HOME}/gist\n\nThe configuration file follows the .ini style. The following is an example,\n\n::\n\n  [gist]\n  token: dde7b84d1e0edf7454ab354934b6ab36b01bf00f\n  editor: /usr/bin/vim\n  gnupg-homedir: /home/user/.gnupg\n  gnupg-fingerprint: 179F9650D9FC1BFE391620B4B13A7829D8DE8623\n  delete-tempfiles: False\n\nThe only essential field in the configuration file is the token. This is the\nauthentication token from github that grants gist permission to access your\ngists. The editor is the editor to use if the EDITOR environment is not set or\nyou wish to use a different editor. \'gnupg-homedir\' is the directory where your\ngnupg data are stored, and \'gnupg-fingerprint\' is the fingerprint of the key to\nuse to encrypt data in your gists. Both gnupg fields are required to support\nencryption/decryption.\n\nThe \'delete-tempfiles\' option is used when gists are created from an editor.\nThe editor writes its contents to a temporary file, which is deleted by\ndefault. The default behavior can be overridden by using the \'delete-tempfiles\'\nflag.\n\n\nContributors\n--------------------------------------------------\n\nThank you to the following people for contributing to \'gist\'!\n\n* Eren Inan Canpolat (https://github.com/canpolat)\n* Kaan Genç (https://github.com/SeriousBug)\n* Eric James Michael Ritz (https://github.com/ejmr)\n* Karan Parikh (https://github.com/karanparikh)\n* Konstantin Krastev (https://github.com/grizmin)\n* Brandon Davidson (https://github.com/brandond)\n* jq170727 (https://github.com/jq170727)\n* jsbronder (https://github.com/jsbronder)\n* hugsy (https://github.com/hugsy)\n* Kenneth Benzie (https://github.com/kbenzie)\n* rtfmoz2 (https://github.com/rtfmoz2)\n',
    'author': 'Joshua Downer',
    'author_email': 'joshua.downer@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/jdowner/gist',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
