# OracleDBLibrary
OracleDBLibrary is a database testing library for Robot Framework that utilizes the cx_Oracle tool internally.
The project is hosted on GitHub and downloads can be found from PyPI.

[![License](https://img.shields.io/badge/License-Apache_2.0-blue.svg)](https://opensource.org/licenses/Apache-2.0)

## Installation

The recommended installation method is using pip

    pip install --upgrade robotframework-oracledb-library

## Usage
To use OracleDBLibrary in Robot Framework tests, the library needs to first be imported using the ``Library`` setting as any other library.

When using Robot Framework, it is generally recommended writing as easy-to-understand tests as possible. 
The keywords provided by OracleDBLibrary is pretty low level, though, and often require implementation-specific arguments like data source name (DSN) to be passed as arguments. 
It is thus typically a good idea to write tests using Robot Framework's higher-level keywords that utilize OracleDBLibrary keywords internally. 
This is illustrated by the following example where OracleDBLibrary keywords like ``ORACLE MAKEDSN``, ``ORACLE CONNECT``, ``ORACLE CONNECTION PING`` and ``ORACLE CONNECTION CLOSE`` are primarily used by higher-level keywords like ``CONNECT TO ORACLE DATABASE WITH SID``.

    *** Settings ***
    Library           OracleDBLibrary

    *** Variables ***
    ${HOST}      localhost
    ${PORT}      1521
    ${SID}       ORCLCDB
    ${USER}      SYS
    ${PASSWORD}  Oradoc_db1
    ${MODE}      SYSDBA

    *** Test Cases ***
    CONNECT TO ORACLE DATABASE AND INSERT DATA
        CONNECT TO ORACLE DATABASE WITH SID
        INSERT DATA INTO ORACLE DATABASE
        DROP ORACLE DATABASE TABLE
        CLOSE ORACLE DATABASE CONNECTION AND CURSOR

    *** Keywords ***
    CONNECT TO ORACLE DATABASE WITH SID
        ${DSN}  ORACLE MAKEDSN  host=${HOST}  port=${PORT}  sid=${SID}
        ORACLE CONNECT  user=${USER}  password=${PASSWORD}  dsn=${DSN}  mode=${MODE}
        ${CONNECTION STATUS}  ORACLE CONNECTION PING
        SHOULD BE EQUAL  ${CONNECTION STATUS}  ${NONE}
    
    INSERT DATA INTO ORACLE DATABASE
        ORACLE CONNECTION CURSOR
        ${FIRST TABLE ROW}   EVALUATE  (1432, 'Ahmet', 'Yalcinkaya')
        ${SECOND TABLE ROW}  EVALUATE  (1453, 'Abdullah', 'Deliogullari')
        ${THIRD TABLE ROW}   EVALUATE  (1481, 'Erim', 'Cerrahoglu')
        ORACLE CURSOR EXECUTE  CREATE TABLE persons (person_id NUMBER GENERATED BY DEFAULT AS IDENTITY, first_name VARCHAR2(50) NOT NULL, last_name VARCHAR2(50) NOT NULL, PRIMARY KEY(person_id))
        ORACLE CURSOR EXECUTE  INSERT INTO persons (person_id, first_name, last_name) VALUES ${FIRST TABLE ROW}
        ORACLE CURSOR EXECUTE  INSERT INTO persons (person_id, first_name, last_name) VALUES ${SECOND TABLE ROW}
        ORACLE CURSOR EXECUTE  INSERT INTO persons (person_id, first_name, last_name) VALUES ${THIRD TABLE ROW}
        ORACLE CONNECTION COMMIT

    DROP ORACLE DATABASE TABLE
        ORACLE CURSOR EXECUTE  DROP TABLE persons
        ORACLE CONNECTION COMMIT

    CLOSE ORACLE DATABASE CONNECTION AND CURSOR
        ORACLE CURSOR CLOSE
        ORACLE CONNECTION CLOSE

## License

Robot Framework is open source software provided under the `Apache License 2.0`