"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DynamoDBStreamsToLambdaToElasticSearchAndKibana = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_dynamodbstreams_lambda_1 = require("@aws-solutions-constructs/aws-dynamodbstreams-lambda");
const aws_lambda_elasticsearch_kibana_1 = require("@aws-solutions-constructs/aws-lambda-elasticsearch-kibana");
// Note: To ensure CDKv2 compatibility, keep the import statement for Construct separate
const constructs_1 = require("constructs");
const defaults = require("@aws-solutions-constructs/core");
class DynamoDBStreamsToLambdaToElasticSearchAndKibana extends constructs_1.Construct {
    /**
     * @summary Constructs a new instance of the LambdaToDynamoDB class.
     * @param {cdk.App} scope - represents the scope for all the resources.
     * @param {string} id - this is a a scope-unique id.
     * @param {DynamoDBStreamsToLambdaToElasticSearchAndKibanaProps} props - user provided props for the construct
     * @access public
     */
    constructor(scope, id, props) {
        super(scope, id);
        defaults.CheckProps(props);
        const lambdaToElasticSearchProps = {
            existingLambdaObj: props.existingLambdaObj,
            lambdaFunctionProps: props.lambdaFunctionProps,
            domainName: props.domainName,
            esDomainProps: props.esDomainProps,
            cognitoDomainName: props.cognitoDomainName,
            createCloudWatchAlarms: props.createCloudWatchAlarms,
            existingVpc: props.existingVpc,
            vpcProps: props.vpcProps,
            deployVpc: props.deployVpc
        };
        this.lambdaToElasticSearchAndKibana = new aws_lambda_elasticsearch_kibana_1.LambdaToElasticSearchAndKibana(this, 'LambdaToElasticSearch', lambdaToElasticSearchProps);
        this.lambdaFunction = this.lambdaToElasticSearchAndKibana.lambdaFunction;
        const dbstreamsToLambdaProps = {
            existingLambdaObj: this.lambdaFunction,
            dynamoEventSourceProps: props.dynamoEventSourceProps,
            dynamoTableProps: props.dynamoTableProps,
            existingTableInterface: props.existingTableInterface,
            deploySqsDlqQueue: props.deploySqsDlqQueue,
            sqsDlqQueueProps: props.sqsDlqQueueProps,
        };
        this.dynamoDBStreamsToLambda = new aws_dynamodbstreams_lambda_1.DynamoDBStreamsToLambda(this, 'DynamoDBStreamsToLambda', dbstreamsToLambdaProps);
        this.dynamoTable = this.dynamoDBStreamsToLambda.dynamoTable;
        this.dynamoTableInterface = this.dynamoDBStreamsToLambda.dynamoTableInterface;
        this.userPool = this.lambdaToElasticSearchAndKibana.userPool;
        this.userPoolClient = this.lambdaToElasticSearchAndKibana.userPoolClient;
        this.identityPool = this.lambdaToElasticSearchAndKibana.identityPool;
        this.elasticsearchDomain = this.lambdaToElasticSearchAndKibana.elasticsearchDomain;
        this.elasticsearchRole = this.lambdaToElasticSearchAndKibana.elasticsearchRole;
        this.cloudwatchAlarms = this.lambdaToElasticSearchAndKibana.cloudwatchAlarms;
        this.vpc = this.lambdaToElasticSearchAndKibana.vpc;
    }
}
exports.DynamoDBStreamsToLambdaToElasticSearchAndKibana = DynamoDBStreamsToLambdaToElasticSearchAndKibana;
_a = JSII_RTTI_SYMBOL_1;
DynamoDBStreamsToLambdaToElasticSearchAndKibana[_a] = { fqn: "@aws-solutions-constructs/aws-dynamodbstreams-lambda-elasticsearch-kibana.DynamoDBStreamsToLambdaToElasticSearchAndKibana", version: "2.28.0" };
//# sourceMappingURL=data:application/json;base64,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