from setuptools import setup, find_packages
import codecs
import os

here = os.path.abspath(os.path.dirname(__file__))

with codecs.open(os.path.join(here, "README.md"), encoding="utf-8") as fh:
    long_description = fh.read()


# Setting up
setup(
    name="customselectmenu",
    version="0.0.5",
    author="Felipe Cavichiolli Silvestre",
    author_email="<mail@neuralnine.com>",
    description="Easy creation and customization of selection menus",
    long_description_content_type="text/markdown",
    long_description=long_description,
    packages=find_packages(),
    install_requires=["keyboard"],
    keywords=["python", "menu", "selection", "custom"],
    classifiers=[
        "Development Status :: 1 - Planning",
        "Intended Audience :: Developers",
        "Programming Language :: Python :: 3",
        # "Operating System :: Unix",
        # "Operating System :: MacOS :: MacOS X",
        "Operating System :: Microsoft :: Windows",
        "License :: OSI Approved :: MIT License",
        "Typing :: Typed",
    ],
)
