"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RetrieveLambdaAtEdge = void 0;
const core_1 = require("@aws-cdk/core");
const custom_resources_1 = require("@aws-cdk/custom-resources");
const aws_lambda_1 = require("@aws-cdk/aws-lambda");
class RetrieveLambdaAtEdge extends core_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const cr = new custom_resources_1.AwsCustomResource(this, 'Resource', {
            onUpdate: {
                service: 'SSM',
                action: 'getParameter',
                parameters: {
                    Name: props.parameter.parameterName,
                },
                region: 'us-east-1',
                physicalResourceId: custom_resources_1.PhysicalResourceId.of(Date.now().toString()),
            },
            policy: custom_resources_1.AwsCustomResourcePolicy.fromSdkCalls({
                resources: [props.parameter.parameterArn],
            }),
        });
        this.lambdaFunction = aws_lambda_1.Function.fromFunctionArn(this, 'Function', cr.getResponseField('Parameter.Value'));
    }
}
exports.RetrieveLambdaAtEdge = RetrieveLambdaAtEdge;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicmV0cmlldmUtbGFtYmRhLWF0LWVkZ2UuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi9zcmMvcmV0cmlldmUtbGFtYmRhLWF0LWVkZ2UudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUEsd0NBQTBDO0FBQzFDLGdFQUltQztBQUVuQyxvREFBMEQ7QUFNMUQsTUFBYSxvQkFBcUIsU0FBUSxnQkFBUztJQUdqRCxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFFLEtBQWdDO1FBQ3hFLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFFakIsTUFBTSxFQUFFLEdBQUcsSUFBSSxvQ0FBaUIsQ0FBQyxJQUFJLEVBQUUsVUFBVSxFQUFFO1lBQ2pELFFBQVEsRUFBRTtnQkFDUixPQUFPLEVBQUUsS0FBSztnQkFDZCxNQUFNLEVBQUUsY0FBYztnQkFDdEIsVUFBVSxFQUFFO29CQUNWLElBQUksRUFBRSxLQUFLLENBQUMsU0FBUyxDQUFDLGFBQWE7aUJBQ3BDO2dCQUNELE1BQU0sRUFBRSxXQUFXO2dCQUNuQixrQkFBa0IsRUFBRSxxQ0FBa0IsQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLEdBQUcsRUFBRSxDQUFDLFFBQVEsRUFBRSxDQUFDO2FBQ2pFO1lBQ0QsTUFBTSxFQUFFLDBDQUF1QixDQUFDLFlBQVksQ0FBQztnQkFDM0MsU0FBUyxFQUFFLENBQUMsS0FBSyxDQUFDLFNBQVMsQ0FBQyxZQUFZLENBQUM7YUFDMUMsQ0FBQztTQUNILENBQUMsQ0FBQztRQUVILElBQUksQ0FBQyxjQUFjLEdBQUcscUJBQVEsQ0FBQyxlQUFlLENBQzVDLElBQUksRUFDSixVQUFVLEVBQ1YsRUFBRSxDQUFDLGdCQUFnQixDQUFDLGlCQUFpQixDQUFDLENBQ3ZDLENBQUM7SUFDSixDQUFDO0NBQ0Y7QUEzQkQsb0RBMkJDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnQGF3cy1jZGsvY29yZSc7XG5pbXBvcnQge1xuICBBd3NDdXN0b21SZXNvdXJjZSxcbiAgQXdzQ3VzdG9tUmVzb3VyY2VQb2xpY3ksXG4gIFBoeXNpY2FsUmVzb3VyY2VJZCxcbn0gZnJvbSAnQGF3cy1jZGsvY3VzdG9tLXJlc291cmNlcyc7XG5pbXBvcnQgeyBJU3RyaW5nUGFyYW1ldGVyIH0gZnJvbSAnQGF3cy1jZGsvYXdzLXNzbSc7XG5pbXBvcnQgeyBJRnVuY3Rpb24sIEZ1bmN0aW9uIH0gZnJvbSAnQGF3cy1jZGsvYXdzLWxhbWJkYSc7XG5cbmV4cG9ydCBpbnRlcmZhY2UgUmV0cmlldmVMYW1iZGFBdEVkZ2VQcm9wcyB7XG4gIHJlYWRvbmx5IHBhcmFtZXRlcjogSVN0cmluZ1BhcmFtZXRlcjtcbn1cblxuZXhwb3J0IGNsYXNzIFJldHJpZXZlTGFtYmRhQXRFZGdlIGV4dGVuZHMgQ29uc3RydWN0IHtcbiAgcHVibGljIHJlYWRvbmx5IGxhbWJkYUZ1bmN0aW9uOiBJRnVuY3Rpb247XG5cbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IFJldHJpZXZlTGFtYmRhQXRFZGdlUHJvcHMpIHtcbiAgICBzdXBlcihzY29wZSwgaWQpO1xuXG4gICAgY29uc3QgY3IgPSBuZXcgQXdzQ3VzdG9tUmVzb3VyY2UodGhpcywgJ1Jlc291cmNlJywge1xuICAgICAgb25VcGRhdGU6IHtcbiAgICAgICAgc2VydmljZTogJ1NTTScsXG4gICAgICAgIGFjdGlvbjogJ2dldFBhcmFtZXRlcicsXG4gICAgICAgIHBhcmFtZXRlcnM6IHtcbiAgICAgICAgICBOYW1lOiBwcm9wcy5wYXJhbWV0ZXIucGFyYW1ldGVyTmFtZSxcbiAgICAgICAgfSxcbiAgICAgICAgcmVnaW9uOiAndXMtZWFzdC0xJyxcbiAgICAgICAgcGh5c2ljYWxSZXNvdXJjZUlkOiBQaHlzaWNhbFJlc291cmNlSWQub2YoRGF0ZS5ub3coKS50b1N0cmluZygpKSwgLy8gVXBkYXRlIHBoeXNpY2FsIGlkIHRvIGFsd2F5cyBmZXRjaCB0aGUgbGF0ZXN0IHZlcnNpb25cbiAgICAgIH0sXG4gICAgICBwb2xpY3k6IEF3c0N1c3RvbVJlc291cmNlUG9saWN5LmZyb21TZGtDYWxscyh7XG4gICAgICAgIHJlc291cmNlczogW3Byb3BzLnBhcmFtZXRlci5wYXJhbWV0ZXJBcm5dLFxuICAgICAgfSksXG4gICAgfSk7XG5cbiAgICB0aGlzLmxhbWJkYUZ1bmN0aW9uID0gRnVuY3Rpb24uZnJvbUZ1bmN0aW9uQXJuKFxuICAgICAgdGhpcyxcbiAgICAgICdGdW5jdGlvbicsXG4gICAgICBjci5nZXRSZXNwb25zZUZpZWxkKCdQYXJhbWV0ZXIuVmFsdWUnKSxcbiAgICApO1xuICB9XG59XG4iXX0=