import { Construct } from '@aws-cdk/core';
import { LambdaEdgeEventType } from '@aws-cdk/aws-cloudfront';
import { IVersion } from '@aws-cdk/aws-lambda';
import { CommonEdgeFunctionProps } from './edge-function';
import { ILambdaFunctionAssociation } from './lambda-function-association';
export interface HttpHeadersProps extends CommonEdgeFunctionProps {
    readonly httpHeaders: Record<string, string>;
}
export declare class HttpHeaders extends Construct implements ILambdaFunctionAssociation {
    readonly eventType: LambdaEdgeEventType;
    readonly lambdaFunction: IVersion;
    constructor(scope: Construct, id: string, props: HttpHeadersProps);
}
