/**
 * (experimental) Factory class for DynamoDB key conditions.
 *
 * @experimental
 */
export declare class KeyCondition {
    private readonly cond;
    /**
     * (experimental) Condition k = arg, true if the key attribute k is equal to the Query argument.
     *
     * @experimental
     */
    static eq(keyName: string, arg: string): KeyCondition;
    /**
     * (experimental) Condition k < arg, true if the key attribute k is less than the Query argument.
     *
     * @experimental
     */
    static lt(keyName: string, arg: string): KeyCondition;
    /**
     * (experimental) Condition k <= arg, true if the key attribute k is less than or equal to the Query argument.
     *
     * @experimental
     */
    static le(keyName: string, arg: string): KeyCondition;
    /**
     * (experimental) Condition k > arg, true if the key attribute k is greater than the the Query argument.
     *
     * @experimental
     */
    static gt(keyName: string, arg: string): KeyCondition;
    /**
     * (experimental) Condition k >= arg, true if the key attribute k is greater or equal to the Query argument.
     *
     * @experimental
     */
    static ge(keyName: string, arg: string): KeyCondition;
    /**
     * (experimental) Condition (k, arg).
     *
     * True if the key attribute k begins with the Query argument.
     *
     * @experimental
     */
    static beginsWith(keyName: string, arg: string): KeyCondition;
    /**
     * (experimental) Condition k BETWEEN arg1 AND arg2, true if k >= arg1 and k <= arg2.
     *
     * @experimental
     */
    static between(keyName: string, arg1: string, arg2: string): KeyCondition;
    private constructor();
    /**
     * (experimental) Conjunction between two conditions.
     *
     * @experimental
     */
    and(keyCond: KeyCondition): KeyCondition;
    /**
     * (experimental) Renders the key condition to a VTL string.
     *
     * @experimental
     */
    renderTemplate(): string;
}
/**
 * (experimental) Utility class representing the assigment of a value to an attribute.
 *
 * @experimental
 */
export declare class Assign {
    private readonly attr;
    private readonly arg;
    /**
     * @experimental
     */
    constructor(attr: string, arg: string);
    /**
     * (experimental) Renders the assignment as a VTL string.
     *
     * @experimental
     */
    renderAsAssignment(): string;
    /**
     * (experimental) Renders the assignment as a map element.
     *
     * @experimental
     */
    putInMap(map: string): string;
}
/**
 * (experimental) Utility class to allow assigning a value or an auto-generated id to a partition key.
 *
 * @experimental
 */
export declare class PartitionKeyStep {
    private readonly key;
    /**
     * @experimental
     */
    constructor(key: string);
    /**
     * (experimental) Assign an auto-generated value to the partition key.
     *
     * @experimental
     */
    is(val: string): PartitionKey;
    /**
     * (experimental) Assign an auto-generated value to the partition key.
     *
     * @experimental
     */
    auto(): PartitionKey;
}
/**
 * (experimental) Utility class to allow assigning a value or an auto-generated id to a sort key.
 *
 * @experimental
 */
export declare class SortKeyStep {
    private readonly pkey;
    private readonly skey;
    /**
     * @experimental
     */
    constructor(pkey: Assign, skey: string);
    /**
     * (experimental) Assign an auto-generated value to the sort key.
     *
     * @experimental
     */
    is(val: string): PrimaryKey;
    /**
     * (experimental) Assign an auto-generated value to the sort key.
     *
     * @experimental
     */
    auto(): PrimaryKey;
}
/**
 * (experimental) Specifies the assignment to the primary key.
 *
 * It either
 * contains the full primary key or only the partition key.
 *
 * @experimental
 */
export declare class PrimaryKey {
    protected readonly pkey: Assign;
    private readonly skey?;
    /**
     * (experimental) Allows assigning a value to the partition key.
     *
     * @experimental
     */
    static partition(key: string): PartitionKeyStep;
    /**
     * @experimental
     */
    constructor(pkey: Assign, skey?: Assign | undefined);
    /**
     * (experimental) Renders the key assignment to a VTL string.
     *
     * @experimental
     */
    renderTemplate(): string;
}
/**
 * (experimental) Specifies the assignment to the partition key.
 *
 * It can be
 * enhanced with the assignment of the sort key.
 *
 * @experimental
 */
export declare class PartitionKey extends PrimaryKey {
    /**
     * @experimental
     */
    constructor(pkey: Assign);
    /**
     * (experimental) Allows assigning a value to the sort key.
     *
     * @experimental
     */
    sort(key: string): SortKeyStep;
}
/**
 * (experimental) Specifies the attribute value assignments.
 *
 * @experimental
 */
export declare class AttributeValues {
    private readonly container;
    private readonly assignments;
    /**
     * @experimental
     */
    constructor(container: string, assignments?: Assign[]);
    /**
     * (experimental) Allows assigning a value to the specified attribute.
     *
     * @experimental
     */
    attribute(attr: string): AttributeValuesStep;
    /**
     * (experimental) Renders the variables required for `renderTemplate`.
     *
     * @experimental
     */
    renderVariables(): string;
    /**
     * (experimental) Renders the attribute value assingments to a VTL string.
     *
     * @experimental
     */
    renderTemplate(): string;
}
/**
 * (experimental) Utility class to allow assigning a value to an attribute.
 *
 * @experimental
 */
export declare class AttributeValuesStep {
    private readonly attr;
    private readonly container;
    private readonly assignments;
    /**
     * @experimental
     */
    constructor(attr: string, container: string, assignments: Assign[]);
    /**
     * (experimental) Assign the value to the current attribute.
     *
     * @experimental
     */
    is(val: string): AttributeValues;
}
/**
 * (experimental) Factory class for attribute value assignments.
 *
 * @experimental
 */
export declare class Values {
    /**
     * (experimental) Treats the specified object as a map of assignments, where the property names represent attribute names.
     *
     * It’s opinionated about how it represents
     * some of the nested objects: e.g., it will use lists (“L”) rather than sets
     * (“SS”, “NS”, “BS”). By default it projects the argument container ("$ctx.args").
     *
     * @experimental
     */
    static projecting(arg?: string): AttributeValues;
    /**
     * (experimental) Allows assigning a value to the specified attribute.
     *
     * @experimental
     */
    static attribute(attr: string): AttributeValuesStep;
}
