'''
Given a string A, find if there is any subsequence that repeats itself. A
 subsequence of a string is defined as a sequence of characters generated by 
 deleting some characters in the string without changing the order of the
  remaining characters. NOTE : sub-sequence length should be greater than
   or equal to 2. 
 Input Format:
The first and the only argument of input contains a string A.
Output Format:
Return an integer, 0 or 1:
    => 0 : False
    => 1 : True
Constraints:
1 <= length(A) <= 100
Examples:
Input 1:
    A = "abab"

Output 1:
    1

Explanation 1:
    "ab" is repeated.

Input 2:
    A = "abba"

Output 2:
    0

Explanation 2:
    There is no repeating subsequence.
'''


def anytwo(A):
    memo = {}
    
    def dp(i, j):
        if i == -1 or j == -1:
            return 0
        
        if (i, j) in memo:
            return memo[i, j]
        
        if A[i] == A[j] and i != j:
            memo[i, j] = 1 + dp(i - 1, j - 1)
        else:
            memo[i, j] = max(dp(i - 1, j), dp(i, j - 1))
        
        return memo[i, j]
    
    return int(dp(len(A) - 1, len(A) - 1) >= 2)
    