[![PyPI version](https://badge.fury.io/py/algorithms.svg)](https://badge.fury.io/py/algorithms)
[![Open Source Helpers](https://www.codetriage.com/keon/algorithms/badges/users.svg)](https://www.codetriage.com/keon/algorithms)
[![Build Status](https://travis-ci.org/keon/algorithms.svg?branch=master)](https://travis-ci.org/keon/algorithms)
[![Coverage Status](https://coveralls.io/repos/github/keon/algorithms/badge.svg?branch=master)](https://coveralls.io/github/keon/algorithms?branch=master)

<p align="center"><img src="https://raw.githubusercontent.com/keon/algorithms/master/docs/source/_static/logo/logotype1blue.png"></p>

SEANLAB Algorithms
Pythonic Data Structures and Algorithms
=========================================

Minimal and clean example implementations of data structures and algorithms in Python 3.

## Contributing
Thanks for your interest in contributing! There are many ways to contribute to this project. [Get started here](CONTRIBUTING.md)

## Tests

### Use unittest
For running all tests write down:

    $ python3 -m unittest discover tests

For running some specific tests you can do this as following (Ex: sort):

    $ python3 -m unittest tests.test_sort

### Use pytest
For running all tests write down:

    $ python3 -m pytest tests

## Install
If you want to use the API algorithms in your code, it is as simple as:

    $ pip3 install seanalgorithms3

You can test by creating a python file: (Ex: use `merge_sort` in `sort`)

```python3
from seanalgorithms3.sort import merge_sort

if __name__ == "__main__":
    my_list = [1, 8, 3, 5, 6]
    my_list = merge_sort(my_list)
    print(my_list)
```

## Uninstall
If you want to uninstall seanalgorithms3, it is as simple as:

    $ pip3 uninstall -y seanalgorithms3

## List of Implementations
  
  - [algorithms_practice](algorithms_practice/arrays)
    - [1.add_to_array_form](arrays/1.add_to_array_form.py)
    - [10.degree_array](arrays/10.degree_array.py)
    - [11.distribute_candies](arrays/11.distribute_candies.py)
    - [12.duplicate_zeroes](arrays/12.duplicate_zeroes.py)
    - [13.find_all_dissapeared_numbers](arrays/13.find_all_dissapeared_numbers.py)
    - [14.find_all_duplicates](arrays/14.find_all_duplicates.py)
    - [15.find_pivot_index](arrays/15.find_pivot_index.py)
    - [16.first_missing_positive](arrays/16.first_missing_positive.py)
    - [17.friends_of_ages](arrays/17.friends_of_ages.py)
    - [18.increasing_triplets](arrays/18.increasing_triplets.py)
    - [19.intersection_two_arrays_II](arrays/19.intersection_two_arrays_II.py)
    - [2.array_partition](arrays/2.array_partition.py)
    - [20.is_monotonic](arrays/20.is_monotonic.py)
    - [21.k_diff_pairs](arrays/21.k_diff_pairs.py)
    - [22.largest_number_twice_of_others](arrays/22.largest_number_twice_of_others.py)
    - [23.longest_continuous_increasing_subsequence](arrays/23.longest_continuous_increasing_subsequence.py)
    - [24.majority_element_ii](arrays/24.majority_element_ii.py)
    - [25.max_average_subarray](arrays/25.max_average_subarray.py)
    - [26.max_consecutive_ones](arrays/26.max_consecutive_ones.py)
    - [27.max_product_three_numbers](arrays/27.max_product_three_numbers.py)
    - [28.maximize_distance_to_nearest_person](arrays/28.maximize_distance_to_nearest_person.py)
    - [29.maximum_subarray](arrays/29.maximum_subarray.py)
    - [3.assign_cookies](arrays/3.assign_cookies.py)
    - [30.merge_intervals](arrays/30.merge_intervals.py)
    - [31.merge_sorted_array](arrays/31.merge_sorted_array.py)
    - [32.min_moves_to_equal_elements](arrays/32.min_moves_to_equal_elements.py)
    - [33.minimum_moves_to_equal_array](arrays/33.minimum_moves_to_equal_array.py)
    - [34.move_zeroes](arrays/34.move_zeroes.py)
    - [35.my_calendar_II](arrays/35.my_calendar_II.py)
    - [36.next_greater_element](arrays/36.next_greater_element.py)
    - [37.non_decreasing_array](arrays/37.non_decreasing_array.py)
    - [38.number_plus_one](arrays/38.number_plus_one.py)
    - [39.partition_array_in_three](arrays/39.partition_array_in_three.py)
    - [4.best_time_to_buy_stock](arrays/4.best_time_to_buy_stock.py)
    - [40.place_flowers](arrays/40.place_flowers.py)
    - [41.positions_large_groups](arrays/41.positions_large_groups.py)
    - [42.product_of_array_except_self](arrays/42.product_of_array_except_self.py)
    - [43.remove_duplicates_two](arrays/43.remove_duplicates_two.py)
    - [44.rotate_array](arrays/44.rotate_array.py)
    - [45.set_mismatch](arrays/45.set_mismatch.py)
    - [46.shortest_unsorted_subarray](arrays/46.shortest_unsorted_subarray.py)
    - [47.smallest_range_I](arrays/47.smallest_range_I.py)
    - [48.sum_after_queries](arrays/48.sum_after_queries.py)
    - [49.summary_ranges](arrays/49.summary_ranges.py)
    - [5.best_time_to_buy_stock_all](arrays/5.best_time_to_buy_stock_all.py)
    - [50.third_max_number](arrays/50.third_max_number.py)
    - [51.two_sum_sorted_array](arrays/51.two_sum_sorted_array.py)
    - [52.wiggle_sort_II](arrays/52.wiggle_sort_II.py)
    - [6.candies_people](arrays/6.candies_people.py)
    - [7.coins_in_a_line](arrays/7.coins_in_a_line.py)
    - [8.contains_duplicate_one](arrays/8.contains_duplicate_one.py)
    - [9.contains_duplicate_range](arrays/9.contains_duplicate_range.py)
    - [x.dynamic_array_implementation](arrays/x.dynamic_array_implementation.py)
    - [1.binary_watch](backtracking/1.binary_watch.py)
    - [10.letter_combinations](backtracking/10.letter_combinations.py)
    - [11.matchsticks_to_square](backtracking/11.matchsticks_to_square.py)
    - [12.n_queens](backtracking/12.n_queens.py)
    - [13.n_queens_II](backtracking/13.n_queens_II.py)
    - [14.palindrome_partition](backtracking/14.palindrome_partition.py)
    - [15.permutation_sequence](backtracking/15.permutation_sequence.py)
    - [16.permutations_one](backtracking/16.permutations_one.py)
    - [17.permutations_two](backtracking/17.permutations_two.py)
    - [18.restore_ip_addresses](backtracking/18.restore_ip_addresses.py)
    - [19.subsets](backtracking/19.subsets.py)
    - [2.combinations](backtracking/2.combinations.py)
    - [20.subsets_duplicates](backtracking/20.subsets_duplicates.py)
    - [21.sudoku_solver](backtracking/21.sudoku_solver.py)
    - [22.valid_time](backtracking/22.valid_time.py)
    - [3.combinations_sum](backtracking/3.combinations_sum.py)
    - [4.combinations_sum_four](backtracking/4.combinations_sum_four.py)
    - [5.combinations_sum_three](backtracking/5.combinations_sum_three.py)
    - [6.combinations_sum_two](backtracking/6.combinations_sum_two.py)
    - [7.decoded_string_at_index](backtracking/7.decoded_string_at_index.py)
    - [8.generate_paranthesis](backtracking/8.generate_paranthesis.py)
    - [9.letter_case_permutations](backtracking/9.letter_case_permutations.py)
    - [xx.flatten_nested_list](backtracking/xx.flatten_nested_list.py)
    - [1.arranging_coins](binarysearch/1.arranging_coins.py)
    - [10.koko_eating_bananas](binarysearch/10.koko_eating_bananas.py)
    - [11.min_in_rotated_sorted_array](binarysearch/11.min_in_rotated_sorted_array.py)
    - [12.minimum_size_subarray](binarysearch/12.minimum_size_subarray.py)
    - [13.next_greater_letter](binarysearch/13.next_greater_letter.py)
    - [14.peak_index_mountain_array](binarysearch/14.peak_index_mountain_array.py)
    - [15.search_2d_matrix](binarysearch/15.search_2d_matrix.py)
    - [16.search_2d_matrix_I2](binarysearch/16.search_2d_matrix_I2.py)
    - [17.search_insert_position](binarysearch/17.search_insert_position.py)
    - [18.search_range](binarysearch/18.search_range.py)
    - [19.search_rotated_array](binarysearch/19.search_rotated_array.py)
    - [20.search_rotated_array_II](binarysearch/20.search_rotated_array_II.py)
    - [21.sqrt_number](binarysearch/21.sqrt_number.py)
    - [22.sum_square_numbers](binarysearch/22.sum_square_numbers.py)
    - [23.valid_perfect_square](binarysearch/23.valid_perfect_square.py)
    - [3.count_of_smaller_to_right](binarysearch/3.count_of_smaller_to_right.py)
    - [4.find_k_closest](binarysearch/4.find_k_closest.py)
    - [5.find_peak](binarysearch/5.find_peak.py)
    - [6.find_right_interval](binarysearch/6.find_right_interval.py)
    - [7.four_sum_count](binarysearch/7.four_sum_count.py)
    - [8.h_index](binarysearch/8.h_index.py)
    - [9.heaters](binarysearch/9.heaters.py)
    - [binary_search](binarysearch/binary_search.py)
    - [x.first_bad](binarysearch/x.first_bad.py)
    - [x.guess_number](binarysearch/x.guess_number.py)
    - [x.random_pick_with_weight](binarysearch/x.random_pick_with_weight.py)
    - [1.binary_gap](bits/1.binary_gap.py)
    - [10.number_with_alternating_bits](bits/10.number_with_alternating_bits.py)
    - [11.prefix_divisible_5](bits/11.prefix_divisible_5.py)
    - [12.reverse_bits](bits/12.reverse_bits.py)
    - [13.single_number](bits/13.single_number.py)
    - [14.single_number_ii](bits/14.single_number_ii.py)
    - [15.single_number_III](bits/15.single_number_III.py)
    - [16sum_two_numbers](bits/16sum_two_numbers.py)
    - [17.total_hamming_distance](bits/17.total_hamming_distance.py)
    - [2.bitwise_and_range](bits/2.bitwise_and_range.py)
    - [3.complement_base_10_integer](bits/3.complement_base_10_integer.py)
    - [4.count_1_bits](bits/4.count_1_bits.py)
    - [5.count_set_bits_prime](bits/5.count_set_bits_prime.py)
    - [6.counting_bits](bits/6.counting_bits.py)
    - [6.find_max_xor_pair](bits/6.find_max_xor_pair.py)
    - [7.gray_code](bits/7.gray_code.py)
    - [8.is_one_bit_character](bits/8.is_one_bit_character.py)
    - [9.max_product_word_lengths](bits/9.max_product_word_lengths.py)
    - [1.bst_to_greater_sum_tree](bst/1.bst_to_greater_sum_tree.py)
    - [10.my_calendar](bst/10.my_calendar.py)
    - [11.range_sum_bst](bst/11.range_sum_bst.py)
    - [12.search_bst](bst/12.search_bst.py)
    - [13.two_sum_bst](bst/13.two_sum_bst.py)
    - [2.delete_node](bst/2.delete_node.py)
    - [3.find_mode_bst](bst/3.find_mode_bst.py)
    - [4.increasing_order_search_tree](bst/4.increasing_order_search_tree.py)
    - [5.insert_into_bst](bst/5.insert_into_bst.py)
    - [6.kth_smallest_element](bst/6.kth_smallest_element.py)
    - [7.lowest_common_ancestor_bst](bst/7.lowest_common_ancestor_bst.py)
    - [8.min_distance_bst](bst/8.min_distance_bst.py)
    - [9.minimum_diff_bst](bst/9.minimum_diff_bst.py)
    - [bst_implementation](bst/bst_implementation.py)
    - [bst_iterator](bst/bst_iterator.py)
    - [validate_bst](bst/validate_bst.py)
    - [x.list_to_bst](bst/x.list_to_bst.py)
    - [x.recover_bst](bst/x.recover_bst.py)
    - [1.best_sight_seeing_pair](dp/1.best_sight_seeing_pair.py)
    - [10.delete_operations_for_two_strings](dp/10.delete_operations_for_two_strings.py)
    - [11.distinct_subsequences](dp/11.distinct_subsequences.py)
    - [12.dungeon_princess](dp/12.dungeon_princess.py)
    - [13.edit_distance](dp/13.edit_distance.py)
    - [14.fibonacci](dp/14.fibonacci.py)
    - [15.flip_array](dp/15.flip_array.py)
    - [16.house_robber](dp/16.house_robber.py)
    - [16.integer_replacement](dp/16.integer_replacement.py)
    - [17.interleaving_strings](dp/17.interleaving_strings.py)
    - [18.jump_game](dp/18.jump_game.py)
    - [19.jump_game_II](dp/19.jump_game_II.py)
    - [2.bitonic_subsequence](dp/2.bitonic_subsequence.py)
    - [20.kth_grammar](dp/20.kth_grammar.py)
    - [21.longest_common_subsequence](dp/21.longest_common_subsequence.py)
    - [22.longest_increasing_subsequence](dp/22.longest_increasing_subsequence.py)
    - [23.longest_palindromic_subsequence](dp/23.longest_palindromic_subsequence.py)
    - [24.matrix_chain_multiplication](dp/24.matrix_chain_multiplication.py)
    - [25.max_crossed_lines](dp/25.max_crossed_lines.py)
    - [26.max_product_subarray](dp/26.max_product_subarray.py)
    - [27.max_sum_without_adjacent_elements](dp/27.max_sum_without_adjacent_elements.py)
    - [28.maximum_sum_two_non_overlapping_subarray](dp/28.maximum_sum_two_non_overlapping_subarray.py)
    - [29.min_cost_climbing_stairs](dp/29.min_cost_climbing_stairs.py)
    - [3.box_stacking](dp/3.box_stacking.py)
    - [30.minimum_path_sum](dp/30.minimum_path_sum.py)
    - [31.nth_ugly_number](dp/31.nth_ugly_number.py)
    - [32.partition_equal_subset](dp/32.partition_equal_subset.py)
    - [33.party](dp/33.party.py)
    - [34.pascal](dp/34.pascal.py)
    - [35.pascal_row](dp/35.pascal_row.py)
    - [36.perfect_squares](dp/36.perfect_squares.py)
    - [37.pow](dp/37.pow.py)
    - [38.range_sum_query](dp/38.range_sum_query.py)
    - [39.range_sum_query_2d](dp/39.range_sum_query_2d.py)
    - [4.capacity_to_ship_packages](dp/4.capacity_to_ship_packages.py)
    - [40.range_sum_query_mutable](dp/40.range_sum_query_mutable.py)
    - [41.repeating_subsequence](dp/41.repeating_subsequence.py)
    - [42.russian_doll](dp/42.russian_doll.py)
    - [43.scramble_string](dp/43.scramble_string.py)
    - [44.super_ugly_number](dp/44.super_ugly_number.py)
    - [45.triangle_min_path](dp/45.triangle_min_path.py)
    - [46.unique_bst](dp/46.unique_bst.py)
    - [47.unique_paths](dp/47.unique_paths.py)
    - [48.unique_paths_with_obstacle](dp/48.unique_paths_with_obstacle.py)
    - [49.zero_one_matrix](dp/49.zero_one_matrix.py)
    - [5.climbing_stairs](dp/5.climbing_stairs.py)
    - [6.coin_sum_infinite](dp/6.coin_sum_infinite.py)
    - [7.continuous_subarray_sum](dp/7.continuous_subarray_sum.py)
    - [8.count_number_without_consecutive_ones](dp/8.count_number_without_consecutive_ones.py)
    - [9.decode_ways](dp/9.decode_ways.py)
    - [fibonacci](dp/fibonacci.py)
    - [0.graph_implementation](graphs/0.graph_implementation.py)
    - [1.accounts_merge](graphs/1.accounts_merge.py)
    - [10.is_bipartate](graphs/10.is_bipartate.py)
    - [11.keys_and_rooms](graphs/11.keys_and_rooms.py)
    - [12.longest_increasing_path_matrix](graphs/12.longest_increasing_path_matrix.py)
    - [13.make_larger_island](graphs/13.make_larger_island.py)
    - [14.max_area_island](graphs/14.max_area_island.py)
    - [15.maximum_sum](graphs/15.maximum_sum.py)
    - [16.min_genetic_mutations](graphs/16.min_genetic_mutations.py)
    - [17.minesweeper](graphs/17.minesweeper.py)
    - [18.minimum_height_trees](graphs/18.minimum_height_trees.py)
    - [19.network_delay_time](graphs/19.network_delay_time.py)
    - [2.bt_right_view](graphs/2.bt_right_view.py)
    - [20.nodes_at_distance](graphs/20.nodes_at_distance.py)
    - [21.number_islands](graphs/21.number_islands.py)
    - [22.number_of_enclaves](graphs/22.number_of_enclaves.py)
    - [23.number_of_sqaureful_arrays](graphs/23.number_of_sqaureful_arrays.py)
    - [24.regions_cut_by_slashes](graphs/24.regions_cut_by_slashes.py)
    - [25.regular_expression_match](graphs/25.regular_expression_match.py)
    - [26.regular_expression_two](graphs/26.regular_expression_two.py)
    - [27.rotton_oranges](graphs/27.rotton_oranges.py)
    - [28.shortest_bridge](graphs/28.shortest_bridge.py)
    - [29.shortest_path_binary_matrix](graphs/29.shortest_path_binary_matrix.py)
    - [3.color_the_border](graphs/3.color_the_border.py)
    - [30.surround_region](graphs/30.surround_region.py)
    - [31.town_judge](graphs/31.town_judge.py)
    - [32.tushars_birthday](graphs/32.tushars_birthday.py)
    - [33.unique_paths_III](graphs/33.unique_paths_III.py)
    - [34.water_and_jug](graphs/34.water_and_jug.py)
    - [35.word_ladder](graphs/35.word_ladder.py)
    - [36.word_ladder_two](graphs/36.word_ladder_two.py)
    - [37.word_search](graphs/37.word_search.py)
    - [4.concatenated_words](graphs/4.concatenated_words.py)
    - [5.course_order](graphs/5.course_order.py)
    - [6.flood_fill](graphs/6.flood_fill.py)
    - [7.flower_planting_with_no_adjacent](graphs/7.flower_planting_with_no_adjacent.py)
    - [8.friend_circle](graphs/8.friend_circle.py)
    - [9.house_robber_three](graphs/9.house_robber_three.py)
    - [test](graphs/test.py)
    - [x.clone_graph](graphs/x.clone_graph.py)
    - [x.employee_importance](graphs/x.employee_importance.py)
    - [x.pacific_atlantic_water_flow](graphs/x.pacific_atlantic_water_flow.py)
    - [x.redundant_connection](graphs/x.redundant_connection.py)
    - [1.burst_balloons](greedy/1.burst_balloons.py)
    - [10.moving_stones](greedy/10.moving_stones.py)
    - [11.non_overlapping_intervals](greedy/11.non_overlapping_intervals.py)
    - [12.queue_reconstruction_by_height](greedy/12.queue_reconstruction_by_height.py)
    - [13.relative_ranks](greedy/13.relative_ranks.py)
    - [14.remove_outermost_parantheses](greedy/14.remove_outermost_parantheses.py)
    - [15.reorganize_string](greedy/15.reorganize_string.py)
    - [16.two_city_scheduling](greedy/16.two_city_scheduling.py)
    - [2.di_string_match](greedy/2.di_string_match.py)
    - [3.dota2_senate](greedy/3.dota2_senate.py)
    - [4.fair_candy_swap](greedy/4.fair_candy_swap.py)
    - [5.is_subsequence](greedy/5.is_subsequence.py)
    - [6.make_paran_valid](greedy/6.make_paran_valid.py)
    - [7.max_chunks_to_make_sorted](greedy/7.max_chunks_to_make_sorted.py)
    - [8.max_chunks_to_make_sorted_II](greedy/8.max_chunks_to_make_sorted_II.py)
    - [9.maximize_sum_array](greedy/9.maximize_sum_array.py)
    - [1.banned_words](hashtables/1.banned_words.py)
    - [10.find_common_characters](hashtables/10.find_common_characters.py)
    - [11.four_sum](hashtables/11.four_sum.py)
    - [12.fraction_to_decimal](hashtables/12.fraction_to_decimal.py)
    - [13.group_anagrams](hashtables/13.group_anagrams.py)
    - [14.keyboard_row](hashtables/14.keyboard_row.py)
    - [15.largest_triangle_area](hashtables/15.largest_triangle_area.py)
    - [16.lemonade_change](hashtables/16.lemonade_change.py)
    - [17.longest_consecutive_sequence](hashtables/17.longest_consecutive_sequence.py)
    - [18.longest_word_dictionary](hashtables/18.longest_word_dictionary.py)
    - [19.minimum_index_sum_of_two_lists](hashtables/19.minimum_index_sum_of_two_lists.py)
    - [2.boomerang_points](hashtables/2.boomerang_points.py)
    - [20.n_repeated_elements](hashtables/20.n_repeated_elements.py)
    - [21.pairs_with_sum](hashtables/21.pairs_with_sum.py)
    - [22.powerful_integers](hashtables/22.powerful_integers.py)
    - [23.repeated_dna_sequences](hashtables/23.repeated_dna_sequences.py)
    - [24.shortest_completing_word](hashtables/24.shortest_completing_word.py)
    - [25.shuffle_array](hashtables/25.shuffle_array.py)
    - [26.sort_by_count](hashtables/26.sort_by_count.py)
    - [27.subdomain_visit_count](hashtables/27.subdomain_visit_count.py)
    - [28.substring_concat](hashtables/28.substring_concat.py)
    - [29.three_sum](hashtables/29.three_sum.py)
    - [3.bulls_and_cows](hashtables/3.bulls_and_cows.py)
    - [30.two_sum](hashtables/30.two_sum.py)
    - [31.uncommon_words](hashtables/31.uncommon_words.py)
    - [32.valid_sudoku](hashtables/32.valid_sudoku.py)
    - [33.verifying_alien_dictionary](hashtables/33.verifying_alien_dictionary.py)
    - [34.word_pattern](hashtables/34.word_pattern.py)
    - [35.word_subsets](hashtables/35.word_subsets.py)
    - [4.contiguous_array](hashtables/4.contiguous_array.py)
    - [5.deck_of_cards](hashtables/5.deck_of_cards.py)
    - [6.distant_barcodes](hashtables/6.distant_barcodes.py)
    - [7.encode_decode](hashtables/7.encode_decode.py)
    - [8.expressive_words](hashtables/8.expressive_words.py)
    - [9.find_and_replace_pattern](hashtables/9.find_and_replace_pattern.py)
    - [hashmap](hashtables/hashmap.py)
    - [hashmap_implementation](hashtables/hashmap_implementation.py)
    - [hashset](hashtables/hashset.py)
    - [insert_delete_random](hashtables/insert_delete_random.py)
    - [insert_delete_random_duplicates](hashtables/insert_delete_random_duplicates.py)
    - [lru_cache](hashtables/lru_cache.py)
    - [magic_dictionary](hashtables/magic_dictionary.py)
    - [1.check_valid_triangle](heaps/1.check_valid_triangle.py)
    - [10.sliding_window_median](heaps/10.sliding_window_median.py)
    - [11.top_k_frequent_words](heaps/11.top_k_frequent_words.py)
    - [2.design_twitter](heaps/2.design_twitter.py)
    - [3.k_most_frequent](heaps/3.k_most_frequent.py)
    - [4.k_pairs_with_smallest_sums](heaps/4.k_pairs_with_smallest_sums.py)
    - [5.kth_largest](heaps/5.kth_largest.py)
    - [6.kth_largest_in_stream](heaps/6.kth_largest_in_stream.py)
    - [7.kth_smallest_in_sorted_matrix](heaps/7.kth_smallest_in_sorted_matrix.py)
    - [8.last_stone_weight](heaps/8.last_stone_weight.py)
    - [9.median_of_stream](heaps/9.median_of_stream.py)
    - [heap_implementation](heaps/heap_implementation.py)
    - [priority_queue_implementation](heaps/priority_queue_implementation.py)
    - [1.add_two_numbers](linkedlist/1.add_two_numbers.py)
    - [10.list_palindrome](linkedlist/10.list_palindrome.py)
    - [11.merge_k_lists](linkedlist/11.merge_k_lists.py)
    - [12.middle_linked_list](linkedlist/12.middle_linked_list.py)
    - [13.merge_two_lists](linkedlist/13.merge_two_lists.py)
    - [14.odd_even_linked_list](linkedlist/14.odd_even_linked_list.py)
    - [15.partition_list](linkedlist/15.partition_list.py)
    - [16.remove_element](linkedlist/16.remove_element.py)
    - [17.remove_nth_end](linkedlist/17.remove_nth_end.py)
    - [18.reorder_list](linkedlist/18.reorder_list.py)
    - [19.reverse_k_groups](linkedlist/19.reverse_k_groups.py)
    - [2.add_two_numbers_II](linkedlist/2.add_two_numbers_II.py)
    - [20.reverse_linkedlist](linkedlist/20.reverse_linkedlist.py)
    - [21.reverse_mn](linkedlist/21.reverse_mn.py)
    - [22.rotate_list](linkedlist/22.rotate_list.py)
    - [23.sort_list](linkedlist/23.sort_list.py)
    - [24.swap_pairs](linkedlist/24.swap_pairs.py)
    - [3.delete_duplicates](linkedlist/3.delete_duplicates.py)
    - [4.delete_duplicates_all](linkedlist/4.delete_duplicates_all.py)
    - [5.insertion_sort_list_geeks](linkedlist/5.insertion_sort_list_geeks.py)
    - [6.insertion_sort_list](linkedlist/6.insertion_sort_list.py)
    - [7.intersection_geeks](linkedlist/7.intersection_geeks.py)
    - [8.linked_cycle](linkedlist/8.linked_cycle.py)
    - [9.linked_list_cycle_II](linkedlist/9.linked_list_cycle_II.py)
    - [delete_node_without_head](linkedlist/delete_node_without_head.py)
    - [intersection](linkedlist/intersection.py)
    - [linkedlist](linkedlist/linkedlist.py)
    - [linked_list_random](linkedlist/linked_list_random.py)
    - [next_greater_node](linkedlist/next_greater_node.py)
    - [singly_linked_list_implementation](linkedlist/singly_linked_list_implementation.py)
    - [split_list_in_parts](linkedlist/split_list_in_parts.py)
    - [test](linkedlist/test.py)
    - [1.add_binary_mod1](math/1.add_binary_mod1.py)
    - [10.count_zeroes_factorial](math/10.count_zeroes_factorial.py)
    - [11.divide_two_numbers](math/11.divide_two_numbers.py)
    - [12.divisor_game](math/12.divisor_game.py)
    - [13.elimination_game](math/13.elimination_game.py)
    - [14.finding_position](math/14.finding_position.py)
    - [15.game_of_nim](math/15.game_of_nim.py)
    - [16.hamming_distance](math/16.hamming_distance.py)
    - [17.happy_numbers](math/17.happy_numbers.py)
    - [18.integer_to_english_words](math/18.integer_to_english_words.py)
    - [19.intersection_two_arrays](math/19.intersection_two_arrays.py)
    - [2.add_digits](math/2.add_digits.py)
    - [20.largest_triangle_area](math/20.largest_triangle_area.py)
    - [21.letter_tile_possibilities](math/21.letter_tile_possibilities.py)
    - [22.majority_element](math/22.majority_element.py)
    - [24.max_points_on_line](math/24.max_points_on_line.py)
    - [25.min_time_difference](math/25.min_time_difference.py)
    - [26.minimum_area_rectangle](math/26.minimum_area_rectangle.py)
    - [27.missing_number](math/27.missing_number.py)
    - [28.next_greater_III](math/28.next_greater_III.py)
    - [29.next_permutation](math/29.next_permutation.py)
    - [3.basic_calculator_I](math/3.basic_calculator_I.py)
    - [30.nth_digit](math/30.nth_digit.py)
    - [31.num_to_col](math/31.num_to_col.py)
    - [32.perfect_number](math/32.perfect_number.py)
    - [33.power_of_two](math/33.power_of_two.py)
    - [34.reach_a_number](math/34.reach_a_number.py)
    - [35.rectangle_overlap](math/35.rectangle_overlap.py)
    - [36.self_dividing_numbers](math/36.self_dividing_numbers.py)
    - [37.smallest_integer_divisible_by_k](math/37.smallest_integer_divisible_by_k.py)
    - [38.statistics_from_sample](math/38.statistics_from_sample.py)
    - [39.ugly_numbers](math/39.ugly_numbers.py)
    - [4.basic_calculator_II](math/4.basic_calculator_II.py)
    - [40.valid_boomerang](math/40.valid_boomerang.py)
    - [41.valid_number](math/41.valid_number.py)
    - [42.valid_triangle_number](math/42.valid_triangle_number.py)
    - [5.construct_rectangle](math/5.construct_rectangle.py)
    - [6.convert_to_base_7](math/6.convert_to_base_7.py)
    - [7.convert_to_hex](math/7.convert_to_hex.py)
    - [8.convert_to_number](math/8.convert_to_number.py)
    - [9.count_primes](math/9.count_primes.py)
    - [add_binary](math/add_binary.py)
    - [total_time](math/total_time.py)
    - [1.battleships_in_a_board](matrix/1.battleships_in_a_board.py)
    - [10.reshape_matrix](matrix/10.reshape_matrix.py)
    - [11.robot_bounded_circle](matrix/11.robot_bounded_circle.py)
    - [12.rook_captures](matrix/12.rook_captures.py)
    - [13.rotate_image_v1](matrix/13.rotate_image_v1.py)
    - [14.set_matrix_zeros](matrix/14.set_matrix_zeros.py)
    - [15.spiral_matrix](matrix/15.spiral_matrix.py)
    - [16.spiral_matrix_generate](matrix/16.spiral_matrix_generate.py)
    - [17.spiral_matrix_III](matrix/17.spiral_matrix_III.py)
    - [18.toeplitz_matrix](matrix/18.toeplitz_matrix.py)
    - [19.transpose_matrix](matrix/19.transpose_matrix.py)
    - [2.brick_wall](matrix/2.brick_wall.py)
    - [20.](matrix/20..py)
    - [3.flip_image](matrix/3.flip_image.py)
    - [4.game_of_life](matrix/4.game_of_life.py)
    - [5.image_smoother](matrix/5.image_smoother.py)
    - [6.island_perimeter](matrix/6.island_perimeter.py)
    - [7.magic_squares_in_grid](matrix/7.magic_squares_in_grid.py)
    - [8.matrix_cells_distance](matrix/8.matrix_cells_distance.py)
    - [9.range_addition](matrix/9.range_addition.py)
    - [rotate_image](matrix/rotate_image.py)
    - [1.car_pooling](queues/1.car_pooling.py)
    - [2.circular_deque_implementation](queues/2.circular_deque_implementation.py)
    - [3.circular_queue_implementation](queues/3.circular_queue_implementation.py)
    - [4.gas_station](queues/4.gas_station.py)
    - [5.max_sliding_window](queues/5.max_sliding_window.py)
    - [6.queue_implementation](queues/6.queue_implementation.py)
    - [7.queue_using_stacks](queues/7.queue_using_stacks.py)
    - [8.rotate_string](queues/8.rotate_string.py)
    - [9.stack_using_queues](queues/9.stack_using_queues.py)
    - [1.bubble_sort](sort/1.bubble_sort.py)
    - [10.most_profit_workers](sort/10.most_profit_workers.py)
    - [11.quick_sort_v2](sort/11.quick_sort_v2.py)
    - [12.reorder_logs](sort/12.reorder_logs.py)
    - [13.selection_sort_v2](sort/13.selection_sort_v2.py)
    - [14.sort_array_parity_II](sort/14.sort_array_parity_II.py)
    - [15.sort_by_parity](sort/15.sort_by_parity.py)
    - [16.sort_three_colors](sort/16.sort_three_colors.py)
    - [17.insertion_sort](sort/17.insertion_sort.py)
    - [18.merge_sort](sort/18.merge_sort.py)
    - [19.quick_sort](sort/19.quick_sort.py)
    - [2.delete_columns_to_make_sorted](sort/2.delete_columns_to_make_sorted.py)
    - [20.selection_sort](sort/20.selection_sort.py)
    - [3.height_checker](sort/3.height_checker.py)
    - [4.insertion_sort_v2](sort/4.insertion_sort_v2.py)
    - [5.k_closest_points_to_origin](sort/5.k_closest_points_to_origin.py)
    - [6.lexical_numbers](sort/6.lexical_numbers.py)
    - [7.longest_harmonious_sequence](sort/7.longest_harmonious_sequence.py)
    - [8.max_gap](sort/8.max_gap.py)
    - [9.merge_sort_v2](sort/9.merge_sort_v2.py)
    - [1.asteroid_collinsion](stack/1.asteroid_collinsion.py)
    - [10.min_stack](stack/10.min_stack.py)
    - [11.next_greater_element_II](stack/11.next_greater_element_II.py)
    - [12.one_three_two_pattern](stack/12.one_three_two_pattern.py)
    - [13.remove_k_digits](stack/13.remove_k_digits.py)
    - [14.simplify_path](stack/14.simplify_path.py)
    - [15.smallest_distinct_seq](stack/15.smallest_distinct_seq.py)
    - [16.trap_rainwater](stack/16.trap_rainwater.py)
    - [17.valid_paran](stack/17.valid_paran.py)
    - [18.validate_stack_sequence](stack/18.validate_stack_sequence.py)
    - [2.baseball_game](stack/2.baseball_game.py)
    - [3.daily_temperatures](stack/3.daily_temperatures.py)
    - [4.duplicate_removal](stack/4.duplicate_removal.py)
    - [5.evaluate_reverse_polish_notation](stack/5.evaluate_reverse_polish_notation.py)
    - [6.exclusive_fuction_time](stack/6.exclusive_fuction_time.py)
    - [7.largest_rectangle_in_histogram](stack/7.largest_rectangle_in_histogram.py)
    - [8.longest_valid_paranthesis](stack/8.longest_valid_paranthesis.py)
    - [9.maximal_rectangle](stack/9.maximal_rectangle.py)
    - [1.2.add_binary](strings/1.2.add_binary.py)
    - [1.add_binary_v2](strings/1.add_binary_v2.py)
    - [10.decode_string](strings/10.decode_string.py)
    - [10.decode_string_v2](strings/10.decode_string_v2.py)
    - [11.defanged_ip_address](strings/11.defanged_ip_address.py)
    - [12.detect_capital](strings/12.detect_capital.py)
    - [13.find_all_anagrams](strings/13.find_all_anagrams.py)
    - [14.find_and_replace](strings/14.find_and_replace.py)
    - [15.find_duplicate_files](strings/15.find_duplicate_files.py)
    - [16.first_unique_character](strings/16.first_unique_character.py)
    - [17.gcd_of_string](strings/17.gcd_of_string.py)
    - [18.goat_latin](strings/18.goat_latin.py)
    - [19.int_to_roman](strings/19.int_to_roman.py)
    - [19.int_to_roman_v2](strings/19.int_to_roman_v2.py)
    - [2.add_strings](strings/2.add_strings.py)
    - [20.isomorphic](strings/20.isomorphic.py)
    - [21.jewels](strings/21.jewels.py)
    - [22.largest_number](strings/22.largest_number.py)
    - [23.length_of_last_word](strings/23.length_of_last_word.py)
    - [24.licence_key_reformatting](strings/24.licence_key_reformatting.py)
    - [25.long_pressed_name](strings/25.long_pressed_name.py)
    - [26.longest_common_prefix](strings/26.longest_common_prefix.py)
    - [27.longest_palin_substring](strings/27.longest_palin_substring.py)
    - [28.longest_palindrome](strings/28.longest_palindrome.py)
    - [29.longest_substring_with_k_chars](strings/29.longest_substring_with_k_chars.py)
    - [3.backspace_compare](strings/3.backspace_compare.py)
    - [30.longest_substring_without_repeating](strings/30.longest_substring_without_repeating.py)
    - [31.longest_uncommon_seq](strings/31.longest_uncommon_seq.py)
    - [32.magical_strings](strings/32.magical_strings.py)
    - [33.minimum_window_string](strings/33.minimum_window_string.py)
    - [34.number_of_lines_to_write_string](strings/34.number_of_lines_to_write_string.py)
    - [35.multiply_strings](strings/35.multiply_strings.py)
    - [35.multiply_strings_v2](strings/35.multiply_strings_v2.py)
    - [36.number_of_segments_string](strings/36.number_of_segments_string.py)
    - [37.occurances_after_bigram](strings/37.occurances_after_bigram.py)
    - [38.optimal_division](strings/38.optimal_division.py)
    - [39.palindrome](strings/39.palindrome.py)
    - [4.buddy_strings](strings/4.buddy_strings.py)
    - [40.permutations_in_string](strings/40.permutations_in_string.py)
    - [41.ransom_note](strings/41.ransom_note.py)
    - [42.remove_comments](strings/42.remove_comments.py)
    - [43.remove_duplicate_letters](strings/43.remove_duplicate_letters.py)
    - [44.repeated_string_match](strings/44.repeated_string_match.py)
    - [45.repeated_substring_pattern](strings/45.repeated_substring_pattern.py)
    - [46.reverse_int](strings/46.reverse_int.py)
    - [47.reverse_only_letters](strings/47.reverse_only_letters.py)
    - [48.reverse_string](strings/48.reverse_string.py)
    - [48.reverse_string_v2](strings/48.reverse_string_v2.py)
    - [49.reverse_string_II](strings/49.reverse_string_II.py)
    - [5.camelcase_matching](strings/5.camelcase_matching.py)
    - [50.reverse_string_words](strings/50.reverse_string_words.py)
    - [51.reverse_vowels_strings](strings/51.reverse_vowels_strings.py)
    - [52.reverse_words_III](strings/52.reverse_words_III.py)
    - [53.robot_origin](strings/53.robot_origin.py)
    - [54.roman_to_int](strings/54.roman_to_int.py)
    - [54.roman_to_int_v2](strings/54.roman_to_int_v2.py)
    - [55.rotated_digits](strings/55.rotated_digits.py)
    - [56.shifting_letters](strings/56.shifting_letters.py)
    - [57.shortest_distance_to_character](strings/57.shortest_distance_to_character.py)
    - [58.shortest_palindrome](strings/58.shortest_palindrome.py)
    - [59.string_compression](strings/59.string_compression.py)
    - [6.compare_version_numbers](strings/6.compare_version_numbers.py)
    - [60.string_to_integer](strings/60.string_to_integer.py)
    - [61.strstr](strings/61.strstr.py)
    - [62.to_lower](strings/62.to_lower.py)
    - [63.unique_email](strings/63.unique_email.py)
    - [64.unique_morse_code](strings/64.unique_morse_code.py)
    - [65.valid_anagram](strings/65.valid_anagram.py)
    - [66.valid_ip](strings/66.valid_ip.py)
    - [67.valid_palin](strings/67.valid_palin.py)
    - [68.valid_palindrome_II](strings/68.valid_palindrome_II.py)
    - [69.valid_string_after_subs](strings/69.valid_string_after_subs.py)
    - [7.complex_number_multiplication](strings/7.complex_number_multiplication.py)
    - [70.zigzag_conversion](strings/70.zigzag_conversion.py)
    - [8.count_binary_strings](strings/8.count_binary_strings.py)
    - [9.count_say](strings/9.count_say.py)
    - [1.add_row_to_tree](trees/1.add_row_to_tree.py)
    - [2.array_bst](trees/2.array_bst.py)
    - [3.average_levels](trees/3.average_levels.py)
    - [4.bst_to_greater_tree](trees/4.bst_to_greater_tree.py)
    - [5.build_tree_postorder](trees/5.build_tree_postorder.py)
    - [6.construct_pre_in](trees/6.construct_pre_in.py)
    - [count_complete_tree_nodes](trees/count_complete_tree_nodes.py)
    - [cousins_in_binary_trees](trees/cousins_in_binary_trees.py)
    - [diameter_binary_tree](trees/diameter_binary_tree.py)
    - [find_bottom_left](trees/find_bottom_left.py)
    - [flatten_binary_tree_to_linked_list](trees/flatten_binary_tree_to_linked_list.py)
    - [inorder](trees/inorder.py)
    - [invert_tree](trees/invert_tree.py)
    - [is_balanced](trees/is_balanced.py)
    - [largest_value_level](trees/largest_value_level.py)
    - [lca_deepest_leaves](trees/lca_deepest_leaves.py)
    - [left_similar_trees](trees/left_similar_trees.py)
    - [level_order_one](trees/level_order_one.py)
    - [level_order_two](trees/level_order_two.py)
    - [lowest_common_ancestor](trees/lowest_common_ancestor.py)
    - [maximum_diff_between_ancestor_and_node](trees/maximum_diff_between_ancestor_and_node.py)
    - [maximum_path_sum](trees/maximum_path_sum.py)
    - [max_depth](trees/max_depth.py)
    - [max_depth_n_ary](trees/max_depth_n_ary.py)
    - [max_subtree](trees/max_subtree.py)
    - [merge_two_trees](trees/merge_two_trees.py)
    - [min_depth](trees/min_depth.py)
    - [most_frequent_subtree_sum](trees/most_frequent_subtree_sum.py)
    - [nary_level_order](trees/nary_level_order.py)
    - [nodes_at_distance_k](trees/nodes_at_distance_k.py)
    - [n_ary_postorder](trees/n_ary_postorder.py)
    - [n_ary_preorder](trees/n_ary_preorder.py)
    - [path_sum](trees/path_sum.py)
    - [path_sum_all](trees/path_sum_all.py)
    - [path_sum_III](trees/path_sum_III.py)
    - [populate_next_right_pointer](trees/populate_next_right_pointer.py)
    - [postorder](trees/postorder.py)
    - [preorder](trees/preorder.py)
    - [same_tree](trees/same_tree.py)
    - [second_minimum_node](trees/second_minimum_node.py)
    - [serialize_tree](trees/serialize_tree.py)
    - [subtree_of_another_tree](trees/subtree_of_another_tree.py)
    - [sum_of_left_leaves](trees/sum_of_left_leaves.py)
    - [sum_root_to_leafs](trees/sum_root_to_leafs.py)
    - [sum_root_to_leaf_paths](trees/sum_root_to_leaf_paths.py)
    - [symmetric](trees/symmetric.py)
    - [tilt_tree](trees/tilt_tree.py)
    - [tree_implementation](trees/tree_implementation.py)
    - [tree_paths](trees/tree_paths.py)
    - [trie_implementation](trees/trie_implementation.py)
    - [univalue_tree](trees/univalue_tree.py)
    - [verify_tree_serialization](trees/verify_tree_serialization.py)
    - [zigzag_level_order](trees/zigzag_level_order.py)
    - [longest_word_dictionary](trie/longest_word_dictionary.py)
    - [replace_words](trie/replace_words.py)
    - [trie_implementation](trie/trie_implementation.py)
    - [word_search_II](trie/word_search_II.py)
    - [container_with_most_water](twopointers/container_with_most_water.py)
    - [find_duplicate_number](twopointers/find_duplicate_number.py)
    - [longest_repeating_character_replacement](twopointers/longest_repeating_character_replacement.py)
    - [longest_word_in_dictionary](twopointers/longest_word_in_dictionary.py)
    - [remove_duplicates](twopointers/remove_duplicates.py)
    - [remove_element](twopointers/remove_element.py)
    - [squares_of_sorted_array](twopointers/squares_of_sorted_array.py)
    - [three_sum_closest](twopointers/three_sum_closest.py)
    - [segment_trees](x_/segment_trees.py)
    
  - [arrays](arrays)
    - [add_to_array_form](arrays/add_to_array_form.py)
    - [array_partition](arrays/array_partition.py)
    - [assign_cookies](arrays/assign_cookies.py)
    - [best_time_to_buy_stock](arrays/best_time_to_buy_stock.py)
    - [best_time_to_buy_stock_all](arrays/best_time_to_buy_stock_all.py)
    - [candies_people](arrays/candies_people.py)
    - [coins_in_a_line](arrays/coins_in_a_line.py)
    - [contains_duplicate_one](arrays/contains_duplicate_one.py)
    - [contains_duplicate_range](arrays/contains_duplicate_range.py)
    - [degree_array](arrays/degree_array.py)
    - [distribute_candies](arrays/distribute_candies.py)
    - [duplicate_zeroes](arrays/duplicate_zeroes.py)
    - [DynamicArray](arrays/DynamicArray.py)
    - [find_all_dissapeared_numbers](arrays/find_all_dissapeared_numbers.py)
    - [find_all_duplicates](arrays/find_all_duplicates.py)
    - [find_pivot_index](arrays/find_pivot_index.py)
    - [find_pivot_index_v2](arrays/find_pivot_index_v2.py)
    - [find_set_mismatch](arrays/find_set_mismatch.py)
    - [first_missing_positive](arrays/first_missing_positive.py)
    - [friends_of_ages](arrays/friends_of_ages.py)
    - [increasing_triplets](arrays/increasing_triplets.py)
    - [intersect_two_array](arrays/intersect_two_array.py)
    - [intersect_two_array_v2](arrays/intersect_two_array_v2.py)
    - [is_monotonic](arrays/is_monotonic.py)
    - [k_diff_pairs](arrays/k_diff_pairs.py)
    - [largest_number_twice_of_others](arrays/largest_number_twice_of_others.py)
    - [longest_continuous_increasing_subsequence](arrays/longest_continuous_increasing_subsequence.py)
    - [majority_element_2](arrays/majority_element_2.py)
    - [maximize_distance_to_nearest_person](arrays/maximize_distance_to_nearest_person.py)
    - [maximum_subarray](arrays/maximum_subarray.py)
    - [max_average_subarray](arrays/max_average_subarray.py)
    - [max_consecutive_ones](arrays/max_consecutive_ones.py)
    - [max_product_three_numbers](arrays/max_product_three_numbers.py)
    - [merge_intervals](arrays/merge_intervals.py)
    - [merge_sorted_array](arrays/merge_sorted_array.py)
    - [minimum_moves_to_equal_array](arrays/minimum_moves_to_equal_array.py)
    - [min_moves_to_equal_elements](arrays/min_moves_to_equal_elements.py)
    - [move_zeroes](arrays/move_zeroes.py)
    - [my_calendar_two](arrays/my_calendar_two.py)
    - [next_greater_element](arrays/next_greater_element.py)
    - [non_decreasing_array](arrays/non_decreasing_array.py)
    - [number_plus_one](arrays/number_plus_one.py)
    - [partition_array_in_three](arrays/partition_array_in_three.py)
    - [place_flowers](arrays/place_flowers.py)
    - [positions_large_groups](arrays/positions_large_groups.py)
    - [product_of_array_except_self](arrays/product_of_array_except_self.py)
    - [product_of_array_except_self_v2](arrays/product_of_array_except_self_v2.py)
    - [remove_duplicates_two](arrays/remove_duplicates_two.py)
    - [rotate_array](arrays/rotate_array.py)
    - [shortest_unsorted_subarray](arrays/shortest_unsorted_subarray.py)
    - [smallest_range_1](arrays/smallest_range_1.py)
    - [summary_ranges](arrays/summary_ranges.py)
    - [sum_after_queries](arrays/sum_after_queries.py)
    - [third_max_number](arrays/third_max_number.py)
    - [two_sum_sorted_array](arrays/two_sum_sorted_array.py)
    - [wiggle_sort](arrays/wiggle_sort.py)

  - [backtracking](backtracking)
    - [binary_watch](backtracking/binary_watch.py)
    - [combinations_numbers](backtracking/combinations_numbers.py)
    - [combinations_sum](backtracking/combinations_sum.py)
    - [combinations_sum_four](backtracking/combinations_sum_four.py)
    - [combinations_sum_four_v2](backtracking/combinations_sum_four_v2.py)
    - [combinations_sum_four_v3](backtracking/combinations_sum_four_v3.py)
    - [combinations_sum_three](backtracking/combinations_sum_three.py)
    - [combinations_sum_two](backtracking/combinations_sum_two.py)
    - [decoded_string_at_index](backtracking/decoded_string_at_index.py)
    - [generate_paranthesis](backtracking/generate_paranthesis.py)
    - [letter_case_permutations](backtracking/letter_case_permutations.py)
    - [letter_case_permutations_v2](backtracking/letter_case_permutations_v2.py)
    - [letter_combinations](backtracking/letter_combinations.py)
    - [matchsticks_to_square](backtracking/matchsticks_to_square.py)
    - [NestedIterator](backtracking/NestedIterator.py)
    - [n_queens](backtracking/n_queens.py)
    - [palindrome_partition](backtracking/palindrome_partition.py)
    - [palindrome_partition_v2](backtracking/palindrome_partition_v2.py)
    - [permutations_one](backtracking/permutations_one.py)
    - [permutations_two](backtracking/permutations_two.py)
    - [permutations_two_v2](backtracking/permutations_two_v2.py)
    - [permutation_sequence](backtracking/permutation_sequence.py)
    - [restore_ip_addresses](backtracking/restore_ip_addresses.py)
    - [subsets](backtracking/subsets.py)
    - [subsets_duplicates](backtracking/subsets_duplicates.py)
    - [sudoku_solver](backtracking/sudoku_solver.py)
    - [total_queens](backtracking/total_queens.py)
    - [valid_time](backtracking/valid_time.py)

  - [binarysearch](binarysearch)
    - [arranging_coins](binarysearch/arranging_coins.py)
    - [binary_search](binarysearch/binary_search.py)
    - [count_smaller](binarysearch/count_smaller.py)
    - [find_k_closest](binarysearch/find_k_closest.py)
    - [find_peak](binarysearch/find_peak.py)
    - [find_right_interval](binarysearch/find_right_interval.py)
    - [first_bad](binarysearch/first_bad.py)
    - [four_sum_count](binarysearch/four_sum_count.py)
    - [guess_number](binarysearch/guess_number.py)
    - [heaters](binarysearch/heaters.py)
    - [h_index](binarysearch/h_index.py)
    - [koko_eating_speed](binarysearch/koko_eating_speed.py)
    - [koko_eating_speed_v2](binarysearch/koko_eating_speed_v2.py)
    - [minimum_size_subarray](binarysearch/minimum_size_subarray.py)
    - [minimum_size_subarray_v2](binarysearch/minimum_size_subarray_v2.py)
    - [minimum_size_subarray_v3](binarysearch/minimum_size_subarray_v3.py)
    - [min_in_rotated_sorted_array](binarysearch/min_in_rotated_sorted_array.py)
    - [next_greater_letter](binarysearch/next_greater_letter.py)
    - [peak_index_mountain_array](binarysearch/peak_index_mountain_array.py)
    - [random_pick_with_weight](binarysearch/random_pick_with_weight.py)
    - [search_2d_matrix](binarysearch/search_2d_matrix.py)
    - [search_2d_matrix_2](binarysearch/search_2d_matrix_2.py)
    - [search_2d_matrix_2_v2](binarysearch/search_2d_matrix_2_v2.py)
    - [search_insert_position](binarysearch/search_insert_position.py)
    - [search_range](binarysearch/search_range.py)
    - [search_rotated_array](binarysearch/search_rotated_array.py)
    - [search_rotated_array_2](binarysearch/search_rotated_array_2.py)
    - [sqrt_number](binarysearch/sqrt_number.py)
    - [sum_square_numbers](binarysearch/sum_square_numbers.py)
    - [sum_square_numbers_v2](binarysearch/sum_square_numbers_v2.py)
    - [valid_perfect_square](binarysearch/valid_perfect_square.py)

  - [bits](bits)
    - [binary_gap](bits/binary_gap.py)
    - [binary_gap_v2](bits/binary_gap_v2.py)
    - [bitwise_and_range](bits/bitwise_and_range.py)
    - [bitwise_compliment](bits/bitwise_compliment.py)
    - [bitwise_compliment_v2](bits/bitwise_compliment_v2.py)
    - [counting_bits](bits/counting_bits.py)
    - [counting_bits_v2](bits/counting_bits_v2.py)
    - [counting_bits_v3](bits/counting_bits_v3.py)
    - [count_set_bits_prime](bits/count_set_bits_prime.py)
    - [count_set_bits_prime_v2](bits/count_set_bits_prime_v2.py)
    - [count_set_bits_prime_v3](bits/count_set_bits_prime_v3.py)
    - [find_max_xor_pair](bits/find_max_xor_pair.py)
    - [gray_code](bits/gray_code.py)
    - [hamming_weight](bits/hamming_weight.py)
    - [hamming_weight_v2](bits/hamming_weight_v2.py)
    - [is_one_bit_character](bits/is_one_bit_character.py)
    - [is_one_bit_character_v2](bits/is_one_bit_character_v2.py)
    - [max_product_word_lengths](bits/max_product_word_lengths.py)
    - [max_product_word_lengths_v2](bits/max_product_word_lengths_v2.py)
    - [max_product_word_lengths_v3](bits/max_product_word_lengths_v3.py)
    - [number_with_alternating_bits](bits/number_with_alternating_bits.py)
    - [number_with_alternating_bits_v2](bits/number_with_alternating_bits_v2.py)
    - [prefix_divisible](bits/prefix_divisible.py)
    - [prefix_divisible_v2](bits/prefix_divisible_v2.py)
    - [prefix_divisible_v3](bits/prefix_divisible_v3.py)
    - [reverse_bits](bits/reverse_bits.py)
    - [single_number](bits/single_number.py)
    - [single_number_three](bits/single_number_three.py)
    - [single_number_twice](bits/single_number_twice.py)
    - [sum_two_numbers](bits/sum_two_numbers.py)
    - [total_hamming_distance](bits/total_hamming_distance.py)
    - [total_hamming_distance_v2](bits/total_hamming_distance_v2.py)

  - [bst](bst)
    - [bst_implementation](bst/bst_implementation.py)
    - [bst_iterator](bst/bst_iterator.py)
    - [bst_to_greater_sum_tree](bst/bst_to_greater_sum_tree.py)
    - [delete_node](bst/delete_node.py)
    - [find_mode_bst](bst/find_mode_bst.py)
    - [increasing_order_search_tree](bst/increasing_order_search_tree.py)
    - [insert_into_bst](bst/insert_into_bst.py)
    - [kth_smallest_element](bst/kth_smallest_element.py)
    - [list_to_bst](bst/list_to_bst.py)
    - [lowest_common_ancestor_bst](bst/lowest_common_ancestor_bst.py)
    - [minimum_diff_bst](bst/minimum_diff_bst.py)
    - [min_distance_bst](bst/min_distance_bst.py)
    - [my_calendar](bst/my_calendar.py)
    - [range_sum_bst](bst/range_sum_bst.py)
    - [recover_bst](bst/recover_bst.py)
    - [search_bst](bst/search_bst.py)
    - [two_sum_bst](bst/two_sum_bst.py)
    - [validate_bst](bst/validate_bst.py)
    - [best_sight_seeing_pair](dp/best_sight_seeing_pair.py)
    - [bitonic_subsequence](dp/bitonic_subsequence.py)
    - [box_stacking](dp/box_stacking.py)
    - [capacity_to_ship_packages](dp/capacity_to_ship_packages.py)
    - [climbing_stairs](dp/climbing_stairs.py)
    - [coin_sum_infinite](dp/coin_sum_infinite.py)
    - [continuous_subarray_sum](dp/continuous_subarray_sum.py)
    - [count_number_without_consecutive_ones](dp/count_number_without_consecutive_ones.py)
    - [decode_ways](dp/decode_ways.py)
    - [delete_operations_for_two_strings](dp/delete_operations_for_two_strings.py)
    - [distinct_subsequences](dp/distinct_subsequences.py)
    - [dungeon_princess](dp/dungeon_princess.py)
    - [edit_distance](dp/edit_distance.py)
    - [fibonacci](dp/fibonacci.py)
    - [flip_array](dp/flip_array.py)
    - [house_robber](dp/house_robber.py)
    - [integer_replacement](dp/integer_replacement.py)
    - [interleaving_strings](dp/interleaving_strings.py)
    - [jump_game](dp/jump_game.py)
    - [jump_game_II](dp/jump_game_II.py)
    - [kth_grammar](dp/kth_grammar.py)
    - [longest_common_subsequence](dp/longest_common_subsequence.py)
    - [longest_increasing_subsequence](dp/longest_increasing_subsequence.py)
    - [longest_palindromic_subsequence](dp/longest_palindromic_subsequence.py)
    - [matrix_chain_multiplication](dp/matrix_chain_multiplication.py)
    - [maximum_sum_two_non_overlapping_subarray](dp/maximum_sum_two_non_overlapping_subarray.py)
    - [max_crossed_lines](dp/max_crossed_lines.py)
    - [max_product_subarray](dp/max_product_subarray.py)
    - [max_sum_without_adjacent_elements](dp/max_sum_without_adjacent_elements.py)
    - [minimum_path_sum](dp/minimum_path_sum.py)
    - [min_cost_climbing_stairs](dp/min_cost_climbing_stairs.py)
    - [nth_ugly_number](dp/nth_ugly_number.py)
    - [partition_equal_subset](dp/partition_equal_subset.py)
    - [party](dp/party.py)
    - [pascal](dp/pascal.py)
    - [pascal_row](dp/pascal_row.py)
    - [perfect_squares](dp/perfect_squares.py)
    - [pow](dp/pow.py)
    - [range_sum_query](dp/range_sum_query.py)
    - [range_sum_query_2d](dp/range_sum_query_2d.py)
    - [range_sum_query_mutable](dp/range_sum_query_mutable.py)
    - [repeating_subsequence](dp/repeating_subsequence.py)
    - [russian_doll](dp/russian_doll.py)
    - [scramble_string](dp/scramble_string.py)
    - [super_ugly_number](dp/super_ugly_number.py)
    - [triangle_min_path](dp/triangle_min_path.py)
    - [unique_bst](dp/unique_bst.py)
    - [unique_paths](dp/unique_paths.py)
    - [unique_paths_with_obstacle](dp/unique_paths_with_obstacle.py)
    - [zero_one_matrix](dp/zero_one_matrix.py)
    - [accounts_merge](graphs/accounts_merge.py)
    - [bt_right_view](graphs/bt_right_view.py)
    - [clone_graph](graphs/clone_graph.py)
    - [color_the_border](graphs/color_the_border.py)
    - [concatenated_words](graphs/concatenated_words.py)
    - [course_order](graphs/course_order.py)
    - [employee_importance](graphs/employee_importance.py)
    - [flood_fill](graphs/flood_fill.py)
    - [flower_planting_with_no_adjacent](graphs/flower_planting_with_no_adjacent.py)
    - [friend_circle](graphs/friend_circle.py)
    - [graph_implementation](graphs/graph_implementation.py)
    - [house_robber_three](graphs/house_robber_three.py)
    - [is_bipartate](graphs/is_bipartate.py)
    - [keys_and_rooms](graphs/keys_and_rooms.py)
    - [longest_increasing_path_matrix](graphs/longest_increasing_path_matrix.py)
    - [make_larger_island](graphs/make_larger_island.py)
    - [maximum_sum](graphs/maximum_sum.py)
    - [max_area_island](graphs/max_area_island.py)
    - [minesweeper](graphs/minesweeper.py)
    - [minimum_height_trees](graphs/minimum_height_trees.py)
    - [min_genetic_mutations](graphs/min_genetic_mutations.py)
    - [network_delay_time](graphs/network_delay_time.py)
    - [nodes_at_distance](graphs/nodes_at_distance.py)
    - [number_islands](graphs/number_islands.py)
    - [number_of_enclaves](graphs/number_of_enclaves.py)
    - [number_of_sqaureful_arrays](graphs/number_of_sqaureful_arrays.py)
    - [pacific_atlantic_water_flow](graphs/pacific_atlantic_water_flow.py)
    - [redundant_connection](graphs/redundant_connection.py)
    - [regions_cut_by_slashes](graphs/regions_cut_by_slashes.py)
    - [regular_expression_match](graphs/regular_expression_match.py)
    - [regular_expression_two](graphs/regular_expression_two.py)
    - [rotton_oranges](graphs/rotton_oranges.py)
    - [shortest_bridge](graphs/shortest_bridge.py)
    - [shortest_path_binary_matrix](graphs/shortest_path_binary_matrix.py)
    - [surround_region](graphs/surround_region.py)
    - [town_judge](graphs/town_judge.py)
    - [tushars_birthday](graphs/tushars_birthday.py)
    - [unique_paths_III](graphs/unique_paths_III.py)
    - [water_and_jug](graphs/water_and_jug.py)
    - [word_ladder](graphs/word_ladder.py)
    - [word_ladder_two](graphs/word_ladder_two.py)
    - [word_ladder_v2](graphs/word_ladder_v2.py)
    - [word_search](graphs/word_search.py)
    - [burst_balloons](greedy/burst_balloons.py)
    - [di_string_match](greedy/di_string_match.py)
    - [dota2_senate](greedy/dota2_senate.py)
    - [fair_candy_swap](greedy/fair_candy_swap.py)
    - [is_subsequence](greedy/is_subsequence.py)
    - [make_paran_valid](greedy/make_paran_valid.py)
    - [maximize_sum_array](greedy/maximize_sum_array.py)
    - [max_chunks_to_make_sorted](greedy/max_chunks_to_make_sorted.py)
    - [max_chunks_to_make_sorted_II](greedy/max_chunks_to_make_sorted_II.py)
    - [moving_stones](greedy/moving_stones.py)
    - [non_overlapping_intervals](greedy/non_overlapping_intervals.py)
    - [queue_reconstruction_by_height](greedy/queue_reconstruction_by_height.py)
    - [relative_ranks](greedy/relative_ranks.py)
    - [remove_outermost_parantheses](greedy/remove_outermost_parantheses.py)
    - [reorganize_string](greedy/reorganize_string.py)
    - [two_city_scheduling](greedy/two_city_scheduling.py)
    - [banned_words](hashtables/banned_words.py)
    - [boomerang_points](hashtables/boomerang_points.py)
    - [bulls_and_cows](hashtables/bulls_and_cows.py)
    - [contiguous_array](hashtables/contiguous_array.py)
    - [deck_of_cards](hashtables/deck_of_cards.py)
    - [distant_barcodes](hashtables/distant_barcodes.py)
    - [encode_decode](hashtables/encode_decode.py)
    - [expressive_words](hashtables/expressive_words.py)
    - [find_and_replace_pattern](hashtables/find_and_replace_pattern.py)
    - [find_common_characters](hashtables/find_common_characters.py)
    - [four_sum](hashtables/four_sum.py)
    - [fraction_to_decimal](hashtables/fraction_to_decimal.py)
    - [group_anagrams](hashtables/group_anagrams.py)
    - [hashmap](hashtables/hashmap.py)
    - [hashmap_implementation](hashtables/hashmap_implementation.py)
    - [hashset](hashtables/hashset.py)
    - [insert_delete_random](hashtables/insert_delete_random.py)
    - [insert_delete_random_duplicates](hashtables/insert_delete_random_duplicates.py)
    - [keyboard_row](hashtables/keyboard_row.py)
    - [largest_triangle_area](hashtables/largest_triangle_area.py)
    - [lemonade_change](hashtables/lemonade_change.py)
    - [longest_consecutive_sequence](hashtables/longest_consecutive_sequence.py)
    - [longest_word_dictionary](hashtables/longest_word_dictionary.py)
    - [lru_cache](hashtables/lru_cache.py)
    - [magic_dictionary](hashtables/magic_dictionary.py)
    - [minimum_index_sum_of_two_lists](hashtables/minimum_index_sum_of_two_lists.py)
    - [n_repeated_elements](hashtables/n_repeated_elements.py)
    - [pairs_with_sum](hashtables/pairs_with_sum.py)
    - [powerful_integers](hashtables/powerful_integers.py)
    - [repeated_dna_sequences](hashtables/repeated_dna_sequences.py)
    - [shortest_completing_word](hashtables/shortest_completing_word.py)
    - [shuffle_array](hashtables/shuffle_array.py)
    - [sort_by_count](hashtables/sort_by_count.py)
    - [subdomain_visit_count](hashtables/subdomain_visit_count.py)
    - [substring_concat](hashtables/substring_concat.py)
    - [three_sum](hashtables/three_sum.py)
    - [two_sum](hashtables/two_sum.py)
    - [uncommon_words](hashtables/uncommon_words.py)
    - [valid_sudoku](hashtables/valid_sudoku.py)
    - [verifying_alien_dictionary](hashtables/verifying_alien_dictionary.py)
    - [word_pattern](hashtables/word_pattern.py)
    - [word_subsets](hashtables/word_subsets.py)
    - [check_valid_triangle](heaps/check_valid_triangle.py)
    - [design_twitter](heaps/design_twitter.py)
    - [heap_implementation](heaps/heap_implementation.py)
    - [kth_largest](heaps/kth_largest.py)
    - [kth_largest_in_stream](heaps/kth_largest_in_stream.py)
    - [kth_smallest_in_sorted_matrix](heaps/kth_smallest_in_sorted_matrix.py)
    - [k_most_frequent](heaps/k_most_frequent.py)
    - [k_pairs_with_smallest_sums](heaps/k_pairs_with_smallest_sums.py)
    - [last_stone_weight](heaps/last_stone_weight.py)
    - [median_of_stream](heaps/median_of_stream.py)
    - [priority_queue_implementation](heaps/priority_queue_implementation.py)
    - [sliding_window_median](heaps/sliding_window_median.py)
    - [top_k_frequent_words](heaps/top_k_frequent_words.py)
    - [add_two_numbers](linkedlist/add_two_numbers.py)
    - [add_two_numbers_II](linkedlist/add_two_numbers_II.py)
    - [delete_duplicates](linkedlist/delete_duplicates.py)
    - [delete_duplicates_all](linkedlist/delete_duplicates_all.py)
    - [delete_node_without_head](linkedlist/delete_node_without_head.py)
    - [insertion_sort_list](linkedlist/insertion_sort_list.py)
    - [insertion_sort_list_geeks](linkedlist/insertion_sort_list_geeks.py)
    - [intersection](linkedlist/intersection.py)
    - [intersection_geeks](linkedlist/intersection_geeks.py)
    - [linkedlist](linkedlist/linkedlist.py)
    - [linked_cycle](linkedlist/linked_cycle.py)
    - [linked_list_cycle_II](linkedlist/linked_list_cycle_II.py)
    - [linked_list_random](linkedlist/linked_list_random.py)
    - [list_palindrome](linkedlist/list_palindrome.py)
    - [merge_k_lists](linkedlist/merge_k_lists.py)
    - [merge_two_lists](linkedlist/merge_two_lists.py)
    - [middle_linked_list](linkedlist/middle_linked_list.py)
    - [next_greater_node](linkedlist/next_greater_node.py)
    - [odd_even_linked_list](linkedlist/odd_even_linked_list.py)
    - [partition_list](linkedlist/partition_list.py)
    - [remove_element](linkedlist/remove_element.py)
    - [remove_nth_end](linkedlist/remove_nth_end.py)
    - [reorder_list](linkedlist/reorder_list.py)
    - [reverse_k_groups](linkedlist/reverse_k_groups.py)
    - [reverse_linkedlist](linkedlist/reverse_linkedlist.py)
    - [reverse_mn](linkedlist/reverse_mn.py)
    - [rotate_list](linkedlist/rotate_list.py)
    - [singly_linked_list_implementation](linkedlist/singly_linked_list_implementation.py)
    - [sort_list](linkedlist/sort_list.py)
    - [split_list_in_parts](linkedlist/split_list_in_parts.py)
    - [swap_pairs](linkedlist/swap_pairs.py)
    - [swap_pairs_v2](linkedlist/swap_pairs_v2.py)
    - [add_binary](math/add_binary.py)
    - [add_digits](math/add_digits.py)
    - [basic_calculator_I](math/basic_calculator_I.py)
    - [basic_calculator_II](math/basic_calculator_II.py)
    - [construct_rectangle](math/construct_rectangle.py)
    - [convert_to_base_7](math/convert_to_base_7.py)
    - [convert_to_hex](math/convert_to_hex.py)
    - [convert_to_number](math/convert_to_number.py)
    - [count_primes](math/count_primes.py)
    - [count_zeroes_factorial](math/count_zeroes_factorial.py)
    - [divide_two_numbers](math/divide_two_numbers.py)
    - [divisor_game](math/divisor_game.py)
    - [elimination_game](math/elimination_game.py)
    - [finding_position](math/finding_position.py)
    - [game_of_nim](math/game_of_nim.py)
    - [hamming_distance](math/hamming_distance.py)
    - [hamming_distance_v2](math/hamming_distance_v2.py)
    - [happy_numbers](math/happy_numbers.py)
    - [happy_numbers_v2](math/happy_numbers_v2.py)
    - [integer_to_english_words](math/integer_to_english_words.py)
    - [intersection_two_arrays](math/intersection_two_arrays.py)
    - [largest_triangle_area](math/largest_triangle_area.py)
    - [letter_tile_possibilities](math/letter_tile_possibilities.py)
    - [majority_element](math/majority_element.py)
    - [max_points_on_line](math/max_points_on_line.py)
    - [minimum_area_rectangle](math/minimum_area_rectangle.py)
    - [min_time_difference](math/min_time_difference.py)
    - [missing_number](math/missing_number.py)
    - [next_greater_III](math/next_greater_III.py)
    - [next_permutation](math/next_permutation.py)
    - [nth_digit](math/nth_digit.py)
    - [num_to_col](math/num_to_col.py)
    - [perfect_number](math/perfect_number.py)
    - [power_of_two](math/power_of_two.py)
    - [reach_a_number](math/reach_a_number.py)
    - [rectangle_overlap](math/rectangle_overlap.py)
    - [self_dividing_numbers](math/self_dividing_numbers.py)
    - [smallest_integer_divisible_by_k](math/smallest_integer_divisible_by_k.py)
    - [statistics_from_sample](math/statistics_from_sample.py)
    - [total_time](math/total_time.py)
    - [ugly_numbers](math/ugly_numbers.py)
    - [valid_boomerang](math/valid_boomerang.py)
    - [valid_number](math/valid_number.py)
    - [valid_triangle_number](math/valid_triangle_number.py)
    - [battleships_in_a_board](matrix/battleships_in_a_board.py)
    - [brick_wall](matrix/brick_wall.py)
    - [flip_image](matrix/flip_image.py)
    - [game_of_life](matrix/game_of_life.py)
    - [image_smoother](matrix/image_smoother.py)
    - [island_perimeter](matrix/island_perimeter.py)
    - [magic_squares_in_grid](matrix/magic_squares_in_grid.py)
    - [matrix_cells_distance](matrix/matrix_cells_distance.py)
    - [range_addition](matrix/range_addition.py)
    - [range_addition_v2](matrix/range_addition_v2.py)
    - [reshape_matrix](matrix/reshape_matrix.py)
    - [robot_bounded_circle](matrix/robot_bounded_circle.py)
    - [rook_captures](matrix/rook_captures.py)
    - [rotate_image](matrix/rotate_image.py)
    - [set_matrix_zeros](matrix/set_matrix_zeros.py)
    - [spiral_matrix](matrix/spiral_matrix.py)
    - [spiral_matrix_generate](matrix/spiral_matrix_generate.py)
    - [spiral_matrix_III](matrix/spiral_matrix_III.py)
    - [toeplitz_matrix](matrix/toeplitz_matrix.py)
    - [transpose_matrix](matrix/transpose_matrix.py)
    - [walking_robot_simulation](matrix/walking_robot_simulation.py)
    - [car_pooling](queues/car_pooling.py)
    - [circular_deque_implementation](queues/circular_deque_implementation.py)
    - [circular_queue_implementation](queues/circular_queue_implementation.py)
    - [gas_station](queues/gas_station.py)
    - [max_sliding_window](queues/max_sliding_window.py)
    - [queue_implementation](queues/queue_implementation.py)
    - [queue_using_stacks](queues/queue_using_stacks.py)
    - [rotate_string](queues/rotate_string.py)
    - [stack_using_queues](queues/stack_using_queues.py)
    - [segment_trees](segtrees/segment_trees.py)
    - [bubble_sort](sort/bubble_sort.py)
    - [delete_columns_to_make_sorted](sort/delete_columns_to_make_sorted.py)
    - [height_checker](sort/height_checker.py)
    - [insertion_sort](sort/insertion_sort.py)
    - [k_closest_points_to_origin](sort/k_closest_points_to_origin.py)
    - [lexical_numbers](sort/lexical_numbers.py)
    - [longest_harmonious_sequence](sort/longest_harmonious_sequence.py)
    - [max_gap](sort/max_gap.py)
    - [merge_sort](sort/merge_sort.py)
    - [most_profit_workers](sort/most_profit_workers.py)
    - [quickSort](sort/quickSort.py)
    - [quick_sort](sort/quick_sort.py)
    - [reorder_logs](sort/reorder_logs.py)
    - [selection_sort](sort/selection_sort.py)
    - [sort_array_parity_II](sort/sort_array_parity_II.py)
    - [sort_by_parity](sort/sort_by_parity.py)
    - [sort_three_colors](sort/sort_three_colors.py)
    - [asteroid_collinsion](stack/asteroid_collinsion.py)
    - [baseball_game](stack/baseball_game.py)
    - [daily_temperatures](stack/daily_temperatures.py)
    - [duplicate_removal](stack/duplicate_removal.py)
    - [evaluate_reverse_polish_notation](stack/evaluate_reverse_polish_notation.py)
    - [exclusive_fuction_time](stack/exclusive_fuction_time.py)
    - [largest_rectangle_in_histogram](stack/largest_rectangle_in_histogram.py)
    - [longest_valid_paranthesis](stack/longest_valid_paranthesis.py)
    - [maximal_rectangle](stack/maximal_rectangle.py)
    - [min_stack](stack/min_stack.py)
    - [next_greater_element_II](stack/next_greater_element_II.py)
    - [one_three_two_pattern](stack/one_three_two_pattern.py)
    - [remove_k_digits](stack/remove_k_digits.py)
    - [simplify_path](stack/simplify_path.py)
    - [smallest_distinct_seq](stack/smallest_distinct_seq.py)
    - [trap_rainwater](stack/trap_rainwater.py)
    - [validate_stack_sequence](stack/validate_stack_sequence.py)
    - [valid_paran](stack/valid_paran.py)
    - [add_binary](strings/add_binary.py)
    - [add_strings](strings/add_strings.py)
    - [backspace_compare](strings/backspace_compare.py)
    - [buddy_strings](strings/buddy_strings.py)
    - [camelcase_matching](strings/camelcase_matching.py)
    - [compare_version_numbers](strings/compare_version_numbers.py)
    - [complex_number_multiplication](strings/complex_number_multiplication.py)
    - [count_binary_strings](strings/count_binary_strings.py)
    - [count_say](strings/count_say.py)
    - [decode_string](strings/decode_string.py)
    - [defanged_ip_address](strings/defanged_ip_address.py)
    - [detect_capital](strings/detect_capital.py)
    - [find_all_anagrams](strings/find_all_anagrams.py)
    - [find_and_replace](strings/find_and_replace.py)
    - [find_duplicate_files](strings/find_duplicate_files.py)
    - [first_unique_character](strings/first_unique_character.py)
    - [gcd_of_string](strings/gcd_of_string.py)
    - [goat_latin](strings/goat_latin.py)
    - [int_to_roman](strings/int_to_roman.py)
    - [isomorphic](strings/isomorphic.py)
    - [jewels](strings/jewels.py)
    - [largest_number](strings/largest_number.py)
    - [length_of_last_word](strings/length_of_last_word.py)
    - [licence_key_reformatting](strings/licence_key_reformatting.py)
    - [longest_common_prefix](strings/longest_common_prefix.py)
    - [longest_palindrome](strings/longest_palindrome.py)
    - [longest_palin_substring](strings/longest_palin_substring.py)
    - [longest_substring_without_repeating](strings/longest_substring_without_repeating.py)
    - [longest_substring_with_k_chars](strings/longest_substring_with_k_chars.py)
    - [longest_uncommon_seq](strings/longest_uncommon_seq.py)
    - [long_pressed_name](strings/long_pressed_name.py)
    - [magical_strings](strings/magical_strings.py)
    - [minimum_window_string](strings/minimum_window_string.py)
    - [multiply_strings](strings/multiply_strings.py)
    - [number_of_lines_to_write_string](strings/number_of_lines_to_write_string.py)
    - [number_of_segments_string](strings/number_of_segments_string.py)
    - [occurances_after_bigram](strings/occurances_after_bigram.py)
    - [optimal_division](strings/optimal_division.py)
    - [palindrome](strings/palindrome.py)
    - [permutations_in_string](strings/permutations_in_string.py)
    - [ransom_note](strings/ransom_note.py)
    - [remove_comments](strings/remove_comments.py)
    - [remove_duplicate_letters](strings/remove_duplicate_letters.py)
    - [repeated_string_match](strings/repeated_string_match.py)
    - [repeated_substring_pattern](strings/repeated_substring_pattern.py)
    - [reverse_int](strings/reverse_int.py)
    - [reverse_only_letters](strings/reverse_only_letters.py)
    - [reverse_string](strings/reverse_string.py)
    - [reverse_string_II](strings/reverse_string_II.py)
    - [reverse_string_words](strings/reverse_string_words.py)
    - [reverse_vowels_strings](strings/reverse_vowels_strings.py)
    - [reverse_words_III](strings/reverse_words_III.py)
    - [robot_origin](strings/robot_origin.py)
    - [roman_to_int](strings/roman_to_int.py)
    - [rotated_digits](strings/rotated_digits.py)
    - [rotated_digits_v2](strings/rotated_digits_v2.py)
    - [shifting_letters](strings/shifting_letters.py)
    - [shortest_distance_to_character](strings/shortest_distance_to_character.py)
    - [shortest_palindrome](strings/shortest_palindrome.py)
    - [string_compression](strings/string_compression.py)
    - [string_to_integer](strings/string_to_integer.py)
    - [strstr](strings/strstr.py)
    - [to_lower](strings/to_lower.py)
    - [unique_email](strings/unique_email.py)
    - [unique_morse_code](strings/unique_morse_code.py)
    - [valid_anagram](strings/valid_anagram.py)
    - [valid_ip](strings/valid_ip.py)
    - [valid_ip_v2](strings/valid_ip_v2.py)
    - [valid_palin](strings/valid_palin.py)
    - [valid_palindrome_II](strings/valid_palindrome_II.py)
    - [valid_string_after_subs](strings/valid_string_after_subs.py)
    - [zigzag_conversion](strings/zigzag_conversion.py)
    - [add_row_to_tree](trees/add_row_to_tree.py)
    - [array_bst](trees/array_bst.py)
    - [average_levels](trees/average_levels.py)
    - [bst_to_greater_tree](trees/bst_to_greater_tree.py)
    - [build_tree_postorder](trees/build_tree_postorder.py)
    - [construct_pre_in](trees/construct_pre_in.py)
    - [count_complete_tree_nodes](trees/count_complete_tree_nodes.py)
    - [cousins_in_binary_trees](trees/cousins_in_binary_trees.py)
    - [diameter_binary_tree](trees/diameter_binary_tree.py)
    - [find_bottom_left](trees/find_bottom_left.py)
    - [flatten_binary_tree_to_linked_list](trees/flatten_binary_tree_to_linked_list.py)
    - [inorder](trees/inorder.py)
    - [invert_tree](trees/invert_tree.py)
    - [is_balanced](trees/is_balanced.py)
    - [largest_value_level](trees/largest_value_level.py)
    - [lca_deepest_leaves](trees/lca_deepest_leaves.py)
    - [left_similar_trees](trees/left_similar_trees.py)
    - [level_order_one](trees/level_order_one.py)
    - [level_order_two](trees/level_order_two.py)
    - [lowest_common_ancestor](trees/lowest_common_ancestor.py)
    - [maximum_diff_between_ancestor_and_node](trees/maximum_diff_between_ancestor_and_node.py)
    - [maximum_path_sum](trees/maximum_path_sum.py)
    - [max_depth](trees/max_depth.py)
    - [max_depth_n_ary](trees/max_depth_n_ary.py)
    - [max_subtree](trees/max_subtree.py)
    - [merge_two_trees](trees/merge_two_trees.py)
    - [min_depth](trees/min_depth.py)
    - [most_frequent_subtree_sum](trees/most_frequent_subtree_sum.py)
    - [nary_level_order](trees/nary_level_order.py)
    - [nodes_at_distance_k](trees/nodes_at_distance_k.py)
    - [n_ary_postorder](trees/n_ary_postorder.py)
    - [n_ary_preorder](trees/n_ary_preorder.py)
    - [path_sum](trees/path_sum.py)
    - [path_sum_all](trees/path_sum_all.py)
    - [path_sum_III](trees/path_sum_III.py)
    - [populate_next_right_pointer](trees/populate_next_right_pointer.py)
    - [postorder](trees/postorder.py)
    - [preorder](trees/preorder.py)
    - [same_tree](trees/same_tree.py)
    - [second_minimum_node](trees/second_minimum_node.py)
    - [serialize_tree](trees/serialize_tree.py)
    - [subtree_of_another_tree](trees/subtree_of_another_tree.py)
    - [sum_of_left_leaves](trees/sum_of_left_leaves.py)
    - [sum_root_to_leafs](trees/sum_root_to_leafs.py)
    - [sum_root_to_leaf_paths](trees/sum_root_to_leaf_paths.py)
    - [symmetric](trees/symmetric.py)
    - [tilt_tree](trees/tilt_tree.py)
    - [tree_implementation](trees/tree_implementation.py)
    - [tree_paths](trees/tree_paths.py)
    - [trie_implementation](trees/trie_implementation.py)
    - [univalue_tree](trees/univalue_tree.py)
    - [verify_tree_serialization](trees/verify_tree_serialization.py)
    - [zigzag_level_order](trees/zigzag_level_order.py)
    - [longest_word_dictionary](trie/longest_word_dictionary.py)
    - [replace_words](trie/replace_words.py)
    - [trie_implementation](trie/trie_implementation.py)
    - [word_search_II](trie/word_search_II.py)
    - [container_with_most_water](twopointers/container_with_most_water.py)
    - [find_duplicate_number](twopointers/find_duplicate_number.py)
    - [longest_repeating_character_replacement](twopointers/longest_repeating_character_replacement.py)
    - [longest_word_in_dictionary](twopointers/longest_word_in_dictionary.py)
    - [remove_duplicates](twopointers/remove_duplicates.py)
    - [remove_element](twopointers/remove_element.py)
    - [squares_of_sorted_array](twopointers/squares_of_sorted_array.py)
    - [three_sum_closest](twopointers/three_sum_closest.py)



## Contributors
 seanlab1, seanlab3
 email: newstein33@gmail.com

