# -*- coding: utf-8 -*-

"""
firstlanguage_python

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
import os
from firstlanguage_python.utilities.schema_validator_wrapper import SchemaValidatorWrapper
from jsonschema import ValidationError
from firstlanguage_python.api_helper import APIHelper


class Input8(object):

    """Implementation of the 'Input8' model.

    TODO: type model description here.

    Attributes:
        url (string): URL of the CSV file.
        send_back_rows (bool): Send back original rows from which the answer
            was extracted. Input either true or false.
        questions (list of string): Array of questions

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "url": 'url',
        "send_back_rows": 'sendBackRows',
        "questions": 'questions'
    }

    def __init__(self,
                 url=None,
                 send_back_rows=None,
                 questions=None):
        """Constructor for the Input8 class"""

        # Initialize members of the class
        self.url = url
        self.send_back_rows = send_back_rows
        self.questions = questions

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """
        if dictionary is None:
            return None

        # Extract variables from the dictionary
        url = dictionary.get('url')
        send_back_rows = dictionary.get('sendBackRows')
        questions = dictionary.get('questions')

        # Return an object of this model
        return cls(url,
                   send_back_rows,
                   questions)

    @classmethod
    def validate(cls, val):
        """Validates value against class schema

        Args:
            val: the value to be validated

        Returns:
            boolean : if value is valid against schema.

        """
        return SchemaValidatorWrapper.getValidator(APIHelper.get_schema_path(os.path.abspath(__file__))).is_valid(val)
