import { IRole, ManagedPolicy, Role } from 'aws-cdk-lib/aws-iam';
import { Construct } from 'constructs';
import { NotebookUserOptions } from './notebook-user';
/**
 * @internal
 * Create a session policy for each user scoped down to the managed endpoint
 * @returns Return the ARN of the policy created
 */
export declare function createUserSessionPolicy(scope: Construct, user: NotebookUserOptions, studioServiceRoleName: string, managedEndpointArns: string[], studioId: string): string;
/**
 * @internal
 * Create a policy for the EMR USER Role
 * @returns Return the ARN of the policy created
 */
export declare function createStudioUserRolePolicy(scope: Construct, studioName: string, studioServiceRoleName: string): string;
/**
 * @internal
 * Add an inline policy to the role passed by the user
 */
export declare function addServiceRoleInlinePolicy(scope: Construct, studioServiceRoleArn: string, bucketName: string): IRole;
/**
 * @internal
 * Create a policy for the EMR Service Role
 * The policy allow access only to a single bucket to store notebooks
 * @returns Return the ARN of the policy created
 */
export declare function createStudioServiceRolePolicy(scope: Construct, keyArn: string, bucketName: string, studioName: string): string;
/**
 * @internal
 * Create a policy for the role to which a user federate
 * Called when working in IAM auth mode with Federated IdP
 * @returns Return the ARN of the policy created
 */
export declare function createIAMRolePolicy(scope: Construct, user: NotebookUserOptions, studioServiceRoleName: string, managedEndpointArns: string[], studioId: string): ManagedPolicy;
/**
 * @internal
 * Create the role to which a user federate
 * Called when working in IAM auth mode with Federated IdP
 * @returns Return the ARN of the policy created
 */
export declare function createIAMFederatedRole(scope: Construct, iamRolePolicy: ManagedPolicy, federatedIdPArn: string, identityName: string, studioId: string): Role;
