import { Role } from 'aws-cdk-lib/aws-iam';
import { Construct } from 'constructs';
/**
 * GlueDemoRole Construct to automatically setup a new Amazon IAM role to use with AWS Glue jobs.
 * The role is created with AWSGlueServiceRole policy and authorize all actions on S3.
 * If you would like to scope down the permission you should create a new role with a scoped down policy
 * The Construct provides a getOrCreate method for SingletonInstantiation
 */
export declare class GlueDemoRole extends Construct {
    static getOrCreate(scope: Construct): GlueDemoRole;
    readonly iamRole: Role;
    /**
     * Constructs a new instance of the GlueDemoRole class
     * @param {Construct} scope the Scope of the CDK Construct
     * @param {string} id the ID of the CDK Construct
     * @access private
     */
    private constructor();
}
