import { Provider } from 'aws-cdk-lib/custom-resources';
import { Construct } from 'constructs';
/**
* The properties for the EMR Managed Endpoint to create.
*/
export interface EmrEksJobTemplateDefinition {
    /**
     * The name of the job template
     */
    readonly name: string;
    /**
     * The JSON definition of the job template
     */
    readonly jobTemplateData: string;
}
/**
 * A custom resource provider for CRUD operations on Amazon EMR on EKS Managed Endpoints.
 * @private
 */
export declare class EmrEksJobTemplateProvider extends Construct {
    /**
     * The custom resource Provider for creating Amazon EMR Managed Endpoints custom resources
     */
    readonly provider: Provider;
    /**
     * Constructs a new instance of the ManageEndpointProvider. The provider can then be used to create Amazon EMR on EKS Managed Endpoint custom resources
     * @param { Construct} scope the Scope of the CDK Construct
     * @param id the ID of the CDK Construct
     * @private
     */
    constructor(scope: Construct, id: string);
}
