import { Role } from 'aws-cdk-lib/aws-iam';
import { Construct } from 'constructs';
/**
 * Construct extending IAM Role with managed and inline policies for LF admin. Adds this role as LF admin.
 */
export declare class DataMeshWorkflowRole extends Construct {
    readonly role: Role;
    /**
     * Constructs a new instance of the LfAdminRole class.
     * @param {Construct} scope the Scope of the CDK Construct
     * @param {string} id the ID of the CDK Construct
     * @param {RoleProps} props the RoleProps [properties]{@link RoleProps}
     * @access public
     */
    constructor(scope: Construct, id: string);
}
