""" Code is generated by ucloud-model, DO NOT EDIT IT. """


from ucloud.core.typesystem import schema, fields
from ucloud.services.uk8s.schemas import models

""" UK8S API Schema
"""


"""
API: AddUK8SExistingUHost

将预先创建好的云主机加入到UK8S集群，需要注意的是，该云主机依然会执行重装系统的操作。
"""


class AddUK8SExistingUHostRequestSchema(schema.RequestSchema):
    """AddUK8SExistingUHost - 将预先创建好的云主机加入到UK8S集群，需要注意的是，该云主机依然会执行重装系统的操作。"""

    fields = {
        "ClusterId": fields.Str(required=True, dump_to="ClusterId"),
        "DisableSchedule": fields.Bool(
            required=False, dump_to="DisableSchedule"
        ),
        "ImageId": fields.Str(required=False, dump_to="ImageId"),
        "InitScript": fields.Str(required=False, dump_to="InitScript"),
        "Labels": fields.Str(required=False, dump_to="Labels"),
        "MaxPods": fields.Int(required=False, dump_to="MaxPods"),
        "Password": fields.Str(required=True, dump_to="Password"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "SubnetId": fields.Str(required=False, dump_to="SubnetId"),
        "UHostId": fields.Str(required=True, dump_to="UHostId"),
        "UserData": fields.Str(required=False, dump_to="UserData"),
        "Zone": fields.Str(required=False, dump_to="Zone"),
    }


class AddUK8SExistingUHostResponseSchema(schema.ResponseSchema):
    """AddUK8SExistingUHost - 将预先创建好的云主机加入到UK8S集群，需要注意的是，该云主机依然会执行重装系统的操作。"""

    fields = {
        "Message": fields.Str(required=False, load_from="Message"),
    }


"""
API: AddUK8SNodeGroup

添加UK8S节点池
"""


class AddUK8SNodeGroupRequestSchema(schema.RequestSchema):
    """AddUK8SNodeGroup - 添加UK8S节点池"""

    fields = {
        "BootDiskType": fields.Str(required=False, dump_to="BootDiskType"),
        "CPU": fields.Int(required=False, dump_to="CPU"),
        "ChargeType": fields.Str(required=False, dump_to="ChargeType"),
        "ClusterId": fields.Str(required=True, dump_to="ClusterId"),
        "DataDiskSize": fields.Int(required=False, dump_to="DataDiskSize"),
        "DataDiskType": fields.Str(required=False, dump_to="DataDiskType"),
        "GPU": fields.Int(required=False, dump_to="GPU"),
        "GpuType": fields.Str(required=False, dump_to="GpuType"),
        "ImageId": fields.Str(required=False, dump_to="ImageId"),
        "MachineType": fields.Str(required=False, dump_to="MachineType"),
        "Mem": fields.Int(required=False, dump_to="Mem"),
        "MinimalCpuPlatform": fields.Str(
            required=False, dump_to="MinimalCpuPlatform"
        ),
        "NodeGroupName": fields.Str(required=True, dump_to="NodeGroupName"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Tag": fields.Str(required=False, dump_to="Tag"),
        "Zone": fields.Str(required=False, dump_to="Zone"),
    }


class AddUK8SNodeGroupResponseSchema(schema.ResponseSchema):
    """AddUK8SNodeGroup - 添加UK8S节点池"""

    fields = {
        "Message": fields.Str(required=True, load_from="Message"),
        "NodeGroupId": fields.Str(required=True, load_from="NodeGroupId"),
    }


"""
API: AddUK8SPHostNode

为UK8S集群添加一台或多台物理云主机类型的节点。
"""


class AddUK8SPHostNodeRequestSchema(schema.RequestSchema):
    """AddUK8SPHostNode - 为UK8S集群添加一台或多台物理云主机类型的节点。"""

    fields = {
        "ChargeType": fields.Str(required=True, dump_to="ChargeType"),
        "ClusterId": fields.Str(required=True, dump_to="ClusterId"),
        "Count": fields.Int(required=True, dump_to="Count"),
        "DisableSchedule": fields.Bool(
            required=False, dump_to="DisableSchedule"
        ),
        "ImageId": fields.Str(required=False, dump_to="ImageId"),
        "InitScript": fields.Str(required=False, dump_to="InitScript"),
        "Labels": fields.Str(required=False, dump_to="Labels"),
        "MaxPods": fields.Int(required=False, dump_to="MaxPods"),
        "NIC": fields.Str(required=False, dump_to="NIC"),
        "Password": fields.Str(required=True, dump_to="Password"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Quantity": fields.Int(required=False, dump_to="Quantity"),
        "Raid": fields.Str(required=False, dump_to="Raid"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "SubnetId": fields.Str(required=False, dump_to="SubnetId"),
        "Type": fields.Str(required=False, dump_to="Type"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class AddUK8SPHostNodeResponseSchema(schema.ResponseSchema):
    """AddUK8SPHostNode - 为UK8S集群添加一台或多台物理云主机类型的节点。"""

    fields = {
        "Message": fields.Str(required=True, load_from="Message"),
    }


"""
API: AddUK8SUHostNode

为UK8S集群添加一台Node节点，机型类型为云主机
"""


class AddUK8SUHostNodeRequestSchema(schema.RequestSchema):
    """AddUK8SUHostNode - 为UK8S集群添加一台Node节点，机型类型为云主机"""

    fields = {
        "BootDiskType": fields.Str(required=False, dump_to="BootDiskType"),
        "CPU": fields.Int(required=True, dump_to="CPU"),
        "ChargeType": fields.Str(required=True, dump_to="ChargeType"),
        "ClusterId": fields.Str(required=True, dump_to="ClusterId"),
        "Count": fields.Int(required=True, dump_to="Count"),
        "DataDiskSize": fields.Int(required=False, dump_to="DataDiskSize"),
        "DataDiskType": fields.Str(required=False, dump_to="DataDiskType"),
        "DisableSchedule": fields.Bool(
            required=False, dump_to="DisableSchedule"
        ),
        "GPU": fields.Int(required=False, dump_to="GPU"),
        "GpuType": fields.Str(required=False, dump_to="GpuType"),
        "ImageId": fields.Str(required=False, dump_to="ImageId"),
        "InitScript": fields.Str(required=False, dump_to="InitScript"),
        "IsolationGroup": fields.Str(required=False, dump_to="IsolationGroup"),
        "Labels": fields.Str(required=False, dump_to="Labels"),
        "MachineType": fields.Str(required=False, dump_to="MachineType"),
        "MaxPods": fields.Int(required=False, dump_to="MaxPods"),
        "Mem": fields.Int(required=True, dump_to="Mem"),
        "MinmalCpuPlatform": fields.Str(
            required=False, dump_to="MinmalCpuPlatform"
        ),
        "Password": fields.Str(required=True, dump_to="Password"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Quantity": fields.Int(required=False, dump_to="Quantity"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "SubnetId": fields.Str(required=False, dump_to="SubnetId"),
        "UserData": fields.Str(required=False, dump_to="UserData"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class AddUK8SUHostNodeResponseSchema(schema.ResponseSchema):
    """AddUK8SUHostNode - 为UK8S集群添加一台Node节点，机型类型为云主机"""

    fields = {
        "Message": fields.Str(
            required=True, load_from="Message"
        ),  # Deprecated, will be removed at 1.0
        "NodeIds": fields.List(
            fields.Str(), required=False, load_from="NodeIds"
        ),
    }


"""
API: CreateUK8SClusterV2

创建UK8S集群
"""


class CreateUK8SClusterV2ParamKubeProxySchema(schema.RequestSchema):
    """CreateUK8SClusterV2ParamKubeProxy -"""

    fields = {
        "Mode": fields.Str(required=False, dump_to="Mode"),
    }


class CreateUK8SClusterV2ParamMasterSchema(schema.RequestSchema):
    """CreateUK8SClusterV2ParamMaster -"""

    fields = {
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class CreateUK8SClusterV2ParamNodesSchema(schema.RequestSchema):
    """CreateUK8SClusterV2ParamNodes -"""

    fields = {
        "BootDiskType": fields.Str(required=False, dump_to="BootDiskType"),
        "CPU": fields.Int(required=True, dump_to="CPU"),
        "Count": fields.Int(required=True, dump_to="Count"),
        "DataDiskSize": fields.Int(required=False, dump_to="DataDiskSize"),
        "DataDiskType": fields.Str(required=False, dump_to="DataDiskType"),
        "GPU": fields.Int(required=False, dump_to="GPU"),
        "GpuType": fields.Str(required=False, dump_to="GpuType"),
        "IsolationGroup": fields.Str(required=False, dump_to="IsolationGroup"),
        "Labels": fields.Str(required=False, dump_to="Labels"),
        "MachineType": fields.Str(required=True, dump_to="MachineType"),
        "MaxPods": fields.Int(required=False, dump_to="MaxPods"),
        "Mem": fields.Int(required=True, dump_to="Mem"),
        "MinmalCpuPlatform": fields.Str(
            required=False, dump_to="MinmalCpuPlatform"
        ),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class CreateUK8SClusterV2RequestSchema(schema.RequestSchema):
    """CreateUK8SClusterV2 - 创建UK8S集群"""

    fields = {
        "ChargeType": fields.Str(required=False, dump_to="ChargeType"),
        "ClusterName": fields.Str(required=True, dump_to="ClusterName"),
        "ExternalApiServer": fields.Str(
            required=False, dump_to="ExternalApiServer"
        ),
        "ImageId": fields.Str(required=False, dump_to="ImageId"),
        "InitScript": fields.Str(required=False, dump_to="InitScript"),
        "K8sVersion": fields.Str(required=False, dump_to="K8sVersion"),
        "KubeProxy": CreateUK8SClusterV2ParamKubeProxySchema(
            required=False, dump_to="KubeProxy"
        ),
        "Master": fields.List(CreateUK8SClusterV2ParamMasterSchema()),
        "MasterBootDiskType": fields.Str(
            required=False, dump_to="MasterBootDiskType"
        ),
        "MasterCPU": fields.Int(required=True, dump_to="MasterCPU"),
        "MasterDataDiskSize": fields.Int(
            required=False, dump_to="MasterDataDiskSize"
        ),
        "MasterDataDiskType": fields.Str(
            required=False, dump_to="MasterDataDiskType"
        ),
        "MasterIsolationGroup": fields.Str(
            required=False, dump_to="MasterIsolationGroup"
        ),
        "MasterMachineType": fields.Str(
            required=True, dump_to="MasterMachineType"
        ),
        "MasterMem": fields.Int(required=True, dump_to="MasterMem"),
        "MasterMinmalCpuPlatform": fields.Str(
            required=False, dump_to="MasterMinmalCpuPlatform"
        ),
        "Nodes": fields.List(CreateUK8SClusterV2ParamNodesSchema()),
        "Password": fields.Str(required=True, dump_to="Password"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "Quantity": fields.Int(required=False, dump_to="Quantity"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "ServiceCIDR": fields.Str(required=True, dump_to="ServiceCIDR"),
        "SubnetId": fields.Str(required=True, dump_to="SubnetId"),
        "UserData": fields.Str(required=False, dump_to="UserData"),
        "VPCId": fields.Str(required=True, dump_to="VPCId"),
    }


class CreateUK8SClusterV2ResponseSchema(schema.ResponseSchema):
    """CreateUK8SClusterV2 - 创建UK8S集群"""

    fields = {
        "ClusterId": fields.Str(required=True, load_from="ClusterId"),
    }


"""
API: DelUK8SCluster

删除UK8S集群
"""


class DelUK8SClusterRequestSchema(schema.RequestSchema):
    """DelUK8SCluster - 删除UK8S集群"""

    fields = {
        "ClusterId": fields.Str(required=True, dump_to="ClusterId"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "ReleaseUDisk": fields.Bool(required=False, dump_to="ReleaseUDisk"),
    }


class DelUK8SClusterResponseSchema(schema.ResponseSchema):
    """DelUK8SCluster - 删除UK8S集群"""

    fields = {}


"""
API: DelUK8SClusterNodeV2

删除集群中的Node节点，删除前务必先将其中的Pod驱逐。
"""


class DelUK8SClusterNodeV2RequestSchema(schema.RequestSchema):
    """DelUK8SClusterNodeV2 - 删除集群中的Node节点，删除前务必先将其中的Pod驱逐。"""

    fields = {
        "ClusterId": fields.Str(required=True, dump_to="ClusterId"),
        "NodeId": fields.Str(required=True, dump_to="NodeId"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "ReleaseDataUDisk": fields.Bool(
            required=False, dump_to="ReleaseDataUDisk"
        ),
    }


class DelUK8SClusterNodeV2ResponseSchema(schema.ResponseSchema):
    """DelUK8SClusterNodeV2 - 删除集群中的Node节点，删除前务必先将其中的Pod驱逐。"""

    fields = {
        "Message": fields.Str(required=False, load_from="Message"),
    }


"""
API: DescribeUK8SCluster

获取集群信息
"""


class DescribeUK8SClusterRequestSchema(schema.RequestSchema):
    """DescribeUK8SCluster - 获取集群信息"""

    fields = {
        "ClusterId": fields.Str(required=True, dump_to="ClusterId"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
    }


class DescribeUK8SClusterResponseSchema(schema.ResponseSchema):
    """DescribeUK8SCluster - 获取集群信息"""

    fields = {
        "ApiServer": fields.Str(required=False, load_from="ApiServer"),
        "CACert": fields.Str(required=False, load_from="CACert"),
        "ClusterDomain": fields.Str(required=False, load_from="ClusterDomain"),
        "ClusterId": fields.Str(required=True, load_from="ClusterId"),
        "ClusterName": fields.Str(required=True, load_from="ClusterName"),
        "CreateTime": fields.Int(required=False, load_from="CreateTime"),
        "EtcdCert": fields.Str(required=False, load_from="EtcdCert"),
        "EtcdKey": fields.Str(required=False, load_from="EtcdKey"),
        "ExternalApiServer": fields.Str(
            required=False, load_from="ExternalApiServer"
        ),
        "KubeProxy": fields.Str(),
        "MasterCount": fields.Int(required=True, load_from="MasterCount"),
        "MasterList": fields.List(
            models.UhostInfoSchema(), required=False, load_from="MasterList"
        ),
        "NodeCount": fields.Int(required=False, load_from="NodeCount"),
        "NodeList": fields.List(
            models.UhostInfoSchema(), required=False, load_from="NodeList"
        ),
        "PodCIDR": fields.Str(required=True, load_from="PodCIDR"),
        "ServiceCIDR": fields.Str(required=True, load_from="ServiceCIDR"),
        "Status": fields.Str(required=False, load_from="Status"),
        "SubnetId": fields.Str(required=True, load_from="SubnetId"),
        "VPCId": fields.Str(required=True, load_from="VPCId"),
        "Version": fields.Str(required=False, load_from="Version"),
    }


"""
API: DescribeUK8SImage

获取UK8S支持的Node节点操作系统，可基于该操作系统制定自定义镜像
"""


class DescribeUK8SImageRequestSchema(schema.RequestSchema):
    """DescribeUK8SImage - 获取UK8S支持的Node节点操作系统，可基于该操作系统制定自定义镜像"""

    fields = {
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Zone": fields.Str(required=False, dump_to="Zone"),
    }


class DescribeUK8SImageResponseSchema(schema.ResponseSchema):
    """DescribeUK8SImage - 获取UK8S支持的Node节点操作系统，可基于该操作系统制定自定义镜像"""

    fields = {
        "ImageSet": fields.List(
            models.ImageInfoSchema(), required=False, load_from="ImageSet"
        ),
        "Message": fields.Str(required=True, load_from="Message"),
        "PHostImageSet": fields.List(
            models.ImageInfoSchema(), required=False, load_from="PHostImageSet"
        ),
    }


"""
API: DescribeUK8SNode

用于获取 UK8S 节点详情
"""


class DescribeUK8SNodeRequestSchema(schema.RequestSchema):
    """DescribeUK8SNode - 用于获取 UK8S 节点详情"""

    fields = {
        "ClusterId": fields.Str(required=True, dump_to="ClusterId"),
        "Name": fields.Str(required=True, dump_to="Name"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
    }


class DescribeUK8SNodeResponseSchema(schema.ResponseSchema):
    """DescribeUK8SNode - 用于获取 UK8S 节点详情"""

    fields = {
        "Action": fields.Str(required=True, load_from="Action"),
        "AllocatedPodCount": fields.Int(
            required=True, load_from="AllocatedPodCount"
        ),
        "Annotations": fields.List(
            fields.Str(), required=True, load_from="Annotations"
        ),
        "CPUCapacity": fields.Str(required=True, load_from="CPUCapacity"),
        "CPULimits": fields.Str(required=True, load_from="CPULimits"),
        "CPULimitsFraction": fields.Str(
            required=True, load_from="CPULimitsFraction"
        ),
        "CPURequests": fields.Str(required=True, load_from="CPURequests"),
        "CPURequestsFraction": fields.Str(
            required=True, load_from="CPURequestsFraction"
        ),
        "Conditions": fields.List(
            models.K8SNodeConditionSchema(),
            required=True,
            load_from="Conditions",
        ),
        "ContainerImages": fields.List(
            fields.Str(), required=True, load_from="ContainerImages"
        ),
        "ContainerRuntimeVersion": fields.Str(
            required=True, load_from="ContainerRuntimeVersion"
        ),
        "CreationTimestamp": fields.Int(
            required=True, load_from="CreationTimestamp"
        ),
        "Hostname": fields.Str(required=True, load_from="Hostname"),
        "InternalIP": fields.Str(required=True, load_from="InternalIP"),
        "KernelVersion": fields.Str(required=True, load_from="KernelVersion"),
        "KubeProxyVersion": fields.Str(
            required=True, load_from="KubeProxyVersion"
        ),
        "KubeletVersion": fields.Str(required=True, load_from="KubeletVersion"),
        "Labels": fields.List(fields.Str(), required=True, load_from="Labels"),
        "MemoryCapacity": fields.Str(required=True, load_from="MemoryCapacity"),
        "MemoryLimits": fields.Str(required=True, load_from="MemoryLimits"),
        "MemoryLimitsFraction": fields.Str(
            required=True, load_from="MemoryLimitsFraction"
        ),
        "MemoryRequests": fields.Str(required=True, load_from="MemoryRequests"),
        "MemoryRequestsFraction": fields.Str(
            required=True, load_from="MemoryRequestsFraction"
        ),
        "Message": fields.Str(required=True, load_from="Message"),
        "Name": fields.Str(required=True, load_from="Name"),
        "OSImage": fields.Str(required=True, load_from="OSImage"),
        "PodCapacity": fields.Int(required=True, load_from="PodCapacity"),
        "ProviderID": fields.Str(required=True, load_from="ProviderID"),
        "RetCode": fields.Int(required=True, load_from="RetCode"),
        "Taints": fields.List(fields.Str(), required=False, load_from="Taints"),
        "Unschedulable": fields.Bool(required=True, load_from="Unschedulable"),
    }


"""
API: ListUK8SClusterNodeV2

获取UK8S集群节点信息
"""


class ListUK8SClusterNodeV2RequestSchema(schema.RequestSchema):
    """ListUK8SClusterNodeV2 - 获取UK8S集群节点信息"""

    fields = {
        "ClusterId": fields.Str(required=True, dump_to="ClusterId"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
    }


class ListUK8SClusterNodeV2ResponseSchema(schema.ResponseSchema):
    """ListUK8SClusterNodeV2 - 获取UK8S集群节点信息"""

    fields = {
        "NodeSet": fields.List(
            models.NodeInfoV2Schema(), required=True, load_from="NodeSet"
        ),
        "TotalCount": fields.Int(required=True, load_from="TotalCount"),
    }


"""
API: ListUK8SClusterV2

获取UK8S集群列表信息
"""


class ListUK8SClusterV2RequestSchema(schema.RequestSchema):
    """ListUK8SClusterV2 - 获取UK8S集群列表信息"""

    fields = {
        "ClusterId": fields.Str(required=False, dump_to="ClusterId"),
        "Limit": fields.Int(required=False, dump_to="Limit"),
        "Offset": fields.Int(required=False, dump_to="Offset"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
    }


class ListUK8SClusterV2ResponseSchema(schema.ResponseSchema):
    """ListUK8SClusterV2 - 获取UK8S集群列表信息"""

    fields = {
        "ClusterCount": fields.Int(required=True, load_from="ClusterCount"),
        "ClusterSet": fields.List(
            models.ClusterSetSchema(), required=False, load_from="ClusterSet"
        ),
    }


"""
API: ListUK8SNodeGroup

列出UK8S节点池
"""


class ListUK8SNodeGroupRequestSchema(schema.RequestSchema):
    """ListUK8SNodeGroup - 列出UK8S节点池"""

    fields = {
        "ClusterId": fields.Str(required=True, dump_to="ClusterId"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Zone": fields.Str(required=False, dump_to="Zone"),
    }


class ListUK8SNodeGroupResponseSchema(schema.ResponseSchema):
    """ListUK8SNodeGroup - 列出UK8S节点池"""

    fields = {
        "NodeGroupList": fields.List(
            models.NodeGroupSetSchema(),
            required=False,
            load_from="NodeGroupList",
        ),
    }


"""
API: RemoveUK8SNodeGroup

删除UK8S节点池
"""


class RemoveUK8SNodeGroupRequestSchema(schema.RequestSchema):
    """RemoveUK8SNodeGroup - 删除UK8S节点池"""

    fields = {
        "ClusterId": fields.Str(required=True, dump_to="ClusterId"),
        "NodeGroupId": fields.Str(required=True, dump_to="NodeGroupId"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Zone": fields.Str(required=False, dump_to="Zone"),
    }


class RemoveUK8SNodeGroupResponseSchema(schema.ResponseSchema):
    """RemoveUK8SNodeGroup - 删除UK8S节点池"""

    fields = {}
