module IntXbar(
  input   auto_int_in_0,
  input   auto_int_in_1,
  input   auto_int_in_2,
  input   auto_int_in_3,
  output  auto_int_out_0,
  output  auto_int_out_1,
  output  auto_int_out_2,
  output  auto_int_out_3
);
  assign auto_int_out_0 = auto_int_in_0; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_int_out_1 = auto_int_in_1; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_int_out_2 = auto_int_in_2; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_int_out_3 = auto_int_in_3; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
endmodule
module NonSyncResetSynchronizerPrimitiveShiftReg_d3(
  input   clock,
  input   io_d,
  output  io_q
);
`ifdef RANDOMIZE_REG_INIT
  reg [31:0] _RAND_0;
  reg [31:0] _RAND_1;
  reg [31:0] _RAND_2;
`endif // RANDOMIZE_REG_INIT
  reg  sync_0; // @[SynchronizerReg.scala 51:66]
  reg  sync_1; // @[SynchronizerReg.scala 51:66]
  reg  sync_2; // @[SynchronizerReg.scala 51:66]
  assign io_q = sync_0; // @[SynchronizerReg.scala 59:8]
  always @(posedge clock) begin
    sync_0 <= sync_1; // @[SynchronizerReg.scala 57:10]
    sync_1 <= sync_2; // @[SynchronizerReg.scala 57:10]
    sync_2 <= io_d; // @[SynchronizerReg.scala 54:22]
  end
// Register and memory initialization
`ifdef RANDOMIZE_GARBAGE_ASSIGN
`define RANDOMIZE
`endif
`ifdef RANDOMIZE_INVALID_ASSIGN
`define RANDOMIZE
`endif
`ifdef RANDOMIZE_REG_INIT
`define RANDOMIZE
`endif
`ifdef RANDOMIZE_MEM_INIT
`define RANDOMIZE
`endif
`ifndef RANDOM
`define RANDOM $random
`endif
`ifdef RANDOMIZE_MEM_INIT
  integer initvar;
`endif
`ifndef SYNTHESIS
`ifdef FIRRTL_BEFORE_INITIAL
`FIRRTL_BEFORE_INITIAL
`endif
initial begin
  `ifdef RANDOMIZE
    `ifdef INIT_RANDOM
      `INIT_RANDOM
    `endif
    `ifndef VERILATOR
      `ifdef RANDOMIZE_DELAY
        #`RANDOMIZE_DELAY begin end
      `else
        #0.002 begin end
      `endif
    `endif
`ifdef RANDOMIZE_REG_INIT
  _RAND_0 = {1{`RANDOM}};
  sync_0 = _RAND_0[0:0];
  _RAND_1 = {1{`RANDOM}};
  sync_1 = _RAND_1[0:0];
  _RAND_2 = {1{`RANDOM}};
  sync_2 = _RAND_2[0:0];
`endif // RANDOMIZE_REG_INIT
  `endif // RANDOMIZE
end // initial
`ifdef FIRRTL_AFTER_INITIAL
`FIRRTL_AFTER_INITIAL
`endif
`endif // SYNTHESIS
endmodule
module SynchronizerShiftReg_w4_d3(
  input        clock,
  input  [3:0] io_d,
  output [3:0] io_q
);
  wire  output_chain_clock; // @[ShiftReg.scala 45:23]
  wire  output_chain_io_d; // @[ShiftReg.scala 45:23]
  wire  output_chain_io_q; // @[ShiftReg.scala 45:23]
  wire  output_chain_1_clock; // @[ShiftReg.scala 45:23]
  wire  output_chain_1_io_d; // @[ShiftReg.scala 45:23]
  wire  output_chain_1_io_q; // @[ShiftReg.scala 45:23]
  wire  output_chain_2_clock; // @[ShiftReg.scala 45:23]
  wire  output_chain_2_io_d; // @[ShiftReg.scala 45:23]
  wire  output_chain_2_io_q; // @[ShiftReg.scala 45:23]
  wire  output_chain_3_clock; // @[ShiftReg.scala 45:23]
  wire  output_chain_3_io_d; // @[ShiftReg.scala 45:23]
  wire  output_chain_3_io_q; // @[ShiftReg.scala 45:23]
  wire  output_1 = output_chain_1_io_q; // @[ShiftReg.scala 48:24 ShiftReg.scala 48:24]
  wire  output_0 = output_chain_io_q; // @[ShiftReg.scala 48:24 ShiftReg.scala 48:24]
  wire [1:0] io_q_lo = {output_1,output_0}; // @[Cat.scala 30:58]
  wire  output_3 = output_chain_3_io_q; // @[ShiftReg.scala 48:24 ShiftReg.scala 48:24]
  wire  output_2 = output_chain_2_io_q; // @[ShiftReg.scala 48:24 ShiftReg.scala 48:24]
  wire [1:0] io_q_hi = {output_3,output_2}; // @[Cat.scala 30:58]
  NonSyncResetSynchronizerPrimitiveShiftReg_d3 output_chain ( // @[ShiftReg.scala 45:23]
    .clock(output_chain_clock),
    .io_d(output_chain_io_d),
    .io_q(output_chain_io_q)
  );
  NonSyncResetSynchronizerPrimitiveShiftReg_d3 output_chain_1 ( // @[ShiftReg.scala 45:23]
    .clock(output_chain_1_clock),
    .io_d(output_chain_1_io_d),
    .io_q(output_chain_1_io_q)
  );
  NonSyncResetSynchronizerPrimitiveShiftReg_d3 output_chain_2 ( // @[ShiftReg.scala 45:23]
    .clock(output_chain_2_clock),
    .io_d(output_chain_2_io_d),
    .io_q(output_chain_2_io_q)
  );
  NonSyncResetSynchronizerPrimitiveShiftReg_d3 output_chain_3 ( // @[ShiftReg.scala 45:23]
    .clock(output_chain_3_clock),
    .io_d(output_chain_3_io_d),
    .io_q(output_chain_3_io_q)
  );
  assign io_q = {io_q_hi,io_q_lo}; // @[Cat.scala 30:58]
  assign output_chain_clock = clock;
  assign output_chain_io_d = io_d[0]; // @[SynchronizerReg.scala 173:39]
  assign output_chain_1_clock = clock;
  assign output_chain_1_io_d = io_d[1]; // @[SynchronizerReg.scala 173:39]
  assign output_chain_2_clock = clock;
  assign output_chain_2_io_d = io_d[2]; // @[SynchronizerReg.scala 173:39]
  assign output_chain_3_clock = clock;
  assign output_chain_3_io_d = io_d[3]; // @[SynchronizerReg.scala 173:39]
endmodule
module IntSyncAsyncCrossingSink(
  input   clock,
  input   auto_in_sync_0,
  input   auto_in_sync_1,
  input   auto_in_sync_2,
  input   auto_in_sync_3,
  output  auto_out_0,
  output  auto_out_1,
  output  auto_out_2,
  output  auto_out_3
);
  wire  chain_clock; // @[ShiftReg.scala 45:23]
  wire [3:0] chain_io_d; // @[ShiftReg.scala 45:23]
  wire [3:0] chain_io_q; // @[ShiftReg.scala 45:23]
  wire [1:0] chain_io_d_lo = {auto_in_sync_1,auto_in_sync_0}; // @[ShiftReg.scala 47:22]
  wire [1:0] chain_io_d_hi = {auto_in_sync_3,auto_in_sync_2}; // @[ShiftReg.scala 47:22]
  wire [3:0] _WIRE_1 = chain_io_q;
  SynchronizerShiftReg_w4_d3 chain ( // @[ShiftReg.scala 45:23]
    .clock(chain_clock),
    .io_d(chain_io_d),
    .io_q(chain_io_q)
  );
  assign auto_out_0 = _WIRE_1[0]; // @[ShiftReg.scala 48:24]
  assign auto_out_1 = _WIRE_1[1]; // @[ShiftReg.scala 48:24]
  assign auto_out_2 = _WIRE_1[2]; // @[ShiftReg.scala 48:24]
  assign auto_out_3 = _WIRE_1[3]; // @[ShiftReg.scala 48:24]
  assign chain_clock = clock;
  assign chain_io_d = {chain_io_d_hi,chain_io_d_lo}; // @[ShiftReg.scala 47:22]
endmodule
module SimpleClockGroupSource(
  input   clock,
  input   reset,
  output  auto_out_member_subsystem_sbus_5_clock,
  output  auto_out_member_subsystem_sbus_5_reset,
  output  auto_out_member_subsystem_sbus_4_clock,
  output  auto_out_member_subsystem_sbus_4_reset,
  output  auto_out_member_subsystem_sbus_3_clock,
  output  auto_out_member_subsystem_sbus_3_reset,
  output  auto_out_member_subsystem_sbus_2_clock,
  output  auto_out_member_subsystem_sbus_2_reset,
  output  auto_out_member_subsystem_sbus_1_clock,
  output  auto_out_member_subsystem_sbus_1_reset,
  output  auto_out_member_subsystem_sbus_0_clock,
  output  auto_out_member_subsystem_sbus_0_reset
);
  assign auto_out_member_subsystem_sbus_5_clock = clock; // @[Nodes.scala 1207:84 ClockGroup.scala 72:17]
  assign auto_out_member_subsystem_sbus_5_reset = reset; // @[Nodes.scala 1207:84 ClockGroup.scala 72:35]
  assign auto_out_member_subsystem_sbus_4_clock = clock; // @[Nodes.scala 1207:84 ClockGroup.scala 72:17]
  assign auto_out_member_subsystem_sbus_4_reset = reset; // @[Nodes.scala 1207:84 ClockGroup.scala 72:35]
  assign auto_out_member_subsystem_sbus_3_clock = clock; // @[Nodes.scala 1207:84 ClockGroup.scala 72:17]
  assign auto_out_member_subsystem_sbus_3_reset = reset; // @[Nodes.scala 1207:84 ClockGroup.scala 72:35]
  assign auto_out_member_subsystem_sbus_2_clock = clock; // @[Nodes.scala 1207:84 ClockGroup.scala 72:17]
  assign auto_out_member_subsystem_sbus_2_reset = reset; // @[Nodes.scala 1207:84 ClockGroup.scala 72:35]
  assign auto_out_member_subsystem_sbus_1_clock = clock; // @[Nodes.scala 1207:84 ClockGroup.scala 72:17]
  assign auto_out_member_subsystem_sbus_1_reset = reset; // @[Nodes.scala 1207:84 ClockGroup.scala 72:35]
  assign auto_out_member_subsystem_sbus_0_clock = clock; // @[Nodes.scala 1207:84 ClockGroup.scala 72:17]
  assign auto_out_member_subsystem_sbus_0_reset = reset; // @[Nodes.scala 1207:84 ClockGroup.scala 72:35]
endmodule
module FixedClockBroadcast(
  input   auto_in_clock,
  input   auto_in_reset,
  output  auto_out_5_clock,
  output  auto_out_5_reset,
  output  auto_out_4_clock,
  output  auto_out_4_reset,
  output  auto_out_3_clock,
  output  auto_out_3_reset,
  output  auto_out_2_clock,
  output  auto_out_2_reset,
  output  auto_out_1_clock,
  output  auto_out_0_clock,
  output  auto_out_0_reset
);
  assign auto_out_5_clock = auto_in_clock; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_5_reset = auto_in_reset; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_4_clock = auto_in_clock; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_4_reset = auto_in_reset; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_3_clock = auto_in_clock; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_3_reset = auto_in_reset; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_2_clock = auto_in_clock; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_2_reset = auto_in_reset; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_1_clock = auto_in_clock; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_0_clock = auto_in_clock; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_0_reset = auto_in_reset; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
endmodule
module TLMonitor(
  input         clock,
  input         reset,
  input         io_in_a_ready,
  input         io_in_a_valid,
  input  [2:0]  io_in_a_bits_opcode,
  input  [2:0]  io_in_a_bits_param,
  input  [3:0]  io_in_a_bits_size,
  input  [3:0]  io_in_a_bits_source,
  input  [31:0] io_in_a_bits_address,
  input  [7:0]  io_in_a_bits_mask,
  input         io_in_a_bits_corrupt,
  input         io_in_d_ready,
  input         io_in_d_valid,
  input  [2:0]  io_in_d_bits_opcode,
  input  [1:0]  io_in_d_bits_param,
  input  [3:0]  io_in_d_bits_size,
  input  [3:0]  io_in_d_bits_source,
  input  [1:0]  io_in_d_bits_sink,
  input         io_in_d_bits_denied,
  input         io_in_d_bits_corrupt
);
`ifdef RANDOMIZE_REG_INIT
  reg [31:0] _RAND_0;
  reg [31:0] _RAND_1;
  reg [31:0] _RAND_2;
  reg [31:0] _RAND_3;
  reg [31:0] _RAND_4;
  reg [31:0] _RAND_5;
  reg [31:0] _RAND_6;
  reg [31:0] _RAND_7;
  reg [31:0] _RAND_8;
  reg [31:0] _RAND_9;
  reg [31:0] _RAND_10;
  reg [31:0] _RAND_11;
  reg [31:0] _RAND_12;
  reg [31:0] _RAND_13;
  reg [63:0] _RAND_14;
  reg [127:0] _RAND_15;
  reg [31:0] _RAND_16;
  reg [31:0] _RAND_17;
  reg [31:0] _RAND_18;
  reg [31:0] _RAND_19;
  reg [127:0] _RAND_20;
  reg [31:0] _RAND_21;
  reg [31:0] _RAND_22;
`endif // RANDOMIZE_REG_INIT
  wire [31:0] plusarg_reader_out; // @[PlusArg.scala 80:11]
  wire [31:0] plusarg_reader_1_out; // @[PlusArg.scala 80:11]
  wire  _source_ok_T_1 = ~io_in_a_bits_source[3]; // @[Parameters.scala 54:32]
  wire  source_ok = _source_ok_T_1 | io_in_a_bits_source[3]; // @[Parameters.scala 1125:46]
  wire [26:0] _is_aligned_mask_T_1 = 27'hfff << io_in_a_bits_size; // @[package.scala 234:77]
  wire [11:0] is_aligned_mask = ~_is_aligned_mask_T_1[11:0]; // @[package.scala 234:46]
  wire [31:0] _GEN_71 = {{20'd0}, is_aligned_mask}; // @[Edges.scala 20:16]
  wire [31:0] _is_aligned_T = io_in_a_bits_address & _GEN_71; // @[Edges.scala 20:16]
  wire  is_aligned = _is_aligned_T == 32'h0; // @[Edges.scala 20:24]
  wire [1:0] mask_sizeOH_shiftAmount = io_in_a_bits_size[1:0]; // @[OneHot.scala 64:49]
  wire [3:0] _mask_sizeOH_T_1 = 4'h1 << mask_sizeOH_shiftAmount; // @[OneHot.scala 65:12]
  wire [2:0] mask_sizeOH = _mask_sizeOH_T_1[2:0] | 3'h1; // @[Misc.scala 201:81]
  wire  _mask_T = io_in_a_bits_size >= 4'h3; // @[Misc.scala 205:21]
  wire  mask_size = mask_sizeOH[2]; // @[Misc.scala 208:26]
  wire  mask_bit = io_in_a_bits_address[2]; // @[Misc.scala 209:26]
  wire  mask_nbit = ~mask_bit; // @[Misc.scala 210:20]
  wire  mask_acc = _mask_T | mask_size & mask_nbit; // @[Misc.scala 214:29]
  wire  mask_acc_1 = _mask_T | mask_size & mask_bit; // @[Misc.scala 214:29]
  wire  mask_size_1 = mask_sizeOH[1]; // @[Misc.scala 208:26]
  wire  mask_bit_1 = io_in_a_bits_address[1]; // @[Misc.scala 209:26]
  wire  mask_nbit_1 = ~mask_bit_1; // @[Misc.scala 210:20]
  wire  mask_eq_2 = mask_nbit & mask_nbit_1; // @[Misc.scala 213:27]
  wire  mask_acc_2 = mask_acc | mask_size_1 & mask_eq_2; // @[Misc.scala 214:29]
  wire  mask_eq_3 = mask_nbit & mask_bit_1; // @[Misc.scala 213:27]
  wire  mask_acc_3 = mask_acc | mask_size_1 & mask_eq_3; // @[Misc.scala 214:29]
  wire  mask_eq_4 = mask_bit & mask_nbit_1; // @[Misc.scala 213:27]
  wire  mask_acc_4 = mask_acc_1 | mask_size_1 & mask_eq_4; // @[Misc.scala 214:29]
  wire  mask_eq_5 = mask_bit & mask_bit_1; // @[Misc.scala 213:27]
  wire  mask_acc_5 = mask_acc_1 | mask_size_1 & mask_eq_5; // @[Misc.scala 214:29]
  wire  mask_size_2 = mask_sizeOH[0]; // @[Misc.scala 208:26]
  wire  mask_bit_2 = io_in_a_bits_address[0]; // @[Misc.scala 209:26]
  wire  mask_nbit_2 = ~mask_bit_2; // @[Misc.scala 210:20]
  wire  mask_eq_6 = mask_eq_2 & mask_nbit_2; // @[Misc.scala 213:27]
  wire  mask_lo_lo_lo = mask_acc_2 | mask_size_2 & mask_eq_6; // @[Misc.scala 214:29]
  wire  mask_eq_7 = mask_eq_2 & mask_bit_2; // @[Misc.scala 213:27]
  wire  mask_lo_lo_hi = mask_acc_2 | mask_size_2 & mask_eq_7; // @[Misc.scala 214:29]
  wire  mask_eq_8 = mask_eq_3 & mask_nbit_2; // @[Misc.scala 213:27]
  wire  mask_lo_hi_lo = mask_acc_3 | mask_size_2 & mask_eq_8; // @[Misc.scala 214:29]
  wire  mask_eq_9 = mask_eq_3 & mask_bit_2; // @[Misc.scala 213:27]
  wire  mask_lo_hi_hi = mask_acc_3 | mask_size_2 & mask_eq_9; // @[Misc.scala 214:29]
  wire  mask_eq_10 = mask_eq_4 & mask_nbit_2; // @[Misc.scala 213:27]
  wire  mask_hi_lo_lo = mask_acc_4 | mask_size_2 & mask_eq_10; // @[Misc.scala 214:29]
  wire  mask_eq_11 = mask_eq_4 & mask_bit_2; // @[Misc.scala 213:27]
  wire  mask_hi_lo_hi = mask_acc_4 | mask_size_2 & mask_eq_11; // @[Misc.scala 214:29]
  wire  mask_eq_12 = mask_eq_5 & mask_nbit_2; // @[Misc.scala 213:27]
  wire  mask_hi_hi_lo = mask_acc_5 | mask_size_2 & mask_eq_12; // @[Misc.scala 214:29]
  wire  mask_eq_13 = mask_eq_5 & mask_bit_2; // @[Misc.scala 213:27]
  wire  mask_hi_hi_hi = mask_acc_5 | mask_size_2 & mask_eq_13; // @[Misc.scala 214:29]
  wire [7:0] mask = {mask_hi_hi_hi,mask_hi_hi_lo,mask_hi_lo_hi,mask_hi_lo_lo,mask_lo_hi_hi,mask_lo_hi_lo,mask_lo_lo_hi,
    mask_lo_lo_lo}; // @[Cat.scala 30:58]
  wire [32:0] _T_12 = {1'b0,$signed(io_in_a_bits_address)}; // @[Parameters.scala 137:49]
  wire  _T_34 = io_in_a_bits_opcode == 3'h6; // @[Monitor.scala 81:25]
  wire  _T_36 = io_in_a_bits_size <= 4'hc; // @[Parameters.scala 92:42]
  wire  _T_51 = _T_36 & source_ok; // @[Parameters.scala 1160:30]
  wire [32:0] _T_57 = $signed(_T_12) & -33'sh1000; // @[Parameters.scala 137:52]
  wire  _T_58 = $signed(_T_57) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _T_59 = io_in_a_bits_address ^ 32'h3000; // @[Parameters.scala 137:31]
  wire [32:0] _T_60 = {1'b0,$signed(_T_59)}; // @[Parameters.scala 137:49]
  wire [32:0] _T_62 = $signed(_T_60) & -33'sh1000; // @[Parameters.scala 137:52]
  wire  _T_63 = $signed(_T_62) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _T_64 = io_in_a_bits_address ^ 32'h10000; // @[Parameters.scala 137:31]
  wire [32:0] _T_65 = {1'b0,$signed(_T_64)}; // @[Parameters.scala 137:49]
  wire [32:0] _T_67 = $signed(_T_65) & -33'sh10000; // @[Parameters.scala 137:52]
  wire  _T_68 = $signed(_T_67) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _T_69 = io_in_a_bits_address ^ 32'h2000000; // @[Parameters.scala 137:31]
  wire [32:0] _T_70 = {1'b0,$signed(_T_69)}; // @[Parameters.scala 137:49]
  wire [32:0] _T_72 = $signed(_T_70) & -33'sh10000; // @[Parameters.scala 137:52]
  wire  _T_73 = $signed(_T_72) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _T_74 = io_in_a_bits_address ^ 32'hc000000; // @[Parameters.scala 137:31]
  wire [32:0] _T_75 = {1'b0,$signed(_T_74)}; // @[Parameters.scala 137:49]
  wire [32:0] _T_77 = $signed(_T_75) & -33'sh4000000; // @[Parameters.scala 137:52]
  wire  _T_78 = $signed(_T_77) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _T_79 = io_in_a_bits_address ^ 32'h10000000; // @[Parameters.scala 137:31]
  wire [32:0] _T_80 = {1'b0,$signed(_T_79)}; // @[Parameters.scala 137:49]
  wire [32:0] _T_82 = $signed(_T_80) & -33'sh10000000; // @[Parameters.scala 137:52]
  wire  _T_83 = $signed(_T_82) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _T_84 = io_in_a_bits_address ^ 32'h20000000; // @[Parameters.scala 137:31]
  wire [32:0] _T_85 = {1'b0,$signed(_T_84)}; // @[Parameters.scala 137:49]
  wire [32:0] _T_87 = $signed(_T_85) & -33'sh20000000; // @[Parameters.scala 137:52]
  wire  _T_88 = $signed(_T_87) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _T_89 = io_in_a_bits_address ^ 32'h40000000; // @[Parameters.scala 137:31]
  wire [32:0] _T_90 = {1'b0,$signed(_T_89)}; // @[Parameters.scala 137:49]
  wire [32:0] _T_92 = $signed(_T_90) & -33'sh40000000; // @[Parameters.scala 137:52]
  wire  _T_93 = $signed(_T_92) == 33'sh0; // @[Parameters.scala 137:67]
  wire  _T_103 = io_in_a_bits_size <= 4'h6; // @[Parameters.scala 92:42]
  wire [31:0] _T_106 = io_in_a_bits_address ^ 32'h80000000; // @[Parameters.scala 137:31]
  wire [32:0] _T_107 = {1'b0,$signed(_T_106)}; // @[Parameters.scala 137:49]
  wire [32:0] _T_109 = $signed(_T_107) & -33'sh80000000; // @[Parameters.scala 137:52]
  wire  _T_110 = $signed(_T_109) == 33'sh0; // @[Parameters.scala 137:67]
  wire  _T_111 = _T_103 & _T_110; // @[Parameters.scala 670:56]
  wire  _T_114 = _T_51 & _T_111; // @[Monitor.scala 82:72]
  wire  _T_191 = io_in_a_bits_param <= 3'h2; // @[Bundles.scala 108:27]
  wire [7:0] _T_195 = ~io_in_a_bits_mask; // @[Monitor.scala 88:18]
  wire  _T_196 = _T_195 == 8'h0; // @[Monitor.scala 88:31]
  wire  _T_200 = ~io_in_a_bits_corrupt; // @[Monitor.scala 89:18]
  wire  _T_204 = io_in_a_bits_opcode == 3'h7; // @[Monitor.scala 92:25]
  wire  _T_365 = io_in_a_bits_param != 3'h0; // @[Monitor.scala 99:31]
  wire  _T_378 = io_in_a_bits_opcode == 3'h4; // @[Monitor.scala 104:25]
  wire  _T_409 = _T_36 & _T_63; // @[Parameters.scala 670:56]
  wire  _T_460 = _T_58 | _T_68 | _T_73 | _T_78 | _T_83 | _T_88 | _T_93 | _T_110; // @[Parameters.scala 671:42]
  wire  _T_461 = _T_103 & _T_460; // @[Parameters.scala 670:56]
  wire  _T_463 = _T_409 | _T_461; // @[Parameters.scala 672:30]
  wire  _T_473 = io_in_a_bits_param == 3'h0; // @[Monitor.scala 109:31]
  wire  _T_477 = io_in_a_bits_mask == mask; // @[Monitor.scala 110:30]
  wire  _T_485 = io_in_a_bits_opcode == 3'h0; // @[Monitor.scala 114:25]
  wire  _T_540 = _T_58 | _T_73 | _T_78 | _T_110; // @[Parameters.scala 671:42]
  wire  _T_541 = _T_103 & _T_540; // @[Parameters.scala 670:56]
  wire  _T_550 = io_in_a_bits_size <= 4'h8; // @[Parameters.scala 92:42]
  wire  _T_569 = _T_83 | _T_88 | _T_93; // @[Parameters.scala 671:42]
  wire  _T_570 = _T_550 & _T_569; // @[Parameters.scala 670:56]
  wire  _T_574 = _T_409 | _T_541 | _T_570; // @[Parameters.scala 672:30]
  wire  _T_575 = _T_51 & _T_574; // @[Monitor.scala 115:71]
  wire  _T_593 = io_in_a_bits_opcode == 3'h1; // @[Monitor.scala 122:25]
  wire [7:0] _T_697 = ~mask; // @[Monitor.scala 127:33]
  wire [7:0] _T_698 = io_in_a_bits_mask & _T_697; // @[Monitor.scala 127:31]
  wire  _T_699 = _T_698 == 8'h0; // @[Monitor.scala 127:40]
  wire  _T_703 = io_in_a_bits_opcode == 3'h2; // @[Monitor.scala 130:25]
  wire  _T_723 = io_in_a_bits_size <= 4'h3; // @[Parameters.scala 92:42]
  wire  _T_748 = _T_58 | _T_63 | _T_73 | _T_78; // @[Parameters.scala 671:42]
  wire  _T_749 = _T_723 & _T_748; // @[Parameters.scala 670:56]
  wire  _T_783 = _T_51 & _T_749; // @[Monitor.scala 131:74]
  wire  _T_793 = io_in_a_bits_param <= 3'h4; // @[Bundles.scala 138:33]
  wire  _T_801 = io_in_a_bits_opcode == 3'h3; // @[Monitor.scala 138:25]
  wire  _T_891 = io_in_a_bits_param <= 3'h3; // @[Bundles.scala 145:30]
  wire  _T_899 = io_in_a_bits_opcode == 3'h5; // @[Monitor.scala 146:25]
  wire  _T_979 = _T_51 & _T_409; // @[Monitor.scala 147:68]
  wire  _T_989 = io_in_a_bits_param <= 3'h1; // @[Bundles.scala 158:28]
  wire  _T_1001 = io_in_d_bits_opcode <= 3'h6; // @[Bundles.scala 42:24]
  wire  _source_ok_T_13 = ~io_in_d_bits_source[3]; // @[Parameters.scala 54:32]
  wire  source_ok_1 = _source_ok_T_13 | io_in_d_bits_source[3]; // @[Parameters.scala 1125:46]
  wire  _T_1005 = io_in_d_bits_opcode == 3'h6; // @[Monitor.scala 310:25]
  wire  _T_1009 = io_in_d_bits_size >= 4'h3; // @[Monitor.scala 312:27]
  wire  _T_1013 = io_in_d_bits_param == 2'h0; // @[Monitor.scala 313:28]
  wire  _T_1017 = ~io_in_d_bits_corrupt; // @[Monitor.scala 314:15]
  wire  _T_1021 = ~io_in_d_bits_denied; // @[Monitor.scala 315:15]
  wire  _T_1025 = io_in_d_bits_opcode == 3'h4; // @[Monitor.scala 318:25]
  wire  _T_1036 = io_in_d_bits_param <= 2'h2; // @[Bundles.scala 102:26]
  wire  _T_1040 = io_in_d_bits_param != 2'h2; // @[Monitor.scala 323:28]
  wire  _T_1053 = io_in_d_bits_opcode == 3'h5; // @[Monitor.scala 328:25]
  wire  _T_1073 = _T_1021 | io_in_d_bits_corrupt; // @[Monitor.scala 334:30]
  wire  _T_1082 = io_in_d_bits_opcode == 3'h0; // @[Monitor.scala 338:25]
  wire  _T_1099 = io_in_d_bits_opcode == 3'h1; // @[Monitor.scala 346:25]
  wire  _T_1117 = io_in_d_bits_opcode == 3'h2; // @[Monitor.scala 354:25]
  wire  _a_first_T = io_in_a_ready & io_in_a_valid; // @[Decoupled.scala 40:37]
  wire [8:0] a_first_beats1_decode = is_aligned_mask[11:3]; // @[Edges.scala 219:59]
  wire  a_first_beats1_opdata = ~io_in_a_bits_opcode[2]; // @[Edges.scala 91:28]
  reg [8:0] a_first_counter; // @[Edges.scala 228:27]
  wire [8:0] a_first_counter1 = a_first_counter - 9'h1; // @[Edges.scala 229:28]
  wire  a_first = a_first_counter == 9'h0; // @[Edges.scala 230:25]
  reg [2:0] opcode; // @[Monitor.scala 384:22]
  reg [2:0] param; // @[Monitor.scala 385:22]
  reg [3:0] size; // @[Monitor.scala 386:22]
  reg [3:0] source; // @[Monitor.scala 387:22]
  reg [31:0] address; // @[Monitor.scala 388:22]
  wire  _T_1147 = io_in_a_valid & ~a_first; // @[Monitor.scala 389:19]
  wire  _T_1148 = io_in_a_bits_opcode == opcode; // @[Monitor.scala 390:32]
  wire  _T_1152 = io_in_a_bits_param == param; // @[Monitor.scala 391:32]
  wire  _T_1156 = io_in_a_bits_size == size; // @[Monitor.scala 392:32]
  wire  _T_1160 = io_in_a_bits_source == source; // @[Monitor.scala 393:32]
  wire  _T_1164 = io_in_a_bits_address == address; // @[Monitor.scala 394:32]
  wire  _d_first_T = io_in_d_ready & io_in_d_valid; // @[Decoupled.scala 40:37]
  wire [26:0] _d_first_beats1_decode_T_1 = 27'hfff << io_in_d_bits_size; // @[package.scala 234:77]
  wire [11:0] _d_first_beats1_decode_T_3 = ~_d_first_beats1_decode_T_1[11:0]; // @[package.scala 234:46]
  wire [8:0] d_first_beats1_decode = _d_first_beats1_decode_T_3[11:3]; // @[Edges.scala 219:59]
  wire  d_first_beats1_opdata = io_in_d_bits_opcode[0]; // @[Edges.scala 105:36]
  reg [8:0] d_first_counter; // @[Edges.scala 228:27]
  wire [8:0] d_first_counter1 = d_first_counter - 9'h1; // @[Edges.scala 229:28]
  wire  d_first = d_first_counter == 9'h0; // @[Edges.scala 230:25]
  reg [2:0] opcode_1; // @[Monitor.scala 535:22]
  reg [1:0] param_1; // @[Monitor.scala 536:22]
  reg [3:0] size_1; // @[Monitor.scala 537:22]
  reg [3:0] source_1; // @[Monitor.scala 538:22]
  reg [1:0] sink; // @[Monitor.scala 539:22]
  reg  denied; // @[Monitor.scala 540:22]
  wire  _T_1171 = io_in_d_valid & ~d_first; // @[Monitor.scala 541:19]
  wire  _T_1172 = io_in_d_bits_opcode == opcode_1; // @[Monitor.scala 542:29]
  wire  _T_1176 = io_in_d_bits_param == param_1; // @[Monitor.scala 543:29]
  wire  _T_1180 = io_in_d_bits_size == size_1; // @[Monitor.scala 544:29]
  wire  _T_1184 = io_in_d_bits_source == source_1; // @[Monitor.scala 545:29]
  wire  _T_1188 = io_in_d_bits_sink == sink; // @[Monitor.scala 546:29]
  wire  _T_1192 = io_in_d_bits_denied == denied; // @[Monitor.scala 547:29]
  reg [15:0] inflight; // @[Monitor.scala 611:27]
  reg [63:0] inflight_opcodes; // @[Monitor.scala 613:35]
  reg [127:0] inflight_sizes; // @[Monitor.scala 615:33]
  reg [8:0] a_first_counter_1; // @[Edges.scala 228:27]
  wire [8:0] a_first_counter1_1 = a_first_counter_1 - 9'h1; // @[Edges.scala 229:28]
  wire  a_first_1 = a_first_counter_1 == 9'h0; // @[Edges.scala 230:25]
  reg [8:0] d_first_counter_1; // @[Edges.scala 228:27]
  wire [8:0] d_first_counter1_1 = d_first_counter_1 - 9'h1; // @[Edges.scala 229:28]
  wire  d_first_1 = d_first_counter_1 == 9'h0; // @[Edges.scala 230:25]
  wire [5:0] _GEN_72 = {io_in_d_bits_source, 2'h0}; // @[Monitor.scala 634:69]
  wire [6:0] _a_opcode_lookup_T = {{1'd0}, _GEN_72}; // @[Monitor.scala 634:69]
  wire [63:0] _a_opcode_lookup_T_1 = inflight_opcodes >> _a_opcode_lookup_T; // @[Monitor.scala 634:44]
  wire [15:0] _a_opcode_lookup_T_5 = 16'h10 - 16'h1; // @[Monitor.scala 609:57]
  wire [63:0] _GEN_73 = {{48'd0}, _a_opcode_lookup_T_5}; // @[Monitor.scala 634:97]
  wire [63:0] _a_opcode_lookup_T_6 = _a_opcode_lookup_T_1 & _GEN_73; // @[Monitor.scala 634:97]
  wire [63:0] _a_opcode_lookup_T_7 = {{1'd0}, _a_opcode_lookup_T_6[63:1]}; // @[Monitor.scala 634:152]
  wire [6:0] _a_size_lookup_T = {io_in_d_bits_source, 3'h0}; // @[Monitor.scala 638:65]
  wire [127:0] _a_size_lookup_T_1 = inflight_sizes >> _a_size_lookup_T; // @[Monitor.scala 638:40]
  wire [15:0] _a_size_lookup_T_5 = 16'h100 - 16'h1; // @[Monitor.scala 609:57]
  wire [127:0] _GEN_75 = {{112'd0}, _a_size_lookup_T_5}; // @[Monitor.scala 638:91]
  wire [127:0] _a_size_lookup_T_6 = _a_size_lookup_T_1 & _GEN_75; // @[Monitor.scala 638:91]
  wire [127:0] _a_size_lookup_T_7 = {{1'd0}, _a_size_lookup_T_6[127:1]}; // @[Monitor.scala 638:144]
  wire  _T_1198 = io_in_a_valid & a_first_1; // @[Monitor.scala 648:26]
  wire [15:0] _a_set_wo_ready_T = 16'h1 << io_in_a_bits_source; // @[OneHot.scala 58:35]
  wire [15:0] a_set_wo_ready = io_in_a_valid & a_first_1 ? _a_set_wo_ready_T : 16'h0; // @[Monitor.scala 648:71 Monitor.scala 649:22]
  wire  _T_1201 = _a_first_T & a_first_1; // @[Monitor.scala 652:27]
  wire [3:0] _a_opcodes_set_interm_T = {io_in_a_bits_opcode, 1'h0}; // @[Monitor.scala 654:53]
  wire [3:0] _a_opcodes_set_interm_T_1 = _a_opcodes_set_interm_T | 4'h1; // @[Monitor.scala 654:61]
  wire [4:0] _a_sizes_set_interm_T = {io_in_a_bits_size, 1'h0}; // @[Monitor.scala 655:51]
  wire [4:0] _a_sizes_set_interm_T_1 = _a_sizes_set_interm_T | 5'h1; // @[Monitor.scala 655:59]
  wire [5:0] _GEN_77 = {io_in_a_bits_source, 2'h0}; // @[Monitor.scala 656:79]
  wire [6:0] _a_opcodes_set_T = {{1'd0}, _GEN_77}; // @[Monitor.scala 656:79]
  wire [3:0] a_opcodes_set_interm = _a_first_T & a_first_1 ? _a_opcodes_set_interm_T_1 : 4'h0; // @[Monitor.scala 652:72 Monitor.scala 654:28]
  wire [130:0] _GEN_78 = {{127'd0}, a_opcodes_set_interm}; // @[Monitor.scala 656:54]
  wire [130:0] _a_opcodes_set_T_1 = _GEN_78 << _a_opcodes_set_T; // @[Monitor.scala 656:54]
  wire [6:0] _a_sizes_set_T = {io_in_a_bits_source, 3'h0}; // @[Monitor.scala 657:77]
  wire [4:0] a_sizes_set_interm = _a_first_T & a_first_1 ? _a_sizes_set_interm_T_1 : 5'h0; // @[Monitor.scala 652:72 Monitor.scala 655:28]
  wire [131:0] _GEN_79 = {{127'd0}, a_sizes_set_interm}; // @[Monitor.scala 657:52]
  wire [131:0] _a_sizes_set_T_1 = _GEN_79 << _a_sizes_set_T; // @[Monitor.scala 657:52]
  wire [15:0] _T_1203 = inflight >> io_in_a_bits_source; // @[Monitor.scala 658:26]
  wire  _T_1205 = ~_T_1203[0]; // @[Monitor.scala 658:17]
  wire [15:0] a_set = _a_first_T & a_first_1 ? _a_set_wo_ready_T : 16'h0; // @[Monitor.scala 652:72 Monitor.scala 653:28]
  wire [130:0] _GEN_19 = _a_first_T & a_first_1 ? _a_opcodes_set_T_1 : 131'h0; // @[Monitor.scala 652:72 Monitor.scala 656:28]
  wire [131:0] _GEN_20 = _a_first_T & a_first_1 ? _a_sizes_set_T_1 : 132'h0; // @[Monitor.scala 652:72 Monitor.scala 657:28]
  wire  _T_1209 = io_in_d_valid & d_first_1; // @[Monitor.scala 671:26]
  wire  _T_1211 = ~_T_1005; // @[Monitor.scala 671:74]
  wire  _T_1212 = io_in_d_valid & d_first_1 & ~_T_1005; // @[Monitor.scala 671:71]
  wire [15:0] _d_clr_wo_ready_T = 16'h1 << io_in_d_bits_source; // @[OneHot.scala 58:35]
  wire [15:0] d_clr_wo_ready = io_in_d_valid & d_first_1 & ~_T_1005 ? _d_clr_wo_ready_T : 16'h0; // @[Monitor.scala 671:90 Monitor.scala 672:22]
  wire [142:0] _GEN_81 = {{127'd0}, _a_opcode_lookup_T_5}; // @[Monitor.scala 677:76]
  wire [142:0] _d_opcodes_clr_T_5 = _GEN_81 << _a_opcode_lookup_T; // @[Monitor.scala 677:76]
  wire [142:0] _GEN_82 = {{127'd0}, _a_size_lookup_T_5}; // @[Monitor.scala 678:74]
  wire [142:0] _d_sizes_clr_T_5 = _GEN_82 << _a_size_lookup_T; // @[Monitor.scala 678:74]
  wire [15:0] d_clr = _d_first_T & d_first_1 & _T_1211 ? _d_clr_wo_ready_T : 16'h0; // @[Monitor.scala 675:91 Monitor.scala 676:21]
  wire [142:0] _GEN_23 = _d_first_T & d_first_1 & _T_1211 ? _d_opcodes_clr_T_5 : 143'h0; // @[Monitor.scala 675:91 Monitor.scala 677:21]
  wire [142:0] _GEN_24 = _d_first_T & d_first_1 & _T_1211 ? _d_sizes_clr_T_5 : 143'h0; // @[Monitor.scala 675:91 Monitor.scala 678:21]
  wire  _same_cycle_resp_T_2 = io_in_a_bits_source == io_in_d_bits_source; // @[Monitor.scala 681:113]
  wire  same_cycle_resp = _T_1198 & io_in_a_bits_source == io_in_d_bits_source; // @[Monitor.scala 681:88]
  wire [15:0] _T_1222 = inflight >> io_in_d_bits_source; // @[Monitor.scala 682:25]
  wire  _T_1224 = _T_1222[0] | same_cycle_resp; // @[Monitor.scala 682:49]
  wire [2:0] _GEN_27 = 3'h2 == io_in_a_bits_opcode ? 3'h1 : 3'h0; // @[Monitor.scala 685:38 Monitor.scala 685:38]
  wire [2:0] _GEN_28 = 3'h3 == io_in_a_bits_opcode ? 3'h1 : _GEN_27; // @[Monitor.scala 685:38 Monitor.scala 685:38]
  wire [2:0] _GEN_29 = 3'h4 == io_in_a_bits_opcode ? 3'h1 : _GEN_28; // @[Monitor.scala 685:38 Monitor.scala 685:38]
  wire [2:0] _GEN_30 = 3'h5 == io_in_a_bits_opcode ? 3'h2 : _GEN_29; // @[Monitor.scala 685:38 Monitor.scala 685:38]
  wire [2:0] _GEN_31 = 3'h6 == io_in_a_bits_opcode ? 3'h4 : _GEN_30; // @[Monitor.scala 685:38 Monitor.scala 685:38]
  wire [2:0] _GEN_32 = 3'h7 == io_in_a_bits_opcode ? 3'h4 : _GEN_31; // @[Monitor.scala 685:38 Monitor.scala 685:38]
  wire [2:0] _GEN_39 = 3'h6 == io_in_a_bits_opcode ? 3'h5 : _GEN_30; // @[Monitor.scala 686:39 Monitor.scala 686:39]
  wire [2:0] _GEN_40 = 3'h7 == io_in_a_bits_opcode ? 3'h4 : _GEN_39; // @[Monitor.scala 686:39 Monitor.scala 686:39]
  wire  _T_1229 = io_in_d_bits_opcode == _GEN_40; // @[Monitor.scala 686:39]
  wire  _T_1230 = io_in_d_bits_opcode == _GEN_32 | _T_1229; // @[Monitor.scala 685:77]
  wire  _T_1234 = io_in_a_bits_size == io_in_d_bits_size; // @[Monitor.scala 687:36]
  wire [3:0] a_opcode_lookup = _a_opcode_lookup_T_7[3:0];
  wire [2:0] _GEN_43 = 3'h2 == a_opcode_lookup[2:0] ? 3'h1 : 3'h0; // @[Monitor.scala 689:38 Monitor.scala 689:38]
  wire [2:0] _GEN_44 = 3'h3 == a_opcode_lookup[2:0] ? 3'h1 : _GEN_43; // @[Monitor.scala 689:38 Monitor.scala 689:38]
  wire [2:0] _GEN_45 = 3'h4 == a_opcode_lookup[2:0] ? 3'h1 : _GEN_44; // @[Monitor.scala 689:38 Monitor.scala 689:38]
  wire [2:0] _GEN_46 = 3'h5 == a_opcode_lookup[2:0] ? 3'h2 : _GEN_45; // @[Monitor.scala 689:38 Monitor.scala 689:38]
  wire [2:0] _GEN_47 = 3'h6 == a_opcode_lookup[2:0] ? 3'h4 : _GEN_46; // @[Monitor.scala 689:38 Monitor.scala 689:38]
  wire [2:0] _GEN_48 = 3'h7 == a_opcode_lookup[2:0] ? 3'h4 : _GEN_47; // @[Monitor.scala 689:38 Monitor.scala 689:38]
  wire [2:0] _GEN_55 = 3'h6 == a_opcode_lookup[2:0] ? 3'h5 : _GEN_46; // @[Monitor.scala 690:38 Monitor.scala 690:38]
  wire [2:0] _GEN_56 = 3'h7 == a_opcode_lookup[2:0] ? 3'h4 : _GEN_55; // @[Monitor.scala 690:38 Monitor.scala 690:38]
  wire  _T_1241 = io_in_d_bits_opcode == _GEN_56; // @[Monitor.scala 690:38]
  wire  _T_1242 = io_in_d_bits_opcode == _GEN_48 | _T_1241; // @[Monitor.scala 689:72]
  wire [7:0] a_size_lookup = _a_size_lookup_T_7[7:0];
  wire [7:0] _GEN_83 = {{4'd0}, io_in_d_bits_size}; // @[Monitor.scala 691:36]
  wire  _T_1246 = _GEN_83 == a_size_lookup; // @[Monitor.scala 691:36]
  wire  _T_1256 = _T_1209 & a_first_1 & io_in_a_valid & _same_cycle_resp_T_2 & _T_1211; // @[Monitor.scala 694:116]
  wire  _T_1258 = ~io_in_d_ready | io_in_a_ready; // @[Monitor.scala 695:32]
  wire  _T_1265 = a_set_wo_ready != d_clr_wo_ready | ~(|a_set_wo_ready); // @[Monitor.scala 699:48]
  wire [15:0] _inflight_T = inflight | a_set; // @[Monitor.scala 702:27]
  wire [15:0] _inflight_T_1 = ~d_clr; // @[Monitor.scala 702:38]
  wire [15:0] _inflight_T_2 = _inflight_T & _inflight_T_1; // @[Monitor.scala 702:36]
  wire [63:0] a_opcodes_set = _GEN_19[63:0];
  wire [63:0] _inflight_opcodes_T = inflight_opcodes | a_opcodes_set; // @[Monitor.scala 703:43]
  wire [63:0] d_opcodes_clr = _GEN_23[63:0];
  wire [63:0] _inflight_opcodes_T_1 = ~d_opcodes_clr; // @[Monitor.scala 703:62]
  wire [63:0] _inflight_opcodes_T_2 = _inflight_opcodes_T & _inflight_opcodes_T_1; // @[Monitor.scala 703:60]
  wire [127:0] a_sizes_set = _GEN_20[127:0];
  wire [127:0] _inflight_sizes_T = inflight_sizes | a_sizes_set; // @[Monitor.scala 704:39]
  wire [127:0] d_sizes_clr = _GEN_24[127:0];
  wire [127:0] _inflight_sizes_T_1 = ~d_sizes_clr; // @[Monitor.scala 704:56]
  wire [127:0] _inflight_sizes_T_2 = _inflight_sizes_T & _inflight_sizes_T_1; // @[Monitor.scala 704:54]
  reg [31:0] watchdog; // @[Monitor.scala 706:27]
  wire  _T_1274 = ~(|inflight) | plusarg_reader_out == 32'h0 | watchdog < plusarg_reader_out; // @[Monitor.scala 709:47]
  wire [31:0] _watchdog_T_1 = watchdog + 32'h1; // @[Monitor.scala 711:26]
  reg [15:0] inflight_1; // @[Monitor.scala 723:35]
  reg [127:0] inflight_sizes_1; // @[Monitor.scala 725:35]
  reg [8:0] d_first_counter_2; // @[Edges.scala 228:27]
  wire [8:0] d_first_counter1_2 = d_first_counter_2 - 9'h1; // @[Edges.scala 229:28]
  wire  d_first_2 = d_first_counter_2 == 9'h0; // @[Edges.scala 230:25]
  wire [127:0] _c_size_lookup_T_1 = inflight_sizes_1 >> _a_size_lookup_T; // @[Monitor.scala 747:42]
  wire [127:0] _c_size_lookup_T_6 = _c_size_lookup_T_1 & _GEN_75; // @[Monitor.scala 747:93]
  wire [127:0] _c_size_lookup_T_7 = {{1'd0}, _c_size_lookup_T_6[127:1]}; // @[Monitor.scala 747:146]
  wire  _T_1300 = io_in_d_valid & d_first_2 & _T_1005; // @[Monitor.scala 779:71]
  wire [15:0] d_clr_1 = _d_first_T & d_first_2 & _T_1005 ? _d_clr_wo_ready_T : 16'h0; // @[Monitor.scala 783:90 Monitor.scala 784:21]
  wire [142:0] _GEN_69 = _d_first_T & d_first_2 & _T_1005 ? _d_sizes_clr_T_5 : 143'h0; // @[Monitor.scala 783:90 Monitor.scala 786:21]
  wire [15:0] _T_1308 = inflight_1 >> io_in_d_bits_source; // @[Monitor.scala 791:25]
  wire [7:0] c_size_lookup = _c_size_lookup_T_7[7:0];
  wire  _T_1318 = _GEN_83 == c_size_lookup; // @[Monitor.scala 795:36]
  wire [15:0] _inflight_T_4 = ~d_clr_1; // @[Monitor.scala 809:46]
  wire [15:0] _inflight_T_5 = inflight_1 & _inflight_T_4; // @[Monitor.scala 809:44]
  wire [127:0] d_sizes_clr_1 = _GEN_69[127:0];
  wire [127:0] _inflight_sizes_T_4 = ~d_sizes_clr_1; // @[Monitor.scala 811:58]
  wire [127:0] _inflight_sizes_T_5 = inflight_sizes_1 & _inflight_sizes_T_4; // @[Monitor.scala 811:56]
  reg [31:0] watchdog_1; // @[Monitor.scala 813:27]
  wire  _T_1343 = ~(|inflight_1) | plusarg_reader_1_out == 32'h0 | watchdog_1 < plusarg_reader_1_out; // @[Monitor.scala 816:47]
  wire [31:0] _watchdog_T_3 = watchdog_1 + 32'h1; // @[Monitor.scala 818:26]
  plusarg_reader #(.FORMAT("tilelink_timeout=%d"), .DEFAULT(0), .WIDTH(32)) plusarg_reader ( // @[PlusArg.scala 80:11]
    .out(plusarg_reader_out)
  );
  plusarg_reader #(.FORMAT("tilelink_timeout=%d"), .DEFAULT(0), .WIDTH(32)) plusarg_reader_1 ( // @[PlusArg.scala 80:11]
    .out(plusarg_reader_1_out)
  );
  always @(posedge clock) begin
    if (reset) begin // @[Edges.scala 228:27]
      a_first_counter <= 9'h0; // @[Edges.scala 228:27]
    end else if (_a_first_T) begin // @[Edges.scala 234:17]
      if (a_first) begin // @[Edges.scala 235:21]
        if (a_first_beats1_opdata) begin // @[Edges.scala 220:14]
          a_first_counter <= a_first_beats1_decode;
        end else begin
          a_first_counter <= 9'h0;
        end
      end else begin
        a_first_counter <= a_first_counter1;
      end
    end
    if (_a_first_T & a_first) begin // @[Monitor.scala 396:32]
      opcode <= io_in_a_bits_opcode; // @[Monitor.scala 397:15]
    end
    if (_a_first_T & a_first) begin // @[Monitor.scala 396:32]
      param <= io_in_a_bits_param; // @[Monitor.scala 398:15]
    end
    if (_a_first_T & a_first) begin // @[Monitor.scala 396:32]
      size <= io_in_a_bits_size; // @[Monitor.scala 399:15]
    end
    if (_a_first_T & a_first) begin // @[Monitor.scala 396:32]
      source <= io_in_a_bits_source; // @[Monitor.scala 400:15]
    end
    if (_a_first_T & a_first) begin // @[Monitor.scala 396:32]
      address <= io_in_a_bits_address; // @[Monitor.scala 401:15]
    end
    if (reset) begin // @[Edges.scala 228:27]
      d_first_counter <= 9'h0; // @[Edges.scala 228:27]
    end else if (_d_first_T) begin // @[Edges.scala 234:17]
      if (d_first) begin // @[Edges.scala 235:21]
        if (d_first_beats1_opdata) begin // @[Edges.scala 220:14]
          d_first_counter <= d_first_beats1_decode;
        end else begin
          d_first_counter <= 9'h0;
        end
      end else begin
        d_first_counter <= d_first_counter1;
      end
    end
    if (_d_first_T & d_first) begin // @[Monitor.scala 549:32]
      opcode_1 <= io_in_d_bits_opcode; // @[Monitor.scala 550:15]
    end
    if (_d_first_T & d_first) begin // @[Monitor.scala 549:32]
      param_1 <= io_in_d_bits_param; // @[Monitor.scala 551:15]
    end
    if (_d_first_T & d_first) begin // @[Monitor.scala 549:32]
      size_1 <= io_in_d_bits_size; // @[Monitor.scala 552:15]
    end
    if (_d_first_T & d_first) begin // @[Monitor.scala 549:32]
      source_1 <= io_in_d_bits_source; // @[Monitor.scala 553:15]
    end
    if (_d_first_T & d_first) begin // @[Monitor.scala 549:32]
      sink <= io_in_d_bits_sink; // @[Monitor.scala 554:15]
    end
    if (_d_first_T & d_first) begin // @[Monitor.scala 549:32]
      denied <= io_in_d_bits_denied; // @[Monitor.scala 555:15]
    end
    if (reset) begin // @[Monitor.scala 611:27]
      inflight <= 16'h0; // @[Monitor.scala 611:27]
    end else begin
      inflight <= _inflight_T_2; // @[Monitor.scala 702:14]
    end
    if (reset) begin // @[Monitor.scala 613:35]
      inflight_opcodes <= 64'h0; // @[Monitor.scala 613:35]
    end else begin
      inflight_opcodes <= _inflight_opcodes_T_2; // @[Monitor.scala 703:22]
    end
    if (reset) begin // @[Monitor.scala 615:33]
      inflight_sizes <= 128'h0; // @[Monitor.scala 615:33]
    end else begin
      inflight_sizes <= _inflight_sizes_T_2; // @[Monitor.scala 704:20]
    end
    if (reset) begin // @[Edges.scala 228:27]
      a_first_counter_1 <= 9'h0; // @[Edges.scala 228:27]
    end else if (_a_first_T) begin // @[Edges.scala 234:17]
      if (a_first_1) begin // @[Edges.scala 235:21]
        if (a_first_beats1_opdata) begin // @[Edges.scala 220:14]
          a_first_counter_1 <= a_first_beats1_decode;
        end else begin
          a_first_counter_1 <= 9'h0;
        end
      end else begin
        a_first_counter_1 <= a_first_counter1_1;
      end
    end
    if (reset) begin // @[Edges.scala 228:27]
      d_first_counter_1 <= 9'h0; // @[Edges.scala 228:27]
    end else if (_d_first_T) begin // @[Edges.scala 234:17]
      if (d_first_1) begin // @[Edges.scala 235:21]
        if (d_first_beats1_opdata) begin // @[Edges.scala 220:14]
          d_first_counter_1 <= d_first_beats1_decode;
        end else begin
          d_first_counter_1 <= 9'h0;
        end
      end else begin
        d_first_counter_1 <= d_first_counter1_1;
      end
    end
    if (reset) begin // @[Monitor.scala 706:27]
      watchdog <= 32'h0; // @[Monitor.scala 706:27]
    end else if (_a_first_T | _d_first_T) begin // @[Monitor.scala 712:47]
      watchdog <= 32'h0; // @[Monitor.scala 712:58]
    end else begin
      watchdog <= _watchdog_T_1; // @[Monitor.scala 711:14]
    end
    if (reset) begin // @[Monitor.scala 723:35]
      inflight_1 <= 16'h0; // @[Monitor.scala 723:35]
    end else begin
      inflight_1 <= _inflight_T_5; // @[Monitor.scala 809:22]
    end
    if (reset) begin // @[Monitor.scala 725:35]
      inflight_sizes_1 <= 128'h0; // @[Monitor.scala 725:35]
    end else begin
      inflight_sizes_1 <= _inflight_sizes_T_5; // @[Monitor.scala 811:22]
    end
    if (reset) begin // @[Edges.scala 228:27]
      d_first_counter_2 <= 9'h0; // @[Edges.scala 228:27]
    end else if (_d_first_T) begin // @[Edges.scala 234:17]
      if (d_first_2) begin // @[Edges.scala 235:21]
        if (d_first_beats1_opdata) begin // @[Edges.scala 220:14]
          d_first_counter_2 <= d_first_beats1_decode;
        end else begin
          d_first_counter_2 <= 9'h0;
        end
      end else begin
        d_first_counter_2 <= d_first_counter1_2;
      end
    end
    if (reset) begin // @[Monitor.scala 813:27]
      watchdog_1 <= 32'h0; // @[Monitor.scala 813:27]
    end else if (_d_first_T) begin // @[Monitor.scala 819:47]
      watchdog_1 <= 32'h0; // @[Monitor.scala 819:58]
    end else begin
      watchdog_1 <= _watchdog_T_3; // @[Monitor.scala 818:14]
    end
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_34 & ~(_T_114 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries AcquireBlock type which is unexpected using diplomatic parameters (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_34 & ~(_T_114 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_34 & ~reset) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries AcquireBlock from a client which does not support Probe (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_34 & ~reset) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_34 & ~(source_ok | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquireBlock carries invalid source ID (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_34 & ~(source_ok | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_34 & ~(_mask_T | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquireBlock smaller than a beat (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_34 & ~(_mask_T | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_34 & ~(is_aligned | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquireBlock address not aligned to size (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_34 & ~(is_aligned | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_34 & ~(_T_191 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquireBlock carries invalid grow param (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_34 & ~(_T_191 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_34 & ~(_T_196 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquireBlock contains invalid mask (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_34 & ~(_T_196 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_34 & ~(_T_200 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquireBlock is corrupt (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_34 & ~(_T_200 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_204 & ~(_T_114 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries AcquirePerm type which is unexpected using diplomatic parameters (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_204 & ~(_T_114 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_204 & ~reset) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries AcquirePerm from a client which does not support Probe (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_204 & ~reset) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_204 & ~(source_ok | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquirePerm carries invalid source ID (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_204 & ~(source_ok | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_204 & ~(_mask_T | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquirePerm smaller than a beat (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_204 & ~(_mask_T | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_204 & ~(is_aligned | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquirePerm address not aligned to size (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_204 & ~(is_aligned | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_204 & ~(_T_191 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquirePerm carries invalid grow param (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_204 & ~(_T_191 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_204 & ~(_T_365 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquirePerm requests NtoB (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_204 & ~(_T_365 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_204 & ~(_T_196 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquirePerm contains invalid mask (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_204 & ~(_T_196 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_204 & ~(_T_200 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquirePerm is corrupt (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_204 & ~(_T_200 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_378 & ~(_T_51 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries Get type which master claims it can't emit (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_378 & ~(_T_51 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_378 & ~(_T_463 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries Get type which slave claims it can't support (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_378 & ~(_T_463 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_378 & ~(source_ok | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Get carries invalid source ID (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_378 & ~(source_ok | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_378 & ~(is_aligned | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Get address not aligned to size (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_378 & ~(is_aligned | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_378 & ~(_T_473 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Get carries invalid param (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_378 & ~(_T_473 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_378 & ~(_T_477 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Get contains invalid mask (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_378 & ~(_T_477 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_378 & ~(_T_200 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Get is corrupt (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_378 & ~(_T_200 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_485 & ~(_T_575 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries PutFull type which is unexpected using diplomatic parameters (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_485 & ~(_T_575 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_485 & ~(source_ok | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel PutFull carries invalid source ID (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_485 & ~(source_ok | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_485 & ~(is_aligned | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel PutFull address not aligned to size (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_485 & ~(is_aligned | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_485 & ~(_T_473 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel PutFull carries invalid param (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_485 & ~(_T_473 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_485 & ~(_T_477 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel PutFull contains invalid mask (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_485 & ~(_T_477 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_593 & ~(_T_575 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries PutPartial type which is unexpected using diplomatic parameters (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_593 & ~(_T_575 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_593 & ~(source_ok | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel PutPartial carries invalid source ID (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_593 & ~(source_ok | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_593 & ~(is_aligned | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel PutPartial address not aligned to size (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_593 & ~(is_aligned | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_593 & ~(_T_473 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel PutPartial carries invalid param (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_593 & ~(_T_473 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_593 & ~(_T_699 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel PutPartial contains invalid mask (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_593 & ~(_T_699 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_703 & ~(_T_783 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries Arithmetic type which is unexpected using diplomatic parameters (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_703 & ~(_T_783 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_703 & ~(source_ok | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Arithmetic carries invalid source ID (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_703 & ~(source_ok | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_703 & ~(is_aligned | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Arithmetic address not aligned to size (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_703 & ~(is_aligned | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_703 & ~(_T_793 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Arithmetic carries invalid opcode param (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_703 & ~(_T_793 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_703 & ~(_T_477 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Arithmetic contains invalid mask (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_703 & ~(_T_477 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_801 & ~(_T_783 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries Logical type which is unexpected using diplomatic parameters (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_801 & ~(_T_783 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_801 & ~(source_ok | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Logical carries invalid source ID (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_801 & ~(source_ok | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_801 & ~(is_aligned | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Logical address not aligned to size (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_801 & ~(is_aligned | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_801 & ~(_T_891 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Logical carries invalid opcode param (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_801 & ~(_T_891 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_801 & ~(_T_477 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Logical contains invalid mask (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_801 & ~(_T_477 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_899 & ~(_T_979 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries Hint type which is unexpected using diplomatic parameters (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_899 & ~(_T_979 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_899 & ~(source_ok | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Hint carries invalid source ID (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_899 & ~(source_ok | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_899 & ~(is_aligned | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Hint address not aligned to size (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_899 & ~(is_aligned | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_899 & ~(_T_989 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Hint carries invalid opcode param (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_899 & ~(_T_989 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_899 & ~(_T_477 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Hint contains invalid mask (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_899 & ~(_T_477 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_899 & ~(_T_200 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Hint is corrupt (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_899 & ~(_T_200 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & ~(_T_1001 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel has invalid opcode (connected at SystemBus.scala:41:55)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & ~(_T_1001 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_1005 & ~(source_ok_1 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel ReleaseAck carries invalid source ID (connected at SystemBus.scala:41:55)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_1005 & ~(source_ok_1 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_1005 & ~(_T_1009 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel ReleaseAck smaller than a beat (connected at SystemBus.scala:41:55)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_1005 & ~(_T_1009 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_1005 & ~(_T_1013 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel ReleaseeAck carries invalid param (connected at SystemBus.scala:41:55)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_1005 & ~(_T_1013 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_1005 & ~(_T_1017 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel ReleaseAck is corrupt (connected at SystemBus.scala:41:55)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_1005 & ~(_T_1017 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_1005 & ~(_T_1021 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel ReleaseAck is denied (connected at SystemBus.scala:41:55)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_1005 & ~(_T_1021 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_1025 & ~(source_ok_1 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel Grant carries invalid source ID (connected at SystemBus.scala:41:55)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_1025 & ~(source_ok_1 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_1025 & ~(_T_1009 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel Grant smaller than a beat (connected at SystemBus.scala:41:55)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_1025 & ~(_T_1009 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_1025 & ~(_T_1036 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel Grant carries invalid cap param (connected at SystemBus.scala:41:55)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_1025 & ~(_T_1036 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_1025 & ~(_T_1040 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel Grant carries toN param (connected at SystemBus.scala:41:55)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_1025 & ~(_T_1040 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_1025 & ~(_T_1017 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel Grant is corrupt (connected at SystemBus.scala:41:55)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_1025 & ~(_T_1017 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_1053 & ~(source_ok_1 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel GrantData carries invalid source ID (connected at SystemBus.scala:41:55)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_1053 & ~(source_ok_1 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_1053 & ~(_T_1009 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel GrantData smaller than a beat (connected at SystemBus.scala:41:55)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_1053 & ~(_T_1009 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_1053 & ~(_T_1036 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel GrantData carries invalid cap param (connected at SystemBus.scala:41:55)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_1053 & ~(_T_1036 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_1053 & ~(_T_1040 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel GrantData carries toN param (connected at SystemBus.scala:41:55)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_1053 & ~(_T_1040 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_1053 & ~(_T_1073 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel GrantData is denied but not corrupt (connected at SystemBus.scala:41:55)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_1053 & ~(_T_1073 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_1082 & ~(source_ok_1 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel AccessAck carries invalid source ID (connected at SystemBus.scala:41:55)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_1082 & ~(source_ok_1 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_1082 & ~(_T_1013 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel AccessAck carries invalid param (connected at SystemBus.scala:41:55)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_1082 & ~(_T_1013 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_1082 & ~(_T_1017 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel AccessAck is corrupt (connected at SystemBus.scala:41:55)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_1082 & ~(_T_1017 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_1099 & ~(source_ok_1 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel AccessAckData carries invalid source ID (connected at SystemBus.scala:41:55)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_1099 & ~(source_ok_1 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_1099 & ~(_T_1013 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel AccessAckData carries invalid param (connected at SystemBus.scala:41:55)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_1099 & ~(_T_1013 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_1099 & ~(_T_1073 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel AccessAckData is denied but not corrupt (connected at SystemBus.scala:41:55)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_1099 & ~(_T_1073 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_1117 & ~(source_ok_1 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel HintAck carries invalid source ID (connected at SystemBus.scala:41:55)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_1117 & ~(source_ok_1 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_1117 & ~(_T_1013 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel HintAck carries invalid param (connected at SystemBus.scala:41:55)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_1117 & ~(_T_1013 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_1117 & ~(_T_1017 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel HintAck is corrupt (connected at SystemBus.scala:41:55)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_1117 & ~(_T_1017 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1147 & ~(_T_1148 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel opcode changed within multibeat operation (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1147 & ~(_T_1148 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1147 & ~(_T_1152 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel param changed within multibeat operation (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1147 & ~(_T_1152 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1147 & ~(_T_1156 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel size changed within multibeat operation (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1147 & ~(_T_1156 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1147 & ~(_T_1160 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel source changed within multibeat operation (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1147 & ~(_T_1160 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1147 & ~(_T_1164 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel address changed with multibeat operation (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1147 & ~(_T_1164 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1171 & ~(_T_1172 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel opcode changed within multibeat operation (connected at SystemBus.scala:41:55)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1171 & ~(_T_1172 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1171 & ~(_T_1176 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel param changed within multibeat operation (connected at SystemBus.scala:41:55)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1171 & ~(_T_1176 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1171 & ~(_T_1180 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel size changed within multibeat operation (connected at SystemBus.scala:41:55)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1171 & ~(_T_1180 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1171 & ~(_T_1184 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel source changed within multibeat operation (connected at SystemBus.scala:41:55)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1171 & ~(_T_1184 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1171 & ~(_T_1188 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel sink changed with multibeat operation (connected at SystemBus.scala:41:55)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1171 & ~(_T_1188 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1171 & ~(_T_1192 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel denied changed with multibeat operation (connected at SystemBus.scala:41:55)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1171 & ~(_T_1192 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1201 & ~(_T_1205 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel re-used a source ID (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1201 & ~(_T_1205 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1212 & ~(_T_1224 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel acknowledged for nothing inflight (connected at SystemBus.scala:41:55)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1212 & ~(_T_1224 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1212 & same_cycle_resp & ~(_T_1230 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel contains improper opcode response (connected at SystemBus.scala:41:55)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1212 & same_cycle_resp & ~(_T_1230 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1212 & same_cycle_resp & ~(_T_1234 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel contains improper response size (connected at SystemBus.scala:41:55)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1212 & same_cycle_resp & ~(_T_1234 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1212 & ~same_cycle_resp & ~(_T_1242 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel contains improper opcode response (connected at SystemBus.scala:41:55)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1212 & ~same_cycle_resp & ~(_T_1242 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1212 & ~same_cycle_resp & ~(_T_1246 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel contains improper response size (connected at SystemBus.scala:41:55)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1212 & ~same_cycle_resp & ~(_T_1246 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1256 & ~(_T_1258 | reset)) begin
          $fwrite(32'h80000002,"Assertion failed: ready check\n    at Monitor.scala:49 assert(cond, message)\n"); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1256 & ~(_T_1258 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (~(_T_1265 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' and 'D' concurrent, despite minlatency 1 (connected at SystemBus.scala:41:55)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (~(_T_1265 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (~(_T_1274 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: TileLink timeout expired (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (~(_T_1274 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1300 & ~(_T_1308[0] | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel acknowledged for nothing inflight (connected at SystemBus.scala:41:55)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1300 & ~(_T_1308[0] | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1300 & ~(_T_1318 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel contains improper response size (connected at SystemBus.scala:41:55)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1300 & ~(_T_1318 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (~(_T_1343 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: TileLink timeout expired (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (~(_T_1343 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
  end
// Register and memory initialization
`ifdef RANDOMIZE_GARBAGE_ASSIGN
`define RANDOMIZE
`endif
`ifdef RANDOMIZE_INVALID_ASSIGN
`define RANDOMIZE
`endif
`ifdef RANDOMIZE_REG_INIT
`define RANDOMIZE
`endif
`ifdef RANDOMIZE_MEM_INIT
`define RANDOMIZE
`endif
`ifndef RANDOM
`define RANDOM $random
`endif
`ifdef RANDOMIZE_MEM_INIT
  integer initvar;
`endif
`ifndef SYNTHESIS
`ifdef FIRRTL_BEFORE_INITIAL
`FIRRTL_BEFORE_INITIAL
`endif
initial begin
  `ifdef RANDOMIZE
    `ifdef INIT_RANDOM
      `INIT_RANDOM
    `endif
    `ifndef VERILATOR
      `ifdef RANDOMIZE_DELAY
        #`RANDOMIZE_DELAY begin end
      `else
        #0.002 begin end
      `endif
    `endif
`ifdef RANDOMIZE_REG_INIT
  _RAND_0 = {1{`RANDOM}};
  a_first_counter = _RAND_0[8:0];
  _RAND_1 = {1{`RANDOM}};
  opcode = _RAND_1[2:0];
  _RAND_2 = {1{`RANDOM}};
  param = _RAND_2[2:0];
  _RAND_3 = {1{`RANDOM}};
  size = _RAND_3[3:0];
  _RAND_4 = {1{`RANDOM}};
  source = _RAND_4[3:0];
  _RAND_5 = {1{`RANDOM}};
  address = _RAND_5[31:0];
  _RAND_6 = {1{`RANDOM}};
  d_first_counter = _RAND_6[8:0];
  _RAND_7 = {1{`RANDOM}};
  opcode_1 = _RAND_7[2:0];
  _RAND_8 = {1{`RANDOM}};
  param_1 = _RAND_8[1:0];
  _RAND_9 = {1{`RANDOM}};
  size_1 = _RAND_9[3:0];
  _RAND_10 = {1{`RANDOM}};
  source_1 = _RAND_10[3:0];
  _RAND_11 = {1{`RANDOM}};
  sink = _RAND_11[1:0];
  _RAND_12 = {1{`RANDOM}};
  denied = _RAND_12[0:0];
  _RAND_13 = {1{`RANDOM}};
  inflight = _RAND_13[15:0];
  _RAND_14 = {2{`RANDOM}};
  inflight_opcodes = _RAND_14[63:0];
  _RAND_15 = {4{`RANDOM}};
  inflight_sizes = _RAND_15[127:0];
  _RAND_16 = {1{`RANDOM}};
  a_first_counter_1 = _RAND_16[8:0];
  _RAND_17 = {1{`RANDOM}};
  d_first_counter_1 = _RAND_17[8:0];
  _RAND_18 = {1{`RANDOM}};
  watchdog = _RAND_18[31:0];
  _RAND_19 = {1{`RANDOM}};
  inflight_1 = _RAND_19[15:0];
  _RAND_20 = {4{`RANDOM}};
  inflight_sizes_1 = _RAND_20[127:0];
  _RAND_21 = {1{`RANDOM}};
  d_first_counter_2 = _RAND_21[8:0];
  _RAND_22 = {1{`RANDOM}};
  watchdog_1 = _RAND_22[31:0];
`endif // RANDOMIZE_REG_INIT
  `endif // RANDOMIZE
end // initial
`ifdef FIRRTL_AFTER_INITIAL
`FIRRTL_AFTER_INITIAL
`endif
`endif // SYNTHESIS
endmodule
module TLMonitor_1(
  input         clock,
  input         reset,
  input         io_in_a_ready,
  input         io_in_a_valid,
  input  [2:0]  io_in_a_bits_opcode,
  input  [2:0]  io_in_a_bits_param,
  input  [3:0]  io_in_a_bits_size,
  input  [1:0]  io_in_a_bits_source,
  input  [31:0] io_in_a_bits_address,
  input  [7:0]  io_in_a_bits_mask,
  input         io_in_a_bits_corrupt,
  input         io_in_b_ready,
  input         io_in_b_valid,
  input  [1:0]  io_in_b_bits_param,
  input  [1:0]  io_in_b_bits_source,
  input  [31:0] io_in_b_bits_address,
  input         io_in_c_ready,
  input         io_in_c_valid,
  input  [2:0]  io_in_c_bits_opcode,
  input  [2:0]  io_in_c_bits_param,
  input  [3:0]  io_in_c_bits_size,
  input  [1:0]  io_in_c_bits_source,
  input  [31:0] io_in_c_bits_address,
  input         io_in_c_bits_corrupt,
  input         io_in_d_ready,
  input         io_in_d_valid,
  input  [2:0]  io_in_d_bits_opcode,
  input  [1:0]  io_in_d_bits_param,
  input  [3:0]  io_in_d_bits_size,
  input  [1:0]  io_in_d_bits_source,
  input  [1:0]  io_in_d_bits_sink,
  input         io_in_d_bits_denied,
  input         io_in_d_bits_corrupt,
  input         io_in_e_ready,
  input         io_in_e_valid,
  input  [1:0]  io_in_e_bits_sink
);
`ifdef RANDOMIZE_REG_INIT
  reg [31:0] _RAND_0;
  reg [31:0] _RAND_1;
  reg [31:0] _RAND_2;
  reg [31:0] _RAND_3;
  reg [31:0] _RAND_4;
  reg [31:0] _RAND_5;
  reg [31:0] _RAND_6;
  reg [31:0] _RAND_7;
  reg [31:0] _RAND_8;
  reg [31:0] _RAND_9;
  reg [31:0] _RAND_10;
  reg [31:0] _RAND_11;
  reg [31:0] _RAND_12;
  reg [31:0] _RAND_13;
  reg [31:0] _RAND_14;
  reg [31:0] _RAND_15;
  reg [31:0] _RAND_16;
  reg [31:0] _RAND_17;
  reg [31:0] _RAND_18;
  reg [31:0] _RAND_19;
  reg [31:0] _RAND_20;
  reg [31:0] _RAND_21;
  reg [31:0] _RAND_22;
  reg [31:0] _RAND_23;
  reg [31:0] _RAND_24;
  reg [31:0] _RAND_25;
  reg [31:0] _RAND_26;
  reg [31:0] _RAND_27;
  reg [31:0] _RAND_28;
  reg [31:0] _RAND_29;
  reg [31:0] _RAND_30;
  reg [31:0] _RAND_31;
  reg [31:0] _RAND_32;
  reg [31:0] _RAND_33;
  reg [31:0] _RAND_34;
  reg [31:0] _RAND_35;
`endif // RANDOMIZE_REG_INIT
  wire [31:0] plusarg_reader_out; // @[PlusArg.scala 80:11]
  wire [31:0] plusarg_reader_1_out; // @[PlusArg.scala 80:11]
  wire  _source_ok_T = io_in_a_bits_source == 2'h0; // @[Parameters.scala 46:9]
  wire  _source_ok_T_1 = io_in_a_bits_source == 2'h1; // @[Parameters.scala 46:9]
  wire  _source_ok_T_2 = io_in_a_bits_source == 2'h2; // @[Parameters.scala 46:9]
  wire  source_ok = _source_ok_T | _source_ok_T_1 | _source_ok_T_2; // @[Parameters.scala 1125:46]
  wire [26:0] _is_aligned_mask_T_1 = 27'hfff << io_in_a_bits_size; // @[package.scala 234:77]
  wire [11:0] is_aligned_mask = ~_is_aligned_mask_T_1[11:0]; // @[package.scala 234:46]
  wire [31:0] _GEN_86 = {{20'd0}, is_aligned_mask}; // @[Edges.scala 20:16]
  wire [31:0] _is_aligned_T = io_in_a_bits_address & _GEN_86; // @[Edges.scala 20:16]
  wire  is_aligned = _is_aligned_T == 32'h0; // @[Edges.scala 20:24]
  wire [1:0] mask_sizeOH_shiftAmount = io_in_a_bits_size[1:0]; // @[OneHot.scala 64:49]
  wire [3:0] _mask_sizeOH_T_1 = 4'h1 << mask_sizeOH_shiftAmount; // @[OneHot.scala 65:12]
  wire [2:0] mask_sizeOH = _mask_sizeOH_T_1[2:0] | 3'h1; // @[Misc.scala 201:81]
  wire  _mask_T = io_in_a_bits_size >= 4'h3; // @[Misc.scala 205:21]
  wire  mask_size = mask_sizeOH[2]; // @[Misc.scala 208:26]
  wire  mask_bit = io_in_a_bits_address[2]; // @[Misc.scala 209:26]
  wire  mask_nbit = ~mask_bit; // @[Misc.scala 210:20]
  wire  mask_acc = _mask_T | mask_size & mask_nbit; // @[Misc.scala 214:29]
  wire  mask_acc_1 = _mask_T | mask_size & mask_bit; // @[Misc.scala 214:29]
  wire  mask_size_1 = mask_sizeOH[1]; // @[Misc.scala 208:26]
  wire  mask_bit_1 = io_in_a_bits_address[1]; // @[Misc.scala 209:26]
  wire  mask_nbit_1 = ~mask_bit_1; // @[Misc.scala 210:20]
  wire  mask_eq_2 = mask_nbit & mask_nbit_1; // @[Misc.scala 213:27]
  wire  mask_acc_2 = mask_acc | mask_size_1 & mask_eq_2; // @[Misc.scala 214:29]
  wire  mask_eq_3 = mask_nbit & mask_bit_1; // @[Misc.scala 213:27]
  wire  mask_acc_3 = mask_acc | mask_size_1 & mask_eq_3; // @[Misc.scala 214:29]
  wire  mask_eq_4 = mask_bit & mask_nbit_1; // @[Misc.scala 213:27]
  wire  mask_acc_4 = mask_acc_1 | mask_size_1 & mask_eq_4; // @[Misc.scala 214:29]
  wire  mask_eq_5 = mask_bit & mask_bit_1; // @[Misc.scala 213:27]
  wire  mask_acc_5 = mask_acc_1 | mask_size_1 & mask_eq_5; // @[Misc.scala 214:29]
  wire  mask_size_2 = mask_sizeOH[0]; // @[Misc.scala 208:26]
  wire  mask_bit_2 = io_in_a_bits_address[0]; // @[Misc.scala 209:26]
  wire  mask_nbit_2 = ~mask_bit_2; // @[Misc.scala 210:20]
  wire  mask_eq_6 = mask_eq_2 & mask_nbit_2; // @[Misc.scala 213:27]
  wire  mask_lo_lo_lo = mask_acc_2 | mask_size_2 & mask_eq_6; // @[Misc.scala 214:29]
  wire  mask_eq_7 = mask_eq_2 & mask_bit_2; // @[Misc.scala 213:27]
  wire  mask_lo_lo_hi = mask_acc_2 | mask_size_2 & mask_eq_7; // @[Misc.scala 214:29]
  wire  mask_eq_8 = mask_eq_3 & mask_nbit_2; // @[Misc.scala 213:27]
  wire  mask_lo_hi_lo = mask_acc_3 | mask_size_2 & mask_eq_8; // @[Misc.scala 214:29]
  wire  mask_eq_9 = mask_eq_3 & mask_bit_2; // @[Misc.scala 213:27]
  wire  mask_lo_hi_hi = mask_acc_3 | mask_size_2 & mask_eq_9; // @[Misc.scala 214:29]
  wire  mask_eq_10 = mask_eq_4 & mask_nbit_2; // @[Misc.scala 213:27]
  wire  mask_hi_lo_lo = mask_acc_4 | mask_size_2 & mask_eq_10; // @[Misc.scala 214:29]
  wire  mask_eq_11 = mask_eq_4 & mask_bit_2; // @[Misc.scala 213:27]
  wire  mask_hi_lo_hi = mask_acc_4 | mask_size_2 & mask_eq_11; // @[Misc.scala 214:29]
  wire  mask_eq_12 = mask_eq_5 & mask_nbit_2; // @[Misc.scala 213:27]
  wire  mask_hi_hi_lo = mask_acc_5 | mask_size_2 & mask_eq_12; // @[Misc.scala 214:29]
  wire  mask_eq_13 = mask_eq_5 & mask_bit_2; // @[Misc.scala 213:27]
  wire  mask_hi_hi_hi = mask_acc_5 | mask_size_2 & mask_eq_13; // @[Misc.scala 214:29]
  wire [7:0] mask = {mask_hi_hi_hi,mask_hi_hi_lo,mask_hi_lo_hi,mask_hi_lo_lo,mask_lo_hi_hi,mask_lo_hi_lo,mask_lo_lo_hi,
    mask_lo_lo_lo}; // @[Cat.scala 30:58]
  wire [32:0] _T_7 = {1'b0,$signed(io_in_a_bits_address)}; // @[Parameters.scala 137:49]
  wire  _T_33 = io_in_a_bits_opcode == 3'h6; // @[Monitor.scala 81:25]
  wire  _T_35 = io_in_a_bits_size <= 4'hc; // @[Parameters.scala 92:42]
  wire  _T_42 = _T_35 & source_ok; // @[Parameters.scala 1160:30]
  wire [32:0] _T_48 = $signed(_T_7) & -33'sh1000; // @[Parameters.scala 137:52]
  wire  _T_49 = $signed(_T_48) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _T_50 = io_in_a_bits_address ^ 32'h3000; // @[Parameters.scala 137:31]
  wire [32:0] _T_51 = {1'b0,$signed(_T_50)}; // @[Parameters.scala 137:49]
  wire [32:0] _T_53 = $signed(_T_51) & -33'sh1000; // @[Parameters.scala 137:52]
  wire  _T_54 = $signed(_T_53) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _T_55 = io_in_a_bits_address ^ 32'h10000; // @[Parameters.scala 137:31]
  wire [32:0] _T_56 = {1'b0,$signed(_T_55)}; // @[Parameters.scala 137:49]
  wire [32:0] _T_58 = $signed(_T_56) & -33'sh10000; // @[Parameters.scala 137:52]
  wire  _T_59 = $signed(_T_58) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _T_60 = io_in_a_bits_address ^ 32'h2000000; // @[Parameters.scala 137:31]
  wire [32:0] _T_61 = {1'b0,$signed(_T_60)}; // @[Parameters.scala 137:49]
  wire [32:0] _T_63 = $signed(_T_61) & -33'sh10000; // @[Parameters.scala 137:52]
  wire  _T_64 = $signed(_T_63) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _T_65 = io_in_a_bits_address ^ 32'hc000000; // @[Parameters.scala 137:31]
  wire [32:0] _T_66 = {1'b0,$signed(_T_65)}; // @[Parameters.scala 137:49]
  wire [32:0] _T_68 = $signed(_T_66) & -33'sh4000000; // @[Parameters.scala 137:52]
  wire  _T_69 = $signed(_T_68) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _T_70 = io_in_a_bits_address ^ 32'h10000000; // @[Parameters.scala 137:31]
  wire [32:0] _T_71 = {1'b0,$signed(_T_70)}; // @[Parameters.scala 137:49]
  wire [32:0] _T_73 = $signed(_T_71) & -33'sh10000000; // @[Parameters.scala 137:52]
  wire  _T_74 = $signed(_T_73) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _T_75 = io_in_a_bits_address ^ 32'h20000000; // @[Parameters.scala 137:31]
  wire [32:0] _T_76 = {1'b0,$signed(_T_75)}; // @[Parameters.scala 137:49]
  wire [32:0] _T_78 = $signed(_T_76) & -33'sh20000000; // @[Parameters.scala 137:52]
  wire  _T_79 = $signed(_T_78) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _T_80 = io_in_a_bits_address ^ 32'h40000000; // @[Parameters.scala 137:31]
  wire [32:0] _T_81 = {1'b0,$signed(_T_80)}; // @[Parameters.scala 137:49]
  wire [32:0] _T_83 = $signed(_T_81) & -33'sh40000000; // @[Parameters.scala 137:52]
  wire  _T_84 = $signed(_T_83) == 33'sh0; // @[Parameters.scala 137:67]
  wire  _T_94 = io_in_a_bits_size <= 4'h6; // @[Parameters.scala 92:42]
  wire [31:0] _T_97 = io_in_a_bits_address ^ 32'h80000000; // @[Parameters.scala 137:31]
  wire [32:0] _T_98 = {1'b0,$signed(_T_97)}; // @[Parameters.scala 137:49]
  wire [32:0] _T_100 = $signed(_T_98) & -33'sh80000000; // @[Parameters.scala 137:52]
  wire  _T_101 = $signed(_T_100) == 33'sh0; // @[Parameters.scala 137:67]
  wire  _T_102 = _T_94 & _T_101; // @[Parameters.scala 670:56]
  wire  _T_105 = _T_42 & _T_102; // @[Monitor.scala 82:72]
  wire  _T_112 = 4'h6 == io_in_a_bits_size; // @[Parameters.scala 91:48]
  wire  _T_113 = _source_ok_T & _T_112; // @[Mux.scala 27:72]
  wire  _T_174 = _T_49 | _T_54 | _T_59 | _T_64 | _T_69 | _T_74 | _T_79 | _T_84 | _T_101; // @[Parameters.scala 671:42]
  wire  _T_175 = _T_35 & _T_174; // @[Parameters.scala 670:56]
  wire  _T_177 = _T_113 & _T_175; // @[Monitor.scala 83:78]
  wire  _T_191 = io_in_a_bits_param <= 3'h2; // @[Bundles.scala 108:27]
  wire [7:0] _T_195 = ~io_in_a_bits_mask; // @[Monitor.scala 88:18]
  wire  _T_196 = _T_195 == 8'h0; // @[Monitor.scala 88:31]
  wire  _T_200 = ~io_in_a_bits_corrupt; // @[Monitor.scala 89:18]
  wire  _T_204 = io_in_a_bits_opcode == 3'h7; // @[Monitor.scala 92:25]
  wire  _T_366 = io_in_a_bits_param != 3'h0; // @[Monitor.scala 99:31]
  wire  _T_379 = io_in_a_bits_opcode == 3'h4; // @[Monitor.scala 104:25]
  wire  _T_402 = _T_35 & _T_54; // @[Parameters.scala 670:56]
  wire  _T_453 = _T_49 | _T_59 | _T_64 | _T_69 | _T_74 | _T_79 | _T_84 | _T_101; // @[Parameters.scala 671:42]
  wire  _T_454 = _T_94 & _T_453; // @[Parameters.scala 670:56]
  wire  _T_456 = _T_402 | _T_454; // @[Parameters.scala 672:30]
  wire  _T_466 = io_in_a_bits_param == 3'h0; // @[Monitor.scala 109:31]
  wire  _T_470 = io_in_a_bits_mask == mask; // @[Monitor.scala 110:30]
  wire  _T_478 = io_in_a_bits_opcode == 3'h0; // @[Monitor.scala 114:25]
  wire  _T_525 = _T_49 | _T_64 | _T_69 | _T_101; // @[Parameters.scala 671:42]
  wire  _T_526 = _T_94 & _T_525; // @[Parameters.scala 670:56]
  wire  _T_535 = io_in_a_bits_size <= 4'h8; // @[Parameters.scala 92:42]
  wire  _T_554 = _T_74 | _T_79 | _T_84; // @[Parameters.scala 671:42]
  wire  _T_555 = _T_535 & _T_554; // @[Parameters.scala 670:56]
  wire  _T_559 = _T_402 | _T_526 | _T_555; // @[Parameters.scala 672:30]
  wire  _T_560 = _T_42 & _T_559; // @[Monitor.scala 115:71]
  wire  _T_578 = io_in_a_bits_opcode == 3'h1; // @[Monitor.scala 122:25]
  wire [7:0] _T_674 = ~mask; // @[Monitor.scala 127:33]
  wire [7:0] _T_675 = io_in_a_bits_mask & _T_674; // @[Monitor.scala 127:31]
  wire  _T_676 = _T_675 == 8'h0; // @[Monitor.scala 127:40]
  wire  _T_680 = io_in_a_bits_opcode == 3'h2; // @[Monitor.scala 130:25]
  wire  _T_692 = io_in_a_bits_size <= 4'h3; // @[Parameters.scala 92:42]
  wire  _T_717 = _T_49 | _T_54 | _T_64 | _T_69; // @[Parameters.scala 671:42]
  wire  _T_718 = _T_692 & _T_717; // @[Parameters.scala 670:56]
  wire  _T_752 = _T_42 & _T_718; // @[Monitor.scala 131:74]
  wire  _T_762 = io_in_a_bits_param <= 3'h4; // @[Bundles.scala 138:33]
  wire  _T_770 = io_in_a_bits_opcode == 3'h3; // @[Monitor.scala 138:25]
  wire  _T_852 = io_in_a_bits_param <= 3'h3; // @[Bundles.scala 145:30]
  wire  _T_860 = io_in_a_bits_opcode == 3'h5; // @[Monitor.scala 146:25]
  wire  _T_932 = _T_42 & _T_402; // @[Monitor.scala 147:68]
  wire  _T_942 = io_in_a_bits_param <= 3'h1; // @[Bundles.scala 158:28]
  wire  _T_954 = io_in_d_bits_opcode <= 3'h6; // @[Bundles.scala 42:24]
  wire  _source_ok_T_4 = io_in_d_bits_source == 2'h0; // @[Parameters.scala 46:9]
  wire  _source_ok_T_5 = io_in_d_bits_source == 2'h1; // @[Parameters.scala 46:9]
  wire  _source_ok_T_6 = io_in_d_bits_source == 2'h2; // @[Parameters.scala 46:9]
  wire  source_ok_1 = _source_ok_T_4 | _source_ok_T_5 | _source_ok_T_6; // @[Parameters.scala 1125:46]
  wire  _T_958 = io_in_d_bits_opcode == 3'h6; // @[Monitor.scala 310:25]
  wire  _T_962 = io_in_d_bits_size >= 4'h3; // @[Monitor.scala 312:27]
  wire  _T_966 = io_in_d_bits_param == 2'h0; // @[Monitor.scala 313:28]
  wire  _T_970 = ~io_in_d_bits_corrupt; // @[Monitor.scala 314:15]
  wire  _T_974 = ~io_in_d_bits_denied; // @[Monitor.scala 315:15]
  wire  _T_978 = io_in_d_bits_opcode == 3'h4; // @[Monitor.scala 318:25]
  wire  _T_989 = io_in_d_bits_param <= 2'h2; // @[Bundles.scala 102:26]
  wire  _T_993 = io_in_d_bits_param != 2'h2; // @[Monitor.scala 323:28]
  wire  _T_1006 = io_in_d_bits_opcode == 3'h5; // @[Monitor.scala 328:25]
  wire  _T_1026 = _T_974 | io_in_d_bits_corrupt; // @[Monitor.scala 334:30]
  wire  _T_1035 = io_in_d_bits_opcode == 3'h0; // @[Monitor.scala 338:25]
  wire  _T_1052 = io_in_d_bits_opcode == 3'h1; // @[Monitor.scala 346:25]
  wire  _T_1070 = io_in_d_bits_opcode == 3'h2; // @[Monitor.scala 354:25]
  wire  _T_1091 = io_in_b_bits_source == 2'h0; // @[Parameters.scala 46:9]
  wire [32:0] _T_1094 = {1'b0,$signed(io_in_b_bits_address)}; // @[Parameters.scala 137:49]
  wire  _T_1099 = io_in_b_bits_source == 2'h1; // @[Parameters.scala 46:9]
  wire  _T_1107 = io_in_b_bits_source == 2'h2; // @[Parameters.scala 46:9]
  wire [31:0] _address_ok_T = io_in_b_bits_address ^ 32'h3000; // @[Parameters.scala 137:31]
  wire [32:0] _address_ok_T_1 = {1'b0,$signed(_address_ok_T)}; // @[Parameters.scala 137:49]
  wire [32:0] _address_ok_T_3 = $signed(_address_ok_T_1) & -33'sh1000; // @[Parameters.scala 137:52]
  wire  _address_ok_T_4 = $signed(_address_ok_T_3) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _address_ok_T_5 = io_in_b_bits_address ^ 32'hc000000; // @[Parameters.scala 137:31]
  wire [32:0] _address_ok_T_6 = {1'b0,$signed(_address_ok_T_5)}; // @[Parameters.scala 137:49]
  wire [32:0] _address_ok_T_8 = $signed(_address_ok_T_6) & -33'sh4000000; // @[Parameters.scala 137:52]
  wire  _address_ok_T_9 = $signed(_address_ok_T_8) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _address_ok_T_10 = io_in_b_bits_address ^ 32'h2000000; // @[Parameters.scala 137:31]
  wire [32:0] _address_ok_T_11 = {1'b0,$signed(_address_ok_T_10)}; // @[Parameters.scala 137:49]
  wire [32:0] _address_ok_T_13 = $signed(_address_ok_T_11) & -33'sh10000; // @[Parameters.scala 137:52]
  wire  _address_ok_T_14 = $signed(_address_ok_T_13) == 33'sh0; // @[Parameters.scala 137:67]
  wire [32:0] _address_ok_T_18 = $signed(_T_1094) & -33'sh1000; // @[Parameters.scala 137:52]
  wire  _address_ok_T_19 = $signed(_address_ok_T_18) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _address_ok_T_20 = io_in_b_bits_address ^ 32'h10000; // @[Parameters.scala 137:31]
  wire [32:0] _address_ok_T_21 = {1'b0,$signed(_address_ok_T_20)}; // @[Parameters.scala 137:49]
  wire [32:0] _address_ok_T_23 = $signed(_address_ok_T_21) & -33'sh10000; // @[Parameters.scala 137:52]
  wire  _address_ok_T_24 = $signed(_address_ok_T_23) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _address_ok_T_25 = io_in_b_bits_address ^ 32'h80000000; // @[Parameters.scala 137:31]
  wire [32:0] _address_ok_T_26 = {1'b0,$signed(_address_ok_T_25)}; // @[Parameters.scala 137:49]
  wire [32:0] _address_ok_T_28 = $signed(_address_ok_T_26) & -33'sh80000000; // @[Parameters.scala 137:52]
  wire  _address_ok_T_29 = $signed(_address_ok_T_28) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _address_ok_T_30 = io_in_b_bits_address ^ 32'h10000000; // @[Parameters.scala 137:31]
  wire [32:0] _address_ok_T_31 = {1'b0,$signed(_address_ok_T_30)}; // @[Parameters.scala 137:49]
  wire [32:0] _address_ok_T_33 = $signed(_address_ok_T_31) & -33'sh10000000; // @[Parameters.scala 137:52]
  wire  _address_ok_T_34 = $signed(_address_ok_T_33) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _address_ok_T_35 = io_in_b_bits_address ^ 32'h20000000; // @[Parameters.scala 137:31]
  wire [32:0] _address_ok_T_36 = {1'b0,$signed(_address_ok_T_35)}; // @[Parameters.scala 137:49]
  wire [32:0] _address_ok_T_38 = $signed(_address_ok_T_36) & -33'sh20000000; // @[Parameters.scala 137:52]
  wire  _address_ok_T_39 = $signed(_address_ok_T_38) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _address_ok_T_40 = io_in_b_bits_address ^ 32'h40000000; // @[Parameters.scala 137:31]
  wire [32:0] _address_ok_T_41 = {1'b0,$signed(_address_ok_T_40)}; // @[Parameters.scala 137:49]
  wire [32:0] _address_ok_T_43 = $signed(_address_ok_T_41) & -33'sh40000000; // @[Parameters.scala 137:52]
  wire  _address_ok_T_44 = $signed(_address_ok_T_43) == 33'sh0; // @[Parameters.scala 137:67]
  wire  _address_ok_T_46 = _address_ok_T_34 | _address_ok_T_39 | _address_ok_T_44; // @[Parameters.scala 598:92]
  wire  address_ok = _address_ok_T_4 | _address_ok_T_9 | _address_ok_T_14 | _address_ok_T_19 | _address_ok_T_24 |
    _address_ok_T_29 | _address_ok_T_46; // @[Parameters.scala 622:64]
  wire [31:0] _is_aligned_T_1 = io_in_b_bits_address & 32'h3f; // @[Edges.scala 20:16]
  wire  is_aligned_1 = _is_aligned_T_1 == 32'h0; // @[Edges.scala 20:24]
  wire [1:0] _legal_source_T_5 = _T_1107 ? 2'h2 : 2'h0; // @[Mux.scala 27:72]
  wire [1:0] _GEN_87 = {{1'd0}, _T_1099}; // @[Mux.scala 27:72]
  wire [1:0] _legal_source_T_7 = _GEN_87 | _legal_source_T_5; // @[Mux.scala 27:72]
  wire  legal_source = _legal_source_T_7 == io_in_b_bits_source; // @[Monitor.scala 165:113]
  wire  _T_1186 = _address_ok_T_19 | _address_ok_T_4 | _address_ok_T_24 | _address_ok_T_14 | _address_ok_T_9 |
    _address_ok_T_34 | _address_ok_T_39 | _address_ok_T_44 | _address_ok_T_29; // @[Parameters.scala 671:42]
  wire  _T_1189 = _T_1091 & _T_1186; // @[Monitor.scala 168:75]
  wire  _T_1202 = io_in_b_bits_param <= 2'h2; // @[Bundles.scala 102:26]
  wire  _source_ok_T_8 = io_in_c_bits_source == 2'h0; // @[Parameters.scala 46:9]
  wire  _source_ok_T_9 = io_in_c_bits_source == 2'h1; // @[Parameters.scala 46:9]
  wire  _source_ok_T_10 = io_in_c_bits_source == 2'h2; // @[Parameters.scala 46:9]
  wire  source_ok_2 = _source_ok_T_8 | _source_ok_T_9 | _source_ok_T_10; // @[Parameters.scala 1125:46]
  wire [26:0] _is_aligned_mask_T_7 = 27'hfff << io_in_c_bits_size; // @[package.scala 234:77]
  wire [11:0] is_aligned_mask_2 = ~_is_aligned_mask_T_7[11:0]; // @[package.scala 234:46]
  wire [31:0] _GEN_88 = {{20'd0}, is_aligned_mask_2}; // @[Edges.scala 20:16]
  wire [31:0] _is_aligned_T_2 = io_in_c_bits_address & _GEN_88; // @[Edges.scala 20:16]
  wire  is_aligned_2 = _is_aligned_T_2 == 32'h0; // @[Edges.scala 20:24]
  wire [31:0] _address_ok_T_52 = io_in_c_bits_address ^ 32'h3000; // @[Parameters.scala 137:31]
  wire [32:0] _address_ok_T_53 = {1'b0,$signed(_address_ok_T_52)}; // @[Parameters.scala 137:49]
  wire [32:0] _address_ok_T_55 = $signed(_address_ok_T_53) & -33'sh1000; // @[Parameters.scala 137:52]
  wire  _address_ok_T_56 = $signed(_address_ok_T_55) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _address_ok_T_57 = io_in_c_bits_address ^ 32'hc000000; // @[Parameters.scala 137:31]
  wire [32:0] _address_ok_T_58 = {1'b0,$signed(_address_ok_T_57)}; // @[Parameters.scala 137:49]
  wire [32:0] _address_ok_T_60 = $signed(_address_ok_T_58) & -33'sh4000000; // @[Parameters.scala 137:52]
  wire  _address_ok_T_61 = $signed(_address_ok_T_60) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _address_ok_T_62 = io_in_c_bits_address ^ 32'h2000000; // @[Parameters.scala 137:31]
  wire [32:0] _address_ok_T_63 = {1'b0,$signed(_address_ok_T_62)}; // @[Parameters.scala 137:49]
  wire [32:0] _address_ok_T_65 = $signed(_address_ok_T_63) & -33'sh10000; // @[Parameters.scala 137:52]
  wire  _address_ok_T_66 = $signed(_address_ok_T_65) == 33'sh0; // @[Parameters.scala 137:67]
  wire [32:0] _address_ok_T_68 = {1'b0,$signed(io_in_c_bits_address)}; // @[Parameters.scala 137:49]
  wire [32:0] _address_ok_T_70 = $signed(_address_ok_T_68) & -33'sh1000; // @[Parameters.scala 137:52]
  wire  _address_ok_T_71 = $signed(_address_ok_T_70) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _address_ok_T_72 = io_in_c_bits_address ^ 32'h10000; // @[Parameters.scala 137:31]
  wire [32:0] _address_ok_T_73 = {1'b0,$signed(_address_ok_T_72)}; // @[Parameters.scala 137:49]
  wire [32:0] _address_ok_T_75 = $signed(_address_ok_T_73) & -33'sh10000; // @[Parameters.scala 137:52]
  wire  _address_ok_T_76 = $signed(_address_ok_T_75) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _address_ok_T_77 = io_in_c_bits_address ^ 32'h80000000; // @[Parameters.scala 137:31]
  wire [32:0] _address_ok_T_78 = {1'b0,$signed(_address_ok_T_77)}; // @[Parameters.scala 137:49]
  wire [32:0] _address_ok_T_80 = $signed(_address_ok_T_78) & -33'sh80000000; // @[Parameters.scala 137:52]
  wire  _address_ok_T_81 = $signed(_address_ok_T_80) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _address_ok_T_82 = io_in_c_bits_address ^ 32'h10000000; // @[Parameters.scala 137:31]
  wire [32:0] _address_ok_T_83 = {1'b0,$signed(_address_ok_T_82)}; // @[Parameters.scala 137:49]
  wire [32:0] _address_ok_T_85 = $signed(_address_ok_T_83) & -33'sh10000000; // @[Parameters.scala 137:52]
  wire  _address_ok_T_86 = $signed(_address_ok_T_85) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _address_ok_T_87 = io_in_c_bits_address ^ 32'h20000000; // @[Parameters.scala 137:31]
  wire [32:0] _address_ok_T_88 = {1'b0,$signed(_address_ok_T_87)}; // @[Parameters.scala 137:49]
  wire [32:0] _address_ok_T_90 = $signed(_address_ok_T_88) & -33'sh20000000; // @[Parameters.scala 137:52]
  wire  _address_ok_T_91 = $signed(_address_ok_T_90) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _address_ok_T_92 = io_in_c_bits_address ^ 32'h40000000; // @[Parameters.scala 137:31]
  wire [32:0] _address_ok_T_93 = {1'b0,$signed(_address_ok_T_92)}; // @[Parameters.scala 137:49]
  wire [32:0] _address_ok_T_95 = $signed(_address_ok_T_93) & -33'sh40000000; // @[Parameters.scala 137:52]
  wire  _address_ok_T_96 = $signed(_address_ok_T_95) == 33'sh0; // @[Parameters.scala 137:67]
  wire  _address_ok_T_98 = _address_ok_T_86 | _address_ok_T_91 | _address_ok_T_96; // @[Parameters.scala 598:92]
  wire  address_ok_1 = _address_ok_T_56 | _address_ok_T_61 | _address_ok_T_66 | _address_ok_T_71 | _address_ok_T_76 |
    _address_ok_T_81 | _address_ok_T_98; // @[Parameters.scala 622:64]
  wire  _T_1739 = io_in_c_bits_opcode == 3'h4; // @[Monitor.scala 242:25]
  wire  _T_1746 = io_in_c_bits_size >= 4'h3; // @[Monitor.scala 245:30]
  wire  _T_1753 = io_in_c_bits_param <= 3'h5; // @[Bundles.scala 120:29]
  wire  _T_1757 = ~io_in_c_bits_corrupt; // @[Monitor.scala 248:18]
  wire  _T_1761 = io_in_c_bits_opcode == 3'h5; // @[Monitor.scala 251:25]
  wire  _T_1779 = io_in_c_bits_opcode == 3'h6; // @[Monitor.scala 259:25]
  wire  _T_1781 = io_in_c_bits_size <= 4'hc; // @[Parameters.scala 92:42]
  wire  _T_1788 = _T_1781 & source_ok_2; // @[Parameters.scala 1160:30]
  wire  _T_1840 = io_in_c_bits_size <= 4'h6; // @[Parameters.scala 92:42]
  wire  _T_1848 = _T_1840 & _address_ok_T_81; // @[Parameters.scala 670:56]
  wire  _T_1851 = _T_1788 & _T_1848; // @[Monitor.scala 260:78]
  wire  _T_1858 = 4'h6 == io_in_c_bits_size; // @[Parameters.scala 91:48]
  wire  _T_1859 = _source_ok_T_8 & _T_1858; // @[Mux.scala 27:72]
  wire  _T_1920 = _address_ok_T_71 | _address_ok_T_56 | _address_ok_T_76 | _address_ok_T_66 | _address_ok_T_61 |
    _address_ok_T_86 | _address_ok_T_91 | _address_ok_T_96 | _address_ok_T_81; // @[Parameters.scala 671:42]
  wire  _T_1921 = _T_1781 & _T_1920; // @[Parameters.scala 670:56]
  wire  _T_1923 = _T_1859 & _T_1921; // @[Monitor.scala 261:78]
  wire  _T_1945 = io_in_c_bits_opcode == 3'h7; // @[Monitor.scala 269:25]
  wire  _T_2107 = io_in_c_bits_opcode == 3'h0; // @[Monitor.scala 278:25]
  wire  _T_2117 = io_in_c_bits_param == 3'h0; // @[Monitor.scala 282:31]
  wire  _T_2125 = io_in_c_bits_opcode == 3'h1; // @[Monitor.scala 286:25]
  wire  _T_2139 = io_in_c_bits_opcode == 3'h2; // @[Monitor.scala 293:25]
  wire  _a_first_T = io_in_a_ready & io_in_a_valid; // @[Decoupled.scala 40:37]
  wire [8:0] a_first_beats1_decode = is_aligned_mask[11:3]; // @[Edges.scala 219:59]
  wire  a_first_beats1_opdata = ~io_in_a_bits_opcode[2]; // @[Edges.scala 91:28]
  reg [8:0] a_first_counter; // @[Edges.scala 228:27]
  wire [8:0] a_first_counter1 = a_first_counter - 9'h1; // @[Edges.scala 229:28]
  wire  a_first = a_first_counter == 9'h0; // @[Edges.scala 230:25]
  reg [2:0] opcode; // @[Monitor.scala 384:22]
  reg [2:0] param; // @[Monitor.scala 385:22]
  reg [3:0] size; // @[Monitor.scala 386:22]
  reg [1:0] source; // @[Monitor.scala 387:22]
  reg [31:0] address; // @[Monitor.scala 388:22]
  wire  _T_2161 = io_in_a_valid & ~a_first; // @[Monitor.scala 389:19]
  wire  _T_2162 = io_in_a_bits_opcode == opcode; // @[Monitor.scala 390:32]
  wire  _T_2166 = io_in_a_bits_param == param; // @[Monitor.scala 391:32]
  wire  _T_2170 = io_in_a_bits_size == size; // @[Monitor.scala 392:32]
  wire  _T_2174 = io_in_a_bits_source == source; // @[Monitor.scala 393:32]
  wire  _T_2178 = io_in_a_bits_address == address; // @[Monitor.scala 394:32]
  wire  _d_first_T = io_in_d_ready & io_in_d_valid; // @[Decoupled.scala 40:37]
  wire [26:0] _d_first_beats1_decode_T_1 = 27'hfff << io_in_d_bits_size; // @[package.scala 234:77]
  wire [11:0] _d_first_beats1_decode_T_3 = ~_d_first_beats1_decode_T_1[11:0]; // @[package.scala 234:46]
  wire [8:0] d_first_beats1_decode = _d_first_beats1_decode_T_3[11:3]; // @[Edges.scala 219:59]
  wire  d_first_beats1_opdata = io_in_d_bits_opcode[0]; // @[Edges.scala 105:36]
  reg [8:0] d_first_counter; // @[Edges.scala 228:27]
  wire [8:0] d_first_counter1 = d_first_counter - 9'h1; // @[Edges.scala 229:28]
  wire  d_first = d_first_counter == 9'h0; // @[Edges.scala 230:25]
  reg [2:0] opcode_1; // @[Monitor.scala 535:22]
  reg [1:0] param_1; // @[Monitor.scala 536:22]
  reg [3:0] size_1; // @[Monitor.scala 537:22]
  reg [1:0] source_1; // @[Monitor.scala 538:22]
  reg [1:0] sink; // @[Monitor.scala 539:22]
  reg  denied; // @[Monitor.scala 540:22]
  wire  _T_2185 = io_in_d_valid & ~d_first; // @[Monitor.scala 541:19]
  wire  _T_2186 = io_in_d_bits_opcode == opcode_1; // @[Monitor.scala 542:29]
  wire  _T_2190 = io_in_d_bits_param == param_1; // @[Monitor.scala 543:29]
  wire  _T_2194 = io_in_d_bits_size == size_1; // @[Monitor.scala 544:29]
  wire  _T_2198 = io_in_d_bits_source == source_1; // @[Monitor.scala 545:29]
  wire  _T_2202 = io_in_d_bits_sink == sink; // @[Monitor.scala 546:29]
  wire  _T_2206 = io_in_d_bits_denied == denied; // @[Monitor.scala 547:29]
  wire  b_first_done = io_in_b_ready & io_in_b_valid; // @[Decoupled.scala 40:37]
  reg [8:0] b_first_counter; // @[Edges.scala 228:27]
  wire [8:0] b_first_counter1 = b_first_counter - 9'h1; // @[Edges.scala 229:28]
  wire  b_first = b_first_counter == 9'h0; // @[Edges.scala 230:25]
  reg [1:0] param_2; // @[Monitor.scala 408:22]
  reg [1:0] source_2; // @[Monitor.scala 410:22]
  reg [31:0] address_1; // @[Monitor.scala 411:22]
  wire  _T_2213 = io_in_b_valid & ~b_first; // @[Monitor.scala 412:19]
  wire  _T_2218 = io_in_b_bits_param == param_2; // @[Monitor.scala 414:32]
  wire  _T_2226 = io_in_b_bits_source == source_2; // @[Monitor.scala 416:32]
  wire  _T_2230 = io_in_b_bits_address == address_1; // @[Monitor.scala 417:32]
  wire  _c_first_T = io_in_c_ready & io_in_c_valid; // @[Decoupled.scala 40:37]
  wire [8:0] c_first_beats1_decode = is_aligned_mask_2[11:3]; // @[Edges.scala 219:59]
  wire  c_first_beats1_opdata = io_in_c_bits_opcode[0]; // @[Edges.scala 101:36]
  reg [8:0] c_first_counter; // @[Edges.scala 228:27]
  wire [8:0] c_first_counter1 = c_first_counter - 9'h1; // @[Edges.scala 229:28]
  wire  c_first = c_first_counter == 9'h0; // @[Edges.scala 230:25]
  reg [2:0] opcode_3; // @[Monitor.scala 512:22]
  reg [2:0] param_3; // @[Monitor.scala 513:22]
  reg [3:0] size_3; // @[Monitor.scala 514:22]
  reg [1:0] source_3; // @[Monitor.scala 515:22]
  reg [31:0] address_2; // @[Monitor.scala 516:22]
  wire  _T_2237 = io_in_c_valid & ~c_first; // @[Monitor.scala 517:19]
  wire  _T_2238 = io_in_c_bits_opcode == opcode_3; // @[Monitor.scala 518:32]
  wire  _T_2242 = io_in_c_bits_param == param_3; // @[Monitor.scala 519:32]
  wire  _T_2246 = io_in_c_bits_size == size_3; // @[Monitor.scala 520:32]
  wire  _T_2250 = io_in_c_bits_source == source_3; // @[Monitor.scala 521:32]
  wire  _T_2254 = io_in_c_bits_address == address_2; // @[Monitor.scala 522:32]
  reg [2:0] inflight; // @[Monitor.scala 611:27]
  reg [11:0] inflight_opcodes; // @[Monitor.scala 613:35]
  reg [23:0] inflight_sizes; // @[Monitor.scala 615:33]
  reg [8:0] a_first_counter_1; // @[Edges.scala 228:27]
  wire [8:0] a_first_counter1_1 = a_first_counter_1 - 9'h1; // @[Edges.scala 229:28]
  wire  a_first_1 = a_first_counter_1 == 9'h0; // @[Edges.scala 230:25]
  reg [8:0] d_first_counter_1; // @[Edges.scala 228:27]
  wire [8:0] d_first_counter1_1 = d_first_counter_1 - 9'h1; // @[Edges.scala 229:28]
  wire  d_first_1 = d_first_counter_1 == 9'h0; // @[Edges.scala 230:25]
  wire [3:0] _GEN_89 = {io_in_d_bits_source, 2'h0}; // @[Monitor.scala 634:69]
  wire [4:0] _a_opcode_lookup_T = {{1'd0}, _GEN_89}; // @[Monitor.scala 634:69]
  wire [11:0] _a_opcode_lookup_T_1 = inflight_opcodes >> _a_opcode_lookup_T; // @[Monitor.scala 634:44]
  wire [15:0] _a_opcode_lookup_T_5 = 16'h10 - 16'h1; // @[Monitor.scala 609:57]
  wire [15:0] _GEN_90 = {{4'd0}, _a_opcode_lookup_T_1}; // @[Monitor.scala 634:97]
  wire [15:0] _a_opcode_lookup_T_6 = _GEN_90 & _a_opcode_lookup_T_5; // @[Monitor.scala 634:97]
  wire [15:0] _a_opcode_lookup_T_7 = {{1'd0}, _a_opcode_lookup_T_6[15:1]}; // @[Monitor.scala 634:152]
  wire [4:0] _a_size_lookup_T = {io_in_d_bits_source, 3'h0}; // @[Monitor.scala 638:65]
  wire [23:0] _a_size_lookup_T_1 = inflight_sizes >> _a_size_lookup_T; // @[Monitor.scala 638:40]
  wire [15:0] _a_size_lookup_T_5 = 16'h100 - 16'h1; // @[Monitor.scala 609:57]
  wire [23:0] _GEN_92 = {{8'd0}, _a_size_lookup_T_5}; // @[Monitor.scala 638:91]
  wire [23:0] _a_size_lookup_T_6 = _a_size_lookup_T_1 & _GEN_92; // @[Monitor.scala 638:91]
  wire [23:0] _a_size_lookup_T_7 = {{1'd0}, _a_size_lookup_T_6[23:1]}; // @[Monitor.scala 638:144]
  wire  _T_2260 = io_in_a_valid & a_first_1; // @[Monitor.scala 648:26]
  wire [3:0] _a_set_wo_ready_T = 4'h1 << io_in_a_bits_source; // @[OneHot.scala 58:35]
  wire [3:0] _GEN_27 = io_in_a_valid & a_first_1 ? _a_set_wo_ready_T : 4'h0; // @[Monitor.scala 648:71 Monitor.scala 649:22]
  wire  _T_2263 = _a_first_T & a_first_1; // @[Monitor.scala 652:27]
  wire [3:0] _a_opcodes_set_interm_T = {io_in_a_bits_opcode, 1'h0}; // @[Monitor.scala 654:53]
  wire [3:0] _a_opcodes_set_interm_T_1 = _a_opcodes_set_interm_T | 4'h1; // @[Monitor.scala 654:61]
  wire [4:0] _a_sizes_set_interm_T = {io_in_a_bits_size, 1'h0}; // @[Monitor.scala 655:51]
  wire [4:0] _a_sizes_set_interm_T_1 = _a_sizes_set_interm_T | 5'h1; // @[Monitor.scala 655:59]
  wire [3:0] _GEN_94 = {io_in_a_bits_source, 2'h0}; // @[Monitor.scala 656:79]
  wire [4:0] _a_opcodes_set_T = {{1'd0}, _GEN_94}; // @[Monitor.scala 656:79]
  wire [3:0] a_opcodes_set_interm = _a_first_T & a_first_1 ? _a_opcodes_set_interm_T_1 : 4'h0; // @[Monitor.scala 652:72 Monitor.scala 654:28]
  wire [34:0] _GEN_95 = {{31'd0}, a_opcodes_set_interm}; // @[Monitor.scala 656:54]
  wire [34:0] _a_opcodes_set_T_1 = _GEN_95 << _a_opcodes_set_T; // @[Monitor.scala 656:54]
  wire [4:0] _a_sizes_set_T = {io_in_a_bits_source, 3'h0}; // @[Monitor.scala 657:77]
  wire [4:0] a_sizes_set_interm = _a_first_T & a_first_1 ? _a_sizes_set_interm_T_1 : 5'h0; // @[Monitor.scala 652:72 Monitor.scala 655:28]
  wire [35:0] _GEN_96 = {{31'd0}, a_sizes_set_interm}; // @[Monitor.scala 657:52]
  wire [35:0] _a_sizes_set_T_1 = _GEN_96 << _a_sizes_set_T; // @[Monitor.scala 657:52]
  wire [2:0] _T_2265 = inflight >> io_in_a_bits_source; // @[Monitor.scala 658:26]
  wire  _T_2267 = ~_T_2265[0]; // @[Monitor.scala 658:17]
  wire [3:0] _GEN_28 = _a_first_T & a_first_1 ? _a_set_wo_ready_T : 4'h0; // @[Monitor.scala 652:72 Monitor.scala 653:28]
  wire [34:0] _GEN_31 = _a_first_T & a_first_1 ? _a_opcodes_set_T_1 : 35'h0; // @[Monitor.scala 652:72 Monitor.scala 656:28]
  wire [35:0] _GEN_32 = _a_first_T & a_first_1 ? _a_sizes_set_T_1 : 36'h0; // @[Monitor.scala 652:72 Monitor.scala 657:28]
  wire  _T_2271 = io_in_d_valid & d_first_1; // @[Monitor.scala 671:26]
  wire  _T_2273 = ~_T_958; // @[Monitor.scala 671:74]
  wire  _T_2274 = io_in_d_valid & d_first_1 & ~_T_958; // @[Monitor.scala 671:71]
  wire [3:0] _d_clr_wo_ready_T = 4'h1 << io_in_d_bits_source; // @[OneHot.scala 58:35]
  wire [3:0] _GEN_33 = io_in_d_valid & d_first_1 & ~_T_958 ? _d_clr_wo_ready_T : 4'h0; // @[Monitor.scala 671:90 Monitor.scala 672:22]
  wire [46:0] _GEN_98 = {{31'd0}, _a_opcode_lookup_T_5}; // @[Monitor.scala 677:76]
  wire [46:0] _d_opcodes_clr_T_5 = _GEN_98 << _a_opcode_lookup_T; // @[Monitor.scala 677:76]
  wire [46:0] _GEN_99 = {{31'd0}, _a_size_lookup_T_5}; // @[Monitor.scala 678:74]
  wire [46:0] _d_sizes_clr_T_5 = _GEN_99 << _a_size_lookup_T; // @[Monitor.scala 678:74]
  wire [3:0] _GEN_34 = _d_first_T & d_first_1 & _T_2273 ? _d_clr_wo_ready_T : 4'h0; // @[Monitor.scala 675:91 Monitor.scala 676:21]
  wire [46:0] _GEN_35 = _d_first_T & d_first_1 & _T_2273 ? _d_opcodes_clr_T_5 : 47'h0; // @[Monitor.scala 675:91 Monitor.scala 677:21]
  wire [46:0] _GEN_36 = _d_first_T & d_first_1 & _T_2273 ? _d_sizes_clr_T_5 : 47'h0; // @[Monitor.scala 675:91 Monitor.scala 678:21]
  wire  _same_cycle_resp_T_2 = io_in_a_bits_source == io_in_d_bits_source; // @[Monitor.scala 681:113]
  wire  same_cycle_resp = _T_2260 & io_in_a_bits_source == io_in_d_bits_source; // @[Monitor.scala 681:88]
  wire [2:0] _T_2284 = inflight >> io_in_d_bits_source; // @[Monitor.scala 682:25]
  wire  _T_2286 = _T_2284[0] | same_cycle_resp; // @[Monitor.scala 682:49]
  wire [2:0] _GEN_39 = 3'h2 == io_in_a_bits_opcode ? 3'h1 : 3'h0; // @[Monitor.scala 685:38 Monitor.scala 685:38]
  wire [2:0] _GEN_40 = 3'h3 == io_in_a_bits_opcode ? 3'h1 : _GEN_39; // @[Monitor.scala 685:38 Monitor.scala 685:38]
  wire [2:0] _GEN_41 = 3'h4 == io_in_a_bits_opcode ? 3'h1 : _GEN_40; // @[Monitor.scala 685:38 Monitor.scala 685:38]
  wire [2:0] _GEN_42 = 3'h5 == io_in_a_bits_opcode ? 3'h2 : _GEN_41; // @[Monitor.scala 685:38 Monitor.scala 685:38]
  wire [2:0] _GEN_43 = 3'h6 == io_in_a_bits_opcode ? 3'h4 : _GEN_42; // @[Monitor.scala 685:38 Monitor.scala 685:38]
  wire [2:0] _GEN_44 = 3'h7 == io_in_a_bits_opcode ? 3'h4 : _GEN_43; // @[Monitor.scala 685:38 Monitor.scala 685:38]
  wire [2:0] _GEN_51 = 3'h6 == io_in_a_bits_opcode ? 3'h5 : _GEN_42; // @[Monitor.scala 686:39 Monitor.scala 686:39]
  wire [2:0] _GEN_52 = 3'h7 == io_in_a_bits_opcode ? 3'h4 : _GEN_51; // @[Monitor.scala 686:39 Monitor.scala 686:39]
  wire  _T_2291 = io_in_d_bits_opcode == _GEN_52; // @[Monitor.scala 686:39]
  wire  _T_2292 = io_in_d_bits_opcode == _GEN_44 | _T_2291; // @[Monitor.scala 685:77]
  wire  _T_2296 = io_in_a_bits_size == io_in_d_bits_size; // @[Monitor.scala 687:36]
  wire [3:0] a_opcode_lookup = _a_opcode_lookup_T_7[3:0];
  wire [2:0] _GEN_55 = 3'h2 == a_opcode_lookup[2:0] ? 3'h1 : 3'h0; // @[Monitor.scala 689:38 Monitor.scala 689:38]
  wire [2:0] _GEN_56 = 3'h3 == a_opcode_lookup[2:0] ? 3'h1 : _GEN_55; // @[Monitor.scala 689:38 Monitor.scala 689:38]
  wire [2:0] _GEN_57 = 3'h4 == a_opcode_lookup[2:0] ? 3'h1 : _GEN_56; // @[Monitor.scala 689:38 Monitor.scala 689:38]
  wire [2:0] _GEN_58 = 3'h5 == a_opcode_lookup[2:0] ? 3'h2 : _GEN_57; // @[Monitor.scala 689:38 Monitor.scala 689:38]
  wire [2:0] _GEN_59 = 3'h6 == a_opcode_lookup[2:0] ? 3'h4 : _GEN_58; // @[Monitor.scala 689:38 Monitor.scala 689:38]
  wire [2:0] _GEN_60 = 3'h7 == a_opcode_lookup[2:0] ? 3'h4 : _GEN_59; // @[Monitor.scala 689:38 Monitor.scala 689:38]
  wire [2:0] _GEN_67 = 3'h6 == a_opcode_lookup[2:0] ? 3'h5 : _GEN_58; // @[Monitor.scala 690:38 Monitor.scala 690:38]
  wire [2:0] _GEN_68 = 3'h7 == a_opcode_lookup[2:0] ? 3'h4 : _GEN_67; // @[Monitor.scala 690:38 Monitor.scala 690:38]
  wire  _T_2303 = io_in_d_bits_opcode == _GEN_68; // @[Monitor.scala 690:38]
  wire  _T_2304 = io_in_d_bits_opcode == _GEN_60 | _T_2303; // @[Monitor.scala 689:72]
  wire [7:0] a_size_lookup = _a_size_lookup_T_7[7:0];
  wire [7:0] _GEN_100 = {{4'd0}, io_in_d_bits_size}; // @[Monitor.scala 691:36]
  wire  _T_2308 = _GEN_100 == a_size_lookup; // @[Monitor.scala 691:36]
  wire  _T_2318 = _T_2271 & a_first_1 & io_in_a_valid & _same_cycle_resp_T_2 & _T_2273; // @[Monitor.scala 694:116]
  wire  _T_2319 = ~io_in_d_ready; // @[Monitor.scala 695:15]
  wire  _T_2320 = ~io_in_d_ready | io_in_a_ready; // @[Monitor.scala 695:32]
  wire [2:0] a_set_wo_ready = _GEN_27[2:0];
  wire [2:0] d_clr_wo_ready = _GEN_33[2:0];
  wire  _T_2327 = a_set_wo_ready != d_clr_wo_ready | ~(|a_set_wo_ready); // @[Monitor.scala 699:48]
  wire [2:0] a_set = _GEN_28[2:0];
  wire [2:0] _inflight_T = inflight | a_set; // @[Monitor.scala 702:27]
  wire [2:0] d_clr = _GEN_34[2:0];
  wire [2:0] _inflight_T_1 = ~d_clr; // @[Monitor.scala 702:38]
  wire [2:0] _inflight_T_2 = _inflight_T & _inflight_T_1; // @[Monitor.scala 702:36]
  wire [11:0] a_opcodes_set = _GEN_31[11:0];
  wire [11:0] _inflight_opcodes_T = inflight_opcodes | a_opcodes_set; // @[Monitor.scala 703:43]
  wire [11:0] d_opcodes_clr = _GEN_35[11:0];
  wire [11:0] _inflight_opcodes_T_1 = ~d_opcodes_clr; // @[Monitor.scala 703:62]
  wire [11:0] _inflight_opcodes_T_2 = _inflight_opcodes_T & _inflight_opcodes_T_1; // @[Monitor.scala 703:60]
  wire [23:0] a_sizes_set = _GEN_32[23:0];
  wire [23:0] _inflight_sizes_T = inflight_sizes | a_sizes_set; // @[Monitor.scala 704:39]
  wire [23:0] d_sizes_clr = _GEN_36[23:0];
  wire [23:0] _inflight_sizes_T_1 = ~d_sizes_clr; // @[Monitor.scala 704:56]
  wire [23:0] _inflight_sizes_T_2 = _inflight_sizes_T & _inflight_sizes_T_1; // @[Monitor.scala 704:54]
  reg [31:0] watchdog; // @[Monitor.scala 706:27]
  wire  _T_2336 = ~(|inflight) | plusarg_reader_out == 32'h0 | watchdog < plusarg_reader_out; // @[Monitor.scala 709:47]
  wire [31:0] _watchdog_T_1 = watchdog + 32'h1; // @[Monitor.scala 711:26]
  reg [2:0] inflight_1; // @[Monitor.scala 723:35]
  reg [23:0] inflight_sizes_1; // @[Monitor.scala 725:35]
  reg [8:0] c_first_counter_1; // @[Edges.scala 228:27]
  wire [8:0] c_first_counter1_1 = c_first_counter_1 - 9'h1; // @[Edges.scala 229:28]
  wire  c_first_1 = c_first_counter_1 == 9'h0; // @[Edges.scala 230:25]
  reg [8:0] d_first_counter_2; // @[Edges.scala 228:27]
  wire [8:0] d_first_counter1_2 = d_first_counter_2 - 9'h1; // @[Edges.scala 229:28]
  wire  d_first_2 = d_first_counter_2 == 9'h0; // @[Edges.scala 230:25]
  wire [23:0] _c_size_lookup_T_1 = inflight_sizes_1 >> _a_size_lookup_T; // @[Monitor.scala 747:42]
  wire [23:0] _c_size_lookup_T_6 = _c_size_lookup_T_1 & _GEN_92; // @[Monitor.scala 747:93]
  wire [23:0] _c_size_lookup_T_7 = {{1'd0}, _c_size_lookup_T_6[23:1]}; // @[Monitor.scala 747:146]
  wire  _T_2346 = io_in_c_bits_opcode[2] & io_in_c_bits_opcode[1]; // @[Edges.scala 67:40]
  wire  _T_2347 = io_in_c_valid & c_first_1 & _T_2346; // @[Monitor.scala 756:37]
  wire [3:0] _c_set_wo_ready_T = 4'h1 << io_in_c_bits_source; // @[OneHot.scala 58:35]
  wire [3:0] _GEN_72 = io_in_c_valid & c_first_1 & _T_2346 ? _c_set_wo_ready_T : 4'h0; // @[Monitor.scala 756:71 Monitor.scala 757:22]
  wire  _T_2353 = _c_first_T & c_first_1 & _T_2346; // @[Monitor.scala 760:38]
  wire [4:0] _c_sizes_set_interm_T = {io_in_c_bits_size, 1'h0}; // @[Monitor.scala 763:51]
  wire [4:0] _c_sizes_set_interm_T_1 = _c_sizes_set_interm_T | 5'h1; // @[Monitor.scala 763:59]
  wire [4:0] _c_sizes_set_T = {io_in_c_bits_source, 3'h0}; // @[Monitor.scala 765:77]
  wire [4:0] c_sizes_set_interm = _c_first_T & c_first_1 & _T_2346 ? _c_sizes_set_interm_T_1 : 5'h0; // @[Monitor.scala 760:72 Monitor.scala 763:28]
  wire [35:0] _GEN_108 = {{31'd0}, c_sizes_set_interm}; // @[Monitor.scala 765:52]
  wire [35:0] _c_sizes_set_T_1 = _GEN_108 << _c_sizes_set_T; // @[Monitor.scala 765:52]
  wire [2:0] _T_2354 = inflight_1 >> io_in_c_bits_source; // @[Monitor.scala 766:26]
  wire  _T_2356 = ~_T_2354[0]; // @[Monitor.scala 766:17]
  wire [3:0] _GEN_73 = _c_first_T & c_first_1 & _T_2346 ? _c_set_wo_ready_T : 4'h0; // @[Monitor.scala 760:72 Monitor.scala 761:28]
  wire [35:0] _GEN_77 = _c_first_T & c_first_1 & _T_2346 ? _c_sizes_set_T_1 : 36'h0; // @[Monitor.scala 760:72 Monitor.scala 765:28]
  wire  _T_2360 = io_in_d_valid & d_first_2; // @[Monitor.scala 779:26]
  wire  _T_2362 = io_in_d_valid & d_first_2 & _T_958; // @[Monitor.scala 779:71]
  wire [3:0] _GEN_78 = io_in_d_valid & d_first_2 & _T_958 ? _d_clr_wo_ready_T : 4'h0; // @[Monitor.scala 779:89 Monitor.scala 780:22]
  wire [3:0] _GEN_79 = _d_first_T & d_first_2 & _T_958 ? _d_clr_wo_ready_T : 4'h0; // @[Monitor.scala 783:90 Monitor.scala 784:21]
  wire [46:0] _GEN_81 = _d_first_T & d_first_2 & _T_958 ? _d_sizes_clr_T_5 : 47'h0; // @[Monitor.scala 783:90 Monitor.scala 786:21]
  wire  _same_cycle_resp_T_8 = io_in_c_bits_source == io_in_d_bits_source; // @[Monitor.scala 790:113]
  wire  same_cycle_resp_1 = _T_2347 & io_in_c_bits_source == io_in_d_bits_source; // @[Monitor.scala 790:88]
  wire [2:0] _T_2370 = inflight_1 >> io_in_d_bits_source; // @[Monitor.scala 791:25]
  wire  _T_2372 = _T_2370[0] | same_cycle_resp_1; // @[Monitor.scala 791:49]
  wire  _T_2376 = io_in_d_bits_size == io_in_c_bits_size; // @[Monitor.scala 793:36]
  wire [7:0] c_size_lookup = _c_size_lookup_T_7[7:0];
  wire  _T_2380 = _GEN_100 == c_size_lookup; // @[Monitor.scala 795:36]
  wire  _T_2389 = _T_2360 & c_first_1 & io_in_c_valid & _same_cycle_resp_T_8 & _T_958; // @[Monitor.scala 799:116]
  wire  _T_2391 = _T_2319 | io_in_c_ready; // @[Monitor.scala 800:32]
  wire [2:0] c_set_wo_ready = _GEN_72[2:0];
  wire  _T_2395 = |c_set_wo_ready; // @[Monitor.scala 804:28]
  wire [2:0] d_clr_wo_ready_1 = _GEN_78[2:0];
  wire  _T_2396 = c_set_wo_ready != d_clr_wo_ready_1; // @[Monitor.scala 805:31]
  wire [2:0] c_set = _GEN_73[2:0];
  wire [2:0] _inflight_T_3 = inflight_1 | c_set; // @[Monitor.scala 809:35]
  wire [2:0] d_clr_1 = _GEN_79[2:0];
  wire [2:0] _inflight_T_4 = ~d_clr_1; // @[Monitor.scala 809:46]
  wire [2:0] _inflight_T_5 = _inflight_T_3 & _inflight_T_4; // @[Monitor.scala 809:44]
  wire [23:0] c_sizes_set = _GEN_77[23:0];
  wire [23:0] _inflight_sizes_T_3 = inflight_sizes_1 | c_sizes_set; // @[Monitor.scala 811:41]
  wire [23:0] d_sizes_clr_1 = _GEN_81[23:0];
  wire [23:0] _inflight_sizes_T_4 = ~d_sizes_clr_1; // @[Monitor.scala 811:58]
  wire [23:0] _inflight_sizes_T_5 = _inflight_sizes_T_3 & _inflight_sizes_T_4; // @[Monitor.scala 811:56]
  reg [31:0] watchdog_1; // @[Monitor.scala 813:27]
  wire  _T_2405 = ~(|inflight_1) | plusarg_reader_1_out == 32'h0 | watchdog_1 < plusarg_reader_1_out; // @[Monitor.scala 816:47]
  wire [31:0] _watchdog_T_3 = watchdog_1 + 32'h1; // @[Monitor.scala 818:26]
  reg [3:0] inflight_2; // @[Monitor.scala 823:27]
  reg [8:0] d_first_counter_3; // @[Edges.scala 228:27]
  wire [8:0] d_first_counter1_3 = d_first_counter_3 - 9'h1; // @[Edges.scala 229:28]
  wire  d_first_3 = d_first_counter_3 == 9'h0; // @[Edges.scala 230:25]
  wire  _T_2417 = io_in_d_bits_opcode[2] & ~io_in_d_bits_opcode[1]; // @[Edges.scala 70:40]
  wire  _T_2418 = _d_first_T & d_first_3 & _T_2417; // @[Monitor.scala 829:38]
  wire [3:0] _d_set_T = 4'h1 << io_in_d_bits_sink; // @[OneHot.scala 58:35]
  wire [3:0] _T_2419 = inflight_2 >> io_in_d_bits_sink; // @[Monitor.scala 831:23]
  wire  _T_2421 = ~_T_2419[0]; // @[Monitor.scala 831:14]
  wire [3:0] d_set = _d_first_T & d_first_3 & _T_2417 ? _d_set_T : 4'h0; // @[Monitor.scala 829:72 Monitor.scala 830:13]
  wire  _T_2425 = io_in_e_ready & io_in_e_valid; // @[Decoupled.scala 40:37]
  wire [3:0] _e_clr_T = 4'h1 << io_in_e_bits_sink; // @[OneHot.scala 58:35]
  wire [3:0] _T_2428 = d_set | inflight_2; // @[Monitor.scala 837:24]
  wire [3:0] _T_2429 = _T_2428 >> io_in_e_bits_sink; // @[Monitor.scala 837:35]
  wire [3:0] e_clr = _T_2425 ? _e_clr_T : 4'h0; // @[Monitor.scala 835:73 Monitor.scala 836:13]
  wire [3:0] _inflight_T_6 = inflight_2 | d_set; // @[Monitor.scala 842:27]
  wire [3:0] _inflight_T_7 = ~e_clr; // @[Monitor.scala 842:38]
  wire [3:0] _inflight_T_8 = _inflight_T_6 & _inflight_T_7; // @[Monitor.scala 842:36]
  plusarg_reader #(.FORMAT("tilelink_timeout=%d"), .DEFAULT(0), .WIDTH(32)) plusarg_reader ( // @[PlusArg.scala 80:11]
    .out(plusarg_reader_out)
  );
  plusarg_reader #(.FORMAT("tilelink_timeout=%d"), .DEFAULT(0), .WIDTH(32)) plusarg_reader_1 ( // @[PlusArg.scala 80:11]
    .out(plusarg_reader_1_out)
  );
  always @(posedge clock) begin
    if (reset) begin // @[Edges.scala 228:27]
      a_first_counter <= 9'h0; // @[Edges.scala 228:27]
    end else if (_a_first_T) begin // @[Edges.scala 234:17]
      if (a_first) begin // @[Edges.scala 235:21]
        if (a_first_beats1_opdata) begin // @[Edges.scala 220:14]
          a_first_counter <= a_first_beats1_decode;
        end else begin
          a_first_counter <= 9'h0;
        end
      end else begin
        a_first_counter <= a_first_counter1;
      end
    end
    if (_a_first_T & a_first) begin // @[Monitor.scala 396:32]
      opcode <= io_in_a_bits_opcode; // @[Monitor.scala 397:15]
    end
    if (_a_first_T & a_first) begin // @[Monitor.scala 396:32]
      param <= io_in_a_bits_param; // @[Monitor.scala 398:15]
    end
    if (_a_first_T & a_first) begin // @[Monitor.scala 396:32]
      size <= io_in_a_bits_size; // @[Monitor.scala 399:15]
    end
    if (_a_first_T & a_first) begin // @[Monitor.scala 396:32]
      source <= io_in_a_bits_source; // @[Monitor.scala 400:15]
    end
    if (_a_first_T & a_first) begin // @[Monitor.scala 396:32]
      address <= io_in_a_bits_address; // @[Monitor.scala 401:15]
    end
    if (reset) begin // @[Edges.scala 228:27]
      d_first_counter <= 9'h0; // @[Edges.scala 228:27]
    end else if (_d_first_T) begin // @[Edges.scala 234:17]
      if (d_first) begin // @[Edges.scala 235:21]
        if (d_first_beats1_opdata) begin // @[Edges.scala 220:14]
          d_first_counter <= d_first_beats1_decode;
        end else begin
          d_first_counter <= 9'h0;
        end
      end else begin
        d_first_counter <= d_first_counter1;
      end
    end
    if (_d_first_T & d_first) begin // @[Monitor.scala 549:32]
      opcode_1 <= io_in_d_bits_opcode; // @[Monitor.scala 550:15]
    end
    if (_d_first_T & d_first) begin // @[Monitor.scala 549:32]
      param_1 <= io_in_d_bits_param; // @[Monitor.scala 551:15]
    end
    if (_d_first_T & d_first) begin // @[Monitor.scala 549:32]
      size_1 <= io_in_d_bits_size; // @[Monitor.scala 552:15]
    end
    if (_d_first_T & d_first) begin // @[Monitor.scala 549:32]
      source_1 <= io_in_d_bits_source; // @[Monitor.scala 553:15]
    end
    if (_d_first_T & d_first) begin // @[Monitor.scala 549:32]
      sink <= io_in_d_bits_sink; // @[Monitor.scala 554:15]
    end
    if (_d_first_T & d_first) begin // @[Monitor.scala 549:32]
      denied <= io_in_d_bits_denied; // @[Monitor.scala 555:15]
    end
    if (reset) begin // @[Edges.scala 228:27]
      b_first_counter <= 9'h0; // @[Edges.scala 228:27]
    end else if (b_first_done) begin // @[Edges.scala 234:17]
      if (b_first) begin // @[Edges.scala 235:21]
        b_first_counter <= 9'h0;
      end else begin
        b_first_counter <= b_first_counter1;
      end
    end
    if (b_first_done & b_first) begin // @[Monitor.scala 419:32]
      param_2 <= io_in_b_bits_param; // @[Monitor.scala 421:15]
    end
    if (b_first_done & b_first) begin // @[Monitor.scala 419:32]
      source_2 <= io_in_b_bits_source; // @[Monitor.scala 423:15]
    end
    if (b_first_done & b_first) begin // @[Monitor.scala 419:32]
      address_1 <= io_in_b_bits_address; // @[Monitor.scala 424:15]
    end
    if (reset) begin // @[Edges.scala 228:27]
      c_first_counter <= 9'h0; // @[Edges.scala 228:27]
    end else if (_c_first_T) begin // @[Edges.scala 234:17]
      if (c_first) begin // @[Edges.scala 235:21]
        if (c_first_beats1_opdata) begin // @[Edges.scala 220:14]
          c_first_counter <= c_first_beats1_decode;
        end else begin
          c_first_counter <= 9'h0;
        end
      end else begin
        c_first_counter <= c_first_counter1;
      end
    end
    if (_c_first_T & c_first) begin // @[Monitor.scala 524:32]
      opcode_3 <= io_in_c_bits_opcode; // @[Monitor.scala 525:15]
    end
    if (_c_first_T & c_first) begin // @[Monitor.scala 524:32]
      param_3 <= io_in_c_bits_param; // @[Monitor.scala 526:15]
    end
    if (_c_first_T & c_first) begin // @[Monitor.scala 524:32]
      size_3 <= io_in_c_bits_size; // @[Monitor.scala 527:15]
    end
    if (_c_first_T & c_first) begin // @[Monitor.scala 524:32]
      source_3 <= io_in_c_bits_source; // @[Monitor.scala 528:15]
    end
    if (_c_first_T & c_first) begin // @[Monitor.scala 524:32]
      address_2 <= io_in_c_bits_address; // @[Monitor.scala 529:15]
    end
    if (reset) begin // @[Monitor.scala 611:27]
      inflight <= 3'h0; // @[Monitor.scala 611:27]
    end else begin
      inflight <= _inflight_T_2; // @[Monitor.scala 702:14]
    end
    if (reset) begin // @[Monitor.scala 613:35]
      inflight_opcodes <= 12'h0; // @[Monitor.scala 613:35]
    end else begin
      inflight_opcodes <= _inflight_opcodes_T_2; // @[Monitor.scala 703:22]
    end
    if (reset) begin // @[Monitor.scala 615:33]
      inflight_sizes <= 24'h0; // @[Monitor.scala 615:33]
    end else begin
      inflight_sizes <= _inflight_sizes_T_2; // @[Monitor.scala 704:20]
    end
    if (reset) begin // @[Edges.scala 228:27]
      a_first_counter_1 <= 9'h0; // @[Edges.scala 228:27]
    end else if (_a_first_T) begin // @[Edges.scala 234:17]
      if (a_first_1) begin // @[Edges.scala 235:21]
        if (a_first_beats1_opdata) begin // @[Edges.scala 220:14]
          a_first_counter_1 <= a_first_beats1_decode;
        end else begin
          a_first_counter_1 <= 9'h0;
        end
      end else begin
        a_first_counter_1 <= a_first_counter1_1;
      end
    end
    if (reset) begin // @[Edges.scala 228:27]
      d_first_counter_1 <= 9'h0; // @[Edges.scala 228:27]
    end else if (_d_first_T) begin // @[Edges.scala 234:17]
      if (d_first_1) begin // @[Edges.scala 235:21]
        if (d_first_beats1_opdata) begin // @[Edges.scala 220:14]
          d_first_counter_1 <= d_first_beats1_decode;
        end else begin
          d_first_counter_1 <= 9'h0;
        end
      end else begin
        d_first_counter_1 <= d_first_counter1_1;
      end
    end
    if (reset) begin // @[Monitor.scala 706:27]
      watchdog <= 32'h0; // @[Monitor.scala 706:27]
    end else if (_a_first_T | _d_first_T) begin // @[Monitor.scala 712:47]
      watchdog <= 32'h0; // @[Monitor.scala 712:58]
    end else begin
      watchdog <= _watchdog_T_1; // @[Monitor.scala 711:14]
    end
    if (reset) begin // @[Monitor.scala 723:35]
      inflight_1 <= 3'h0; // @[Monitor.scala 723:35]
    end else begin
      inflight_1 <= _inflight_T_5; // @[Monitor.scala 809:22]
    end
    if (reset) begin // @[Monitor.scala 725:35]
      inflight_sizes_1 <= 24'h0; // @[Monitor.scala 725:35]
    end else begin
      inflight_sizes_1 <= _inflight_sizes_T_5; // @[Monitor.scala 811:22]
    end
    if (reset) begin // @[Edges.scala 228:27]
      c_first_counter_1 <= 9'h0; // @[Edges.scala 228:27]
    end else if (_c_first_T) begin // @[Edges.scala 234:17]
      if (c_first_1) begin // @[Edges.scala 235:21]
        if (c_first_beats1_opdata) begin // @[Edges.scala 220:14]
          c_first_counter_1 <= c_first_beats1_decode;
        end else begin
          c_first_counter_1 <= 9'h0;
        end
      end else begin
        c_first_counter_1 <= c_first_counter1_1;
      end
    end
    if (reset) begin // @[Edges.scala 228:27]
      d_first_counter_2 <= 9'h0; // @[Edges.scala 228:27]
    end else if (_d_first_T) begin // @[Edges.scala 234:17]
      if (d_first_2) begin // @[Edges.scala 235:21]
        if (d_first_beats1_opdata) begin // @[Edges.scala 220:14]
          d_first_counter_2 <= d_first_beats1_decode;
        end else begin
          d_first_counter_2 <= 9'h0;
        end
      end else begin
        d_first_counter_2 <= d_first_counter1_2;
      end
    end
    if (reset) begin // @[Monitor.scala 813:27]
      watchdog_1 <= 32'h0; // @[Monitor.scala 813:27]
    end else if (_c_first_T | _d_first_T) begin // @[Monitor.scala 819:47]
      watchdog_1 <= 32'h0; // @[Monitor.scala 819:58]
    end else begin
      watchdog_1 <= _watchdog_T_3; // @[Monitor.scala 818:14]
    end
    if (reset) begin // @[Monitor.scala 823:27]
      inflight_2 <= 4'h0; // @[Monitor.scala 823:27]
    end else begin
      inflight_2 <= _inflight_T_8; // @[Monitor.scala 842:14]
    end
    if (reset) begin // @[Edges.scala 228:27]
      d_first_counter_3 <= 9'h0; // @[Edges.scala 228:27]
    end else if (_d_first_T) begin // @[Edges.scala 234:17]
      if (d_first_3) begin // @[Edges.scala 235:21]
        if (d_first_beats1_opdata) begin // @[Edges.scala 220:14]
          d_first_counter_3 <= d_first_beats1_decode;
        end else begin
          d_first_counter_3 <= 9'h0;
        end
      end else begin
        d_first_counter_3 <= d_first_counter1_3;
      end
    end
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_33 & ~(_T_105 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries AcquireBlock type which is unexpected using diplomatic parameters (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_33 & ~(_T_105 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_33 & ~(_T_177 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries AcquireBlock from a client which does not support Probe (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_33 & ~(_T_177 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_33 & ~(source_ok | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquireBlock carries invalid source ID (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_33 & ~(source_ok | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_33 & ~(_mask_T | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquireBlock smaller than a beat (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_33 & ~(_mask_T | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_33 & ~(is_aligned | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquireBlock address not aligned to size (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_33 & ~(is_aligned | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_33 & ~(_T_191 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquireBlock carries invalid grow param (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_33 & ~(_T_191 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_33 & ~(_T_196 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquireBlock contains invalid mask (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_33 & ~(_T_196 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_33 & ~(_T_200 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquireBlock is corrupt (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_33 & ~(_T_200 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_204 & ~(_T_105 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries AcquirePerm type which is unexpected using diplomatic parameters (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_204 & ~(_T_105 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_204 & ~(_T_177 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries AcquirePerm from a client which does not support Probe (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_204 & ~(_T_177 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_204 & ~(source_ok | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquirePerm carries invalid source ID (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_204 & ~(source_ok | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_204 & ~(_mask_T | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquirePerm smaller than a beat (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_204 & ~(_mask_T | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_204 & ~(is_aligned | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquirePerm address not aligned to size (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_204 & ~(is_aligned | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_204 & ~(_T_191 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquirePerm carries invalid grow param (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_204 & ~(_T_191 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_204 & ~(_T_366 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquirePerm requests NtoB (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_204 & ~(_T_366 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_204 & ~(_T_196 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquirePerm contains invalid mask (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_204 & ~(_T_196 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_204 & ~(_T_200 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquirePerm is corrupt (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_204 & ~(_T_200 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_379 & ~(_T_42 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries Get type which master claims it can't emit (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_379 & ~(_T_42 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_379 & ~(_T_456 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries Get type which slave claims it can't support (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_379 & ~(_T_456 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_379 & ~(source_ok | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Get carries invalid source ID (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_379 & ~(source_ok | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_379 & ~(is_aligned | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Get address not aligned to size (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_379 & ~(is_aligned | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_379 & ~(_T_466 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Get carries invalid param (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_379 & ~(_T_466 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_379 & ~(_T_470 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Get contains invalid mask (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_379 & ~(_T_470 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_379 & ~(_T_200 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Get is corrupt (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_379 & ~(_T_200 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_478 & ~(_T_560 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries PutFull type which is unexpected using diplomatic parameters (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_478 & ~(_T_560 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_478 & ~(source_ok | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel PutFull carries invalid source ID (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_478 & ~(source_ok | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_478 & ~(is_aligned | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel PutFull address not aligned to size (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_478 & ~(is_aligned | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_478 & ~(_T_466 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel PutFull carries invalid param (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_478 & ~(_T_466 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_478 & ~(_T_470 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel PutFull contains invalid mask (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_478 & ~(_T_470 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_578 & ~(_T_560 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries PutPartial type which is unexpected using diplomatic parameters (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_578 & ~(_T_560 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_578 & ~(source_ok | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel PutPartial carries invalid source ID (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_578 & ~(source_ok | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_578 & ~(is_aligned | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel PutPartial address not aligned to size (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_578 & ~(is_aligned | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_578 & ~(_T_466 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel PutPartial carries invalid param (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_578 & ~(_T_466 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_578 & ~(_T_676 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel PutPartial contains invalid mask (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_578 & ~(_T_676 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_680 & ~(_T_752 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries Arithmetic type which is unexpected using diplomatic parameters (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_680 & ~(_T_752 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_680 & ~(source_ok | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Arithmetic carries invalid source ID (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_680 & ~(source_ok | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_680 & ~(is_aligned | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Arithmetic address not aligned to size (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_680 & ~(is_aligned | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_680 & ~(_T_762 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Arithmetic carries invalid opcode param (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_680 & ~(_T_762 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_680 & ~(_T_470 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Arithmetic contains invalid mask (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_680 & ~(_T_470 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_770 & ~(_T_752 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries Logical type which is unexpected using diplomatic parameters (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_770 & ~(_T_752 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_770 & ~(source_ok | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Logical carries invalid source ID (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_770 & ~(source_ok | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_770 & ~(is_aligned | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Logical address not aligned to size (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_770 & ~(is_aligned | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_770 & ~(_T_852 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Logical carries invalid opcode param (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_770 & ~(_T_852 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_770 & ~(_T_470 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Logical contains invalid mask (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_770 & ~(_T_470 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_860 & ~(_T_932 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries Hint type which is unexpected using diplomatic parameters (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_860 & ~(_T_932 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_860 & ~(source_ok | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Hint carries invalid source ID (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_860 & ~(source_ok | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_860 & ~(is_aligned | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Hint address not aligned to size (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_860 & ~(is_aligned | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_860 & ~(_T_942 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Hint carries invalid opcode param (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_860 & ~(_T_942 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_860 & ~(_T_470 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Hint contains invalid mask (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_860 & ~(_T_470 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_860 & ~(_T_200 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Hint is corrupt (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_860 & ~(_T_200 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & ~(_T_954 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel has invalid opcode (connected at SystemBus.scala:41:55)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & ~(_T_954 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_958 & ~(source_ok_1 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel ReleaseAck carries invalid source ID (connected at SystemBus.scala:41:55)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_958 & ~(source_ok_1 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_958 & ~(_T_962 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel ReleaseAck smaller than a beat (connected at SystemBus.scala:41:55)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_958 & ~(_T_962 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_958 & ~(_T_966 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel ReleaseeAck carries invalid param (connected at SystemBus.scala:41:55)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_958 & ~(_T_966 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_958 & ~(_T_970 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel ReleaseAck is corrupt (connected at SystemBus.scala:41:55)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_958 & ~(_T_970 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_958 & ~(_T_974 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel ReleaseAck is denied (connected at SystemBus.scala:41:55)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_958 & ~(_T_974 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_978 & ~(source_ok_1 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel Grant carries invalid source ID (connected at SystemBus.scala:41:55)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_978 & ~(source_ok_1 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_978 & ~(_T_962 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel Grant smaller than a beat (connected at SystemBus.scala:41:55)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_978 & ~(_T_962 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_978 & ~(_T_989 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel Grant carries invalid cap param (connected at SystemBus.scala:41:55)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_978 & ~(_T_989 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_978 & ~(_T_993 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel Grant carries toN param (connected at SystemBus.scala:41:55)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_978 & ~(_T_993 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_978 & ~(_T_970 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel Grant is corrupt (connected at SystemBus.scala:41:55)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_978 & ~(_T_970 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_1006 & ~(source_ok_1 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel GrantData carries invalid source ID (connected at SystemBus.scala:41:55)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_1006 & ~(source_ok_1 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_1006 & ~(_T_962 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel GrantData smaller than a beat (connected at SystemBus.scala:41:55)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_1006 & ~(_T_962 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_1006 & ~(_T_989 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel GrantData carries invalid cap param (connected at SystemBus.scala:41:55)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_1006 & ~(_T_989 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_1006 & ~(_T_993 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel GrantData carries toN param (connected at SystemBus.scala:41:55)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_1006 & ~(_T_993 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_1006 & ~(_T_1026 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel GrantData is denied but not corrupt (connected at SystemBus.scala:41:55)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_1006 & ~(_T_1026 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_1035 & ~(source_ok_1 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel AccessAck carries invalid source ID (connected at SystemBus.scala:41:55)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_1035 & ~(source_ok_1 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_1035 & ~(_T_966 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel AccessAck carries invalid param (connected at SystemBus.scala:41:55)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_1035 & ~(_T_966 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_1035 & ~(_T_970 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel AccessAck is corrupt (connected at SystemBus.scala:41:55)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_1035 & ~(_T_970 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_1052 & ~(source_ok_1 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel AccessAckData carries invalid source ID (connected at SystemBus.scala:41:55)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_1052 & ~(source_ok_1 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_1052 & ~(_T_966 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel AccessAckData carries invalid param (connected at SystemBus.scala:41:55)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_1052 & ~(_T_966 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_1052 & ~(_T_1026 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel AccessAckData is denied but not corrupt (connected at SystemBus.scala:41:55)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_1052 & ~(_T_1026 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_1070 & ~(source_ok_1 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel HintAck carries invalid source ID (connected at SystemBus.scala:41:55)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_1070 & ~(source_ok_1 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_1070 & ~(_T_966 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel HintAck carries invalid param (connected at SystemBus.scala:41:55)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_1070 & ~(_T_966 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_1070 & ~(_T_970 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel HintAck is corrupt (connected at SystemBus.scala:41:55)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_1070 & ~(_T_970 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_b_valid & ~(_T_1189 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'B' channel carries Probe type which is unexpected using diplomatic parameters (connected at SystemBus.scala:41:55)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_b_valid & ~(_T_1189 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_b_valid & ~(address_ok | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'B' channel Probe carries unmanaged address (connected at SystemBus.scala:41:55)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_b_valid & ~(address_ok | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_b_valid & ~(legal_source | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'B' channel Probe carries source that is not first source (connected at SystemBus.scala:41:55)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_b_valid & ~(legal_source | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_b_valid & ~(is_aligned_1 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'B' channel Probe address not aligned to size (connected at SystemBus.scala:41:55)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_b_valid & ~(is_aligned_1 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_b_valid & ~(_T_1202 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'B' channel Probe carries invalid cap param (connected at SystemBus.scala:41:55)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_b_valid & ~(_T_1202 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1739 & ~(address_ok_1 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel ProbeAck carries unmanaged address (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1739 & ~(address_ok_1 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1739 & ~(source_ok_2 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel ProbeAck carries invalid source ID (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1739 & ~(source_ok_2 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1739 & ~(_T_1746 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel ProbeAck smaller than a beat (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1739 & ~(_T_1746 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1739 & ~(is_aligned_2 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel ProbeAck address not aligned to size (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1739 & ~(is_aligned_2 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1739 & ~(_T_1753 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel ProbeAck carries invalid report param (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1739 & ~(_T_1753 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1739 & ~(_T_1757 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel ProbeAck is corrupt (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1739 & ~(_T_1757 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1761 & ~(address_ok_1 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel ProbeAckData carries unmanaged address (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1761 & ~(address_ok_1 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1761 & ~(source_ok_2 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel ProbeAckData carries invalid source ID (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1761 & ~(source_ok_2 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1761 & ~(_T_1746 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel ProbeAckData smaller than a beat (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1761 & ~(_T_1746 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1761 & ~(is_aligned_2 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel ProbeAckData address not aligned to size (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1761 & ~(is_aligned_2 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1761 & ~(_T_1753 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel ProbeAckData carries invalid report param (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1761 & ~(_T_1753 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1779 & ~(_T_1851 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel carries Release type unsupported by manager (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1779 & ~(_T_1851 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1779 & ~(_T_1923 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel carries Release from a client which does not support Probe (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1779 & ~(_T_1923 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1779 & ~(source_ok_2 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel Release carries invalid source ID (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1779 & ~(source_ok_2 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1779 & ~(_T_1746 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel Release smaller than a beat (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1779 & ~(_T_1746 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1779 & ~(is_aligned_2 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel Release address not aligned to size (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1779 & ~(is_aligned_2 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1779 & ~(_T_1753 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel Release carries invalid report param (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1779 & ~(_T_1753 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1779 & ~(_T_1757 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel Release is corrupt (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1779 & ~(_T_1757 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1945 & ~(_T_1851 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel carries ReleaseData type unsupported by manager (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1945 & ~(_T_1851 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1945 & ~(_T_1923 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel carries Release from a client which does not support Probe (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1945 & ~(_T_1923 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1945 & ~(source_ok_2 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel ReleaseData carries invalid source ID (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1945 & ~(source_ok_2 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1945 & ~(_T_1746 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel ReleaseData smaller than a beat (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1945 & ~(_T_1746 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1945 & ~(is_aligned_2 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel ReleaseData address not aligned to size (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1945 & ~(is_aligned_2 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1945 & ~(_T_1753 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel ReleaseData carries invalid report param (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1945 & ~(_T_1753 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_2107 & ~(address_ok_1 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel AccessAck carries unmanaged address (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_2107 & ~(address_ok_1 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_2107 & ~(source_ok_2 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel AccessAck carries invalid source ID (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_2107 & ~(source_ok_2 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_2107 & ~(is_aligned_2 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel AccessAck address not aligned to size (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_2107 & ~(is_aligned_2 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_2107 & ~(_T_2117 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel AccessAck carries invalid param (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_2107 & ~(_T_2117 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_2107 & ~(_T_1757 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel AccessAck is corrupt (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_2107 & ~(_T_1757 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_2125 & ~(address_ok_1 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel AccessAckData carries unmanaged address (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_2125 & ~(address_ok_1 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_2125 & ~(source_ok_2 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel AccessAckData carries invalid source ID (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_2125 & ~(source_ok_2 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_2125 & ~(is_aligned_2 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel AccessAckData address not aligned to size (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_2125 & ~(is_aligned_2 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_2125 & ~(_T_2117 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel AccessAckData carries invalid param (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_2125 & ~(_T_2117 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_2139 & ~(address_ok_1 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel HintAck carries unmanaged address (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_2139 & ~(address_ok_1 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_2139 & ~(source_ok_2 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel HintAck carries invalid source ID (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_2139 & ~(source_ok_2 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_2139 & ~(is_aligned_2 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel HintAck address not aligned to size (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_2139 & ~(is_aligned_2 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_2139 & ~(_T_2117 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel HintAck carries invalid param (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_2139 & ~(_T_2117 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_2139 & ~(_T_1757 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel HintAck is corrupt (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_2139 & ~(_T_1757 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_2161 & ~(_T_2162 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel opcode changed within multibeat operation (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_2161 & ~(_T_2162 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_2161 & ~(_T_2166 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel param changed within multibeat operation (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_2161 & ~(_T_2166 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_2161 & ~(_T_2170 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel size changed within multibeat operation (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_2161 & ~(_T_2170 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_2161 & ~(_T_2174 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel source changed within multibeat operation (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_2161 & ~(_T_2174 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_2161 & ~(_T_2178 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel address changed with multibeat operation (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_2161 & ~(_T_2178 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_2185 & ~(_T_2186 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel opcode changed within multibeat operation (connected at SystemBus.scala:41:55)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_2185 & ~(_T_2186 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_2185 & ~(_T_2190 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel param changed within multibeat operation (connected at SystemBus.scala:41:55)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_2185 & ~(_T_2190 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_2185 & ~(_T_2194 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel size changed within multibeat operation (connected at SystemBus.scala:41:55)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_2185 & ~(_T_2194 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_2185 & ~(_T_2198 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel source changed within multibeat operation (connected at SystemBus.scala:41:55)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_2185 & ~(_T_2198 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_2185 & ~(_T_2202 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel sink changed with multibeat operation (connected at SystemBus.scala:41:55)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_2185 & ~(_T_2202 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_2185 & ~(_T_2206 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel denied changed with multibeat operation (connected at SystemBus.scala:41:55)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_2185 & ~(_T_2206 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_2213 & ~(_T_2218 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'B' channel param changed within multibeat operation (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_2213 & ~(_T_2218 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_2213 & ~(_T_2226 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'B' channel source changed within multibeat operation (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_2213 & ~(_T_2226 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_2213 & ~(_T_2230 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'B' channel addresss changed with multibeat operation (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_2213 & ~(_T_2230 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_2237 & ~(_T_2238 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel opcode changed within multibeat operation (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_2237 & ~(_T_2238 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_2237 & ~(_T_2242 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel param changed within multibeat operation (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_2237 & ~(_T_2242 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_2237 & ~(_T_2246 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel size changed within multibeat operation (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_2237 & ~(_T_2246 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_2237 & ~(_T_2250 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel source changed within multibeat operation (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_2237 & ~(_T_2250 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_2237 & ~(_T_2254 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel address changed with multibeat operation (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_2237 & ~(_T_2254 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_2263 & ~(_T_2267 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel re-used a source ID (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_2263 & ~(_T_2267 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_2274 & ~(_T_2286 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel acknowledged for nothing inflight (connected at SystemBus.scala:41:55)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_2274 & ~(_T_2286 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_2274 & same_cycle_resp & ~(_T_2292 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel contains improper opcode response (connected at SystemBus.scala:41:55)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_2274 & same_cycle_resp & ~(_T_2292 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_2274 & same_cycle_resp & ~(_T_2296 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel contains improper response size (connected at SystemBus.scala:41:55)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_2274 & same_cycle_resp & ~(_T_2296 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_2274 & ~same_cycle_resp & ~(_T_2304 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel contains improper opcode response (connected at SystemBus.scala:41:55)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_2274 & ~same_cycle_resp & ~(_T_2304 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_2274 & ~same_cycle_resp & ~(_T_2308 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel contains improper response size (connected at SystemBus.scala:41:55)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_2274 & ~same_cycle_resp & ~(_T_2308 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_2318 & ~(_T_2320 | reset)) begin
          $fwrite(32'h80000002,"Assertion failed: ready check\n    at Monitor.scala:49 assert(cond, message)\n"); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_2318 & ~(_T_2320 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (~(_T_2327 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' and 'D' concurrent, despite minlatency 1 (connected at SystemBus.scala:41:55)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (~(_T_2327 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (~(_T_2336 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: TileLink timeout expired (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (~(_T_2336 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_2353 & ~(_T_2356 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel re-used a source ID (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_2353 & ~(_T_2356 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_2362 & ~(_T_2372 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel acknowledged for nothing inflight (connected at SystemBus.scala:41:55)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_2362 & ~(_T_2372 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_2362 & same_cycle_resp_1 & ~(_T_2376 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel contains improper response size (connected at SystemBus.scala:41:55)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_2362 & same_cycle_resp_1 & ~(_T_2376 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_2362 & ~same_cycle_resp_1 & ~(_T_2380 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel contains improper response size (connected at SystemBus.scala:41:55)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_2362 & ~same_cycle_resp_1 & ~(_T_2380 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_2389 & ~(_T_2391 | reset)) begin
          $fwrite(32'h80000002,"Assertion failed: ready check\n    at Monitor.scala:49 assert(cond, message)\n"); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_2389 & ~(_T_2391 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_2395 & ~(_T_2396 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' and 'D' concurrent, despite minlatency 1 (connected at SystemBus.scala:41:55)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_2395 & ~(_T_2396 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (~(_T_2405 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: TileLink timeout expired (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (~(_T_2405 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_2418 & ~(_T_2421 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel re-used a sink ID (connected at SystemBus.scala:41:55)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_2418 & ~(_T_2421 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_2425 & ~(_T_2429[0] | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'E' channel acknowledged for nothing inflight (connected at SystemBus.scala:41:55)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_2425 & ~(_T_2429[0] | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
  end
// Register and memory initialization
`ifdef RANDOMIZE_GARBAGE_ASSIGN
`define RANDOMIZE
`endif
`ifdef RANDOMIZE_INVALID_ASSIGN
`define RANDOMIZE
`endif
`ifdef RANDOMIZE_REG_INIT
`define RANDOMIZE
`endif
`ifdef RANDOMIZE_MEM_INIT
`define RANDOMIZE
`endif
`ifndef RANDOM
`define RANDOM $random
`endif
`ifdef RANDOMIZE_MEM_INIT
  integer initvar;
`endif
`ifndef SYNTHESIS
`ifdef FIRRTL_BEFORE_INITIAL
`FIRRTL_BEFORE_INITIAL
`endif
initial begin
  `ifdef RANDOMIZE
    `ifdef INIT_RANDOM
      `INIT_RANDOM
    `endif
    `ifndef VERILATOR
      `ifdef RANDOMIZE_DELAY
        #`RANDOMIZE_DELAY begin end
      `else
        #0.002 begin end
      `endif
    `endif
`ifdef RANDOMIZE_REG_INIT
  _RAND_0 = {1{`RANDOM}};
  a_first_counter = _RAND_0[8:0];
  _RAND_1 = {1{`RANDOM}};
  opcode = _RAND_1[2:0];
  _RAND_2 = {1{`RANDOM}};
  param = _RAND_2[2:0];
  _RAND_3 = {1{`RANDOM}};
  size = _RAND_3[3:0];
  _RAND_4 = {1{`RANDOM}};
  source = _RAND_4[1:0];
  _RAND_5 = {1{`RANDOM}};
  address = _RAND_5[31:0];
  _RAND_6 = {1{`RANDOM}};
  d_first_counter = _RAND_6[8:0];
  _RAND_7 = {1{`RANDOM}};
  opcode_1 = _RAND_7[2:0];
  _RAND_8 = {1{`RANDOM}};
  param_1 = _RAND_8[1:0];
  _RAND_9 = {1{`RANDOM}};
  size_1 = _RAND_9[3:0];
  _RAND_10 = {1{`RANDOM}};
  source_1 = _RAND_10[1:0];
  _RAND_11 = {1{`RANDOM}};
  sink = _RAND_11[1:0];
  _RAND_12 = {1{`RANDOM}};
  denied = _RAND_12[0:0];
  _RAND_13 = {1{`RANDOM}};
  b_first_counter = _RAND_13[8:0];
  _RAND_14 = {1{`RANDOM}};
  param_2 = _RAND_14[1:0];
  _RAND_15 = {1{`RANDOM}};
  source_2 = _RAND_15[1:0];
  _RAND_16 = {1{`RANDOM}};
  address_1 = _RAND_16[31:0];
  _RAND_17 = {1{`RANDOM}};
  c_first_counter = _RAND_17[8:0];
  _RAND_18 = {1{`RANDOM}};
  opcode_3 = _RAND_18[2:0];
  _RAND_19 = {1{`RANDOM}};
  param_3 = _RAND_19[2:0];
  _RAND_20 = {1{`RANDOM}};
  size_3 = _RAND_20[3:0];
  _RAND_21 = {1{`RANDOM}};
  source_3 = _RAND_21[1:0];
  _RAND_22 = {1{`RANDOM}};
  address_2 = _RAND_22[31:0];
  _RAND_23 = {1{`RANDOM}};
  inflight = _RAND_23[2:0];
  _RAND_24 = {1{`RANDOM}};
  inflight_opcodes = _RAND_24[11:0];
  _RAND_25 = {1{`RANDOM}};
  inflight_sizes = _RAND_25[23:0];
  _RAND_26 = {1{`RANDOM}};
  a_first_counter_1 = _RAND_26[8:0];
  _RAND_27 = {1{`RANDOM}};
  d_first_counter_1 = _RAND_27[8:0];
  _RAND_28 = {1{`RANDOM}};
  watchdog = _RAND_28[31:0];
  _RAND_29 = {1{`RANDOM}};
  inflight_1 = _RAND_29[2:0];
  _RAND_30 = {1{`RANDOM}};
  inflight_sizes_1 = _RAND_30[23:0];
  _RAND_31 = {1{`RANDOM}};
  c_first_counter_1 = _RAND_31[8:0];
  _RAND_32 = {1{`RANDOM}};
  d_first_counter_2 = _RAND_32[8:0];
  _RAND_33 = {1{`RANDOM}};
  watchdog_1 = _RAND_33[31:0];
  _RAND_34 = {1{`RANDOM}};
  inflight_2 = _RAND_34[3:0];
  _RAND_35 = {1{`RANDOM}};
  d_first_counter_3 = _RAND_35[8:0];
`endif // RANDOMIZE_REG_INIT
  `endif // RANDOMIZE
end // initial
`ifdef FIRRTL_AFTER_INITIAL
`FIRRTL_AFTER_INITIAL
`endif
`endif // SYNTHESIS
endmodule
module TLXbar(
  input         clock,
  input         reset,
  output        auto_in_4_a_ready,
  input         auto_in_4_a_valid,
  input  [2:0]  auto_in_4_a_bits_opcode,
  input  [2:0]  auto_in_4_a_bits_param,
  input  [3:0]  auto_in_4_a_bits_size,
  input  [1:0]  auto_in_4_a_bits_source,
  input  [31:0] auto_in_4_a_bits_address,
  input  [7:0]  auto_in_4_a_bits_mask,
  input  [63:0] auto_in_4_a_bits_data,
  input         auto_in_4_a_bits_corrupt,
  input         auto_in_4_b_ready,
  output        auto_in_4_b_valid,
  output [1:0]  auto_in_4_b_bits_param,
  output [1:0]  auto_in_4_b_bits_source,
  output [31:0] auto_in_4_b_bits_address,
  output        auto_in_4_c_ready,
  input         auto_in_4_c_valid,
  input  [2:0]  auto_in_4_c_bits_opcode,
  input  [2:0]  auto_in_4_c_bits_param,
  input  [3:0]  auto_in_4_c_bits_size,
  input  [1:0]  auto_in_4_c_bits_source,
  input  [31:0] auto_in_4_c_bits_address,
  input  [63:0] auto_in_4_c_bits_data,
  input         auto_in_4_c_bits_corrupt,
  input         auto_in_4_d_ready,
  output        auto_in_4_d_valid,
  output [2:0]  auto_in_4_d_bits_opcode,
  output [1:0]  auto_in_4_d_bits_param,
  output [3:0]  auto_in_4_d_bits_size,
  output [1:0]  auto_in_4_d_bits_source,
  output [1:0]  auto_in_4_d_bits_sink,
  output        auto_in_4_d_bits_denied,
  output [63:0] auto_in_4_d_bits_data,
  output        auto_in_4_d_bits_corrupt,
  output        auto_in_4_e_ready,
  input         auto_in_4_e_valid,
  input  [1:0]  auto_in_4_e_bits_sink,
  output        auto_in_3_a_ready,
  input         auto_in_3_a_valid,
  input  [2:0]  auto_in_3_a_bits_opcode,
  input  [2:0]  auto_in_3_a_bits_param,
  input  [3:0]  auto_in_3_a_bits_size,
  input  [1:0]  auto_in_3_a_bits_source,
  input  [31:0] auto_in_3_a_bits_address,
  input  [7:0]  auto_in_3_a_bits_mask,
  input  [63:0] auto_in_3_a_bits_data,
  input         auto_in_3_a_bits_corrupt,
  input         auto_in_3_b_ready,
  output        auto_in_3_b_valid,
  output [1:0]  auto_in_3_b_bits_param,
  output [1:0]  auto_in_3_b_bits_source,
  output [31:0] auto_in_3_b_bits_address,
  output        auto_in_3_c_ready,
  input         auto_in_3_c_valid,
  input  [2:0]  auto_in_3_c_bits_opcode,
  input  [2:0]  auto_in_3_c_bits_param,
  input  [3:0]  auto_in_3_c_bits_size,
  input  [1:0]  auto_in_3_c_bits_source,
  input  [31:0] auto_in_3_c_bits_address,
  input  [63:0] auto_in_3_c_bits_data,
  input         auto_in_3_c_bits_corrupt,
  input         auto_in_3_d_ready,
  output        auto_in_3_d_valid,
  output [2:0]  auto_in_3_d_bits_opcode,
  output [1:0]  auto_in_3_d_bits_param,
  output [3:0]  auto_in_3_d_bits_size,
  output [1:0]  auto_in_3_d_bits_source,
  output [1:0]  auto_in_3_d_bits_sink,
  output        auto_in_3_d_bits_denied,
  output [63:0] auto_in_3_d_bits_data,
  output        auto_in_3_d_bits_corrupt,
  output        auto_in_3_e_ready,
  input         auto_in_3_e_valid,
  input  [1:0]  auto_in_3_e_bits_sink,
  output        auto_in_2_a_ready,
  input         auto_in_2_a_valid,
  input  [2:0]  auto_in_2_a_bits_opcode,
  input  [2:0]  auto_in_2_a_bits_param,
  input  [3:0]  auto_in_2_a_bits_size,
  input  [1:0]  auto_in_2_a_bits_source,
  input  [31:0] auto_in_2_a_bits_address,
  input  [7:0]  auto_in_2_a_bits_mask,
  input  [63:0] auto_in_2_a_bits_data,
  input         auto_in_2_a_bits_corrupt,
  input         auto_in_2_b_ready,
  output        auto_in_2_b_valid,
  output [1:0]  auto_in_2_b_bits_param,
  output [1:0]  auto_in_2_b_bits_source,
  output [31:0] auto_in_2_b_bits_address,
  output        auto_in_2_c_ready,
  input         auto_in_2_c_valid,
  input  [2:0]  auto_in_2_c_bits_opcode,
  input  [2:0]  auto_in_2_c_bits_param,
  input  [3:0]  auto_in_2_c_bits_size,
  input  [1:0]  auto_in_2_c_bits_source,
  input  [31:0] auto_in_2_c_bits_address,
  input  [63:0] auto_in_2_c_bits_data,
  input         auto_in_2_c_bits_corrupt,
  input         auto_in_2_d_ready,
  output        auto_in_2_d_valid,
  output [2:0]  auto_in_2_d_bits_opcode,
  output [1:0]  auto_in_2_d_bits_param,
  output [3:0]  auto_in_2_d_bits_size,
  output [1:0]  auto_in_2_d_bits_source,
  output [1:0]  auto_in_2_d_bits_sink,
  output        auto_in_2_d_bits_denied,
  output [63:0] auto_in_2_d_bits_data,
  output        auto_in_2_d_bits_corrupt,
  output        auto_in_2_e_ready,
  input         auto_in_2_e_valid,
  input  [1:0]  auto_in_2_e_bits_sink,
  output        auto_in_1_a_ready,
  input         auto_in_1_a_valid,
  input  [2:0]  auto_in_1_a_bits_opcode,
  input  [2:0]  auto_in_1_a_bits_param,
  input  [3:0]  auto_in_1_a_bits_size,
  input  [1:0]  auto_in_1_a_bits_source,
  input  [31:0] auto_in_1_a_bits_address,
  input  [7:0]  auto_in_1_a_bits_mask,
  input  [63:0] auto_in_1_a_bits_data,
  input         auto_in_1_a_bits_corrupt,
  input         auto_in_1_b_ready,
  output        auto_in_1_b_valid,
  output [1:0]  auto_in_1_b_bits_param,
  output [1:0]  auto_in_1_b_bits_source,
  output [31:0] auto_in_1_b_bits_address,
  output        auto_in_1_c_ready,
  input         auto_in_1_c_valid,
  input  [2:0]  auto_in_1_c_bits_opcode,
  input  [2:0]  auto_in_1_c_bits_param,
  input  [3:0]  auto_in_1_c_bits_size,
  input  [1:0]  auto_in_1_c_bits_source,
  input  [31:0] auto_in_1_c_bits_address,
  input  [63:0] auto_in_1_c_bits_data,
  input         auto_in_1_c_bits_corrupt,
  input         auto_in_1_d_ready,
  output        auto_in_1_d_valid,
  output [2:0]  auto_in_1_d_bits_opcode,
  output [1:0]  auto_in_1_d_bits_param,
  output [3:0]  auto_in_1_d_bits_size,
  output [1:0]  auto_in_1_d_bits_source,
  output [1:0]  auto_in_1_d_bits_sink,
  output        auto_in_1_d_bits_denied,
  output [63:0] auto_in_1_d_bits_data,
  output        auto_in_1_d_bits_corrupt,
  output        auto_in_1_e_ready,
  input         auto_in_1_e_valid,
  input  [1:0]  auto_in_1_e_bits_sink,
  output        auto_in_0_a_ready,
  input         auto_in_0_a_valid,
  input  [2:0]  auto_in_0_a_bits_opcode,
  input  [2:0]  auto_in_0_a_bits_param,
  input  [3:0]  auto_in_0_a_bits_size,
  input  [3:0]  auto_in_0_a_bits_source,
  input  [31:0] auto_in_0_a_bits_address,
  input         auto_in_0_a_bits_user_amba_prot_bufferable,
  input         auto_in_0_a_bits_user_amba_prot_modifiable,
  input         auto_in_0_a_bits_user_amba_prot_readalloc,
  input         auto_in_0_a_bits_user_amba_prot_writealloc,
  input         auto_in_0_a_bits_user_amba_prot_privileged,
  input         auto_in_0_a_bits_user_amba_prot_secure,
  input         auto_in_0_a_bits_user_amba_prot_fetch,
  input  [7:0]  auto_in_0_a_bits_mask,
  input  [63:0] auto_in_0_a_bits_data,
  input         auto_in_0_a_bits_corrupt,
  input         auto_in_0_d_ready,
  output        auto_in_0_d_valid,
  output [2:0]  auto_in_0_d_bits_opcode,
  output [1:0]  auto_in_0_d_bits_param,
  output [3:0]  auto_in_0_d_bits_size,
  output [3:0]  auto_in_0_d_bits_source,
  output [1:0]  auto_in_0_d_bits_sink,
  output        auto_in_0_d_bits_denied,
  output [63:0] auto_in_0_d_bits_data,
  output        auto_in_0_d_bits_corrupt,
  input         auto_out_2_a_ready,
  output        auto_out_2_a_valid,
  output [2:0]  auto_out_2_a_bits_opcode,
  output [2:0]  auto_out_2_a_bits_param,
  output [3:0]  auto_out_2_a_bits_size,
  output [4:0]  auto_out_2_a_bits_source,
  output [30:0] auto_out_2_a_bits_address,
  output        auto_out_2_a_bits_user_amba_prot_bufferable,
  output        auto_out_2_a_bits_user_amba_prot_modifiable,
  output        auto_out_2_a_bits_user_amba_prot_readalloc,
  output        auto_out_2_a_bits_user_amba_prot_writealloc,
  output        auto_out_2_a_bits_user_amba_prot_privileged,
  output        auto_out_2_a_bits_user_amba_prot_secure,
  output        auto_out_2_a_bits_user_amba_prot_fetch,
  output [7:0]  auto_out_2_a_bits_mask,
  output [63:0] auto_out_2_a_bits_data,
  output        auto_out_2_a_bits_corrupt,
  output        auto_out_2_d_ready,
  input         auto_out_2_d_valid,
  input  [2:0]  auto_out_2_d_bits_opcode,
  input  [3:0]  auto_out_2_d_bits_size,
  input  [4:0]  auto_out_2_d_bits_source,
  input         auto_out_2_d_bits_denied,
  input  [63:0] auto_out_2_d_bits_data,
  input         auto_out_2_d_bits_corrupt,
  input         auto_out_1_a_ready,
  output        auto_out_1_a_valid,
  output [2:0]  auto_out_1_a_bits_opcode,
  output [2:0]  auto_out_1_a_bits_param,
  output [2:0]  auto_out_1_a_bits_size,
  output [4:0]  auto_out_1_a_bits_source,
  output [31:0] auto_out_1_a_bits_address,
  output        auto_out_1_a_bits_user_amba_prot_bufferable,
  output        auto_out_1_a_bits_user_amba_prot_modifiable,
  output        auto_out_1_a_bits_user_amba_prot_readalloc,
  output        auto_out_1_a_bits_user_amba_prot_writealloc,
  output        auto_out_1_a_bits_user_amba_prot_privileged,
  output        auto_out_1_a_bits_user_amba_prot_secure,
  output        auto_out_1_a_bits_user_amba_prot_fetch,
  output [7:0]  auto_out_1_a_bits_mask,
  output [63:0] auto_out_1_a_bits_data,
  output        auto_out_1_a_bits_corrupt,
  output        auto_out_1_b_ready,
  input         auto_out_1_b_valid,
  input  [1:0]  auto_out_1_b_bits_param,
  input  [4:0]  auto_out_1_b_bits_source,
  input  [31:0] auto_out_1_b_bits_address,
  input         auto_out_1_c_ready,
  output        auto_out_1_c_valid,
  output [2:0]  auto_out_1_c_bits_opcode,
  output [2:0]  auto_out_1_c_bits_param,
  output [2:0]  auto_out_1_c_bits_size,
  output [4:0]  auto_out_1_c_bits_source,
  output [31:0] auto_out_1_c_bits_address,
  output [63:0] auto_out_1_c_bits_data,
  output        auto_out_1_c_bits_corrupt,
  output        auto_out_1_d_ready,
  input         auto_out_1_d_valid,
  input  [2:0]  auto_out_1_d_bits_opcode,
  input  [1:0]  auto_out_1_d_bits_param,
  input  [2:0]  auto_out_1_d_bits_size,
  input  [4:0]  auto_out_1_d_bits_source,
  input  [1:0]  auto_out_1_d_bits_sink,
  input         auto_out_1_d_bits_denied,
  input  [63:0] auto_out_1_d_bits_data,
  input         auto_out_1_d_bits_corrupt,
  output        auto_out_1_e_valid,
  output [1:0]  auto_out_1_e_bits_sink,
  input         auto_out_0_a_ready,
  output        auto_out_0_a_valid,
  output [2:0]  auto_out_0_a_bits_opcode,
  output [2:0]  auto_out_0_a_bits_param,
  output [3:0]  auto_out_0_a_bits_size,
  output [4:0]  auto_out_0_a_bits_source,
  output [27:0] auto_out_0_a_bits_address,
  output [7:0]  auto_out_0_a_bits_mask,
  output [63:0] auto_out_0_a_bits_data,
  output        auto_out_0_a_bits_corrupt,
  output        auto_out_0_d_ready,
  input         auto_out_0_d_valid,
  input  [2:0]  auto_out_0_d_bits_opcode,
  input  [1:0]  auto_out_0_d_bits_param,
  input  [3:0]  auto_out_0_d_bits_size,
  input  [4:0]  auto_out_0_d_bits_source,
  input         auto_out_0_d_bits_sink,
  input         auto_out_0_d_bits_denied,
  input  [63:0] auto_out_0_d_bits_data,
  input         auto_out_0_d_bits_corrupt
);
`ifdef RANDOMIZE_REG_INIT
  reg [31:0] _RAND_0;
  reg [31:0] _RAND_1;
  reg [31:0] _RAND_2;
  reg [31:0] _RAND_3;
  reg [31:0] _RAND_4;
  reg [31:0] _RAND_5;
  reg [31:0] _RAND_6;
  reg [31:0] _RAND_7;
  reg [31:0] _RAND_8;
  reg [31:0] _RAND_9;
  reg [31:0] _RAND_10;
  reg [31:0] _RAND_11;
  reg [31:0] _RAND_12;
  reg [31:0] _RAND_13;
  reg [31:0] _RAND_14;
  reg [31:0] _RAND_15;
  reg [31:0] _RAND_16;
  reg [31:0] _RAND_17;
  reg [31:0] _RAND_18;
  reg [31:0] _RAND_19;
  reg [31:0] _RAND_20;
  reg [31:0] _RAND_21;
  reg [31:0] _RAND_22;
  reg [31:0] _RAND_23;
  reg [31:0] _RAND_24;
  reg [31:0] _RAND_25;
  reg [31:0] _RAND_26;
  reg [31:0] _RAND_27;
  reg [31:0] _RAND_28;
  reg [31:0] _RAND_29;
  reg [31:0] _RAND_30;
  reg [31:0] _RAND_31;
  reg [31:0] _RAND_32;
  reg [31:0] _RAND_33;
  reg [31:0] _RAND_34;
  reg [31:0] _RAND_35;
  reg [31:0] _RAND_36;
  reg [31:0] _RAND_37;
  reg [31:0] _RAND_38;
  reg [31:0] _RAND_39;
  reg [31:0] _RAND_40;
  reg [31:0] _RAND_41;
  reg [31:0] _RAND_42;
  reg [31:0] _RAND_43;
  reg [31:0] _RAND_44;
  reg [31:0] _RAND_45;
  reg [31:0] _RAND_46;
  reg [31:0] _RAND_47;
  reg [31:0] _RAND_48;
  reg [31:0] _RAND_49;
  reg [31:0] _RAND_50;
  reg [31:0] _RAND_51;
  reg [31:0] _RAND_52;
  reg [31:0] _RAND_53;
  reg [31:0] _RAND_54;
  reg [31:0] _RAND_55;
  reg [31:0] _RAND_56;
  reg [31:0] _RAND_57;
`endif // RANDOMIZE_REG_INIT
  wire  monitor_clock; // @[Nodes.scala 24:25]
  wire  monitor_reset; // @[Nodes.scala 24:25]
  wire  monitor_io_in_a_ready; // @[Nodes.scala 24:25]
  wire  monitor_io_in_a_valid; // @[Nodes.scala 24:25]
  wire [2:0] monitor_io_in_a_bits_opcode; // @[Nodes.scala 24:25]
  wire [2:0] monitor_io_in_a_bits_param; // @[Nodes.scala 24:25]
  wire [3:0] monitor_io_in_a_bits_size; // @[Nodes.scala 24:25]
  wire [3:0] monitor_io_in_a_bits_source; // @[Nodes.scala 24:25]
  wire [31:0] monitor_io_in_a_bits_address; // @[Nodes.scala 24:25]
  wire [7:0] monitor_io_in_a_bits_mask; // @[Nodes.scala 24:25]
  wire  monitor_io_in_a_bits_corrupt; // @[Nodes.scala 24:25]
  wire  monitor_io_in_d_ready; // @[Nodes.scala 24:25]
  wire  monitor_io_in_d_valid; // @[Nodes.scala 24:25]
  wire [2:0] monitor_io_in_d_bits_opcode; // @[Nodes.scala 24:25]
  wire [1:0] monitor_io_in_d_bits_param; // @[Nodes.scala 24:25]
  wire [3:0] monitor_io_in_d_bits_size; // @[Nodes.scala 24:25]
  wire [3:0] monitor_io_in_d_bits_source; // @[Nodes.scala 24:25]
  wire [1:0] monitor_io_in_d_bits_sink; // @[Nodes.scala 24:25]
  wire  monitor_io_in_d_bits_denied; // @[Nodes.scala 24:25]
  wire  monitor_io_in_d_bits_corrupt; // @[Nodes.scala 24:25]
  wire  monitor_1_clock; // @[Nodes.scala 24:25]
  wire  monitor_1_reset; // @[Nodes.scala 24:25]
  wire  monitor_1_io_in_a_ready; // @[Nodes.scala 24:25]
  wire  monitor_1_io_in_a_valid; // @[Nodes.scala 24:25]
  wire [2:0] monitor_1_io_in_a_bits_opcode; // @[Nodes.scala 24:25]
  wire [2:0] monitor_1_io_in_a_bits_param; // @[Nodes.scala 24:25]
  wire [3:0] monitor_1_io_in_a_bits_size; // @[Nodes.scala 24:25]
  wire [1:0] monitor_1_io_in_a_bits_source; // @[Nodes.scala 24:25]
  wire [31:0] monitor_1_io_in_a_bits_address; // @[Nodes.scala 24:25]
  wire [7:0] monitor_1_io_in_a_bits_mask; // @[Nodes.scala 24:25]
  wire  monitor_1_io_in_a_bits_corrupt; // @[Nodes.scala 24:25]
  wire  monitor_1_io_in_b_ready; // @[Nodes.scala 24:25]
  wire  monitor_1_io_in_b_valid; // @[Nodes.scala 24:25]
  wire [1:0] monitor_1_io_in_b_bits_param; // @[Nodes.scala 24:25]
  wire [1:0] monitor_1_io_in_b_bits_source; // @[Nodes.scala 24:25]
  wire [31:0] monitor_1_io_in_b_bits_address; // @[Nodes.scala 24:25]
  wire  monitor_1_io_in_c_ready; // @[Nodes.scala 24:25]
  wire  monitor_1_io_in_c_valid; // @[Nodes.scala 24:25]
  wire [2:0] monitor_1_io_in_c_bits_opcode; // @[Nodes.scala 24:25]
  wire [2:0] monitor_1_io_in_c_bits_param; // @[Nodes.scala 24:25]
  wire [3:0] monitor_1_io_in_c_bits_size; // @[Nodes.scala 24:25]
  wire [1:0] monitor_1_io_in_c_bits_source; // @[Nodes.scala 24:25]
  wire [31:0] monitor_1_io_in_c_bits_address; // @[Nodes.scala 24:25]
  wire  monitor_1_io_in_c_bits_corrupt; // @[Nodes.scala 24:25]
  wire  monitor_1_io_in_d_ready; // @[Nodes.scala 24:25]
  wire  monitor_1_io_in_d_valid; // @[Nodes.scala 24:25]
  wire [2:0] monitor_1_io_in_d_bits_opcode; // @[Nodes.scala 24:25]
  wire [1:0] monitor_1_io_in_d_bits_param; // @[Nodes.scala 24:25]
  wire [3:0] monitor_1_io_in_d_bits_size; // @[Nodes.scala 24:25]
  wire [1:0] monitor_1_io_in_d_bits_source; // @[Nodes.scala 24:25]
  wire [1:0] monitor_1_io_in_d_bits_sink; // @[Nodes.scala 24:25]
  wire  monitor_1_io_in_d_bits_denied; // @[Nodes.scala 24:25]
  wire  monitor_1_io_in_d_bits_corrupt; // @[Nodes.scala 24:25]
  wire  monitor_1_io_in_e_ready; // @[Nodes.scala 24:25]
  wire  monitor_1_io_in_e_valid; // @[Nodes.scala 24:25]
  wire [1:0] monitor_1_io_in_e_bits_sink; // @[Nodes.scala 24:25]
  wire  monitor_2_clock; // @[Nodes.scala 24:25]
  wire  monitor_2_reset; // @[Nodes.scala 24:25]
  wire  monitor_2_io_in_a_ready; // @[Nodes.scala 24:25]
  wire  monitor_2_io_in_a_valid; // @[Nodes.scala 24:25]
  wire [2:0] monitor_2_io_in_a_bits_opcode; // @[Nodes.scala 24:25]
  wire [2:0] monitor_2_io_in_a_bits_param; // @[Nodes.scala 24:25]
  wire [3:0] monitor_2_io_in_a_bits_size; // @[Nodes.scala 24:25]
  wire [1:0] monitor_2_io_in_a_bits_source; // @[Nodes.scala 24:25]
  wire [31:0] monitor_2_io_in_a_bits_address; // @[Nodes.scala 24:25]
  wire [7:0] monitor_2_io_in_a_bits_mask; // @[Nodes.scala 24:25]
  wire  monitor_2_io_in_a_bits_corrupt; // @[Nodes.scala 24:25]
  wire  monitor_2_io_in_b_ready; // @[Nodes.scala 24:25]
  wire  monitor_2_io_in_b_valid; // @[Nodes.scala 24:25]
  wire [1:0] monitor_2_io_in_b_bits_param; // @[Nodes.scala 24:25]
  wire [1:0] monitor_2_io_in_b_bits_source; // @[Nodes.scala 24:25]
  wire [31:0] monitor_2_io_in_b_bits_address; // @[Nodes.scala 24:25]
  wire  monitor_2_io_in_c_ready; // @[Nodes.scala 24:25]
  wire  monitor_2_io_in_c_valid; // @[Nodes.scala 24:25]
  wire [2:0] monitor_2_io_in_c_bits_opcode; // @[Nodes.scala 24:25]
  wire [2:0] monitor_2_io_in_c_bits_param; // @[Nodes.scala 24:25]
  wire [3:0] monitor_2_io_in_c_bits_size; // @[Nodes.scala 24:25]
  wire [1:0] monitor_2_io_in_c_bits_source; // @[Nodes.scala 24:25]
  wire [31:0] monitor_2_io_in_c_bits_address; // @[Nodes.scala 24:25]
  wire  monitor_2_io_in_c_bits_corrupt; // @[Nodes.scala 24:25]
  wire  monitor_2_io_in_d_ready; // @[Nodes.scala 24:25]
  wire  monitor_2_io_in_d_valid; // @[Nodes.scala 24:25]
  wire [2:0] monitor_2_io_in_d_bits_opcode; // @[Nodes.scala 24:25]
  wire [1:0] monitor_2_io_in_d_bits_param; // @[Nodes.scala 24:25]
  wire [3:0] monitor_2_io_in_d_bits_size; // @[Nodes.scala 24:25]
  wire [1:0] monitor_2_io_in_d_bits_source; // @[Nodes.scala 24:25]
  wire [1:0] monitor_2_io_in_d_bits_sink; // @[Nodes.scala 24:25]
  wire  monitor_2_io_in_d_bits_denied; // @[Nodes.scala 24:25]
  wire  monitor_2_io_in_d_bits_corrupt; // @[Nodes.scala 24:25]
  wire  monitor_2_io_in_e_ready; // @[Nodes.scala 24:25]
  wire  monitor_2_io_in_e_valid; // @[Nodes.scala 24:25]
  wire [1:0] monitor_2_io_in_e_bits_sink; // @[Nodes.scala 24:25]
  wire  monitor_3_clock; // @[Nodes.scala 24:25]
  wire  monitor_3_reset; // @[Nodes.scala 24:25]
  wire  monitor_3_io_in_a_ready; // @[Nodes.scala 24:25]
  wire  monitor_3_io_in_a_valid; // @[Nodes.scala 24:25]
  wire [2:0] monitor_3_io_in_a_bits_opcode; // @[Nodes.scala 24:25]
  wire [2:0] monitor_3_io_in_a_bits_param; // @[Nodes.scala 24:25]
  wire [3:0] monitor_3_io_in_a_bits_size; // @[Nodes.scala 24:25]
  wire [1:0] monitor_3_io_in_a_bits_source; // @[Nodes.scala 24:25]
  wire [31:0] monitor_3_io_in_a_bits_address; // @[Nodes.scala 24:25]
  wire [7:0] monitor_3_io_in_a_bits_mask; // @[Nodes.scala 24:25]
  wire  monitor_3_io_in_a_bits_corrupt; // @[Nodes.scala 24:25]
  wire  monitor_3_io_in_b_ready; // @[Nodes.scala 24:25]
  wire  monitor_3_io_in_b_valid; // @[Nodes.scala 24:25]
  wire [1:0] monitor_3_io_in_b_bits_param; // @[Nodes.scala 24:25]
  wire [1:0] monitor_3_io_in_b_bits_source; // @[Nodes.scala 24:25]
  wire [31:0] monitor_3_io_in_b_bits_address; // @[Nodes.scala 24:25]
  wire  monitor_3_io_in_c_ready; // @[Nodes.scala 24:25]
  wire  monitor_3_io_in_c_valid; // @[Nodes.scala 24:25]
  wire [2:0] monitor_3_io_in_c_bits_opcode; // @[Nodes.scala 24:25]
  wire [2:0] monitor_3_io_in_c_bits_param; // @[Nodes.scala 24:25]
  wire [3:0] monitor_3_io_in_c_bits_size; // @[Nodes.scala 24:25]
  wire [1:0] monitor_3_io_in_c_bits_source; // @[Nodes.scala 24:25]
  wire [31:0] monitor_3_io_in_c_bits_address; // @[Nodes.scala 24:25]
  wire  monitor_3_io_in_c_bits_corrupt; // @[Nodes.scala 24:25]
  wire  monitor_3_io_in_d_ready; // @[Nodes.scala 24:25]
  wire  monitor_3_io_in_d_valid; // @[Nodes.scala 24:25]
  wire [2:0] monitor_3_io_in_d_bits_opcode; // @[Nodes.scala 24:25]
  wire [1:0] monitor_3_io_in_d_bits_param; // @[Nodes.scala 24:25]
  wire [3:0] monitor_3_io_in_d_bits_size; // @[Nodes.scala 24:25]
  wire [1:0] monitor_3_io_in_d_bits_source; // @[Nodes.scala 24:25]
  wire [1:0] monitor_3_io_in_d_bits_sink; // @[Nodes.scala 24:25]
  wire  monitor_3_io_in_d_bits_denied; // @[Nodes.scala 24:25]
  wire  monitor_3_io_in_d_bits_corrupt; // @[Nodes.scala 24:25]
  wire  monitor_3_io_in_e_ready; // @[Nodes.scala 24:25]
  wire  monitor_3_io_in_e_valid; // @[Nodes.scala 24:25]
  wire [1:0] monitor_3_io_in_e_bits_sink; // @[Nodes.scala 24:25]
  wire  monitor_4_clock; // @[Nodes.scala 24:25]
  wire  monitor_4_reset; // @[Nodes.scala 24:25]
  wire  monitor_4_io_in_a_ready; // @[Nodes.scala 24:25]
  wire  monitor_4_io_in_a_valid; // @[Nodes.scala 24:25]
  wire [2:0] monitor_4_io_in_a_bits_opcode; // @[Nodes.scala 24:25]
  wire [2:0] monitor_4_io_in_a_bits_param; // @[Nodes.scala 24:25]
  wire [3:0] monitor_4_io_in_a_bits_size; // @[Nodes.scala 24:25]
  wire [1:0] monitor_4_io_in_a_bits_source; // @[Nodes.scala 24:25]
  wire [31:0] monitor_4_io_in_a_bits_address; // @[Nodes.scala 24:25]
  wire [7:0] monitor_4_io_in_a_bits_mask; // @[Nodes.scala 24:25]
  wire  monitor_4_io_in_a_bits_corrupt; // @[Nodes.scala 24:25]
  wire  monitor_4_io_in_b_ready; // @[Nodes.scala 24:25]
  wire  monitor_4_io_in_b_valid; // @[Nodes.scala 24:25]
  wire [1:0] monitor_4_io_in_b_bits_param; // @[Nodes.scala 24:25]
  wire [1:0] monitor_4_io_in_b_bits_source; // @[Nodes.scala 24:25]
  wire [31:0] monitor_4_io_in_b_bits_address; // @[Nodes.scala 24:25]
  wire  monitor_4_io_in_c_ready; // @[Nodes.scala 24:25]
  wire  monitor_4_io_in_c_valid; // @[Nodes.scala 24:25]
  wire [2:0] monitor_4_io_in_c_bits_opcode; // @[Nodes.scala 24:25]
  wire [2:0] monitor_4_io_in_c_bits_param; // @[Nodes.scala 24:25]
  wire [3:0] monitor_4_io_in_c_bits_size; // @[Nodes.scala 24:25]
  wire [1:0] monitor_4_io_in_c_bits_source; // @[Nodes.scala 24:25]
  wire [31:0] monitor_4_io_in_c_bits_address; // @[Nodes.scala 24:25]
  wire  monitor_4_io_in_c_bits_corrupt; // @[Nodes.scala 24:25]
  wire  monitor_4_io_in_d_ready; // @[Nodes.scala 24:25]
  wire  monitor_4_io_in_d_valid; // @[Nodes.scala 24:25]
  wire [2:0] monitor_4_io_in_d_bits_opcode; // @[Nodes.scala 24:25]
  wire [1:0] monitor_4_io_in_d_bits_param; // @[Nodes.scala 24:25]
  wire [3:0] monitor_4_io_in_d_bits_size; // @[Nodes.scala 24:25]
  wire [1:0] monitor_4_io_in_d_bits_source; // @[Nodes.scala 24:25]
  wire [1:0] monitor_4_io_in_d_bits_sink; // @[Nodes.scala 24:25]
  wire  monitor_4_io_in_d_bits_denied; // @[Nodes.scala 24:25]
  wire  monitor_4_io_in_d_bits_corrupt; // @[Nodes.scala 24:25]
  wire  monitor_4_io_in_e_ready; // @[Nodes.scala 24:25]
  wire  monitor_4_io_in_e_valid; // @[Nodes.scala 24:25]
  wire [1:0] monitor_4_io_in_e_bits_sink; // @[Nodes.scala 24:25]
  reg [8:0] beatsLeft_5; // @[Arbiter.scala 87:30]
  wire  idle_5 = beatsLeft_5 == 9'h0; // @[Arbiter.scala 88:28]
  wire  requestDOI_2_0 = ~auto_out_2_d_bits_source[4]; // @[Parameters.scala 54:32]
  wire  portsDIO_filtered_2_0_valid = auto_out_2_d_valid & requestDOI_2_0; // @[Xbar.scala 179:40]
  wire  requestDOI_1_0 = ~auto_out_1_d_bits_source[4]; // @[Parameters.scala 54:32]
  wire  portsDIO_filtered_1_0_valid = auto_out_1_d_valid & requestDOI_1_0; // @[Xbar.scala 179:40]
  wire  requestDOI_0_0 = ~auto_out_0_d_bits_source[4]; // @[Parameters.scala 54:32]
  wire  portsDIO_filtered__0_valid = auto_out_0_d_valid & requestDOI_0_0; // @[Xbar.scala 179:40]
  wire [2:0] readys_filter_lo_5 = {portsDIO_filtered_2_0_valid,portsDIO_filtered_1_0_valid,portsDIO_filtered__0_valid}; // @[Cat.scala 30:58]
  reg [2:0] readys_mask_5; // @[Arbiter.scala 23:23]
  wire [2:0] _readys_filter_T_5 = ~readys_mask_5; // @[Arbiter.scala 24:30]
  wire [2:0] readys_filter_hi_5 = readys_filter_lo_5 & _readys_filter_T_5; // @[Arbiter.scala 24:28]
  wire [5:0] readys_filter_5 = {readys_filter_hi_5,portsDIO_filtered_2_0_valid,portsDIO_filtered_1_0_valid,
    portsDIO_filtered__0_valid}; // @[Cat.scala 30:58]
  wire [5:0] _GEN_10 = {{1'd0}, readys_filter_5[5:1]}; // @[package.scala 253:43]
  wire [5:0] _readys_unready_T_42 = readys_filter_5 | _GEN_10; // @[package.scala 253:43]
  wire [5:0] _GEN_11 = {{2'd0}, _readys_unready_T_42[5:2]}; // @[package.scala 253:43]
  wire [5:0] _readys_unready_T_44 = _readys_unready_T_42 | _GEN_11; // @[package.scala 253:43]
  wire [5:0] _readys_unready_T_47 = {readys_mask_5, 3'h0}; // @[Arbiter.scala 25:66]
  wire [5:0] _GEN_12 = {{1'd0}, _readys_unready_T_44[5:1]}; // @[Arbiter.scala 25:58]
  wire [5:0] readys_unready_5 = _GEN_12 | _readys_unready_T_47; // @[Arbiter.scala 25:58]
  wire [2:0] _readys_readys_T_17 = readys_unready_5[5:3] & readys_unready_5[2:0]; // @[Arbiter.scala 26:39]
  wire [2:0] readys_readys_5 = ~_readys_readys_T_17; // @[Arbiter.scala 26:18]
  wire  readys_5_0 = readys_readys_5[0]; // @[Arbiter.scala 95:86]
  wire  earlyWinner_5_0 = readys_5_0 & portsDIO_filtered__0_valid; // @[Arbiter.scala 97:79]
  reg  state_5_0; // @[Arbiter.scala 116:26]
  wire  muxStateEarly_5_0 = idle_5 ? earlyWinner_5_0 : state_5_0; // @[Arbiter.scala 117:30]
  wire [4:0] _T_787 = muxStateEarly_5_0 ? auto_out_0_d_bits_source : 5'h0; // @[Mux.scala 27:72]
  wire  readys_5_1 = readys_readys_5[1]; // @[Arbiter.scala 95:86]
  wire  earlyWinner_5_1 = readys_5_1 & portsDIO_filtered_1_0_valid; // @[Arbiter.scala 97:79]
  reg  state_5_1; // @[Arbiter.scala 116:26]
  wire  muxStateEarly_5_1 = idle_5 ? earlyWinner_5_1 : state_5_1; // @[Arbiter.scala 117:30]
  wire [4:0] _T_788 = muxStateEarly_5_1 ? auto_out_1_d_bits_source : 5'h0; // @[Mux.scala 27:72]
  wire [4:0] _T_790 = _T_787 | _T_788; // @[Mux.scala 27:72]
  wire  readys_5_2 = readys_readys_5[2]; // @[Arbiter.scala 95:86]
  wire  earlyWinner_5_2 = readys_5_2 & portsDIO_filtered_2_0_valid; // @[Arbiter.scala 97:79]
  reg  state_5_2; // @[Arbiter.scala 116:26]
  wire  muxStateEarly_5_2 = idle_5 ? earlyWinner_5_2 : state_5_2; // @[Arbiter.scala 117:30]
  wire [4:0] _T_789 = muxStateEarly_5_2 ? auto_out_2_d_bits_source : 5'h0; // @[Mux.scala 27:72]
  wire [4:0] sink_ACancel_7_bits_source = _T_790 | _T_789; // @[Mux.scala 27:72]
  wire [4:0] _GEN_13 = {{3'd0}, auto_in_1_a_bits_source}; // @[Xbar.scala 237:55]
  wire [4:0] in_1_a_bits_source = _GEN_13 | 5'h1c; // @[Xbar.scala 237:55]
  wire [4:0] _GEN_14 = {{3'd0}, auto_in_1_c_bits_source}; // @[Xbar.scala 259:55]
  wire [4:0] in_1_c_bits_source = _GEN_14 | 5'h1c; // @[Xbar.scala 259:55]
  reg [8:0] beatsLeft_6; // @[Arbiter.scala 87:30]
  wire  idle_6 = beatsLeft_6 == 9'h0; // @[Arbiter.scala 88:28]
  wire  requestDOI_2_1 = auto_out_2_d_bits_source[4:2] == 3'h7; // @[Parameters.scala 54:32]
  wire  portsDIO_filtered_2_1_valid = auto_out_2_d_valid & requestDOI_2_1; // @[Xbar.scala 179:40]
  wire  requestDOI_1_1 = auto_out_1_d_bits_source[4:2] == 3'h7; // @[Parameters.scala 54:32]
  wire  portsDIO_filtered_1_1_valid = auto_out_1_d_valid & requestDOI_1_1; // @[Xbar.scala 179:40]
  wire  requestDOI_0_1 = auto_out_0_d_bits_source[4:2] == 3'h7; // @[Parameters.scala 54:32]
  wire  portsDIO_filtered__1_valid = auto_out_0_d_valid & requestDOI_0_1; // @[Xbar.scala 179:40]
  wire [2:0] readys_filter_lo_6 = {portsDIO_filtered_2_1_valid,portsDIO_filtered_1_1_valid,portsDIO_filtered__1_valid}; // @[Cat.scala 30:58]
  reg [2:0] readys_mask_6; // @[Arbiter.scala 23:23]
  wire [2:0] _readys_filter_T_6 = ~readys_mask_6; // @[Arbiter.scala 24:30]
  wire [2:0] readys_filter_hi_6 = readys_filter_lo_6 & _readys_filter_T_6; // @[Arbiter.scala 24:28]
  wire [5:0] readys_filter_6 = {readys_filter_hi_6,portsDIO_filtered_2_1_valid,portsDIO_filtered_1_1_valid,
    portsDIO_filtered__1_valid}; // @[Cat.scala 30:58]
  wire [5:0] _GEN_15 = {{1'd0}, readys_filter_6[5:1]}; // @[package.scala 253:43]
  wire [5:0] _readys_unready_T_49 = readys_filter_6 | _GEN_15; // @[package.scala 253:43]
  wire [5:0] _GEN_16 = {{2'd0}, _readys_unready_T_49[5:2]}; // @[package.scala 253:43]
  wire [5:0] _readys_unready_T_51 = _readys_unready_T_49 | _GEN_16; // @[package.scala 253:43]
  wire [5:0] _readys_unready_T_54 = {readys_mask_6, 3'h0}; // @[Arbiter.scala 25:66]
  wire [5:0] _GEN_17 = {{1'd0}, _readys_unready_T_51[5:1]}; // @[Arbiter.scala 25:58]
  wire [5:0] readys_unready_6 = _GEN_17 | _readys_unready_T_54; // @[Arbiter.scala 25:58]
  wire [2:0] _readys_readys_T_20 = readys_unready_6[5:3] & readys_unready_6[2:0]; // @[Arbiter.scala 26:39]
  wire [2:0] readys_readys_6 = ~_readys_readys_T_20; // @[Arbiter.scala 26:18]
  wire  readys_6_0 = readys_readys_6[0]; // @[Arbiter.scala 95:86]
  wire  earlyWinner_6_0 = readys_6_0 & portsDIO_filtered__1_valid; // @[Arbiter.scala 97:79]
  reg  state_6_0; // @[Arbiter.scala 116:26]
  wire  muxStateEarly_6_0 = idle_6 ? earlyWinner_6_0 : state_6_0; // @[Arbiter.scala 117:30]
  wire [4:0] _T_859 = muxStateEarly_6_0 ? auto_out_0_d_bits_source : 5'h0; // @[Mux.scala 27:72]
  wire  readys_6_1 = readys_readys_6[1]; // @[Arbiter.scala 95:86]
  wire  earlyWinner_6_1 = readys_6_1 & portsDIO_filtered_1_1_valid; // @[Arbiter.scala 97:79]
  reg  state_6_1; // @[Arbiter.scala 116:26]
  wire  muxStateEarly_6_1 = idle_6 ? earlyWinner_6_1 : state_6_1; // @[Arbiter.scala 117:30]
  wire [4:0] _T_860 = muxStateEarly_6_1 ? auto_out_1_d_bits_source : 5'h0; // @[Mux.scala 27:72]
  wire [4:0] _T_862 = _T_859 | _T_860; // @[Mux.scala 27:72]
  wire  readys_6_2 = readys_readys_6[2]; // @[Arbiter.scala 95:86]
  wire  earlyWinner_6_2 = readys_6_2 & portsDIO_filtered_2_1_valid; // @[Arbiter.scala 97:79]
  reg  state_6_2; // @[Arbiter.scala 116:26]
  wire  muxStateEarly_6_2 = idle_6 ? earlyWinner_6_2 : state_6_2; // @[Arbiter.scala 117:30]
  wire [4:0] _T_861 = muxStateEarly_6_2 ? auto_out_2_d_bits_source : 5'h0; // @[Mux.scala 27:72]
  wire [4:0] sink_ACancel_9_bits_source = _T_862 | _T_861; // @[Mux.scala 27:72]
  wire [4:0] _GEN_18 = {{3'd0}, auto_in_2_a_bits_source}; // @[Xbar.scala 237:55]
  wire [4:0] in_2_a_bits_source = _GEN_18 | 5'h18; // @[Xbar.scala 237:55]
  wire [4:0] _GEN_19 = {{3'd0}, auto_in_2_c_bits_source}; // @[Xbar.scala 259:55]
  wire [4:0] in_2_c_bits_source = _GEN_19 | 5'h18; // @[Xbar.scala 259:55]
  reg [8:0] beatsLeft_7; // @[Arbiter.scala 87:30]
  wire  idle_7 = beatsLeft_7 == 9'h0; // @[Arbiter.scala 88:28]
  wire  requestDOI_2_2 = auto_out_2_d_bits_source[4:2] == 3'h6; // @[Parameters.scala 54:32]
  wire  portsDIO_filtered_2_2_valid = auto_out_2_d_valid & requestDOI_2_2; // @[Xbar.scala 179:40]
  wire  requestDOI_1_2 = auto_out_1_d_bits_source[4:2] == 3'h6; // @[Parameters.scala 54:32]
  wire  portsDIO_filtered_1_2_valid = auto_out_1_d_valid & requestDOI_1_2; // @[Xbar.scala 179:40]
  wire  requestDOI_0_2 = auto_out_0_d_bits_source[4:2] == 3'h6; // @[Parameters.scala 54:32]
  wire  portsDIO_filtered__2_valid = auto_out_0_d_valid & requestDOI_0_2; // @[Xbar.scala 179:40]
  wire [2:0] readys_filter_lo_7 = {portsDIO_filtered_2_2_valid,portsDIO_filtered_1_2_valid,portsDIO_filtered__2_valid}; // @[Cat.scala 30:58]
  reg [2:0] readys_mask_7; // @[Arbiter.scala 23:23]
  wire [2:0] _readys_filter_T_7 = ~readys_mask_7; // @[Arbiter.scala 24:30]
  wire [2:0] readys_filter_hi_7 = readys_filter_lo_7 & _readys_filter_T_7; // @[Arbiter.scala 24:28]
  wire [5:0] readys_filter_7 = {readys_filter_hi_7,portsDIO_filtered_2_2_valid,portsDIO_filtered_1_2_valid,
    portsDIO_filtered__2_valid}; // @[Cat.scala 30:58]
  wire [5:0] _GEN_20 = {{1'd0}, readys_filter_7[5:1]}; // @[package.scala 253:43]
  wire [5:0] _readys_unready_T_56 = readys_filter_7 | _GEN_20; // @[package.scala 253:43]
  wire [5:0] _GEN_21 = {{2'd0}, _readys_unready_T_56[5:2]}; // @[package.scala 253:43]
  wire [5:0] _readys_unready_T_58 = _readys_unready_T_56 | _GEN_21; // @[package.scala 253:43]
  wire [5:0] _readys_unready_T_61 = {readys_mask_7, 3'h0}; // @[Arbiter.scala 25:66]
  wire [5:0] _GEN_22 = {{1'd0}, _readys_unready_T_58[5:1]}; // @[Arbiter.scala 25:58]
  wire [5:0] readys_unready_7 = _GEN_22 | _readys_unready_T_61; // @[Arbiter.scala 25:58]
  wire [2:0] _readys_readys_T_23 = readys_unready_7[5:3] & readys_unready_7[2:0]; // @[Arbiter.scala 26:39]
  wire [2:0] readys_readys_7 = ~_readys_readys_T_23; // @[Arbiter.scala 26:18]
  wire  readys_7_0 = readys_readys_7[0]; // @[Arbiter.scala 95:86]
  wire  earlyWinner_7_0 = readys_7_0 & portsDIO_filtered__2_valid; // @[Arbiter.scala 97:79]
  reg  state_7_0; // @[Arbiter.scala 116:26]
  wire  muxStateEarly_7_0 = idle_7 ? earlyWinner_7_0 : state_7_0; // @[Arbiter.scala 117:30]
  wire [4:0] _T_931 = muxStateEarly_7_0 ? auto_out_0_d_bits_source : 5'h0; // @[Mux.scala 27:72]
  wire  readys_7_1 = readys_readys_7[1]; // @[Arbiter.scala 95:86]
  wire  earlyWinner_7_1 = readys_7_1 & portsDIO_filtered_1_2_valid; // @[Arbiter.scala 97:79]
  reg  state_7_1; // @[Arbiter.scala 116:26]
  wire  muxStateEarly_7_1 = idle_7 ? earlyWinner_7_1 : state_7_1; // @[Arbiter.scala 117:30]
  wire [4:0] _T_932 = muxStateEarly_7_1 ? auto_out_1_d_bits_source : 5'h0; // @[Mux.scala 27:72]
  wire [4:0] _T_934 = _T_931 | _T_932; // @[Mux.scala 27:72]
  wire  readys_7_2 = readys_readys_7[2]; // @[Arbiter.scala 95:86]
  wire  earlyWinner_7_2 = readys_7_2 & portsDIO_filtered_2_2_valid; // @[Arbiter.scala 97:79]
  reg  state_7_2; // @[Arbiter.scala 116:26]
  wire  muxStateEarly_7_2 = idle_7 ? earlyWinner_7_2 : state_7_2; // @[Arbiter.scala 117:30]
  wire [4:0] _T_933 = muxStateEarly_7_2 ? auto_out_2_d_bits_source : 5'h0; // @[Mux.scala 27:72]
  wire [4:0] sink_ACancel_11_bits_source = _T_934 | _T_933; // @[Mux.scala 27:72]
  wire [4:0] _GEN_23 = {{3'd0}, auto_in_3_a_bits_source}; // @[Xbar.scala 237:55]
  wire [4:0] in_3_a_bits_source = _GEN_23 | 5'h14; // @[Xbar.scala 237:55]
  wire [4:0] _GEN_24 = {{3'd0}, auto_in_3_c_bits_source}; // @[Xbar.scala 259:55]
  wire [4:0] in_3_c_bits_source = _GEN_24 | 5'h14; // @[Xbar.scala 259:55]
  reg [8:0] beatsLeft_8; // @[Arbiter.scala 87:30]
  wire  idle_8 = beatsLeft_8 == 9'h0; // @[Arbiter.scala 88:28]
  wire  requestDOI_2_3 = auto_out_2_d_bits_source[4:2] == 3'h5; // @[Parameters.scala 54:32]
  wire  portsDIO_filtered_2_3_valid = auto_out_2_d_valid & requestDOI_2_3; // @[Xbar.scala 179:40]
  wire  requestDOI_1_3 = auto_out_1_d_bits_source[4:2] == 3'h5; // @[Parameters.scala 54:32]
  wire  portsDIO_filtered_1_3_valid = auto_out_1_d_valid & requestDOI_1_3; // @[Xbar.scala 179:40]
  wire  requestDOI_0_3 = auto_out_0_d_bits_source[4:2] == 3'h5; // @[Parameters.scala 54:32]
  wire  portsDIO_filtered__3_valid = auto_out_0_d_valid & requestDOI_0_3; // @[Xbar.scala 179:40]
  wire [2:0] readys_filter_lo_8 = {portsDIO_filtered_2_3_valid,portsDIO_filtered_1_3_valid,portsDIO_filtered__3_valid}; // @[Cat.scala 30:58]
  reg [2:0] readys_mask_8; // @[Arbiter.scala 23:23]
  wire [2:0] _readys_filter_T_8 = ~readys_mask_8; // @[Arbiter.scala 24:30]
  wire [2:0] readys_filter_hi_8 = readys_filter_lo_8 & _readys_filter_T_8; // @[Arbiter.scala 24:28]
  wire [5:0] readys_filter_8 = {readys_filter_hi_8,portsDIO_filtered_2_3_valid,portsDIO_filtered_1_3_valid,
    portsDIO_filtered__3_valid}; // @[Cat.scala 30:58]
  wire [5:0] _GEN_25 = {{1'd0}, readys_filter_8[5:1]}; // @[package.scala 253:43]
  wire [5:0] _readys_unready_T_63 = readys_filter_8 | _GEN_25; // @[package.scala 253:43]
  wire [5:0] _GEN_26 = {{2'd0}, _readys_unready_T_63[5:2]}; // @[package.scala 253:43]
  wire [5:0] _readys_unready_T_65 = _readys_unready_T_63 | _GEN_26; // @[package.scala 253:43]
  wire [5:0] _readys_unready_T_68 = {readys_mask_8, 3'h0}; // @[Arbiter.scala 25:66]
  wire [5:0] _GEN_27 = {{1'd0}, _readys_unready_T_65[5:1]}; // @[Arbiter.scala 25:58]
  wire [5:0] readys_unready_8 = _GEN_27 | _readys_unready_T_68; // @[Arbiter.scala 25:58]
  wire [2:0] _readys_readys_T_26 = readys_unready_8[5:3] & readys_unready_8[2:0]; // @[Arbiter.scala 26:39]
  wire [2:0] readys_readys_8 = ~_readys_readys_T_26; // @[Arbiter.scala 26:18]
  wire  readys_8_0 = readys_readys_8[0]; // @[Arbiter.scala 95:86]
  wire  earlyWinner_8_0 = readys_8_0 & portsDIO_filtered__3_valid; // @[Arbiter.scala 97:79]
  reg  state_8_0; // @[Arbiter.scala 116:26]
  wire  muxStateEarly_8_0 = idle_8 ? earlyWinner_8_0 : state_8_0; // @[Arbiter.scala 117:30]
  wire [4:0] _T_1003 = muxStateEarly_8_0 ? auto_out_0_d_bits_source : 5'h0; // @[Mux.scala 27:72]
  wire  readys_8_1 = readys_readys_8[1]; // @[Arbiter.scala 95:86]
  wire  earlyWinner_8_1 = readys_8_1 & portsDIO_filtered_1_3_valid; // @[Arbiter.scala 97:79]
  reg  state_8_1; // @[Arbiter.scala 116:26]
  wire  muxStateEarly_8_1 = idle_8 ? earlyWinner_8_1 : state_8_1; // @[Arbiter.scala 117:30]
  wire [4:0] _T_1004 = muxStateEarly_8_1 ? auto_out_1_d_bits_source : 5'h0; // @[Mux.scala 27:72]
  wire [4:0] _T_1006 = _T_1003 | _T_1004; // @[Mux.scala 27:72]
  wire  readys_8_2 = readys_readys_8[2]; // @[Arbiter.scala 95:86]
  wire  earlyWinner_8_2 = readys_8_2 & portsDIO_filtered_2_3_valid; // @[Arbiter.scala 97:79]
  reg  state_8_2; // @[Arbiter.scala 116:26]
  wire  muxStateEarly_8_2 = idle_8 ? earlyWinner_8_2 : state_8_2; // @[Arbiter.scala 117:30]
  wire [4:0] _T_1005 = muxStateEarly_8_2 ? auto_out_2_d_bits_source : 5'h0; // @[Mux.scala 27:72]
  wire [4:0] sink_ACancel_13_bits_source = _T_1006 | _T_1005; // @[Mux.scala 27:72]
  wire [4:0] _GEN_28 = {{3'd0}, auto_in_4_a_bits_source}; // @[Xbar.scala 237:55]
  wire [4:0] in_4_a_bits_source = _GEN_28 | 5'h10; // @[Xbar.scala 237:55]
  wire [4:0] _GEN_29 = {{3'd0}, auto_in_4_c_bits_source}; // @[Xbar.scala 259:55]
  wire [4:0] in_4_c_bits_source = _GEN_29 | 5'h10; // @[Xbar.scala 259:55]
  reg [8:0] beatsLeft_9; // @[Arbiter.scala 87:30]
  wire  idle_9 = beatsLeft_9 == 9'h0; // @[Arbiter.scala 88:28]
  wire  requestDOI_2_4 = auto_out_2_d_bits_source[4:2] == 3'h4; // @[Parameters.scala 54:32]
  wire  portsDIO_filtered_2_4_valid = auto_out_2_d_valid & requestDOI_2_4; // @[Xbar.scala 179:40]
  wire  requestDOI_1_4 = auto_out_1_d_bits_source[4:2] == 3'h4; // @[Parameters.scala 54:32]
  wire  portsDIO_filtered_1_4_valid = auto_out_1_d_valid & requestDOI_1_4; // @[Xbar.scala 179:40]
  wire  requestDOI_0_4 = auto_out_0_d_bits_source[4:2] == 3'h4; // @[Parameters.scala 54:32]
  wire  portsDIO_filtered__4_valid = auto_out_0_d_valid & requestDOI_0_4; // @[Xbar.scala 179:40]
  wire [2:0] readys_filter_lo_9 = {portsDIO_filtered_2_4_valid,portsDIO_filtered_1_4_valid,portsDIO_filtered__4_valid}; // @[Cat.scala 30:58]
  reg [2:0] readys_mask_9; // @[Arbiter.scala 23:23]
  wire [2:0] _readys_filter_T_9 = ~readys_mask_9; // @[Arbiter.scala 24:30]
  wire [2:0] readys_filter_hi_9 = readys_filter_lo_9 & _readys_filter_T_9; // @[Arbiter.scala 24:28]
  wire [5:0] readys_filter_9 = {readys_filter_hi_9,portsDIO_filtered_2_4_valid,portsDIO_filtered_1_4_valid,
    portsDIO_filtered__4_valid}; // @[Cat.scala 30:58]
  wire [5:0] _GEN_30 = {{1'd0}, readys_filter_9[5:1]}; // @[package.scala 253:43]
  wire [5:0] _readys_unready_T_70 = readys_filter_9 | _GEN_30; // @[package.scala 253:43]
  wire [5:0] _GEN_31 = {{2'd0}, _readys_unready_T_70[5:2]}; // @[package.scala 253:43]
  wire [5:0] _readys_unready_T_72 = _readys_unready_T_70 | _GEN_31; // @[package.scala 253:43]
  wire [5:0] _readys_unready_T_75 = {readys_mask_9, 3'h0}; // @[Arbiter.scala 25:66]
  wire [5:0] _GEN_32 = {{1'd0}, _readys_unready_T_72[5:1]}; // @[Arbiter.scala 25:58]
  wire [5:0] readys_unready_9 = _GEN_32 | _readys_unready_T_75; // @[Arbiter.scala 25:58]
  wire [2:0] _readys_readys_T_29 = readys_unready_9[5:3] & readys_unready_9[2:0]; // @[Arbiter.scala 26:39]
  wire [2:0] readys_readys_9 = ~_readys_readys_T_29; // @[Arbiter.scala 26:18]
  wire  readys_9_0 = readys_readys_9[0]; // @[Arbiter.scala 95:86]
  wire  earlyWinner_9_0 = readys_9_0 & portsDIO_filtered__4_valid; // @[Arbiter.scala 97:79]
  reg  state_9_0; // @[Arbiter.scala 116:26]
  wire  muxStateEarly_9_0 = idle_9 ? earlyWinner_9_0 : state_9_0; // @[Arbiter.scala 117:30]
  wire [4:0] _T_1075 = muxStateEarly_9_0 ? auto_out_0_d_bits_source : 5'h0; // @[Mux.scala 27:72]
  wire  readys_9_1 = readys_readys_9[1]; // @[Arbiter.scala 95:86]
  wire  earlyWinner_9_1 = readys_9_1 & portsDIO_filtered_1_4_valid; // @[Arbiter.scala 97:79]
  reg  state_9_1; // @[Arbiter.scala 116:26]
  wire  muxStateEarly_9_1 = idle_9 ? earlyWinner_9_1 : state_9_1; // @[Arbiter.scala 117:30]
  wire [4:0] _T_1076 = muxStateEarly_9_1 ? auto_out_1_d_bits_source : 5'h0; // @[Mux.scala 27:72]
  wire [4:0] _T_1078 = _T_1075 | _T_1076; // @[Mux.scala 27:72]
  wire  readys_9_2 = readys_readys_9[2]; // @[Arbiter.scala 95:86]
  wire  earlyWinner_9_2 = readys_9_2 & portsDIO_filtered_2_4_valid; // @[Arbiter.scala 97:79]
  reg  state_9_2; // @[Arbiter.scala 116:26]
  wire  muxStateEarly_9_2 = idle_9 ? earlyWinner_9_2 : state_9_2; // @[Arbiter.scala 117:30]
  wire [4:0] _T_1077 = muxStateEarly_9_2 ? auto_out_2_d_bits_source : 5'h0; // @[Mux.scala 27:72]
  wire [4:0] sink_ACancel_15_bits_source = _T_1078 | _T_1077; // @[Mux.scala 27:72]
  reg  beatsLeft_3; // @[Arbiter.scala 87:30]
  wire  idle_3 = ~beatsLeft_3; // @[Arbiter.scala 88:28]
  wire [3:0] readys_filter_lo_3 = {auto_in_4_e_valid,auto_in_3_e_valid,auto_in_2_e_valid,auto_in_1_e_valid}; // @[Cat.scala 30:58]
  reg [3:0] readys_mask_3; // @[Arbiter.scala 23:23]
  wire [3:0] _readys_filter_T_3 = ~readys_mask_3; // @[Arbiter.scala 24:30]
  wire [3:0] readys_filter_hi_3 = readys_filter_lo_3 & _readys_filter_T_3; // @[Arbiter.scala 24:28]
  wire [7:0] readys_filter_3 = {readys_filter_hi_3,auto_in_4_e_valid,auto_in_3_e_valid,auto_in_2_e_valid,
    auto_in_1_e_valid}; // @[Cat.scala 30:58]
  wire [7:0] _GEN_33 = {{1'd0}, readys_filter_3[7:1]}; // @[package.scala 253:43]
  wire [7:0] _readys_unready_T_26 = readys_filter_3 | _GEN_33; // @[package.scala 253:43]
  wire [7:0] _GEN_34 = {{2'd0}, _readys_unready_T_26[7:2]}; // @[package.scala 253:43]
  wire [7:0] _readys_unready_T_28 = _readys_unready_T_26 | _GEN_34; // @[package.scala 253:43]
  wire [7:0] _readys_unready_T_31 = {readys_mask_3, 4'h0}; // @[Arbiter.scala 25:66]
  wire [7:0] _GEN_35 = {{1'd0}, _readys_unready_T_28[7:1]}; // @[Arbiter.scala 25:58]
  wire [7:0] readys_unready_3 = _GEN_35 | _readys_unready_T_31; // @[Arbiter.scala 25:58]
  wire [3:0] _readys_readys_T_11 = readys_unready_3[7:4] & readys_unready_3[3:0]; // @[Arbiter.scala 26:39]
  wire [3:0] readys_readys_3 = ~_readys_readys_T_11; // @[Arbiter.scala 26:18]
  wire  readys_3_0 = readys_readys_3[0]; // @[Arbiter.scala 95:86]
  wire  earlyWinner_3_0 = readys_3_0 & auto_in_1_e_valid; // @[Arbiter.scala 97:79]
  reg  state_3_0; // @[Arbiter.scala 116:26]
  wire  muxStateEarly_3_0 = idle_3 ? earlyWinner_3_0 : state_3_0; // @[Arbiter.scala 117:30]
  wire [1:0] _T_545 = muxStateEarly_3_0 ? auto_in_1_e_bits_sink : 2'h0; // @[Mux.scala 27:72]
  wire  readys_3_1 = readys_readys_3[1]; // @[Arbiter.scala 95:86]
  wire  earlyWinner_3_1 = readys_3_1 & auto_in_2_e_valid; // @[Arbiter.scala 97:79]
  reg  state_3_1; // @[Arbiter.scala 116:26]
  wire  muxStateEarly_3_1 = idle_3 ? earlyWinner_3_1 : state_3_1; // @[Arbiter.scala 117:30]
  wire [1:0] _T_546 = muxStateEarly_3_1 ? auto_in_2_e_bits_sink : 2'h0; // @[Mux.scala 27:72]
  wire [1:0] _T_549 = _T_545 | _T_546; // @[Mux.scala 27:72]
  wire  readys_3_2 = readys_readys_3[2]; // @[Arbiter.scala 95:86]
  wire  earlyWinner_3_2 = readys_3_2 & auto_in_3_e_valid; // @[Arbiter.scala 97:79]
  reg  state_3_2; // @[Arbiter.scala 116:26]
  wire  muxStateEarly_3_2 = idle_3 ? earlyWinner_3_2 : state_3_2; // @[Arbiter.scala 117:30]
  wire [1:0] _T_547 = muxStateEarly_3_2 ? auto_in_3_e_bits_sink : 2'h0; // @[Mux.scala 27:72]
  wire [1:0] _T_550 = _T_549 | _T_547; // @[Mux.scala 27:72]
  wire  readys_3_3 = readys_readys_3[3]; // @[Arbiter.scala 95:86]
  wire  earlyWinner_3_3 = readys_3_3 & auto_in_4_e_valid; // @[Arbiter.scala 97:79]
  reg  state_3_3; // @[Arbiter.scala 116:26]
  wire  muxStateEarly_3_3 = idle_3 ? earlyWinner_3_3 : state_3_3; // @[Arbiter.scala 117:30]
  wire [1:0] _T_548 = muxStateEarly_3_3 ? auto_in_4_e_bits_sink : 2'h0; // @[Mux.scala 27:72]
  wire [32:0] _requestAIO_T_1 = {1'b0,$signed(auto_in_0_a_bits_address)}; // @[Parameters.scala 137:49]
  wire [32:0] _requestAIO_T_3 = $signed(_requestAIO_T_1) & 33'shf0000000; // @[Parameters.scala 137:52]
  wire  requestAIO_0_0 = $signed(_requestAIO_T_3) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _requestAIO_T_5 = auto_in_0_a_bits_address ^ 32'h80000000; // @[Parameters.scala 137:31]
  wire [32:0] _requestAIO_T_6 = {1'b0,$signed(_requestAIO_T_5)}; // @[Parameters.scala 137:49]
  wire [32:0] _requestAIO_T_8 = $signed(_requestAIO_T_6) & 33'sh80000000; // @[Parameters.scala 137:52]
  wire  requestAIO_0_1 = $signed(_requestAIO_T_8) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _requestAIO_T_10 = auto_in_0_a_bits_address ^ 32'h10000000; // @[Parameters.scala 137:31]
  wire [32:0] _requestAIO_T_11 = {1'b0,$signed(_requestAIO_T_10)}; // @[Parameters.scala 137:49]
  wire [32:0] _requestAIO_T_13 = $signed(_requestAIO_T_11) & 33'shf0000000; // @[Parameters.scala 137:52]
  wire  _requestAIO_T_14 = $signed(_requestAIO_T_13) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _requestAIO_T_15 = auto_in_0_a_bits_address ^ 32'h20000000; // @[Parameters.scala 137:31]
  wire [32:0] _requestAIO_T_16 = {1'b0,$signed(_requestAIO_T_15)}; // @[Parameters.scala 137:49]
  wire [32:0] _requestAIO_T_18 = $signed(_requestAIO_T_16) & 33'she0000000; // @[Parameters.scala 137:52]
  wire  _requestAIO_T_19 = $signed(_requestAIO_T_18) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _requestAIO_T_20 = auto_in_0_a_bits_address ^ 32'h40000000; // @[Parameters.scala 137:31]
  wire [32:0] _requestAIO_T_21 = {1'b0,$signed(_requestAIO_T_20)}; // @[Parameters.scala 137:49]
  wire [32:0] _requestAIO_T_23 = $signed(_requestAIO_T_21) & 33'shc0000000; // @[Parameters.scala 137:52]
  wire  _requestAIO_T_24 = $signed(_requestAIO_T_23) == 33'sh0; // @[Parameters.scala 137:67]
  wire  requestAIO_0_2 = _requestAIO_T_14 | _requestAIO_T_19 | _requestAIO_T_24; // @[Xbar.scala 363:92]
  wire [32:0] _requestAIO_T_28 = {1'b0,$signed(auto_in_1_a_bits_address)}; // @[Parameters.scala 137:49]
  wire [32:0] _requestAIO_T_30 = $signed(_requestAIO_T_28) & 33'shf0000000; // @[Parameters.scala 137:52]
  wire  requestAIO_1_0 = $signed(_requestAIO_T_30) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _requestAIO_T_32 = auto_in_1_a_bits_address ^ 32'h80000000; // @[Parameters.scala 137:31]
  wire [32:0] _requestAIO_T_33 = {1'b0,$signed(_requestAIO_T_32)}; // @[Parameters.scala 137:49]
  wire [32:0] _requestAIO_T_35 = $signed(_requestAIO_T_33) & 33'sh80000000; // @[Parameters.scala 137:52]
  wire  requestAIO_1_1 = $signed(_requestAIO_T_35) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _requestAIO_T_37 = auto_in_1_a_bits_address ^ 32'h10000000; // @[Parameters.scala 137:31]
  wire [32:0] _requestAIO_T_38 = {1'b0,$signed(_requestAIO_T_37)}; // @[Parameters.scala 137:49]
  wire [32:0] _requestAIO_T_40 = $signed(_requestAIO_T_38) & 33'shf0000000; // @[Parameters.scala 137:52]
  wire  _requestAIO_T_41 = $signed(_requestAIO_T_40) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _requestAIO_T_42 = auto_in_1_a_bits_address ^ 32'h20000000; // @[Parameters.scala 137:31]
  wire [32:0] _requestAIO_T_43 = {1'b0,$signed(_requestAIO_T_42)}; // @[Parameters.scala 137:49]
  wire [32:0] _requestAIO_T_45 = $signed(_requestAIO_T_43) & 33'she0000000; // @[Parameters.scala 137:52]
  wire  _requestAIO_T_46 = $signed(_requestAIO_T_45) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _requestAIO_T_47 = auto_in_1_a_bits_address ^ 32'h40000000; // @[Parameters.scala 137:31]
  wire [32:0] _requestAIO_T_48 = {1'b0,$signed(_requestAIO_T_47)}; // @[Parameters.scala 137:49]
  wire [32:0] _requestAIO_T_50 = $signed(_requestAIO_T_48) & 33'shc0000000; // @[Parameters.scala 137:52]
  wire  _requestAIO_T_51 = $signed(_requestAIO_T_50) == 33'sh0; // @[Parameters.scala 137:67]
  wire  requestAIO_1_2 = _requestAIO_T_41 | _requestAIO_T_46 | _requestAIO_T_51; // @[Xbar.scala 363:92]
  wire [32:0] _requestAIO_T_55 = {1'b0,$signed(auto_in_2_a_bits_address)}; // @[Parameters.scala 137:49]
  wire [32:0] _requestAIO_T_57 = $signed(_requestAIO_T_55) & 33'shf0000000; // @[Parameters.scala 137:52]
  wire  requestAIO_2_0 = $signed(_requestAIO_T_57) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _requestAIO_T_59 = auto_in_2_a_bits_address ^ 32'h80000000; // @[Parameters.scala 137:31]
  wire [32:0] _requestAIO_T_60 = {1'b0,$signed(_requestAIO_T_59)}; // @[Parameters.scala 137:49]
  wire [32:0] _requestAIO_T_62 = $signed(_requestAIO_T_60) & 33'sh80000000; // @[Parameters.scala 137:52]
  wire  requestAIO_2_1 = $signed(_requestAIO_T_62) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _requestAIO_T_64 = auto_in_2_a_bits_address ^ 32'h10000000; // @[Parameters.scala 137:31]
  wire [32:0] _requestAIO_T_65 = {1'b0,$signed(_requestAIO_T_64)}; // @[Parameters.scala 137:49]
  wire [32:0] _requestAIO_T_67 = $signed(_requestAIO_T_65) & 33'shf0000000; // @[Parameters.scala 137:52]
  wire  _requestAIO_T_68 = $signed(_requestAIO_T_67) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _requestAIO_T_69 = auto_in_2_a_bits_address ^ 32'h20000000; // @[Parameters.scala 137:31]
  wire [32:0] _requestAIO_T_70 = {1'b0,$signed(_requestAIO_T_69)}; // @[Parameters.scala 137:49]
  wire [32:0] _requestAIO_T_72 = $signed(_requestAIO_T_70) & 33'she0000000; // @[Parameters.scala 137:52]
  wire  _requestAIO_T_73 = $signed(_requestAIO_T_72) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _requestAIO_T_74 = auto_in_2_a_bits_address ^ 32'h40000000; // @[Parameters.scala 137:31]
  wire [32:0] _requestAIO_T_75 = {1'b0,$signed(_requestAIO_T_74)}; // @[Parameters.scala 137:49]
  wire [32:0] _requestAIO_T_77 = $signed(_requestAIO_T_75) & 33'shc0000000; // @[Parameters.scala 137:52]
  wire  _requestAIO_T_78 = $signed(_requestAIO_T_77) == 33'sh0; // @[Parameters.scala 137:67]
  wire  requestAIO_2_2 = _requestAIO_T_68 | _requestAIO_T_73 | _requestAIO_T_78; // @[Xbar.scala 363:92]
  wire [32:0] _requestAIO_T_82 = {1'b0,$signed(auto_in_3_a_bits_address)}; // @[Parameters.scala 137:49]
  wire [32:0] _requestAIO_T_84 = $signed(_requestAIO_T_82) & 33'shf0000000; // @[Parameters.scala 137:52]
  wire  requestAIO_3_0 = $signed(_requestAIO_T_84) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _requestAIO_T_86 = auto_in_3_a_bits_address ^ 32'h80000000; // @[Parameters.scala 137:31]
  wire [32:0] _requestAIO_T_87 = {1'b0,$signed(_requestAIO_T_86)}; // @[Parameters.scala 137:49]
  wire [32:0] _requestAIO_T_89 = $signed(_requestAIO_T_87) & 33'sh80000000; // @[Parameters.scala 137:52]
  wire  requestAIO_3_1 = $signed(_requestAIO_T_89) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _requestAIO_T_91 = auto_in_3_a_bits_address ^ 32'h10000000; // @[Parameters.scala 137:31]
  wire [32:0] _requestAIO_T_92 = {1'b0,$signed(_requestAIO_T_91)}; // @[Parameters.scala 137:49]
  wire [32:0] _requestAIO_T_94 = $signed(_requestAIO_T_92) & 33'shf0000000; // @[Parameters.scala 137:52]
  wire  _requestAIO_T_95 = $signed(_requestAIO_T_94) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _requestAIO_T_96 = auto_in_3_a_bits_address ^ 32'h20000000; // @[Parameters.scala 137:31]
  wire [32:0] _requestAIO_T_97 = {1'b0,$signed(_requestAIO_T_96)}; // @[Parameters.scala 137:49]
  wire [32:0] _requestAIO_T_99 = $signed(_requestAIO_T_97) & 33'she0000000; // @[Parameters.scala 137:52]
  wire  _requestAIO_T_100 = $signed(_requestAIO_T_99) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _requestAIO_T_101 = auto_in_3_a_bits_address ^ 32'h40000000; // @[Parameters.scala 137:31]
  wire [32:0] _requestAIO_T_102 = {1'b0,$signed(_requestAIO_T_101)}; // @[Parameters.scala 137:49]
  wire [32:0] _requestAIO_T_104 = $signed(_requestAIO_T_102) & 33'shc0000000; // @[Parameters.scala 137:52]
  wire  _requestAIO_T_105 = $signed(_requestAIO_T_104) == 33'sh0; // @[Parameters.scala 137:67]
  wire  requestAIO_3_2 = _requestAIO_T_95 | _requestAIO_T_100 | _requestAIO_T_105; // @[Xbar.scala 363:92]
  wire [32:0] _requestAIO_T_109 = {1'b0,$signed(auto_in_4_a_bits_address)}; // @[Parameters.scala 137:49]
  wire [32:0] _requestAIO_T_111 = $signed(_requestAIO_T_109) & 33'shf0000000; // @[Parameters.scala 137:52]
  wire  requestAIO_4_0 = $signed(_requestAIO_T_111) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _requestAIO_T_113 = auto_in_4_a_bits_address ^ 32'h80000000; // @[Parameters.scala 137:31]
  wire [32:0] _requestAIO_T_114 = {1'b0,$signed(_requestAIO_T_113)}; // @[Parameters.scala 137:49]
  wire [32:0] _requestAIO_T_116 = $signed(_requestAIO_T_114) & 33'sh80000000; // @[Parameters.scala 137:52]
  wire  requestAIO_4_1 = $signed(_requestAIO_T_116) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _requestAIO_T_118 = auto_in_4_a_bits_address ^ 32'h10000000; // @[Parameters.scala 137:31]
  wire [32:0] _requestAIO_T_119 = {1'b0,$signed(_requestAIO_T_118)}; // @[Parameters.scala 137:49]
  wire [32:0] _requestAIO_T_121 = $signed(_requestAIO_T_119) & 33'shf0000000; // @[Parameters.scala 137:52]
  wire  _requestAIO_T_122 = $signed(_requestAIO_T_121) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _requestAIO_T_123 = auto_in_4_a_bits_address ^ 32'h20000000; // @[Parameters.scala 137:31]
  wire [32:0] _requestAIO_T_124 = {1'b0,$signed(_requestAIO_T_123)}; // @[Parameters.scala 137:49]
  wire [32:0] _requestAIO_T_126 = $signed(_requestAIO_T_124) & 33'she0000000; // @[Parameters.scala 137:52]
  wire  _requestAIO_T_127 = $signed(_requestAIO_T_126) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _requestAIO_T_128 = auto_in_4_a_bits_address ^ 32'h40000000; // @[Parameters.scala 137:31]
  wire [32:0] _requestAIO_T_129 = {1'b0,$signed(_requestAIO_T_128)}; // @[Parameters.scala 137:49]
  wire [32:0] _requestAIO_T_131 = $signed(_requestAIO_T_129) & 33'shc0000000; // @[Parameters.scala 137:52]
  wire  _requestAIO_T_132 = $signed(_requestAIO_T_131) == 33'sh0; // @[Parameters.scala 137:67]
  wire  requestAIO_4_2 = _requestAIO_T_122 | _requestAIO_T_127 | _requestAIO_T_132; // @[Xbar.scala 363:92]
  wire  requestBOI_1_1 = auto_out_1_b_bits_source[4:2] == 3'h7; // @[Parameters.scala 54:32]
  wire  requestBOI_1_2 = auto_out_1_b_bits_source[4:2] == 3'h6; // @[Parameters.scala 54:32]
  wire  requestBOI_1_3 = auto_out_1_b_bits_source[4:2] == 3'h5; // @[Parameters.scala 54:32]
  wire  requestBOI_1_4 = auto_out_1_b_bits_source[4:2] == 3'h4; // @[Parameters.scala 54:32]
  wire [26:0] _beatsAI_decode_T_1 = 27'hfff << auto_in_0_a_bits_size; // @[package.scala 234:77]
  wire [11:0] _beatsAI_decode_T_3 = ~_beatsAI_decode_T_1[11:0]; // @[package.scala 234:46]
  wire [8:0] beatsAI_decode = _beatsAI_decode_T_3[11:3]; // @[Edges.scala 219:59]
  wire  beatsAI_opdata = ~auto_in_0_a_bits_opcode[2]; // @[Edges.scala 91:28]
  wire [8:0] beatsAI_0 = beatsAI_opdata ? beatsAI_decode : 9'h0; // @[Edges.scala 220:14]
  wire [26:0] _beatsAI_decode_T_5 = 27'hfff << auto_in_1_a_bits_size; // @[package.scala 234:77]
  wire [11:0] _beatsAI_decode_T_7 = ~_beatsAI_decode_T_5[11:0]; // @[package.scala 234:46]
  wire [8:0] beatsAI_decode_1 = _beatsAI_decode_T_7[11:3]; // @[Edges.scala 219:59]
  wire  beatsAI_opdata_1 = ~auto_in_1_a_bits_opcode[2]; // @[Edges.scala 91:28]
  wire [8:0] beatsAI_1 = beatsAI_opdata_1 ? beatsAI_decode_1 : 9'h0; // @[Edges.scala 220:14]
  wire [26:0] _beatsAI_decode_T_9 = 27'hfff << auto_in_2_a_bits_size; // @[package.scala 234:77]
  wire [11:0] _beatsAI_decode_T_11 = ~_beatsAI_decode_T_9[11:0]; // @[package.scala 234:46]
  wire [8:0] beatsAI_decode_2 = _beatsAI_decode_T_11[11:3]; // @[Edges.scala 219:59]
  wire  beatsAI_opdata_2 = ~auto_in_2_a_bits_opcode[2]; // @[Edges.scala 91:28]
  wire [8:0] beatsAI_2 = beatsAI_opdata_2 ? beatsAI_decode_2 : 9'h0; // @[Edges.scala 220:14]
  wire [26:0] _beatsAI_decode_T_13 = 27'hfff << auto_in_3_a_bits_size; // @[package.scala 234:77]
  wire [11:0] _beatsAI_decode_T_15 = ~_beatsAI_decode_T_13[11:0]; // @[package.scala 234:46]
  wire [8:0] beatsAI_decode_3 = _beatsAI_decode_T_15[11:3]; // @[Edges.scala 219:59]
  wire  beatsAI_opdata_3 = ~auto_in_3_a_bits_opcode[2]; // @[Edges.scala 91:28]
  wire [8:0] beatsAI_3 = beatsAI_opdata_3 ? beatsAI_decode_3 : 9'h0; // @[Edges.scala 220:14]
  wire [26:0] _beatsAI_decode_T_17 = 27'hfff << auto_in_4_a_bits_size; // @[package.scala 234:77]
  wire [11:0] _beatsAI_decode_T_19 = ~_beatsAI_decode_T_17[11:0]; // @[package.scala 234:46]
  wire [8:0] beatsAI_decode_4 = _beatsAI_decode_T_19[11:3]; // @[Edges.scala 219:59]
  wire  beatsAI_opdata_4 = ~auto_in_4_a_bits_opcode[2]; // @[Edges.scala 91:28]
  wire [8:0] beatsAI_4 = beatsAI_opdata_4 ? beatsAI_decode_4 : 9'h0; // @[Edges.scala 220:14]
  wire [26:0] _beatsCI_decode_T_5 = 27'hfff << auto_in_1_c_bits_size; // @[package.scala 234:77]
  wire [11:0] _beatsCI_decode_T_7 = ~_beatsCI_decode_T_5[11:0]; // @[package.scala 234:46]
  wire [8:0] beatsCI_decode_1 = _beatsCI_decode_T_7[11:3]; // @[Edges.scala 219:59]
  wire  beatsCI_opdata_1 = auto_in_1_c_bits_opcode[0]; // @[Edges.scala 101:36]
  wire [8:0] beatsCI_1 = beatsCI_opdata_1 ? beatsCI_decode_1 : 9'h0; // @[Edges.scala 220:14]
  wire [26:0] _beatsCI_decode_T_9 = 27'hfff << auto_in_2_c_bits_size; // @[package.scala 234:77]
  wire [11:0] _beatsCI_decode_T_11 = ~_beatsCI_decode_T_9[11:0]; // @[package.scala 234:46]
  wire [8:0] beatsCI_decode_2 = _beatsCI_decode_T_11[11:3]; // @[Edges.scala 219:59]
  wire  beatsCI_opdata_2 = auto_in_2_c_bits_opcode[0]; // @[Edges.scala 101:36]
  wire [8:0] beatsCI_2 = beatsCI_opdata_2 ? beatsCI_decode_2 : 9'h0; // @[Edges.scala 220:14]
  wire [26:0] _beatsCI_decode_T_13 = 27'hfff << auto_in_3_c_bits_size; // @[package.scala 234:77]
  wire [11:0] _beatsCI_decode_T_15 = ~_beatsCI_decode_T_13[11:0]; // @[package.scala 234:46]
  wire [8:0] beatsCI_decode_3 = _beatsCI_decode_T_15[11:3]; // @[Edges.scala 219:59]
  wire  beatsCI_opdata_3 = auto_in_3_c_bits_opcode[0]; // @[Edges.scala 101:36]
  wire [8:0] beatsCI_3 = beatsCI_opdata_3 ? beatsCI_decode_3 : 9'h0; // @[Edges.scala 220:14]
  wire [26:0] _beatsCI_decode_T_17 = 27'hfff << auto_in_4_c_bits_size; // @[package.scala 234:77]
  wire [11:0] _beatsCI_decode_T_19 = ~_beatsCI_decode_T_17[11:0]; // @[package.scala 234:46]
  wire [8:0] beatsCI_decode_4 = _beatsCI_decode_T_19[11:3]; // @[Edges.scala 219:59]
  wire  beatsCI_opdata_4 = auto_in_4_c_bits_opcode[0]; // @[Edges.scala 101:36]
  wire [8:0] beatsCI_4 = beatsCI_opdata_4 ? beatsCI_decode_4 : 9'h0; // @[Edges.scala 220:14]
  wire [26:0] _beatsDO_decode_T_1 = 27'hfff << auto_out_0_d_bits_size; // @[package.scala 234:77]
  wire [11:0] _beatsDO_decode_T_3 = ~_beatsDO_decode_T_1[11:0]; // @[package.scala 234:46]
  wire [8:0] beatsDO_decode = _beatsDO_decode_T_3[11:3]; // @[Edges.scala 219:59]
  wire  beatsDO_opdata = auto_out_0_d_bits_opcode[0]; // @[Edges.scala 105:36]
  wire [8:0] beatsDO_0 = beatsDO_opdata ? beatsDO_decode : 9'h0; // @[Edges.scala 220:14]
  wire [3:0] out_5_1_d_bits_size = {{1'd0}, auto_out_1_d_bits_size}; // @[Xbar.scala 288:19 BundleMap.scala 247:19]
  wire [20:0] _beatsDO_decode_T_5 = 21'h3f << out_5_1_d_bits_size; // @[package.scala 234:77]
  wire [5:0] _beatsDO_decode_T_7 = ~_beatsDO_decode_T_5[5:0]; // @[package.scala 234:46]
  wire [2:0] beatsDO_decode_1 = _beatsDO_decode_T_7[5:3]; // @[Edges.scala 219:59]
  wire  beatsDO_opdata_1 = auto_out_1_d_bits_opcode[0]; // @[Edges.scala 105:36]
  wire [2:0] beatsDO_1 = beatsDO_opdata_1 ? beatsDO_decode_1 : 3'h0; // @[Edges.scala 220:14]
  wire [22:0] _beatsDO_decode_T_9 = 23'hff << auto_out_2_d_bits_size; // @[package.scala 234:77]
  wire [7:0] _beatsDO_decode_T_11 = ~_beatsDO_decode_T_9[7:0]; // @[package.scala 234:46]
  wire [4:0] beatsDO_decode_2 = _beatsDO_decode_T_11[7:3]; // @[Edges.scala 219:59]
  wire  beatsDO_opdata_2 = auto_out_2_d_bits_opcode[0]; // @[Edges.scala 105:36]
  wire [4:0] beatsDO_2 = beatsDO_opdata_2 ? beatsDO_decode_2 : 5'h0; // @[Edges.scala 220:14]
  wire  portsAOI_filtered__0_earlyValid = auto_in_0_a_valid & requestAIO_0_0; // @[Xbar.scala 428:50]
  wire  portsAOI_filtered__1_earlyValid = auto_in_0_a_valid & requestAIO_0_1; // @[Xbar.scala 428:50]
  wire  portsAOI_filtered__2_earlyValid = auto_in_0_a_valid & requestAIO_0_2; // @[Xbar.scala 428:50]
  reg [8:0] beatsLeft; // @[Arbiter.scala 87:30]
  wire  idle = beatsLeft == 9'h0; // @[Arbiter.scala 88:28]
  wire  portsAOI_filtered_4_0_earlyValid = auto_in_4_a_valid & requestAIO_4_0; // @[Xbar.scala 428:50]
  wire  portsAOI_filtered_3_0_earlyValid = auto_in_3_a_valid & requestAIO_3_0; // @[Xbar.scala 428:50]
  wire  portsAOI_filtered_2_0_earlyValid = auto_in_2_a_valid & requestAIO_2_0; // @[Xbar.scala 428:50]
  wire  portsAOI_filtered_1_0_earlyValid = auto_in_1_a_valid & requestAIO_1_0; // @[Xbar.scala 428:50]
  wire [4:0] readys_filter_lo = {portsAOI_filtered_4_0_earlyValid,portsAOI_filtered_3_0_earlyValid,
    portsAOI_filtered_2_0_earlyValid,portsAOI_filtered_1_0_earlyValid,portsAOI_filtered__0_earlyValid}; // @[Cat.scala 30:58]
  reg [4:0] readys_mask; // @[Arbiter.scala 23:23]
  wire [4:0] _readys_filter_T = ~readys_mask; // @[Arbiter.scala 24:30]
  wire [4:0] readys_filter_hi = readys_filter_lo & _readys_filter_T; // @[Arbiter.scala 24:28]
  wire [9:0] readys_filter = {readys_filter_hi,portsAOI_filtered_4_0_earlyValid,portsAOI_filtered_3_0_earlyValid,
    portsAOI_filtered_2_0_earlyValid,portsAOI_filtered_1_0_earlyValid,portsAOI_filtered__0_earlyValid}; // @[Cat.scala 30:58]
  wire [9:0] _GEN_36 = {{1'd0}, readys_filter[9:1]}; // @[package.scala 253:43]
  wire [9:0] _readys_unready_T_1 = readys_filter | _GEN_36; // @[package.scala 253:43]
  wire [9:0] _GEN_37 = {{2'd0}, _readys_unready_T_1[9:2]}; // @[package.scala 253:43]
  wire [9:0] _readys_unready_T_3 = _readys_unready_T_1 | _GEN_37; // @[package.scala 253:43]
  wire [9:0] _GEN_38 = {{4'd0}, _readys_unready_T_3[9:4]}; // @[package.scala 253:43]
  wire [9:0] _readys_unready_T_5 = _readys_unready_T_3 | _GEN_38; // @[package.scala 253:43]
  wire [9:0] _readys_unready_T_8 = {readys_mask, 5'h0}; // @[Arbiter.scala 25:66]
  wire [9:0] _GEN_39 = {{1'd0}, _readys_unready_T_5[9:1]}; // @[Arbiter.scala 25:58]
  wire [9:0] readys_unready = _GEN_39 | _readys_unready_T_8; // @[Arbiter.scala 25:58]
  wire [4:0] _readys_readys_T_2 = readys_unready[9:5] & readys_unready[4:0]; // @[Arbiter.scala 26:39]
  wire [4:0] readys_readys = ~_readys_readys_T_2; // @[Arbiter.scala 26:18]
  wire  readys__0 = readys_readys[0]; // @[Arbiter.scala 95:86]
  reg  state__0; // @[Arbiter.scala 116:26]
  wire  allowed__0 = idle ? readys__0 : state__0; // @[Arbiter.scala 121:24]
  wire  portsAOI_filtered__0_ready = auto_out_0_a_ready & allowed__0; // @[Arbiter.scala 123:31]
  reg [8:0] beatsLeft_1; // @[Arbiter.scala 87:30]
  wire  idle_1 = beatsLeft_1 == 9'h0; // @[Arbiter.scala 88:28]
  wire  portsAOI_filtered_4_1_earlyValid = auto_in_4_a_valid & requestAIO_4_1; // @[Xbar.scala 428:50]
  wire  portsAOI_filtered_3_1_earlyValid = auto_in_3_a_valid & requestAIO_3_1; // @[Xbar.scala 428:50]
  wire  portsAOI_filtered_2_1_earlyValid = auto_in_2_a_valid & requestAIO_2_1; // @[Xbar.scala 428:50]
  wire  portsAOI_filtered_1_1_earlyValid = auto_in_1_a_valid & requestAIO_1_1; // @[Xbar.scala 428:50]
  wire [4:0] readys_filter_lo_1 = {portsAOI_filtered_4_1_earlyValid,portsAOI_filtered_3_1_earlyValid,
    portsAOI_filtered_2_1_earlyValid,portsAOI_filtered_1_1_earlyValid,portsAOI_filtered__1_earlyValid}; // @[Cat.scala 30:58]
  reg [4:0] readys_mask_1; // @[Arbiter.scala 23:23]
  wire [4:0] _readys_filter_T_1 = ~readys_mask_1; // @[Arbiter.scala 24:30]
  wire [4:0] readys_filter_hi_1 = readys_filter_lo_1 & _readys_filter_T_1; // @[Arbiter.scala 24:28]
  wire [9:0] readys_filter_1 = {readys_filter_hi_1,portsAOI_filtered_4_1_earlyValid,portsAOI_filtered_3_1_earlyValid,
    portsAOI_filtered_2_1_earlyValid,portsAOI_filtered_1_1_earlyValid,portsAOI_filtered__1_earlyValid}; // @[Cat.scala 30:58]
  wire [9:0] _GEN_40 = {{1'd0}, readys_filter_1[9:1]}; // @[package.scala 253:43]
  wire [9:0] _readys_unready_T_10 = readys_filter_1 | _GEN_40; // @[package.scala 253:43]
  wire [9:0] _GEN_41 = {{2'd0}, _readys_unready_T_10[9:2]}; // @[package.scala 253:43]
  wire [9:0] _readys_unready_T_12 = _readys_unready_T_10 | _GEN_41; // @[package.scala 253:43]
  wire [9:0] _GEN_42 = {{4'd0}, _readys_unready_T_12[9:4]}; // @[package.scala 253:43]
  wire [9:0] _readys_unready_T_14 = _readys_unready_T_12 | _GEN_42; // @[package.scala 253:43]
  wire [9:0] _readys_unready_T_17 = {readys_mask_1, 5'h0}; // @[Arbiter.scala 25:66]
  wire [9:0] _GEN_43 = {{1'd0}, _readys_unready_T_14[9:1]}; // @[Arbiter.scala 25:58]
  wire [9:0] readys_unready_1 = _GEN_43 | _readys_unready_T_17; // @[Arbiter.scala 25:58]
  wire [4:0] _readys_readys_T_5 = readys_unready_1[9:5] & readys_unready_1[4:0]; // @[Arbiter.scala 26:39]
  wire [4:0] readys_readys_1 = ~_readys_readys_T_5; // @[Arbiter.scala 26:18]
  wire  readys_1_0 = readys_readys_1[0]; // @[Arbiter.scala 95:86]
  reg  state_1_0; // @[Arbiter.scala 116:26]
  wire  allowed_1_0 = idle_1 ? readys_1_0 : state_1_0; // @[Arbiter.scala 121:24]
  wire  portsAOI_filtered__1_ready = auto_out_1_a_ready & allowed_1_0; // @[Arbiter.scala 123:31]
  reg [8:0] beatsLeft_4; // @[Arbiter.scala 87:30]
  wire  idle_4 = beatsLeft_4 == 9'h0; // @[Arbiter.scala 88:28]
  wire  portsAOI_filtered_4_2_earlyValid = auto_in_4_a_valid & requestAIO_4_2; // @[Xbar.scala 428:50]
  wire  portsAOI_filtered_3_2_earlyValid = auto_in_3_a_valid & requestAIO_3_2; // @[Xbar.scala 428:50]
  wire  portsAOI_filtered_2_2_earlyValid = auto_in_2_a_valid & requestAIO_2_2; // @[Xbar.scala 428:50]
  wire  portsAOI_filtered_1_2_earlyValid = auto_in_1_a_valid & requestAIO_1_2; // @[Xbar.scala 428:50]
  wire [4:0] readys_filter_lo_4 = {portsAOI_filtered_4_2_earlyValid,portsAOI_filtered_3_2_earlyValid,
    portsAOI_filtered_2_2_earlyValid,portsAOI_filtered_1_2_earlyValid,portsAOI_filtered__2_earlyValid}; // @[Cat.scala 30:58]
  reg [4:0] readys_mask_4; // @[Arbiter.scala 23:23]
  wire [4:0] _readys_filter_T_4 = ~readys_mask_4; // @[Arbiter.scala 24:30]
  wire [4:0] readys_filter_hi_4 = readys_filter_lo_4 & _readys_filter_T_4; // @[Arbiter.scala 24:28]
  wire [9:0] readys_filter_4 = {readys_filter_hi_4,portsAOI_filtered_4_2_earlyValid,portsAOI_filtered_3_2_earlyValid,
    portsAOI_filtered_2_2_earlyValid,portsAOI_filtered_1_2_earlyValid,portsAOI_filtered__2_earlyValid}; // @[Cat.scala 30:58]
  wire [9:0] _GEN_44 = {{1'd0}, readys_filter_4[9:1]}; // @[package.scala 253:43]
  wire [9:0] _readys_unready_T_33 = readys_filter_4 | _GEN_44; // @[package.scala 253:43]
  wire [9:0] _GEN_45 = {{2'd0}, _readys_unready_T_33[9:2]}; // @[package.scala 253:43]
  wire [9:0] _readys_unready_T_35 = _readys_unready_T_33 | _GEN_45; // @[package.scala 253:43]
  wire [9:0] _GEN_46 = {{4'd0}, _readys_unready_T_35[9:4]}; // @[package.scala 253:43]
  wire [9:0] _readys_unready_T_37 = _readys_unready_T_35 | _GEN_46; // @[package.scala 253:43]
  wire [9:0] _readys_unready_T_40 = {readys_mask_4, 5'h0}; // @[Arbiter.scala 25:66]
  wire [9:0] _GEN_47 = {{1'd0}, _readys_unready_T_37[9:1]}; // @[Arbiter.scala 25:58]
  wire [9:0] readys_unready_4 = _GEN_47 | _readys_unready_T_40; // @[Arbiter.scala 25:58]
  wire [4:0] _readys_readys_T_14 = readys_unready_4[9:5] & readys_unready_4[4:0]; // @[Arbiter.scala 26:39]
  wire [4:0] readys_readys_4 = ~_readys_readys_T_14; // @[Arbiter.scala 26:18]
  wire  readys_4_0 = readys_readys_4[0]; // @[Arbiter.scala 95:86]
  reg  state_4_0; // @[Arbiter.scala 116:26]
  wire  allowed_4_0 = idle_4 ? readys_4_0 : state_4_0; // @[Arbiter.scala 121:24]
  wire  portsAOI_filtered__2_ready = auto_out_2_a_ready & allowed_4_0; // @[Arbiter.scala 123:31]
  wire  readys__1 = readys_readys[1]; // @[Arbiter.scala 95:86]
  reg  state__1; // @[Arbiter.scala 116:26]
  wire  allowed__1 = idle ? readys__1 : state__1; // @[Arbiter.scala 121:24]
  wire  portsAOI_filtered_1_0_ready = auto_out_0_a_ready & allowed__1; // @[Arbiter.scala 123:31]
  wire  readys_1_1 = readys_readys_1[1]; // @[Arbiter.scala 95:86]
  reg  state_1_1; // @[Arbiter.scala 116:26]
  wire  allowed_1_1 = idle_1 ? readys_1_1 : state_1_1; // @[Arbiter.scala 121:24]
  wire  portsAOI_filtered_1_1_ready = auto_out_1_a_ready & allowed_1_1; // @[Arbiter.scala 123:31]
  wire  readys_4_1 = readys_readys_4[1]; // @[Arbiter.scala 95:86]
  reg  state_4_1; // @[Arbiter.scala 116:26]
  wire  allowed_4_1 = idle_4 ? readys_4_1 : state_4_1; // @[Arbiter.scala 121:24]
  wire  portsAOI_filtered_1_2_ready = auto_out_2_a_ready & allowed_4_1; // @[Arbiter.scala 123:31]
  wire  readys__2 = readys_readys[2]; // @[Arbiter.scala 95:86]
  reg  state__2; // @[Arbiter.scala 116:26]
  wire  allowed__2 = idle ? readys__2 : state__2; // @[Arbiter.scala 121:24]
  wire  portsAOI_filtered_2_0_ready = auto_out_0_a_ready & allowed__2; // @[Arbiter.scala 123:31]
  wire  readys_1_2 = readys_readys_1[2]; // @[Arbiter.scala 95:86]
  reg  state_1_2; // @[Arbiter.scala 116:26]
  wire  allowed_1_2 = idle_1 ? readys_1_2 : state_1_2; // @[Arbiter.scala 121:24]
  wire  portsAOI_filtered_2_1_ready = auto_out_1_a_ready & allowed_1_2; // @[Arbiter.scala 123:31]
  wire  readys_4_2 = readys_readys_4[2]; // @[Arbiter.scala 95:86]
  reg  state_4_2; // @[Arbiter.scala 116:26]
  wire  allowed_4_2 = idle_4 ? readys_4_2 : state_4_2; // @[Arbiter.scala 121:24]
  wire  portsAOI_filtered_2_2_ready = auto_out_2_a_ready & allowed_4_2; // @[Arbiter.scala 123:31]
  wire  readys__3 = readys_readys[3]; // @[Arbiter.scala 95:86]
  reg  state__3; // @[Arbiter.scala 116:26]
  wire  allowed__3 = idle ? readys__3 : state__3; // @[Arbiter.scala 121:24]
  wire  portsAOI_filtered_3_0_ready = auto_out_0_a_ready & allowed__3; // @[Arbiter.scala 123:31]
  wire  readys_1_3 = readys_readys_1[3]; // @[Arbiter.scala 95:86]
  reg  state_1_3; // @[Arbiter.scala 116:26]
  wire  allowed_1_3 = idle_1 ? readys_1_3 : state_1_3; // @[Arbiter.scala 121:24]
  wire  portsAOI_filtered_3_1_ready = auto_out_1_a_ready & allowed_1_3; // @[Arbiter.scala 123:31]
  wire  readys_4_3 = readys_readys_4[3]; // @[Arbiter.scala 95:86]
  reg  state_4_3; // @[Arbiter.scala 116:26]
  wire  allowed_4_3 = idle_4 ? readys_4_3 : state_4_3; // @[Arbiter.scala 121:24]
  wire  portsAOI_filtered_3_2_ready = auto_out_2_a_ready & allowed_4_3; // @[Arbiter.scala 123:31]
  wire  readys__4 = readys_readys[4]; // @[Arbiter.scala 95:86]
  reg  state__4; // @[Arbiter.scala 116:26]
  wire  allowed__4 = idle ? readys__4 : state__4; // @[Arbiter.scala 121:24]
  wire  portsAOI_filtered_4_0_ready = auto_out_0_a_ready & allowed__4; // @[Arbiter.scala 123:31]
  wire  readys_1_4 = readys_readys_1[4]; // @[Arbiter.scala 95:86]
  reg  state_1_4; // @[Arbiter.scala 116:26]
  wire  allowed_1_4 = idle_1 ? readys_1_4 : state_1_4; // @[Arbiter.scala 121:24]
  wire  portsAOI_filtered_4_1_ready = auto_out_1_a_ready & allowed_1_4; // @[Arbiter.scala 123:31]
  wire  readys_4_4 = readys_readys_4[4]; // @[Arbiter.scala 95:86]
  reg  state_4_4; // @[Arbiter.scala 116:26]
  wire  allowed_4_4 = idle_4 ? readys_4_4 : state_4_4; // @[Arbiter.scala 121:24]
  wire  portsAOI_filtered_4_2_ready = auto_out_2_a_ready & allowed_4_4; // @[Arbiter.scala 123:31]
  reg [8:0] beatsLeft_2; // @[Arbiter.scala 87:30]
  wire  idle_2 = beatsLeft_2 == 9'h0; // @[Arbiter.scala 88:28]
  wire [3:0] readys_filter_lo_2 = {auto_in_4_c_valid,auto_in_3_c_valid,auto_in_2_c_valid,auto_in_1_c_valid}; // @[Cat.scala 30:58]
  reg [3:0] readys_mask_2; // @[Arbiter.scala 23:23]
  wire [3:0] _readys_filter_T_2 = ~readys_mask_2; // @[Arbiter.scala 24:30]
  wire [3:0] readys_filter_hi_2 = readys_filter_lo_2 & _readys_filter_T_2; // @[Arbiter.scala 24:28]
  wire [7:0] readys_filter_2 = {readys_filter_hi_2,auto_in_4_c_valid,auto_in_3_c_valid,auto_in_2_c_valid,
    auto_in_1_c_valid}; // @[Cat.scala 30:58]
  wire [7:0] _GEN_48 = {{1'd0}, readys_filter_2[7:1]}; // @[package.scala 253:43]
  wire [7:0] _readys_unready_T_19 = readys_filter_2 | _GEN_48; // @[package.scala 253:43]
  wire [7:0] _GEN_49 = {{2'd0}, _readys_unready_T_19[7:2]}; // @[package.scala 253:43]
  wire [7:0] _readys_unready_T_21 = _readys_unready_T_19 | _GEN_49; // @[package.scala 253:43]
  wire [7:0] _readys_unready_T_24 = {readys_mask_2, 4'h0}; // @[Arbiter.scala 25:66]
  wire [7:0] _GEN_50 = {{1'd0}, _readys_unready_T_21[7:1]}; // @[Arbiter.scala 25:58]
  wire [7:0] readys_unready_2 = _GEN_50 | _readys_unready_T_24; // @[Arbiter.scala 25:58]
  wire [3:0] _readys_readys_T_8 = readys_unready_2[7:4] & readys_unready_2[3:0]; // @[Arbiter.scala 26:39]
  wire [3:0] readys_readys_2 = ~_readys_readys_T_8; // @[Arbiter.scala 26:18]
  wire  readys_2_0 = readys_readys_2[0]; // @[Arbiter.scala 95:86]
  reg  state_2_0; // @[Arbiter.scala 116:26]
  wire  allowed_2_0 = idle_2 ? readys_2_0 : state_2_0; // @[Arbiter.scala 121:24]
  wire  readys_2_1 = readys_readys_2[1]; // @[Arbiter.scala 95:86]
  reg  state_2_1; // @[Arbiter.scala 116:26]
  wire  allowed_2_1 = idle_2 ? readys_2_1 : state_2_1; // @[Arbiter.scala 121:24]
  wire  readys_2_2 = readys_readys_2[2]; // @[Arbiter.scala 95:86]
  reg  state_2_2; // @[Arbiter.scala 116:26]
  wire  allowed_2_2 = idle_2 ? readys_2_2 : state_2_2; // @[Arbiter.scala 121:24]
  wire  readys_2_3 = readys_readys_2[3]; // @[Arbiter.scala 95:86]
  reg  state_2_3; // @[Arbiter.scala 116:26]
  wire  allowed_2_3 = idle_2 ? readys_2_3 : state_2_3; // @[Arbiter.scala 121:24]
  wire  allowed_5_0 = idle_5 ? readys_5_0 : state_5_0; // @[Arbiter.scala 121:24]
  wire  out_21_ready = auto_in_0_d_ready & allowed_5_0; // @[Arbiter.scala 123:31]
  wire  allowed_6_0 = idle_6 ? readys_6_0 : state_6_0; // @[Arbiter.scala 121:24]
  wire  out_27_ready = auto_in_1_d_ready & allowed_6_0; // @[Arbiter.scala 123:31]
  wire  allowed_7_0 = idle_7 ? readys_7_0 : state_7_0; // @[Arbiter.scala 121:24]
  wire  out_33_ready = auto_in_2_d_ready & allowed_7_0; // @[Arbiter.scala 123:31]
  wire  allowed_8_0 = idle_8 ? readys_8_0 : state_8_0; // @[Arbiter.scala 121:24]
  wire  out_39_ready = auto_in_3_d_ready & allowed_8_0; // @[Arbiter.scala 123:31]
  wire  allowed_9_0 = idle_9 ? readys_9_0 : state_9_0; // @[Arbiter.scala 121:24]
  wire  out_45_ready = auto_in_4_d_ready & allowed_9_0; // @[Arbiter.scala 123:31]
  wire  allowed_5_1 = idle_5 ? readys_5_1 : state_5_1; // @[Arbiter.scala 121:24]
  wire  out_22_ready = auto_in_0_d_ready & allowed_5_1; // @[Arbiter.scala 123:31]
  wire  allowed_6_1 = idle_6 ? readys_6_1 : state_6_1; // @[Arbiter.scala 121:24]
  wire  out_28_ready = auto_in_1_d_ready & allowed_6_1; // @[Arbiter.scala 123:31]
  wire  allowed_7_1 = idle_7 ? readys_7_1 : state_7_1; // @[Arbiter.scala 121:24]
  wire  out_34_ready = auto_in_2_d_ready & allowed_7_1; // @[Arbiter.scala 123:31]
  wire  allowed_8_1 = idle_8 ? readys_8_1 : state_8_1; // @[Arbiter.scala 121:24]
  wire  out_40_ready = auto_in_3_d_ready & allowed_8_1; // @[Arbiter.scala 123:31]
  wire  allowed_9_1 = idle_9 ? readys_9_1 : state_9_1; // @[Arbiter.scala 121:24]
  wire  out_46_ready = auto_in_4_d_ready & allowed_9_1; // @[Arbiter.scala 123:31]
  wire  allowed_5_2 = idle_5 ? readys_5_2 : state_5_2; // @[Arbiter.scala 121:24]
  wire  out_23_ready = auto_in_0_d_ready & allowed_5_2; // @[Arbiter.scala 123:31]
  wire  allowed_6_2 = idle_6 ? readys_6_2 : state_6_2; // @[Arbiter.scala 121:24]
  wire  out_29_ready = auto_in_1_d_ready & allowed_6_2; // @[Arbiter.scala 123:31]
  wire  allowed_7_2 = idle_7 ? readys_7_2 : state_7_2; // @[Arbiter.scala 121:24]
  wire  out_35_ready = auto_in_2_d_ready & allowed_7_2; // @[Arbiter.scala 123:31]
  wire  allowed_8_2 = idle_8 ? readys_8_2 : state_8_2; // @[Arbiter.scala 121:24]
  wire  out_41_ready = auto_in_3_d_ready & allowed_8_2; // @[Arbiter.scala 123:31]
  wire  allowed_9_2 = idle_9 ? readys_9_2 : state_9_2; // @[Arbiter.scala 121:24]
  wire  out_47_ready = auto_in_4_d_ready & allowed_9_2; // @[Arbiter.scala 123:31]
  wire  latch = idle & auto_out_0_a_ready; // @[Arbiter.scala 89:24]
  wire [4:0] _readys_mask_T = readys_readys & readys_filter_lo; // @[Arbiter.scala 28:29]
  wire [5:0] _readys_mask_T_1 = {_readys_mask_T, 1'h0}; // @[package.scala 244:48]
  wire [4:0] _readys_mask_T_3 = _readys_mask_T | _readys_mask_T_1[4:0]; // @[package.scala 244:43]
  wire [6:0] _readys_mask_T_4 = {_readys_mask_T_3, 2'h0}; // @[package.scala 244:48]
  wire [4:0] _readys_mask_T_6 = _readys_mask_T_3 | _readys_mask_T_4[4:0]; // @[package.scala 244:43]
  wire [8:0] _readys_mask_T_7 = {_readys_mask_T_6, 4'h0}; // @[package.scala 244:48]
  wire [4:0] _readys_mask_T_9 = _readys_mask_T_6 | _readys_mask_T_7[4:0]; // @[package.scala 244:43]
  wire  earlyWinner__0 = readys__0 & portsAOI_filtered__0_earlyValid; // @[Arbiter.scala 97:79]
  wire  earlyWinner__1 = readys__1 & portsAOI_filtered_1_0_earlyValid; // @[Arbiter.scala 97:79]
  wire  earlyWinner__2 = readys__2 & portsAOI_filtered_2_0_earlyValid; // @[Arbiter.scala 97:79]
  wire  earlyWinner__3 = readys__3 & portsAOI_filtered_3_0_earlyValid; // @[Arbiter.scala 97:79]
  wire  earlyWinner__4 = readys__4 & portsAOI_filtered_4_0_earlyValid; // @[Arbiter.scala 97:79]
  wire  prefixOR_2 = earlyWinner__0 | earlyWinner__1; // @[Arbiter.scala 104:53]
  wire  prefixOR_3 = prefixOR_2 | earlyWinner__2; // @[Arbiter.scala 104:53]
  wire  prefixOR_4 = prefixOR_3 | earlyWinner__3; // @[Arbiter.scala 104:53]
  wire  _prefixOR_T = prefixOR_4 | earlyWinner__4; // @[Arbiter.scala 104:53]
  wire  _T_26 = portsAOI_filtered__0_earlyValid | portsAOI_filtered_1_0_earlyValid | portsAOI_filtered_2_0_earlyValid |
    portsAOI_filtered_3_0_earlyValid | portsAOI_filtered_4_0_earlyValid; // @[Arbiter.scala 107:36]
  wire  _T_27 = ~(portsAOI_filtered__0_earlyValid | portsAOI_filtered_1_0_earlyValid | portsAOI_filtered_2_0_earlyValid
     | portsAOI_filtered_3_0_earlyValid | portsAOI_filtered_4_0_earlyValid); // @[Arbiter.scala 107:15]
  wire [8:0] maskedBeats_0 = earlyWinner__0 ? beatsAI_0 : 9'h0; // @[Arbiter.scala 111:73]
  wire [8:0] maskedBeats_1 = earlyWinner__1 ? beatsAI_1 : 9'h0; // @[Arbiter.scala 111:73]
  wire [8:0] maskedBeats_2 = earlyWinner__2 ? beatsAI_2 : 9'h0; // @[Arbiter.scala 111:73]
  wire [8:0] maskedBeats_3 = earlyWinner__3 ? beatsAI_3 : 9'h0; // @[Arbiter.scala 111:73]
  wire [8:0] maskedBeats_4 = earlyWinner__4 ? beatsAI_4 : 9'h0; // @[Arbiter.scala 111:73]
  wire [8:0] _initBeats_T = maskedBeats_0 | maskedBeats_1; // @[Arbiter.scala 112:44]
  wire [8:0] _initBeats_T_1 = _initBeats_T | maskedBeats_2; // @[Arbiter.scala 112:44]
  wire [8:0] _initBeats_T_2 = _initBeats_T_1 | maskedBeats_3; // @[Arbiter.scala 112:44]
  wire [8:0] initBeats = _initBeats_T_2 | maskedBeats_4; // @[Arbiter.scala 112:44]
  wire  muxStateEarly__0 = idle ? earlyWinner__0 : state__0; // @[Arbiter.scala 117:30]
  wire  muxStateEarly__1 = idle ? earlyWinner__1 : state__1; // @[Arbiter.scala 117:30]
  wire  muxStateEarly__2 = idle ? earlyWinner__2 : state__2; // @[Arbiter.scala 117:30]
  wire  muxStateEarly__3 = idle ? earlyWinner__3 : state__3; // @[Arbiter.scala 117:30]
  wire  muxStateEarly__4 = idle ? earlyWinner__4 : state__4; // @[Arbiter.scala 117:30]
  wire  _out_0_a_earlyValid_T_12 = state__0 & portsAOI_filtered__0_earlyValid | state__1 &
    portsAOI_filtered_1_0_earlyValid | state__2 & portsAOI_filtered_2_0_earlyValid | state__3 &
    portsAOI_filtered_3_0_earlyValid | state__4 & portsAOI_filtered_4_0_earlyValid; // @[Mux.scala 27:72]
  wire  out_5_0_a_earlyValid = idle ? _T_26 : _out_0_a_earlyValid_T_12; // @[Arbiter.scala 125:29]
  wire  _beatsLeft_T_2 = auto_out_0_a_ready & out_5_0_a_earlyValid; // @[ReadyValidCancel.scala 50:33]
  wire [8:0] _GEN_51 = {{8'd0}, _beatsLeft_T_2}; // @[Arbiter.scala 113:52]
  wire [8:0] _beatsLeft_T_4 = beatsLeft - _GEN_51; // @[Arbiter.scala 113:52]
  wire [63:0] _T_58 = muxStateEarly__0 ? auto_in_0_a_bits_data : 64'h0; // @[Mux.scala 27:72]
  wire [63:0] _T_59 = muxStateEarly__1 ? auto_in_1_a_bits_data : 64'h0; // @[Mux.scala 27:72]
  wire [63:0] _T_60 = muxStateEarly__2 ? auto_in_2_a_bits_data : 64'h0; // @[Mux.scala 27:72]
  wire [63:0] _T_61 = muxStateEarly__3 ? auto_in_3_a_bits_data : 64'h0; // @[Mux.scala 27:72]
  wire [63:0] _T_62 = muxStateEarly__4 ? auto_in_4_a_bits_data : 64'h0; // @[Mux.scala 27:72]
  wire [63:0] _T_63 = _T_58 | _T_59; // @[Mux.scala 27:72]
  wire [63:0] _T_64 = _T_63 | _T_60; // @[Mux.scala 27:72]
  wire [63:0] _T_65 = _T_64 | _T_61; // @[Mux.scala 27:72]
  wire [7:0] _T_67 = muxStateEarly__0 ? auto_in_0_a_bits_mask : 8'h0; // @[Mux.scala 27:72]
  wire [7:0] _T_68 = muxStateEarly__1 ? auto_in_1_a_bits_mask : 8'h0; // @[Mux.scala 27:72]
  wire [7:0] _T_69 = muxStateEarly__2 ? auto_in_2_a_bits_mask : 8'h0; // @[Mux.scala 27:72]
  wire [7:0] _T_70 = muxStateEarly__3 ? auto_in_3_a_bits_mask : 8'h0; // @[Mux.scala 27:72]
  wire [7:0] _T_71 = muxStateEarly__4 ? auto_in_4_a_bits_mask : 8'h0; // @[Mux.scala 27:72]
  wire [7:0] _T_72 = _T_67 | _T_68; // @[Mux.scala 27:72]
  wire [7:0] _T_73 = _T_72 | _T_69; // @[Mux.scala 27:72]
  wire [7:0] _T_74 = _T_73 | _T_70; // @[Mux.scala 27:72]
  wire [31:0] _T_139 = muxStateEarly__0 ? auto_in_0_a_bits_address : 32'h0; // @[Mux.scala 27:72]
  wire [31:0] _T_140 = muxStateEarly__1 ? auto_in_1_a_bits_address : 32'h0; // @[Mux.scala 27:72]
  wire [31:0] _T_141 = muxStateEarly__2 ? auto_in_2_a_bits_address : 32'h0; // @[Mux.scala 27:72]
  wire [31:0] _T_142 = muxStateEarly__3 ? auto_in_3_a_bits_address : 32'h0; // @[Mux.scala 27:72]
  wire [31:0] _T_143 = muxStateEarly__4 ? auto_in_4_a_bits_address : 32'h0; // @[Mux.scala 27:72]
  wire [31:0] _T_144 = _T_139 | _T_140; // @[Mux.scala 27:72]
  wire [31:0] _T_145 = _T_144 | _T_141; // @[Mux.scala 27:72]
  wire [31:0] _T_146 = _T_145 | _T_142; // @[Mux.scala 27:72]
  wire [31:0] out_5_0_a_bits_address = _T_146 | _T_143; // @[Mux.scala 27:72]
  wire [4:0] in_0_a_bits_source = {{1'd0}, auto_in_0_a_bits_source}; // @[Xbar.scala 231:18 Xbar.scala 237:29]
  wire [4:0] _T_148 = muxStateEarly__0 ? in_0_a_bits_source : 5'h0; // @[Mux.scala 27:72]
  wire [4:0] _T_149 = muxStateEarly__1 ? in_1_a_bits_source : 5'h0; // @[Mux.scala 27:72]
  wire [4:0] _T_150 = muxStateEarly__2 ? in_2_a_bits_source : 5'h0; // @[Mux.scala 27:72]
  wire [4:0] _T_151 = muxStateEarly__3 ? in_3_a_bits_source : 5'h0; // @[Mux.scala 27:72]
  wire [4:0] _T_152 = muxStateEarly__4 ? in_4_a_bits_source : 5'h0; // @[Mux.scala 27:72]
  wire [4:0] _T_153 = _T_148 | _T_149; // @[Mux.scala 27:72]
  wire [4:0] _T_154 = _T_153 | _T_150; // @[Mux.scala 27:72]
  wire [4:0] _T_155 = _T_154 | _T_151; // @[Mux.scala 27:72]
  wire [3:0] _T_157 = muxStateEarly__0 ? auto_in_0_a_bits_size : 4'h0; // @[Mux.scala 27:72]
  wire [3:0] _T_158 = muxStateEarly__1 ? auto_in_1_a_bits_size : 4'h0; // @[Mux.scala 27:72]
  wire [3:0] _T_159 = muxStateEarly__2 ? auto_in_2_a_bits_size : 4'h0; // @[Mux.scala 27:72]
  wire [3:0] _T_160 = muxStateEarly__3 ? auto_in_3_a_bits_size : 4'h0; // @[Mux.scala 27:72]
  wire [3:0] _T_161 = muxStateEarly__4 ? auto_in_4_a_bits_size : 4'h0; // @[Mux.scala 27:72]
  wire [3:0] _T_162 = _T_157 | _T_158; // @[Mux.scala 27:72]
  wire [3:0] _T_163 = _T_162 | _T_159; // @[Mux.scala 27:72]
  wire [3:0] _T_164 = _T_163 | _T_160; // @[Mux.scala 27:72]
  wire [2:0] _T_166 = muxStateEarly__0 ? auto_in_0_a_bits_param : 3'h0; // @[Mux.scala 27:72]
  wire [2:0] _T_167 = muxStateEarly__1 ? auto_in_1_a_bits_param : 3'h0; // @[Mux.scala 27:72]
  wire [2:0] _T_168 = muxStateEarly__2 ? auto_in_2_a_bits_param : 3'h0; // @[Mux.scala 27:72]
  wire [2:0] _T_169 = muxStateEarly__3 ? auto_in_3_a_bits_param : 3'h0; // @[Mux.scala 27:72]
  wire [2:0] _T_170 = muxStateEarly__4 ? auto_in_4_a_bits_param : 3'h0; // @[Mux.scala 27:72]
  wire [2:0] _T_171 = _T_166 | _T_167; // @[Mux.scala 27:72]
  wire [2:0] _T_172 = _T_171 | _T_168; // @[Mux.scala 27:72]
  wire [2:0] _T_173 = _T_172 | _T_169; // @[Mux.scala 27:72]
  wire [2:0] _T_175 = muxStateEarly__0 ? auto_in_0_a_bits_opcode : 3'h0; // @[Mux.scala 27:72]
  wire [2:0] _T_176 = muxStateEarly__1 ? auto_in_1_a_bits_opcode : 3'h0; // @[Mux.scala 27:72]
  wire [2:0] _T_177 = muxStateEarly__2 ? auto_in_2_a_bits_opcode : 3'h0; // @[Mux.scala 27:72]
  wire [2:0] _T_178 = muxStateEarly__3 ? auto_in_3_a_bits_opcode : 3'h0; // @[Mux.scala 27:72]
  wire [2:0] _T_179 = muxStateEarly__4 ? auto_in_4_a_bits_opcode : 3'h0; // @[Mux.scala 27:72]
  wire [2:0] _T_180 = _T_175 | _T_176; // @[Mux.scala 27:72]
  wire [2:0] _T_181 = _T_180 | _T_177; // @[Mux.scala 27:72]
  wire [2:0] _T_182 = _T_181 | _T_178; // @[Mux.scala 27:72]
  wire  latch_1 = idle_1 & auto_out_1_a_ready; // @[Arbiter.scala 89:24]
  wire [4:0] _readys_mask_T_11 = readys_readys_1 & readys_filter_lo_1; // @[Arbiter.scala 28:29]
  wire [5:0] _readys_mask_T_12 = {_readys_mask_T_11, 1'h0}; // @[package.scala 244:48]
  wire [4:0] _readys_mask_T_14 = _readys_mask_T_11 | _readys_mask_T_12[4:0]; // @[package.scala 244:43]
  wire [6:0] _readys_mask_T_15 = {_readys_mask_T_14, 2'h0}; // @[package.scala 244:48]
  wire [4:0] _readys_mask_T_17 = _readys_mask_T_14 | _readys_mask_T_15[4:0]; // @[package.scala 244:43]
  wire [8:0] _readys_mask_T_18 = {_readys_mask_T_17, 4'h0}; // @[package.scala 244:48]
  wire [4:0] _readys_mask_T_20 = _readys_mask_T_17 | _readys_mask_T_18[4:0]; // @[package.scala 244:43]
  wire  earlyWinner_1_0 = readys_1_0 & portsAOI_filtered__1_earlyValid; // @[Arbiter.scala 97:79]
  wire  earlyWinner_1_1 = readys_1_1 & portsAOI_filtered_1_1_earlyValid; // @[Arbiter.scala 97:79]
  wire  earlyWinner_1_2 = readys_1_2 & portsAOI_filtered_2_1_earlyValid; // @[Arbiter.scala 97:79]
  wire  earlyWinner_1_3 = readys_1_3 & portsAOI_filtered_3_1_earlyValid; // @[Arbiter.scala 97:79]
  wire  earlyWinner_1_4 = readys_1_4 & portsAOI_filtered_4_1_earlyValid; // @[Arbiter.scala 97:79]
  wire  prefixOR_2_1 = earlyWinner_1_0 | earlyWinner_1_1; // @[Arbiter.scala 104:53]
  wire  prefixOR_3_1 = prefixOR_2_1 | earlyWinner_1_2; // @[Arbiter.scala 104:53]
  wire  prefixOR_4_1 = prefixOR_3_1 | earlyWinner_1_3; // @[Arbiter.scala 104:53]
  wire  _prefixOR_T_1 = prefixOR_4_1 | earlyWinner_1_4; // @[Arbiter.scala 104:53]
  wire  _T_209 = portsAOI_filtered__1_earlyValid | portsAOI_filtered_1_1_earlyValid | portsAOI_filtered_2_1_earlyValid
     | portsAOI_filtered_3_1_earlyValid | portsAOI_filtered_4_1_earlyValid; // @[Arbiter.scala 107:36]
  wire  _T_210 = ~(portsAOI_filtered__1_earlyValid | portsAOI_filtered_1_1_earlyValid | portsAOI_filtered_2_1_earlyValid
     | portsAOI_filtered_3_1_earlyValid | portsAOI_filtered_4_1_earlyValid); // @[Arbiter.scala 107:15]
  wire [8:0] maskedBeats_0_1 = earlyWinner_1_0 ? beatsAI_0 : 9'h0; // @[Arbiter.scala 111:73]
  wire [8:0] maskedBeats_1_1 = earlyWinner_1_1 ? beatsAI_1 : 9'h0; // @[Arbiter.scala 111:73]
  wire [8:0] maskedBeats_2_1 = earlyWinner_1_2 ? beatsAI_2 : 9'h0; // @[Arbiter.scala 111:73]
  wire [8:0] maskedBeats_3_1 = earlyWinner_1_3 ? beatsAI_3 : 9'h0; // @[Arbiter.scala 111:73]
  wire [8:0] maskedBeats_4_1 = earlyWinner_1_4 ? beatsAI_4 : 9'h0; // @[Arbiter.scala 111:73]
  wire [8:0] _initBeats_T_3 = maskedBeats_0_1 | maskedBeats_1_1; // @[Arbiter.scala 112:44]
  wire [8:0] _initBeats_T_4 = _initBeats_T_3 | maskedBeats_2_1; // @[Arbiter.scala 112:44]
  wire [8:0] _initBeats_T_5 = _initBeats_T_4 | maskedBeats_3_1; // @[Arbiter.scala 112:44]
  wire [8:0] initBeats_1 = _initBeats_T_5 | maskedBeats_4_1; // @[Arbiter.scala 112:44]
  wire  muxStateEarly_1_0 = idle_1 ? earlyWinner_1_0 : state_1_0; // @[Arbiter.scala 117:30]
  wire  muxStateEarly_1_1 = idle_1 ? earlyWinner_1_1 : state_1_1; // @[Arbiter.scala 117:30]
  wire  muxStateEarly_1_2 = idle_1 ? earlyWinner_1_2 : state_1_2; // @[Arbiter.scala 117:30]
  wire  muxStateEarly_1_3 = idle_1 ? earlyWinner_1_3 : state_1_3; // @[Arbiter.scala 117:30]
  wire  muxStateEarly_1_4 = idle_1 ? earlyWinner_1_4 : state_1_4; // @[Arbiter.scala 117:30]
  wire  _out_1_a_earlyValid_T_12 = state_1_0 & portsAOI_filtered__1_earlyValid | state_1_1 &
    portsAOI_filtered_1_1_earlyValid | state_1_2 & portsAOI_filtered_2_1_earlyValid | state_1_3 &
    portsAOI_filtered_3_1_earlyValid | state_1_4 & portsAOI_filtered_4_1_earlyValid; // @[Mux.scala 27:72]
  wire  out_5_1_a_earlyValid = idle_1 ? _T_209 : _out_1_a_earlyValid_T_12; // @[Arbiter.scala 125:29]
  wire  _beatsLeft_T_8 = auto_out_1_a_ready & out_5_1_a_earlyValid; // @[ReadyValidCancel.scala 50:33]
  wire [8:0] _GEN_52 = {{8'd0}, _beatsLeft_T_8}; // @[Arbiter.scala 113:52]
  wire [8:0] _beatsLeft_T_10 = beatsLeft_1 - _GEN_52; // @[Arbiter.scala 113:52]
  wire [63:0] _T_241 = muxStateEarly_1_0 ? auto_in_0_a_bits_data : 64'h0; // @[Mux.scala 27:72]
  wire [63:0] _T_242 = muxStateEarly_1_1 ? auto_in_1_a_bits_data : 64'h0; // @[Mux.scala 27:72]
  wire [63:0] _T_243 = muxStateEarly_1_2 ? auto_in_2_a_bits_data : 64'h0; // @[Mux.scala 27:72]
  wire [63:0] _T_244 = muxStateEarly_1_3 ? auto_in_3_a_bits_data : 64'h0; // @[Mux.scala 27:72]
  wire [63:0] _T_245 = muxStateEarly_1_4 ? auto_in_4_a_bits_data : 64'h0; // @[Mux.scala 27:72]
  wire [63:0] _T_246 = _T_241 | _T_242; // @[Mux.scala 27:72]
  wire [63:0] _T_247 = _T_246 | _T_243; // @[Mux.scala 27:72]
  wire [63:0] _T_248 = _T_247 | _T_244; // @[Mux.scala 27:72]
  wire [7:0] _T_250 = muxStateEarly_1_0 ? auto_in_0_a_bits_mask : 8'h0; // @[Mux.scala 27:72]
  wire [7:0] _T_251 = muxStateEarly_1_1 ? auto_in_1_a_bits_mask : 8'h0; // @[Mux.scala 27:72]
  wire [7:0] _T_252 = muxStateEarly_1_2 ? auto_in_2_a_bits_mask : 8'h0; // @[Mux.scala 27:72]
  wire [7:0] _T_253 = muxStateEarly_1_3 ? auto_in_3_a_bits_mask : 8'h0; // @[Mux.scala 27:72]
  wire [7:0] _T_254 = muxStateEarly_1_4 ? auto_in_4_a_bits_mask : 8'h0; // @[Mux.scala 27:72]
  wire [7:0] _T_255 = _T_250 | _T_251; // @[Mux.scala 27:72]
  wire [7:0] _T_256 = _T_255 | _T_252; // @[Mux.scala 27:72]
  wire [7:0] _T_257 = _T_256 | _T_253; // @[Mux.scala 27:72]
  wire [31:0] _T_322 = muxStateEarly_1_0 ? auto_in_0_a_bits_address : 32'h0; // @[Mux.scala 27:72]
  wire [31:0] _T_323 = muxStateEarly_1_1 ? auto_in_1_a_bits_address : 32'h0; // @[Mux.scala 27:72]
  wire [31:0] _T_324 = muxStateEarly_1_2 ? auto_in_2_a_bits_address : 32'h0; // @[Mux.scala 27:72]
  wire [31:0] _T_325 = muxStateEarly_1_3 ? auto_in_3_a_bits_address : 32'h0; // @[Mux.scala 27:72]
  wire [31:0] _T_326 = muxStateEarly_1_4 ? auto_in_4_a_bits_address : 32'h0; // @[Mux.scala 27:72]
  wire [31:0] _T_327 = _T_322 | _T_323; // @[Mux.scala 27:72]
  wire [31:0] _T_328 = _T_327 | _T_324; // @[Mux.scala 27:72]
  wire [31:0] _T_329 = _T_328 | _T_325; // @[Mux.scala 27:72]
  wire [4:0] _T_331 = muxStateEarly_1_0 ? in_0_a_bits_source : 5'h0; // @[Mux.scala 27:72]
  wire [4:0] _T_332 = muxStateEarly_1_1 ? in_1_a_bits_source : 5'h0; // @[Mux.scala 27:72]
  wire [4:0] _T_333 = muxStateEarly_1_2 ? in_2_a_bits_source : 5'h0; // @[Mux.scala 27:72]
  wire [4:0] _T_334 = muxStateEarly_1_3 ? in_3_a_bits_source : 5'h0; // @[Mux.scala 27:72]
  wire [4:0] _T_335 = muxStateEarly_1_4 ? in_4_a_bits_source : 5'h0; // @[Mux.scala 27:72]
  wire [4:0] _T_336 = _T_331 | _T_332; // @[Mux.scala 27:72]
  wire [4:0] _T_337 = _T_336 | _T_333; // @[Mux.scala 27:72]
  wire [4:0] _T_338 = _T_337 | _T_334; // @[Mux.scala 27:72]
  wire [3:0] _T_340 = muxStateEarly_1_0 ? auto_in_0_a_bits_size : 4'h0; // @[Mux.scala 27:72]
  wire [3:0] _T_341 = muxStateEarly_1_1 ? auto_in_1_a_bits_size : 4'h0; // @[Mux.scala 27:72]
  wire [3:0] _T_342 = muxStateEarly_1_2 ? auto_in_2_a_bits_size : 4'h0; // @[Mux.scala 27:72]
  wire [3:0] _T_343 = muxStateEarly_1_3 ? auto_in_3_a_bits_size : 4'h0; // @[Mux.scala 27:72]
  wire [3:0] _T_344 = muxStateEarly_1_4 ? auto_in_4_a_bits_size : 4'h0; // @[Mux.scala 27:72]
  wire [3:0] _T_345 = _T_340 | _T_341; // @[Mux.scala 27:72]
  wire [3:0] _T_346 = _T_345 | _T_342; // @[Mux.scala 27:72]
  wire [3:0] _T_347 = _T_346 | _T_343; // @[Mux.scala 27:72]
  wire [3:0] out_5_1_a_bits_size = _T_347 | _T_344; // @[Mux.scala 27:72]
  wire [2:0] _T_349 = muxStateEarly_1_0 ? auto_in_0_a_bits_param : 3'h0; // @[Mux.scala 27:72]
  wire [2:0] _T_350 = muxStateEarly_1_1 ? auto_in_1_a_bits_param : 3'h0; // @[Mux.scala 27:72]
  wire [2:0] _T_351 = muxStateEarly_1_2 ? auto_in_2_a_bits_param : 3'h0; // @[Mux.scala 27:72]
  wire [2:0] _T_352 = muxStateEarly_1_3 ? auto_in_3_a_bits_param : 3'h0; // @[Mux.scala 27:72]
  wire [2:0] _T_353 = muxStateEarly_1_4 ? auto_in_4_a_bits_param : 3'h0; // @[Mux.scala 27:72]
  wire [2:0] _T_354 = _T_349 | _T_350; // @[Mux.scala 27:72]
  wire [2:0] _T_355 = _T_354 | _T_351; // @[Mux.scala 27:72]
  wire [2:0] _T_356 = _T_355 | _T_352; // @[Mux.scala 27:72]
  wire [2:0] _T_358 = muxStateEarly_1_0 ? auto_in_0_a_bits_opcode : 3'h0; // @[Mux.scala 27:72]
  wire [2:0] _T_359 = muxStateEarly_1_1 ? auto_in_1_a_bits_opcode : 3'h0; // @[Mux.scala 27:72]
  wire [2:0] _T_360 = muxStateEarly_1_2 ? auto_in_2_a_bits_opcode : 3'h0; // @[Mux.scala 27:72]
  wire [2:0] _T_361 = muxStateEarly_1_3 ? auto_in_3_a_bits_opcode : 3'h0; // @[Mux.scala 27:72]
  wire [2:0] _T_362 = muxStateEarly_1_4 ? auto_in_4_a_bits_opcode : 3'h0; // @[Mux.scala 27:72]
  wire [2:0] _T_363 = _T_358 | _T_359; // @[Mux.scala 27:72]
  wire [2:0] _T_364 = _T_363 | _T_360; // @[Mux.scala 27:72]
  wire [2:0] _T_365 = _T_364 | _T_361; // @[Mux.scala 27:72]
  wire  latch_2 = idle_2 & auto_out_1_c_ready; // @[Arbiter.scala 89:24]
  wire [3:0] _readys_mask_T_22 = readys_readys_2 & readys_filter_lo_2; // @[Arbiter.scala 28:29]
  wire [4:0] _readys_mask_T_23 = {_readys_mask_T_22, 1'h0}; // @[package.scala 244:48]
  wire [3:0] _readys_mask_T_25 = _readys_mask_T_22 | _readys_mask_T_23[3:0]; // @[package.scala 244:43]
  wire [5:0] _readys_mask_T_26 = {_readys_mask_T_25, 2'h0}; // @[package.scala 244:48]
  wire [3:0] _readys_mask_T_28 = _readys_mask_T_25 | _readys_mask_T_26[3:0]; // @[package.scala 244:43]
  wire  earlyWinner_2_0 = readys_2_0 & auto_in_1_c_valid; // @[Arbiter.scala 97:79]
  wire  earlyWinner_2_1 = readys_2_1 & auto_in_2_c_valid; // @[Arbiter.scala 97:79]
  wire  earlyWinner_2_2 = readys_2_2 & auto_in_3_c_valid; // @[Arbiter.scala 97:79]
  wire  earlyWinner_2_3 = readys_2_3 & auto_in_4_c_valid; // @[Arbiter.scala 97:79]
  wire  prefixOR_2_2 = earlyWinner_2_0 | earlyWinner_2_1; // @[Arbiter.scala 104:53]
  wire  prefixOR_3_2 = prefixOR_2_2 | earlyWinner_2_2; // @[Arbiter.scala 104:53]
  wire  _prefixOR_T_2 = prefixOR_3_2 | earlyWinner_2_3; // @[Arbiter.scala 104:53]
  wire  _T_387 = auto_in_1_c_valid | auto_in_2_c_valid | auto_in_3_c_valid | auto_in_4_c_valid; // @[Arbiter.scala 107:36]
  wire  _T_388 = ~(auto_in_1_c_valid | auto_in_2_c_valid | auto_in_3_c_valid | auto_in_4_c_valid); // @[Arbiter.scala 107:15]
  wire [8:0] maskedBeats_0_2 = earlyWinner_2_0 ? beatsCI_1 : 9'h0; // @[Arbiter.scala 111:73]
  wire [8:0] maskedBeats_1_2 = earlyWinner_2_1 ? beatsCI_2 : 9'h0; // @[Arbiter.scala 111:73]
  wire [8:0] maskedBeats_2_2 = earlyWinner_2_2 ? beatsCI_3 : 9'h0; // @[Arbiter.scala 111:73]
  wire [8:0] maskedBeats_3_2 = earlyWinner_2_3 ? beatsCI_4 : 9'h0; // @[Arbiter.scala 111:73]
  wire [8:0] _initBeats_T_6 = maskedBeats_0_2 | maskedBeats_1_2; // @[Arbiter.scala 112:44]
  wire [8:0] _initBeats_T_7 = _initBeats_T_6 | maskedBeats_2_2; // @[Arbiter.scala 112:44]
  wire [8:0] initBeats_2 = _initBeats_T_7 | maskedBeats_3_2; // @[Arbiter.scala 112:44]
  wire  muxStateEarly_2_0 = idle_2 ? earlyWinner_2_0 : state_2_0; // @[Arbiter.scala 117:30]
  wire  muxStateEarly_2_1 = idle_2 ? earlyWinner_2_1 : state_2_1; // @[Arbiter.scala 117:30]
  wire  muxStateEarly_2_2 = idle_2 ? earlyWinner_2_2 : state_2_2; // @[Arbiter.scala 117:30]
  wire  muxStateEarly_2_3 = idle_2 ? earlyWinner_2_3 : state_2_3; // @[Arbiter.scala 117:30]
  wire  _sink_ACancel_earlyValid_T_9 = state_2_0 & auto_in_1_c_valid | state_2_1 & auto_in_2_c_valid | state_2_2 &
    auto_in_3_c_valid | state_2_3 & auto_in_4_c_valid; // @[Mux.scala 27:72]
  wire  sink_ACancel_2_earlyValid = idle_2 ? _T_387 : _sink_ACancel_earlyValid_T_9; // @[Arbiter.scala 125:29]
  wire  _beatsLeft_T_14 = auto_out_1_c_ready & sink_ACancel_2_earlyValid; // @[ReadyValidCancel.scala 50:33]
  wire [8:0] _GEN_53 = {{8'd0}, _beatsLeft_T_14}; // @[Arbiter.scala 113:52]
  wire [8:0] _beatsLeft_T_16 = beatsLeft_2 - _GEN_53; // @[Arbiter.scala 113:52]
  wire [63:0] _T_414 = muxStateEarly_2_0 ? auto_in_1_c_bits_data : 64'h0; // @[Mux.scala 27:72]
  wire [63:0] _T_415 = muxStateEarly_2_1 ? auto_in_2_c_bits_data : 64'h0; // @[Mux.scala 27:72]
  wire [63:0] _T_416 = muxStateEarly_2_2 ? auto_in_3_c_bits_data : 64'h0; // @[Mux.scala 27:72]
  wire [63:0] _T_417 = muxStateEarly_2_3 ? auto_in_4_c_bits_data : 64'h0; // @[Mux.scala 27:72]
  wire [63:0] _T_418 = _T_414 | _T_415; // @[Mux.scala 27:72]
  wire [63:0] _T_419 = _T_418 | _T_416; // @[Mux.scala 27:72]
  wire [31:0] _T_470 = muxStateEarly_2_0 ? auto_in_1_c_bits_address : 32'h0; // @[Mux.scala 27:72]
  wire [31:0] _T_471 = muxStateEarly_2_1 ? auto_in_2_c_bits_address : 32'h0; // @[Mux.scala 27:72]
  wire [31:0] _T_472 = muxStateEarly_2_2 ? auto_in_3_c_bits_address : 32'h0; // @[Mux.scala 27:72]
  wire [31:0] _T_473 = muxStateEarly_2_3 ? auto_in_4_c_bits_address : 32'h0; // @[Mux.scala 27:72]
  wire [31:0] _T_474 = _T_470 | _T_471; // @[Mux.scala 27:72]
  wire [31:0] _T_475 = _T_474 | _T_472; // @[Mux.scala 27:72]
  wire [4:0] _T_477 = muxStateEarly_2_0 ? in_1_c_bits_source : 5'h0; // @[Mux.scala 27:72]
  wire [4:0] _T_478 = muxStateEarly_2_1 ? in_2_c_bits_source : 5'h0; // @[Mux.scala 27:72]
  wire [4:0] _T_479 = muxStateEarly_2_2 ? in_3_c_bits_source : 5'h0; // @[Mux.scala 27:72]
  wire [4:0] _T_480 = muxStateEarly_2_3 ? in_4_c_bits_source : 5'h0; // @[Mux.scala 27:72]
  wire [4:0] _T_481 = _T_477 | _T_478; // @[Mux.scala 27:72]
  wire [4:0] _T_482 = _T_481 | _T_479; // @[Mux.scala 27:72]
  wire [3:0] _T_484 = muxStateEarly_2_0 ? auto_in_1_c_bits_size : 4'h0; // @[Mux.scala 27:72]
  wire [3:0] _T_485 = muxStateEarly_2_1 ? auto_in_2_c_bits_size : 4'h0; // @[Mux.scala 27:72]
  wire [3:0] _T_486 = muxStateEarly_2_2 ? auto_in_3_c_bits_size : 4'h0; // @[Mux.scala 27:72]
  wire [3:0] _T_487 = muxStateEarly_2_3 ? auto_in_4_c_bits_size : 4'h0; // @[Mux.scala 27:72]
  wire [3:0] _T_488 = _T_484 | _T_485; // @[Mux.scala 27:72]
  wire [3:0] _T_489 = _T_488 | _T_486; // @[Mux.scala 27:72]
  wire [3:0] sink_ACancel_2_bits_size = _T_489 | _T_487; // @[Mux.scala 27:72]
  wire [2:0] _T_491 = muxStateEarly_2_0 ? auto_in_1_c_bits_param : 3'h0; // @[Mux.scala 27:72]
  wire [2:0] _T_492 = muxStateEarly_2_1 ? auto_in_2_c_bits_param : 3'h0; // @[Mux.scala 27:72]
  wire [2:0] _T_493 = muxStateEarly_2_2 ? auto_in_3_c_bits_param : 3'h0; // @[Mux.scala 27:72]
  wire [2:0] _T_494 = muxStateEarly_2_3 ? auto_in_4_c_bits_param : 3'h0; // @[Mux.scala 27:72]
  wire [2:0] _T_495 = _T_491 | _T_492; // @[Mux.scala 27:72]
  wire [2:0] _T_496 = _T_495 | _T_493; // @[Mux.scala 27:72]
  wire [2:0] _T_498 = muxStateEarly_2_0 ? auto_in_1_c_bits_opcode : 3'h0; // @[Mux.scala 27:72]
  wire [2:0] _T_499 = muxStateEarly_2_1 ? auto_in_2_c_bits_opcode : 3'h0; // @[Mux.scala 27:72]
  wire [2:0] _T_500 = muxStateEarly_2_2 ? auto_in_3_c_bits_opcode : 3'h0; // @[Mux.scala 27:72]
  wire [2:0] _T_501 = muxStateEarly_2_3 ? auto_in_4_c_bits_opcode : 3'h0; // @[Mux.scala 27:72]
  wire [2:0] _T_502 = _T_498 | _T_499; // @[Mux.scala 27:72]
  wire [2:0] _T_503 = _T_502 | _T_500; // @[Mux.scala 27:72]
  wire [3:0] _readys_mask_T_30 = readys_readys_3 & readys_filter_lo_3; // @[Arbiter.scala 28:29]
  wire [4:0] _readys_mask_T_31 = {_readys_mask_T_30, 1'h0}; // @[package.scala 244:48]
  wire [3:0] _readys_mask_T_33 = _readys_mask_T_30 | _readys_mask_T_31[3:0]; // @[package.scala 244:43]
  wire [5:0] _readys_mask_T_34 = {_readys_mask_T_33, 2'h0}; // @[package.scala 244:48]
  wire [3:0] _readys_mask_T_36 = _readys_mask_T_33 | _readys_mask_T_34[3:0]; // @[package.scala 244:43]
  wire  prefixOR_2_3 = earlyWinner_3_0 | earlyWinner_3_1; // @[Arbiter.scala 104:53]
  wire  prefixOR_3_3 = prefixOR_2_3 | earlyWinner_3_2; // @[Arbiter.scala 104:53]
  wire  _prefixOR_T_3 = prefixOR_3_3 | earlyWinner_3_3; // @[Arbiter.scala 104:53]
  wire  _T_525 = auto_in_1_e_valid | auto_in_2_e_valid | auto_in_3_e_valid | auto_in_4_e_valid; // @[Arbiter.scala 107:36]
  wire  _T_526 = ~(auto_in_1_e_valid | auto_in_2_e_valid | auto_in_3_e_valid | auto_in_4_e_valid); // @[Arbiter.scala 107:15]
  wire  _sink_ACancel_earlyValid_T_20 = state_3_0 & auto_in_1_e_valid | state_3_1 & auto_in_2_e_valid | state_3_2 &
    auto_in_3_e_valid | state_3_3 & auto_in_4_e_valid; // @[Mux.scala 27:72]
  wire  sink_ACancel_3_earlyValid = idle_3 ? _T_525 : _sink_ACancel_earlyValid_T_20; // @[Arbiter.scala 125:29]
  wire  latch_4 = idle_4 & auto_out_2_a_ready; // @[Arbiter.scala 89:24]
  wire [4:0] _readys_mask_T_38 = readys_readys_4 & readys_filter_lo_4; // @[Arbiter.scala 28:29]
  wire [5:0] _readys_mask_T_39 = {_readys_mask_T_38, 1'h0}; // @[package.scala 244:48]
  wire [4:0] _readys_mask_T_41 = _readys_mask_T_38 | _readys_mask_T_39[4:0]; // @[package.scala 244:43]
  wire [6:0] _readys_mask_T_42 = {_readys_mask_T_41, 2'h0}; // @[package.scala 244:48]
  wire [4:0] _readys_mask_T_44 = _readys_mask_T_41 | _readys_mask_T_42[4:0]; // @[package.scala 244:43]
  wire [8:0] _readys_mask_T_45 = {_readys_mask_T_44, 4'h0}; // @[package.scala 244:48]
  wire [4:0] _readys_mask_T_47 = _readys_mask_T_44 | _readys_mask_T_45[4:0]; // @[package.scala 244:43]
  wire  earlyWinner_4_0 = readys_4_0 & portsAOI_filtered__2_earlyValid; // @[Arbiter.scala 97:79]
  wire  earlyWinner_4_1 = readys_4_1 & portsAOI_filtered_1_2_earlyValid; // @[Arbiter.scala 97:79]
  wire  earlyWinner_4_2 = readys_4_2 & portsAOI_filtered_2_2_earlyValid; // @[Arbiter.scala 97:79]
  wire  earlyWinner_4_3 = readys_4_3 & portsAOI_filtered_3_2_earlyValid; // @[Arbiter.scala 97:79]
  wire  earlyWinner_4_4 = readys_4_4 & portsAOI_filtered_4_2_earlyValid; // @[Arbiter.scala 97:79]
  wire  prefixOR_2_4 = earlyWinner_4_0 | earlyWinner_4_1; // @[Arbiter.scala 104:53]
  wire  prefixOR_3_4 = prefixOR_2_4 | earlyWinner_4_2; // @[Arbiter.scala 104:53]
  wire  prefixOR_4_2 = prefixOR_3_4 | earlyWinner_4_3; // @[Arbiter.scala 104:53]
  wire  _prefixOR_T_4 = prefixOR_4_2 | earlyWinner_4_4; // @[Arbiter.scala 104:53]
  wire  _T_577 = portsAOI_filtered__2_earlyValid | portsAOI_filtered_1_2_earlyValid | portsAOI_filtered_2_2_earlyValid
     | portsAOI_filtered_3_2_earlyValid | portsAOI_filtered_4_2_earlyValid; // @[Arbiter.scala 107:36]
  wire  _T_578 = ~(portsAOI_filtered__2_earlyValid | portsAOI_filtered_1_2_earlyValid | portsAOI_filtered_2_2_earlyValid
     | portsAOI_filtered_3_2_earlyValid | portsAOI_filtered_4_2_earlyValid); // @[Arbiter.scala 107:15]
  wire [8:0] maskedBeats_0_4 = earlyWinner_4_0 ? beatsAI_0 : 9'h0; // @[Arbiter.scala 111:73]
  wire [8:0] maskedBeats_1_4 = earlyWinner_4_1 ? beatsAI_1 : 9'h0; // @[Arbiter.scala 111:73]
  wire [8:0] maskedBeats_2_4 = earlyWinner_4_2 ? beatsAI_2 : 9'h0; // @[Arbiter.scala 111:73]
  wire [8:0] maskedBeats_3_4 = earlyWinner_4_3 ? beatsAI_3 : 9'h0; // @[Arbiter.scala 111:73]
  wire [8:0] maskedBeats_4_2 = earlyWinner_4_4 ? beatsAI_4 : 9'h0; // @[Arbiter.scala 111:73]
  wire [8:0] _initBeats_T_10 = maskedBeats_0_4 | maskedBeats_1_4; // @[Arbiter.scala 112:44]
  wire [8:0] _initBeats_T_11 = _initBeats_T_10 | maskedBeats_2_4; // @[Arbiter.scala 112:44]
  wire [8:0] _initBeats_T_12 = _initBeats_T_11 | maskedBeats_3_4; // @[Arbiter.scala 112:44]
  wire [8:0] initBeats_4 = _initBeats_T_12 | maskedBeats_4_2; // @[Arbiter.scala 112:44]
  wire  muxStateEarly_4_0 = idle_4 ? earlyWinner_4_0 : state_4_0; // @[Arbiter.scala 117:30]
  wire  muxStateEarly_4_1 = idle_4 ? earlyWinner_4_1 : state_4_1; // @[Arbiter.scala 117:30]
  wire  muxStateEarly_4_2 = idle_4 ? earlyWinner_4_2 : state_4_2; // @[Arbiter.scala 117:30]
  wire  muxStateEarly_4_3 = idle_4 ? earlyWinner_4_3 : state_4_3; // @[Arbiter.scala 117:30]
  wire  muxStateEarly_4_4 = idle_4 ? earlyWinner_4_4 : state_4_4; // @[Arbiter.scala 117:30]
  wire  _out_2_a_earlyValid_T_12 = state_4_0 & portsAOI_filtered__2_earlyValid | state_4_1 &
    portsAOI_filtered_1_2_earlyValid | state_4_2 & portsAOI_filtered_2_2_earlyValid | state_4_3 &
    portsAOI_filtered_3_2_earlyValid | state_4_4 & portsAOI_filtered_4_2_earlyValid; // @[Mux.scala 27:72]
  wire  out_5_2_a_earlyValid = idle_4 ? _T_577 : _out_2_a_earlyValid_T_12; // @[Arbiter.scala 125:29]
  wire  _beatsLeft_T_26 = auto_out_2_a_ready & out_5_2_a_earlyValid; // @[ReadyValidCancel.scala 50:33]
  wire [8:0] _GEN_54 = {{8'd0}, _beatsLeft_T_26}; // @[Arbiter.scala 113:52]
  wire [8:0] _beatsLeft_T_28 = beatsLeft_4 - _GEN_54; // @[Arbiter.scala 113:52]
  wire [63:0] _T_609 = muxStateEarly_4_0 ? auto_in_0_a_bits_data : 64'h0; // @[Mux.scala 27:72]
  wire [63:0] _T_610 = muxStateEarly_4_1 ? auto_in_1_a_bits_data : 64'h0; // @[Mux.scala 27:72]
  wire [63:0] _T_611 = muxStateEarly_4_2 ? auto_in_2_a_bits_data : 64'h0; // @[Mux.scala 27:72]
  wire [63:0] _T_612 = muxStateEarly_4_3 ? auto_in_3_a_bits_data : 64'h0; // @[Mux.scala 27:72]
  wire [63:0] _T_613 = muxStateEarly_4_4 ? auto_in_4_a_bits_data : 64'h0; // @[Mux.scala 27:72]
  wire [63:0] _T_614 = _T_609 | _T_610; // @[Mux.scala 27:72]
  wire [63:0] _T_615 = _T_614 | _T_611; // @[Mux.scala 27:72]
  wire [63:0] _T_616 = _T_615 | _T_612; // @[Mux.scala 27:72]
  wire [7:0] _T_618 = muxStateEarly_4_0 ? auto_in_0_a_bits_mask : 8'h0; // @[Mux.scala 27:72]
  wire [7:0] _T_619 = muxStateEarly_4_1 ? auto_in_1_a_bits_mask : 8'h0; // @[Mux.scala 27:72]
  wire [7:0] _T_620 = muxStateEarly_4_2 ? auto_in_2_a_bits_mask : 8'h0; // @[Mux.scala 27:72]
  wire [7:0] _T_621 = muxStateEarly_4_3 ? auto_in_3_a_bits_mask : 8'h0; // @[Mux.scala 27:72]
  wire [7:0] _T_622 = muxStateEarly_4_4 ? auto_in_4_a_bits_mask : 8'h0; // @[Mux.scala 27:72]
  wire [7:0] _T_623 = _T_618 | _T_619; // @[Mux.scala 27:72]
  wire [7:0] _T_624 = _T_623 | _T_620; // @[Mux.scala 27:72]
  wire [7:0] _T_625 = _T_624 | _T_621; // @[Mux.scala 27:72]
  wire [31:0] _T_690 = muxStateEarly_4_0 ? auto_in_0_a_bits_address : 32'h0; // @[Mux.scala 27:72]
  wire [31:0] _T_691 = muxStateEarly_4_1 ? auto_in_1_a_bits_address : 32'h0; // @[Mux.scala 27:72]
  wire [31:0] _T_692 = muxStateEarly_4_2 ? auto_in_2_a_bits_address : 32'h0; // @[Mux.scala 27:72]
  wire [31:0] _T_693 = muxStateEarly_4_3 ? auto_in_3_a_bits_address : 32'h0; // @[Mux.scala 27:72]
  wire [31:0] _T_694 = muxStateEarly_4_4 ? auto_in_4_a_bits_address : 32'h0; // @[Mux.scala 27:72]
  wire [31:0] _T_695 = _T_690 | _T_691; // @[Mux.scala 27:72]
  wire [31:0] _T_696 = _T_695 | _T_692; // @[Mux.scala 27:72]
  wire [31:0] _T_697 = _T_696 | _T_693; // @[Mux.scala 27:72]
  wire [31:0] out_5_2_a_bits_address = _T_697 | _T_694; // @[Mux.scala 27:72]
  wire [4:0] _T_699 = muxStateEarly_4_0 ? in_0_a_bits_source : 5'h0; // @[Mux.scala 27:72]
  wire [4:0] _T_700 = muxStateEarly_4_1 ? in_1_a_bits_source : 5'h0; // @[Mux.scala 27:72]
  wire [4:0] _T_701 = muxStateEarly_4_2 ? in_2_a_bits_source : 5'h0; // @[Mux.scala 27:72]
  wire [4:0] _T_702 = muxStateEarly_4_3 ? in_3_a_bits_source : 5'h0; // @[Mux.scala 27:72]
  wire [4:0] _T_703 = muxStateEarly_4_4 ? in_4_a_bits_source : 5'h0; // @[Mux.scala 27:72]
  wire [4:0] _T_704 = _T_699 | _T_700; // @[Mux.scala 27:72]
  wire [4:0] _T_705 = _T_704 | _T_701; // @[Mux.scala 27:72]
  wire [4:0] _T_706 = _T_705 | _T_702; // @[Mux.scala 27:72]
  wire [3:0] _T_708 = muxStateEarly_4_0 ? auto_in_0_a_bits_size : 4'h0; // @[Mux.scala 27:72]
  wire [3:0] _T_709 = muxStateEarly_4_1 ? auto_in_1_a_bits_size : 4'h0; // @[Mux.scala 27:72]
  wire [3:0] _T_710 = muxStateEarly_4_2 ? auto_in_2_a_bits_size : 4'h0; // @[Mux.scala 27:72]
  wire [3:0] _T_711 = muxStateEarly_4_3 ? auto_in_3_a_bits_size : 4'h0; // @[Mux.scala 27:72]
  wire [3:0] _T_712 = muxStateEarly_4_4 ? auto_in_4_a_bits_size : 4'h0; // @[Mux.scala 27:72]
  wire [3:0] _T_713 = _T_708 | _T_709; // @[Mux.scala 27:72]
  wire [3:0] _T_714 = _T_713 | _T_710; // @[Mux.scala 27:72]
  wire [3:0] _T_715 = _T_714 | _T_711; // @[Mux.scala 27:72]
  wire [2:0] _T_717 = muxStateEarly_4_0 ? auto_in_0_a_bits_param : 3'h0; // @[Mux.scala 27:72]
  wire [2:0] _T_718 = muxStateEarly_4_1 ? auto_in_1_a_bits_param : 3'h0; // @[Mux.scala 27:72]
  wire [2:0] _T_719 = muxStateEarly_4_2 ? auto_in_2_a_bits_param : 3'h0; // @[Mux.scala 27:72]
  wire [2:0] _T_720 = muxStateEarly_4_3 ? auto_in_3_a_bits_param : 3'h0; // @[Mux.scala 27:72]
  wire [2:0] _T_721 = muxStateEarly_4_4 ? auto_in_4_a_bits_param : 3'h0; // @[Mux.scala 27:72]
  wire [2:0] _T_722 = _T_717 | _T_718; // @[Mux.scala 27:72]
  wire [2:0] _T_723 = _T_722 | _T_719; // @[Mux.scala 27:72]
  wire [2:0] _T_724 = _T_723 | _T_720; // @[Mux.scala 27:72]
  wire [2:0] _T_726 = muxStateEarly_4_0 ? auto_in_0_a_bits_opcode : 3'h0; // @[Mux.scala 27:72]
  wire [2:0] _T_727 = muxStateEarly_4_1 ? auto_in_1_a_bits_opcode : 3'h0; // @[Mux.scala 27:72]
  wire [2:0] _T_728 = muxStateEarly_4_2 ? auto_in_2_a_bits_opcode : 3'h0; // @[Mux.scala 27:72]
  wire [2:0] _T_729 = muxStateEarly_4_3 ? auto_in_3_a_bits_opcode : 3'h0; // @[Mux.scala 27:72]
  wire [2:0] _T_730 = muxStateEarly_4_4 ? auto_in_4_a_bits_opcode : 3'h0; // @[Mux.scala 27:72]
  wire [2:0] _T_731 = _T_726 | _T_727; // @[Mux.scala 27:72]
  wire [2:0] _T_732 = _T_731 | _T_728; // @[Mux.scala 27:72]
  wire [2:0] _T_733 = _T_732 | _T_729; // @[Mux.scala 27:72]
  wire  latch_5 = idle_5 & auto_in_0_d_ready; // @[Arbiter.scala 89:24]
  wire [2:0] _readys_mask_T_49 = readys_readys_5 & readys_filter_lo_5; // @[Arbiter.scala 28:29]
  wire [3:0] _readys_mask_T_50 = {_readys_mask_T_49, 1'h0}; // @[package.scala 244:48]
  wire [2:0] _readys_mask_T_52 = _readys_mask_T_49 | _readys_mask_T_50[2:0]; // @[package.scala 244:43]
  wire [4:0] _readys_mask_T_53 = {_readys_mask_T_52, 2'h0}; // @[package.scala 244:48]
  wire [2:0] _readys_mask_T_55 = _readys_mask_T_52 | _readys_mask_T_53[2:0]; // @[package.scala 244:43]
  wire  prefixOR_2_5 = earlyWinner_5_0 | earlyWinner_5_1; // @[Arbiter.scala 104:53]
  wire  _prefixOR_T_5 = prefixOR_2_5 | earlyWinner_5_2; // @[Arbiter.scala 104:53]
  wire  _T_750 = portsDIO_filtered__0_valid | portsDIO_filtered_1_0_valid | portsDIO_filtered_2_0_valid; // @[Arbiter.scala 107:36]
  wire  _T_751 = ~(portsDIO_filtered__0_valid | portsDIO_filtered_1_0_valid | portsDIO_filtered_2_0_valid); // @[Arbiter.scala 107:15]
  wire [8:0] maskedBeats_0_5 = earlyWinner_5_0 ? beatsDO_0 : 9'h0; // @[Arbiter.scala 111:73]
  wire [2:0] maskedBeats_1_5 = earlyWinner_5_1 ? beatsDO_1 : 3'h0; // @[Arbiter.scala 111:73]
  wire [4:0] maskedBeats_2_5 = earlyWinner_5_2 ? beatsDO_2 : 5'h0; // @[Arbiter.scala 111:73]
  wire [8:0] _GEN_55 = {{6'd0}, maskedBeats_1_5}; // @[Arbiter.scala 112:44]
  wire [8:0] _initBeats_T_13 = maskedBeats_0_5 | _GEN_55; // @[Arbiter.scala 112:44]
  wire [8:0] _GEN_56 = {{4'd0}, maskedBeats_2_5}; // @[Arbiter.scala 112:44]
  wire [8:0] initBeats_5 = _initBeats_T_13 | _GEN_56; // @[Arbiter.scala 112:44]
  wire  _sink_ACancel_earlyValid_T_28 = state_5_0 & portsDIO_filtered__0_valid | state_5_1 & portsDIO_filtered_1_0_valid
     | state_5_2 & portsDIO_filtered_2_0_valid; // @[Mux.scala 27:72]
  wire  sink_ACancel_7_earlyValid = idle_5 ? _T_750 : _sink_ACancel_earlyValid_T_28; // @[Arbiter.scala 125:29]
  wire  _beatsLeft_T_32 = auto_in_0_d_ready & sink_ACancel_7_earlyValid; // @[ReadyValidCancel.scala 50:33]
  wire [8:0] _GEN_57 = {{8'd0}, _beatsLeft_T_32}; // @[Arbiter.scala 113:52]
  wire [8:0] _beatsLeft_T_34 = beatsLeft_5 - _GEN_57; // @[Arbiter.scala 113:52]
  wire [63:0] _T_772 = muxStateEarly_5_0 ? auto_out_0_d_bits_data : 64'h0; // @[Mux.scala 27:72]
  wire [63:0] _T_773 = muxStateEarly_5_1 ? auto_out_1_d_bits_data : 64'h0; // @[Mux.scala 27:72]
  wire [63:0] _T_774 = muxStateEarly_5_2 ? auto_out_2_d_bits_data : 64'h0; // @[Mux.scala 27:72]
  wire [63:0] _T_775 = _T_772 | _T_773; // @[Mux.scala 27:72]
  wire [1:0] out_5_0_d_bits_sink = {{1'd0}, auto_out_0_d_bits_sink}; // @[Xbar.scala 288:19 Xbar.scala 323:28]
  wire [1:0] _T_782 = muxStateEarly_5_0 ? out_5_0_d_bits_sink : 2'h0; // @[Mux.scala 27:72]
  wire [1:0] _T_783 = muxStateEarly_5_1 ? auto_out_1_d_bits_sink : 2'h0; // @[Mux.scala 27:72]
  wire [3:0] _T_792 = muxStateEarly_5_0 ? auto_out_0_d_bits_size : 4'h0; // @[Mux.scala 27:72]
  wire [3:0] _T_793 = muxStateEarly_5_1 ? out_5_1_d_bits_size : 4'h0; // @[Mux.scala 27:72]
  wire [3:0] _T_794 = muxStateEarly_5_2 ? auto_out_2_d_bits_size : 4'h0; // @[Mux.scala 27:72]
  wire [3:0] _T_795 = _T_792 | _T_793; // @[Mux.scala 27:72]
  wire [1:0] _T_797 = muxStateEarly_5_0 ? auto_out_0_d_bits_param : 2'h0; // @[Mux.scala 27:72]
  wire [1:0] _T_798 = muxStateEarly_5_1 ? auto_out_1_d_bits_param : 2'h0; // @[Mux.scala 27:72]
  wire [2:0] _T_802 = muxStateEarly_5_0 ? auto_out_0_d_bits_opcode : 3'h0; // @[Mux.scala 27:72]
  wire [2:0] _T_803 = muxStateEarly_5_1 ? auto_out_1_d_bits_opcode : 3'h0; // @[Mux.scala 27:72]
  wire [2:0] _T_804 = muxStateEarly_5_2 ? auto_out_2_d_bits_opcode : 3'h0; // @[Mux.scala 27:72]
  wire [2:0] _T_805 = _T_802 | _T_803; // @[Mux.scala 27:72]
  wire  latch_6 = idle_6 & auto_in_1_d_ready; // @[Arbiter.scala 89:24]
  wire [2:0] _readys_mask_T_57 = readys_readys_6 & readys_filter_lo_6; // @[Arbiter.scala 28:29]
  wire [3:0] _readys_mask_T_58 = {_readys_mask_T_57, 1'h0}; // @[package.scala 244:48]
  wire [2:0] _readys_mask_T_60 = _readys_mask_T_57 | _readys_mask_T_58[2:0]; // @[package.scala 244:43]
  wire [4:0] _readys_mask_T_61 = {_readys_mask_T_60, 2'h0}; // @[package.scala 244:48]
  wire [2:0] _readys_mask_T_63 = _readys_mask_T_60 | _readys_mask_T_61[2:0]; // @[package.scala 244:43]
  wire  prefixOR_2_6 = earlyWinner_6_0 | earlyWinner_6_1; // @[Arbiter.scala 104:53]
  wire  _prefixOR_T_6 = prefixOR_2_6 | earlyWinner_6_2; // @[Arbiter.scala 104:53]
  wire  _T_822 = portsDIO_filtered__1_valid | portsDIO_filtered_1_1_valid | portsDIO_filtered_2_1_valid; // @[Arbiter.scala 107:36]
  wire  _T_823 = ~(portsDIO_filtered__1_valid | portsDIO_filtered_1_1_valid | portsDIO_filtered_2_1_valid); // @[Arbiter.scala 107:15]
  wire [8:0] maskedBeats_0_6 = earlyWinner_6_0 ? beatsDO_0 : 9'h0; // @[Arbiter.scala 111:73]
  wire [2:0] maskedBeats_1_6 = earlyWinner_6_1 ? beatsDO_1 : 3'h0; // @[Arbiter.scala 111:73]
  wire [4:0] maskedBeats_2_6 = earlyWinner_6_2 ? beatsDO_2 : 5'h0; // @[Arbiter.scala 111:73]
  wire [8:0] _GEN_58 = {{6'd0}, maskedBeats_1_6}; // @[Arbiter.scala 112:44]
  wire [8:0] _initBeats_T_14 = maskedBeats_0_6 | _GEN_58; // @[Arbiter.scala 112:44]
  wire [8:0] _GEN_59 = {{4'd0}, maskedBeats_2_6}; // @[Arbiter.scala 112:44]
  wire [8:0] initBeats_6 = _initBeats_T_14 | _GEN_59; // @[Arbiter.scala 112:44]
  wire  _sink_ACancel_earlyValid_T_36 = state_6_0 & portsDIO_filtered__1_valid | state_6_1 & portsDIO_filtered_1_1_valid
     | state_6_2 & portsDIO_filtered_2_1_valid; // @[Mux.scala 27:72]
  wire  sink_ACancel_9_earlyValid = idle_6 ? _T_822 : _sink_ACancel_earlyValid_T_36; // @[Arbiter.scala 125:29]
  wire  _beatsLeft_T_38 = auto_in_1_d_ready & sink_ACancel_9_earlyValid; // @[ReadyValidCancel.scala 50:33]
  wire [8:0] _GEN_60 = {{8'd0}, _beatsLeft_T_38}; // @[Arbiter.scala 113:52]
  wire [8:0] _beatsLeft_T_40 = beatsLeft_6 - _GEN_60; // @[Arbiter.scala 113:52]
  wire [63:0] _T_844 = muxStateEarly_6_0 ? auto_out_0_d_bits_data : 64'h0; // @[Mux.scala 27:72]
  wire [63:0] _T_845 = muxStateEarly_6_1 ? auto_out_1_d_bits_data : 64'h0; // @[Mux.scala 27:72]
  wire [63:0] _T_846 = muxStateEarly_6_2 ? auto_out_2_d_bits_data : 64'h0; // @[Mux.scala 27:72]
  wire [63:0] _T_847 = _T_844 | _T_845; // @[Mux.scala 27:72]
  wire [1:0] _T_854 = muxStateEarly_6_0 ? out_5_0_d_bits_sink : 2'h0; // @[Mux.scala 27:72]
  wire [1:0] _T_855 = muxStateEarly_6_1 ? auto_out_1_d_bits_sink : 2'h0; // @[Mux.scala 27:72]
  wire [3:0] _T_864 = muxStateEarly_6_0 ? auto_out_0_d_bits_size : 4'h0; // @[Mux.scala 27:72]
  wire [3:0] _T_865 = muxStateEarly_6_1 ? out_5_1_d_bits_size : 4'h0; // @[Mux.scala 27:72]
  wire [3:0] _T_866 = muxStateEarly_6_2 ? auto_out_2_d_bits_size : 4'h0; // @[Mux.scala 27:72]
  wire [3:0] _T_867 = _T_864 | _T_865; // @[Mux.scala 27:72]
  wire [1:0] _T_869 = muxStateEarly_6_0 ? auto_out_0_d_bits_param : 2'h0; // @[Mux.scala 27:72]
  wire [1:0] _T_870 = muxStateEarly_6_1 ? auto_out_1_d_bits_param : 2'h0; // @[Mux.scala 27:72]
  wire [2:0] _T_874 = muxStateEarly_6_0 ? auto_out_0_d_bits_opcode : 3'h0; // @[Mux.scala 27:72]
  wire [2:0] _T_875 = muxStateEarly_6_1 ? auto_out_1_d_bits_opcode : 3'h0; // @[Mux.scala 27:72]
  wire [2:0] _T_876 = muxStateEarly_6_2 ? auto_out_2_d_bits_opcode : 3'h0; // @[Mux.scala 27:72]
  wire [2:0] _T_877 = _T_874 | _T_875; // @[Mux.scala 27:72]
  wire  latch_7 = idle_7 & auto_in_2_d_ready; // @[Arbiter.scala 89:24]
  wire [2:0] _readys_mask_T_65 = readys_readys_7 & readys_filter_lo_7; // @[Arbiter.scala 28:29]
  wire [3:0] _readys_mask_T_66 = {_readys_mask_T_65, 1'h0}; // @[package.scala 244:48]
  wire [2:0] _readys_mask_T_68 = _readys_mask_T_65 | _readys_mask_T_66[2:0]; // @[package.scala 244:43]
  wire [4:0] _readys_mask_T_69 = {_readys_mask_T_68, 2'h0}; // @[package.scala 244:48]
  wire [2:0] _readys_mask_T_71 = _readys_mask_T_68 | _readys_mask_T_69[2:0]; // @[package.scala 244:43]
  wire  prefixOR_2_7 = earlyWinner_7_0 | earlyWinner_7_1; // @[Arbiter.scala 104:53]
  wire  _prefixOR_T_7 = prefixOR_2_7 | earlyWinner_7_2; // @[Arbiter.scala 104:53]
  wire  _T_894 = portsDIO_filtered__2_valid | portsDIO_filtered_1_2_valid | portsDIO_filtered_2_2_valid; // @[Arbiter.scala 107:36]
  wire  _T_895 = ~(portsDIO_filtered__2_valid | portsDIO_filtered_1_2_valid | portsDIO_filtered_2_2_valid); // @[Arbiter.scala 107:15]
  wire [8:0] maskedBeats_0_7 = earlyWinner_7_0 ? beatsDO_0 : 9'h0; // @[Arbiter.scala 111:73]
  wire [2:0] maskedBeats_1_7 = earlyWinner_7_1 ? beatsDO_1 : 3'h0; // @[Arbiter.scala 111:73]
  wire [4:0] maskedBeats_2_7 = earlyWinner_7_2 ? beatsDO_2 : 5'h0; // @[Arbiter.scala 111:73]
  wire [8:0] _GEN_61 = {{6'd0}, maskedBeats_1_7}; // @[Arbiter.scala 112:44]
  wire [8:0] _initBeats_T_15 = maskedBeats_0_7 | _GEN_61; // @[Arbiter.scala 112:44]
  wire [8:0] _GEN_62 = {{4'd0}, maskedBeats_2_7}; // @[Arbiter.scala 112:44]
  wire [8:0] initBeats_7 = _initBeats_T_15 | _GEN_62; // @[Arbiter.scala 112:44]
  wire  _sink_ACancel_earlyValid_T_44 = state_7_0 & portsDIO_filtered__2_valid | state_7_1 & portsDIO_filtered_1_2_valid
     | state_7_2 & portsDIO_filtered_2_2_valid; // @[Mux.scala 27:72]
  wire  sink_ACancel_11_earlyValid = idle_7 ? _T_894 : _sink_ACancel_earlyValid_T_44; // @[Arbiter.scala 125:29]
  wire  _beatsLeft_T_44 = auto_in_2_d_ready & sink_ACancel_11_earlyValid; // @[ReadyValidCancel.scala 50:33]
  wire [8:0] _GEN_63 = {{8'd0}, _beatsLeft_T_44}; // @[Arbiter.scala 113:52]
  wire [8:0] _beatsLeft_T_46 = beatsLeft_7 - _GEN_63; // @[Arbiter.scala 113:52]
  wire [63:0] _T_916 = muxStateEarly_7_0 ? auto_out_0_d_bits_data : 64'h0; // @[Mux.scala 27:72]
  wire [63:0] _T_917 = muxStateEarly_7_1 ? auto_out_1_d_bits_data : 64'h0; // @[Mux.scala 27:72]
  wire [63:0] _T_918 = muxStateEarly_7_2 ? auto_out_2_d_bits_data : 64'h0; // @[Mux.scala 27:72]
  wire [63:0] _T_919 = _T_916 | _T_917; // @[Mux.scala 27:72]
  wire [1:0] _T_926 = muxStateEarly_7_0 ? out_5_0_d_bits_sink : 2'h0; // @[Mux.scala 27:72]
  wire [1:0] _T_927 = muxStateEarly_7_1 ? auto_out_1_d_bits_sink : 2'h0; // @[Mux.scala 27:72]
  wire [3:0] _T_936 = muxStateEarly_7_0 ? auto_out_0_d_bits_size : 4'h0; // @[Mux.scala 27:72]
  wire [3:0] _T_937 = muxStateEarly_7_1 ? out_5_1_d_bits_size : 4'h0; // @[Mux.scala 27:72]
  wire [3:0] _T_938 = muxStateEarly_7_2 ? auto_out_2_d_bits_size : 4'h0; // @[Mux.scala 27:72]
  wire [3:0] _T_939 = _T_936 | _T_937; // @[Mux.scala 27:72]
  wire [1:0] _T_941 = muxStateEarly_7_0 ? auto_out_0_d_bits_param : 2'h0; // @[Mux.scala 27:72]
  wire [1:0] _T_942 = muxStateEarly_7_1 ? auto_out_1_d_bits_param : 2'h0; // @[Mux.scala 27:72]
  wire [2:0] _T_946 = muxStateEarly_7_0 ? auto_out_0_d_bits_opcode : 3'h0; // @[Mux.scala 27:72]
  wire [2:0] _T_947 = muxStateEarly_7_1 ? auto_out_1_d_bits_opcode : 3'h0; // @[Mux.scala 27:72]
  wire [2:0] _T_948 = muxStateEarly_7_2 ? auto_out_2_d_bits_opcode : 3'h0; // @[Mux.scala 27:72]
  wire [2:0] _T_949 = _T_946 | _T_947; // @[Mux.scala 27:72]
  wire  latch_8 = idle_8 & auto_in_3_d_ready; // @[Arbiter.scala 89:24]
  wire [2:0] _readys_mask_T_73 = readys_readys_8 & readys_filter_lo_8; // @[Arbiter.scala 28:29]
  wire [3:0] _readys_mask_T_74 = {_readys_mask_T_73, 1'h0}; // @[package.scala 244:48]
  wire [2:0] _readys_mask_T_76 = _readys_mask_T_73 | _readys_mask_T_74[2:0]; // @[package.scala 244:43]
  wire [4:0] _readys_mask_T_77 = {_readys_mask_T_76, 2'h0}; // @[package.scala 244:48]
  wire [2:0] _readys_mask_T_79 = _readys_mask_T_76 | _readys_mask_T_77[2:0]; // @[package.scala 244:43]
  wire  prefixOR_2_8 = earlyWinner_8_0 | earlyWinner_8_1; // @[Arbiter.scala 104:53]
  wire  _prefixOR_T_8 = prefixOR_2_8 | earlyWinner_8_2; // @[Arbiter.scala 104:53]
  wire  _T_966 = portsDIO_filtered__3_valid | portsDIO_filtered_1_3_valid | portsDIO_filtered_2_3_valid; // @[Arbiter.scala 107:36]
  wire  _T_967 = ~(portsDIO_filtered__3_valid | portsDIO_filtered_1_3_valid | portsDIO_filtered_2_3_valid); // @[Arbiter.scala 107:15]
  wire [8:0] maskedBeats_0_8 = earlyWinner_8_0 ? beatsDO_0 : 9'h0; // @[Arbiter.scala 111:73]
  wire [2:0] maskedBeats_1_8 = earlyWinner_8_1 ? beatsDO_1 : 3'h0; // @[Arbiter.scala 111:73]
  wire [4:0] maskedBeats_2_8 = earlyWinner_8_2 ? beatsDO_2 : 5'h0; // @[Arbiter.scala 111:73]
  wire [8:0] _GEN_64 = {{6'd0}, maskedBeats_1_8}; // @[Arbiter.scala 112:44]
  wire [8:0] _initBeats_T_16 = maskedBeats_0_8 | _GEN_64; // @[Arbiter.scala 112:44]
  wire [8:0] _GEN_65 = {{4'd0}, maskedBeats_2_8}; // @[Arbiter.scala 112:44]
  wire [8:0] initBeats_8 = _initBeats_T_16 | _GEN_65; // @[Arbiter.scala 112:44]
  wire  _sink_ACancel_earlyValid_T_52 = state_8_0 & portsDIO_filtered__3_valid | state_8_1 & portsDIO_filtered_1_3_valid
     | state_8_2 & portsDIO_filtered_2_3_valid; // @[Mux.scala 27:72]
  wire  sink_ACancel_13_earlyValid = idle_8 ? _T_966 : _sink_ACancel_earlyValid_T_52; // @[Arbiter.scala 125:29]
  wire  _beatsLeft_T_50 = auto_in_3_d_ready & sink_ACancel_13_earlyValid; // @[ReadyValidCancel.scala 50:33]
  wire [8:0] _GEN_66 = {{8'd0}, _beatsLeft_T_50}; // @[Arbiter.scala 113:52]
  wire [8:0] _beatsLeft_T_52 = beatsLeft_8 - _GEN_66; // @[Arbiter.scala 113:52]
  wire [63:0] _T_988 = muxStateEarly_8_0 ? auto_out_0_d_bits_data : 64'h0; // @[Mux.scala 27:72]
  wire [63:0] _T_989 = muxStateEarly_8_1 ? auto_out_1_d_bits_data : 64'h0; // @[Mux.scala 27:72]
  wire [63:0] _T_990 = muxStateEarly_8_2 ? auto_out_2_d_bits_data : 64'h0; // @[Mux.scala 27:72]
  wire [63:0] _T_991 = _T_988 | _T_989; // @[Mux.scala 27:72]
  wire [1:0] _T_998 = muxStateEarly_8_0 ? out_5_0_d_bits_sink : 2'h0; // @[Mux.scala 27:72]
  wire [1:0] _T_999 = muxStateEarly_8_1 ? auto_out_1_d_bits_sink : 2'h0; // @[Mux.scala 27:72]
  wire [3:0] _T_1008 = muxStateEarly_8_0 ? auto_out_0_d_bits_size : 4'h0; // @[Mux.scala 27:72]
  wire [3:0] _T_1009 = muxStateEarly_8_1 ? out_5_1_d_bits_size : 4'h0; // @[Mux.scala 27:72]
  wire [3:0] _T_1010 = muxStateEarly_8_2 ? auto_out_2_d_bits_size : 4'h0; // @[Mux.scala 27:72]
  wire [3:0] _T_1011 = _T_1008 | _T_1009; // @[Mux.scala 27:72]
  wire [1:0] _T_1013 = muxStateEarly_8_0 ? auto_out_0_d_bits_param : 2'h0; // @[Mux.scala 27:72]
  wire [1:0] _T_1014 = muxStateEarly_8_1 ? auto_out_1_d_bits_param : 2'h0; // @[Mux.scala 27:72]
  wire [2:0] _T_1018 = muxStateEarly_8_0 ? auto_out_0_d_bits_opcode : 3'h0; // @[Mux.scala 27:72]
  wire [2:0] _T_1019 = muxStateEarly_8_1 ? auto_out_1_d_bits_opcode : 3'h0; // @[Mux.scala 27:72]
  wire [2:0] _T_1020 = muxStateEarly_8_2 ? auto_out_2_d_bits_opcode : 3'h0; // @[Mux.scala 27:72]
  wire [2:0] _T_1021 = _T_1018 | _T_1019; // @[Mux.scala 27:72]
  wire  latch_9 = idle_9 & auto_in_4_d_ready; // @[Arbiter.scala 89:24]
  wire [2:0] _readys_mask_T_81 = readys_readys_9 & readys_filter_lo_9; // @[Arbiter.scala 28:29]
  wire [3:0] _readys_mask_T_82 = {_readys_mask_T_81, 1'h0}; // @[package.scala 244:48]
  wire [2:0] _readys_mask_T_84 = _readys_mask_T_81 | _readys_mask_T_82[2:0]; // @[package.scala 244:43]
  wire [4:0] _readys_mask_T_85 = {_readys_mask_T_84, 2'h0}; // @[package.scala 244:48]
  wire [2:0] _readys_mask_T_87 = _readys_mask_T_84 | _readys_mask_T_85[2:0]; // @[package.scala 244:43]
  wire  prefixOR_2_9 = earlyWinner_9_0 | earlyWinner_9_1; // @[Arbiter.scala 104:53]
  wire  _prefixOR_T_9 = prefixOR_2_9 | earlyWinner_9_2; // @[Arbiter.scala 104:53]
  wire  _T_1038 = portsDIO_filtered__4_valid | portsDIO_filtered_1_4_valid | portsDIO_filtered_2_4_valid; // @[Arbiter.scala 107:36]
  wire  _T_1039 = ~(portsDIO_filtered__4_valid | portsDIO_filtered_1_4_valid | portsDIO_filtered_2_4_valid); // @[Arbiter.scala 107:15]
  wire [8:0] maskedBeats_0_9 = earlyWinner_9_0 ? beatsDO_0 : 9'h0; // @[Arbiter.scala 111:73]
  wire [2:0] maskedBeats_1_9 = earlyWinner_9_1 ? beatsDO_1 : 3'h0; // @[Arbiter.scala 111:73]
  wire [4:0] maskedBeats_2_9 = earlyWinner_9_2 ? beatsDO_2 : 5'h0; // @[Arbiter.scala 111:73]
  wire [8:0] _GEN_67 = {{6'd0}, maskedBeats_1_9}; // @[Arbiter.scala 112:44]
  wire [8:0] _initBeats_T_17 = maskedBeats_0_9 | _GEN_67; // @[Arbiter.scala 112:44]
  wire [8:0] _GEN_68 = {{4'd0}, maskedBeats_2_9}; // @[Arbiter.scala 112:44]
  wire [8:0] initBeats_9 = _initBeats_T_17 | _GEN_68; // @[Arbiter.scala 112:44]
  wire  _sink_ACancel_earlyValid_T_60 = state_9_0 & portsDIO_filtered__4_valid | state_9_1 & portsDIO_filtered_1_4_valid
     | state_9_2 & portsDIO_filtered_2_4_valid; // @[Mux.scala 27:72]
  wire  sink_ACancel_15_earlyValid = idle_9 ? _T_1038 : _sink_ACancel_earlyValid_T_60; // @[Arbiter.scala 125:29]
  wire  _beatsLeft_T_56 = auto_in_4_d_ready & sink_ACancel_15_earlyValid; // @[ReadyValidCancel.scala 50:33]
  wire [8:0] _GEN_69 = {{8'd0}, _beatsLeft_T_56}; // @[Arbiter.scala 113:52]
  wire [8:0] _beatsLeft_T_58 = beatsLeft_9 - _GEN_69; // @[Arbiter.scala 113:52]
  wire [63:0] _T_1060 = muxStateEarly_9_0 ? auto_out_0_d_bits_data : 64'h0; // @[Mux.scala 27:72]
  wire [63:0] _T_1061 = muxStateEarly_9_1 ? auto_out_1_d_bits_data : 64'h0; // @[Mux.scala 27:72]
  wire [63:0] _T_1062 = muxStateEarly_9_2 ? auto_out_2_d_bits_data : 64'h0; // @[Mux.scala 27:72]
  wire [63:0] _T_1063 = _T_1060 | _T_1061; // @[Mux.scala 27:72]
  wire [1:0] _T_1070 = muxStateEarly_9_0 ? out_5_0_d_bits_sink : 2'h0; // @[Mux.scala 27:72]
  wire [1:0] _T_1071 = muxStateEarly_9_1 ? auto_out_1_d_bits_sink : 2'h0; // @[Mux.scala 27:72]
  wire [3:0] _T_1080 = muxStateEarly_9_0 ? auto_out_0_d_bits_size : 4'h0; // @[Mux.scala 27:72]
  wire [3:0] _T_1081 = muxStateEarly_9_1 ? out_5_1_d_bits_size : 4'h0; // @[Mux.scala 27:72]
  wire [3:0] _T_1082 = muxStateEarly_9_2 ? auto_out_2_d_bits_size : 4'h0; // @[Mux.scala 27:72]
  wire [3:0] _T_1083 = _T_1080 | _T_1081; // @[Mux.scala 27:72]
  wire [1:0] _T_1085 = muxStateEarly_9_0 ? auto_out_0_d_bits_param : 2'h0; // @[Mux.scala 27:72]
  wire [1:0] _T_1086 = muxStateEarly_9_1 ? auto_out_1_d_bits_param : 2'h0; // @[Mux.scala 27:72]
  wire [2:0] _T_1090 = muxStateEarly_9_0 ? auto_out_0_d_bits_opcode : 3'h0; // @[Mux.scala 27:72]
  wire [2:0] _T_1091 = muxStateEarly_9_1 ? auto_out_1_d_bits_opcode : 3'h0; // @[Mux.scala 27:72]
  wire [2:0] _T_1092 = muxStateEarly_9_2 ? auto_out_2_d_bits_opcode : 3'h0; // @[Mux.scala 27:72]
  wire [2:0] _T_1093 = _T_1090 | _T_1091; // @[Mux.scala 27:72]
  TLMonitor monitor ( // @[Nodes.scala 24:25]
    .clock(monitor_clock),
    .reset(monitor_reset),
    .io_in_a_ready(monitor_io_in_a_ready),
    .io_in_a_valid(monitor_io_in_a_valid),
    .io_in_a_bits_opcode(monitor_io_in_a_bits_opcode),
    .io_in_a_bits_param(monitor_io_in_a_bits_param),
    .io_in_a_bits_size(monitor_io_in_a_bits_size),
    .io_in_a_bits_source(monitor_io_in_a_bits_source),
    .io_in_a_bits_address(monitor_io_in_a_bits_address),
    .io_in_a_bits_mask(monitor_io_in_a_bits_mask),
    .io_in_a_bits_corrupt(monitor_io_in_a_bits_corrupt),
    .io_in_d_ready(monitor_io_in_d_ready),
    .io_in_d_valid(monitor_io_in_d_valid),
    .io_in_d_bits_opcode(monitor_io_in_d_bits_opcode),
    .io_in_d_bits_param(monitor_io_in_d_bits_param),
    .io_in_d_bits_size(monitor_io_in_d_bits_size),
    .io_in_d_bits_source(monitor_io_in_d_bits_source),
    .io_in_d_bits_sink(monitor_io_in_d_bits_sink),
    .io_in_d_bits_denied(monitor_io_in_d_bits_denied),
    .io_in_d_bits_corrupt(monitor_io_in_d_bits_corrupt)
  );
  TLMonitor_1 monitor_1 ( // @[Nodes.scala 24:25]
    .clock(monitor_1_clock),
    .reset(monitor_1_reset),
    .io_in_a_ready(monitor_1_io_in_a_ready),
    .io_in_a_valid(monitor_1_io_in_a_valid),
    .io_in_a_bits_opcode(monitor_1_io_in_a_bits_opcode),
    .io_in_a_bits_param(monitor_1_io_in_a_bits_param),
    .io_in_a_bits_size(monitor_1_io_in_a_bits_size),
    .io_in_a_bits_source(monitor_1_io_in_a_bits_source),
    .io_in_a_bits_address(monitor_1_io_in_a_bits_address),
    .io_in_a_bits_mask(monitor_1_io_in_a_bits_mask),
    .io_in_a_bits_corrupt(monitor_1_io_in_a_bits_corrupt),
    .io_in_b_ready(monitor_1_io_in_b_ready),
    .io_in_b_valid(monitor_1_io_in_b_valid),
    .io_in_b_bits_param(monitor_1_io_in_b_bits_param),
    .io_in_b_bits_source(monitor_1_io_in_b_bits_source),
    .io_in_b_bits_address(monitor_1_io_in_b_bits_address),
    .io_in_c_ready(monitor_1_io_in_c_ready),
    .io_in_c_valid(monitor_1_io_in_c_valid),
    .io_in_c_bits_opcode(monitor_1_io_in_c_bits_opcode),
    .io_in_c_bits_param(monitor_1_io_in_c_bits_param),
    .io_in_c_bits_size(monitor_1_io_in_c_bits_size),
    .io_in_c_bits_source(monitor_1_io_in_c_bits_source),
    .io_in_c_bits_address(monitor_1_io_in_c_bits_address),
    .io_in_c_bits_corrupt(monitor_1_io_in_c_bits_corrupt),
    .io_in_d_ready(monitor_1_io_in_d_ready),
    .io_in_d_valid(monitor_1_io_in_d_valid),
    .io_in_d_bits_opcode(monitor_1_io_in_d_bits_opcode),
    .io_in_d_bits_param(monitor_1_io_in_d_bits_param),
    .io_in_d_bits_size(monitor_1_io_in_d_bits_size),
    .io_in_d_bits_source(monitor_1_io_in_d_bits_source),
    .io_in_d_bits_sink(monitor_1_io_in_d_bits_sink),
    .io_in_d_bits_denied(monitor_1_io_in_d_bits_denied),
    .io_in_d_bits_corrupt(monitor_1_io_in_d_bits_corrupt),
    .io_in_e_ready(monitor_1_io_in_e_ready),
    .io_in_e_valid(monitor_1_io_in_e_valid),
    .io_in_e_bits_sink(monitor_1_io_in_e_bits_sink)
  );
  TLMonitor_1 monitor_2 ( // @[Nodes.scala 24:25]
    .clock(monitor_2_clock),
    .reset(monitor_2_reset),
    .io_in_a_ready(monitor_2_io_in_a_ready),
    .io_in_a_valid(monitor_2_io_in_a_valid),
    .io_in_a_bits_opcode(monitor_2_io_in_a_bits_opcode),
    .io_in_a_bits_param(monitor_2_io_in_a_bits_param),
    .io_in_a_bits_size(monitor_2_io_in_a_bits_size),
    .io_in_a_bits_source(monitor_2_io_in_a_bits_source),
    .io_in_a_bits_address(monitor_2_io_in_a_bits_address),
    .io_in_a_bits_mask(monitor_2_io_in_a_bits_mask),
    .io_in_a_bits_corrupt(monitor_2_io_in_a_bits_corrupt),
    .io_in_b_ready(monitor_2_io_in_b_ready),
    .io_in_b_valid(monitor_2_io_in_b_valid),
    .io_in_b_bits_param(monitor_2_io_in_b_bits_param),
    .io_in_b_bits_source(monitor_2_io_in_b_bits_source),
    .io_in_b_bits_address(monitor_2_io_in_b_bits_address),
    .io_in_c_ready(monitor_2_io_in_c_ready),
    .io_in_c_valid(monitor_2_io_in_c_valid),
    .io_in_c_bits_opcode(monitor_2_io_in_c_bits_opcode),
    .io_in_c_bits_param(monitor_2_io_in_c_bits_param),
    .io_in_c_bits_size(monitor_2_io_in_c_bits_size),
    .io_in_c_bits_source(monitor_2_io_in_c_bits_source),
    .io_in_c_bits_address(monitor_2_io_in_c_bits_address),
    .io_in_c_bits_corrupt(monitor_2_io_in_c_bits_corrupt),
    .io_in_d_ready(monitor_2_io_in_d_ready),
    .io_in_d_valid(monitor_2_io_in_d_valid),
    .io_in_d_bits_opcode(monitor_2_io_in_d_bits_opcode),
    .io_in_d_bits_param(monitor_2_io_in_d_bits_param),
    .io_in_d_bits_size(monitor_2_io_in_d_bits_size),
    .io_in_d_bits_source(monitor_2_io_in_d_bits_source),
    .io_in_d_bits_sink(monitor_2_io_in_d_bits_sink),
    .io_in_d_bits_denied(monitor_2_io_in_d_bits_denied),
    .io_in_d_bits_corrupt(monitor_2_io_in_d_bits_corrupt),
    .io_in_e_ready(monitor_2_io_in_e_ready),
    .io_in_e_valid(monitor_2_io_in_e_valid),
    .io_in_e_bits_sink(monitor_2_io_in_e_bits_sink)
  );
  TLMonitor_1 monitor_3 ( // @[Nodes.scala 24:25]
    .clock(monitor_3_clock),
    .reset(monitor_3_reset),
    .io_in_a_ready(monitor_3_io_in_a_ready),
    .io_in_a_valid(monitor_3_io_in_a_valid),
    .io_in_a_bits_opcode(monitor_3_io_in_a_bits_opcode),
    .io_in_a_bits_param(monitor_3_io_in_a_bits_param),
    .io_in_a_bits_size(monitor_3_io_in_a_bits_size),
    .io_in_a_bits_source(monitor_3_io_in_a_bits_source),
    .io_in_a_bits_address(monitor_3_io_in_a_bits_address),
    .io_in_a_bits_mask(monitor_3_io_in_a_bits_mask),
    .io_in_a_bits_corrupt(monitor_3_io_in_a_bits_corrupt),
    .io_in_b_ready(monitor_3_io_in_b_ready),
    .io_in_b_valid(monitor_3_io_in_b_valid),
    .io_in_b_bits_param(monitor_3_io_in_b_bits_param),
    .io_in_b_bits_source(monitor_3_io_in_b_bits_source),
    .io_in_b_bits_address(monitor_3_io_in_b_bits_address),
    .io_in_c_ready(monitor_3_io_in_c_ready),
    .io_in_c_valid(monitor_3_io_in_c_valid),
    .io_in_c_bits_opcode(monitor_3_io_in_c_bits_opcode),
    .io_in_c_bits_param(monitor_3_io_in_c_bits_param),
    .io_in_c_bits_size(monitor_3_io_in_c_bits_size),
    .io_in_c_bits_source(monitor_3_io_in_c_bits_source),
    .io_in_c_bits_address(monitor_3_io_in_c_bits_address),
    .io_in_c_bits_corrupt(monitor_3_io_in_c_bits_corrupt),
    .io_in_d_ready(monitor_3_io_in_d_ready),
    .io_in_d_valid(monitor_3_io_in_d_valid),
    .io_in_d_bits_opcode(monitor_3_io_in_d_bits_opcode),
    .io_in_d_bits_param(monitor_3_io_in_d_bits_param),
    .io_in_d_bits_size(monitor_3_io_in_d_bits_size),
    .io_in_d_bits_source(monitor_3_io_in_d_bits_source),
    .io_in_d_bits_sink(monitor_3_io_in_d_bits_sink),
    .io_in_d_bits_denied(monitor_3_io_in_d_bits_denied),
    .io_in_d_bits_corrupt(monitor_3_io_in_d_bits_corrupt),
    .io_in_e_ready(monitor_3_io_in_e_ready),
    .io_in_e_valid(monitor_3_io_in_e_valid),
    .io_in_e_bits_sink(monitor_3_io_in_e_bits_sink)
  );
  TLMonitor_1 monitor_4 ( // @[Nodes.scala 24:25]
    .clock(monitor_4_clock),
    .reset(monitor_4_reset),
    .io_in_a_ready(monitor_4_io_in_a_ready),
    .io_in_a_valid(monitor_4_io_in_a_valid),
    .io_in_a_bits_opcode(monitor_4_io_in_a_bits_opcode),
    .io_in_a_bits_param(monitor_4_io_in_a_bits_param),
    .io_in_a_bits_size(monitor_4_io_in_a_bits_size),
    .io_in_a_bits_source(monitor_4_io_in_a_bits_source),
    .io_in_a_bits_address(monitor_4_io_in_a_bits_address),
    .io_in_a_bits_mask(monitor_4_io_in_a_bits_mask),
    .io_in_a_bits_corrupt(monitor_4_io_in_a_bits_corrupt),
    .io_in_b_ready(monitor_4_io_in_b_ready),
    .io_in_b_valid(monitor_4_io_in_b_valid),
    .io_in_b_bits_param(monitor_4_io_in_b_bits_param),
    .io_in_b_bits_source(monitor_4_io_in_b_bits_source),
    .io_in_b_bits_address(monitor_4_io_in_b_bits_address),
    .io_in_c_ready(monitor_4_io_in_c_ready),
    .io_in_c_valid(monitor_4_io_in_c_valid),
    .io_in_c_bits_opcode(monitor_4_io_in_c_bits_opcode),
    .io_in_c_bits_param(monitor_4_io_in_c_bits_param),
    .io_in_c_bits_size(monitor_4_io_in_c_bits_size),
    .io_in_c_bits_source(monitor_4_io_in_c_bits_source),
    .io_in_c_bits_address(monitor_4_io_in_c_bits_address),
    .io_in_c_bits_corrupt(monitor_4_io_in_c_bits_corrupt),
    .io_in_d_ready(monitor_4_io_in_d_ready),
    .io_in_d_valid(monitor_4_io_in_d_valid),
    .io_in_d_bits_opcode(monitor_4_io_in_d_bits_opcode),
    .io_in_d_bits_param(monitor_4_io_in_d_bits_param),
    .io_in_d_bits_size(monitor_4_io_in_d_bits_size),
    .io_in_d_bits_source(monitor_4_io_in_d_bits_source),
    .io_in_d_bits_sink(monitor_4_io_in_d_bits_sink),
    .io_in_d_bits_denied(monitor_4_io_in_d_bits_denied),
    .io_in_d_bits_corrupt(monitor_4_io_in_d_bits_corrupt),
    .io_in_e_ready(monitor_4_io_in_e_ready),
    .io_in_e_valid(monitor_4_io_in_e_valid),
    .io_in_e_bits_sink(monitor_4_io_in_e_bits_sink)
  );
  assign auto_in_4_a_ready = requestAIO_4_0 & portsAOI_filtered_4_0_ready | requestAIO_4_1 & portsAOI_filtered_4_1_ready
     | requestAIO_4_2 & portsAOI_filtered_4_2_ready; // @[Mux.scala 27:72]
  assign auto_in_4_b_valid = auto_out_1_b_valid & requestBOI_1_4; // @[Xbar.scala 179:40]
  assign auto_in_4_b_bits_param = auto_out_1_b_bits_param; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_4_b_bits_source = auto_out_1_b_bits_source[1:0]; // @[Xbar.scala 228:69]
  assign auto_in_4_b_bits_address = auto_out_1_b_bits_address; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_4_c_ready = auto_out_1_c_ready & allowed_2_3; // @[Arbiter.scala 123:31]
  assign auto_in_4_d_valid = idle_9 ? _T_1038 : _sink_ACancel_earlyValid_T_60; // @[Arbiter.scala 125:29]
  assign auto_in_4_d_bits_opcode = _T_1093 | _T_1092; // @[Mux.scala 27:72]
  assign auto_in_4_d_bits_param = _T_1085 | _T_1086; // @[Mux.scala 27:72]
  assign auto_in_4_d_bits_size = _T_1083 | _T_1082; // @[Mux.scala 27:72]
  assign auto_in_4_d_bits_source = sink_ACancel_15_bits_source[1:0]; // @[Xbar.scala 228:69]
  assign auto_in_4_d_bits_sink = _T_1070 | _T_1071; // @[Mux.scala 27:72]
  assign auto_in_4_d_bits_denied = muxStateEarly_9_0 & auto_out_0_d_bits_denied | muxStateEarly_9_1 &
    auto_out_1_d_bits_denied | muxStateEarly_9_2 & auto_out_2_d_bits_denied; // @[Mux.scala 27:72]
  assign auto_in_4_d_bits_data = _T_1063 | _T_1062; // @[Mux.scala 27:72]
  assign auto_in_4_d_bits_corrupt = muxStateEarly_9_0 & auto_out_0_d_bits_corrupt | muxStateEarly_9_1 &
    auto_out_1_d_bits_corrupt | muxStateEarly_9_2 & auto_out_2_d_bits_corrupt; // @[Mux.scala 27:72]
  assign auto_in_4_e_ready = idle_3 ? readys_3_3 : state_3_3; // @[Arbiter.scala 121:24]
  assign auto_in_3_a_ready = requestAIO_3_0 & portsAOI_filtered_3_0_ready | requestAIO_3_1 & portsAOI_filtered_3_1_ready
     | requestAIO_3_2 & portsAOI_filtered_3_2_ready; // @[Mux.scala 27:72]
  assign auto_in_3_b_valid = auto_out_1_b_valid & requestBOI_1_3; // @[Xbar.scala 179:40]
  assign auto_in_3_b_bits_param = auto_out_1_b_bits_param; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_3_b_bits_source = auto_out_1_b_bits_source[1:0]; // @[Xbar.scala 228:69]
  assign auto_in_3_b_bits_address = auto_out_1_b_bits_address; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_3_c_ready = auto_out_1_c_ready & allowed_2_2; // @[Arbiter.scala 123:31]
  assign auto_in_3_d_valid = idle_8 ? _T_966 : _sink_ACancel_earlyValid_T_52; // @[Arbiter.scala 125:29]
  assign auto_in_3_d_bits_opcode = _T_1021 | _T_1020; // @[Mux.scala 27:72]
  assign auto_in_3_d_bits_param = _T_1013 | _T_1014; // @[Mux.scala 27:72]
  assign auto_in_3_d_bits_size = _T_1011 | _T_1010; // @[Mux.scala 27:72]
  assign auto_in_3_d_bits_source = sink_ACancel_13_bits_source[1:0]; // @[Xbar.scala 228:69]
  assign auto_in_3_d_bits_sink = _T_998 | _T_999; // @[Mux.scala 27:72]
  assign auto_in_3_d_bits_denied = muxStateEarly_8_0 & auto_out_0_d_bits_denied | muxStateEarly_8_1 &
    auto_out_1_d_bits_denied | muxStateEarly_8_2 & auto_out_2_d_bits_denied; // @[Mux.scala 27:72]
  assign auto_in_3_d_bits_data = _T_991 | _T_990; // @[Mux.scala 27:72]
  assign auto_in_3_d_bits_corrupt = muxStateEarly_8_0 & auto_out_0_d_bits_corrupt | muxStateEarly_8_1 &
    auto_out_1_d_bits_corrupt | muxStateEarly_8_2 & auto_out_2_d_bits_corrupt; // @[Mux.scala 27:72]
  assign auto_in_3_e_ready = idle_3 ? readys_3_2 : state_3_2; // @[Arbiter.scala 121:24]
  assign auto_in_2_a_ready = requestAIO_2_0 & portsAOI_filtered_2_0_ready | requestAIO_2_1 & portsAOI_filtered_2_1_ready
     | requestAIO_2_2 & portsAOI_filtered_2_2_ready; // @[Mux.scala 27:72]
  assign auto_in_2_b_valid = auto_out_1_b_valid & requestBOI_1_2; // @[Xbar.scala 179:40]
  assign auto_in_2_b_bits_param = auto_out_1_b_bits_param; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_2_b_bits_source = auto_out_1_b_bits_source[1:0]; // @[Xbar.scala 228:69]
  assign auto_in_2_b_bits_address = auto_out_1_b_bits_address; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_2_c_ready = auto_out_1_c_ready & allowed_2_1; // @[Arbiter.scala 123:31]
  assign auto_in_2_d_valid = idle_7 ? _T_894 : _sink_ACancel_earlyValid_T_44; // @[Arbiter.scala 125:29]
  assign auto_in_2_d_bits_opcode = _T_949 | _T_948; // @[Mux.scala 27:72]
  assign auto_in_2_d_bits_param = _T_941 | _T_942; // @[Mux.scala 27:72]
  assign auto_in_2_d_bits_size = _T_939 | _T_938; // @[Mux.scala 27:72]
  assign auto_in_2_d_bits_source = sink_ACancel_11_bits_source[1:0]; // @[Xbar.scala 228:69]
  assign auto_in_2_d_bits_sink = _T_926 | _T_927; // @[Mux.scala 27:72]
  assign auto_in_2_d_bits_denied = muxStateEarly_7_0 & auto_out_0_d_bits_denied | muxStateEarly_7_1 &
    auto_out_1_d_bits_denied | muxStateEarly_7_2 & auto_out_2_d_bits_denied; // @[Mux.scala 27:72]
  assign auto_in_2_d_bits_data = _T_919 | _T_918; // @[Mux.scala 27:72]
  assign auto_in_2_d_bits_corrupt = muxStateEarly_7_0 & auto_out_0_d_bits_corrupt | muxStateEarly_7_1 &
    auto_out_1_d_bits_corrupt | muxStateEarly_7_2 & auto_out_2_d_bits_corrupt; // @[Mux.scala 27:72]
  assign auto_in_2_e_ready = idle_3 ? readys_3_1 : state_3_1; // @[Arbiter.scala 121:24]
  assign auto_in_1_a_ready = requestAIO_1_0 & portsAOI_filtered_1_0_ready | requestAIO_1_1 & portsAOI_filtered_1_1_ready
     | requestAIO_1_2 & portsAOI_filtered_1_2_ready; // @[Mux.scala 27:72]
  assign auto_in_1_b_valid = auto_out_1_b_valid & requestBOI_1_1; // @[Xbar.scala 179:40]
  assign auto_in_1_b_bits_param = auto_out_1_b_bits_param; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_1_b_bits_source = auto_out_1_b_bits_source[1:0]; // @[Xbar.scala 228:69]
  assign auto_in_1_b_bits_address = auto_out_1_b_bits_address; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_1_c_ready = auto_out_1_c_ready & allowed_2_0; // @[Arbiter.scala 123:31]
  assign auto_in_1_d_valid = idle_6 ? _T_822 : _sink_ACancel_earlyValid_T_36; // @[Arbiter.scala 125:29]
  assign auto_in_1_d_bits_opcode = _T_877 | _T_876; // @[Mux.scala 27:72]
  assign auto_in_1_d_bits_param = _T_869 | _T_870; // @[Mux.scala 27:72]
  assign auto_in_1_d_bits_size = _T_867 | _T_866; // @[Mux.scala 27:72]
  assign auto_in_1_d_bits_source = sink_ACancel_9_bits_source[1:0]; // @[Xbar.scala 228:69]
  assign auto_in_1_d_bits_sink = _T_854 | _T_855; // @[Mux.scala 27:72]
  assign auto_in_1_d_bits_denied = muxStateEarly_6_0 & auto_out_0_d_bits_denied | muxStateEarly_6_1 &
    auto_out_1_d_bits_denied | muxStateEarly_6_2 & auto_out_2_d_bits_denied; // @[Mux.scala 27:72]
  assign auto_in_1_d_bits_data = _T_847 | _T_846; // @[Mux.scala 27:72]
  assign auto_in_1_d_bits_corrupt = muxStateEarly_6_0 & auto_out_0_d_bits_corrupt | muxStateEarly_6_1 &
    auto_out_1_d_bits_corrupt | muxStateEarly_6_2 & auto_out_2_d_bits_corrupt; // @[Mux.scala 27:72]
  assign auto_in_1_e_ready = idle_3 ? readys_3_0 : state_3_0; // @[Arbiter.scala 121:24]
  assign auto_in_0_a_ready = requestAIO_0_0 & portsAOI_filtered__0_ready | requestAIO_0_1 & portsAOI_filtered__1_ready
     | requestAIO_0_2 & portsAOI_filtered__2_ready; // @[Mux.scala 27:72]
  assign auto_in_0_d_valid = idle_5 ? _T_750 : _sink_ACancel_earlyValid_T_28; // @[Arbiter.scala 125:29]
  assign auto_in_0_d_bits_opcode = _T_805 | _T_804; // @[Mux.scala 27:72]
  assign auto_in_0_d_bits_param = _T_797 | _T_798; // @[Mux.scala 27:72]
  assign auto_in_0_d_bits_size = _T_795 | _T_794; // @[Mux.scala 27:72]
  assign auto_in_0_d_bits_source = sink_ACancel_7_bits_source[3:0]; // @[Xbar.scala 228:69]
  assign auto_in_0_d_bits_sink = _T_782 | _T_783; // @[Mux.scala 27:72]
  assign auto_in_0_d_bits_denied = muxStateEarly_5_0 & auto_out_0_d_bits_denied | muxStateEarly_5_1 &
    auto_out_1_d_bits_denied | muxStateEarly_5_2 & auto_out_2_d_bits_denied; // @[Mux.scala 27:72]
  assign auto_in_0_d_bits_data = _T_775 | _T_774; // @[Mux.scala 27:72]
  assign auto_in_0_d_bits_corrupt = muxStateEarly_5_0 & auto_out_0_d_bits_corrupt | muxStateEarly_5_1 &
    auto_out_1_d_bits_corrupt | muxStateEarly_5_2 & auto_out_2_d_bits_corrupt; // @[Mux.scala 27:72]
  assign auto_out_2_a_valid = idle_4 ? _T_577 : _out_2_a_earlyValid_T_12; // @[Arbiter.scala 125:29]
  assign auto_out_2_a_bits_opcode = _T_733 | _T_730; // @[Mux.scala 27:72]
  assign auto_out_2_a_bits_param = _T_724 | _T_721; // @[Mux.scala 27:72]
  assign auto_out_2_a_bits_size = _T_715 | _T_712; // @[Mux.scala 27:72]
  assign auto_out_2_a_bits_source = _T_706 | _T_703; // @[Mux.scala 27:72]
  assign auto_out_2_a_bits_address = out_5_2_a_bits_address[30:0]; // @[Xbar.scala 132:50 BundleMap.scala 247:19]
  assign auto_out_2_a_bits_user_amba_prot_bufferable = muxStateEarly_4_0 & auto_in_0_a_bits_user_amba_prot_bufferable; // @[Mux.scala 27:72]
  assign auto_out_2_a_bits_user_amba_prot_modifiable = muxStateEarly_4_0 & auto_in_0_a_bits_user_amba_prot_modifiable; // @[Mux.scala 27:72]
  assign auto_out_2_a_bits_user_amba_prot_readalloc = muxStateEarly_4_0 & auto_in_0_a_bits_user_amba_prot_readalloc; // @[Mux.scala 27:72]
  assign auto_out_2_a_bits_user_amba_prot_writealloc = muxStateEarly_4_0 & auto_in_0_a_bits_user_amba_prot_writealloc; // @[Mux.scala 27:72]
  assign auto_out_2_a_bits_user_amba_prot_privileged = muxStateEarly_4_0 & auto_in_0_a_bits_user_amba_prot_privileged |
    muxStateEarly_4_1 | muxStateEarly_4_2 | muxStateEarly_4_3 | muxStateEarly_4_4; // @[Mux.scala 27:72]
  assign auto_out_2_a_bits_user_amba_prot_secure = muxStateEarly_4_0 & auto_in_0_a_bits_user_amba_prot_secure |
    muxStateEarly_4_1 | muxStateEarly_4_2 | muxStateEarly_4_3 | muxStateEarly_4_4; // @[Mux.scala 27:72]
  assign auto_out_2_a_bits_user_amba_prot_fetch = muxStateEarly_4_0 & auto_in_0_a_bits_user_amba_prot_fetch; // @[Mux.scala 27:72]
  assign auto_out_2_a_bits_mask = _T_625 | _T_622; // @[Mux.scala 27:72]
  assign auto_out_2_a_bits_data = _T_616 | _T_613; // @[Mux.scala 27:72]
  assign auto_out_2_a_bits_corrupt = muxStateEarly_4_0 & auto_in_0_a_bits_corrupt | muxStateEarly_4_1 &
    auto_in_1_a_bits_corrupt | muxStateEarly_4_2 & auto_in_2_a_bits_corrupt | muxStateEarly_4_3 &
    auto_in_3_a_bits_corrupt | muxStateEarly_4_4 & auto_in_4_a_bits_corrupt; // @[Mux.scala 27:72]
  assign auto_out_2_d_ready = requestDOI_2_0 & out_23_ready | requestDOI_2_1 & out_29_ready | requestDOI_2_2 &
    out_35_ready | requestDOI_2_3 & out_41_ready | requestDOI_2_4 & out_47_ready; // @[Mux.scala 27:72]
  assign auto_out_1_a_valid = idle_1 ? _T_209 : _out_1_a_earlyValid_T_12; // @[Arbiter.scala 125:29]
  assign auto_out_1_a_bits_opcode = _T_365 | _T_362; // @[Mux.scala 27:72]
  assign auto_out_1_a_bits_param = _T_356 | _T_353; // @[Mux.scala 27:72]
  assign auto_out_1_a_bits_size = out_5_1_a_bits_size[2:0]; // @[Xbar.scala 132:50 BundleMap.scala 247:19]
  assign auto_out_1_a_bits_source = _T_338 | _T_335; // @[Mux.scala 27:72]
  assign auto_out_1_a_bits_address = _T_329 | _T_326; // @[Mux.scala 27:72]
  assign auto_out_1_a_bits_user_amba_prot_bufferable = muxStateEarly_1_0 & auto_in_0_a_bits_user_amba_prot_bufferable; // @[Mux.scala 27:72]
  assign auto_out_1_a_bits_user_amba_prot_modifiable = muxStateEarly_1_0 & auto_in_0_a_bits_user_amba_prot_modifiable; // @[Mux.scala 27:72]
  assign auto_out_1_a_bits_user_amba_prot_readalloc = muxStateEarly_1_0 & auto_in_0_a_bits_user_amba_prot_readalloc; // @[Mux.scala 27:72]
  assign auto_out_1_a_bits_user_amba_prot_writealloc = muxStateEarly_1_0 & auto_in_0_a_bits_user_amba_prot_writealloc; // @[Mux.scala 27:72]
  assign auto_out_1_a_bits_user_amba_prot_privileged = muxStateEarly_1_0 & auto_in_0_a_bits_user_amba_prot_privileged |
    muxStateEarly_1_1 | muxStateEarly_1_2 | muxStateEarly_1_3 | muxStateEarly_1_4; // @[Mux.scala 27:72]
  assign auto_out_1_a_bits_user_amba_prot_secure = muxStateEarly_1_0 & auto_in_0_a_bits_user_amba_prot_secure |
    muxStateEarly_1_1 | muxStateEarly_1_2 | muxStateEarly_1_3 | muxStateEarly_1_4; // @[Mux.scala 27:72]
  assign auto_out_1_a_bits_user_amba_prot_fetch = muxStateEarly_1_0 & auto_in_0_a_bits_user_amba_prot_fetch; // @[Mux.scala 27:72]
  assign auto_out_1_a_bits_mask = _T_257 | _T_254; // @[Mux.scala 27:72]
  assign auto_out_1_a_bits_data = _T_248 | _T_245; // @[Mux.scala 27:72]
  assign auto_out_1_a_bits_corrupt = muxStateEarly_1_0 & auto_in_0_a_bits_corrupt | muxStateEarly_1_1 &
    auto_in_1_a_bits_corrupt | muxStateEarly_1_2 & auto_in_2_a_bits_corrupt | muxStateEarly_1_3 &
    auto_in_3_a_bits_corrupt | muxStateEarly_1_4 & auto_in_4_a_bits_corrupt; // @[Mux.scala 27:72]
  assign auto_out_1_b_ready = requestBOI_1_1 & auto_in_1_b_ready | requestBOI_1_2 & auto_in_2_b_ready | requestBOI_1_3
     & auto_in_3_b_ready | requestBOI_1_4 & auto_in_4_b_ready; // @[Mux.scala 27:72]
  assign auto_out_1_c_valid = idle_2 ? _T_387 : _sink_ACancel_earlyValid_T_9; // @[Arbiter.scala 125:29]
  assign auto_out_1_c_bits_opcode = _T_503 | _T_501; // @[Mux.scala 27:72]
  assign auto_out_1_c_bits_param = _T_496 | _T_494; // @[Mux.scala 27:72]
  assign auto_out_1_c_bits_size = sink_ACancel_2_bits_size[2:0]; // @[Xbar.scala 132:50 BundleMap.scala 247:19]
  assign auto_out_1_c_bits_source = _T_482 | _T_480; // @[Mux.scala 27:72]
  assign auto_out_1_c_bits_address = _T_475 | _T_473; // @[Mux.scala 27:72]
  assign auto_out_1_c_bits_data = _T_419 | _T_417; // @[Mux.scala 27:72]
  assign auto_out_1_c_bits_corrupt = muxStateEarly_2_0 & auto_in_1_c_bits_corrupt | muxStateEarly_2_1 &
    auto_in_2_c_bits_corrupt | muxStateEarly_2_2 & auto_in_3_c_bits_corrupt | muxStateEarly_2_3 &
    auto_in_4_c_bits_corrupt; // @[Mux.scala 27:72]
  assign auto_out_1_d_ready = requestDOI_1_0 & out_22_ready | requestDOI_1_1 & out_28_ready | requestDOI_1_2 &
    out_34_ready | requestDOI_1_3 & out_40_ready | requestDOI_1_4 & out_46_ready; // @[Mux.scala 27:72]
  assign auto_out_1_e_valid = idle_3 ? _T_525 : _sink_ACancel_earlyValid_T_20; // @[Arbiter.scala 125:29]
  assign auto_out_1_e_bits_sink = _T_550 | _T_548; // @[Mux.scala 27:72]
  assign auto_out_0_a_valid = idle ? _T_26 : _out_0_a_earlyValid_T_12; // @[Arbiter.scala 125:29]
  assign auto_out_0_a_bits_opcode = _T_182 | _T_179; // @[Mux.scala 27:72]
  assign auto_out_0_a_bits_param = _T_173 | _T_170; // @[Mux.scala 27:72]
  assign auto_out_0_a_bits_size = _T_164 | _T_161; // @[Mux.scala 27:72]
  assign auto_out_0_a_bits_source = _T_155 | _T_152; // @[Mux.scala 27:72]
  assign auto_out_0_a_bits_address = out_5_0_a_bits_address[27:0]; // @[Xbar.scala 132:50 BundleMap.scala 247:19]
  assign auto_out_0_a_bits_mask = _T_74 | _T_71; // @[Mux.scala 27:72]
  assign auto_out_0_a_bits_data = _T_65 | _T_62; // @[Mux.scala 27:72]
  assign auto_out_0_a_bits_corrupt = muxStateEarly__0 & auto_in_0_a_bits_corrupt | muxStateEarly__1 &
    auto_in_1_a_bits_corrupt | muxStateEarly__2 & auto_in_2_a_bits_corrupt | muxStateEarly__3 & auto_in_3_a_bits_corrupt
     | muxStateEarly__4 & auto_in_4_a_bits_corrupt; // @[Mux.scala 27:72]
  assign auto_out_0_d_ready = requestDOI_0_0 & out_21_ready | requestDOI_0_1 & out_27_ready | requestDOI_0_2 &
    out_33_ready | requestDOI_0_3 & out_39_ready | requestDOI_0_4 & out_45_ready; // @[Mux.scala 27:72]
  assign monitor_clock = clock;
  assign monitor_reset = reset;
  assign monitor_io_in_a_ready = requestAIO_0_0 & portsAOI_filtered__0_ready | requestAIO_0_1 &
    portsAOI_filtered__1_ready | requestAIO_0_2 & portsAOI_filtered__2_ready; // @[Mux.scala 27:72]
  assign monitor_io_in_a_valid = auto_in_0_a_valid; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_io_in_a_bits_opcode = auto_in_0_a_bits_opcode; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_io_in_a_bits_param = auto_in_0_a_bits_param; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_io_in_a_bits_size = auto_in_0_a_bits_size; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_io_in_a_bits_source = auto_in_0_a_bits_source; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_io_in_a_bits_address = auto_in_0_a_bits_address; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_io_in_a_bits_mask = auto_in_0_a_bits_mask; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_io_in_a_bits_corrupt = auto_in_0_a_bits_corrupt; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_io_in_d_ready = auto_in_0_d_ready; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_io_in_d_valid = idle_5 ? _T_750 : _sink_ACancel_earlyValid_T_28; // @[Arbiter.scala 125:29]
  assign monitor_io_in_d_bits_opcode = _T_805 | _T_804; // @[Mux.scala 27:72]
  assign monitor_io_in_d_bits_param = _T_797 | _T_798; // @[Mux.scala 27:72]
  assign monitor_io_in_d_bits_size = _T_795 | _T_794; // @[Mux.scala 27:72]
  assign monitor_io_in_d_bits_source = sink_ACancel_7_bits_source[3:0]; // @[Xbar.scala 228:69]
  assign monitor_io_in_d_bits_sink = _T_782 | _T_783; // @[Mux.scala 27:72]
  assign monitor_io_in_d_bits_denied = muxStateEarly_5_0 & auto_out_0_d_bits_denied | muxStateEarly_5_1 &
    auto_out_1_d_bits_denied | muxStateEarly_5_2 & auto_out_2_d_bits_denied; // @[Mux.scala 27:72]
  assign monitor_io_in_d_bits_corrupt = muxStateEarly_5_0 & auto_out_0_d_bits_corrupt | muxStateEarly_5_1 &
    auto_out_1_d_bits_corrupt | muxStateEarly_5_2 & auto_out_2_d_bits_corrupt; // @[Mux.scala 27:72]
  assign monitor_1_clock = clock;
  assign monitor_1_reset = reset;
  assign monitor_1_io_in_a_ready = requestAIO_1_0 & portsAOI_filtered_1_0_ready | requestAIO_1_1 &
    portsAOI_filtered_1_1_ready | requestAIO_1_2 & portsAOI_filtered_1_2_ready; // @[Mux.scala 27:72]
  assign monitor_1_io_in_a_valid = auto_in_1_a_valid; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_1_io_in_a_bits_opcode = auto_in_1_a_bits_opcode; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_1_io_in_a_bits_param = auto_in_1_a_bits_param; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_1_io_in_a_bits_size = auto_in_1_a_bits_size; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_1_io_in_a_bits_source = auto_in_1_a_bits_source; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_1_io_in_a_bits_address = auto_in_1_a_bits_address; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_1_io_in_a_bits_mask = auto_in_1_a_bits_mask; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_1_io_in_a_bits_corrupt = auto_in_1_a_bits_corrupt; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_1_io_in_b_ready = auto_in_1_b_ready; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_1_io_in_b_valid = auto_out_1_b_valid & requestBOI_1_1; // @[Xbar.scala 179:40]
  assign monitor_1_io_in_b_bits_param = auto_out_1_b_bits_param; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign monitor_1_io_in_b_bits_source = auto_out_1_b_bits_source[1:0]; // @[Xbar.scala 228:69]
  assign monitor_1_io_in_b_bits_address = auto_out_1_b_bits_address; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign monitor_1_io_in_c_ready = auto_out_1_c_ready & allowed_2_0; // @[Arbiter.scala 123:31]
  assign monitor_1_io_in_c_valid = auto_in_1_c_valid; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_1_io_in_c_bits_opcode = auto_in_1_c_bits_opcode; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_1_io_in_c_bits_param = auto_in_1_c_bits_param; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_1_io_in_c_bits_size = auto_in_1_c_bits_size; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_1_io_in_c_bits_source = auto_in_1_c_bits_source; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_1_io_in_c_bits_address = auto_in_1_c_bits_address; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_1_io_in_c_bits_corrupt = auto_in_1_c_bits_corrupt; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_1_io_in_d_ready = auto_in_1_d_ready; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_1_io_in_d_valid = idle_6 ? _T_822 : _sink_ACancel_earlyValid_T_36; // @[Arbiter.scala 125:29]
  assign monitor_1_io_in_d_bits_opcode = _T_877 | _T_876; // @[Mux.scala 27:72]
  assign monitor_1_io_in_d_bits_param = _T_869 | _T_870; // @[Mux.scala 27:72]
  assign monitor_1_io_in_d_bits_size = _T_867 | _T_866; // @[Mux.scala 27:72]
  assign monitor_1_io_in_d_bits_source = sink_ACancel_9_bits_source[1:0]; // @[Xbar.scala 228:69]
  assign monitor_1_io_in_d_bits_sink = _T_854 | _T_855; // @[Mux.scala 27:72]
  assign monitor_1_io_in_d_bits_denied = muxStateEarly_6_0 & auto_out_0_d_bits_denied | muxStateEarly_6_1 &
    auto_out_1_d_bits_denied | muxStateEarly_6_2 & auto_out_2_d_bits_denied; // @[Mux.scala 27:72]
  assign monitor_1_io_in_d_bits_corrupt = muxStateEarly_6_0 & auto_out_0_d_bits_corrupt | muxStateEarly_6_1 &
    auto_out_1_d_bits_corrupt | muxStateEarly_6_2 & auto_out_2_d_bits_corrupt; // @[Mux.scala 27:72]
  assign monitor_1_io_in_e_ready = idle_3 ? readys_3_0 : state_3_0; // @[Arbiter.scala 121:24]
  assign monitor_1_io_in_e_valid = auto_in_1_e_valid; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_1_io_in_e_bits_sink = auto_in_1_e_bits_sink; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_2_clock = clock;
  assign monitor_2_reset = reset;
  assign monitor_2_io_in_a_ready = requestAIO_2_0 & portsAOI_filtered_2_0_ready | requestAIO_2_1 &
    portsAOI_filtered_2_1_ready | requestAIO_2_2 & portsAOI_filtered_2_2_ready; // @[Mux.scala 27:72]
  assign monitor_2_io_in_a_valid = auto_in_2_a_valid; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_2_io_in_a_bits_opcode = auto_in_2_a_bits_opcode; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_2_io_in_a_bits_param = auto_in_2_a_bits_param; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_2_io_in_a_bits_size = auto_in_2_a_bits_size; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_2_io_in_a_bits_source = auto_in_2_a_bits_source; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_2_io_in_a_bits_address = auto_in_2_a_bits_address; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_2_io_in_a_bits_mask = auto_in_2_a_bits_mask; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_2_io_in_a_bits_corrupt = auto_in_2_a_bits_corrupt; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_2_io_in_b_ready = auto_in_2_b_ready; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_2_io_in_b_valid = auto_out_1_b_valid & requestBOI_1_2; // @[Xbar.scala 179:40]
  assign monitor_2_io_in_b_bits_param = auto_out_1_b_bits_param; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign monitor_2_io_in_b_bits_source = auto_out_1_b_bits_source[1:0]; // @[Xbar.scala 228:69]
  assign monitor_2_io_in_b_bits_address = auto_out_1_b_bits_address; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign monitor_2_io_in_c_ready = auto_out_1_c_ready & allowed_2_1; // @[Arbiter.scala 123:31]
  assign monitor_2_io_in_c_valid = auto_in_2_c_valid; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_2_io_in_c_bits_opcode = auto_in_2_c_bits_opcode; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_2_io_in_c_bits_param = auto_in_2_c_bits_param; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_2_io_in_c_bits_size = auto_in_2_c_bits_size; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_2_io_in_c_bits_source = auto_in_2_c_bits_source; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_2_io_in_c_bits_address = auto_in_2_c_bits_address; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_2_io_in_c_bits_corrupt = auto_in_2_c_bits_corrupt; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_2_io_in_d_ready = auto_in_2_d_ready; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_2_io_in_d_valid = idle_7 ? _T_894 : _sink_ACancel_earlyValid_T_44; // @[Arbiter.scala 125:29]
  assign monitor_2_io_in_d_bits_opcode = _T_949 | _T_948; // @[Mux.scala 27:72]
  assign monitor_2_io_in_d_bits_param = _T_941 | _T_942; // @[Mux.scala 27:72]
  assign monitor_2_io_in_d_bits_size = _T_939 | _T_938; // @[Mux.scala 27:72]
  assign monitor_2_io_in_d_bits_source = sink_ACancel_11_bits_source[1:0]; // @[Xbar.scala 228:69]
  assign monitor_2_io_in_d_bits_sink = _T_926 | _T_927; // @[Mux.scala 27:72]
  assign monitor_2_io_in_d_bits_denied = muxStateEarly_7_0 & auto_out_0_d_bits_denied | muxStateEarly_7_1 &
    auto_out_1_d_bits_denied | muxStateEarly_7_2 & auto_out_2_d_bits_denied; // @[Mux.scala 27:72]
  assign monitor_2_io_in_d_bits_corrupt = muxStateEarly_7_0 & auto_out_0_d_bits_corrupt | muxStateEarly_7_1 &
    auto_out_1_d_bits_corrupt | muxStateEarly_7_2 & auto_out_2_d_bits_corrupt; // @[Mux.scala 27:72]
  assign monitor_2_io_in_e_ready = idle_3 ? readys_3_1 : state_3_1; // @[Arbiter.scala 121:24]
  assign monitor_2_io_in_e_valid = auto_in_2_e_valid; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_2_io_in_e_bits_sink = auto_in_2_e_bits_sink; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_3_clock = clock;
  assign monitor_3_reset = reset;
  assign monitor_3_io_in_a_ready = requestAIO_3_0 & portsAOI_filtered_3_0_ready | requestAIO_3_1 &
    portsAOI_filtered_3_1_ready | requestAIO_3_2 & portsAOI_filtered_3_2_ready; // @[Mux.scala 27:72]
  assign monitor_3_io_in_a_valid = auto_in_3_a_valid; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_3_io_in_a_bits_opcode = auto_in_3_a_bits_opcode; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_3_io_in_a_bits_param = auto_in_3_a_bits_param; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_3_io_in_a_bits_size = auto_in_3_a_bits_size; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_3_io_in_a_bits_source = auto_in_3_a_bits_source; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_3_io_in_a_bits_address = auto_in_3_a_bits_address; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_3_io_in_a_bits_mask = auto_in_3_a_bits_mask; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_3_io_in_a_bits_corrupt = auto_in_3_a_bits_corrupt; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_3_io_in_b_ready = auto_in_3_b_ready; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_3_io_in_b_valid = auto_out_1_b_valid & requestBOI_1_3; // @[Xbar.scala 179:40]
  assign monitor_3_io_in_b_bits_param = auto_out_1_b_bits_param; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign monitor_3_io_in_b_bits_source = auto_out_1_b_bits_source[1:0]; // @[Xbar.scala 228:69]
  assign monitor_3_io_in_b_bits_address = auto_out_1_b_bits_address; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign monitor_3_io_in_c_ready = auto_out_1_c_ready & allowed_2_2; // @[Arbiter.scala 123:31]
  assign monitor_3_io_in_c_valid = auto_in_3_c_valid; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_3_io_in_c_bits_opcode = auto_in_3_c_bits_opcode; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_3_io_in_c_bits_param = auto_in_3_c_bits_param; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_3_io_in_c_bits_size = auto_in_3_c_bits_size; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_3_io_in_c_bits_source = auto_in_3_c_bits_source; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_3_io_in_c_bits_address = auto_in_3_c_bits_address; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_3_io_in_c_bits_corrupt = auto_in_3_c_bits_corrupt; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_3_io_in_d_ready = auto_in_3_d_ready; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_3_io_in_d_valid = idle_8 ? _T_966 : _sink_ACancel_earlyValid_T_52; // @[Arbiter.scala 125:29]
  assign monitor_3_io_in_d_bits_opcode = _T_1021 | _T_1020; // @[Mux.scala 27:72]
  assign monitor_3_io_in_d_bits_param = _T_1013 | _T_1014; // @[Mux.scala 27:72]
  assign monitor_3_io_in_d_bits_size = _T_1011 | _T_1010; // @[Mux.scala 27:72]
  assign monitor_3_io_in_d_bits_source = sink_ACancel_13_bits_source[1:0]; // @[Xbar.scala 228:69]
  assign monitor_3_io_in_d_bits_sink = _T_998 | _T_999; // @[Mux.scala 27:72]
  assign monitor_3_io_in_d_bits_denied = muxStateEarly_8_0 & auto_out_0_d_bits_denied | muxStateEarly_8_1 &
    auto_out_1_d_bits_denied | muxStateEarly_8_2 & auto_out_2_d_bits_denied; // @[Mux.scala 27:72]
  assign monitor_3_io_in_d_bits_corrupt = muxStateEarly_8_0 & auto_out_0_d_bits_corrupt | muxStateEarly_8_1 &
    auto_out_1_d_bits_corrupt | muxStateEarly_8_2 & auto_out_2_d_bits_corrupt; // @[Mux.scala 27:72]
  assign monitor_3_io_in_e_ready = idle_3 ? readys_3_2 : state_3_2; // @[Arbiter.scala 121:24]
  assign monitor_3_io_in_e_valid = auto_in_3_e_valid; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_3_io_in_e_bits_sink = auto_in_3_e_bits_sink; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_4_clock = clock;
  assign monitor_4_reset = reset;
  assign monitor_4_io_in_a_ready = requestAIO_4_0 & portsAOI_filtered_4_0_ready | requestAIO_4_1 &
    portsAOI_filtered_4_1_ready | requestAIO_4_2 & portsAOI_filtered_4_2_ready; // @[Mux.scala 27:72]
  assign monitor_4_io_in_a_valid = auto_in_4_a_valid; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_4_io_in_a_bits_opcode = auto_in_4_a_bits_opcode; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_4_io_in_a_bits_param = auto_in_4_a_bits_param; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_4_io_in_a_bits_size = auto_in_4_a_bits_size; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_4_io_in_a_bits_source = auto_in_4_a_bits_source; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_4_io_in_a_bits_address = auto_in_4_a_bits_address; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_4_io_in_a_bits_mask = auto_in_4_a_bits_mask; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_4_io_in_a_bits_corrupt = auto_in_4_a_bits_corrupt; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_4_io_in_b_ready = auto_in_4_b_ready; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_4_io_in_b_valid = auto_out_1_b_valid & requestBOI_1_4; // @[Xbar.scala 179:40]
  assign monitor_4_io_in_b_bits_param = auto_out_1_b_bits_param; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign monitor_4_io_in_b_bits_source = auto_out_1_b_bits_source[1:0]; // @[Xbar.scala 228:69]
  assign monitor_4_io_in_b_bits_address = auto_out_1_b_bits_address; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign monitor_4_io_in_c_ready = auto_out_1_c_ready & allowed_2_3; // @[Arbiter.scala 123:31]
  assign monitor_4_io_in_c_valid = auto_in_4_c_valid; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_4_io_in_c_bits_opcode = auto_in_4_c_bits_opcode; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_4_io_in_c_bits_param = auto_in_4_c_bits_param; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_4_io_in_c_bits_size = auto_in_4_c_bits_size; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_4_io_in_c_bits_source = auto_in_4_c_bits_source; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_4_io_in_c_bits_address = auto_in_4_c_bits_address; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_4_io_in_c_bits_corrupt = auto_in_4_c_bits_corrupt; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_4_io_in_d_ready = auto_in_4_d_ready; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_4_io_in_d_valid = idle_9 ? _T_1038 : _sink_ACancel_earlyValid_T_60; // @[Arbiter.scala 125:29]
  assign monitor_4_io_in_d_bits_opcode = _T_1093 | _T_1092; // @[Mux.scala 27:72]
  assign monitor_4_io_in_d_bits_param = _T_1085 | _T_1086; // @[Mux.scala 27:72]
  assign monitor_4_io_in_d_bits_size = _T_1083 | _T_1082; // @[Mux.scala 27:72]
  assign monitor_4_io_in_d_bits_source = sink_ACancel_15_bits_source[1:0]; // @[Xbar.scala 228:69]
  assign monitor_4_io_in_d_bits_sink = _T_1070 | _T_1071; // @[Mux.scala 27:72]
  assign monitor_4_io_in_d_bits_denied = muxStateEarly_9_0 & auto_out_0_d_bits_denied | muxStateEarly_9_1 &
    auto_out_1_d_bits_denied | muxStateEarly_9_2 & auto_out_2_d_bits_denied; // @[Mux.scala 27:72]
  assign monitor_4_io_in_d_bits_corrupt = muxStateEarly_9_0 & auto_out_0_d_bits_corrupt | muxStateEarly_9_1 &
    auto_out_1_d_bits_corrupt | muxStateEarly_9_2 & auto_out_2_d_bits_corrupt; // @[Mux.scala 27:72]
  assign monitor_4_io_in_e_ready = idle_3 ? readys_3_3 : state_3_3; // @[Arbiter.scala 121:24]
  assign monitor_4_io_in_e_valid = auto_in_4_e_valid; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_4_io_in_e_bits_sink = auto_in_4_e_bits_sink; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  always @(posedge clock) begin
    if (reset) begin // @[Arbiter.scala 87:30]
      beatsLeft_5 <= 9'h0; // @[Arbiter.scala 87:30]
    end else if (latch_5) begin // @[Arbiter.scala 113:23]
      beatsLeft_5 <= initBeats_5;
    end else begin
      beatsLeft_5 <= _beatsLeft_T_34;
    end
    if (reset) begin // @[Arbiter.scala 23:23]
      readys_mask_5 <= 3'h7; // @[Arbiter.scala 23:23]
    end else if (latch_5 & |readys_filter_lo_5) begin // @[Arbiter.scala 27:32]
      readys_mask_5 <= _readys_mask_T_55; // @[Arbiter.scala 28:12]
    end
    if (reset) begin // @[Arbiter.scala 116:26]
      state_5_0 <= 1'h0; // @[Arbiter.scala 116:26]
    end else if (idle_5) begin // @[Arbiter.scala 117:30]
      state_5_0 <= earlyWinner_5_0;
    end
    if (reset) begin // @[Arbiter.scala 116:26]
      state_5_1 <= 1'h0; // @[Arbiter.scala 116:26]
    end else if (idle_5) begin // @[Arbiter.scala 117:30]
      state_5_1 <= earlyWinner_5_1;
    end
    if (reset) begin // @[Arbiter.scala 116:26]
      state_5_2 <= 1'h0; // @[Arbiter.scala 116:26]
    end else if (idle_5) begin // @[Arbiter.scala 117:30]
      state_5_2 <= earlyWinner_5_2;
    end
    if (reset) begin // @[Arbiter.scala 87:30]
      beatsLeft_6 <= 9'h0; // @[Arbiter.scala 87:30]
    end else if (latch_6) begin // @[Arbiter.scala 113:23]
      beatsLeft_6 <= initBeats_6;
    end else begin
      beatsLeft_6 <= _beatsLeft_T_40;
    end
    if (reset) begin // @[Arbiter.scala 23:23]
      readys_mask_6 <= 3'h7; // @[Arbiter.scala 23:23]
    end else if (latch_6 & |readys_filter_lo_6) begin // @[Arbiter.scala 27:32]
      readys_mask_6 <= _readys_mask_T_63; // @[Arbiter.scala 28:12]
    end
    if (reset) begin // @[Arbiter.scala 116:26]
      state_6_0 <= 1'h0; // @[Arbiter.scala 116:26]
    end else if (idle_6) begin // @[Arbiter.scala 117:30]
      state_6_0 <= earlyWinner_6_0;
    end
    if (reset) begin // @[Arbiter.scala 116:26]
      state_6_1 <= 1'h0; // @[Arbiter.scala 116:26]
    end else if (idle_6) begin // @[Arbiter.scala 117:30]
      state_6_1 <= earlyWinner_6_1;
    end
    if (reset) begin // @[Arbiter.scala 116:26]
      state_6_2 <= 1'h0; // @[Arbiter.scala 116:26]
    end else if (idle_6) begin // @[Arbiter.scala 117:30]
      state_6_2 <= earlyWinner_6_2;
    end
    if (reset) begin // @[Arbiter.scala 87:30]
      beatsLeft_7 <= 9'h0; // @[Arbiter.scala 87:30]
    end else if (latch_7) begin // @[Arbiter.scala 113:23]
      beatsLeft_7 <= initBeats_7;
    end else begin
      beatsLeft_7 <= _beatsLeft_T_46;
    end
    if (reset) begin // @[Arbiter.scala 23:23]
      readys_mask_7 <= 3'h7; // @[Arbiter.scala 23:23]
    end else if (latch_7 & |readys_filter_lo_7) begin // @[Arbiter.scala 27:32]
      readys_mask_7 <= _readys_mask_T_71; // @[Arbiter.scala 28:12]
    end
    if (reset) begin // @[Arbiter.scala 116:26]
      state_7_0 <= 1'h0; // @[Arbiter.scala 116:26]
    end else if (idle_7) begin // @[Arbiter.scala 117:30]
      state_7_0 <= earlyWinner_7_0;
    end
    if (reset) begin // @[Arbiter.scala 116:26]
      state_7_1 <= 1'h0; // @[Arbiter.scala 116:26]
    end else if (idle_7) begin // @[Arbiter.scala 117:30]
      state_7_1 <= earlyWinner_7_1;
    end
    if (reset) begin // @[Arbiter.scala 116:26]
      state_7_2 <= 1'h0; // @[Arbiter.scala 116:26]
    end else if (idle_7) begin // @[Arbiter.scala 117:30]
      state_7_2 <= earlyWinner_7_2;
    end
    if (reset) begin // @[Arbiter.scala 87:30]
      beatsLeft_8 <= 9'h0; // @[Arbiter.scala 87:30]
    end else if (latch_8) begin // @[Arbiter.scala 113:23]
      beatsLeft_8 <= initBeats_8;
    end else begin
      beatsLeft_8 <= _beatsLeft_T_52;
    end
    if (reset) begin // @[Arbiter.scala 23:23]
      readys_mask_8 <= 3'h7; // @[Arbiter.scala 23:23]
    end else if (latch_8 & |readys_filter_lo_8) begin // @[Arbiter.scala 27:32]
      readys_mask_8 <= _readys_mask_T_79; // @[Arbiter.scala 28:12]
    end
    if (reset) begin // @[Arbiter.scala 116:26]
      state_8_0 <= 1'h0; // @[Arbiter.scala 116:26]
    end else if (idle_8) begin // @[Arbiter.scala 117:30]
      state_8_0 <= earlyWinner_8_0;
    end
    if (reset) begin // @[Arbiter.scala 116:26]
      state_8_1 <= 1'h0; // @[Arbiter.scala 116:26]
    end else if (idle_8) begin // @[Arbiter.scala 117:30]
      state_8_1 <= earlyWinner_8_1;
    end
    if (reset) begin // @[Arbiter.scala 116:26]
      state_8_2 <= 1'h0; // @[Arbiter.scala 116:26]
    end else if (idle_8) begin // @[Arbiter.scala 117:30]
      state_8_2 <= earlyWinner_8_2;
    end
    if (reset) begin // @[Arbiter.scala 87:30]
      beatsLeft_9 <= 9'h0; // @[Arbiter.scala 87:30]
    end else if (latch_9) begin // @[Arbiter.scala 113:23]
      beatsLeft_9 <= initBeats_9;
    end else begin
      beatsLeft_9 <= _beatsLeft_T_58;
    end
    if (reset) begin // @[Arbiter.scala 23:23]
      readys_mask_9 <= 3'h7; // @[Arbiter.scala 23:23]
    end else if (latch_9 & |readys_filter_lo_9) begin // @[Arbiter.scala 27:32]
      readys_mask_9 <= _readys_mask_T_87; // @[Arbiter.scala 28:12]
    end
    if (reset) begin // @[Arbiter.scala 116:26]
      state_9_0 <= 1'h0; // @[Arbiter.scala 116:26]
    end else if (idle_9) begin // @[Arbiter.scala 117:30]
      state_9_0 <= earlyWinner_9_0;
    end
    if (reset) begin // @[Arbiter.scala 116:26]
      state_9_1 <= 1'h0; // @[Arbiter.scala 116:26]
    end else if (idle_9) begin // @[Arbiter.scala 117:30]
      state_9_1 <= earlyWinner_9_1;
    end
    if (reset) begin // @[Arbiter.scala 116:26]
      state_9_2 <= 1'h0; // @[Arbiter.scala 116:26]
    end else if (idle_9) begin // @[Arbiter.scala 117:30]
      state_9_2 <= earlyWinner_9_2;
    end
    if (reset) begin // @[Arbiter.scala 87:30]
      beatsLeft_3 <= 1'h0; // @[Arbiter.scala 87:30]
    end else if (idle_3) begin // @[Arbiter.scala 113:23]
      beatsLeft_3 <= 1'h0;
    end else begin
      beatsLeft_3 <= beatsLeft_3 - sink_ACancel_3_earlyValid;
    end
    if (reset) begin // @[Arbiter.scala 23:23]
      readys_mask_3 <= 4'hf; // @[Arbiter.scala 23:23]
    end else if (idle_3 & |readys_filter_lo_3) begin // @[Arbiter.scala 27:32]
      readys_mask_3 <= _readys_mask_T_36; // @[Arbiter.scala 28:12]
    end
    if (reset) begin // @[Arbiter.scala 116:26]
      state_3_0 <= 1'h0; // @[Arbiter.scala 116:26]
    end else if (idle_3) begin // @[Arbiter.scala 117:30]
      state_3_0 <= earlyWinner_3_0;
    end
    if (reset) begin // @[Arbiter.scala 116:26]
      state_3_1 <= 1'h0; // @[Arbiter.scala 116:26]
    end else if (idle_3) begin // @[Arbiter.scala 117:30]
      state_3_1 <= earlyWinner_3_1;
    end
    if (reset) begin // @[Arbiter.scala 116:26]
      state_3_2 <= 1'h0; // @[Arbiter.scala 116:26]
    end else if (idle_3) begin // @[Arbiter.scala 117:30]
      state_3_2 <= earlyWinner_3_2;
    end
    if (reset) begin // @[Arbiter.scala 116:26]
      state_3_3 <= 1'h0; // @[Arbiter.scala 116:26]
    end else if (idle_3) begin // @[Arbiter.scala 117:30]
      state_3_3 <= earlyWinner_3_3;
    end
    if (reset) begin // @[Arbiter.scala 87:30]
      beatsLeft <= 9'h0; // @[Arbiter.scala 87:30]
    end else if (latch) begin // @[Arbiter.scala 113:23]
      beatsLeft <= initBeats;
    end else begin
      beatsLeft <= _beatsLeft_T_4;
    end
    if (reset) begin // @[Arbiter.scala 23:23]
      readys_mask <= 5'h1f; // @[Arbiter.scala 23:23]
    end else if (latch & |readys_filter_lo) begin // @[Arbiter.scala 27:32]
      readys_mask <= _readys_mask_T_9; // @[Arbiter.scala 28:12]
    end
    if (reset) begin // @[Arbiter.scala 116:26]
      state__0 <= 1'h0; // @[Arbiter.scala 116:26]
    end else if (idle) begin // @[Arbiter.scala 117:30]
      state__0 <= earlyWinner__0;
    end
    if (reset) begin // @[Arbiter.scala 87:30]
      beatsLeft_1 <= 9'h0; // @[Arbiter.scala 87:30]
    end else if (latch_1) begin // @[Arbiter.scala 113:23]
      beatsLeft_1 <= initBeats_1;
    end else begin
      beatsLeft_1 <= _beatsLeft_T_10;
    end
    if (reset) begin // @[Arbiter.scala 23:23]
      readys_mask_1 <= 5'h1f; // @[Arbiter.scala 23:23]
    end else if (latch_1 & |readys_filter_lo_1) begin // @[Arbiter.scala 27:32]
      readys_mask_1 <= _readys_mask_T_20; // @[Arbiter.scala 28:12]
    end
    if (reset) begin // @[Arbiter.scala 116:26]
      state_1_0 <= 1'h0; // @[Arbiter.scala 116:26]
    end else if (idle_1) begin // @[Arbiter.scala 117:30]
      state_1_0 <= earlyWinner_1_0;
    end
    if (reset) begin // @[Arbiter.scala 87:30]
      beatsLeft_4 <= 9'h0; // @[Arbiter.scala 87:30]
    end else if (latch_4) begin // @[Arbiter.scala 113:23]
      beatsLeft_4 <= initBeats_4;
    end else begin
      beatsLeft_4 <= _beatsLeft_T_28;
    end
    if (reset) begin // @[Arbiter.scala 23:23]
      readys_mask_4 <= 5'h1f; // @[Arbiter.scala 23:23]
    end else if (latch_4 & |readys_filter_lo_4) begin // @[Arbiter.scala 27:32]
      readys_mask_4 <= _readys_mask_T_47; // @[Arbiter.scala 28:12]
    end
    if (reset) begin // @[Arbiter.scala 116:26]
      state_4_0 <= 1'h0; // @[Arbiter.scala 116:26]
    end else if (idle_4) begin // @[Arbiter.scala 117:30]
      state_4_0 <= earlyWinner_4_0;
    end
    if (reset) begin // @[Arbiter.scala 116:26]
      state__1 <= 1'h0; // @[Arbiter.scala 116:26]
    end else if (idle) begin // @[Arbiter.scala 117:30]
      state__1 <= earlyWinner__1;
    end
    if (reset) begin // @[Arbiter.scala 116:26]
      state_1_1 <= 1'h0; // @[Arbiter.scala 116:26]
    end else if (idle_1) begin // @[Arbiter.scala 117:30]
      state_1_1 <= earlyWinner_1_1;
    end
    if (reset) begin // @[Arbiter.scala 116:26]
      state_4_1 <= 1'h0; // @[Arbiter.scala 116:26]
    end else if (idle_4) begin // @[Arbiter.scala 117:30]
      state_4_1 <= earlyWinner_4_1;
    end
    if (reset) begin // @[Arbiter.scala 116:26]
      state__2 <= 1'h0; // @[Arbiter.scala 116:26]
    end else if (idle) begin // @[Arbiter.scala 117:30]
      state__2 <= earlyWinner__2;
    end
    if (reset) begin // @[Arbiter.scala 116:26]
      state_1_2 <= 1'h0; // @[Arbiter.scala 116:26]
    end else if (idle_1) begin // @[Arbiter.scala 117:30]
      state_1_2 <= earlyWinner_1_2;
    end
    if (reset) begin // @[Arbiter.scala 116:26]
      state_4_2 <= 1'h0; // @[Arbiter.scala 116:26]
    end else if (idle_4) begin // @[Arbiter.scala 117:30]
      state_4_2 <= earlyWinner_4_2;
    end
    if (reset) begin // @[Arbiter.scala 116:26]
      state__3 <= 1'h0; // @[Arbiter.scala 116:26]
    end else if (idle) begin // @[Arbiter.scala 117:30]
      state__3 <= earlyWinner__3;
    end
    if (reset) begin // @[Arbiter.scala 116:26]
      state_1_3 <= 1'h0; // @[Arbiter.scala 116:26]
    end else if (idle_1) begin // @[Arbiter.scala 117:30]
      state_1_3 <= earlyWinner_1_3;
    end
    if (reset) begin // @[Arbiter.scala 116:26]
      state_4_3 <= 1'h0; // @[Arbiter.scala 116:26]
    end else if (idle_4) begin // @[Arbiter.scala 117:30]
      state_4_3 <= earlyWinner_4_3;
    end
    if (reset) begin // @[Arbiter.scala 116:26]
      state__4 <= 1'h0; // @[Arbiter.scala 116:26]
    end else if (idle) begin // @[Arbiter.scala 117:30]
      state__4 <= earlyWinner__4;
    end
    if (reset) begin // @[Arbiter.scala 116:26]
      state_1_4 <= 1'h0; // @[Arbiter.scala 116:26]
    end else if (idle_1) begin // @[Arbiter.scala 117:30]
      state_1_4 <= earlyWinner_1_4;
    end
    if (reset) begin // @[Arbiter.scala 116:26]
      state_4_4 <= 1'h0; // @[Arbiter.scala 116:26]
    end else if (idle_4) begin // @[Arbiter.scala 117:30]
      state_4_4 <= earlyWinner_4_4;
    end
    if (reset) begin // @[Arbiter.scala 87:30]
      beatsLeft_2 <= 9'h0; // @[Arbiter.scala 87:30]
    end else if (latch_2) begin // @[Arbiter.scala 113:23]
      beatsLeft_2 <= initBeats_2;
    end else begin
      beatsLeft_2 <= _beatsLeft_T_16;
    end
    if (reset) begin // @[Arbiter.scala 23:23]
      readys_mask_2 <= 4'hf; // @[Arbiter.scala 23:23]
    end else if (latch_2 & |readys_filter_lo_2) begin // @[Arbiter.scala 27:32]
      readys_mask_2 <= _readys_mask_T_28; // @[Arbiter.scala 28:12]
    end
    if (reset) begin // @[Arbiter.scala 116:26]
      state_2_0 <= 1'h0; // @[Arbiter.scala 116:26]
    end else if (idle_2) begin // @[Arbiter.scala 117:30]
      state_2_0 <= earlyWinner_2_0;
    end
    if (reset) begin // @[Arbiter.scala 116:26]
      state_2_1 <= 1'h0; // @[Arbiter.scala 116:26]
    end else if (idle_2) begin // @[Arbiter.scala 117:30]
      state_2_1 <= earlyWinner_2_1;
    end
    if (reset) begin // @[Arbiter.scala 116:26]
      state_2_2 <= 1'h0; // @[Arbiter.scala 116:26]
    end else if (idle_2) begin // @[Arbiter.scala 117:30]
      state_2_2 <= earlyWinner_2_2;
    end
    if (reset) begin // @[Arbiter.scala 116:26]
      state_2_3 <= 1'h0; // @[Arbiter.scala 116:26]
    end else if (idle_2) begin // @[Arbiter.scala 117:30]
      state_2_3 <= earlyWinner_2_3;
    end
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (~((~earlyWinner__0 | ~earlyWinner__1) & (~prefixOR_2 | ~earlyWinner__2) & (~prefixOR_3 | ~earlyWinner__3) &
          (~prefixOR_4 | ~earlyWinner__4) | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed\n    at Arbiter.scala:105 assert((prefixOR zip earlyWinner) map { case (p,w) => !p || !w } reduce {_ && _})\n"
            ); // @[Arbiter.scala 105:13]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (~((~earlyWinner__0 | ~earlyWinner__1) & (~prefixOR_2 | ~earlyWinner__2) & (~prefixOR_3 | ~earlyWinner__3) &
          (~prefixOR_4 | ~earlyWinner__4) | reset)) begin
          $fatal; // @[Arbiter.scala 105:13]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (~(~(portsAOI_filtered__0_earlyValid | portsAOI_filtered_1_0_earlyValid | portsAOI_filtered_2_0_earlyValid |
          portsAOI_filtered_3_0_earlyValid | portsAOI_filtered_4_0_earlyValid) | _prefixOR_T | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed\n    at Arbiter.scala:107 assert (!earlyValids.reduce(_||_) || earlyWinner.reduce(_||_))\n"
            ); // @[Arbiter.scala 107:14]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (~(~(portsAOI_filtered__0_earlyValid | portsAOI_filtered_1_0_earlyValid | portsAOI_filtered_2_0_earlyValid |
          portsAOI_filtered_3_0_earlyValid | portsAOI_filtered_4_0_earlyValid) | _prefixOR_T | reset)) begin
          $fatal; // @[Arbiter.scala 107:14]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (~(_T_27 | _T_26 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed\n    at Arbiter.scala:108 assert (!validQuals .reduce(_||_) || validQuals .reduce(_||_))\n"
            ); // @[Arbiter.scala 108:14]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (~(_T_27 | _T_26 | reset)) begin
          $fatal; // @[Arbiter.scala 108:14]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (~((~earlyWinner_1_0 | ~earlyWinner_1_1) & (~prefixOR_2_1 | ~earlyWinner_1_2) & (~prefixOR_3_1 | ~
          earlyWinner_1_3) & (~prefixOR_4_1 | ~earlyWinner_1_4) | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed\n    at Arbiter.scala:105 assert((prefixOR zip earlyWinner) map { case (p,w) => !p || !w } reduce {_ && _})\n"
            ); // @[Arbiter.scala 105:13]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (~((~earlyWinner_1_0 | ~earlyWinner_1_1) & (~prefixOR_2_1 | ~earlyWinner_1_2) & (~prefixOR_3_1 | ~
          earlyWinner_1_3) & (~prefixOR_4_1 | ~earlyWinner_1_4) | reset)) begin
          $fatal; // @[Arbiter.scala 105:13]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (~(~(portsAOI_filtered__1_earlyValid | portsAOI_filtered_1_1_earlyValid | portsAOI_filtered_2_1_earlyValid |
          portsAOI_filtered_3_1_earlyValid | portsAOI_filtered_4_1_earlyValid) | _prefixOR_T_1 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed\n    at Arbiter.scala:107 assert (!earlyValids.reduce(_||_) || earlyWinner.reduce(_||_))\n"
            ); // @[Arbiter.scala 107:14]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (~(~(portsAOI_filtered__1_earlyValid | portsAOI_filtered_1_1_earlyValid | portsAOI_filtered_2_1_earlyValid |
          portsAOI_filtered_3_1_earlyValid | portsAOI_filtered_4_1_earlyValid) | _prefixOR_T_1 | reset)) begin
          $fatal; // @[Arbiter.scala 107:14]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (~(_T_210 | _T_209 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed\n    at Arbiter.scala:108 assert (!validQuals .reduce(_||_) || validQuals .reduce(_||_))\n"
            ); // @[Arbiter.scala 108:14]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (~(_T_210 | _T_209 | reset)) begin
          $fatal; // @[Arbiter.scala 108:14]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (~((~earlyWinner_2_0 | ~earlyWinner_2_1) & (~prefixOR_2_2 | ~earlyWinner_2_2) & (~prefixOR_3_2 | ~
          earlyWinner_2_3) | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed\n    at Arbiter.scala:105 assert((prefixOR zip earlyWinner) map { case (p,w) => !p || !w } reduce {_ && _})\n"
            ); // @[Arbiter.scala 105:13]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (~((~earlyWinner_2_0 | ~earlyWinner_2_1) & (~prefixOR_2_2 | ~earlyWinner_2_2) & (~prefixOR_3_2 | ~
          earlyWinner_2_3) | reset)) begin
          $fatal; // @[Arbiter.scala 105:13]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (~(~(auto_in_1_c_valid | auto_in_2_c_valid | auto_in_3_c_valid | auto_in_4_c_valid) | _prefixOR_T_2 | reset)
          ) begin
          $fwrite(32'h80000002,
            "Assertion failed\n    at Arbiter.scala:107 assert (!earlyValids.reduce(_||_) || earlyWinner.reduce(_||_))\n"
            ); // @[Arbiter.scala 107:14]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (~(~(auto_in_1_c_valid | auto_in_2_c_valid | auto_in_3_c_valid | auto_in_4_c_valid) | _prefixOR_T_2 | reset)
          ) begin
          $fatal; // @[Arbiter.scala 107:14]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (~(_T_388 | _T_387 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed\n    at Arbiter.scala:108 assert (!validQuals .reduce(_||_) || validQuals .reduce(_||_))\n"
            ); // @[Arbiter.scala 108:14]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (~(_T_388 | _T_387 | reset)) begin
          $fatal; // @[Arbiter.scala 108:14]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (~((~earlyWinner_3_0 | ~earlyWinner_3_1) & (~prefixOR_2_3 | ~earlyWinner_3_2) & (~prefixOR_3_3 | ~
          earlyWinner_3_3) | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed\n    at Arbiter.scala:105 assert((prefixOR zip earlyWinner) map { case (p,w) => !p || !w } reduce {_ && _})\n"
            ); // @[Arbiter.scala 105:13]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (~((~earlyWinner_3_0 | ~earlyWinner_3_1) & (~prefixOR_2_3 | ~earlyWinner_3_2) & (~prefixOR_3_3 | ~
          earlyWinner_3_3) | reset)) begin
          $fatal; // @[Arbiter.scala 105:13]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (~(~(auto_in_1_e_valid | auto_in_2_e_valid | auto_in_3_e_valid | auto_in_4_e_valid) | _prefixOR_T_3 | reset)
          ) begin
          $fwrite(32'h80000002,
            "Assertion failed\n    at Arbiter.scala:107 assert (!earlyValids.reduce(_||_) || earlyWinner.reduce(_||_))\n"
            ); // @[Arbiter.scala 107:14]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (~(~(auto_in_1_e_valid | auto_in_2_e_valid | auto_in_3_e_valid | auto_in_4_e_valid) | _prefixOR_T_3 | reset)
          ) begin
          $fatal; // @[Arbiter.scala 107:14]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (~(_T_526 | _T_525 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed\n    at Arbiter.scala:108 assert (!validQuals .reduce(_||_) || validQuals .reduce(_||_))\n"
            ); // @[Arbiter.scala 108:14]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (~(_T_526 | _T_525 | reset)) begin
          $fatal; // @[Arbiter.scala 108:14]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (~((~earlyWinner_4_0 | ~earlyWinner_4_1) & (~prefixOR_2_4 | ~earlyWinner_4_2) & (~prefixOR_3_4 | ~
          earlyWinner_4_3) & (~prefixOR_4_2 | ~earlyWinner_4_4) | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed\n    at Arbiter.scala:105 assert((prefixOR zip earlyWinner) map { case (p,w) => !p || !w } reduce {_ && _})\n"
            ); // @[Arbiter.scala 105:13]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (~((~earlyWinner_4_0 | ~earlyWinner_4_1) & (~prefixOR_2_4 | ~earlyWinner_4_2) & (~prefixOR_3_4 | ~
          earlyWinner_4_3) & (~prefixOR_4_2 | ~earlyWinner_4_4) | reset)) begin
          $fatal; // @[Arbiter.scala 105:13]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (~(~(portsAOI_filtered__2_earlyValid | portsAOI_filtered_1_2_earlyValid | portsAOI_filtered_2_2_earlyValid |
          portsAOI_filtered_3_2_earlyValid | portsAOI_filtered_4_2_earlyValid) | _prefixOR_T_4 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed\n    at Arbiter.scala:107 assert (!earlyValids.reduce(_||_) || earlyWinner.reduce(_||_))\n"
            ); // @[Arbiter.scala 107:14]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (~(~(portsAOI_filtered__2_earlyValid | portsAOI_filtered_1_2_earlyValid | portsAOI_filtered_2_2_earlyValid |
          portsAOI_filtered_3_2_earlyValid | portsAOI_filtered_4_2_earlyValid) | _prefixOR_T_4 | reset)) begin
          $fatal; // @[Arbiter.scala 107:14]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (~(_T_578 | _T_577 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed\n    at Arbiter.scala:108 assert (!validQuals .reduce(_||_) || validQuals .reduce(_||_))\n"
            ); // @[Arbiter.scala 108:14]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (~(_T_578 | _T_577 | reset)) begin
          $fatal; // @[Arbiter.scala 108:14]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (~((~earlyWinner_5_0 | ~earlyWinner_5_1) & (~prefixOR_2_5 | ~earlyWinner_5_2) | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed\n    at Arbiter.scala:105 assert((prefixOR zip earlyWinner) map { case (p,w) => !p || !w } reduce {_ && _})\n"
            ); // @[Arbiter.scala 105:13]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (~((~earlyWinner_5_0 | ~earlyWinner_5_1) & (~prefixOR_2_5 | ~earlyWinner_5_2) | reset)) begin
          $fatal; // @[Arbiter.scala 105:13]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (~(~(portsDIO_filtered__0_valid | portsDIO_filtered_1_0_valid | portsDIO_filtered_2_0_valid) | _prefixOR_T_5
           | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed\n    at Arbiter.scala:107 assert (!earlyValids.reduce(_||_) || earlyWinner.reduce(_||_))\n"
            ); // @[Arbiter.scala 107:14]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (~(~(portsDIO_filtered__0_valid | portsDIO_filtered_1_0_valid | portsDIO_filtered_2_0_valid) | _prefixOR_T_5
           | reset)) begin
          $fatal; // @[Arbiter.scala 107:14]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (~(_T_751 | _T_750 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed\n    at Arbiter.scala:108 assert (!validQuals .reduce(_||_) || validQuals .reduce(_||_))\n"
            ); // @[Arbiter.scala 108:14]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (~(_T_751 | _T_750 | reset)) begin
          $fatal; // @[Arbiter.scala 108:14]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (~((~earlyWinner_6_0 | ~earlyWinner_6_1) & (~prefixOR_2_6 | ~earlyWinner_6_2) | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed\n    at Arbiter.scala:105 assert((prefixOR zip earlyWinner) map { case (p,w) => !p || !w } reduce {_ && _})\n"
            ); // @[Arbiter.scala 105:13]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (~((~earlyWinner_6_0 | ~earlyWinner_6_1) & (~prefixOR_2_6 | ~earlyWinner_6_2) | reset)) begin
          $fatal; // @[Arbiter.scala 105:13]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (~(~(portsDIO_filtered__1_valid | portsDIO_filtered_1_1_valid | portsDIO_filtered_2_1_valid) | _prefixOR_T_6
           | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed\n    at Arbiter.scala:107 assert (!earlyValids.reduce(_||_) || earlyWinner.reduce(_||_))\n"
            ); // @[Arbiter.scala 107:14]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (~(~(portsDIO_filtered__1_valid | portsDIO_filtered_1_1_valid | portsDIO_filtered_2_1_valid) | _prefixOR_T_6
           | reset)) begin
          $fatal; // @[Arbiter.scala 107:14]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (~(_T_823 | _T_822 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed\n    at Arbiter.scala:108 assert (!validQuals .reduce(_||_) || validQuals .reduce(_||_))\n"
            ); // @[Arbiter.scala 108:14]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (~(_T_823 | _T_822 | reset)) begin
          $fatal; // @[Arbiter.scala 108:14]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (~((~earlyWinner_7_0 | ~earlyWinner_7_1) & (~prefixOR_2_7 | ~earlyWinner_7_2) | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed\n    at Arbiter.scala:105 assert((prefixOR zip earlyWinner) map { case (p,w) => !p || !w } reduce {_ && _})\n"
            ); // @[Arbiter.scala 105:13]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (~((~earlyWinner_7_0 | ~earlyWinner_7_1) & (~prefixOR_2_7 | ~earlyWinner_7_2) | reset)) begin
          $fatal; // @[Arbiter.scala 105:13]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (~(~(portsDIO_filtered__2_valid | portsDIO_filtered_1_2_valid | portsDIO_filtered_2_2_valid) | _prefixOR_T_7
           | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed\n    at Arbiter.scala:107 assert (!earlyValids.reduce(_||_) || earlyWinner.reduce(_||_))\n"
            ); // @[Arbiter.scala 107:14]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (~(~(portsDIO_filtered__2_valid | portsDIO_filtered_1_2_valid | portsDIO_filtered_2_2_valid) | _prefixOR_T_7
           | reset)) begin
          $fatal; // @[Arbiter.scala 107:14]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (~(_T_895 | _T_894 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed\n    at Arbiter.scala:108 assert (!validQuals .reduce(_||_) || validQuals .reduce(_||_))\n"
            ); // @[Arbiter.scala 108:14]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (~(_T_895 | _T_894 | reset)) begin
          $fatal; // @[Arbiter.scala 108:14]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (~((~earlyWinner_8_0 | ~earlyWinner_8_1) & (~prefixOR_2_8 | ~earlyWinner_8_2) | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed\n    at Arbiter.scala:105 assert((prefixOR zip earlyWinner) map { case (p,w) => !p || !w } reduce {_ && _})\n"
            ); // @[Arbiter.scala 105:13]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (~((~earlyWinner_8_0 | ~earlyWinner_8_1) & (~prefixOR_2_8 | ~earlyWinner_8_2) | reset)) begin
          $fatal; // @[Arbiter.scala 105:13]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (~(~(portsDIO_filtered__3_valid | portsDIO_filtered_1_3_valid | portsDIO_filtered_2_3_valid) | _prefixOR_T_8
           | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed\n    at Arbiter.scala:107 assert (!earlyValids.reduce(_||_) || earlyWinner.reduce(_||_))\n"
            ); // @[Arbiter.scala 107:14]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (~(~(portsDIO_filtered__3_valid | portsDIO_filtered_1_3_valid | portsDIO_filtered_2_3_valid) | _prefixOR_T_8
           | reset)) begin
          $fatal; // @[Arbiter.scala 107:14]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (~(_T_967 | _T_966 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed\n    at Arbiter.scala:108 assert (!validQuals .reduce(_||_) || validQuals .reduce(_||_))\n"
            ); // @[Arbiter.scala 108:14]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (~(_T_967 | _T_966 | reset)) begin
          $fatal; // @[Arbiter.scala 108:14]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (~((~earlyWinner_9_0 | ~earlyWinner_9_1) & (~prefixOR_2_9 | ~earlyWinner_9_2) | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed\n    at Arbiter.scala:105 assert((prefixOR zip earlyWinner) map { case (p,w) => !p || !w } reduce {_ && _})\n"
            ); // @[Arbiter.scala 105:13]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (~((~earlyWinner_9_0 | ~earlyWinner_9_1) & (~prefixOR_2_9 | ~earlyWinner_9_2) | reset)) begin
          $fatal; // @[Arbiter.scala 105:13]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (~(~(portsDIO_filtered__4_valid | portsDIO_filtered_1_4_valid | portsDIO_filtered_2_4_valid) | _prefixOR_T_9
           | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed\n    at Arbiter.scala:107 assert (!earlyValids.reduce(_||_) || earlyWinner.reduce(_||_))\n"
            ); // @[Arbiter.scala 107:14]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (~(~(portsDIO_filtered__4_valid | portsDIO_filtered_1_4_valid | portsDIO_filtered_2_4_valid) | _prefixOR_T_9
           | reset)) begin
          $fatal; // @[Arbiter.scala 107:14]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (~(_T_1039 | _T_1038 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed\n    at Arbiter.scala:108 assert (!validQuals .reduce(_||_) || validQuals .reduce(_||_))\n"
            ); // @[Arbiter.scala 108:14]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (~(_T_1039 | _T_1038 | reset)) begin
          $fatal; // @[Arbiter.scala 108:14]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
  end
// Register and memory initialization
`ifdef RANDOMIZE_GARBAGE_ASSIGN
`define RANDOMIZE
`endif
`ifdef RANDOMIZE_INVALID_ASSIGN
`define RANDOMIZE
`endif
`ifdef RANDOMIZE_REG_INIT
`define RANDOMIZE
`endif
`ifdef RANDOMIZE_MEM_INIT
`define RANDOMIZE
`endif
`ifndef RANDOM
`define RANDOM $random
`endif
`ifdef RANDOMIZE_MEM_INIT
  integer initvar;
`endif
`ifndef SYNTHESIS
`ifdef FIRRTL_BEFORE_INITIAL
`FIRRTL_BEFORE_INITIAL
`endif
initial begin
  `ifdef RANDOMIZE
    `ifdef INIT_RANDOM
      `INIT_RANDOM
    `endif
    `ifndef VERILATOR
      `ifdef RANDOMIZE_DELAY
        #`RANDOMIZE_DELAY begin end
      `else
        #0.002 begin end
      `endif
    `endif
`ifdef RANDOMIZE_REG_INIT
  _RAND_0 = {1{`RANDOM}};
  beatsLeft_5 = _RAND_0[8:0];
  _RAND_1 = {1{`RANDOM}};
  readys_mask_5 = _RAND_1[2:0];
  _RAND_2 = {1{`RANDOM}};
  state_5_0 = _RAND_2[0:0];
  _RAND_3 = {1{`RANDOM}};
  state_5_1 = _RAND_3[0:0];
  _RAND_4 = {1{`RANDOM}};
  state_5_2 = _RAND_4[0:0];
  _RAND_5 = {1{`RANDOM}};
  beatsLeft_6 = _RAND_5[8:0];
  _RAND_6 = {1{`RANDOM}};
  readys_mask_6 = _RAND_6[2:0];
  _RAND_7 = {1{`RANDOM}};
  state_6_0 = _RAND_7[0:0];
  _RAND_8 = {1{`RANDOM}};
  state_6_1 = _RAND_8[0:0];
  _RAND_9 = {1{`RANDOM}};
  state_6_2 = _RAND_9[0:0];
  _RAND_10 = {1{`RANDOM}};
  beatsLeft_7 = _RAND_10[8:0];
  _RAND_11 = {1{`RANDOM}};
  readys_mask_7 = _RAND_11[2:0];
  _RAND_12 = {1{`RANDOM}};
  state_7_0 = _RAND_12[0:0];
  _RAND_13 = {1{`RANDOM}};
  state_7_1 = _RAND_13[0:0];
  _RAND_14 = {1{`RANDOM}};
  state_7_2 = _RAND_14[0:0];
  _RAND_15 = {1{`RANDOM}};
  beatsLeft_8 = _RAND_15[8:0];
  _RAND_16 = {1{`RANDOM}};
  readys_mask_8 = _RAND_16[2:0];
  _RAND_17 = {1{`RANDOM}};
  state_8_0 = _RAND_17[0:0];
  _RAND_18 = {1{`RANDOM}};
  state_8_1 = _RAND_18[0:0];
  _RAND_19 = {1{`RANDOM}};
  state_8_2 = _RAND_19[0:0];
  _RAND_20 = {1{`RANDOM}};
  beatsLeft_9 = _RAND_20[8:0];
  _RAND_21 = {1{`RANDOM}};
  readys_mask_9 = _RAND_21[2:0];
  _RAND_22 = {1{`RANDOM}};
  state_9_0 = _RAND_22[0:0];
  _RAND_23 = {1{`RANDOM}};
  state_9_1 = _RAND_23[0:0];
  _RAND_24 = {1{`RANDOM}};
  state_9_2 = _RAND_24[0:0];
  _RAND_25 = {1{`RANDOM}};
  beatsLeft_3 = _RAND_25[0:0];
  _RAND_26 = {1{`RANDOM}};
  readys_mask_3 = _RAND_26[3:0];
  _RAND_27 = {1{`RANDOM}};
  state_3_0 = _RAND_27[0:0];
  _RAND_28 = {1{`RANDOM}};
  state_3_1 = _RAND_28[0:0];
  _RAND_29 = {1{`RANDOM}};
  state_3_2 = _RAND_29[0:0];
  _RAND_30 = {1{`RANDOM}};
  state_3_3 = _RAND_30[0:0];
  _RAND_31 = {1{`RANDOM}};
  beatsLeft = _RAND_31[8:0];
  _RAND_32 = {1{`RANDOM}};
  readys_mask = _RAND_32[4:0];
  _RAND_33 = {1{`RANDOM}};
  state__0 = _RAND_33[0:0];
  _RAND_34 = {1{`RANDOM}};
  beatsLeft_1 = _RAND_34[8:0];
  _RAND_35 = {1{`RANDOM}};
  readys_mask_1 = _RAND_35[4:0];
  _RAND_36 = {1{`RANDOM}};
  state_1_0 = _RAND_36[0:0];
  _RAND_37 = {1{`RANDOM}};
  beatsLeft_4 = _RAND_37[8:0];
  _RAND_38 = {1{`RANDOM}};
  readys_mask_4 = _RAND_38[4:0];
  _RAND_39 = {1{`RANDOM}};
  state_4_0 = _RAND_39[0:0];
  _RAND_40 = {1{`RANDOM}};
  state__1 = _RAND_40[0:0];
  _RAND_41 = {1{`RANDOM}};
  state_1_1 = _RAND_41[0:0];
  _RAND_42 = {1{`RANDOM}};
  state_4_1 = _RAND_42[0:0];
  _RAND_43 = {1{`RANDOM}};
  state__2 = _RAND_43[0:0];
  _RAND_44 = {1{`RANDOM}};
  state_1_2 = _RAND_44[0:0];
  _RAND_45 = {1{`RANDOM}};
  state_4_2 = _RAND_45[0:0];
  _RAND_46 = {1{`RANDOM}};
  state__3 = _RAND_46[0:0];
  _RAND_47 = {1{`RANDOM}};
  state_1_3 = _RAND_47[0:0];
  _RAND_48 = {1{`RANDOM}};
  state_4_3 = _RAND_48[0:0];
  _RAND_49 = {1{`RANDOM}};
  state__4 = _RAND_49[0:0];
  _RAND_50 = {1{`RANDOM}};
  state_1_4 = _RAND_50[0:0];
  _RAND_51 = {1{`RANDOM}};
  state_4_4 = _RAND_51[0:0];
  _RAND_52 = {1{`RANDOM}};
  beatsLeft_2 = _RAND_52[8:0];
  _RAND_53 = {1{`RANDOM}};
  readys_mask_2 = _RAND_53[3:0];
  _RAND_54 = {1{`RANDOM}};
  state_2_0 = _RAND_54[0:0];
  _RAND_55 = {1{`RANDOM}};
  state_2_1 = _RAND_55[0:0];
  _RAND_56 = {1{`RANDOM}};
  state_2_2 = _RAND_56[0:0];
  _RAND_57 = {1{`RANDOM}};
  state_2_3 = _RAND_57[0:0];
`endif // RANDOMIZE_REG_INIT
  `endif // RANDOMIZE
end // initial
`ifdef FIRRTL_AFTER_INITIAL
`FIRRTL_AFTER_INITIAL
`endif
`endif // SYNTHESIS
endmodule
module TLMonitor_5(
  input         clock,
  input         reset,
  input         io_in_a_ready,
  input         io_in_a_valid,
  input  [2:0]  io_in_a_bits_opcode,
  input  [2:0]  io_in_a_bits_param,
  input  [3:0]  io_in_a_bits_size,
  input  [3:0]  io_in_a_bits_source,
  input  [31:0] io_in_a_bits_address,
  input  [7:0]  io_in_a_bits_mask,
  input         io_in_a_bits_corrupt,
  input         io_in_d_ready,
  input         io_in_d_valid,
  input  [2:0]  io_in_d_bits_opcode,
  input  [1:0]  io_in_d_bits_param,
  input  [3:0]  io_in_d_bits_size,
  input  [3:0]  io_in_d_bits_source,
  input  [1:0]  io_in_d_bits_sink,
  input         io_in_d_bits_denied,
  input         io_in_d_bits_corrupt
);
`ifdef RANDOMIZE_REG_INIT
  reg [31:0] _RAND_0;
  reg [31:0] _RAND_1;
  reg [31:0] _RAND_2;
  reg [31:0] _RAND_3;
  reg [31:0] _RAND_4;
  reg [31:0] _RAND_5;
  reg [31:0] _RAND_6;
  reg [31:0] _RAND_7;
  reg [31:0] _RAND_8;
  reg [31:0] _RAND_9;
  reg [31:0] _RAND_10;
  reg [31:0] _RAND_11;
  reg [31:0] _RAND_12;
  reg [31:0] _RAND_13;
  reg [63:0] _RAND_14;
  reg [127:0] _RAND_15;
  reg [31:0] _RAND_16;
  reg [31:0] _RAND_17;
  reg [31:0] _RAND_18;
  reg [31:0] _RAND_19;
  reg [127:0] _RAND_20;
  reg [31:0] _RAND_21;
  reg [31:0] _RAND_22;
`endif // RANDOMIZE_REG_INIT
  wire [31:0] plusarg_reader_out; // @[PlusArg.scala 80:11]
  wire [31:0] plusarg_reader_1_out; // @[PlusArg.scala 80:11]
  wire  _source_ok_T_1 = ~io_in_a_bits_source[3]; // @[Parameters.scala 54:32]
  wire  source_ok = _source_ok_T_1 | io_in_a_bits_source[3]; // @[Parameters.scala 1125:46]
  wire [26:0] _is_aligned_mask_T_1 = 27'hfff << io_in_a_bits_size; // @[package.scala 234:77]
  wire [11:0] is_aligned_mask = ~_is_aligned_mask_T_1[11:0]; // @[package.scala 234:46]
  wire [31:0] _GEN_71 = {{20'd0}, is_aligned_mask}; // @[Edges.scala 20:16]
  wire [31:0] _is_aligned_T = io_in_a_bits_address & _GEN_71; // @[Edges.scala 20:16]
  wire  is_aligned = _is_aligned_T == 32'h0; // @[Edges.scala 20:24]
  wire [1:0] mask_sizeOH_shiftAmount = io_in_a_bits_size[1:0]; // @[OneHot.scala 64:49]
  wire [3:0] _mask_sizeOH_T_1 = 4'h1 << mask_sizeOH_shiftAmount; // @[OneHot.scala 65:12]
  wire [2:0] mask_sizeOH = _mask_sizeOH_T_1[2:0] | 3'h1; // @[Misc.scala 201:81]
  wire  _mask_T = io_in_a_bits_size >= 4'h3; // @[Misc.scala 205:21]
  wire  mask_size = mask_sizeOH[2]; // @[Misc.scala 208:26]
  wire  mask_bit = io_in_a_bits_address[2]; // @[Misc.scala 209:26]
  wire  mask_nbit = ~mask_bit; // @[Misc.scala 210:20]
  wire  mask_acc = _mask_T | mask_size & mask_nbit; // @[Misc.scala 214:29]
  wire  mask_acc_1 = _mask_T | mask_size & mask_bit; // @[Misc.scala 214:29]
  wire  mask_size_1 = mask_sizeOH[1]; // @[Misc.scala 208:26]
  wire  mask_bit_1 = io_in_a_bits_address[1]; // @[Misc.scala 209:26]
  wire  mask_nbit_1 = ~mask_bit_1; // @[Misc.scala 210:20]
  wire  mask_eq_2 = mask_nbit & mask_nbit_1; // @[Misc.scala 213:27]
  wire  mask_acc_2 = mask_acc | mask_size_1 & mask_eq_2; // @[Misc.scala 214:29]
  wire  mask_eq_3 = mask_nbit & mask_bit_1; // @[Misc.scala 213:27]
  wire  mask_acc_3 = mask_acc | mask_size_1 & mask_eq_3; // @[Misc.scala 214:29]
  wire  mask_eq_4 = mask_bit & mask_nbit_1; // @[Misc.scala 213:27]
  wire  mask_acc_4 = mask_acc_1 | mask_size_1 & mask_eq_4; // @[Misc.scala 214:29]
  wire  mask_eq_5 = mask_bit & mask_bit_1; // @[Misc.scala 213:27]
  wire  mask_acc_5 = mask_acc_1 | mask_size_1 & mask_eq_5; // @[Misc.scala 214:29]
  wire  mask_size_2 = mask_sizeOH[0]; // @[Misc.scala 208:26]
  wire  mask_bit_2 = io_in_a_bits_address[0]; // @[Misc.scala 209:26]
  wire  mask_nbit_2 = ~mask_bit_2; // @[Misc.scala 210:20]
  wire  mask_eq_6 = mask_eq_2 & mask_nbit_2; // @[Misc.scala 213:27]
  wire  mask_lo_lo_lo = mask_acc_2 | mask_size_2 & mask_eq_6; // @[Misc.scala 214:29]
  wire  mask_eq_7 = mask_eq_2 & mask_bit_2; // @[Misc.scala 213:27]
  wire  mask_lo_lo_hi = mask_acc_2 | mask_size_2 & mask_eq_7; // @[Misc.scala 214:29]
  wire  mask_eq_8 = mask_eq_3 & mask_nbit_2; // @[Misc.scala 213:27]
  wire  mask_lo_hi_lo = mask_acc_3 | mask_size_2 & mask_eq_8; // @[Misc.scala 214:29]
  wire  mask_eq_9 = mask_eq_3 & mask_bit_2; // @[Misc.scala 213:27]
  wire  mask_lo_hi_hi = mask_acc_3 | mask_size_2 & mask_eq_9; // @[Misc.scala 214:29]
  wire  mask_eq_10 = mask_eq_4 & mask_nbit_2; // @[Misc.scala 213:27]
  wire  mask_hi_lo_lo = mask_acc_4 | mask_size_2 & mask_eq_10; // @[Misc.scala 214:29]
  wire  mask_eq_11 = mask_eq_4 & mask_bit_2; // @[Misc.scala 213:27]
  wire  mask_hi_lo_hi = mask_acc_4 | mask_size_2 & mask_eq_11; // @[Misc.scala 214:29]
  wire  mask_eq_12 = mask_eq_5 & mask_nbit_2; // @[Misc.scala 213:27]
  wire  mask_hi_hi_lo = mask_acc_5 | mask_size_2 & mask_eq_12; // @[Misc.scala 214:29]
  wire  mask_eq_13 = mask_eq_5 & mask_bit_2; // @[Misc.scala 213:27]
  wire  mask_hi_hi_hi = mask_acc_5 | mask_size_2 & mask_eq_13; // @[Misc.scala 214:29]
  wire [7:0] mask = {mask_hi_hi_hi,mask_hi_hi_lo,mask_hi_lo_hi,mask_hi_lo_lo,mask_lo_hi_hi,mask_lo_hi_lo,mask_lo_lo_hi,
    mask_lo_lo_lo}; // @[Cat.scala 30:58]
  wire [32:0] _T_12 = {1'b0,$signed(io_in_a_bits_address)}; // @[Parameters.scala 137:49]
  wire  _T_34 = io_in_a_bits_opcode == 3'h6; // @[Monitor.scala 81:25]
  wire  _T_36 = io_in_a_bits_size <= 4'hc; // @[Parameters.scala 92:42]
  wire  _T_51 = _T_36 & source_ok; // @[Parameters.scala 1160:30]
  wire [32:0] _T_57 = $signed(_T_12) & -33'sh1000; // @[Parameters.scala 137:52]
  wire  _T_58 = $signed(_T_57) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _T_59 = io_in_a_bits_address ^ 32'h3000; // @[Parameters.scala 137:31]
  wire [32:0] _T_60 = {1'b0,$signed(_T_59)}; // @[Parameters.scala 137:49]
  wire [32:0] _T_62 = $signed(_T_60) & -33'sh1000; // @[Parameters.scala 137:52]
  wire  _T_63 = $signed(_T_62) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _T_64 = io_in_a_bits_address ^ 32'h10000; // @[Parameters.scala 137:31]
  wire [32:0] _T_65 = {1'b0,$signed(_T_64)}; // @[Parameters.scala 137:49]
  wire [32:0] _T_67 = $signed(_T_65) & -33'sh10000; // @[Parameters.scala 137:52]
  wire  _T_68 = $signed(_T_67) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _T_69 = io_in_a_bits_address ^ 32'h2000000; // @[Parameters.scala 137:31]
  wire [32:0] _T_70 = {1'b0,$signed(_T_69)}; // @[Parameters.scala 137:49]
  wire [32:0] _T_72 = $signed(_T_70) & -33'sh10000; // @[Parameters.scala 137:52]
  wire  _T_73 = $signed(_T_72) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _T_74 = io_in_a_bits_address ^ 32'hc000000; // @[Parameters.scala 137:31]
  wire [32:0] _T_75 = {1'b0,$signed(_T_74)}; // @[Parameters.scala 137:49]
  wire [32:0] _T_77 = $signed(_T_75) & -33'sh4000000; // @[Parameters.scala 137:52]
  wire  _T_78 = $signed(_T_77) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _T_79 = io_in_a_bits_address ^ 32'h10000000; // @[Parameters.scala 137:31]
  wire [32:0] _T_80 = {1'b0,$signed(_T_79)}; // @[Parameters.scala 137:49]
  wire [32:0] _T_82 = $signed(_T_80) & -33'sh10000000; // @[Parameters.scala 137:52]
  wire  _T_83 = $signed(_T_82) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _T_84 = io_in_a_bits_address ^ 32'h20000000; // @[Parameters.scala 137:31]
  wire [32:0] _T_85 = {1'b0,$signed(_T_84)}; // @[Parameters.scala 137:49]
  wire [32:0] _T_87 = $signed(_T_85) & -33'sh20000000; // @[Parameters.scala 137:52]
  wire  _T_88 = $signed(_T_87) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _T_89 = io_in_a_bits_address ^ 32'h40000000; // @[Parameters.scala 137:31]
  wire [32:0] _T_90 = {1'b0,$signed(_T_89)}; // @[Parameters.scala 137:49]
  wire [32:0] _T_92 = $signed(_T_90) & -33'sh40000000; // @[Parameters.scala 137:52]
  wire  _T_93 = $signed(_T_92) == 33'sh0; // @[Parameters.scala 137:67]
  wire  _T_103 = io_in_a_bits_size <= 4'h6; // @[Parameters.scala 92:42]
  wire [31:0] _T_106 = io_in_a_bits_address ^ 32'h80000000; // @[Parameters.scala 137:31]
  wire [32:0] _T_107 = {1'b0,$signed(_T_106)}; // @[Parameters.scala 137:49]
  wire [32:0] _T_109 = $signed(_T_107) & -33'sh80000000; // @[Parameters.scala 137:52]
  wire  _T_110 = $signed(_T_109) == 33'sh0; // @[Parameters.scala 137:67]
  wire  _T_111 = _T_103 & _T_110; // @[Parameters.scala 670:56]
  wire  _T_114 = _T_51 & _T_111; // @[Monitor.scala 82:72]
  wire  _T_191 = io_in_a_bits_param <= 3'h2; // @[Bundles.scala 108:27]
  wire [7:0] _T_195 = ~io_in_a_bits_mask; // @[Monitor.scala 88:18]
  wire  _T_196 = _T_195 == 8'h0; // @[Monitor.scala 88:31]
  wire  _T_200 = ~io_in_a_bits_corrupt; // @[Monitor.scala 89:18]
  wire  _T_204 = io_in_a_bits_opcode == 3'h7; // @[Monitor.scala 92:25]
  wire  _T_365 = io_in_a_bits_param != 3'h0; // @[Monitor.scala 99:31]
  wire  _T_378 = io_in_a_bits_opcode == 3'h4; // @[Monitor.scala 104:25]
  wire  _T_409 = _T_36 & _T_63; // @[Parameters.scala 670:56]
  wire  _T_460 = _T_58 | _T_68 | _T_73 | _T_78 | _T_83 | _T_88 | _T_93 | _T_110; // @[Parameters.scala 671:42]
  wire  _T_461 = _T_103 & _T_460; // @[Parameters.scala 670:56]
  wire  _T_463 = _T_409 | _T_461; // @[Parameters.scala 672:30]
  wire  _T_473 = io_in_a_bits_param == 3'h0; // @[Monitor.scala 109:31]
  wire  _T_477 = io_in_a_bits_mask == mask; // @[Monitor.scala 110:30]
  wire  _T_485 = io_in_a_bits_opcode == 3'h0; // @[Monitor.scala 114:25]
  wire  _T_540 = _T_58 | _T_73 | _T_78 | _T_110; // @[Parameters.scala 671:42]
  wire  _T_541 = _T_103 & _T_540; // @[Parameters.scala 670:56]
  wire  _T_550 = io_in_a_bits_size <= 4'h8; // @[Parameters.scala 92:42]
  wire  _T_569 = _T_83 | _T_88 | _T_93; // @[Parameters.scala 671:42]
  wire  _T_570 = _T_550 & _T_569; // @[Parameters.scala 670:56]
  wire  _T_574 = _T_409 | _T_541 | _T_570; // @[Parameters.scala 672:30]
  wire  _T_575 = _T_51 & _T_574; // @[Monitor.scala 115:71]
  wire  _T_593 = io_in_a_bits_opcode == 3'h1; // @[Monitor.scala 122:25]
  wire [7:0] _T_697 = ~mask; // @[Monitor.scala 127:33]
  wire [7:0] _T_698 = io_in_a_bits_mask & _T_697; // @[Monitor.scala 127:31]
  wire  _T_699 = _T_698 == 8'h0; // @[Monitor.scala 127:40]
  wire  _T_703 = io_in_a_bits_opcode == 3'h2; // @[Monitor.scala 130:25]
  wire  _T_723 = io_in_a_bits_size <= 4'h3; // @[Parameters.scala 92:42]
  wire  _T_748 = _T_58 | _T_63 | _T_73 | _T_78; // @[Parameters.scala 671:42]
  wire  _T_749 = _T_723 & _T_748; // @[Parameters.scala 670:56]
  wire  _T_783 = _T_51 & _T_749; // @[Monitor.scala 131:74]
  wire  _T_793 = io_in_a_bits_param <= 3'h4; // @[Bundles.scala 138:33]
  wire  _T_801 = io_in_a_bits_opcode == 3'h3; // @[Monitor.scala 138:25]
  wire  _T_891 = io_in_a_bits_param <= 3'h3; // @[Bundles.scala 145:30]
  wire  _T_899 = io_in_a_bits_opcode == 3'h5; // @[Monitor.scala 146:25]
  wire  _T_979 = _T_51 & _T_409; // @[Monitor.scala 147:68]
  wire  _T_989 = io_in_a_bits_param <= 3'h1; // @[Bundles.scala 158:28]
  wire  _T_1001 = io_in_d_bits_opcode <= 3'h6; // @[Bundles.scala 42:24]
  wire  _source_ok_T_13 = ~io_in_d_bits_source[3]; // @[Parameters.scala 54:32]
  wire  source_ok_1 = _source_ok_T_13 | io_in_d_bits_source[3]; // @[Parameters.scala 1125:46]
  wire  _T_1005 = io_in_d_bits_opcode == 3'h6; // @[Monitor.scala 310:25]
  wire  _T_1009 = io_in_d_bits_size >= 4'h3; // @[Monitor.scala 312:27]
  wire  _T_1013 = io_in_d_bits_param == 2'h0; // @[Monitor.scala 313:28]
  wire  _T_1017 = ~io_in_d_bits_corrupt; // @[Monitor.scala 314:15]
  wire  _T_1021 = ~io_in_d_bits_denied; // @[Monitor.scala 315:15]
  wire  _T_1025 = io_in_d_bits_opcode == 3'h4; // @[Monitor.scala 318:25]
  wire  _T_1036 = io_in_d_bits_param <= 2'h2; // @[Bundles.scala 102:26]
  wire  _T_1040 = io_in_d_bits_param != 2'h2; // @[Monitor.scala 323:28]
  wire  _T_1053 = io_in_d_bits_opcode == 3'h5; // @[Monitor.scala 328:25]
  wire  _T_1073 = _T_1021 | io_in_d_bits_corrupt; // @[Monitor.scala 334:30]
  wire  _T_1082 = io_in_d_bits_opcode == 3'h0; // @[Monitor.scala 338:25]
  wire  _T_1099 = io_in_d_bits_opcode == 3'h1; // @[Monitor.scala 346:25]
  wire  _T_1117 = io_in_d_bits_opcode == 3'h2; // @[Monitor.scala 354:25]
  wire  _a_first_T = io_in_a_ready & io_in_a_valid; // @[Decoupled.scala 40:37]
  wire [8:0] a_first_beats1_decode = is_aligned_mask[11:3]; // @[Edges.scala 219:59]
  wire  a_first_beats1_opdata = ~io_in_a_bits_opcode[2]; // @[Edges.scala 91:28]
  reg [8:0] a_first_counter; // @[Edges.scala 228:27]
  wire [8:0] a_first_counter1 = a_first_counter - 9'h1; // @[Edges.scala 229:28]
  wire  a_first = a_first_counter == 9'h0; // @[Edges.scala 230:25]
  reg [2:0] opcode; // @[Monitor.scala 384:22]
  reg [2:0] param; // @[Monitor.scala 385:22]
  reg [3:0] size; // @[Monitor.scala 386:22]
  reg [3:0] source; // @[Monitor.scala 387:22]
  reg [31:0] address; // @[Monitor.scala 388:22]
  wire  _T_1147 = io_in_a_valid & ~a_first; // @[Monitor.scala 389:19]
  wire  _T_1148 = io_in_a_bits_opcode == opcode; // @[Monitor.scala 390:32]
  wire  _T_1152 = io_in_a_bits_param == param; // @[Monitor.scala 391:32]
  wire  _T_1156 = io_in_a_bits_size == size; // @[Monitor.scala 392:32]
  wire  _T_1160 = io_in_a_bits_source == source; // @[Monitor.scala 393:32]
  wire  _T_1164 = io_in_a_bits_address == address; // @[Monitor.scala 394:32]
  wire  _d_first_T = io_in_d_ready & io_in_d_valid; // @[Decoupled.scala 40:37]
  wire [26:0] _d_first_beats1_decode_T_1 = 27'hfff << io_in_d_bits_size; // @[package.scala 234:77]
  wire [11:0] _d_first_beats1_decode_T_3 = ~_d_first_beats1_decode_T_1[11:0]; // @[package.scala 234:46]
  wire [8:0] d_first_beats1_decode = _d_first_beats1_decode_T_3[11:3]; // @[Edges.scala 219:59]
  wire  d_first_beats1_opdata = io_in_d_bits_opcode[0]; // @[Edges.scala 105:36]
  reg [8:0] d_first_counter; // @[Edges.scala 228:27]
  wire [8:0] d_first_counter1 = d_first_counter - 9'h1; // @[Edges.scala 229:28]
  wire  d_first = d_first_counter == 9'h0; // @[Edges.scala 230:25]
  reg [2:0] opcode_1; // @[Monitor.scala 535:22]
  reg [1:0] param_1; // @[Monitor.scala 536:22]
  reg [3:0] size_1; // @[Monitor.scala 537:22]
  reg [3:0] source_1; // @[Monitor.scala 538:22]
  reg [1:0] sink; // @[Monitor.scala 539:22]
  reg  denied; // @[Monitor.scala 540:22]
  wire  _T_1171 = io_in_d_valid & ~d_first; // @[Monitor.scala 541:19]
  wire  _T_1172 = io_in_d_bits_opcode == opcode_1; // @[Monitor.scala 542:29]
  wire  _T_1176 = io_in_d_bits_param == param_1; // @[Monitor.scala 543:29]
  wire  _T_1180 = io_in_d_bits_size == size_1; // @[Monitor.scala 544:29]
  wire  _T_1184 = io_in_d_bits_source == source_1; // @[Monitor.scala 545:29]
  wire  _T_1188 = io_in_d_bits_sink == sink; // @[Monitor.scala 546:29]
  wire  _T_1192 = io_in_d_bits_denied == denied; // @[Monitor.scala 547:29]
  reg [15:0] inflight; // @[Monitor.scala 611:27]
  reg [63:0] inflight_opcodes; // @[Monitor.scala 613:35]
  reg [127:0] inflight_sizes; // @[Monitor.scala 615:33]
  reg [8:0] a_first_counter_1; // @[Edges.scala 228:27]
  wire [8:0] a_first_counter1_1 = a_first_counter_1 - 9'h1; // @[Edges.scala 229:28]
  wire  a_first_1 = a_first_counter_1 == 9'h0; // @[Edges.scala 230:25]
  reg [8:0] d_first_counter_1; // @[Edges.scala 228:27]
  wire [8:0] d_first_counter1_1 = d_first_counter_1 - 9'h1; // @[Edges.scala 229:28]
  wire  d_first_1 = d_first_counter_1 == 9'h0; // @[Edges.scala 230:25]
  wire [5:0] _GEN_72 = {io_in_d_bits_source, 2'h0}; // @[Monitor.scala 634:69]
  wire [6:0] _a_opcode_lookup_T = {{1'd0}, _GEN_72}; // @[Monitor.scala 634:69]
  wire [63:0] _a_opcode_lookup_T_1 = inflight_opcodes >> _a_opcode_lookup_T; // @[Monitor.scala 634:44]
  wire [15:0] _a_opcode_lookup_T_5 = 16'h10 - 16'h1; // @[Monitor.scala 609:57]
  wire [63:0] _GEN_73 = {{48'd0}, _a_opcode_lookup_T_5}; // @[Monitor.scala 634:97]
  wire [63:0] _a_opcode_lookup_T_6 = _a_opcode_lookup_T_1 & _GEN_73; // @[Monitor.scala 634:97]
  wire [63:0] _a_opcode_lookup_T_7 = {{1'd0}, _a_opcode_lookup_T_6[63:1]}; // @[Monitor.scala 634:152]
  wire [6:0] _a_size_lookup_T = {io_in_d_bits_source, 3'h0}; // @[Monitor.scala 638:65]
  wire [127:0] _a_size_lookup_T_1 = inflight_sizes >> _a_size_lookup_T; // @[Monitor.scala 638:40]
  wire [15:0] _a_size_lookup_T_5 = 16'h100 - 16'h1; // @[Monitor.scala 609:57]
  wire [127:0] _GEN_75 = {{112'd0}, _a_size_lookup_T_5}; // @[Monitor.scala 638:91]
  wire [127:0] _a_size_lookup_T_6 = _a_size_lookup_T_1 & _GEN_75; // @[Monitor.scala 638:91]
  wire [127:0] _a_size_lookup_T_7 = {{1'd0}, _a_size_lookup_T_6[127:1]}; // @[Monitor.scala 638:144]
  wire  _T_1198 = io_in_a_valid & a_first_1; // @[Monitor.scala 648:26]
  wire [15:0] _a_set_wo_ready_T = 16'h1 << io_in_a_bits_source; // @[OneHot.scala 58:35]
  wire [15:0] a_set_wo_ready = io_in_a_valid & a_first_1 ? _a_set_wo_ready_T : 16'h0; // @[Monitor.scala 648:71 Monitor.scala 649:22]
  wire  _T_1201 = _a_first_T & a_first_1; // @[Monitor.scala 652:27]
  wire [3:0] _a_opcodes_set_interm_T = {io_in_a_bits_opcode, 1'h0}; // @[Monitor.scala 654:53]
  wire [3:0] _a_opcodes_set_interm_T_1 = _a_opcodes_set_interm_T | 4'h1; // @[Monitor.scala 654:61]
  wire [4:0] _a_sizes_set_interm_T = {io_in_a_bits_size, 1'h0}; // @[Monitor.scala 655:51]
  wire [4:0] _a_sizes_set_interm_T_1 = _a_sizes_set_interm_T | 5'h1; // @[Monitor.scala 655:59]
  wire [5:0] _GEN_77 = {io_in_a_bits_source, 2'h0}; // @[Monitor.scala 656:79]
  wire [6:0] _a_opcodes_set_T = {{1'd0}, _GEN_77}; // @[Monitor.scala 656:79]
  wire [3:0] a_opcodes_set_interm = _a_first_T & a_first_1 ? _a_opcodes_set_interm_T_1 : 4'h0; // @[Monitor.scala 652:72 Monitor.scala 654:28]
  wire [130:0] _GEN_78 = {{127'd0}, a_opcodes_set_interm}; // @[Monitor.scala 656:54]
  wire [130:0] _a_opcodes_set_T_1 = _GEN_78 << _a_opcodes_set_T; // @[Monitor.scala 656:54]
  wire [6:0] _a_sizes_set_T = {io_in_a_bits_source, 3'h0}; // @[Monitor.scala 657:77]
  wire [4:0] a_sizes_set_interm = _a_first_T & a_first_1 ? _a_sizes_set_interm_T_1 : 5'h0; // @[Monitor.scala 652:72 Monitor.scala 655:28]
  wire [131:0] _GEN_79 = {{127'd0}, a_sizes_set_interm}; // @[Monitor.scala 657:52]
  wire [131:0] _a_sizes_set_T_1 = _GEN_79 << _a_sizes_set_T; // @[Monitor.scala 657:52]
  wire [15:0] _T_1203 = inflight >> io_in_a_bits_source; // @[Monitor.scala 658:26]
  wire  _T_1205 = ~_T_1203[0]; // @[Monitor.scala 658:17]
  wire [15:0] a_set = _a_first_T & a_first_1 ? _a_set_wo_ready_T : 16'h0; // @[Monitor.scala 652:72 Monitor.scala 653:28]
  wire [130:0] _GEN_19 = _a_first_T & a_first_1 ? _a_opcodes_set_T_1 : 131'h0; // @[Monitor.scala 652:72 Monitor.scala 656:28]
  wire [131:0] _GEN_20 = _a_first_T & a_first_1 ? _a_sizes_set_T_1 : 132'h0; // @[Monitor.scala 652:72 Monitor.scala 657:28]
  wire  _T_1209 = io_in_d_valid & d_first_1; // @[Monitor.scala 671:26]
  wire  _T_1211 = ~_T_1005; // @[Monitor.scala 671:74]
  wire  _T_1212 = io_in_d_valid & d_first_1 & ~_T_1005; // @[Monitor.scala 671:71]
  wire [15:0] _d_clr_wo_ready_T = 16'h1 << io_in_d_bits_source; // @[OneHot.scala 58:35]
  wire [15:0] d_clr_wo_ready = io_in_d_valid & d_first_1 & ~_T_1005 ? _d_clr_wo_ready_T : 16'h0; // @[Monitor.scala 671:90 Monitor.scala 672:22]
  wire [142:0] _GEN_81 = {{127'd0}, _a_opcode_lookup_T_5}; // @[Monitor.scala 677:76]
  wire [142:0] _d_opcodes_clr_T_5 = _GEN_81 << _a_opcode_lookup_T; // @[Monitor.scala 677:76]
  wire [142:0] _GEN_82 = {{127'd0}, _a_size_lookup_T_5}; // @[Monitor.scala 678:74]
  wire [142:0] _d_sizes_clr_T_5 = _GEN_82 << _a_size_lookup_T; // @[Monitor.scala 678:74]
  wire [15:0] d_clr = _d_first_T & d_first_1 & _T_1211 ? _d_clr_wo_ready_T : 16'h0; // @[Monitor.scala 675:91 Monitor.scala 676:21]
  wire [142:0] _GEN_23 = _d_first_T & d_first_1 & _T_1211 ? _d_opcodes_clr_T_5 : 143'h0; // @[Monitor.scala 675:91 Monitor.scala 677:21]
  wire [142:0] _GEN_24 = _d_first_T & d_first_1 & _T_1211 ? _d_sizes_clr_T_5 : 143'h0; // @[Monitor.scala 675:91 Monitor.scala 678:21]
  wire  _same_cycle_resp_T_2 = io_in_a_bits_source == io_in_d_bits_source; // @[Monitor.scala 681:113]
  wire  same_cycle_resp = _T_1198 & io_in_a_bits_source == io_in_d_bits_source; // @[Monitor.scala 681:88]
  wire [15:0] _T_1222 = inflight >> io_in_d_bits_source; // @[Monitor.scala 682:25]
  wire  _T_1224 = _T_1222[0] | same_cycle_resp; // @[Monitor.scala 682:49]
  wire [2:0] _GEN_27 = 3'h2 == io_in_a_bits_opcode ? 3'h1 : 3'h0; // @[Monitor.scala 685:38 Monitor.scala 685:38]
  wire [2:0] _GEN_28 = 3'h3 == io_in_a_bits_opcode ? 3'h1 : _GEN_27; // @[Monitor.scala 685:38 Monitor.scala 685:38]
  wire [2:0] _GEN_29 = 3'h4 == io_in_a_bits_opcode ? 3'h1 : _GEN_28; // @[Monitor.scala 685:38 Monitor.scala 685:38]
  wire [2:0] _GEN_30 = 3'h5 == io_in_a_bits_opcode ? 3'h2 : _GEN_29; // @[Monitor.scala 685:38 Monitor.scala 685:38]
  wire [2:0] _GEN_31 = 3'h6 == io_in_a_bits_opcode ? 3'h4 : _GEN_30; // @[Monitor.scala 685:38 Monitor.scala 685:38]
  wire [2:0] _GEN_32 = 3'h7 == io_in_a_bits_opcode ? 3'h4 : _GEN_31; // @[Monitor.scala 685:38 Monitor.scala 685:38]
  wire [2:0] _GEN_39 = 3'h6 == io_in_a_bits_opcode ? 3'h5 : _GEN_30; // @[Monitor.scala 686:39 Monitor.scala 686:39]
  wire [2:0] _GEN_40 = 3'h7 == io_in_a_bits_opcode ? 3'h4 : _GEN_39; // @[Monitor.scala 686:39 Monitor.scala 686:39]
  wire  _T_1229 = io_in_d_bits_opcode == _GEN_40; // @[Monitor.scala 686:39]
  wire  _T_1230 = io_in_d_bits_opcode == _GEN_32 | _T_1229; // @[Monitor.scala 685:77]
  wire  _T_1234 = io_in_a_bits_size == io_in_d_bits_size; // @[Monitor.scala 687:36]
  wire [3:0] a_opcode_lookup = _a_opcode_lookup_T_7[3:0];
  wire [2:0] _GEN_43 = 3'h2 == a_opcode_lookup[2:0] ? 3'h1 : 3'h0; // @[Monitor.scala 689:38 Monitor.scala 689:38]
  wire [2:0] _GEN_44 = 3'h3 == a_opcode_lookup[2:0] ? 3'h1 : _GEN_43; // @[Monitor.scala 689:38 Monitor.scala 689:38]
  wire [2:0] _GEN_45 = 3'h4 == a_opcode_lookup[2:0] ? 3'h1 : _GEN_44; // @[Monitor.scala 689:38 Monitor.scala 689:38]
  wire [2:0] _GEN_46 = 3'h5 == a_opcode_lookup[2:0] ? 3'h2 : _GEN_45; // @[Monitor.scala 689:38 Monitor.scala 689:38]
  wire [2:0] _GEN_47 = 3'h6 == a_opcode_lookup[2:0] ? 3'h4 : _GEN_46; // @[Monitor.scala 689:38 Monitor.scala 689:38]
  wire [2:0] _GEN_48 = 3'h7 == a_opcode_lookup[2:0] ? 3'h4 : _GEN_47; // @[Monitor.scala 689:38 Monitor.scala 689:38]
  wire [2:0] _GEN_55 = 3'h6 == a_opcode_lookup[2:0] ? 3'h5 : _GEN_46; // @[Monitor.scala 690:38 Monitor.scala 690:38]
  wire [2:0] _GEN_56 = 3'h7 == a_opcode_lookup[2:0] ? 3'h4 : _GEN_55; // @[Monitor.scala 690:38 Monitor.scala 690:38]
  wire  _T_1241 = io_in_d_bits_opcode == _GEN_56; // @[Monitor.scala 690:38]
  wire  _T_1242 = io_in_d_bits_opcode == _GEN_48 | _T_1241; // @[Monitor.scala 689:72]
  wire [7:0] a_size_lookup = _a_size_lookup_T_7[7:0];
  wire [7:0] _GEN_83 = {{4'd0}, io_in_d_bits_size}; // @[Monitor.scala 691:36]
  wire  _T_1246 = _GEN_83 == a_size_lookup; // @[Monitor.scala 691:36]
  wire  _T_1256 = _T_1209 & a_first_1 & io_in_a_valid & _same_cycle_resp_T_2 & _T_1211; // @[Monitor.scala 694:116]
  wire  _T_1258 = ~io_in_d_ready | io_in_a_ready; // @[Monitor.scala 695:32]
  wire  _T_1265 = a_set_wo_ready != d_clr_wo_ready | ~(|a_set_wo_ready); // @[Monitor.scala 699:48]
  wire [15:0] _inflight_T = inflight | a_set; // @[Monitor.scala 702:27]
  wire [15:0] _inflight_T_1 = ~d_clr; // @[Monitor.scala 702:38]
  wire [15:0] _inflight_T_2 = _inflight_T & _inflight_T_1; // @[Monitor.scala 702:36]
  wire [63:0] a_opcodes_set = _GEN_19[63:0];
  wire [63:0] _inflight_opcodes_T = inflight_opcodes | a_opcodes_set; // @[Monitor.scala 703:43]
  wire [63:0] d_opcodes_clr = _GEN_23[63:0];
  wire [63:0] _inflight_opcodes_T_1 = ~d_opcodes_clr; // @[Monitor.scala 703:62]
  wire [63:0] _inflight_opcodes_T_2 = _inflight_opcodes_T & _inflight_opcodes_T_1; // @[Monitor.scala 703:60]
  wire [127:0] a_sizes_set = _GEN_20[127:0];
  wire [127:0] _inflight_sizes_T = inflight_sizes | a_sizes_set; // @[Monitor.scala 704:39]
  wire [127:0] d_sizes_clr = _GEN_24[127:0];
  wire [127:0] _inflight_sizes_T_1 = ~d_sizes_clr; // @[Monitor.scala 704:56]
  wire [127:0] _inflight_sizes_T_2 = _inflight_sizes_T & _inflight_sizes_T_1; // @[Monitor.scala 704:54]
  reg [31:0] watchdog; // @[Monitor.scala 706:27]
  wire  _T_1274 = ~(|inflight) | plusarg_reader_out == 32'h0 | watchdog < plusarg_reader_out; // @[Monitor.scala 709:47]
  wire [31:0] _watchdog_T_1 = watchdog + 32'h1; // @[Monitor.scala 711:26]
  reg [15:0] inflight_1; // @[Monitor.scala 723:35]
  reg [127:0] inflight_sizes_1; // @[Monitor.scala 725:35]
  reg [8:0] d_first_counter_2; // @[Edges.scala 228:27]
  wire [8:0] d_first_counter1_2 = d_first_counter_2 - 9'h1; // @[Edges.scala 229:28]
  wire  d_first_2 = d_first_counter_2 == 9'h0; // @[Edges.scala 230:25]
  wire [127:0] _c_size_lookup_T_1 = inflight_sizes_1 >> _a_size_lookup_T; // @[Monitor.scala 747:42]
  wire [127:0] _c_size_lookup_T_6 = _c_size_lookup_T_1 & _GEN_75; // @[Monitor.scala 747:93]
  wire [127:0] _c_size_lookup_T_7 = {{1'd0}, _c_size_lookup_T_6[127:1]}; // @[Monitor.scala 747:146]
  wire  _T_1300 = io_in_d_valid & d_first_2 & _T_1005; // @[Monitor.scala 779:71]
  wire [15:0] d_clr_1 = _d_first_T & d_first_2 & _T_1005 ? _d_clr_wo_ready_T : 16'h0; // @[Monitor.scala 783:90 Monitor.scala 784:21]
  wire [142:0] _GEN_69 = _d_first_T & d_first_2 & _T_1005 ? _d_sizes_clr_T_5 : 143'h0; // @[Monitor.scala 783:90 Monitor.scala 786:21]
  wire [15:0] _T_1308 = inflight_1 >> io_in_d_bits_source; // @[Monitor.scala 791:25]
  wire [7:0] c_size_lookup = _c_size_lookup_T_7[7:0];
  wire  _T_1318 = _GEN_83 == c_size_lookup; // @[Monitor.scala 795:36]
  wire [15:0] _inflight_T_4 = ~d_clr_1; // @[Monitor.scala 809:46]
  wire [15:0] _inflight_T_5 = inflight_1 & _inflight_T_4; // @[Monitor.scala 809:44]
  wire [127:0] d_sizes_clr_1 = _GEN_69[127:0];
  wire [127:0] _inflight_sizes_T_4 = ~d_sizes_clr_1; // @[Monitor.scala 811:58]
  wire [127:0] _inflight_sizes_T_5 = inflight_sizes_1 & _inflight_sizes_T_4; // @[Monitor.scala 811:56]
  reg [31:0] watchdog_1; // @[Monitor.scala 813:27]
  wire  _T_1343 = ~(|inflight_1) | plusarg_reader_1_out == 32'h0 | watchdog_1 < plusarg_reader_1_out; // @[Monitor.scala 816:47]
  wire [31:0] _watchdog_T_3 = watchdog_1 + 32'h1; // @[Monitor.scala 818:26]
  plusarg_reader #(.FORMAT("tilelink_timeout=%d"), .DEFAULT(0), .WIDTH(32)) plusarg_reader ( // @[PlusArg.scala 80:11]
    .out(plusarg_reader_out)
  );
  plusarg_reader #(.FORMAT("tilelink_timeout=%d"), .DEFAULT(0), .WIDTH(32)) plusarg_reader_1 ( // @[PlusArg.scala 80:11]
    .out(plusarg_reader_1_out)
  );
  always @(posedge clock) begin
    if (reset) begin // @[Edges.scala 228:27]
      a_first_counter <= 9'h0; // @[Edges.scala 228:27]
    end else if (_a_first_T) begin // @[Edges.scala 234:17]
      if (a_first) begin // @[Edges.scala 235:21]
        if (a_first_beats1_opdata) begin // @[Edges.scala 220:14]
          a_first_counter <= a_first_beats1_decode;
        end else begin
          a_first_counter <= 9'h0;
        end
      end else begin
        a_first_counter <= a_first_counter1;
      end
    end
    if (_a_first_T & a_first) begin // @[Monitor.scala 396:32]
      opcode <= io_in_a_bits_opcode; // @[Monitor.scala 397:15]
    end
    if (_a_first_T & a_first) begin // @[Monitor.scala 396:32]
      param <= io_in_a_bits_param; // @[Monitor.scala 398:15]
    end
    if (_a_first_T & a_first) begin // @[Monitor.scala 396:32]
      size <= io_in_a_bits_size; // @[Monitor.scala 399:15]
    end
    if (_a_first_T & a_first) begin // @[Monitor.scala 396:32]
      source <= io_in_a_bits_source; // @[Monitor.scala 400:15]
    end
    if (_a_first_T & a_first) begin // @[Monitor.scala 396:32]
      address <= io_in_a_bits_address; // @[Monitor.scala 401:15]
    end
    if (reset) begin // @[Edges.scala 228:27]
      d_first_counter <= 9'h0; // @[Edges.scala 228:27]
    end else if (_d_first_T) begin // @[Edges.scala 234:17]
      if (d_first) begin // @[Edges.scala 235:21]
        if (d_first_beats1_opdata) begin // @[Edges.scala 220:14]
          d_first_counter <= d_first_beats1_decode;
        end else begin
          d_first_counter <= 9'h0;
        end
      end else begin
        d_first_counter <= d_first_counter1;
      end
    end
    if (_d_first_T & d_first) begin // @[Monitor.scala 549:32]
      opcode_1 <= io_in_d_bits_opcode; // @[Monitor.scala 550:15]
    end
    if (_d_first_T & d_first) begin // @[Monitor.scala 549:32]
      param_1 <= io_in_d_bits_param; // @[Monitor.scala 551:15]
    end
    if (_d_first_T & d_first) begin // @[Monitor.scala 549:32]
      size_1 <= io_in_d_bits_size; // @[Monitor.scala 552:15]
    end
    if (_d_first_T & d_first) begin // @[Monitor.scala 549:32]
      source_1 <= io_in_d_bits_source; // @[Monitor.scala 553:15]
    end
    if (_d_first_T & d_first) begin // @[Monitor.scala 549:32]
      sink <= io_in_d_bits_sink; // @[Monitor.scala 554:15]
    end
    if (_d_first_T & d_first) begin // @[Monitor.scala 549:32]
      denied <= io_in_d_bits_denied; // @[Monitor.scala 555:15]
    end
    if (reset) begin // @[Monitor.scala 611:27]
      inflight <= 16'h0; // @[Monitor.scala 611:27]
    end else begin
      inflight <= _inflight_T_2; // @[Monitor.scala 702:14]
    end
    if (reset) begin // @[Monitor.scala 613:35]
      inflight_opcodes <= 64'h0; // @[Monitor.scala 613:35]
    end else begin
      inflight_opcodes <= _inflight_opcodes_T_2; // @[Monitor.scala 703:22]
    end
    if (reset) begin // @[Monitor.scala 615:33]
      inflight_sizes <= 128'h0; // @[Monitor.scala 615:33]
    end else begin
      inflight_sizes <= _inflight_sizes_T_2; // @[Monitor.scala 704:20]
    end
    if (reset) begin // @[Edges.scala 228:27]
      a_first_counter_1 <= 9'h0; // @[Edges.scala 228:27]
    end else if (_a_first_T) begin // @[Edges.scala 234:17]
      if (a_first_1) begin // @[Edges.scala 235:21]
        if (a_first_beats1_opdata) begin // @[Edges.scala 220:14]
          a_first_counter_1 <= a_first_beats1_decode;
        end else begin
          a_first_counter_1 <= 9'h0;
        end
      end else begin
        a_first_counter_1 <= a_first_counter1_1;
      end
    end
    if (reset) begin // @[Edges.scala 228:27]
      d_first_counter_1 <= 9'h0; // @[Edges.scala 228:27]
    end else if (_d_first_T) begin // @[Edges.scala 234:17]
      if (d_first_1) begin // @[Edges.scala 235:21]
        if (d_first_beats1_opdata) begin // @[Edges.scala 220:14]
          d_first_counter_1 <= d_first_beats1_decode;
        end else begin
          d_first_counter_1 <= 9'h0;
        end
      end else begin
        d_first_counter_1 <= d_first_counter1_1;
      end
    end
    if (reset) begin // @[Monitor.scala 706:27]
      watchdog <= 32'h0; // @[Monitor.scala 706:27]
    end else if (_a_first_T | _d_first_T) begin // @[Monitor.scala 712:47]
      watchdog <= 32'h0; // @[Monitor.scala 712:58]
    end else begin
      watchdog <= _watchdog_T_1; // @[Monitor.scala 711:14]
    end
    if (reset) begin // @[Monitor.scala 723:35]
      inflight_1 <= 16'h0; // @[Monitor.scala 723:35]
    end else begin
      inflight_1 <= _inflight_T_5; // @[Monitor.scala 809:22]
    end
    if (reset) begin // @[Monitor.scala 725:35]
      inflight_sizes_1 <= 128'h0; // @[Monitor.scala 725:35]
    end else begin
      inflight_sizes_1 <= _inflight_sizes_T_5; // @[Monitor.scala 811:22]
    end
    if (reset) begin // @[Edges.scala 228:27]
      d_first_counter_2 <= 9'h0; // @[Edges.scala 228:27]
    end else if (_d_first_T) begin // @[Edges.scala 234:17]
      if (d_first_2) begin // @[Edges.scala 235:21]
        if (d_first_beats1_opdata) begin // @[Edges.scala 220:14]
          d_first_counter_2 <= d_first_beats1_decode;
        end else begin
          d_first_counter_2 <= 9'h0;
        end
      end else begin
        d_first_counter_2 <= d_first_counter1_2;
      end
    end
    if (reset) begin // @[Monitor.scala 813:27]
      watchdog_1 <= 32'h0; // @[Monitor.scala 813:27]
    end else if (_d_first_T) begin // @[Monitor.scala 819:47]
      watchdog_1 <= 32'h0; // @[Monitor.scala 819:58]
    end else begin
      watchdog_1 <= _watchdog_T_3; // @[Monitor.scala 818:14]
    end
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_34 & ~(_T_114 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries AcquireBlock type which is unexpected using diplomatic parameters (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_34 & ~(_T_114 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_34 & ~reset) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries AcquireBlock from a client which does not support Probe (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_34 & ~reset) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_34 & ~(source_ok | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquireBlock carries invalid source ID (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_34 & ~(source_ok | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_34 & ~(_mask_T | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquireBlock smaller than a beat (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_34 & ~(_mask_T | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_34 & ~(is_aligned | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquireBlock address not aligned to size (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_34 & ~(is_aligned | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_34 & ~(_T_191 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquireBlock carries invalid grow param (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_34 & ~(_T_191 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_34 & ~(_T_196 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquireBlock contains invalid mask (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_34 & ~(_T_196 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_34 & ~(_T_200 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquireBlock is corrupt (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_34 & ~(_T_200 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_204 & ~(_T_114 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries AcquirePerm type which is unexpected using diplomatic parameters (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_204 & ~(_T_114 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_204 & ~reset) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries AcquirePerm from a client which does not support Probe (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_204 & ~reset) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_204 & ~(source_ok | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquirePerm carries invalid source ID (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_204 & ~(source_ok | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_204 & ~(_mask_T | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquirePerm smaller than a beat (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_204 & ~(_mask_T | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_204 & ~(is_aligned | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquirePerm address not aligned to size (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_204 & ~(is_aligned | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_204 & ~(_T_191 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquirePerm carries invalid grow param (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_204 & ~(_T_191 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_204 & ~(_T_365 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquirePerm requests NtoB (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_204 & ~(_T_365 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_204 & ~(_T_196 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquirePerm contains invalid mask (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_204 & ~(_T_196 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_204 & ~(_T_200 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquirePerm is corrupt (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_204 & ~(_T_200 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_378 & ~(_T_51 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries Get type which master claims it can't emit (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_378 & ~(_T_51 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_378 & ~(_T_463 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries Get type which slave claims it can't support (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_378 & ~(_T_463 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_378 & ~(source_ok | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Get carries invalid source ID (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_378 & ~(source_ok | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_378 & ~(is_aligned | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Get address not aligned to size (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_378 & ~(is_aligned | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_378 & ~(_T_473 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Get carries invalid param (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_378 & ~(_T_473 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_378 & ~(_T_477 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Get contains invalid mask (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_378 & ~(_T_477 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_378 & ~(_T_200 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Get is corrupt (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_378 & ~(_T_200 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_485 & ~(_T_575 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries PutFull type which is unexpected using diplomatic parameters (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_485 & ~(_T_575 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_485 & ~(source_ok | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel PutFull carries invalid source ID (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_485 & ~(source_ok | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_485 & ~(is_aligned | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel PutFull address not aligned to size (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_485 & ~(is_aligned | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_485 & ~(_T_473 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel PutFull carries invalid param (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_485 & ~(_T_473 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_485 & ~(_T_477 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel PutFull contains invalid mask (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_485 & ~(_T_477 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_593 & ~(_T_575 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries PutPartial type which is unexpected using diplomatic parameters (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_593 & ~(_T_575 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_593 & ~(source_ok | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel PutPartial carries invalid source ID (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_593 & ~(source_ok | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_593 & ~(is_aligned | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel PutPartial address not aligned to size (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_593 & ~(is_aligned | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_593 & ~(_T_473 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel PutPartial carries invalid param (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_593 & ~(_T_473 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_593 & ~(_T_699 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel PutPartial contains invalid mask (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_593 & ~(_T_699 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_703 & ~(_T_783 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries Arithmetic type which is unexpected using diplomatic parameters (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_703 & ~(_T_783 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_703 & ~(source_ok | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Arithmetic carries invalid source ID (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_703 & ~(source_ok | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_703 & ~(is_aligned | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Arithmetic address not aligned to size (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_703 & ~(is_aligned | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_703 & ~(_T_793 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Arithmetic carries invalid opcode param (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_703 & ~(_T_793 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_703 & ~(_T_477 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Arithmetic contains invalid mask (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_703 & ~(_T_477 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_801 & ~(_T_783 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries Logical type which is unexpected using diplomatic parameters (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_801 & ~(_T_783 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_801 & ~(source_ok | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Logical carries invalid source ID (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_801 & ~(source_ok | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_801 & ~(is_aligned | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Logical address not aligned to size (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_801 & ~(is_aligned | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_801 & ~(_T_891 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Logical carries invalid opcode param (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_801 & ~(_T_891 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_801 & ~(_T_477 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Logical contains invalid mask (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_801 & ~(_T_477 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_899 & ~(_T_979 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries Hint type which is unexpected using diplomatic parameters (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_899 & ~(_T_979 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_899 & ~(source_ok | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Hint carries invalid source ID (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_899 & ~(source_ok | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_899 & ~(is_aligned | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Hint address not aligned to size (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_899 & ~(is_aligned | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_899 & ~(_T_989 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Hint carries invalid opcode param (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_899 & ~(_T_989 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_899 & ~(_T_477 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Hint contains invalid mask (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_899 & ~(_T_477 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_899 & ~(_T_200 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Hint is corrupt (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_899 & ~(_T_200 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & ~(_T_1001 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel has invalid opcode (connected at SystemBus.scala:41:96)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & ~(_T_1001 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_1005 & ~(source_ok_1 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel ReleaseAck carries invalid source ID (connected at SystemBus.scala:41:96)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_1005 & ~(source_ok_1 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_1005 & ~(_T_1009 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel ReleaseAck smaller than a beat (connected at SystemBus.scala:41:96)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_1005 & ~(_T_1009 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_1005 & ~(_T_1013 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel ReleaseeAck carries invalid param (connected at SystemBus.scala:41:96)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_1005 & ~(_T_1013 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_1005 & ~(_T_1017 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel ReleaseAck is corrupt (connected at SystemBus.scala:41:96)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_1005 & ~(_T_1017 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_1005 & ~(_T_1021 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel ReleaseAck is denied (connected at SystemBus.scala:41:96)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_1005 & ~(_T_1021 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_1025 & ~(source_ok_1 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel Grant carries invalid source ID (connected at SystemBus.scala:41:96)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_1025 & ~(source_ok_1 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_1025 & ~(_T_1009 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel Grant smaller than a beat (connected at SystemBus.scala:41:96)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_1025 & ~(_T_1009 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_1025 & ~(_T_1036 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel Grant carries invalid cap param (connected at SystemBus.scala:41:96)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_1025 & ~(_T_1036 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_1025 & ~(_T_1040 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel Grant carries toN param (connected at SystemBus.scala:41:96)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_1025 & ~(_T_1040 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_1025 & ~(_T_1017 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel Grant is corrupt (connected at SystemBus.scala:41:96)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_1025 & ~(_T_1017 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_1053 & ~(source_ok_1 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel GrantData carries invalid source ID (connected at SystemBus.scala:41:96)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_1053 & ~(source_ok_1 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_1053 & ~(_T_1009 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel GrantData smaller than a beat (connected at SystemBus.scala:41:96)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_1053 & ~(_T_1009 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_1053 & ~(_T_1036 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel GrantData carries invalid cap param (connected at SystemBus.scala:41:96)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_1053 & ~(_T_1036 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_1053 & ~(_T_1040 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel GrantData carries toN param (connected at SystemBus.scala:41:96)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_1053 & ~(_T_1040 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_1053 & ~(_T_1073 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel GrantData is denied but not corrupt (connected at SystemBus.scala:41:96)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_1053 & ~(_T_1073 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_1082 & ~(source_ok_1 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel AccessAck carries invalid source ID (connected at SystemBus.scala:41:96)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_1082 & ~(source_ok_1 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_1082 & ~(_T_1013 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel AccessAck carries invalid param (connected at SystemBus.scala:41:96)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_1082 & ~(_T_1013 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_1082 & ~(_T_1017 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel AccessAck is corrupt (connected at SystemBus.scala:41:96)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_1082 & ~(_T_1017 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_1099 & ~(source_ok_1 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel AccessAckData carries invalid source ID (connected at SystemBus.scala:41:96)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_1099 & ~(source_ok_1 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_1099 & ~(_T_1013 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel AccessAckData carries invalid param (connected at SystemBus.scala:41:96)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_1099 & ~(_T_1013 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_1099 & ~(_T_1073 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel AccessAckData is denied but not corrupt (connected at SystemBus.scala:41:96)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_1099 & ~(_T_1073 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_1117 & ~(source_ok_1 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel HintAck carries invalid source ID (connected at SystemBus.scala:41:96)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_1117 & ~(source_ok_1 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_1117 & ~(_T_1013 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel HintAck carries invalid param (connected at SystemBus.scala:41:96)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_1117 & ~(_T_1013 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_1117 & ~(_T_1017 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel HintAck is corrupt (connected at SystemBus.scala:41:96)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_1117 & ~(_T_1017 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1147 & ~(_T_1148 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel opcode changed within multibeat operation (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1147 & ~(_T_1148 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1147 & ~(_T_1152 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel param changed within multibeat operation (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1147 & ~(_T_1152 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1147 & ~(_T_1156 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel size changed within multibeat operation (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1147 & ~(_T_1156 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1147 & ~(_T_1160 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel source changed within multibeat operation (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1147 & ~(_T_1160 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1147 & ~(_T_1164 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel address changed with multibeat operation (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1147 & ~(_T_1164 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1171 & ~(_T_1172 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel opcode changed within multibeat operation (connected at SystemBus.scala:41:96)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1171 & ~(_T_1172 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1171 & ~(_T_1176 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel param changed within multibeat operation (connected at SystemBus.scala:41:96)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1171 & ~(_T_1176 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1171 & ~(_T_1180 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel size changed within multibeat operation (connected at SystemBus.scala:41:96)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1171 & ~(_T_1180 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1171 & ~(_T_1184 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel source changed within multibeat operation (connected at SystemBus.scala:41:96)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1171 & ~(_T_1184 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1171 & ~(_T_1188 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel sink changed with multibeat operation (connected at SystemBus.scala:41:96)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1171 & ~(_T_1188 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1171 & ~(_T_1192 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel denied changed with multibeat operation (connected at SystemBus.scala:41:96)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1171 & ~(_T_1192 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1201 & ~(_T_1205 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel re-used a source ID (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1201 & ~(_T_1205 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1212 & ~(_T_1224 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel acknowledged for nothing inflight (connected at SystemBus.scala:41:96)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1212 & ~(_T_1224 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1212 & same_cycle_resp & ~(_T_1230 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel contains improper opcode response (connected at SystemBus.scala:41:96)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1212 & same_cycle_resp & ~(_T_1230 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1212 & same_cycle_resp & ~(_T_1234 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel contains improper response size (connected at SystemBus.scala:41:96)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1212 & same_cycle_resp & ~(_T_1234 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1212 & ~same_cycle_resp & ~(_T_1242 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel contains improper opcode response (connected at SystemBus.scala:41:96)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1212 & ~same_cycle_resp & ~(_T_1242 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1212 & ~same_cycle_resp & ~(_T_1246 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel contains improper response size (connected at SystemBus.scala:41:96)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1212 & ~same_cycle_resp & ~(_T_1246 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1256 & ~(_T_1258 | reset)) begin
          $fwrite(32'h80000002,"Assertion failed: ready check\n    at Monitor.scala:49 assert(cond, message)\n"); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1256 & ~(_T_1258 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (~(_T_1265 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' and 'D' concurrent, despite minlatency 1 (connected at SystemBus.scala:41:96)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (~(_T_1265 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (~(_T_1274 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: TileLink timeout expired (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (~(_T_1274 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1300 & ~(_T_1308[0] | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel acknowledged for nothing inflight (connected at SystemBus.scala:41:96)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1300 & ~(_T_1308[0] | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1300 & ~(_T_1318 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel contains improper response size (connected at SystemBus.scala:41:96)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1300 & ~(_T_1318 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (~(_T_1343 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: TileLink timeout expired (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (~(_T_1343 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
  end
// Register and memory initialization
`ifdef RANDOMIZE_GARBAGE_ASSIGN
`define RANDOMIZE
`endif
`ifdef RANDOMIZE_INVALID_ASSIGN
`define RANDOMIZE
`endif
`ifdef RANDOMIZE_REG_INIT
`define RANDOMIZE
`endif
`ifdef RANDOMIZE_MEM_INIT
`define RANDOMIZE
`endif
`ifndef RANDOM
`define RANDOM $random
`endif
`ifdef RANDOMIZE_MEM_INIT
  integer initvar;
`endif
`ifndef SYNTHESIS
`ifdef FIRRTL_BEFORE_INITIAL
`FIRRTL_BEFORE_INITIAL
`endif
initial begin
  `ifdef RANDOMIZE
    `ifdef INIT_RANDOM
      `INIT_RANDOM
    `endif
    `ifndef VERILATOR
      `ifdef RANDOMIZE_DELAY
        #`RANDOMIZE_DELAY begin end
      `else
        #0.002 begin end
      `endif
    `endif
`ifdef RANDOMIZE_REG_INIT
  _RAND_0 = {1{`RANDOM}};
  a_first_counter = _RAND_0[8:0];
  _RAND_1 = {1{`RANDOM}};
  opcode = _RAND_1[2:0];
  _RAND_2 = {1{`RANDOM}};
  param = _RAND_2[2:0];
  _RAND_3 = {1{`RANDOM}};
  size = _RAND_3[3:0];
  _RAND_4 = {1{`RANDOM}};
  source = _RAND_4[3:0];
  _RAND_5 = {1{`RANDOM}};
  address = _RAND_5[31:0];
  _RAND_6 = {1{`RANDOM}};
  d_first_counter = _RAND_6[8:0];
  _RAND_7 = {1{`RANDOM}};
  opcode_1 = _RAND_7[2:0];
  _RAND_8 = {1{`RANDOM}};
  param_1 = _RAND_8[1:0];
  _RAND_9 = {1{`RANDOM}};
  size_1 = _RAND_9[3:0];
  _RAND_10 = {1{`RANDOM}};
  source_1 = _RAND_10[3:0];
  _RAND_11 = {1{`RANDOM}};
  sink = _RAND_11[1:0];
  _RAND_12 = {1{`RANDOM}};
  denied = _RAND_12[0:0];
  _RAND_13 = {1{`RANDOM}};
  inflight = _RAND_13[15:0];
  _RAND_14 = {2{`RANDOM}};
  inflight_opcodes = _RAND_14[63:0];
  _RAND_15 = {4{`RANDOM}};
  inflight_sizes = _RAND_15[127:0];
  _RAND_16 = {1{`RANDOM}};
  a_first_counter_1 = _RAND_16[8:0];
  _RAND_17 = {1{`RANDOM}};
  d_first_counter_1 = _RAND_17[8:0];
  _RAND_18 = {1{`RANDOM}};
  watchdog = _RAND_18[31:0];
  _RAND_19 = {1{`RANDOM}};
  inflight_1 = _RAND_19[15:0];
  _RAND_20 = {4{`RANDOM}};
  inflight_sizes_1 = _RAND_20[127:0];
  _RAND_21 = {1{`RANDOM}};
  d_first_counter_2 = _RAND_21[8:0];
  _RAND_22 = {1{`RANDOM}};
  watchdog_1 = _RAND_22[31:0];
`endif // RANDOMIZE_REG_INIT
  `endif // RANDOMIZE
end // initial
`ifdef FIRRTL_AFTER_INITIAL
`FIRRTL_AFTER_INITIAL
`endif
`endif // SYNTHESIS
endmodule
module TLMonitor_6(
  input         clock,
  input         reset,
  input         io_in_a_ready,
  input         io_in_a_valid,
  input  [2:0]  io_in_a_bits_opcode,
  input  [2:0]  io_in_a_bits_param,
  input  [3:0]  io_in_a_bits_size,
  input  [1:0]  io_in_a_bits_source,
  input  [31:0] io_in_a_bits_address,
  input  [7:0]  io_in_a_bits_mask,
  input         io_in_a_bits_corrupt,
  input         io_in_b_ready,
  input         io_in_b_valid,
  input  [1:0]  io_in_b_bits_param,
  input  [1:0]  io_in_b_bits_source,
  input  [31:0] io_in_b_bits_address,
  input         io_in_c_ready,
  input         io_in_c_valid,
  input  [2:0]  io_in_c_bits_opcode,
  input  [2:0]  io_in_c_bits_param,
  input  [3:0]  io_in_c_bits_size,
  input  [1:0]  io_in_c_bits_source,
  input  [31:0] io_in_c_bits_address,
  input         io_in_c_bits_corrupt,
  input         io_in_d_ready,
  input         io_in_d_valid,
  input  [2:0]  io_in_d_bits_opcode,
  input  [1:0]  io_in_d_bits_param,
  input  [3:0]  io_in_d_bits_size,
  input  [1:0]  io_in_d_bits_source,
  input  [1:0]  io_in_d_bits_sink,
  input         io_in_d_bits_denied,
  input         io_in_d_bits_corrupt,
  input         io_in_e_ready,
  input         io_in_e_valid,
  input  [1:0]  io_in_e_bits_sink
);
`ifdef RANDOMIZE_REG_INIT
  reg [31:0] _RAND_0;
  reg [31:0] _RAND_1;
  reg [31:0] _RAND_2;
  reg [31:0] _RAND_3;
  reg [31:0] _RAND_4;
  reg [31:0] _RAND_5;
  reg [31:0] _RAND_6;
  reg [31:0] _RAND_7;
  reg [31:0] _RAND_8;
  reg [31:0] _RAND_9;
  reg [31:0] _RAND_10;
  reg [31:0] _RAND_11;
  reg [31:0] _RAND_12;
  reg [31:0] _RAND_13;
  reg [31:0] _RAND_14;
  reg [31:0] _RAND_15;
  reg [31:0] _RAND_16;
  reg [31:0] _RAND_17;
  reg [31:0] _RAND_18;
  reg [31:0] _RAND_19;
  reg [31:0] _RAND_20;
  reg [31:0] _RAND_21;
  reg [31:0] _RAND_22;
  reg [31:0] _RAND_23;
  reg [31:0] _RAND_24;
  reg [31:0] _RAND_25;
  reg [31:0] _RAND_26;
  reg [31:0] _RAND_27;
  reg [31:0] _RAND_28;
  reg [31:0] _RAND_29;
  reg [31:0] _RAND_30;
  reg [31:0] _RAND_31;
  reg [31:0] _RAND_32;
  reg [31:0] _RAND_33;
  reg [31:0] _RAND_34;
  reg [31:0] _RAND_35;
`endif // RANDOMIZE_REG_INIT
  wire [31:0] plusarg_reader_out; // @[PlusArg.scala 80:11]
  wire [31:0] plusarg_reader_1_out; // @[PlusArg.scala 80:11]
  wire  _source_ok_T = io_in_a_bits_source == 2'h0; // @[Parameters.scala 46:9]
  wire  _source_ok_T_1 = io_in_a_bits_source == 2'h1; // @[Parameters.scala 46:9]
  wire  _source_ok_T_2 = io_in_a_bits_source == 2'h2; // @[Parameters.scala 46:9]
  wire  source_ok = _source_ok_T | _source_ok_T_1 | _source_ok_T_2; // @[Parameters.scala 1125:46]
  wire [26:0] _is_aligned_mask_T_1 = 27'hfff << io_in_a_bits_size; // @[package.scala 234:77]
  wire [11:0] is_aligned_mask = ~_is_aligned_mask_T_1[11:0]; // @[package.scala 234:46]
  wire [31:0] _GEN_86 = {{20'd0}, is_aligned_mask}; // @[Edges.scala 20:16]
  wire [31:0] _is_aligned_T = io_in_a_bits_address & _GEN_86; // @[Edges.scala 20:16]
  wire  is_aligned = _is_aligned_T == 32'h0; // @[Edges.scala 20:24]
  wire [1:0] mask_sizeOH_shiftAmount = io_in_a_bits_size[1:0]; // @[OneHot.scala 64:49]
  wire [3:0] _mask_sizeOH_T_1 = 4'h1 << mask_sizeOH_shiftAmount; // @[OneHot.scala 65:12]
  wire [2:0] mask_sizeOH = _mask_sizeOH_T_1[2:0] | 3'h1; // @[Misc.scala 201:81]
  wire  _mask_T = io_in_a_bits_size >= 4'h3; // @[Misc.scala 205:21]
  wire  mask_size = mask_sizeOH[2]; // @[Misc.scala 208:26]
  wire  mask_bit = io_in_a_bits_address[2]; // @[Misc.scala 209:26]
  wire  mask_nbit = ~mask_bit; // @[Misc.scala 210:20]
  wire  mask_acc = _mask_T | mask_size & mask_nbit; // @[Misc.scala 214:29]
  wire  mask_acc_1 = _mask_T | mask_size & mask_bit; // @[Misc.scala 214:29]
  wire  mask_size_1 = mask_sizeOH[1]; // @[Misc.scala 208:26]
  wire  mask_bit_1 = io_in_a_bits_address[1]; // @[Misc.scala 209:26]
  wire  mask_nbit_1 = ~mask_bit_1; // @[Misc.scala 210:20]
  wire  mask_eq_2 = mask_nbit & mask_nbit_1; // @[Misc.scala 213:27]
  wire  mask_acc_2 = mask_acc | mask_size_1 & mask_eq_2; // @[Misc.scala 214:29]
  wire  mask_eq_3 = mask_nbit & mask_bit_1; // @[Misc.scala 213:27]
  wire  mask_acc_3 = mask_acc | mask_size_1 & mask_eq_3; // @[Misc.scala 214:29]
  wire  mask_eq_4 = mask_bit & mask_nbit_1; // @[Misc.scala 213:27]
  wire  mask_acc_4 = mask_acc_1 | mask_size_1 & mask_eq_4; // @[Misc.scala 214:29]
  wire  mask_eq_5 = mask_bit & mask_bit_1; // @[Misc.scala 213:27]
  wire  mask_acc_5 = mask_acc_1 | mask_size_1 & mask_eq_5; // @[Misc.scala 214:29]
  wire  mask_size_2 = mask_sizeOH[0]; // @[Misc.scala 208:26]
  wire  mask_bit_2 = io_in_a_bits_address[0]; // @[Misc.scala 209:26]
  wire  mask_nbit_2 = ~mask_bit_2; // @[Misc.scala 210:20]
  wire  mask_eq_6 = mask_eq_2 & mask_nbit_2; // @[Misc.scala 213:27]
  wire  mask_lo_lo_lo = mask_acc_2 | mask_size_2 & mask_eq_6; // @[Misc.scala 214:29]
  wire  mask_eq_7 = mask_eq_2 & mask_bit_2; // @[Misc.scala 213:27]
  wire  mask_lo_lo_hi = mask_acc_2 | mask_size_2 & mask_eq_7; // @[Misc.scala 214:29]
  wire  mask_eq_8 = mask_eq_3 & mask_nbit_2; // @[Misc.scala 213:27]
  wire  mask_lo_hi_lo = mask_acc_3 | mask_size_2 & mask_eq_8; // @[Misc.scala 214:29]
  wire  mask_eq_9 = mask_eq_3 & mask_bit_2; // @[Misc.scala 213:27]
  wire  mask_lo_hi_hi = mask_acc_3 | mask_size_2 & mask_eq_9; // @[Misc.scala 214:29]
  wire  mask_eq_10 = mask_eq_4 & mask_nbit_2; // @[Misc.scala 213:27]
  wire  mask_hi_lo_lo = mask_acc_4 | mask_size_2 & mask_eq_10; // @[Misc.scala 214:29]
  wire  mask_eq_11 = mask_eq_4 & mask_bit_2; // @[Misc.scala 213:27]
  wire  mask_hi_lo_hi = mask_acc_4 | mask_size_2 & mask_eq_11; // @[Misc.scala 214:29]
  wire  mask_eq_12 = mask_eq_5 & mask_nbit_2; // @[Misc.scala 213:27]
  wire  mask_hi_hi_lo = mask_acc_5 | mask_size_2 & mask_eq_12; // @[Misc.scala 214:29]
  wire  mask_eq_13 = mask_eq_5 & mask_bit_2; // @[Misc.scala 213:27]
  wire  mask_hi_hi_hi = mask_acc_5 | mask_size_2 & mask_eq_13; // @[Misc.scala 214:29]
  wire [7:0] mask = {mask_hi_hi_hi,mask_hi_hi_lo,mask_hi_lo_hi,mask_hi_lo_lo,mask_lo_hi_hi,mask_lo_hi_lo,mask_lo_lo_hi,
    mask_lo_lo_lo}; // @[Cat.scala 30:58]
  wire [32:0] _T_7 = {1'b0,$signed(io_in_a_bits_address)}; // @[Parameters.scala 137:49]
  wire  _T_33 = io_in_a_bits_opcode == 3'h6; // @[Monitor.scala 81:25]
  wire  _T_35 = io_in_a_bits_size <= 4'hc; // @[Parameters.scala 92:42]
  wire  _T_42 = _T_35 & source_ok; // @[Parameters.scala 1160:30]
  wire [32:0] _T_48 = $signed(_T_7) & -33'sh1000; // @[Parameters.scala 137:52]
  wire  _T_49 = $signed(_T_48) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _T_50 = io_in_a_bits_address ^ 32'h3000; // @[Parameters.scala 137:31]
  wire [32:0] _T_51 = {1'b0,$signed(_T_50)}; // @[Parameters.scala 137:49]
  wire [32:0] _T_53 = $signed(_T_51) & -33'sh1000; // @[Parameters.scala 137:52]
  wire  _T_54 = $signed(_T_53) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _T_55 = io_in_a_bits_address ^ 32'h10000; // @[Parameters.scala 137:31]
  wire [32:0] _T_56 = {1'b0,$signed(_T_55)}; // @[Parameters.scala 137:49]
  wire [32:0] _T_58 = $signed(_T_56) & -33'sh10000; // @[Parameters.scala 137:52]
  wire  _T_59 = $signed(_T_58) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _T_60 = io_in_a_bits_address ^ 32'h2000000; // @[Parameters.scala 137:31]
  wire [32:0] _T_61 = {1'b0,$signed(_T_60)}; // @[Parameters.scala 137:49]
  wire [32:0] _T_63 = $signed(_T_61) & -33'sh10000; // @[Parameters.scala 137:52]
  wire  _T_64 = $signed(_T_63) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _T_65 = io_in_a_bits_address ^ 32'hc000000; // @[Parameters.scala 137:31]
  wire [32:0] _T_66 = {1'b0,$signed(_T_65)}; // @[Parameters.scala 137:49]
  wire [32:0] _T_68 = $signed(_T_66) & -33'sh4000000; // @[Parameters.scala 137:52]
  wire  _T_69 = $signed(_T_68) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _T_70 = io_in_a_bits_address ^ 32'h10000000; // @[Parameters.scala 137:31]
  wire [32:0] _T_71 = {1'b0,$signed(_T_70)}; // @[Parameters.scala 137:49]
  wire [32:0] _T_73 = $signed(_T_71) & -33'sh10000000; // @[Parameters.scala 137:52]
  wire  _T_74 = $signed(_T_73) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _T_75 = io_in_a_bits_address ^ 32'h20000000; // @[Parameters.scala 137:31]
  wire [32:0] _T_76 = {1'b0,$signed(_T_75)}; // @[Parameters.scala 137:49]
  wire [32:0] _T_78 = $signed(_T_76) & -33'sh20000000; // @[Parameters.scala 137:52]
  wire  _T_79 = $signed(_T_78) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _T_80 = io_in_a_bits_address ^ 32'h40000000; // @[Parameters.scala 137:31]
  wire [32:0] _T_81 = {1'b0,$signed(_T_80)}; // @[Parameters.scala 137:49]
  wire [32:0] _T_83 = $signed(_T_81) & -33'sh40000000; // @[Parameters.scala 137:52]
  wire  _T_84 = $signed(_T_83) == 33'sh0; // @[Parameters.scala 137:67]
  wire  _T_94 = io_in_a_bits_size <= 4'h6; // @[Parameters.scala 92:42]
  wire [31:0] _T_97 = io_in_a_bits_address ^ 32'h80000000; // @[Parameters.scala 137:31]
  wire [32:0] _T_98 = {1'b0,$signed(_T_97)}; // @[Parameters.scala 137:49]
  wire [32:0] _T_100 = $signed(_T_98) & -33'sh80000000; // @[Parameters.scala 137:52]
  wire  _T_101 = $signed(_T_100) == 33'sh0; // @[Parameters.scala 137:67]
  wire  _T_102 = _T_94 & _T_101; // @[Parameters.scala 670:56]
  wire  _T_105 = _T_42 & _T_102; // @[Monitor.scala 82:72]
  wire  _T_112 = 4'h6 == io_in_a_bits_size; // @[Parameters.scala 91:48]
  wire  _T_113 = _source_ok_T & _T_112; // @[Mux.scala 27:72]
  wire  _T_174 = _T_49 | _T_54 | _T_59 | _T_64 | _T_69 | _T_74 | _T_79 | _T_84 | _T_101; // @[Parameters.scala 671:42]
  wire  _T_175 = _T_35 & _T_174; // @[Parameters.scala 670:56]
  wire  _T_177 = _T_113 & _T_175; // @[Monitor.scala 83:78]
  wire  _T_191 = io_in_a_bits_param <= 3'h2; // @[Bundles.scala 108:27]
  wire [7:0] _T_195 = ~io_in_a_bits_mask; // @[Monitor.scala 88:18]
  wire  _T_196 = _T_195 == 8'h0; // @[Monitor.scala 88:31]
  wire  _T_200 = ~io_in_a_bits_corrupt; // @[Monitor.scala 89:18]
  wire  _T_204 = io_in_a_bits_opcode == 3'h7; // @[Monitor.scala 92:25]
  wire  _T_366 = io_in_a_bits_param != 3'h0; // @[Monitor.scala 99:31]
  wire  _T_379 = io_in_a_bits_opcode == 3'h4; // @[Monitor.scala 104:25]
  wire  _T_402 = _T_35 & _T_54; // @[Parameters.scala 670:56]
  wire  _T_453 = _T_49 | _T_59 | _T_64 | _T_69 | _T_74 | _T_79 | _T_84 | _T_101; // @[Parameters.scala 671:42]
  wire  _T_454 = _T_94 & _T_453; // @[Parameters.scala 670:56]
  wire  _T_456 = _T_402 | _T_454; // @[Parameters.scala 672:30]
  wire  _T_466 = io_in_a_bits_param == 3'h0; // @[Monitor.scala 109:31]
  wire  _T_470 = io_in_a_bits_mask == mask; // @[Monitor.scala 110:30]
  wire  _T_478 = io_in_a_bits_opcode == 3'h0; // @[Monitor.scala 114:25]
  wire  _T_525 = _T_49 | _T_64 | _T_69 | _T_101; // @[Parameters.scala 671:42]
  wire  _T_526 = _T_94 & _T_525; // @[Parameters.scala 670:56]
  wire  _T_535 = io_in_a_bits_size <= 4'h8; // @[Parameters.scala 92:42]
  wire  _T_554 = _T_74 | _T_79 | _T_84; // @[Parameters.scala 671:42]
  wire  _T_555 = _T_535 & _T_554; // @[Parameters.scala 670:56]
  wire  _T_559 = _T_402 | _T_526 | _T_555; // @[Parameters.scala 672:30]
  wire  _T_560 = _T_42 & _T_559; // @[Monitor.scala 115:71]
  wire  _T_578 = io_in_a_bits_opcode == 3'h1; // @[Monitor.scala 122:25]
  wire [7:0] _T_674 = ~mask; // @[Monitor.scala 127:33]
  wire [7:0] _T_675 = io_in_a_bits_mask & _T_674; // @[Monitor.scala 127:31]
  wire  _T_676 = _T_675 == 8'h0; // @[Monitor.scala 127:40]
  wire  _T_680 = io_in_a_bits_opcode == 3'h2; // @[Monitor.scala 130:25]
  wire  _T_692 = io_in_a_bits_size <= 4'h3; // @[Parameters.scala 92:42]
  wire  _T_717 = _T_49 | _T_54 | _T_64 | _T_69; // @[Parameters.scala 671:42]
  wire  _T_718 = _T_692 & _T_717; // @[Parameters.scala 670:56]
  wire  _T_752 = _T_42 & _T_718; // @[Monitor.scala 131:74]
  wire  _T_762 = io_in_a_bits_param <= 3'h4; // @[Bundles.scala 138:33]
  wire  _T_770 = io_in_a_bits_opcode == 3'h3; // @[Monitor.scala 138:25]
  wire  _T_852 = io_in_a_bits_param <= 3'h3; // @[Bundles.scala 145:30]
  wire  _T_860 = io_in_a_bits_opcode == 3'h5; // @[Monitor.scala 146:25]
  wire  _T_932 = _T_42 & _T_402; // @[Monitor.scala 147:68]
  wire  _T_942 = io_in_a_bits_param <= 3'h1; // @[Bundles.scala 158:28]
  wire  _T_954 = io_in_d_bits_opcode <= 3'h6; // @[Bundles.scala 42:24]
  wire  _source_ok_T_4 = io_in_d_bits_source == 2'h0; // @[Parameters.scala 46:9]
  wire  _source_ok_T_5 = io_in_d_bits_source == 2'h1; // @[Parameters.scala 46:9]
  wire  _source_ok_T_6 = io_in_d_bits_source == 2'h2; // @[Parameters.scala 46:9]
  wire  source_ok_1 = _source_ok_T_4 | _source_ok_T_5 | _source_ok_T_6; // @[Parameters.scala 1125:46]
  wire  _T_958 = io_in_d_bits_opcode == 3'h6; // @[Monitor.scala 310:25]
  wire  _T_962 = io_in_d_bits_size >= 4'h3; // @[Monitor.scala 312:27]
  wire  _T_966 = io_in_d_bits_param == 2'h0; // @[Monitor.scala 313:28]
  wire  _T_970 = ~io_in_d_bits_corrupt; // @[Monitor.scala 314:15]
  wire  _T_974 = ~io_in_d_bits_denied; // @[Monitor.scala 315:15]
  wire  _T_978 = io_in_d_bits_opcode == 3'h4; // @[Monitor.scala 318:25]
  wire  _T_989 = io_in_d_bits_param <= 2'h2; // @[Bundles.scala 102:26]
  wire  _T_993 = io_in_d_bits_param != 2'h2; // @[Monitor.scala 323:28]
  wire  _T_1006 = io_in_d_bits_opcode == 3'h5; // @[Monitor.scala 328:25]
  wire  _T_1026 = _T_974 | io_in_d_bits_corrupt; // @[Monitor.scala 334:30]
  wire  _T_1035 = io_in_d_bits_opcode == 3'h0; // @[Monitor.scala 338:25]
  wire  _T_1052 = io_in_d_bits_opcode == 3'h1; // @[Monitor.scala 346:25]
  wire  _T_1070 = io_in_d_bits_opcode == 3'h2; // @[Monitor.scala 354:25]
  wire  _T_1091 = io_in_b_bits_source == 2'h0; // @[Parameters.scala 46:9]
  wire [32:0] _T_1094 = {1'b0,$signed(io_in_b_bits_address)}; // @[Parameters.scala 137:49]
  wire  _T_1099 = io_in_b_bits_source == 2'h1; // @[Parameters.scala 46:9]
  wire  _T_1107 = io_in_b_bits_source == 2'h2; // @[Parameters.scala 46:9]
  wire [31:0] _address_ok_T = io_in_b_bits_address ^ 32'h3000; // @[Parameters.scala 137:31]
  wire [32:0] _address_ok_T_1 = {1'b0,$signed(_address_ok_T)}; // @[Parameters.scala 137:49]
  wire [32:0] _address_ok_T_3 = $signed(_address_ok_T_1) & -33'sh1000; // @[Parameters.scala 137:52]
  wire  _address_ok_T_4 = $signed(_address_ok_T_3) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _address_ok_T_5 = io_in_b_bits_address ^ 32'hc000000; // @[Parameters.scala 137:31]
  wire [32:0] _address_ok_T_6 = {1'b0,$signed(_address_ok_T_5)}; // @[Parameters.scala 137:49]
  wire [32:0] _address_ok_T_8 = $signed(_address_ok_T_6) & -33'sh4000000; // @[Parameters.scala 137:52]
  wire  _address_ok_T_9 = $signed(_address_ok_T_8) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _address_ok_T_10 = io_in_b_bits_address ^ 32'h2000000; // @[Parameters.scala 137:31]
  wire [32:0] _address_ok_T_11 = {1'b0,$signed(_address_ok_T_10)}; // @[Parameters.scala 137:49]
  wire [32:0] _address_ok_T_13 = $signed(_address_ok_T_11) & -33'sh10000; // @[Parameters.scala 137:52]
  wire  _address_ok_T_14 = $signed(_address_ok_T_13) == 33'sh0; // @[Parameters.scala 137:67]
  wire [32:0] _address_ok_T_18 = $signed(_T_1094) & -33'sh1000; // @[Parameters.scala 137:52]
  wire  _address_ok_T_19 = $signed(_address_ok_T_18) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _address_ok_T_20 = io_in_b_bits_address ^ 32'h10000; // @[Parameters.scala 137:31]
  wire [32:0] _address_ok_T_21 = {1'b0,$signed(_address_ok_T_20)}; // @[Parameters.scala 137:49]
  wire [32:0] _address_ok_T_23 = $signed(_address_ok_T_21) & -33'sh10000; // @[Parameters.scala 137:52]
  wire  _address_ok_T_24 = $signed(_address_ok_T_23) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _address_ok_T_25 = io_in_b_bits_address ^ 32'h80000000; // @[Parameters.scala 137:31]
  wire [32:0] _address_ok_T_26 = {1'b0,$signed(_address_ok_T_25)}; // @[Parameters.scala 137:49]
  wire [32:0] _address_ok_T_28 = $signed(_address_ok_T_26) & -33'sh80000000; // @[Parameters.scala 137:52]
  wire  _address_ok_T_29 = $signed(_address_ok_T_28) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _address_ok_T_30 = io_in_b_bits_address ^ 32'h10000000; // @[Parameters.scala 137:31]
  wire [32:0] _address_ok_T_31 = {1'b0,$signed(_address_ok_T_30)}; // @[Parameters.scala 137:49]
  wire [32:0] _address_ok_T_33 = $signed(_address_ok_T_31) & -33'sh10000000; // @[Parameters.scala 137:52]
  wire  _address_ok_T_34 = $signed(_address_ok_T_33) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _address_ok_T_35 = io_in_b_bits_address ^ 32'h20000000; // @[Parameters.scala 137:31]
  wire [32:0] _address_ok_T_36 = {1'b0,$signed(_address_ok_T_35)}; // @[Parameters.scala 137:49]
  wire [32:0] _address_ok_T_38 = $signed(_address_ok_T_36) & -33'sh20000000; // @[Parameters.scala 137:52]
  wire  _address_ok_T_39 = $signed(_address_ok_T_38) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _address_ok_T_40 = io_in_b_bits_address ^ 32'h40000000; // @[Parameters.scala 137:31]
  wire [32:0] _address_ok_T_41 = {1'b0,$signed(_address_ok_T_40)}; // @[Parameters.scala 137:49]
  wire [32:0] _address_ok_T_43 = $signed(_address_ok_T_41) & -33'sh40000000; // @[Parameters.scala 137:52]
  wire  _address_ok_T_44 = $signed(_address_ok_T_43) == 33'sh0; // @[Parameters.scala 137:67]
  wire  _address_ok_T_46 = _address_ok_T_34 | _address_ok_T_39 | _address_ok_T_44; // @[Parameters.scala 598:92]
  wire  address_ok = _address_ok_T_4 | _address_ok_T_9 | _address_ok_T_14 | _address_ok_T_19 | _address_ok_T_24 |
    _address_ok_T_29 | _address_ok_T_46; // @[Parameters.scala 622:64]
  wire [31:0] _is_aligned_T_1 = io_in_b_bits_address & 32'h3f; // @[Edges.scala 20:16]
  wire  is_aligned_1 = _is_aligned_T_1 == 32'h0; // @[Edges.scala 20:24]
  wire [1:0] _legal_source_T_5 = _T_1107 ? 2'h2 : 2'h0; // @[Mux.scala 27:72]
  wire [1:0] _GEN_87 = {{1'd0}, _T_1099}; // @[Mux.scala 27:72]
  wire [1:0] _legal_source_T_7 = _GEN_87 | _legal_source_T_5; // @[Mux.scala 27:72]
  wire  legal_source = _legal_source_T_7 == io_in_b_bits_source; // @[Monitor.scala 165:113]
  wire  _T_1186 = _address_ok_T_19 | _address_ok_T_4 | _address_ok_T_24 | _address_ok_T_14 | _address_ok_T_9 |
    _address_ok_T_34 | _address_ok_T_39 | _address_ok_T_44 | _address_ok_T_29; // @[Parameters.scala 671:42]
  wire  _T_1189 = _T_1091 & _T_1186; // @[Monitor.scala 168:75]
  wire  _T_1202 = io_in_b_bits_param <= 2'h2; // @[Bundles.scala 102:26]
  wire  _source_ok_T_8 = io_in_c_bits_source == 2'h0; // @[Parameters.scala 46:9]
  wire  _source_ok_T_9 = io_in_c_bits_source == 2'h1; // @[Parameters.scala 46:9]
  wire  _source_ok_T_10 = io_in_c_bits_source == 2'h2; // @[Parameters.scala 46:9]
  wire  source_ok_2 = _source_ok_T_8 | _source_ok_T_9 | _source_ok_T_10; // @[Parameters.scala 1125:46]
  wire [26:0] _is_aligned_mask_T_7 = 27'hfff << io_in_c_bits_size; // @[package.scala 234:77]
  wire [11:0] is_aligned_mask_2 = ~_is_aligned_mask_T_7[11:0]; // @[package.scala 234:46]
  wire [31:0] _GEN_88 = {{20'd0}, is_aligned_mask_2}; // @[Edges.scala 20:16]
  wire [31:0] _is_aligned_T_2 = io_in_c_bits_address & _GEN_88; // @[Edges.scala 20:16]
  wire  is_aligned_2 = _is_aligned_T_2 == 32'h0; // @[Edges.scala 20:24]
  wire [31:0] _address_ok_T_52 = io_in_c_bits_address ^ 32'h3000; // @[Parameters.scala 137:31]
  wire [32:0] _address_ok_T_53 = {1'b0,$signed(_address_ok_T_52)}; // @[Parameters.scala 137:49]
  wire [32:0] _address_ok_T_55 = $signed(_address_ok_T_53) & -33'sh1000; // @[Parameters.scala 137:52]
  wire  _address_ok_T_56 = $signed(_address_ok_T_55) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _address_ok_T_57 = io_in_c_bits_address ^ 32'hc000000; // @[Parameters.scala 137:31]
  wire [32:0] _address_ok_T_58 = {1'b0,$signed(_address_ok_T_57)}; // @[Parameters.scala 137:49]
  wire [32:0] _address_ok_T_60 = $signed(_address_ok_T_58) & -33'sh4000000; // @[Parameters.scala 137:52]
  wire  _address_ok_T_61 = $signed(_address_ok_T_60) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _address_ok_T_62 = io_in_c_bits_address ^ 32'h2000000; // @[Parameters.scala 137:31]
  wire [32:0] _address_ok_T_63 = {1'b0,$signed(_address_ok_T_62)}; // @[Parameters.scala 137:49]
  wire [32:0] _address_ok_T_65 = $signed(_address_ok_T_63) & -33'sh10000; // @[Parameters.scala 137:52]
  wire  _address_ok_T_66 = $signed(_address_ok_T_65) == 33'sh0; // @[Parameters.scala 137:67]
  wire [32:0] _address_ok_T_68 = {1'b0,$signed(io_in_c_bits_address)}; // @[Parameters.scala 137:49]
  wire [32:0] _address_ok_T_70 = $signed(_address_ok_T_68) & -33'sh1000; // @[Parameters.scala 137:52]
  wire  _address_ok_T_71 = $signed(_address_ok_T_70) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _address_ok_T_72 = io_in_c_bits_address ^ 32'h10000; // @[Parameters.scala 137:31]
  wire [32:0] _address_ok_T_73 = {1'b0,$signed(_address_ok_T_72)}; // @[Parameters.scala 137:49]
  wire [32:0] _address_ok_T_75 = $signed(_address_ok_T_73) & -33'sh10000; // @[Parameters.scala 137:52]
  wire  _address_ok_T_76 = $signed(_address_ok_T_75) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _address_ok_T_77 = io_in_c_bits_address ^ 32'h80000000; // @[Parameters.scala 137:31]
  wire [32:0] _address_ok_T_78 = {1'b0,$signed(_address_ok_T_77)}; // @[Parameters.scala 137:49]
  wire [32:0] _address_ok_T_80 = $signed(_address_ok_T_78) & -33'sh80000000; // @[Parameters.scala 137:52]
  wire  _address_ok_T_81 = $signed(_address_ok_T_80) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _address_ok_T_82 = io_in_c_bits_address ^ 32'h10000000; // @[Parameters.scala 137:31]
  wire [32:0] _address_ok_T_83 = {1'b0,$signed(_address_ok_T_82)}; // @[Parameters.scala 137:49]
  wire [32:0] _address_ok_T_85 = $signed(_address_ok_T_83) & -33'sh10000000; // @[Parameters.scala 137:52]
  wire  _address_ok_T_86 = $signed(_address_ok_T_85) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _address_ok_T_87 = io_in_c_bits_address ^ 32'h20000000; // @[Parameters.scala 137:31]
  wire [32:0] _address_ok_T_88 = {1'b0,$signed(_address_ok_T_87)}; // @[Parameters.scala 137:49]
  wire [32:0] _address_ok_T_90 = $signed(_address_ok_T_88) & -33'sh20000000; // @[Parameters.scala 137:52]
  wire  _address_ok_T_91 = $signed(_address_ok_T_90) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _address_ok_T_92 = io_in_c_bits_address ^ 32'h40000000; // @[Parameters.scala 137:31]
  wire [32:0] _address_ok_T_93 = {1'b0,$signed(_address_ok_T_92)}; // @[Parameters.scala 137:49]
  wire [32:0] _address_ok_T_95 = $signed(_address_ok_T_93) & -33'sh40000000; // @[Parameters.scala 137:52]
  wire  _address_ok_T_96 = $signed(_address_ok_T_95) == 33'sh0; // @[Parameters.scala 137:67]
  wire  _address_ok_T_98 = _address_ok_T_86 | _address_ok_T_91 | _address_ok_T_96; // @[Parameters.scala 598:92]
  wire  address_ok_1 = _address_ok_T_56 | _address_ok_T_61 | _address_ok_T_66 | _address_ok_T_71 | _address_ok_T_76 |
    _address_ok_T_81 | _address_ok_T_98; // @[Parameters.scala 622:64]
  wire  _T_1739 = io_in_c_bits_opcode == 3'h4; // @[Monitor.scala 242:25]
  wire  _T_1746 = io_in_c_bits_size >= 4'h3; // @[Monitor.scala 245:30]
  wire  _T_1753 = io_in_c_bits_param <= 3'h5; // @[Bundles.scala 120:29]
  wire  _T_1757 = ~io_in_c_bits_corrupt; // @[Monitor.scala 248:18]
  wire  _T_1761 = io_in_c_bits_opcode == 3'h5; // @[Monitor.scala 251:25]
  wire  _T_1779 = io_in_c_bits_opcode == 3'h6; // @[Monitor.scala 259:25]
  wire  _T_1781 = io_in_c_bits_size <= 4'hc; // @[Parameters.scala 92:42]
  wire  _T_1788 = _T_1781 & source_ok_2; // @[Parameters.scala 1160:30]
  wire  _T_1840 = io_in_c_bits_size <= 4'h6; // @[Parameters.scala 92:42]
  wire  _T_1848 = _T_1840 & _address_ok_T_81; // @[Parameters.scala 670:56]
  wire  _T_1851 = _T_1788 & _T_1848; // @[Monitor.scala 260:78]
  wire  _T_1858 = 4'h6 == io_in_c_bits_size; // @[Parameters.scala 91:48]
  wire  _T_1859 = _source_ok_T_8 & _T_1858; // @[Mux.scala 27:72]
  wire  _T_1920 = _address_ok_T_71 | _address_ok_T_56 | _address_ok_T_76 | _address_ok_T_66 | _address_ok_T_61 |
    _address_ok_T_86 | _address_ok_T_91 | _address_ok_T_96 | _address_ok_T_81; // @[Parameters.scala 671:42]
  wire  _T_1921 = _T_1781 & _T_1920; // @[Parameters.scala 670:56]
  wire  _T_1923 = _T_1859 & _T_1921; // @[Monitor.scala 261:78]
  wire  _T_1945 = io_in_c_bits_opcode == 3'h7; // @[Monitor.scala 269:25]
  wire  _T_2107 = io_in_c_bits_opcode == 3'h0; // @[Monitor.scala 278:25]
  wire  _T_2117 = io_in_c_bits_param == 3'h0; // @[Monitor.scala 282:31]
  wire  _T_2125 = io_in_c_bits_opcode == 3'h1; // @[Monitor.scala 286:25]
  wire  _T_2139 = io_in_c_bits_opcode == 3'h2; // @[Monitor.scala 293:25]
  wire  _a_first_T = io_in_a_ready & io_in_a_valid; // @[Decoupled.scala 40:37]
  wire [8:0] a_first_beats1_decode = is_aligned_mask[11:3]; // @[Edges.scala 219:59]
  wire  a_first_beats1_opdata = ~io_in_a_bits_opcode[2]; // @[Edges.scala 91:28]
  reg [8:0] a_first_counter; // @[Edges.scala 228:27]
  wire [8:0] a_first_counter1 = a_first_counter - 9'h1; // @[Edges.scala 229:28]
  wire  a_first = a_first_counter == 9'h0; // @[Edges.scala 230:25]
  reg [2:0] opcode; // @[Monitor.scala 384:22]
  reg [2:0] param; // @[Monitor.scala 385:22]
  reg [3:0] size; // @[Monitor.scala 386:22]
  reg [1:0] source; // @[Monitor.scala 387:22]
  reg [31:0] address; // @[Monitor.scala 388:22]
  wire  _T_2161 = io_in_a_valid & ~a_first; // @[Monitor.scala 389:19]
  wire  _T_2162 = io_in_a_bits_opcode == opcode; // @[Monitor.scala 390:32]
  wire  _T_2166 = io_in_a_bits_param == param; // @[Monitor.scala 391:32]
  wire  _T_2170 = io_in_a_bits_size == size; // @[Monitor.scala 392:32]
  wire  _T_2174 = io_in_a_bits_source == source; // @[Monitor.scala 393:32]
  wire  _T_2178 = io_in_a_bits_address == address; // @[Monitor.scala 394:32]
  wire  _d_first_T = io_in_d_ready & io_in_d_valid; // @[Decoupled.scala 40:37]
  wire [26:0] _d_first_beats1_decode_T_1 = 27'hfff << io_in_d_bits_size; // @[package.scala 234:77]
  wire [11:0] _d_first_beats1_decode_T_3 = ~_d_first_beats1_decode_T_1[11:0]; // @[package.scala 234:46]
  wire [8:0] d_first_beats1_decode = _d_first_beats1_decode_T_3[11:3]; // @[Edges.scala 219:59]
  wire  d_first_beats1_opdata = io_in_d_bits_opcode[0]; // @[Edges.scala 105:36]
  reg [8:0] d_first_counter; // @[Edges.scala 228:27]
  wire [8:0] d_first_counter1 = d_first_counter - 9'h1; // @[Edges.scala 229:28]
  wire  d_first = d_first_counter == 9'h0; // @[Edges.scala 230:25]
  reg [2:0] opcode_1; // @[Monitor.scala 535:22]
  reg [1:0] param_1; // @[Monitor.scala 536:22]
  reg [3:0] size_1; // @[Monitor.scala 537:22]
  reg [1:0] source_1; // @[Monitor.scala 538:22]
  reg [1:0] sink; // @[Monitor.scala 539:22]
  reg  denied; // @[Monitor.scala 540:22]
  wire  _T_2185 = io_in_d_valid & ~d_first; // @[Monitor.scala 541:19]
  wire  _T_2186 = io_in_d_bits_opcode == opcode_1; // @[Monitor.scala 542:29]
  wire  _T_2190 = io_in_d_bits_param == param_1; // @[Monitor.scala 543:29]
  wire  _T_2194 = io_in_d_bits_size == size_1; // @[Monitor.scala 544:29]
  wire  _T_2198 = io_in_d_bits_source == source_1; // @[Monitor.scala 545:29]
  wire  _T_2202 = io_in_d_bits_sink == sink; // @[Monitor.scala 546:29]
  wire  _T_2206 = io_in_d_bits_denied == denied; // @[Monitor.scala 547:29]
  wire  b_first_done = io_in_b_ready & io_in_b_valid; // @[Decoupled.scala 40:37]
  reg [8:0] b_first_counter; // @[Edges.scala 228:27]
  wire [8:0] b_first_counter1 = b_first_counter - 9'h1; // @[Edges.scala 229:28]
  wire  b_first = b_first_counter == 9'h0; // @[Edges.scala 230:25]
  reg [1:0] param_2; // @[Monitor.scala 408:22]
  reg [1:0] source_2; // @[Monitor.scala 410:22]
  reg [31:0] address_1; // @[Monitor.scala 411:22]
  wire  _T_2213 = io_in_b_valid & ~b_first; // @[Monitor.scala 412:19]
  wire  _T_2218 = io_in_b_bits_param == param_2; // @[Monitor.scala 414:32]
  wire  _T_2226 = io_in_b_bits_source == source_2; // @[Monitor.scala 416:32]
  wire  _T_2230 = io_in_b_bits_address == address_1; // @[Monitor.scala 417:32]
  wire  _c_first_T = io_in_c_ready & io_in_c_valid; // @[Decoupled.scala 40:37]
  wire [8:0] c_first_beats1_decode = is_aligned_mask_2[11:3]; // @[Edges.scala 219:59]
  wire  c_first_beats1_opdata = io_in_c_bits_opcode[0]; // @[Edges.scala 101:36]
  reg [8:0] c_first_counter; // @[Edges.scala 228:27]
  wire [8:0] c_first_counter1 = c_first_counter - 9'h1; // @[Edges.scala 229:28]
  wire  c_first = c_first_counter == 9'h0; // @[Edges.scala 230:25]
  reg [2:0] opcode_3; // @[Monitor.scala 512:22]
  reg [2:0] param_3; // @[Monitor.scala 513:22]
  reg [3:0] size_3; // @[Monitor.scala 514:22]
  reg [1:0] source_3; // @[Monitor.scala 515:22]
  reg [31:0] address_2; // @[Monitor.scala 516:22]
  wire  _T_2237 = io_in_c_valid & ~c_first; // @[Monitor.scala 517:19]
  wire  _T_2238 = io_in_c_bits_opcode == opcode_3; // @[Monitor.scala 518:32]
  wire  _T_2242 = io_in_c_bits_param == param_3; // @[Monitor.scala 519:32]
  wire  _T_2246 = io_in_c_bits_size == size_3; // @[Monitor.scala 520:32]
  wire  _T_2250 = io_in_c_bits_source == source_3; // @[Monitor.scala 521:32]
  wire  _T_2254 = io_in_c_bits_address == address_2; // @[Monitor.scala 522:32]
  reg [2:0] inflight; // @[Monitor.scala 611:27]
  reg [11:0] inflight_opcodes; // @[Monitor.scala 613:35]
  reg [23:0] inflight_sizes; // @[Monitor.scala 615:33]
  reg [8:0] a_first_counter_1; // @[Edges.scala 228:27]
  wire [8:0] a_first_counter1_1 = a_first_counter_1 - 9'h1; // @[Edges.scala 229:28]
  wire  a_first_1 = a_first_counter_1 == 9'h0; // @[Edges.scala 230:25]
  reg [8:0] d_first_counter_1; // @[Edges.scala 228:27]
  wire [8:0] d_first_counter1_1 = d_first_counter_1 - 9'h1; // @[Edges.scala 229:28]
  wire  d_first_1 = d_first_counter_1 == 9'h0; // @[Edges.scala 230:25]
  wire [3:0] _GEN_89 = {io_in_d_bits_source, 2'h0}; // @[Monitor.scala 634:69]
  wire [4:0] _a_opcode_lookup_T = {{1'd0}, _GEN_89}; // @[Monitor.scala 634:69]
  wire [11:0] _a_opcode_lookup_T_1 = inflight_opcodes >> _a_opcode_lookup_T; // @[Monitor.scala 634:44]
  wire [15:0] _a_opcode_lookup_T_5 = 16'h10 - 16'h1; // @[Monitor.scala 609:57]
  wire [15:0] _GEN_90 = {{4'd0}, _a_opcode_lookup_T_1}; // @[Monitor.scala 634:97]
  wire [15:0] _a_opcode_lookup_T_6 = _GEN_90 & _a_opcode_lookup_T_5; // @[Monitor.scala 634:97]
  wire [15:0] _a_opcode_lookup_T_7 = {{1'd0}, _a_opcode_lookup_T_6[15:1]}; // @[Monitor.scala 634:152]
  wire [4:0] _a_size_lookup_T = {io_in_d_bits_source, 3'h0}; // @[Monitor.scala 638:65]
  wire [23:0] _a_size_lookup_T_1 = inflight_sizes >> _a_size_lookup_T; // @[Monitor.scala 638:40]
  wire [15:0] _a_size_lookup_T_5 = 16'h100 - 16'h1; // @[Monitor.scala 609:57]
  wire [23:0] _GEN_92 = {{8'd0}, _a_size_lookup_T_5}; // @[Monitor.scala 638:91]
  wire [23:0] _a_size_lookup_T_6 = _a_size_lookup_T_1 & _GEN_92; // @[Monitor.scala 638:91]
  wire [23:0] _a_size_lookup_T_7 = {{1'd0}, _a_size_lookup_T_6[23:1]}; // @[Monitor.scala 638:144]
  wire  _T_2260 = io_in_a_valid & a_first_1; // @[Monitor.scala 648:26]
  wire [3:0] _a_set_wo_ready_T = 4'h1 << io_in_a_bits_source; // @[OneHot.scala 58:35]
  wire [3:0] _GEN_27 = io_in_a_valid & a_first_1 ? _a_set_wo_ready_T : 4'h0; // @[Monitor.scala 648:71 Monitor.scala 649:22]
  wire  _T_2263 = _a_first_T & a_first_1; // @[Monitor.scala 652:27]
  wire [3:0] _a_opcodes_set_interm_T = {io_in_a_bits_opcode, 1'h0}; // @[Monitor.scala 654:53]
  wire [3:0] _a_opcodes_set_interm_T_1 = _a_opcodes_set_interm_T | 4'h1; // @[Monitor.scala 654:61]
  wire [4:0] _a_sizes_set_interm_T = {io_in_a_bits_size, 1'h0}; // @[Monitor.scala 655:51]
  wire [4:0] _a_sizes_set_interm_T_1 = _a_sizes_set_interm_T | 5'h1; // @[Monitor.scala 655:59]
  wire [3:0] _GEN_94 = {io_in_a_bits_source, 2'h0}; // @[Monitor.scala 656:79]
  wire [4:0] _a_opcodes_set_T = {{1'd0}, _GEN_94}; // @[Monitor.scala 656:79]
  wire [3:0] a_opcodes_set_interm = _a_first_T & a_first_1 ? _a_opcodes_set_interm_T_1 : 4'h0; // @[Monitor.scala 652:72 Monitor.scala 654:28]
  wire [34:0] _GEN_95 = {{31'd0}, a_opcodes_set_interm}; // @[Monitor.scala 656:54]
  wire [34:0] _a_opcodes_set_T_1 = _GEN_95 << _a_opcodes_set_T; // @[Monitor.scala 656:54]
  wire [4:0] _a_sizes_set_T = {io_in_a_bits_source, 3'h0}; // @[Monitor.scala 657:77]
  wire [4:0] a_sizes_set_interm = _a_first_T & a_first_1 ? _a_sizes_set_interm_T_1 : 5'h0; // @[Monitor.scala 652:72 Monitor.scala 655:28]
  wire [35:0] _GEN_96 = {{31'd0}, a_sizes_set_interm}; // @[Monitor.scala 657:52]
  wire [35:0] _a_sizes_set_T_1 = _GEN_96 << _a_sizes_set_T; // @[Monitor.scala 657:52]
  wire [2:0] _T_2265 = inflight >> io_in_a_bits_source; // @[Monitor.scala 658:26]
  wire  _T_2267 = ~_T_2265[0]; // @[Monitor.scala 658:17]
  wire [3:0] _GEN_28 = _a_first_T & a_first_1 ? _a_set_wo_ready_T : 4'h0; // @[Monitor.scala 652:72 Monitor.scala 653:28]
  wire [34:0] _GEN_31 = _a_first_T & a_first_1 ? _a_opcodes_set_T_1 : 35'h0; // @[Monitor.scala 652:72 Monitor.scala 656:28]
  wire [35:0] _GEN_32 = _a_first_T & a_first_1 ? _a_sizes_set_T_1 : 36'h0; // @[Monitor.scala 652:72 Monitor.scala 657:28]
  wire  _T_2271 = io_in_d_valid & d_first_1; // @[Monitor.scala 671:26]
  wire  _T_2273 = ~_T_958; // @[Monitor.scala 671:74]
  wire  _T_2274 = io_in_d_valid & d_first_1 & ~_T_958; // @[Monitor.scala 671:71]
  wire [3:0] _d_clr_wo_ready_T = 4'h1 << io_in_d_bits_source; // @[OneHot.scala 58:35]
  wire [3:0] _GEN_33 = io_in_d_valid & d_first_1 & ~_T_958 ? _d_clr_wo_ready_T : 4'h0; // @[Monitor.scala 671:90 Monitor.scala 672:22]
  wire [46:0] _GEN_98 = {{31'd0}, _a_opcode_lookup_T_5}; // @[Monitor.scala 677:76]
  wire [46:0] _d_opcodes_clr_T_5 = _GEN_98 << _a_opcode_lookup_T; // @[Monitor.scala 677:76]
  wire [46:0] _GEN_99 = {{31'd0}, _a_size_lookup_T_5}; // @[Monitor.scala 678:74]
  wire [46:0] _d_sizes_clr_T_5 = _GEN_99 << _a_size_lookup_T; // @[Monitor.scala 678:74]
  wire [3:0] _GEN_34 = _d_first_T & d_first_1 & _T_2273 ? _d_clr_wo_ready_T : 4'h0; // @[Monitor.scala 675:91 Monitor.scala 676:21]
  wire [46:0] _GEN_35 = _d_first_T & d_first_1 & _T_2273 ? _d_opcodes_clr_T_5 : 47'h0; // @[Monitor.scala 675:91 Monitor.scala 677:21]
  wire [46:0] _GEN_36 = _d_first_T & d_first_1 & _T_2273 ? _d_sizes_clr_T_5 : 47'h0; // @[Monitor.scala 675:91 Monitor.scala 678:21]
  wire  _same_cycle_resp_T_2 = io_in_a_bits_source == io_in_d_bits_source; // @[Monitor.scala 681:113]
  wire  same_cycle_resp = _T_2260 & io_in_a_bits_source == io_in_d_bits_source; // @[Monitor.scala 681:88]
  wire [2:0] _T_2284 = inflight >> io_in_d_bits_source; // @[Monitor.scala 682:25]
  wire  _T_2286 = _T_2284[0] | same_cycle_resp; // @[Monitor.scala 682:49]
  wire [2:0] _GEN_39 = 3'h2 == io_in_a_bits_opcode ? 3'h1 : 3'h0; // @[Monitor.scala 685:38 Monitor.scala 685:38]
  wire [2:0] _GEN_40 = 3'h3 == io_in_a_bits_opcode ? 3'h1 : _GEN_39; // @[Monitor.scala 685:38 Monitor.scala 685:38]
  wire [2:0] _GEN_41 = 3'h4 == io_in_a_bits_opcode ? 3'h1 : _GEN_40; // @[Monitor.scala 685:38 Monitor.scala 685:38]
  wire [2:0] _GEN_42 = 3'h5 == io_in_a_bits_opcode ? 3'h2 : _GEN_41; // @[Monitor.scala 685:38 Monitor.scala 685:38]
  wire [2:0] _GEN_43 = 3'h6 == io_in_a_bits_opcode ? 3'h4 : _GEN_42; // @[Monitor.scala 685:38 Monitor.scala 685:38]
  wire [2:0] _GEN_44 = 3'h7 == io_in_a_bits_opcode ? 3'h4 : _GEN_43; // @[Monitor.scala 685:38 Monitor.scala 685:38]
  wire [2:0] _GEN_51 = 3'h6 == io_in_a_bits_opcode ? 3'h5 : _GEN_42; // @[Monitor.scala 686:39 Monitor.scala 686:39]
  wire [2:0] _GEN_52 = 3'h7 == io_in_a_bits_opcode ? 3'h4 : _GEN_51; // @[Monitor.scala 686:39 Monitor.scala 686:39]
  wire  _T_2291 = io_in_d_bits_opcode == _GEN_52; // @[Monitor.scala 686:39]
  wire  _T_2292 = io_in_d_bits_opcode == _GEN_44 | _T_2291; // @[Monitor.scala 685:77]
  wire  _T_2296 = io_in_a_bits_size == io_in_d_bits_size; // @[Monitor.scala 687:36]
  wire [3:0] a_opcode_lookup = _a_opcode_lookup_T_7[3:0];
  wire [2:0] _GEN_55 = 3'h2 == a_opcode_lookup[2:0] ? 3'h1 : 3'h0; // @[Monitor.scala 689:38 Monitor.scala 689:38]
  wire [2:0] _GEN_56 = 3'h3 == a_opcode_lookup[2:0] ? 3'h1 : _GEN_55; // @[Monitor.scala 689:38 Monitor.scala 689:38]
  wire [2:0] _GEN_57 = 3'h4 == a_opcode_lookup[2:0] ? 3'h1 : _GEN_56; // @[Monitor.scala 689:38 Monitor.scala 689:38]
  wire [2:0] _GEN_58 = 3'h5 == a_opcode_lookup[2:0] ? 3'h2 : _GEN_57; // @[Monitor.scala 689:38 Monitor.scala 689:38]
  wire [2:0] _GEN_59 = 3'h6 == a_opcode_lookup[2:0] ? 3'h4 : _GEN_58; // @[Monitor.scala 689:38 Monitor.scala 689:38]
  wire [2:0] _GEN_60 = 3'h7 == a_opcode_lookup[2:0] ? 3'h4 : _GEN_59; // @[Monitor.scala 689:38 Monitor.scala 689:38]
  wire [2:0] _GEN_67 = 3'h6 == a_opcode_lookup[2:0] ? 3'h5 : _GEN_58; // @[Monitor.scala 690:38 Monitor.scala 690:38]
  wire [2:0] _GEN_68 = 3'h7 == a_opcode_lookup[2:0] ? 3'h4 : _GEN_67; // @[Monitor.scala 690:38 Monitor.scala 690:38]
  wire  _T_2303 = io_in_d_bits_opcode == _GEN_68; // @[Monitor.scala 690:38]
  wire  _T_2304 = io_in_d_bits_opcode == _GEN_60 | _T_2303; // @[Monitor.scala 689:72]
  wire [7:0] a_size_lookup = _a_size_lookup_T_7[7:0];
  wire [7:0] _GEN_100 = {{4'd0}, io_in_d_bits_size}; // @[Monitor.scala 691:36]
  wire  _T_2308 = _GEN_100 == a_size_lookup; // @[Monitor.scala 691:36]
  wire  _T_2318 = _T_2271 & a_first_1 & io_in_a_valid & _same_cycle_resp_T_2 & _T_2273; // @[Monitor.scala 694:116]
  wire  _T_2319 = ~io_in_d_ready; // @[Monitor.scala 695:15]
  wire  _T_2320 = ~io_in_d_ready | io_in_a_ready; // @[Monitor.scala 695:32]
  wire [2:0] a_set_wo_ready = _GEN_27[2:0];
  wire [2:0] d_clr_wo_ready = _GEN_33[2:0];
  wire  _T_2327 = a_set_wo_ready != d_clr_wo_ready | ~(|a_set_wo_ready); // @[Monitor.scala 699:48]
  wire [2:0] a_set = _GEN_28[2:0];
  wire [2:0] _inflight_T = inflight | a_set; // @[Monitor.scala 702:27]
  wire [2:0] d_clr = _GEN_34[2:0];
  wire [2:0] _inflight_T_1 = ~d_clr; // @[Monitor.scala 702:38]
  wire [2:0] _inflight_T_2 = _inflight_T & _inflight_T_1; // @[Monitor.scala 702:36]
  wire [11:0] a_opcodes_set = _GEN_31[11:0];
  wire [11:0] _inflight_opcodes_T = inflight_opcodes | a_opcodes_set; // @[Monitor.scala 703:43]
  wire [11:0] d_opcodes_clr = _GEN_35[11:0];
  wire [11:0] _inflight_opcodes_T_1 = ~d_opcodes_clr; // @[Monitor.scala 703:62]
  wire [11:0] _inflight_opcodes_T_2 = _inflight_opcodes_T & _inflight_opcodes_T_1; // @[Monitor.scala 703:60]
  wire [23:0] a_sizes_set = _GEN_32[23:0];
  wire [23:0] _inflight_sizes_T = inflight_sizes | a_sizes_set; // @[Monitor.scala 704:39]
  wire [23:0] d_sizes_clr = _GEN_36[23:0];
  wire [23:0] _inflight_sizes_T_1 = ~d_sizes_clr; // @[Monitor.scala 704:56]
  wire [23:0] _inflight_sizes_T_2 = _inflight_sizes_T & _inflight_sizes_T_1; // @[Monitor.scala 704:54]
  reg [31:0] watchdog; // @[Monitor.scala 706:27]
  wire  _T_2336 = ~(|inflight) | plusarg_reader_out == 32'h0 | watchdog < plusarg_reader_out; // @[Monitor.scala 709:47]
  wire [31:0] _watchdog_T_1 = watchdog + 32'h1; // @[Monitor.scala 711:26]
  reg [2:0] inflight_1; // @[Monitor.scala 723:35]
  reg [23:0] inflight_sizes_1; // @[Monitor.scala 725:35]
  reg [8:0] c_first_counter_1; // @[Edges.scala 228:27]
  wire [8:0] c_first_counter1_1 = c_first_counter_1 - 9'h1; // @[Edges.scala 229:28]
  wire  c_first_1 = c_first_counter_1 == 9'h0; // @[Edges.scala 230:25]
  reg [8:0] d_first_counter_2; // @[Edges.scala 228:27]
  wire [8:0] d_first_counter1_2 = d_first_counter_2 - 9'h1; // @[Edges.scala 229:28]
  wire  d_first_2 = d_first_counter_2 == 9'h0; // @[Edges.scala 230:25]
  wire [23:0] _c_size_lookup_T_1 = inflight_sizes_1 >> _a_size_lookup_T; // @[Monitor.scala 747:42]
  wire [23:0] _c_size_lookup_T_6 = _c_size_lookup_T_1 & _GEN_92; // @[Monitor.scala 747:93]
  wire [23:0] _c_size_lookup_T_7 = {{1'd0}, _c_size_lookup_T_6[23:1]}; // @[Monitor.scala 747:146]
  wire  _T_2346 = io_in_c_bits_opcode[2] & io_in_c_bits_opcode[1]; // @[Edges.scala 67:40]
  wire  _T_2347 = io_in_c_valid & c_first_1 & _T_2346; // @[Monitor.scala 756:37]
  wire [3:0] _c_set_wo_ready_T = 4'h1 << io_in_c_bits_source; // @[OneHot.scala 58:35]
  wire [3:0] _GEN_72 = io_in_c_valid & c_first_1 & _T_2346 ? _c_set_wo_ready_T : 4'h0; // @[Monitor.scala 756:71 Monitor.scala 757:22]
  wire  _T_2353 = _c_first_T & c_first_1 & _T_2346; // @[Monitor.scala 760:38]
  wire [4:0] _c_sizes_set_interm_T = {io_in_c_bits_size, 1'h0}; // @[Monitor.scala 763:51]
  wire [4:0] _c_sizes_set_interm_T_1 = _c_sizes_set_interm_T | 5'h1; // @[Monitor.scala 763:59]
  wire [4:0] _c_sizes_set_T = {io_in_c_bits_source, 3'h0}; // @[Monitor.scala 765:77]
  wire [4:0] c_sizes_set_interm = _c_first_T & c_first_1 & _T_2346 ? _c_sizes_set_interm_T_1 : 5'h0; // @[Monitor.scala 760:72 Monitor.scala 763:28]
  wire [35:0] _GEN_108 = {{31'd0}, c_sizes_set_interm}; // @[Monitor.scala 765:52]
  wire [35:0] _c_sizes_set_T_1 = _GEN_108 << _c_sizes_set_T; // @[Monitor.scala 765:52]
  wire [2:0] _T_2354 = inflight_1 >> io_in_c_bits_source; // @[Monitor.scala 766:26]
  wire  _T_2356 = ~_T_2354[0]; // @[Monitor.scala 766:17]
  wire [3:0] _GEN_73 = _c_first_T & c_first_1 & _T_2346 ? _c_set_wo_ready_T : 4'h0; // @[Monitor.scala 760:72 Monitor.scala 761:28]
  wire [35:0] _GEN_77 = _c_first_T & c_first_1 & _T_2346 ? _c_sizes_set_T_1 : 36'h0; // @[Monitor.scala 760:72 Monitor.scala 765:28]
  wire  _T_2360 = io_in_d_valid & d_first_2; // @[Monitor.scala 779:26]
  wire  _T_2362 = io_in_d_valid & d_first_2 & _T_958; // @[Monitor.scala 779:71]
  wire [3:0] _GEN_78 = io_in_d_valid & d_first_2 & _T_958 ? _d_clr_wo_ready_T : 4'h0; // @[Monitor.scala 779:89 Monitor.scala 780:22]
  wire [3:0] _GEN_79 = _d_first_T & d_first_2 & _T_958 ? _d_clr_wo_ready_T : 4'h0; // @[Monitor.scala 783:90 Monitor.scala 784:21]
  wire [46:0] _GEN_81 = _d_first_T & d_first_2 & _T_958 ? _d_sizes_clr_T_5 : 47'h0; // @[Monitor.scala 783:90 Monitor.scala 786:21]
  wire  _same_cycle_resp_T_8 = io_in_c_bits_source == io_in_d_bits_source; // @[Monitor.scala 790:113]
  wire  same_cycle_resp_1 = _T_2347 & io_in_c_bits_source == io_in_d_bits_source; // @[Monitor.scala 790:88]
  wire [2:0] _T_2370 = inflight_1 >> io_in_d_bits_source; // @[Monitor.scala 791:25]
  wire  _T_2372 = _T_2370[0] | same_cycle_resp_1; // @[Monitor.scala 791:49]
  wire  _T_2376 = io_in_d_bits_size == io_in_c_bits_size; // @[Monitor.scala 793:36]
  wire [7:0] c_size_lookup = _c_size_lookup_T_7[7:0];
  wire  _T_2380 = _GEN_100 == c_size_lookup; // @[Monitor.scala 795:36]
  wire  _T_2389 = _T_2360 & c_first_1 & io_in_c_valid & _same_cycle_resp_T_8 & _T_958; // @[Monitor.scala 799:116]
  wire  _T_2391 = _T_2319 | io_in_c_ready; // @[Monitor.scala 800:32]
  wire [2:0] c_set_wo_ready = _GEN_72[2:0];
  wire  _T_2395 = |c_set_wo_ready; // @[Monitor.scala 804:28]
  wire [2:0] d_clr_wo_ready_1 = _GEN_78[2:0];
  wire  _T_2396 = c_set_wo_ready != d_clr_wo_ready_1; // @[Monitor.scala 805:31]
  wire [2:0] c_set = _GEN_73[2:0];
  wire [2:0] _inflight_T_3 = inflight_1 | c_set; // @[Monitor.scala 809:35]
  wire [2:0] d_clr_1 = _GEN_79[2:0];
  wire [2:0] _inflight_T_4 = ~d_clr_1; // @[Monitor.scala 809:46]
  wire [2:0] _inflight_T_5 = _inflight_T_3 & _inflight_T_4; // @[Monitor.scala 809:44]
  wire [23:0] c_sizes_set = _GEN_77[23:0];
  wire [23:0] _inflight_sizes_T_3 = inflight_sizes_1 | c_sizes_set; // @[Monitor.scala 811:41]
  wire [23:0] d_sizes_clr_1 = _GEN_81[23:0];
  wire [23:0] _inflight_sizes_T_4 = ~d_sizes_clr_1; // @[Monitor.scala 811:58]
  wire [23:0] _inflight_sizes_T_5 = _inflight_sizes_T_3 & _inflight_sizes_T_4; // @[Monitor.scala 811:56]
  reg [31:0] watchdog_1; // @[Monitor.scala 813:27]
  wire  _T_2405 = ~(|inflight_1) | plusarg_reader_1_out == 32'h0 | watchdog_1 < plusarg_reader_1_out; // @[Monitor.scala 816:47]
  wire [31:0] _watchdog_T_3 = watchdog_1 + 32'h1; // @[Monitor.scala 818:26]
  reg [3:0] inflight_2; // @[Monitor.scala 823:27]
  reg [8:0] d_first_counter_3; // @[Edges.scala 228:27]
  wire [8:0] d_first_counter1_3 = d_first_counter_3 - 9'h1; // @[Edges.scala 229:28]
  wire  d_first_3 = d_first_counter_3 == 9'h0; // @[Edges.scala 230:25]
  wire  _T_2417 = io_in_d_bits_opcode[2] & ~io_in_d_bits_opcode[1]; // @[Edges.scala 70:40]
  wire  _T_2418 = _d_first_T & d_first_3 & _T_2417; // @[Monitor.scala 829:38]
  wire [3:0] _d_set_T = 4'h1 << io_in_d_bits_sink; // @[OneHot.scala 58:35]
  wire [3:0] _T_2419 = inflight_2 >> io_in_d_bits_sink; // @[Monitor.scala 831:23]
  wire  _T_2421 = ~_T_2419[0]; // @[Monitor.scala 831:14]
  wire [3:0] d_set = _d_first_T & d_first_3 & _T_2417 ? _d_set_T : 4'h0; // @[Monitor.scala 829:72 Monitor.scala 830:13]
  wire  _T_2425 = io_in_e_ready & io_in_e_valid; // @[Decoupled.scala 40:37]
  wire [3:0] _e_clr_T = 4'h1 << io_in_e_bits_sink; // @[OneHot.scala 58:35]
  wire [3:0] _T_2428 = d_set | inflight_2; // @[Monitor.scala 837:24]
  wire [3:0] _T_2429 = _T_2428 >> io_in_e_bits_sink; // @[Monitor.scala 837:35]
  wire [3:0] e_clr = _T_2425 ? _e_clr_T : 4'h0; // @[Monitor.scala 835:73 Monitor.scala 836:13]
  wire [3:0] _inflight_T_6 = inflight_2 | d_set; // @[Monitor.scala 842:27]
  wire [3:0] _inflight_T_7 = ~e_clr; // @[Monitor.scala 842:38]
  wire [3:0] _inflight_T_8 = _inflight_T_6 & _inflight_T_7; // @[Monitor.scala 842:36]
  plusarg_reader #(.FORMAT("tilelink_timeout=%d"), .DEFAULT(0), .WIDTH(32)) plusarg_reader ( // @[PlusArg.scala 80:11]
    .out(plusarg_reader_out)
  );
  plusarg_reader #(.FORMAT("tilelink_timeout=%d"), .DEFAULT(0), .WIDTH(32)) plusarg_reader_1 ( // @[PlusArg.scala 80:11]
    .out(plusarg_reader_1_out)
  );
  always @(posedge clock) begin
    if (reset) begin // @[Edges.scala 228:27]
      a_first_counter <= 9'h0; // @[Edges.scala 228:27]
    end else if (_a_first_T) begin // @[Edges.scala 234:17]
      if (a_first) begin // @[Edges.scala 235:21]
        if (a_first_beats1_opdata) begin // @[Edges.scala 220:14]
          a_first_counter <= a_first_beats1_decode;
        end else begin
          a_first_counter <= 9'h0;
        end
      end else begin
        a_first_counter <= a_first_counter1;
      end
    end
    if (_a_first_T & a_first) begin // @[Monitor.scala 396:32]
      opcode <= io_in_a_bits_opcode; // @[Monitor.scala 397:15]
    end
    if (_a_first_T & a_first) begin // @[Monitor.scala 396:32]
      param <= io_in_a_bits_param; // @[Monitor.scala 398:15]
    end
    if (_a_first_T & a_first) begin // @[Monitor.scala 396:32]
      size <= io_in_a_bits_size; // @[Monitor.scala 399:15]
    end
    if (_a_first_T & a_first) begin // @[Monitor.scala 396:32]
      source <= io_in_a_bits_source; // @[Monitor.scala 400:15]
    end
    if (_a_first_T & a_first) begin // @[Monitor.scala 396:32]
      address <= io_in_a_bits_address; // @[Monitor.scala 401:15]
    end
    if (reset) begin // @[Edges.scala 228:27]
      d_first_counter <= 9'h0; // @[Edges.scala 228:27]
    end else if (_d_first_T) begin // @[Edges.scala 234:17]
      if (d_first) begin // @[Edges.scala 235:21]
        if (d_first_beats1_opdata) begin // @[Edges.scala 220:14]
          d_first_counter <= d_first_beats1_decode;
        end else begin
          d_first_counter <= 9'h0;
        end
      end else begin
        d_first_counter <= d_first_counter1;
      end
    end
    if (_d_first_T & d_first) begin // @[Monitor.scala 549:32]
      opcode_1 <= io_in_d_bits_opcode; // @[Monitor.scala 550:15]
    end
    if (_d_first_T & d_first) begin // @[Monitor.scala 549:32]
      param_1 <= io_in_d_bits_param; // @[Monitor.scala 551:15]
    end
    if (_d_first_T & d_first) begin // @[Monitor.scala 549:32]
      size_1 <= io_in_d_bits_size; // @[Monitor.scala 552:15]
    end
    if (_d_first_T & d_first) begin // @[Monitor.scala 549:32]
      source_1 <= io_in_d_bits_source; // @[Monitor.scala 553:15]
    end
    if (_d_first_T & d_first) begin // @[Monitor.scala 549:32]
      sink <= io_in_d_bits_sink; // @[Monitor.scala 554:15]
    end
    if (_d_first_T & d_first) begin // @[Monitor.scala 549:32]
      denied <= io_in_d_bits_denied; // @[Monitor.scala 555:15]
    end
    if (reset) begin // @[Edges.scala 228:27]
      b_first_counter <= 9'h0; // @[Edges.scala 228:27]
    end else if (b_first_done) begin // @[Edges.scala 234:17]
      if (b_first) begin // @[Edges.scala 235:21]
        b_first_counter <= 9'h0;
      end else begin
        b_first_counter <= b_first_counter1;
      end
    end
    if (b_first_done & b_first) begin // @[Monitor.scala 419:32]
      param_2 <= io_in_b_bits_param; // @[Monitor.scala 421:15]
    end
    if (b_first_done & b_first) begin // @[Monitor.scala 419:32]
      source_2 <= io_in_b_bits_source; // @[Monitor.scala 423:15]
    end
    if (b_first_done & b_first) begin // @[Monitor.scala 419:32]
      address_1 <= io_in_b_bits_address; // @[Monitor.scala 424:15]
    end
    if (reset) begin // @[Edges.scala 228:27]
      c_first_counter <= 9'h0; // @[Edges.scala 228:27]
    end else if (_c_first_T) begin // @[Edges.scala 234:17]
      if (c_first) begin // @[Edges.scala 235:21]
        if (c_first_beats1_opdata) begin // @[Edges.scala 220:14]
          c_first_counter <= c_first_beats1_decode;
        end else begin
          c_first_counter <= 9'h0;
        end
      end else begin
        c_first_counter <= c_first_counter1;
      end
    end
    if (_c_first_T & c_first) begin // @[Monitor.scala 524:32]
      opcode_3 <= io_in_c_bits_opcode; // @[Monitor.scala 525:15]
    end
    if (_c_first_T & c_first) begin // @[Monitor.scala 524:32]
      param_3 <= io_in_c_bits_param; // @[Monitor.scala 526:15]
    end
    if (_c_first_T & c_first) begin // @[Monitor.scala 524:32]
      size_3 <= io_in_c_bits_size; // @[Monitor.scala 527:15]
    end
    if (_c_first_T & c_first) begin // @[Monitor.scala 524:32]
      source_3 <= io_in_c_bits_source; // @[Monitor.scala 528:15]
    end
    if (_c_first_T & c_first) begin // @[Monitor.scala 524:32]
      address_2 <= io_in_c_bits_address; // @[Monitor.scala 529:15]
    end
    if (reset) begin // @[Monitor.scala 611:27]
      inflight <= 3'h0; // @[Monitor.scala 611:27]
    end else begin
      inflight <= _inflight_T_2; // @[Monitor.scala 702:14]
    end
    if (reset) begin // @[Monitor.scala 613:35]
      inflight_opcodes <= 12'h0; // @[Monitor.scala 613:35]
    end else begin
      inflight_opcodes <= _inflight_opcodes_T_2; // @[Monitor.scala 703:22]
    end
    if (reset) begin // @[Monitor.scala 615:33]
      inflight_sizes <= 24'h0; // @[Monitor.scala 615:33]
    end else begin
      inflight_sizes <= _inflight_sizes_T_2; // @[Monitor.scala 704:20]
    end
    if (reset) begin // @[Edges.scala 228:27]
      a_first_counter_1 <= 9'h0; // @[Edges.scala 228:27]
    end else if (_a_first_T) begin // @[Edges.scala 234:17]
      if (a_first_1) begin // @[Edges.scala 235:21]
        if (a_first_beats1_opdata) begin // @[Edges.scala 220:14]
          a_first_counter_1 <= a_first_beats1_decode;
        end else begin
          a_first_counter_1 <= 9'h0;
        end
      end else begin
        a_first_counter_1 <= a_first_counter1_1;
      end
    end
    if (reset) begin // @[Edges.scala 228:27]
      d_first_counter_1 <= 9'h0; // @[Edges.scala 228:27]
    end else if (_d_first_T) begin // @[Edges.scala 234:17]
      if (d_first_1) begin // @[Edges.scala 235:21]
        if (d_first_beats1_opdata) begin // @[Edges.scala 220:14]
          d_first_counter_1 <= d_first_beats1_decode;
        end else begin
          d_first_counter_1 <= 9'h0;
        end
      end else begin
        d_first_counter_1 <= d_first_counter1_1;
      end
    end
    if (reset) begin // @[Monitor.scala 706:27]
      watchdog <= 32'h0; // @[Monitor.scala 706:27]
    end else if (_a_first_T | _d_first_T) begin // @[Monitor.scala 712:47]
      watchdog <= 32'h0; // @[Monitor.scala 712:58]
    end else begin
      watchdog <= _watchdog_T_1; // @[Monitor.scala 711:14]
    end
    if (reset) begin // @[Monitor.scala 723:35]
      inflight_1 <= 3'h0; // @[Monitor.scala 723:35]
    end else begin
      inflight_1 <= _inflight_T_5; // @[Monitor.scala 809:22]
    end
    if (reset) begin // @[Monitor.scala 725:35]
      inflight_sizes_1 <= 24'h0; // @[Monitor.scala 725:35]
    end else begin
      inflight_sizes_1 <= _inflight_sizes_T_5; // @[Monitor.scala 811:22]
    end
    if (reset) begin // @[Edges.scala 228:27]
      c_first_counter_1 <= 9'h0; // @[Edges.scala 228:27]
    end else if (_c_first_T) begin // @[Edges.scala 234:17]
      if (c_first_1) begin // @[Edges.scala 235:21]
        if (c_first_beats1_opdata) begin // @[Edges.scala 220:14]
          c_first_counter_1 <= c_first_beats1_decode;
        end else begin
          c_first_counter_1 <= 9'h0;
        end
      end else begin
        c_first_counter_1 <= c_first_counter1_1;
      end
    end
    if (reset) begin // @[Edges.scala 228:27]
      d_first_counter_2 <= 9'h0; // @[Edges.scala 228:27]
    end else if (_d_first_T) begin // @[Edges.scala 234:17]
      if (d_first_2) begin // @[Edges.scala 235:21]
        if (d_first_beats1_opdata) begin // @[Edges.scala 220:14]
          d_first_counter_2 <= d_first_beats1_decode;
        end else begin
          d_first_counter_2 <= 9'h0;
        end
      end else begin
        d_first_counter_2 <= d_first_counter1_2;
      end
    end
    if (reset) begin // @[Monitor.scala 813:27]
      watchdog_1 <= 32'h0; // @[Monitor.scala 813:27]
    end else if (_c_first_T | _d_first_T) begin // @[Monitor.scala 819:47]
      watchdog_1 <= 32'h0; // @[Monitor.scala 819:58]
    end else begin
      watchdog_1 <= _watchdog_T_3; // @[Monitor.scala 818:14]
    end
    if (reset) begin // @[Monitor.scala 823:27]
      inflight_2 <= 4'h0; // @[Monitor.scala 823:27]
    end else begin
      inflight_2 <= _inflight_T_8; // @[Monitor.scala 842:14]
    end
    if (reset) begin // @[Edges.scala 228:27]
      d_first_counter_3 <= 9'h0; // @[Edges.scala 228:27]
    end else if (_d_first_T) begin // @[Edges.scala 234:17]
      if (d_first_3) begin // @[Edges.scala 235:21]
        if (d_first_beats1_opdata) begin // @[Edges.scala 220:14]
          d_first_counter_3 <= d_first_beats1_decode;
        end else begin
          d_first_counter_3 <= 9'h0;
        end
      end else begin
        d_first_counter_3 <= d_first_counter1_3;
      end
    end
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_33 & ~(_T_105 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries AcquireBlock type which is unexpected using diplomatic parameters (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_33 & ~(_T_105 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_33 & ~(_T_177 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries AcquireBlock from a client which does not support Probe (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_33 & ~(_T_177 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_33 & ~(source_ok | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquireBlock carries invalid source ID (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_33 & ~(source_ok | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_33 & ~(_mask_T | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquireBlock smaller than a beat (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_33 & ~(_mask_T | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_33 & ~(is_aligned | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquireBlock address not aligned to size (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_33 & ~(is_aligned | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_33 & ~(_T_191 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquireBlock carries invalid grow param (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_33 & ~(_T_191 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_33 & ~(_T_196 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquireBlock contains invalid mask (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_33 & ~(_T_196 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_33 & ~(_T_200 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquireBlock is corrupt (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_33 & ~(_T_200 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_204 & ~(_T_105 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries AcquirePerm type which is unexpected using diplomatic parameters (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_204 & ~(_T_105 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_204 & ~(_T_177 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries AcquirePerm from a client which does not support Probe (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_204 & ~(_T_177 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_204 & ~(source_ok | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquirePerm carries invalid source ID (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_204 & ~(source_ok | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_204 & ~(_mask_T | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquirePerm smaller than a beat (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_204 & ~(_mask_T | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_204 & ~(is_aligned | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquirePerm address not aligned to size (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_204 & ~(is_aligned | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_204 & ~(_T_191 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquirePerm carries invalid grow param (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_204 & ~(_T_191 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_204 & ~(_T_366 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquirePerm requests NtoB (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_204 & ~(_T_366 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_204 & ~(_T_196 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquirePerm contains invalid mask (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_204 & ~(_T_196 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_204 & ~(_T_200 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquirePerm is corrupt (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_204 & ~(_T_200 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_379 & ~(_T_42 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries Get type which master claims it can't emit (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_379 & ~(_T_42 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_379 & ~(_T_456 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries Get type which slave claims it can't support (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_379 & ~(_T_456 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_379 & ~(source_ok | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Get carries invalid source ID (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_379 & ~(source_ok | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_379 & ~(is_aligned | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Get address not aligned to size (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_379 & ~(is_aligned | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_379 & ~(_T_466 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Get carries invalid param (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_379 & ~(_T_466 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_379 & ~(_T_470 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Get contains invalid mask (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_379 & ~(_T_470 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_379 & ~(_T_200 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Get is corrupt (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_379 & ~(_T_200 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_478 & ~(_T_560 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries PutFull type which is unexpected using diplomatic parameters (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_478 & ~(_T_560 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_478 & ~(source_ok | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel PutFull carries invalid source ID (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_478 & ~(source_ok | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_478 & ~(is_aligned | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel PutFull address not aligned to size (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_478 & ~(is_aligned | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_478 & ~(_T_466 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel PutFull carries invalid param (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_478 & ~(_T_466 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_478 & ~(_T_470 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel PutFull contains invalid mask (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_478 & ~(_T_470 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_578 & ~(_T_560 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries PutPartial type which is unexpected using diplomatic parameters (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_578 & ~(_T_560 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_578 & ~(source_ok | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel PutPartial carries invalid source ID (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_578 & ~(source_ok | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_578 & ~(is_aligned | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel PutPartial address not aligned to size (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_578 & ~(is_aligned | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_578 & ~(_T_466 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel PutPartial carries invalid param (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_578 & ~(_T_466 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_578 & ~(_T_676 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel PutPartial contains invalid mask (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_578 & ~(_T_676 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_680 & ~(_T_752 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries Arithmetic type which is unexpected using diplomatic parameters (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_680 & ~(_T_752 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_680 & ~(source_ok | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Arithmetic carries invalid source ID (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_680 & ~(source_ok | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_680 & ~(is_aligned | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Arithmetic address not aligned to size (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_680 & ~(is_aligned | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_680 & ~(_T_762 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Arithmetic carries invalid opcode param (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_680 & ~(_T_762 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_680 & ~(_T_470 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Arithmetic contains invalid mask (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_680 & ~(_T_470 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_770 & ~(_T_752 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries Logical type which is unexpected using diplomatic parameters (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_770 & ~(_T_752 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_770 & ~(source_ok | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Logical carries invalid source ID (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_770 & ~(source_ok | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_770 & ~(is_aligned | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Logical address not aligned to size (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_770 & ~(is_aligned | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_770 & ~(_T_852 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Logical carries invalid opcode param (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_770 & ~(_T_852 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_770 & ~(_T_470 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Logical contains invalid mask (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_770 & ~(_T_470 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_860 & ~(_T_932 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries Hint type which is unexpected using diplomatic parameters (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_860 & ~(_T_932 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_860 & ~(source_ok | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Hint carries invalid source ID (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_860 & ~(source_ok | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_860 & ~(is_aligned | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Hint address not aligned to size (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_860 & ~(is_aligned | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_860 & ~(_T_942 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Hint carries invalid opcode param (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_860 & ~(_T_942 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_860 & ~(_T_470 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Hint contains invalid mask (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_860 & ~(_T_470 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_860 & ~(_T_200 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Hint is corrupt (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_860 & ~(_T_200 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & ~(_T_954 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel has invalid opcode (connected at SystemBus.scala:41:96)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & ~(_T_954 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_958 & ~(source_ok_1 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel ReleaseAck carries invalid source ID (connected at SystemBus.scala:41:96)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_958 & ~(source_ok_1 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_958 & ~(_T_962 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel ReleaseAck smaller than a beat (connected at SystemBus.scala:41:96)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_958 & ~(_T_962 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_958 & ~(_T_966 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel ReleaseeAck carries invalid param (connected at SystemBus.scala:41:96)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_958 & ~(_T_966 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_958 & ~(_T_970 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel ReleaseAck is corrupt (connected at SystemBus.scala:41:96)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_958 & ~(_T_970 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_958 & ~(_T_974 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel ReleaseAck is denied (connected at SystemBus.scala:41:96)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_958 & ~(_T_974 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_978 & ~(source_ok_1 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel Grant carries invalid source ID (connected at SystemBus.scala:41:96)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_978 & ~(source_ok_1 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_978 & ~(_T_962 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel Grant smaller than a beat (connected at SystemBus.scala:41:96)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_978 & ~(_T_962 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_978 & ~(_T_989 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel Grant carries invalid cap param (connected at SystemBus.scala:41:96)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_978 & ~(_T_989 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_978 & ~(_T_993 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel Grant carries toN param (connected at SystemBus.scala:41:96)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_978 & ~(_T_993 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_978 & ~(_T_970 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel Grant is corrupt (connected at SystemBus.scala:41:96)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_978 & ~(_T_970 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_1006 & ~(source_ok_1 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel GrantData carries invalid source ID (connected at SystemBus.scala:41:96)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_1006 & ~(source_ok_1 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_1006 & ~(_T_962 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel GrantData smaller than a beat (connected at SystemBus.scala:41:96)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_1006 & ~(_T_962 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_1006 & ~(_T_989 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel GrantData carries invalid cap param (connected at SystemBus.scala:41:96)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_1006 & ~(_T_989 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_1006 & ~(_T_993 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel GrantData carries toN param (connected at SystemBus.scala:41:96)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_1006 & ~(_T_993 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_1006 & ~(_T_1026 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel GrantData is denied but not corrupt (connected at SystemBus.scala:41:96)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_1006 & ~(_T_1026 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_1035 & ~(source_ok_1 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel AccessAck carries invalid source ID (connected at SystemBus.scala:41:96)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_1035 & ~(source_ok_1 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_1035 & ~(_T_966 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel AccessAck carries invalid param (connected at SystemBus.scala:41:96)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_1035 & ~(_T_966 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_1035 & ~(_T_970 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel AccessAck is corrupt (connected at SystemBus.scala:41:96)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_1035 & ~(_T_970 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_1052 & ~(source_ok_1 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel AccessAckData carries invalid source ID (connected at SystemBus.scala:41:96)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_1052 & ~(source_ok_1 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_1052 & ~(_T_966 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel AccessAckData carries invalid param (connected at SystemBus.scala:41:96)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_1052 & ~(_T_966 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_1052 & ~(_T_1026 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel AccessAckData is denied but not corrupt (connected at SystemBus.scala:41:96)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_1052 & ~(_T_1026 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_1070 & ~(source_ok_1 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel HintAck carries invalid source ID (connected at SystemBus.scala:41:96)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_1070 & ~(source_ok_1 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_1070 & ~(_T_966 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel HintAck carries invalid param (connected at SystemBus.scala:41:96)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_1070 & ~(_T_966 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_1070 & ~(_T_970 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel HintAck is corrupt (connected at SystemBus.scala:41:96)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_1070 & ~(_T_970 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_b_valid & ~(_T_1189 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'B' channel carries Probe type which is unexpected using diplomatic parameters (connected at SystemBus.scala:41:96)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_b_valid & ~(_T_1189 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_b_valid & ~(address_ok | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'B' channel Probe carries unmanaged address (connected at SystemBus.scala:41:96)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_b_valid & ~(address_ok | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_b_valid & ~(legal_source | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'B' channel Probe carries source that is not first source (connected at SystemBus.scala:41:96)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_b_valid & ~(legal_source | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_b_valid & ~(is_aligned_1 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'B' channel Probe address not aligned to size (connected at SystemBus.scala:41:96)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_b_valid & ~(is_aligned_1 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_b_valid & ~(_T_1202 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'B' channel Probe carries invalid cap param (connected at SystemBus.scala:41:96)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_b_valid & ~(_T_1202 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1739 & ~(address_ok_1 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel ProbeAck carries unmanaged address (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1739 & ~(address_ok_1 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1739 & ~(source_ok_2 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel ProbeAck carries invalid source ID (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1739 & ~(source_ok_2 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1739 & ~(_T_1746 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel ProbeAck smaller than a beat (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1739 & ~(_T_1746 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1739 & ~(is_aligned_2 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel ProbeAck address not aligned to size (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1739 & ~(is_aligned_2 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1739 & ~(_T_1753 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel ProbeAck carries invalid report param (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1739 & ~(_T_1753 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1739 & ~(_T_1757 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel ProbeAck is corrupt (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1739 & ~(_T_1757 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1761 & ~(address_ok_1 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel ProbeAckData carries unmanaged address (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1761 & ~(address_ok_1 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1761 & ~(source_ok_2 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel ProbeAckData carries invalid source ID (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1761 & ~(source_ok_2 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1761 & ~(_T_1746 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel ProbeAckData smaller than a beat (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1761 & ~(_T_1746 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1761 & ~(is_aligned_2 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel ProbeAckData address not aligned to size (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1761 & ~(is_aligned_2 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1761 & ~(_T_1753 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel ProbeAckData carries invalid report param (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1761 & ~(_T_1753 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1779 & ~(_T_1851 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel carries Release type unsupported by manager (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1779 & ~(_T_1851 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1779 & ~(_T_1923 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel carries Release from a client which does not support Probe (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1779 & ~(_T_1923 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1779 & ~(source_ok_2 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel Release carries invalid source ID (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1779 & ~(source_ok_2 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1779 & ~(_T_1746 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel Release smaller than a beat (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1779 & ~(_T_1746 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1779 & ~(is_aligned_2 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel Release address not aligned to size (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1779 & ~(is_aligned_2 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1779 & ~(_T_1753 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel Release carries invalid report param (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1779 & ~(_T_1753 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1779 & ~(_T_1757 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel Release is corrupt (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1779 & ~(_T_1757 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1945 & ~(_T_1851 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel carries ReleaseData type unsupported by manager (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1945 & ~(_T_1851 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1945 & ~(_T_1923 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel carries Release from a client which does not support Probe (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1945 & ~(_T_1923 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1945 & ~(source_ok_2 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel ReleaseData carries invalid source ID (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1945 & ~(source_ok_2 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1945 & ~(_T_1746 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel ReleaseData smaller than a beat (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1945 & ~(_T_1746 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1945 & ~(is_aligned_2 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel ReleaseData address not aligned to size (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1945 & ~(is_aligned_2 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1945 & ~(_T_1753 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel ReleaseData carries invalid report param (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1945 & ~(_T_1753 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_2107 & ~(address_ok_1 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel AccessAck carries unmanaged address (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_2107 & ~(address_ok_1 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_2107 & ~(source_ok_2 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel AccessAck carries invalid source ID (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_2107 & ~(source_ok_2 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_2107 & ~(is_aligned_2 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel AccessAck address not aligned to size (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_2107 & ~(is_aligned_2 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_2107 & ~(_T_2117 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel AccessAck carries invalid param (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_2107 & ~(_T_2117 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_2107 & ~(_T_1757 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel AccessAck is corrupt (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_2107 & ~(_T_1757 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_2125 & ~(address_ok_1 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel AccessAckData carries unmanaged address (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_2125 & ~(address_ok_1 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_2125 & ~(source_ok_2 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel AccessAckData carries invalid source ID (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_2125 & ~(source_ok_2 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_2125 & ~(is_aligned_2 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel AccessAckData address not aligned to size (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_2125 & ~(is_aligned_2 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_2125 & ~(_T_2117 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel AccessAckData carries invalid param (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_2125 & ~(_T_2117 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_2139 & ~(address_ok_1 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel HintAck carries unmanaged address (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_2139 & ~(address_ok_1 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_2139 & ~(source_ok_2 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel HintAck carries invalid source ID (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_2139 & ~(source_ok_2 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_2139 & ~(is_aligned_2 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel HintAck address not aligned to size (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_2139 & ~(is_aligned_2 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_2139 & ~(_T_2117 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel HintAck carries invalid param (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_2139 & ~(_T_2117 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_2139 & ~(_T_1757 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel HintAck is corrupt (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_2139 & ~(_T_1757 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_2161 & ~(_T_2162 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel opcode changed within multibeat operation (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_2161 & ~(_T_2162 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_2161 & ~(_T_2166 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel param changed within multibeat operation (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_2161 & ~(_T_2166 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_2161 & ~(_T_2170 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel size changed within multibeat operation (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_2161 & ~(_T_2170 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_2161 & ~(_T_2174 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel source changed within multibeat operation (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_2161 & ~(_T_2174 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_2161 & ~(_T_2178 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel address changed with multibeat operation (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_2161 & ~(_T_2178 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_2185 & ~(_T_2186 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel opcode changed within multibeat operation (connected at SystemBus.scala:41:96)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_2185 & ~(_T_2186 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_2185 & ~(_T_2190 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel param changed within multibeat operation (connected at SystemBus.scala:41:96)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_2185 & ~(_T_2190 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_2185 & ~(_T_2194 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel size changed within multibeat operation (connected at SystemBus.scala:41:96)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_2185 & ~(_T_2194 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_2185 & ~(_T_2198 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel source changed within multibeat operation (connected at SystemBus.scala:41:96)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_2185 & ~(_T_2198 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_2185 & ~(_T_2202 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel sink changed with multibeat operation (connected at SystemBus.scala:41:96)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_2185 & ~(_T_2202 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_2185 & ~(_T_2206 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel denied changed with multibeat operation (connected at SystemBus.scala:41:96)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_2185 & ~(_T_2206 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_2213 & ~(_T_2218 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'B' channel param changed within multibeat operation (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_2213 & ~(_T_2218 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_2213 & ~(_T_2226 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'B' channel source changed within multibeat operation (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_2213 & ~(_T_2226 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_2213 & ~(_T_2230 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'B' channel addresss changed with multibeat operation (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_2213 & ~(_T_2230 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_2237 & ~(_T_2238 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel opcode changed within multibeat operation (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_2237 & ~(_T_2238 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_2237 & ~(_T_2242 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel param changed within multibeat operation (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_2237 & ~(_T_2242 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_2237 & ~(_T_2246 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel size changed within multibeat operation (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_2237 & ~(_T_2246 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_2237 & ~(_T_2250 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel source changed within multibeat operation (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_2237 & ~(_T_2250 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_2237 & ~(_T_2254 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel address changed with multibeat operation (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_2237 & ~(_T_2254 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_2263 & ~(_T_2267 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel re-used a source ID (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_2263 & ~(_T_2267 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_2274 & ~(_T_2286 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel acknowledged for nothing inflight (connected at SystemBus.scala:41:96)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_2274 & ~(_T_2286 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_2274 & same_cycle_resp & ~(_T_2292 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel contains improper opcode response (connected at SystemBus.scala:41:96)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_2274 & same_cycle_resp & ~(_T_2292 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_2274 & same_cycle_resp & ~(_T_2296 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel contains improper response size (connected at SystemBus.scala:41:96)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_2274 & same_cycle_resp & ~(_T_2296 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_2274 & ~same_cycle_resp & ~(_T_2304 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel contains improper opcode response (connected at SystemBus.scala:41:96)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_2274 & ~same_cycle_resp & ~(_T_2304 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_2274 & ~same_cycle_resp & ~(_T_2308 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel contains improper response size (connected at SystemBus.scala:41:96)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_2274 & ~same_cycle_resp & ~(_T_2308 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_2318 & ~(_T_2320 | reset)) begin
          $fwrite(32'h80000002,"Assertion failed: ready check\n    at Monitor.scala:49 assert(cond, message)\n"); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_2318 & ~(_T_2320 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (~(_T_2327 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' and 'D' concurrent, despite minlatency 1 (connected at SystemBus.scala:41:96)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (~(_T_2327 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (~(_T_2336 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: TileLink timeout expired (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (~(_T_2336 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_2353 & ~(_T_2356 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel re-used a source ID (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_2353 & ~(_T_2356 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_2362 & ~(_T_2372 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel acknowledged for nothing inflight (connected at SystemBus.scala:41:96)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_2362 & ~(_T_2372 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_2362 & same_cycle_resp_1 & ~(_T_2376 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel contains improper response size (connected at SystemBus.scala:41:96)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_2362 & same_cycle_resp_1 & ~(_T_2376 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_2362 & ~same_cycle_resp_1 & ~(_T_2380 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel contains improper response size (connected at SystemBus.scala:41:96)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_2362 & ~same_cycle_resp_1 & ~(_T_2380 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_2389 & ~(_T_2391 | reset)) begin
          $fwrite(32'h80000002,"Assertion failed: ready check\n    at Monitor.scala:49 assert(cond, message)\n"); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_2389 & ~(_T_2391 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_2395 & ~(_T_2396 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' and 'D' concurrent, despite minlatency 1 (connected at SystemBus.scala:41:96)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_2395 & ~(_T_2396 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (~(_T_2405 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: TileLink timeout expired (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (~(_T_2405 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_2418 & ~(_T_2421 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel re-used a sink ID (connected at SystemBus.scala:41:96)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_2418 & ~(_T_2421 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_2425 & ~(_T_2429[0] | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'E' channel acknowledged for nothing inflight (connected at SystemBus.scala:41:96)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_2425 & ~(_T_2429[0] | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
  end
// Register and memory initialization
`ifdef RANDOMIZE_GARBAGE_ASSIGN
`define RANDOMIZE
`endif
`ifdef RANDOMIZE_INVALID_ASSIGN
`define RANDOMIZE
`endif
`ifdef RANDOMIZE_REG_INIT
`define RANDOMIZE
`endif
`ifdef RANDOMIZE_MEM_INIT
`define RANDOMIZE
`endif
`ifndef RANDOM
`define RANDOM $random
`endif
`ifdef RANDOMIZE_MEM_INIT
  integer initvar;
`endif
`ifndef SYNTHESIS
`ifdef FIRRTL_BEFORE_INITIAL
`FIRRTL_BEFORE_INITIAL
`endif
initial begin
  `ifdef RANDOMIZE
    `ifdef INIT_RANDOM
      `INIT_RANDOM
    `endif
    `ifndef VERILATOR
      `ifdef RANDOMIZE_DELAY
        #`RANDOMIZE_DELAY begin end
      `else
        #0.002 begin end
      `endif
    `endif
`ifdef RANDOMIZE_REG_INIT
  _RAND_0 = {1{`RANDOM}};
  a_first_counter = _RAND_0[8:0];
  _RAND_1 = {1{`RANDOM}};
  opcode = _RAND_1[2:0];
  _RAND_2 = {1{`RANDOM}};
  param = _RAND_2[2:0];
  _RAND_3 = {1{`RANDOM}};
  size = _RAND_3[3:0];
  _RAND_4 = {1{`RANDOM}};
  source = _RAND_4[1:0];
  _RAND_5 = {1{`RANDOM}};
  address = _RAND_5[31:0];
  _RAND_6 = {1{`RANDOM}};
  d_first_counter = _RAND_6[8:0];
  _RAND_7 = {1{`RANDOM}};
  opcode_1 = _RAND_7[2:0];
  _RAND_8 = {1{`RANDOM}};
  param_1 = _RAND_8[1:0];
  _RAND_9 = {1{`RANDOM}};
  size_1 = _RAND_9[3:0];
  _RAND_10 = {1{`RANDOM}};
  source_1 = _RAND_10[1:0];
  _RAND_11 = {1{`RANDOM}};
  sink = _RAND_11[1:0];
  _RAND_12 = {1{`RANDOM}};
  denied = _RAND_12[0:0];
  _RAND_13 = {1{`RANDOM}};
  b_first_counter = _RAND_13[8:0];
  _RAND_14 = {1{`RANDOM}};
  param_2 = _RAND_14[1:0];
  _RAND_15 = {1{`RANDOM}};
  source_2 = _RAND_15[1:0];
  _RAND_16 = {1{`RANDOM}};
  address_1 = _RAND_16[31:0];
  _RAND_17 = {1{`RANDOM}};
  c_first_counter = _RAND_17[8:0];
  _RAND_18 = {1{`RANDOM}};
  opcode_3 = _RAND_18[2:0];
  _RAND_19 = {1{`RANDOM}};
  param_3 = _RAND_19[2:0];
  _RAND_20 = {1{`RANDOM}};
  size_3 = _RAND_20[3:0];
  _RAND_21 = {1{`RANDOM}};
  source_3 = _RAND_21[1:0];
  _RAND_22 = {1{`RANDOM}};
  address_2 = _RAND_22[31:0];
  _RAND_23 = {1{`RANDOM}};
  inflight = _RAND_23[2:0];
  _RAND_24 = {1{`RANDOM}};
  inflight_opcodes = _RAND_24[11:0];
  _RAND_25 = {1{`RANDOM}};
  inflight_sizes = _RAND_25[23:0];
  _RAND_26 = {1{`RANDOM}};
  a_first_counter_1 = _RAND_26[8:0];
  _RAND_27 = {1{`RANDOM}};
  d_first_counter_1 = _RAND_27[8:0];
  _RAND_28 = {1{`RANDOM}};
  watchdog = _RAND_28[31:0];
  _RAND_29 = {1{`RANDOM}};
  inflight_1 = _RAND_29[2:0];
  _RAND_30 = {1{`RANDOM}};
  inflight_sizes_1 = _RAND_30[23:0];
  _RAND_31 = {1{`RANDOM}};
  c_first_counter_1 = _RAND_31[8:0];
  _RAND_32 = {1{`RANDOM}};
  d_first_counter_2 = _RAND_32[8:0];
  _RAND_33 = {1{`RANDOM}};
  watchdog_1 = _RAND_33[31:0];
  _RAND_34 = {1{`RANDOM}};
  inflight_2 = _RAND_34[3:0];
  _RAND_35 = {1{`RANDOM}};
  d_first_counter_3 = _RAND_35[8:0];
`endif // RANDOMIZE_REG_INIT
  `endif // RANDOMIZE
end // initial
`ifdef FIRRTL_AFTER_INITIAL
`FIRRTL_AFTER_INITIAL
`endif
`endif // SYNTHESIS
endmodule
module TLFIFOFixer(
  input         clock,
  input         reset,
  output        auto_in_4_a_ready,
  input         auto_in_4_a_valid,
  input  [2:0]  auto_in_4_a_bits_opcode,
  input  [2:0]  auto_in_4_a_bits_param,
  input  [3:0]  auto_in_4_a_bits_size,
  input  [1:0]  auto_in_4_a_bits_source,
  input  [31:0] auto_in_4_a_bits_address,
  input  [7:0]  auto_in_4_a_bits_mask,
  input  [63:0] auto_in_4_a_bits_data,
  input         auto_in_4_a_bits_corrupt,
  input         auto_in_4_b_ready,
  output        auto_in_4_b_valid,
  output [1:0]  auto_in_4_b_bits_param,
  output [1:0]  auto_in_4_b_bits_source,
  output [31:0] auto_in_4_b_bits_address,
  output        auto_in_4_c_ready,
  input         auto_in_4_c_valid,
  input  [2:0]  auto_in_4_c_bits_opcode,
  input  [2:0]  auto_in_4_c_bits_param,
  input  [3:0]  auto_in_4_c_bits_size,
  input  [1:0]  auto_in_4_c_bits_source,
  input  [31:0] auto_in_4_c_bits_address,
  input  [63:0] auto_in_4_c_bits_data,
  input         auto_in_4_c_bits_corrupt,
  input         auto_in_4_d_ready,
  output        auto_in_4_d_valid,
  output [2:0]  auto_in_4_d_bits_opcode,
  output [1:0]  auto_in_4_d_bits_param,
  output [3:0]  auto_in_4_d_bits_size,
  output [1:0]  auto_in_4_d_bits_source,
  output [1:0]  auto_in_4_d_bits_sink,
  output        auto_in_4_d_bits_denied,
  output [63:0] auto_in_4_d_bits_data,
  output        auto_in_4_d_bits_corrupt,
  output        auto_in_4_e_ready,
  input         auto_in_4_e_valid,
  input  [1:0]  auto_in_4_e_bits_sink,
  output        auto_in_3_a_ready,
  input         auto_in_3_a_valid,
  input  [2:0]  auto_in_3_a_bits_opcode,
  input  [2:0]  auto_in_3_a_bits_param,
  input  [3:0]  auto_in_3_a_bits_size,
  input  [1:0]  auto_in_3_a_bits_source,
  input  [31:0] auto_in_3_a_bits_address,
  input  [7:0]  auto_in_3_a_bits_mask,
  input  [63:0] auto_in_3_a_bits_data,
  input         auto_in_3_a_bits_corrupt,
  input         auto_in_3_b_ready,
  output        auto_in_3_b_valid,
  output [1:0]  auto_in_3_b_bits_param,
  output [1:0]  auto_in_3_b_bits_source,
  output [31:0] auto_in_3_b_bits_address,
  output        auto_in_3_c_ready,
  input         auto_in_3_c_valid,
  input  [2:0]  auto_in_3_c_bits_opcode,
  input  [2:0]  auto_in_3_c_bits_param,
  input  [3:0]  auto_in_3_c_bits_size,
  input  [1:0]  auto_in_3_c_bits_source,
  input  [31:0] auto_in_3_c_bits_address,
  input  [63:0] auto_in_3_c_bits_data,
  input         auto_in_3_c_bits_corrupt,
  input         auto_in_3_d_ready,
  output        auto_in_3_d_valid,
  output [2:0]  auto_in_3_d_bits_opcode,
  output [1:0]  auto_in_3_d_bits_param,
  output [3:0]  auto_in_3_d_bits_size,
  output [1:0]  auto_in_3_d_bits_source,
  output [1:0]  auto_in_3_d_bits_sink,
  output        auto_in_3_d_bits_denied,
  output [63:0] auto_in_3_d_bits_data,
  output        auto_in_3_d_bits_corrupt,
  output        auto_in_3_e_ready,
  input         auto_in_3_e_valid,
  input  [1:0]  auto_in_3_e_bits_sink,
  output        auto_in_2_a_ready,
  input         auto_in_2_a_valid,
  input  [2:0]  auto_in_2_a_bits_opcode,
  input  [2:0]  auto_in_2_a_bits_param,
  input  [3:0]  auto_in_2_a_bits_size,
  input  [1:0]  auto_in_2_a_bits_source,
  input  [31:0] auto_in_2_a_bits_address,
  input  [7:0]  auto_in_2_a_bits_mask,
  input  [63:0] auto_in_2_a_bits_data,
  input         auto_in_2_a_bits_corrupt,
  input         auto_in_2_b_ready,
  output        auto_in_2_b_valid,
  output [1:0]  auto_in_2_b_bits_param,
  output [1:0]  auto_in_2_b_bits_source,
  output [31:0] auto_in_2_b_bits_address,
  output        auto_in_2_c_ready,
  input         auto_in_2_c_valid,
  input  [2:0]  auto_in_2_c_bits_opcode,
  input  [2:0]  auto_in_2_c_bits_param,
  input  [3:0]  auto_in_2_c_bits_size,
  input  [1:0]  auto_in_2_c_bits_source,
  input  [31:0] auto_in_2_c_bits_address,
  input  [63:0] auto_in_2_c_bits_data,
  input         auto_in_2_c_bits_corrupt,
  input         auto_in_2_d_ready,
  output        auto_in_2_d_valid,
  output [2:0]  auto_in_2_d_bits_opcode,
  output [1:0]  auto_in_2_d_bits_param,
  output [3:0]  auto_in_2_d_bits_size,
  output [1:0]  auto_in_2_d_bits_source,
  output [1:0]  auto_in_2_d_bits_sink,
  output        auto_in_2_d_bits_denied,
  output [63:0] auto_in_2_d_bits_data,
  output        auto_in_2_d_bits_corrupt,
  output        auto_in_2_e_ready,
  input         auto_in_2_e_valid,
  input  [1:0]  auto_in_2_e_bits_sink,
  output        auto_in_1_a_ready,
  input         auto_in_1_a_valid,
  input  [2:0]  auto_in_1_a_bits_opcode,
  input  [2:0]  auto_in_1_a_bits_param,
  input  [3:0]  auto_in_1_a_bits_size,
  input  [1:0]  auto_in_1_a_bits_source,
  input  [31:0] auto_in_1_a_bits_address,
  input  [7:0]  auto_in_1_a_bits_mask,
  input  [63:0] auto_in_1_a_bits_data,
  input         auto_in_1_a_bits_corrupt,
  input         auto_in_1_b_ready,
  output        auto_in_1_b_valid,
  output [1:0]  auto_in_1_b_bits_param,
  output [1:0]  auto_in_1_b_bits_source,
  output [31:0] auto_in_1_b_bits_address,
  output        auto_in_1_c_ready,
  input         auto_in_1_c_valid,
  input  [2:0]  auto_in_1_c_bits_opcode,
  input  [2:0]  auto_in_1_c_bits_param,
  input  [3:0]  auto_in_1_c_bits_size,
  input  [1:0]  auto_in_1_c_bits_source,
  input  [31:0] auto_in_1_c_bits_address,
  input  [63:0] auto_in_1_c_bits_data,
  input         auto_in_1_c_bits_corrupt,
  input         auto_in_1_d_ready,
  output        auto_in_1_d_valid,
  output [2:0]  auto_in_1_d_bits_opcode,
  output [1:0]  auto_in_1_d_bits_param,
  output [3:0]  auto_in_1_d_bits_size,
  output [1:0]  auto_in_1_d_bits_source,
  output [1:0]  auto_in_1_d_bits_sink,
  output        auto_in_1_d_bits_denied,
  output [63:0] auto_in_1_d_bits_data,
  output        auto_in_1_d_bits_corrupt,
  output        auto_in_1_e_ready,
  input         auto_in_1_e_valid,
  input  [1:0]  auto_in_1_e_bits_sink,
  output        auto_in_0_a_ready,
  input         auto_in_0_a_valid,
  input  [2:0]  auto_in_0_a_bits_opcode,
  input  [2:0]  auto_in_0_a_bits_param,
  input  [3:0]  auto_in_0_a_bits_size,
  input  [3:0]  auto_in_0_a_bits_source,
  input  [31:0] auto_in_0_a_bits_address,
  input         auto_in_0_a_bits_user_amba_prot_bufferable,
  input         auto_in_0_a_bits_user_amba_prot_modifiable,
  input         auto_in_0_a_bits_user_amba_prot_readalloc,
  input         auto_in_0_a_bits_user_amba_prot_writealloc,
  input         auto_in_0_a_bits_user_amba_prot_privileged,
  input         auto_in_0_a_bits_user_amba_prot_secure,
  input         auto_in_0_a_bits_user_amba_prot_fetch,
  input  [7:0]  auto_in_0_a_bits_mask,
  input  [63:0] auto_in_0_a_bits_data,
  input         auto_in_0_a_bits_corrupt,
  input         auto_in_0_d_ready,
  output        auto_in_0_d_valid,
  output [2:0]  auto_in_0_d_bits_opcode,
  output [1:0]  auto_in_0_d_bits_param,
  output [3:0]  auto_in_0_d_bits_size,
  output [3:0]  auto_in_0_d_bits_source,
  output [1:0]  auto_in_0_d_bits_sink,
  output        auto_in_0_d_bits_denied,
  output [63:0] auto_in_0_d_bits_data,
  output        auto_in_0_d_bits_corrupt,
  input         auto_out_4_a_ready,
  output        auto_out_4_a_valid,
  output [2:0]  auto_out_4_a_bits_opcode,
  output [2:0]  auto_out_4_a_bits_param,
  output [3:0]  auto_out_4_a_bits_size,
  output [1:0]  auto_out_4_a_bits_source,
  output [31:0] auto_out_4_a_bits_address,
  output [7:0]  auto_out_4_a_bits_mask,
  output [63:0] auto_out_4_a_bits_data,
  output        auto_out_4_a_bits_corrupt,
  output        auto_out_4_b_ready,
  input         auto_out_4_b_valid,
  input  [1:0]  auto_out_4_b_bits_param,
  input  [1:0]  auto_out_4_b_bits_source,
  input  [31:0] auto_out_4_b_bits_address,
  input         auto_out_4_c_ready,
  output        auto_out_4_c_valid,
  output [2:0]  auto_out_4_c_bits_opcode,
  output [2:0]  auto_out_4_c_bits_param,
  output [3:0]  auto_out_4_c_bits_size,
  output [1:0]  auto_out_4_c_bits_source,
  output [31:0] auto_out_4_c_bits_address,
  output [63:0] auto_out_4_c_bits_data,
  output        auto_out_4_c_bits_corrupt,
  output        auto_out_4_d_ready,
  input         auto_out_4_d_valid,
  input  [2:0]  auto_out_4_d_bits_opcode,
  input  [1:0]  auto_out_4_d_bits_param,
  input  [3:0]  auto_out_4_d_bits_size,
  input  [1:0]  auto_out_4_d_bits_source,
  input  [1:0]  auto_out_4_d_bits_sink,
  input         auto_out_4_d_bits_denied,
  input  [63:0] auto_out_4_d_bits_data,
  input         auto_out_4_d_bits_corrupt,
  input         auto_out_4_e_ready,
  output        auto_out_4_e_valid,
  output [1:0]  auto_out_4_e_bits_sink,
  input         auto_out_3_a_ready,
  output        auto_out_3_a_valid,
  output [2:0]  auto_out_3_a_bits_opcode,
  output [2:0]  auto_out_3_a_bits_param,
  output [3:0]  auto_out_3_a_bits_size,
  output [1:0]  auto_out_3_a_bits_source,
  output [31:0] auto_out_3_a_bits_address,
  output [7:0]  auto_out_3_a_bits_mask,
  output [63:0] auto_out_3_a_bits_data,
  output        auto_out_3_a_bits_corrupt,
  output        auto_out_3_b_ready,
  input         auto_out_3_b_valid,
  input  [1:0]  auto_out_3_b_bits_param,
  input  [1:0]  auto_out_3_b_bits_source,
  input  [31:0] auto_out_3_b_bits_address,
  input         auto_out_3_c_ready,
  output        auto_out_3_c_valid,
  output [2:0]  auto_out_3_c_bits_opcode,
  output [2:0]  auto_out_3_c_bits_param,
  output [3:0]  auto_out_3_c_bits_size,
  output [1:0]  auto_out_3_c_bits_source,
  output [31:0] auto_out_3_c_bits_address,
  output [63:0] auto_out_3_c_bits_data,
  output        auto_out_3_c_bits_corrupt,
  output        auto_out_3_d_ready,
  input         auto_out_3_d_valid,
  input  [2:0]  auto_out_3_d_bits_opcode,
  input  [1:0]  auto_out_3_d_bits_param,
  input  [3:0]  auto_out_3_d_bits_size,
  input  [1:0]  auto_out_3_d_bits_source,
  input  [1:0]  auto_out_3_d_bits_sink,
  input         auto_out_3_d_bits_denied,
  input  [63:0] auto_out_3_d_bits_data,
  input         auto_out_3_d_bits_corrupt,
  input         auto_out_3_e_ready,
  output        auto_out_3_e_valid,
  output [1:0]  auto_out_3_e_bits_sink,
  input         auto_out_2_a_ready,
  output        auto_out_2_a_valid,
  output [2:0]  auto_out_2_a_bits_opcode,
  output [2:0]  auto_out_2_a_bits_param,
  output [3:0]  auto_out_2_a_bits_size,
  output [1:0]  auto_out_2_a_bits_source,
  output [31:0] auto_out_2_a_bits_address,
  output [7:0]  auto_out_2_a_bits_mask,
  output [63:0] auto_out_2_a_bits_data,
  output        auto_out_2_a_bits_corrupt,
  output        auto_out_2_b_ready,
  input         auto_out_2_b_valid,
  input  [1:0]  auto_out_2_b_bits_param,
  input  [1:0]  auto_out_2_b_bits_source,
  input  [31:0] auto_out_2_b_bits_address,
  input         auto_out_2_c_ready,
  output        auto_out_2_c_valid,
  output [2:0]  auto_out_2_c_bits_opcode,
  output [2:0]  auto_out_2_c_bits_param,
  output [3:0]  auto_out_2_c_bits_size,
  output [1:0]  auto_out_2_c_bits_source,
  output [31:0] auto_out_2_c_bits_address,
  output [63:0] auto_out_2_c_bits_data,
  output        auto_out_2_c_bits_corrupt,
  output        auto_out_2_d_ready,
  input         auto_out_2_d_valid,
  input  [2:0]  auto_out_2_d_bits_opcode,
  input  [1:0]  auto_out_2_d_bits_param,
  input  [3:0]  auto_out_2_d_bits_size,
  input  [1:0]  auto_out_2_d_bits_source,
  input  [1:0]  auto_out_2_d_bits_sink,
  input         auto_out_2_d_bits_denied,
  input  [63:0] auto_out_2_d_bits_data,
  input         auto_out_2_d_bits_corrupt,
  input         auto_out_2_e_ready,
  output        auto_out_2_e_valid,
  output [1:0]  auto_out_2_e_bits_sink,
  input         auto_out_1_a_ready,
  output        auto_out_1_a_valid,
  output [2:0]  auto_out_1_a_bits_opcode,
  output [2:0]  auto_out_1_a_bits_param,
  output [3:0]  auto_out_1_a_bits_size,
  output [1:0]  auto_out_1_a_bits_source,
  output [31:0] auto_out_1_a_bits_address,
  output [7:0]  auto_out_1_a_bits_mask,
  output [63:0] auto_out_1_a_bits_data,
  output        auto_out_1_a_bits_corrupt,
  output        auto_out_1_b_ready,
  input         auto_out_1_b_valid,
  input  [1:0]  auto_out_1_b_bits_param,
  input  [1:0]  auto_out_1_b_bits_source,
  input  [31:0] auto_out_1_b_bits_address,
  input         auto_out_1_c_ready,
  output        auto_out_1_c_valid,
  output [2:0]  auto_out_1_c_bits_opcode,
  output [2:0]  auto_out_1_c_bits_param,
  output [3:0]  auto_out_1_c_bits_size,
  output [1:0]  auto_out_1_c_bits_source,
  output [31:0] auto_out_1_c_bits_address,
  output [63:0] auto_out_1_c_bits_data,
  output        auto_out_1_c_bits_corrupt,
  output        auto_out_1_d_ready,
  input         auto_out_1_d_valid,
  input  [2:0]  auto_out_1_d_bits_opcode,
  input  [1:0]  auto_out_1_d_bits_param,
  input  [3:0]  auto_out_1_d_bits_size,
  input  [1:0]  auto_out_1_d_bits_source,
  input  [1:0]  auto_out_1_d_bits_sink,
  input         auto_out_1_d_bits_denied,
  input  [63:0] auto_out_1_d_bits_data,
  input         auto_out_1_d_bits_corrupt,
  input         auto_out_1_e_ready,
  output        auto_out_1_e_valid,
  output [1:0]  auto_out_1_e_bits_sink,
  input         auto_out_0_a_ready,
  output        auto_out_0_a_valid,
  output [2:0]  auto_out_0_a_bits_opcode,
  output [2:0]  auto_out_0_a_bits_param,
  output [3:0]  auto_out_0_a_bits_size,
  output [3:0]  auto_out_0_a_bits_source,
  output [31:0] auto_out_0_a_bits_address,
  output        auto_out_0_a_bits_user_amba_prot_bufferable,
  output        auto_out_0_a_bits_user_amba_prot_modifiable,
  output        auto_out_0_a_bits_user_amba_prot_readalloc,
  output        auto_out_0_a_bits_user_amba_prot_writealloc,
  output        auto_out_0_a_bits_user_amba_prot_privileged,
  output        auto_out_0_a_bits_user_amba_prot_secure,
  output        auto_out_0_a_bits_user_amba_prot_fetch,
  output [7:0]  auto_out_0_a_bits_mask,
  output [63:0] auto_out_0_a_bits_data,
  output        auto_out_0_a_bits_corrupt,
  output        auto_out_0_d_ready,
  input         auto_out_0_d_valid,
  input  [2:0]  auto_out_0_d_bits_opcode,
  input  [1:0]  auto_out_0_d_bits_param,
  input  [3:0]  auto_out_0_d_bits_size,
  input  [3:0]  auto_out_0_d_bits_source,
  input  [1:0]  auto_out_0_d_bits_sink,
  input         auto_out_0_d_bits_denied,
  input  [63:0] auto_out_0_d_bits_data,
  input         auto_out_0_d_bits_corrupt
);
`ifdef RANDOMIZE_REG_INIT
  reg [31:0] _RAND_0;
  reg [31:0] _RAND_1;
  reg [31:0] _RAND_2;
  reg [31:0] _RAND_3;
  reg [31:0] _RAND_4;
  reg [31:0] _RAND_5;
  reg [31:0] _RAND_6;
  reg [31:0] _RAND_7;
  reg [31:0] _RAND_8;
  reg [31:0] _RAND_9;
  reg [31:0] _RAND_10;
  reg [31:0] _RAND_11;
  reg [31:0] _RAND_12;
  reg [31:0] _RAND_13;
  reg [31:0] _RAND_14;
  reg [31:0] _RAND_15;
  reg [31:0] _RAND_16;
  reg [31:0] _RAND_17;
  reg [31:0] _RAND_18;
  reg [31:0] _RAND_19;
`endif // RANDOMIZE_REG_INIT
  wire  monitor_clock; // @[Nodes.scala 24:25]
  wire  monitor_reset; // @[Nodes.scala 24:25]
  wire  monitor_io_in_a_ready; // @[Nodes.scala 24:25]
  wire  monitor_io_in_a_valid; // @[Nodes.scala 24:25]
  wire [2:0] monitor_io_in_a_bits_opcode; // @[Nodes.scala 24:25]
  wire [2:0] monitor_io_in_a_bits_param; // @[Nodes.scala 24:25]
  wire [3:0] monitor_io_in_a_bits_size; // @[Nodes.scala 24:25]
  wire [3:0] monitor_io_in_a_bits_source; // @[Nodes.scala 24:25]
  wire [31:0] monitor_io_in_a_bits_address; // @[Nodes.scala 24:25]
  wire [7:0] monitor_io_in_a_bits_mask; // @[Nodes.scala 24:25]
  wire  monitor_io_in_a_bits_corrupt; // @[Nodes.scala 24:25]
  wire  monitor_io_in_d_ready; // @[Nodes.scala 24:25]
  wire  monitor_io_in_d_valid; // @[Nodes.scala 24:25]
  wire [2:0] monitor_io_in_d_bits_opcode; // @[Nodes.scala 24:25]
  wire [1:0] monitor_io_in_d_bits_param; // @[Nodes.scala 24:25]
  wire [3:0] monitor_io_in_d_bits_size; // @[Nodes.scala 24:25]
  wire [3:0] monitor_io_in_d_bits_source; // @[Nodes.scala 24:25]
  wire [1:0] monitor_io_in_d_bits_sink; // @[Nodes.scala 24:25]
  wire  monitor_io_in_d_bits_denied; // @[Nodes.scala 24:25]
  wire  monitor_io_in_d_bits_corrupt; // @[Nodes.scala 24:25]
  wire  monitor_1_clock; // @[Nodes.scala 24:25]
  wire  monitor_1_reset; // @[Nodes.scala 24:25]
  wire  monitor_1_io_in_a_ready; // @[Nodes.scala 24:25]
  wire  monitor_1_io_in_a_valid; // @[Nodes.scala 24:25]
  wire [2:0] monitor_1_io_in_a_bits_opcode; // @[Nodes.scala 24:25]
  wire [2:0] monitor_1_io_in_a_bits_param; // @[Nodes.scala 24:25]
  wire [3:0] monitor_1_io_in_a_bits_size; // @[Nodes.scala 24:25]
  wire [1:0] monitor_1_io_in_a_bits_source; // @[Nodes.scala 24:25]
  wire [31:0] monitor_1_io_in_a_bits_address; // @[Nodes.scala 24:25]
  wire [7:0] monitor_1_io_in_a_bits_mask; // @[Nodes.scala 24:25]
  wire  monitor_1_io_in_a_bits_corrupt; // @[Nodes.scala 24:25]
  wire  monitor_1_io_in_b_ready; // @[Nodes.scala 24:25]
  wire  monitor_1_io_in_b_valid; // @[Nodes.scala 24:25]
  wire [1:0] monitor_1_io_in_b_bits_param; // @[Nodes.scala 24:25]
  wire [1:0] monitor_1_io_in_b_bits_source; // @[Nodes.scala 24:25]
  wire [31:0] monitor_1_io_in_b_bits_address; // @[Nodes.scala 24:25]
  wire  monitor_1_io_in_c_ready; // @[Nodes.scala 24:25]
  wire  monitor_1_io_in_c_valid; // @[Nodes.scala 24:25]
  wire [2:0] monitor_1_io_in_c_bits_opcode; // @[Nodes.scala 24:25]
  wire [2:0] monitor_1_io_in_c_bits_param; // @[Nodes.scala 24:25]
  wire [3:0] monitor_1_io_in_c_bits_size; // @[Nodes.scala 24:25]
  wire [1:0] monitor_1_io_in_c_bits_source; // @[Nodes.scala 24:25]
  wire [31:0] monitor_1_io_in_c_bits_address; // @[Nodes.scala 24:25]
  wire  monitor_1_io_in_c_bits_corrupt; // @[Nodes.scala 24:25]
  wire  monitor_1_io_in_d_ready; // @[Nodes.scala 24:25]
  wire  monitor_1_io_in_d_valid; // @[Nodes.scala 24:25]
  wire [2:0] monitor_1_io_in_d_bits_opcode; // @[Nodes.scala 24:25]
  wire [1:0] monitor_1_io_in_d_bits_param; // @[Nodes.scala 24:25]
  wire [3:0] monitor_1_io_in_d_bits_size; // @[Nodes.scala 24:25]
  wire [1:0] monitor_1_io_in_d_bits_source; // @[Nodes.scala 24:25]
  wire [1:0] monitor_1_io_in_d_bits_sink; // @[Nodes.scala 24:25]
  wire  monitor_1_io_in_d_bits_denied; // @[Nodes.scala 24:25]
  wire  monitor_1_io_in_d_bits_corrupt; // @[Nodes.scala 24:25]
  wire  monitor_1_io_in_e_ready; // @[Nodes.scala 24:25]
  wire  monitor_1_io_in_e_valid; // @[Nodes.scala 24:25]
  wire [1:0] monitor_1_io_in_e_bits_sink; // @[Nodes.scala 24:25]
  wire  monitor_2_clock; // @[Nodes.scala 24:25]
  wire  monitor_2_reset; // @[Nodes.scala 24:25]
  wire  monitor_2_io_in_a_ready; // @[Nodes.scala 24:25]
  wire  monitor_2_io_in_a_valid; // @[Nodes.scala 24:25]
  wire [2:0] monitor_2_io_in_a_bits_opcode; // @[Nodes.scala 24:25]
  wire [2:0] monitor_2_io_in_a_bits_param; // @[Nodes.scala 24:25]
  wire [3:0] monitor_2_io_in_a_bits_size; // @[Nodes.scala 24:25]
  wire [1:0] monitor_2_io_in_a_bits_source; // @[Nodes.scala 24:25]
  wire [31:0] monitor_2_io_in_a_bits_address; // @[Nodes.scala 24:25]
  wire [7:0] monitor_2_io_in_a_bits_mask; // @[Nodes.scala 24:25]
  wire  monitor_2_io_in_a_bits_corrupt; // @[Nodes.scala 24:25]
  wire  monitor_2_io_in_b_ready; // @[Nodes.scala 24:25]
  wire  monitor_2_io_in_b_valid; // @[Nodes.scala 24:25]
  wire [1:0] monitor_2_io_in_b_bits_param; // @[Nodes.scala 24:25]
  wire [1:0] monitor_2_io_in_b_bits_source; // @[Nodes.scala 24:25]
  wire [31:0] monitor_2_io_in_b_bits_address; // @[Nodes.scala 24:25]
  wire  monitor_2_io_in_c_ready; // @[Nodes.scala 24:25]
  wire  monitor_2_io_in_c_valid; // @[Nodes.scala 24:25]
  wire [2:0] monitor_2_io_in_c_bits_opcode; // @[Nodes.scala 24:25]
  wire [2:0] monitor_2_io_in_c_bits_param; // @[Nodes.scala 24:25]
  wire [3:0] monitor_2_io_in_c_bits_size; // @[Nodes.scala 24:25]
  wire [1:0] monitor_2_io_in_c_bits_source; // @[Nodes.scala 24:25]
  wire [31:0] monitor_2_io_in_c_bits_address; // @[Nodes.scala 24:25]
  wire  monitor_2_io_in_c_bits_corrupt; // @[Nodes.scala 24:25]
  wire  monitor_2_io_in_d_ready; // @[Nodes.scala 24:25]
  wire  monitor_2_io_in_d_valid; // @[Nodes.scala 24:25]
  wire [2:0] monitor_2_io_in_d_bits_opcode; // @[Nodes.scala 24:25]
  wire [1:0] monitor_2_io_in_d_bits_param; // @[Nodes.scala 24:25]
  wire [3:0] monitor_2_io_in_d_bits_size; // @[Nodes.scala 24:25]
  wire [1:0] monitor_2_io_in_d_bits_source; // @[Nodes.scala 24:25]
  wire [1:0] monitor_2_io_in_d_bits_sink; // @[Nodes.scala 24:25]
  wire  monitor_2_io_in_d_bits_denied; // @[Nodes.scala 24:25]
  wire  monitor_2_io_in_d_bits_corrupt; // @[Nodes.scala 24:25]
  wire  monitor_2_io_in_e_ready; // @[Nodes.scala 24:25]
  wire  monitor_2_io_in_e_valid; // @[Nodes.scala 24:25]
  wire [1:0] monitor_2_io_in_e_bits_sink; // @[Nodes.scala 24:25]
  wire  monitor_3_clock; // @[Nodes.scala 24:25]
  wire  monitor_3_reset; // @[Nodes.scala 24:25]
  wire  monitor_3_io_in_a_ready; // @[Nodes.scala 24:25]
  wire  monitor_3_io_in_a_valid; // @[Nodes.scala 24:25]
  wire [2:0] monitor_3_io_in_a_bits_opcode; // @[Nodes.scala 24:25]
  wire [2:0] monitor_3_io_in_a_bits_param; // @[Nodes.scala 24:25]
  wire [3:0] monitor_3_io_in_a_bits_size; // @[Nodes.scala 24:25]
  wire [1:0] monitor_3_io_in_a_bits_source; // @[Nodes.scala 24:25]
  wire [31:0] monitor_3_io_in_a_bits_address; // @[Nodes.scala 24:25]
  wire [7:0] monitor_3_io_in_a_bits_mask; // @[Nodes.scala 24:25]
  wire  monitor_3_io_in_a_bits_corrupt; // @[Nodes.scala 24:25]
  wire  monitor_3_io_in_b_ready; // @[Nodes.scala 24:25]
  wire  monitor_3_io_in_b_valid; // @[Nodes.scala 24:25]
  wire [1:0] monitor_3_io_in_b_bits_param; // @[Nodes.scala 24:25]
  wire [1:0] monitor_3_io_in_b_bits_source; // @[Nodes.scala 24:25]
  wire [31:0] monitor_3_io_in_b_bits_address; // @[Nodes.scala 24:25]
  wire  monitor_3_io_in_c_ready; // @[Nodes.scala 24:25]
  wire  monitor_3_io_in_c_valid; // @[Nodes.scala 24:25]
  wire [2:0] monitor_3_io_in_c_bits_opcode; // @[Nodes.scala 24:25]
  wire [2:0] monitor_3_io_in_c_bits_param; // @[Nodes.scala 24:25]
  wire [3:0] monitor_3_io_in_c_bits_size; // @[Nodes.scala 24:25]
  wire [1:0] monitor_3_io_in_c_bits_source; // @[Nodes.scala 24:25]
  wire [31:0] monitor_3_io_in_c_bits_address; // @[Nodes.scala 24:25]
  wire  monitor_3_io_in_c_bits_corrupt; // @[Nodes.scala 24:25]
  wire  monitor_3_io_in_d_ready; // @[Nodes.scala 24:25]
  wire  monitor_3_io_in_d_valid; // @[Nodes.scala 24:25]
  wire [2:0] monitor_3_io_in_d_bits_opcode; // @[Nodes.scala 24:25]
  wire [1:0] monitor_3_io_in_d_bits_param; // @[Nodes.scala 24:25]
  wire [3:0] monitor_3_io_in_d_bits_size; // @[Nodes.scala 24:25]
  wire [1:0] monitor_3_io_in_d_bits_source; // @[Nodes.scala 24:25]
  wire [1:0] monitor_3_io_in_d_bits_sink; // @[Nodes.scala 24:25]
  wire  monitor_3_io_in_d_bits_denied; // @[Nodes.scala 24:25]
  wire  monitor_3_io_in_d_bits_corrupt; // @[Nodes.scala 24:25]
  wire  monitor_3_io_in_e_ready; // @[Nodes.scala 24:25]
  wire  monitor_3_io_in_e_valid; // @[Nodes.scala 24:25]
  wire [1:0] monitor_3_io_in_e_bits_sink; // @[Nodes.scala 24:25]
  wire  monitor_4_clock; // @[Nodes.scala 24:25]
  wire  monitor_4_reset; // @[Nodes.scala 24:25]
  wire  monitor_4_io_in_a_ready; // @[Nodes.scala 24:25]
  wire  monitor_4_io_in_a_valid; // @[Nodes.scala 24:25]
  wire [2:0] monitor_4_io_in_a_bits_opcode; // @[Nodes.scala 24:25]
  wire [2:0] monitor_4_io_in_a_bits_param; // @[Nodes.scala 24:25]
  wire [3:0] monitor_4_io_in_a_bits_size; // @[Nodes.scala 24:25]
  wire [1:0] monitor_4_io_in_a_bits_source; // @[Nodes.scala 24:25]
  wire [31:0] monitor_4_io_in_a_bits_address; // @[Nodes.scala 24:25]
  wire [7:0] monitor_4_io_in_a_bits_mask; // @[Nodes.scala 24:25]
  wire  monitor_4_io_in_a_bits_corrupt; // @[Nodes.scala 24:25]
  wire  monitor_4_io_in_b_ready; // @[Nodes.scala 24:25]
  wire  monitor_4_io_in_b_valid; // @[Nodes.scala 24:25]
  wire [1:0] monitor_4_io_in_b_bits_param; // @[Nodes.scala 24:25]
  wire [1:0] monitor_4_io_in_b_bits_source; // @[Nodes.scala 24:25]
  wire [31:0] monitor_4_io_in_b_bits_address; // @[Nodes.scala 24:25]
  wire  monitor_4_io_in_c_ready; // @[Nodes.scala 24:25]
  wire  monitor_4_io_in_c_valid; // @[Nodes.scala 24:25]
  wire [2:0] monitor_4_io_in_c_bits_opcode; // @[Nodes.scala 24:25]
  wire [2:0] monitor_4_io_in_c_bits_param; // @[Nodes.scala 24:25]
  wire [3:0] monitor_4_io_in_c_bits_size; // @[Nodes.scala 24:25]
  wire [1:0] monitor_4_io_in_c_bits_source; // @[Nodes.scala 24:25]
  wire [31:0] monitor_4_io_in_c_bits_address; // @[Nodes.scala 24:25]
  wire  monitor_4_io_in_c_bits_corrupt; // @[Nodes.scala 24:25]
  wire  monitor_4_io_in_d_ready; // @[Nodes.scala 24:25]
  wire  monitor_4_io_in_d_valid; // @[Nodes.scala 24:25]
  wire [2:0] monitor_4_io_in_d_bits_opcode; // @[Nodes.scala 24:25]
  wire [1:0] monitor_4_io_in_d_bits_param; // @[Nodes.scala 24:25]
  wire [3:0] monitor_4_io_in_d_bits_size; // @[Nodes.scala 24:25]
  wire [1:0] monitor_4_io_in_d_bits_source; // @[Nodes.scala 24:25]
  wire [1:0] monitor_4_io_in_d_bits_sink; // @[Nodes.scala 24:25]
  wire  monitor_4_io_in_d_bits_denied; // @[Nodes.scala 24:25]
  wire  monitor_4_io_in_d_bits_corrupt; // @[Nodes.scala 24:25]
  wire  monitor_4_io_in_e_ready; // @[Nodes.scala 24:25]
  wire  monitor_4_io_in_e_valid; // @[Nodes.scala 24:25]
  wire [1:0] monitor_4_io_in_e_bits_sink; // @[Nodes.scala 24:25]
  wire [32:0] _a_notFIFO_T_1 = {1'b0,$signed(auto_in_0_a_bits_address)}; // @[Parameters.scala 137:49]
  wire [31:0] _a_notFIFO_T_5 = auto_in_0_a_bits_address ^ 32'h80000000; // @[Parameters.scala 137:31]
  wire [32:0] _a_notFIFO_T_6 = {1'b0,$signed(_a_notFIFO_T_5)}; // @[Parameters.scala 137:49]
  wire [32:0] _a_notFIFO_T_8 = $signed(_a_notFIFO_T_6) & 33'sh80000000; // @[Parameters.scala 137:52]
  wire  a_notFIFO = $signed(_a_notFIFO_T_8) == 33'sh0; // @[Parameters.scala 137:67]
  wire [32:0] _a_id_T_3 = $signed(_a_notFIFO_T_1) & 33'sh70000000; // @[Parameters.scala 137:52]
  wire  _a_id_T_4 = $signed(_a_id_T_3) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _a_id_T_5 = auto_in_0_a_bits_address ^ 32'h10000000; // @[Parameters.scala 137:31]
  wire [32:0] _a_id_T_6 = {1'b0,$signed(_a_id_T_5)}; // @[Parameters.scala 137:49]
  wire [32:0] _a_id_T_8 = $signed(_a_id_T_6) & 33'sh70000000; // @[Parameters.scala 137:52]
  wire  _a_id_T_9 = $signed(_a_id_T_8) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _a_id_T_10 = auto_in_0_a_bits_address ^ 32'h20000000; // @[Parameters.scala 137:31]
  wire [32:0] _a_id_T_11 = {1'b0,$signed(_a_id_T_10)}; // @[Parameters.scala 137:49]
  wire [32:0] _a_id_T_13 = $signed(_a_id_T_11) & 33'sh60000000; // @[Parameters.scala 137:52]
  wire  _a_id_T_14 = $signed(_a_id_T_13) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _a_id_T_15 = auto_in_0_a_bits_address ^ 32'h40000000; // @[Parameters.scala 137:31]
  wire [32:0] _a_id_T_16 = {1'b0,$signed(_a_id_T_15)}; // @[Parameters.scala 137:49]
  wire [32:0] _a_id_T_18 = $signed(_a_id_T_16) & 33'sh40000000; // @[Parameters.scala 137:52]
  wire  _a_id_T_19 = $signed(_a_id_T_18) == 33'sh0; // @[Parameters.scala 137:67]
  wire  _a_id_T_21 = _a_id_T_9 | _a_id_T_14 | _a_id_T_19; // @[Parameters.scala 615:89]
  wire [1:0] _a_id_T_23 = _a_id_T_21 ? 2'h2 : 2'h0; // @[Mux.scala 27:72]
  wire [1:0] _GEN_134 = {{1'd0}, _a_id_T_4}; // @[Mux.scala 27:72]
  wire [1:0] a_id = _GEN_134 | _a_id_T_23; // @[Mux.scala 27:72]
  wire  a_noDomain = a_id == 2'h0; // @[FIFOFixer.scala 55:29]
  wire  stalls_a_sel = ~auto_in_0_a_bits_source[3]; // @[Parameters.scala 54:32]
  reg [8:0] a_first_counter; // @[Edges.scala 228:27]
  wire  a_first = a_first_counter == 9'h0; // @[Edges.scala 230:25]
  reg  flight__0; // @[FIFOFixer.scala 71:27]
  reg  flight__1; // @[FIFOFixer.scala 71:27]
  reg  flight__2; // @[FIFOFixer.scala 71:27]
  reg  flight__3; // @[FIFOFixer.scala 71:27]
  reg  flight__4; // @[FIFOFixer.scala 71:27]
  reg  flight__5; // @[FIFOFixer.scala 71:27]
  reg  flight__6; // @[FIFOFixer.scala 71:27]
  reg  flight__7; // @[FIFOFixer.scala 71:27]
  reg [1:0] stalls_id; // @[Reg.scala 15:16]
  wire  stalls_0 = stalls_a_sel & a_first & (flight__0 | flight__1 | flight__2 | flight__3 | flight__4 | flight__5 |
    flight__6 | flight__7) & (a_noDomain | stalls_id != a_id); // @[FIFOFixer.scala 80:50]
  reg  flight__8; // @[FIFOFixer.scala 71:27]
  reg  flight__9; // @[FIFOFixer.scala 71:27]
  reg  flight__10; // @[FIFOFixer.scala 71:27]
  reg  flight__11; // @[FIFOFixer.scala 71:27]
  reg  flight__12; // @[FIFOFixer.scala 71:27]
  reg  flight__13; // @[FIFOFixer.scala 71:27]
  reg  flight__14; // @[FIFOFixer.scala 71:27]
  reg  flight__15; // @[FIFOFixer.scala 71:27]
  reg [1:0] stalls_id_1; // @[Reg.scala 15:16]
  wire  stalls_1 = auto_in_0_a_bits_source[3] & a_first & (flight__8 | flight__9 | flight__10 | flight__11 | flight__12
     | flight__13 | flight__14 | flight__15) & (a_noDomain | stalls_id_1 != a_id); // @[FIFOFixer.scala 80:50]
  wire  stall = stalls_0 | stalls_1; // @[FIFOFixer.scala 83:49]
  wire  _bundleIn_0_a_ready_T_1 = a_notFIFO | ~stall; // @[FIFOFixer.scala 88:47]
  wire  bundleIn_0_a_ready = auto_out_0_a_ready & (a_notFIFO | ~stall); // @[FIFOFixer.scala 88:33]
  wire  _a_first_T = bundleIn_0_a_ready & auto_in_0_a_valid; // @[Decoupled.scala 40:37]
  wire [26:0] _a_first_beats1_decode_T_1 = 27'hfff << auto_in_0_a_bits_size; // @[package.scala 234:77]
  wire [11:0] _a_first_beats1_decode_T_3 = ~_a_first_beats1_decode_T_1[11:0]; // @[package.scala 234:46]
  wire [8:0] a_first_beats1_decode = _a_first_beats1_decode_T_3[11:3]; // @[Edges.scala 219:59]
  wire  a_first_beats1_opdata = ~auto_in_0_a_bits_opcode[2]; // @[Edges.scala 91:28]
  wire [8:0] a_first_counter1 = a_first_counter - 9'h1; // @[Edges.scala 229:28]
  wire  _d_first_T = auto_in_0_d_ready & auto_out_0_d_valid; // @[Decoupled.scala 40:37]
  wire [26:0] _d_first_beats1_decode_T_1 = 27'hfff << auto_out_0_d_bits_size; // @[package.scala 234:77]
  wire [11:0] _d_first_beats1_decode_T_3 = ~_d_first_beats1_decode_T_1[11:0]; // @[package.scala 234:46]
  wire [8:0] d_first_beats1_decode = _d_first_beats1_decode_T_3[11:3]; // @[Edges.scala 219:59]
  wire  d_first_beats1_opdata = auto_out_0_d_bits_opcode[0]; // @[Edges.scala 105:36]
  reg [8:0] d_first_counter; // @[Edges.scala 228:27]
  wire [8:0] d_first_counter1 = d_first_counter - 9'h1; // @[Edges.scala 229:28]
  wire  d_first_first = d_first_counter == 9'h0; // @[Edges.scala 230:25]
  wire  d_first = d_first_first & auto_out_0_d_bits_opcode != 3'h6; // @[FIFOFixer.scala 67:42]
  wire  _flight_T = ~a_notFIFO; // @[FIFOFixer.scala 72:67]
  wire  _GEN_2 = 4'h0 == auto_in_0_a_bits_source ? ~a_notFIFO : flight__0; // @[FIFOFixer.scala 72:64 FIFOFixer.scala 72:64 FIFOFixer.scala 71:27]
  wire  _GEN_3 = 4'h1 == auto_in_0_a_bits_source ? ~a_notFIFO : flight__1; // @[FIFOFixer.scala 72:64 FIFOFixer.scala 72:64 FIFOFixer.scala 71:27]
  wire  _GEN_4 = 4'h2 == auto_in_0_a_bits_source ? ~a_notFIFO : flight__2; // @[FIFOFixer.scala 72:64 FIFOFixer.scala 72:64 FIFOFixer.scala 71:27]
  wire  _GEN_5 = 4'h3 == auto_in_0_a_bits_source ? ~a_notFIFO : flight__3; // @[FIFOFixer.scala 72:64 FIFOFixer.scala 72:64 FIFOFixer.scala 71:27]
  wire  _GEN_6 = 4'h4 == auto_in_0_a_bits_source ? ~a_notFIFO : flight__4; // @[FIFOFixer.scala 72:64 FIFOFixer.scala 72:64 FIFOFixer.scala 71:27]
  wire  _GEN_7 = 4'h5 == auto_in_0_a_bits_source ? ~a_notFIFO : flight__5; // @[FIFOFixer.scala 72:64 FIFOFixer.scala 72:64 FIFOFixer.scala 71:27]
  wire  _GEN_8 = 4'h6 == auto_in_0_a_bits_source ? ~a_notFIFO : flight__6; // @[FIFOFixer.scala 72:64 FIFOFixer.scala 72:64 FIFOFixer.scala 71:27]
  wire  _GEN_9 = 4'h7 == auto_in_0_a_bits_source ? ~a_notFIFO : flight__7; // @[FIFOFixer.scala 72:64 FIFOFixer.scala 72:64 FIFOFixer.scala 71:27]
  wire  _GEN_10 = 4'h8 == auto_in_0_a_bits_source ? ~a_notFIFO : flight__8; // @[FIFOFixer.scala 72:64 FIFOFixer.scala 72:64 FIFOFixer.scala 71:27]
  wire  _GEN_11 = 4'h9 == auto_in_0_a_bits_source ? ~a_notFIFO : flight__9; // @[FIFOFixer.scala 72:64 FIFOFixer.scala 72:64 FIFOFixer.scala 71:27]
  wire  _GEN_12 = 4'ha == auto_in_0_a_bits_source ? ~a_notFIFO : flight__10; // @[FIFOFixer.scala 72:64 FIFOFixer.scala 72:64 FIFOFixer.scala 71:27]
  wire  _GEN_13 = 4'hb == auto_in_0_a_bits_source ? ~a_notFIFO : flight__11; // @[FIFOFixer.scala 72:64 FIFOFixer.scala 72:64 FIFOFixer.scala 71:27]
  wire  _GEN_14 = 4'hc == auto_in_0_a_bits_source ? ~a_notFIFO : flight__12; // @[FIFOFixer.scala 72:64 FIFOFixer.scala 72:64 FIFOFixer.scala 71:27]
  wire  _GEN_15 = 4'hd == auto_in_0_a_bits_source ? ~a_notFIFO : flight__13; // @[FIFOFixer.scala 72:64 FIFOFixer.scala 72:64 FIFOFixer.scala 71:27]
  wire  _GEN_16 = 4'he == auto_in_0_a_bits_source ? ~a_notFIFO : flight__14; // @[FIFOFixer.scala 72:64 FIFOFixer.scala 72:64 FIFOFixer.scala 71:27]
  wire  _GEN_17 = 4'hf == auto_in_0_a_bits_source ? ~a_notFIFO : flight__15; // @[FIFOFixer.scala 72:64 FIFOFixer.scala 72:64 FIFOFixer.scala 71:27]
  wire  _GEN_18 = a_first & _a_first_T ? _GEN_2 : flight__0; // @[FIFOFixer.scala 72:37 FIFOFixer.scala 71:27]
  wire  _GEN_19 = a_first & _a_first_T ? _GEN_3 : flight__1; // @[FIFOFixer.scala 72:37 FIFOFixer.scala 71:27]
  wire  _GEN_20 = a_first & _a_first_T ? _GEN_4 : flight__2; // @[FIFOFixer.scala 72:37 FIFOFixer.scala 71:27]
  wire  _GEN_21 = a_first & _a_first_T ? _GEN_5 : flight__3; // @[FIFOFixer.scala 72:37 FIFOFixer.scala 71:27]
  wire  _GEN_22 = a_first & _a_first_T ? _GEN_6 : flight__4; // @[FIFOFixer.scala 72:37 FIFOFixer.scala 71:27]
  wire  _GEN_23 = a_first & _a_first_T ? _GEN_7 : flight__5; // @[FIFOFixer.scala 72:37 FIFOFixer.scala 71:27]
  wire  _GEN_24 = a_first & _a_first_T ? _GEN_8 : flight__6; // @[FIFOFixer.scala 72:37 FIFOFixer.scala 71:27]
  wire  _GEN_25 = a_first & _a_first_T ? _GEN_9 : flight__7; // @[FIFOFixer.scala 72:37 FIFOFixer.scala 71:27]
  wire  _GEN_26 = a_first & _a_first_T ? _GEN_10 : flight__8; // @[FIFOFixer.scala 72:37 FIFOFixer.scala 71:27]
  wire  _GEN_27 = a_first & _a_first_T ? _GEN_11 : flight__9; // @[FIFOFixer.scala 72:37 FIFOFixer.scala 71:27]
  wire  _GEN_28 = a_first & _a_first_T ? _GEN_12 : flight__10; // @[FIFOFixer.scala 72:37 FIFOFixer.scala 71:27]
  wire  _GEN_29 = a_first & _a_first_T ? _GEN_13 : flight__11; // @[FIFOFixer.scala 72:37 FIFOFixer.scala 71:27]
  wire  _GEN_30 = a_first & _a_first_T ? _GEN_14 : flight__12; // @[FIFOFixer.scala 72:37 FIFOFixer.scala 71:27]
  wire  _GEN_31 = a_first & _a_first_T ? _GEN_15 : flight__13; // @[FIFOFixer.scala 72:37 FIFOFixer.scala 71:27]
  wire  _GEN_32 = a_first & _a_first_T ? _GEN_16 : flight__14; // @[FIFOFixer.scala 72:37 FIFOFixer.scala 71:27]
  wire  _GEN_33 = a_first & _a_first_T ? _GEN_17 : flight__15; // @[FIFOFixer.scala 72:37 FIFOFixer.scala 71:27]
  wire  _stalls_id_T_3 = _a_first_T & stalls_a_sel & _flight_T; // @[FIFOFixer.scala 77:58]
  wire  _stalls_id_T_7 = _a_first_T & auto_in_0_a_bits_source[3] & _flight_T; // @[FIFOFixer.scala 77:58]
  TLMonitor_5 monitor ( // @[Nodes.scala 24:25]
    .clock(monitor_clock),
    .reset(monitor_reset),
    .io_in_a_ready(monitor_io_in_a_ready),
    .io_in_a_valid(monitor_io_in_a_valid),
    .io_in_a_bits_opcode(monitor_io_in_a_bits_opcode),
    .io_in_a_bits_param(monitor_io_in_a_bits_param),
    .io_in_a_bits_size(monitor_io_in_a_bits_size),
    .io_in_a_bits_source(monitor_io_in_a_bits_source),
    .io_in_a_bits_address(monitor_io_in_a_bits_address),
    .io_in_a_bits_mask(monitor_io_in_a_bits_mask),
    .io_in_a_bits_corrupt(monitor_io_in_a_bits_corrupt),
    .io_in_d_ready(monitor_io_in_d_ready),
    .io_in_d_valid(monitor_io_in_d_valid),
    .io_in_d_bits_opcode(monitor_io_in_d_bits_opcode),
    .io_in_d_bits_param(monitor_io_in_d_bits_param),
    .io_in_d_bits_size(monitor_io_in_d_bits_size),
    .io_in_d_bits_source(monitor_io_in_d_bits_source),
    .io_in_d_bits_sink(monitor_io_in_d_bits_sink),
    .io_in_d_bits_denied(monitor_io_in_d_bits_denied),
    .io_in_d_bits_corrupt(monitor_io_in_d_bits_corrupt)
  );
  TLMonitor_6 monitor_1 ( // @[Nodes.scala 24:25]
    .clock(monitor_1_clock),
    .reset(monitor_1_reset),
    .io_in_a_ready(monitor_1_io_in_a_ready),
    .io_in_a_valid(monitor_1_io_in_a_valid),
    .io_in_a_bits_opcode(monitor_1_io_in_a_bits_opcode),
    .io_in_a_bits_param(monitor_1_io_in_a_bits_param),
    .io_in_a_bits_size(monitor_1_io_in_a_bits_size),
    .io_in_a_bits_source(monitor_1_io_in_a_bits_source),
    .io_in_a_bits_address(monitor_1_io_in_a_bits_address),
    .io_in_a_bits_mask(monitor_1_io_in_a_bits_mask),
    .io_in_a_bits_corrupt(monitor_1_io_in_a_bits_corrupt),
    .io_in_b_ready(monitor_1_io_in_b_ready),
    .io_in_b_valid(monitor_1_io_in_b_valid),
    .io_in_b_bits_param(monitor_1_io_in_b_bits_param),
    .io_in_b_bits_source(monitor_1_io_in_b_bits_source),
    .io_in_b_bits_address(monitor_1_io_in_b_bits_address),
    .io_in_c_ready(monitor_1_io_in_c_ready),
    .io_in_c_valid(monitor_1_io_in_c_valid),
    .io_in_c_bits_opcode(monitor_1_io_in_c_bits_opcode),
    .io_in_c_bits_param(monitor_1_io_in_c_bits_param),
    .io_in_c_bits_size(monitor_1_io_in_c_bits_size),
    .io_in_c_bits_source(monitor_1_io_in_c_bits_source),
    .io_in_c_bits_address(monitor_1_io_in_c_bits_address),
    .io_in_c_bits_corrupt(monitor_1_io_in_c_bits_corrupt),
    .io_in_d_ready(monitor_1_io_in_d_ready),
    .io_in_d_valid(monitor_1_io_in_d_valid),
    .io_in_d_bits_opcode(monitor_1_io_in_d_bits_opcode),
    .io_in_d_bits_param(monitor_1_io_in_d_bits_param),
    .io_in_d_bits_size(monitor_1_io_in_d_bits_size),
    .io_in_d_bits_source(monitor_1_io_in_d_bits_source),
    .io_in_d_bits_sink(monitor_1_io_in_d_bits_sink),
    .io_in_d_bits_denied(monitor_1_io_in_d_bits_denied),
    .io_in_d_bits_corrupt(monitor_1_io_in_d_bits_corrupt),
    .io_in_e_ready(monitor_1_io_in_e_ready),
    .io_in_e_valid(monitor_1_io_in_e_valid),
    .io_in_e_bits_sink(monitor_1_io_in_e_bits_sink)
  );
  TLMonitor_6 monitor_2 ( // @[Nodes.scala 24:25]
    .clock(monitor_2_clock),
    .reset(monitor_2_reset),
    .io_in_a_ready(monitor_2_io_in_a_ready),
    .io_in_a_valid(monitor_2_io_in_a_valid),
    .io_in_a_bits_opcode(monitor_2_io_in_a_bits_opcode),
    .io_in_a_bits_param(monitor_2_io_in_a_bits_param),
    .io_in_a_bits_size(monitor_2_io_in_a_bits_size),
    .io_in_a_bits_source(monitor_2_io_in_a_bits_source),
    .io_in_a_bits_address(monitor_2_io_in_a_bits_address),
    .io_in_a_bits_mask(monitor_2_io_in_a_bits_mask),
    .io_in_a_bits_corrupt(monitor_2_io_in_a_bits_corrupt),
    .io_in_b_ready(monitor_2_io_in_b_ready),
    .io_in_b_valid(monitor_2_io_in_b_valid),
    .io_in_b_bits_param(monitor_2_io_in_b_bits_param),
    .io_in_b_bits_source(monitor_2_io_in_b_bits_source),
    .io_in_b_bits_address(monitor_2_io_in_b_bits_address),
    .io_in_c_ready(monitor_2_io_in_c_ready),
    .io_in_c_valid(monitor_2_io_in_c_valid),
    .io_in_c_bits_opcode(monitor_2_io_in_c_bits_opcode),
    .io_in_c_bits_param(monitor_2_io_in_c_bits_param),
    .io_in_c_bits_size(monitor_2_io_in_c_bits_size),
    .io_in_c_bits_source(monitor_2_io_in_c_bits_source),
    .io_in_c_bits_address(monitor_2_io_in_c_bits_address),
    .io_in_c_bits_corrupt(monitor_2_io_in_c_bits_corrupt),
    .io_in_d_ready(monitor_2_io_in_d_ready),
    .io_in_d_valid(monitor_2_io_in_d_valid),
    .io_in_d_bits_opcode(monitor_2_io_in_d_bits_opcode),
    .io_in_d_bits_param(monitor_2_io_in_d_bits_param),
    .io_in_d_bits_size(monitor_2_io_in_d_bits_size),
    .io_in_d_bits_source(monitor_2_io_in_d_bits_source),
    .io_in_d_bits_sink(monitor_2_io_in_d_bits_sink),
    .io_in_d_bits_denied(monitor_2_io_in_d_bits_denied),
    .io_in_d_bits_corrupt(monitor_2_io_in_d_bits_corrupt),
    .io_in_e_ready(monitor_2_io_in_e_ready),
    .io_in_e_valid(monitor_2_io_in_e_valid),
    .io_in_e_bits_sink(monitor_2_io_in_e_bits_sink)
  );
  TLMonitor_6 monitor_3 ( // @[Nodes.scala 24:25]
    .clock(monitor_3_clock),
    .reset(monitor_3_reset),
    .io_in_a_ready(monitor_3_io_in_a_ready),
    .io_in_a_valid(monitor_3_io_in_a_valid),
    .io_in_a_bits_opcode(monitor_3_io_in_a_bits_opcode),
    .io_in_a_bits_param(monitor_3_io_in_a_bits_param),
    .io_in_a_bits_size(monitor_3_io_in_a_bits_size),
    .io_in_a_bits_source(monitor_3_io_in_a_bits_source),
    .io_in_a_bits_address(monitor_3_io_in_a_bits_address),
    .io_in_a_bits_mask(monitor_3_io_in_a_bits_mask),
    .io_in_a_bits_corrupt(monitor_3_io_in_a_bits_corrupt),
    .io_in_b_ready(monitor_3_io_in_b_ready),
    .io_in_b_valid(monitor_3_io_in_b_valid),
    .io_in_b_bits_param(monitor_3_io_in_b_bits_param),
    .io_in_b_bits_source(monitor_3_io_in_b_bits_source),
    .io_in_b_bits_address(monitor_3_io_in_b_bits_address),
    .io_in_c_ready(monitor_3_io_in_c_ready),
    .io_in_c_valid(monitor_3_io_in_c_valid),
    .io_in_c_bits_opcode(monitor_3_io_in_c_bits_opcode),
    .io_in_c_bits_param(monitor_3_io_in_c_bits_param),
    .io_in_c_bits_size(monitor_3_io_in_c_bits_size),
    .io_in_c_bits_source(monitor_3_io_in_c_bits_source),
    .io_in_c_bits_address(monitor_3_io_in_c_bits_address),
    .io_in_c_bits_corrupt(monitor_3_io_in_c_bits_corrupt),
    .io_in_d_ready(monitor_3_io_in_d_ready),
    .io_in_d_valid(monitor_3_io_in_d_valid),
    .io_in_d_bits_opcode(monitor_3_io_in_d_bits_opcode),
    .io_in_d_bits_param(monitor_3_io_in_d_bits_param),
    .io_in_d_bits_size(monitor_3_io_in_d_bits_size),
    .io_in_d_bits_source(monitor_3_io_in_d_bits_source),
    .io_in_d_bits_sink(monitor_3_io_in_d_bits_sink),
    .io_in_d_bits_denied(monitor_3_io_in_d_bits_denied),
    .io_in_d_bits_corrupt(monitor_3_io_in_d_bits_corrupt),
    .io_in_e_ready(monitor_3_io_in_e_ready),
    .io_in_e_valid(monitor_3_io_in_e_valid),
    .io_in_e_bits_sink(monitor_3_io_in_e_bits_sink)
  );
  TLMonitor_6 monitor_4 ( // @[Nodes.scala 24:25]
    .clock(monitor_4_clock),
    .reset(monitor_4_reset),
    .io_in_a_ready(monitor_4_io_in_a_ready),
    .io_in_a_valid(monitor_4_io_in_a_valid),
    .io_in_a_bits_opcode(monitor_4_io_in_a_bits_opcode),
    .io_in_a_bits_param(monitor_4_io_in_a_bits_param),
    .io_in_a_bits_size(monitor_4_io_in_a_bits_size),
    .io_in_a_bits_source(monitor_4_io_in_a_bits_source),
    .io_in_a_bits_address(monitor_4_io_in_a_bits_address),
    .io_in_a_bits_mask(monitor_4_io_in_a_bits_mask),
    .io_in_a_bits_corrupt(monitor_4_io_in_a_bits_corrupt),
    .io_in_b_ready(monitor_4_io_in_b_ready),
    .io_in_b_valid(monitor_4_io_in_b_valid),
    .io_in_b_bits_param(monitor_4_io_in_b_bits_param),
    .io_in_b_bits_source(monitor_4_io_in_b_bits_source),
    .io_in_b_bits_address(monitor_4_io_in_b_bits_address),
    .io_in_c_ready(monitor_4_io_in_c_ready),
    .io_in_c_valid(monitor_4_io_in_c_valid),
    .io_in_c_bits_opcode(monitor_4_io_in_c_bits_opcode),
    .io_in_c_bits_param(monitor_4_io_in_c_bits_param),
    .io_in_c_bits_size(monitor_4_io_in_c_bits_size),
    .io_in_c_bits_source(monitor_4_io_in_c_bits_source),
    .io_in_c_bits_address(monitor_4_io_in_c_bits_address),
    .io_in_c_bits_corrupt(monitor_4_io_in_c_bits_corrupt),
    .io_in_d_ready(monitor_4_io_in_d_ready),
    .io_in_d_valid(monitor_4_io_in_d_valid),
    .io_in_d_bits_opcode(monitor_4_io_in_d_bits_opcode),
    .io_in_d_bits_param(monitor_4_io_in_d_bits_param),
    .io_in_d_bits_size(monitor_4_io_in_d_bits_size),
    .io_in_d_bits_source(monitor_4_io_in_d_bits_source),
    .io_in_d_bits_sink(monitor_4_io_in_d_bits_sink),
    .io_in_d_bits_denied(monitor_4_io_in_d_bits_denied),
    .io_in_d_bits_corrupt(monitor_4_io_in_d_bits_corrupt),
    .io_in_e_ready(monitor_4_io_in_e_ready),
    .io_in_e_valid(monitor_4_io_in_e_valid),
    .io_in_e_bits_sink(monitor_4_io_in_e_bits_sink)
  );
  assign auto_in_4_a_ready = auto_out_4_a_ready; // @[FIFOFixer.scala 88:33]
  assign auto_in_4_b_valid = auto_out_4_b_valid; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_4_b_bits_param = auto_out_4_b_bits_param; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_4_b_bits_source = auto_out_4_b_bits_source; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_4_b_bits_address = auto_out_4_b_bits_address; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_4_c_ready = auto_out_4_c_ready; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_4_d_valid = auto_out_4_d_valid; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_4_d_bits_opcode = auto_out_4_d_bits_opcode; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_4_d_bits_param = auto_out_4_d_bits_param; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_4_d_bits_size = auto_out_4_d_bits_size; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_4_d_bits_source = auto_out_4_d_bits_source; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_4_d_bits_sink = auto_out_4_d_bits_sink; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_4_d_bits_denied = auto_out_4_d_bits_denied; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_4_d_bits_data = auto_out_4_d_bits_data; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_4_d_bits_corrupt = auto_out_4_d_bits_corrupt; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_4_e_ready = auto_out_4_e_ready; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_3_a_ready = auto_out_3_a_ready; // @[FIFOFixer.scala 88:33]
  assign auto_in_3_b_valid = auto_out_3_b_valid; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_3_b_bits_param = auto_out_3_b_bits_param; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_3_b_bits_source = auto_out_3_b_bits_source; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_3_b_bits_address = auto_out_3_b_bits_address; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_3_c_ready = auto_out_3_c_ready; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_3_d_valid = auto_out_3_d_valid; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_3_d_bits_opcode = auto_out_3_d_bits_opcode; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_3_d_bits_param = auto_out_3_d_bits_param; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_3_d_bits_size = auto_out_3_d_bits_size; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_3_d_bits_source = auto_out_3_d_bits_source; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_3_d_bits_sink = auto_out_3_d_bits_sink; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_3_d_bits_denied = auto_out_3_d_bits_denied; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_3_d_bits_data = auto_out_3_d_bits_data; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_3_d_bits_corrupt = auto_out_3_d_bits_corrupt; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_3_e_ready = auto_out_3_e_ready; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_2_a_ready = auto_out_2_a_ready; // @[FIFOFixer.scala 88:33]
  assign auto_in_2_b_valid = auto_out_2_b_valid; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_2_b_bits_param = auto_out_2_b_bits_param; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_2_b_bits_source = auto_out_2_b_bits_source; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_2_b_bits_address = auto_out_2_b_bits_address; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_2_c_ready = auto_out_2_c_ready; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_2_d_valid = auto_out_2_d_valid; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_2_d_bits_opcode = auto_out_2_d_bits_opcode; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_2_d_bits_param = auto_out_2_d_bits_param; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_2_d_bits_size = auto_out_2_d_bits_size; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_2_d_bits_source = auto_out_2_d_bits_source; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_2_d_bits_sink = auto_out_2_d_bits_sink; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_2_d_bits_denied = auto_out_2_d_bits_denied; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_2_d_bits_data = auto_out_2_d_bits_data; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_2_d_bits_corrupt = auto_out_2_d_bits_corrupt; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_2_e_ready = auto_out_2_e_ready; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_1_a_ready = auto_out_1_a_ready; // @[FIFOFixer.scala 88:33]
  assign auto_in_1_b_valid = auto_out_1_b_valid; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_1_b_bits_param = auto_out_1_b_bits_param; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_1_b_bits_source = auto_out_1_b_bits_source; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_1_b_bits_address = auto_out_1_b_bits_address; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_1_c_ready = auto_out_1_c_ready; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_1_d_valid = auto_out_1_d_valid; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_1_d_bits_opcode = auto_out_1_d_bits_opcode; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_1_d_bits_param = auto_out_1_d_bits_param; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_1_d_bits_size = auto_out_1_d_bits_size; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_1_d_bits_source = auto_out_1_d_bits_source; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_1_d_bits_sink = auto_out_1_d_bits_sink; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_1_d_bits_denied = auto_out_1_d_bits_denied; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_1_d_bits_data = auto_out_1_d_bits_data; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_1_d_bits_corrupt = auto_out_1_d_bits_corrupt; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_1_e_ready = auto_out_1_e_ready; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_0_a_ready = auto_out_0_a_ready & (a_notFIFO | ~stall); // @[FIFOFixer.scala 88:33]
  assign auto_in_0_d_valid = auto_out_0_d_valid; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_0_d_bits_opcode = auto_out_0_d_bits_opcode; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_0_d_bits_param = auto_out_0_d_bits_param; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_0_d_bits_size = auto_out_0_d_bits_size; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_0_d_bits_source = auto_out_0_d_bits_source; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_0_d_bits_sink = auto_out_0_d_bits_sink; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_0_d_bits_denied = auto_out_0_d_bits_denied; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_0_d_bits_data = auto_out_0_d_bits_data; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_0_d_bits_corrupt = auto_out_0_d_bits_corrupt; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_out_4_a_valid = auto_in_4_a_valid; // @[FIFOFixer.scala 87:33]
  assign auto_out_4_a_bits_opcode = auto_in_4_a_bits_opcode; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_4_a_bits_param = auto_in_4_a_bits_param; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_4_a_bits_size = auto_in_4_a_bits_size; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_4_a_bits_source = auto_in_4_a_bits_source; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_4_a_bits_address = auto_in_4_a_bits_address; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_4_a_bits_mask = auto_in_4_a_bits_mask; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_4_a_bits_data = auto_in_4_a_bits_data; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_4_a_bits_corrupt = auto_in_4_a_bits_corrupt; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_4_b_ready = auto_in_4_b_ready; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_4_c_valid = auto_in_4_c_valid; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_4_c_bits_opcode = auto_in_4_c_bits_opcode; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_4_c_bits_param = auto_in_4_c_bits_param; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_4_c_bits_size = auto_in_4_c_bits_size; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_4_c_bits_source = auto_in_4_c_bits_source; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_4_c_bits_address = auto_in_4_c_bits_address; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_4_c_bits_data = auto_in_4_c_bits_data; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_4_c_bits_corrupt = auto_in_4_c_bits_corrupt; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_4_d_ready = auto_in_4_d_ready; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_4_e_valid = auto_in_4_e_valid; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_4_e_bits_sink = auto_in_4_e_bits_sink; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_3_a_valid = auto_in_3_a_valid; // @[FIFOFixer.scala 87:33]
  assign auto_out_3_a_bits_opcode = auto_in_3_a_bits_opcode; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_3_a_bits_param = auto_in_3_a_bits_param; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_3_a_bits_size = auto_in_3_a_bits_size; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_3_a_bits_source = auto_in_3_a_bits_source; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_3_a_bits_address = auto_in_3_a_bits_address; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_3_a_bits_mask = auto_in_3_a_bits_mask; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_3_a_bits_data = auto_in_3_a_bits_data; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_3_a_bits_corrupt = auto_in_3_a_bits_corrupt; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_3_b_ready = auto_in_3_b_ready; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_3_c_valid = auto_in_3_c_valid; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_3_c_bits_opcode = auto_in_3_c_bits_opcode; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_3_c_bits_param = auto_in_3_c_bits_param; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_3_c_bits_size = auto_in_3_c_bits_size; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_3_c_bits_source = auto_in_3_c_bits_source; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_3_c_bits_address = auto_in_3_c_bits_address; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_3_c_bits_data = auto_in_3_c_bits_data; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_3_c_bits_corrupt = auto_in_3_c_bits_corrupt; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_3_d_ready = auto_in_3_d_ready; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_3_e_valid = auto_in_3_e_valid; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_3_e_bits_sink = auto_in_3_e_bits_sink; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_2_a_valid = auto_in_2_a_valid; // @[FIFOFixer.scala 87:33]
  assign auto_out_2_a_bits_opcode = auto_in_2_a_bits_opcode; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_2_a_bits_param = auto_in_2_a_bits_param; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_2_a_bits_size = auto_in_2_a_bits_size; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_2_a_bits_source = auto_in_2_a_bits_source; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_2_a_bits_address = auto_in_2_a_bits_address; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_2_a_bits_mask = auto_in_2_a_bits_mask; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_2_a_bits_data = auto_in_2_a_bits_data; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_2_a_bits_corrupt = auto_in_2_a_bits_corrupt; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_2_b_ready = auto_in_2_b_ready; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_2_c_valid = auto_in_2_c_valid; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_2_c_bits_opcode = auto_in_2_c_bits_opcode; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_2_c_bits_param = auto_in_2_c_bits_param; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_2_c_bits_size = auto_in_2_c_bits_size; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_2_c_bits_source = auto_in_2_c_bits_source; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_2_c_bits_address = auto_in_2_c_bits_address; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_2_c_bits_data = auto_in_2_c_bits_data; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_2_c_bits_corrupt = auto_in_2_c_bits_corrupt; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_2_d_ready = auto_in_2_d_ready; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_2_e_valid = auto_in_2_e_valid; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_2_e_bits_sink = auto_in_2_e_bits_sink; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_1_a_valid = auto_in_1_a_valid; // @[FIFOFixer.scala 87:33]
  assign auto_out_1_a_bits_opcode = auto_in_1_a_bits_opcode; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_1_a_bits_param = auto_in_1_a_bits_param; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_1_a_bits_size = auto_in_1_a_bits_size; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_1_a_bits_source = auto_in_1_a_bits_source; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_1_a_bits_address = auto_in_1_a_bits_address; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_1_a_bits_mask = auto_in_1_a_bits_mask; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_1_a_bits_data = auto_in_1_a_bits_data; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_1_a_bits_corrupt = auto_in_1_a_bits_corrupt; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_1_b_ready = auto_in_1_b_ready; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_1_c_valid = auto_in_1_c_valid; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_1_c_bits_opcode = auto_in_1_c_bits_opcode; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_1_c_bits_param = auto_in_1_c_bits_param; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_1_c_bits_size = auto_in_1_c_bits_size; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_1_c_bits_source = auto_in_1_c_bits_source; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_1_c_bits_address = auto_in_1_c_bits_address; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_1_c_bits_data = auto_in_1_c_bits_data; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_1_c_bits_corrupt = auto_in_1_c_bits_corrupt; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_1_d_ready = auto_in_1_d_ready; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_1_e_valid = auto_in_1_e_valid; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_1_e_bits_sink = auto_in_1_e_bits_sink; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_0_a_valid = auto_in_0_a_valid & _bundleIn_0_a_ready_T_1; // @[FIFOFixer.scala 87:33]
  assign auto_out_0_a_bits_opcode = auto_in_0_a_bits_opcode; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_0_a_bits_param = auto_in_0_a_bits_param; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_0_a_bits_size = auto_in_0_a_bits_size; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_0_a_bits_source = auto_in_0_a_bits_source; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_0_a_bits_address = auto_in_0_a_bits_address; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_0_a_bits_user_amba_prot_bufferable = auto_in_0_a_bits_user_amba_prot_bufferable; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_0_a_bits_user_amba_prot_modifiable = auto_in_0_a_bits_user_amba_prot_modifiable; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_0_a_bits_user_amba_prot_readalloc = auto_in_0_a_bits_user_amba_prot_readalloc; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_0_a_bits_user_amba_prot_writealloc = auto_in_0_a_bits_user_amba_prot_writealloc; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_0_a_bits_user_amba_prot_privileged = auto_in_0_a_bits_user_amba_prot_privileged; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_0_a_bits_user_amba_prot_secure = auto_in_0_a_bits_user_amba_prot_secure; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_0_a_bits_user_amba_prot_fetch = auto_in_0_a_bits_user_amba_prot_fetch; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_0_a_bits_mask = auto_in_0_a_bits_mask; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_0_a_bits_data = auto_in_0_a_bits_data; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_0_a_bits_corrupt = auto_in_0_a_bits_corrupt; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_0_d_ready = auto_in_0_d_ready; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_clock = clock;
  assign monitor_reset = reset;
  assign monitor_io_in_a_ready = auto_out_0_a_ready & (a_notFIFO | ~stall); // @[FIFOFixer.scala 88:33]
  assign monitor_io_in_a_valid = auto_in_0_a_valid; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_io_in_a_bits_opcode = auto_in_0_a_bits_opcode; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_io_in_a_bits_param = auto_in_0_a_bits_param; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_io_in_a_bits_size = auto_in_0_a_bits_size; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_io_in_a_bits_source = auto_in_0_a_bits_source; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_io_in_a_bits_address = auto_in_0_a_bits_address; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_io_in_a_bits_mask = auto_in_0_a_bits_mask; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_io_in_a_bits_corrupt = auto_in_0_a_bits_corrupt; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_io_in_d_ready = auto_in_0_d_ready; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_io_in_d_valid = auto_out_0_d_valid; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign monitor_io_in_d_bits_opcode = auto_out_0_d_bits_opcode; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign monitor_io_in_d_bits_param = auto_out_0_d_bits_param; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign monitor_io_in_d_bits_size = auto_out_0_d_bits_size; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign monitor_io_in_d_bits_source = auto_out_0_d_bits_source; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign monitor_io_in_d_bits_sink = auto_out_0_d_bits_sink; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign monitor_io_in_d_bits_denied = auto_out_0_d_bits_denied; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign monitor_io_in_d_bits_corrupt = auto_out_0_d_bits_corrupt; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign monitor_1_clock = clock;
  assign monitor_1_reset = reset;
  assign monitor_1_io_in_a_ready = auto_out_1_a_ready; // @[FIFOFixer.scala 88:33]
  assign monitor_1_io_in_a_valid = auto_in_1_a_valid; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_1_io_in_a_bits_opcode = auto_in_1_a_bits_opcode; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_1_io_in_a_bits_param = auto_in_1_a_bits_param; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_1_io_in_a_bits_size = auto_in_1_a_bits_size; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_1_io_in_a_bits_source = auto_in_1_a_bits_source; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_1_io_in_a_bits_address = auto_in_1_a_bits_address; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_1_io_in_a_bits_mask = auto_in_1_a_bits_mask; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_1_io_in_a_bits_corrupt = auto_in_1_a_bits_corrupt; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_1_io_in_b_ready = auto_in_1_b_ready; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_1_io_in_b_valid = auto_out_1_b_valid; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign monitor_1_io_in_b_bits_param = auto_out_1_b_bits_param; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign monitor_1_io_in_b_bits_source = auto_out_1_b_bits_source; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign monitor_1_io_in_b_bits_address = auto_out_1_b_bits_address; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign monitor_1_io_in_c_ready = auto_out_1_c_ready; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign monitor_1_io_in_c_valid = auto_in_1_c_valid; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_1_io_in_c_bits_opcode = auto_in_1_c_bits_opcode; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_1_io_in_c_bits_param = auto_in_1_c_bits_param; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_1_io_in_c_bits_size = auto_in_1_c_bits_size; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_1_io_in_c_bits_source = auto_in_1_c_bits_source; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_1_io_in_c_bits_address = auto_in_1_c_bits_address; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_1_io_in_c_bits_corrupt = auto_in_1_c_bits_corrupt; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_1_io_in_d_ready = auto_in_1_d_ready; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_1_io_in_d_valid = auto_out_1_d_valid; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign monitor_1_io_in_d_bits_opcode = auto_out_1_d_bits_opcode; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign monitor_1_io_in_d_bits_param = auto_out_1_d_bits_param; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign monitor_1_io_in_d_bits_size = auto_out_1_d_bits_size; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign monitor_1_io_in_d_bits_source = auto_out_1_d_bits_source; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign monitor_1_io_in_d_bits_sink = auto_out_1_d_bits_sink; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign monitor_1_io_in_d_bits_denied = auto_out_1_d_bits_denied; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign monitor_1_io_in_d_bits_corrupt = auto_out_1_d_bits_corrupt; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign monitor_1_io_in_e_ready = auto_out_1_e_ready; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign monitor_1_io_in_e_valid = auto_in_1_e_valid; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_1_io_in_e_bits_sink = auto_in_1_e_bits_sink; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_2_clock = clock;
  assign monitor_2_reset = reset;
  assign monitor_2_io_in_a_ready = auto_out_2_a_ready; // @[FIFOFixer.scala 88:33]
  assign monitor_2_io_in_a_valid = auto_in_2_a_valid; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_2_io_in_a_bits_opcode = auto_in_2_a_bits_opcode; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_2_io_in_a_bits_param = auto_in_2_a_bits_param; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_2_io_in_a_bits_size = auto_in_2_a_bits_size; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_2_io_in_a_bits_source = auto_in_2_a_bits_source; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_2_io_in_a_bits_address = auto_in_2_a_bits_address; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_2_io_in_a_bits_mask = auto_in_2_a_bits_mask; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_2_io_in_a_bits_corrupt = auto_in_2_a_bits_corrupt; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_2_io_in_b_ready = auto_in_2_b_ready; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_2_io_in_b_valid = auto_out_2_b_valid; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign monitor_2_io_in_b_bits_param = auto_out_2_b_bits_param; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign monitor_2_io_in_b_bits_source = auto_out_2_b_bits_source; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign monitor_2_io_in_b_bits_address = auto_out_2_b_bits_address; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign monitor_2_io_in_c_ready = auto_out_2_c_ready; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign monitor_2_io_in_c_valid = auto_in_2_c_valid; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_2_io_in_c_bits_opcode = auto_in_2_c_bits_opcode; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_2_io_in_c_bits_param = auto_in_2_c_bits_param; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_2_io_in_c_bits_size = auto_in_2_c_bits_size; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_2_io_in_c_bits_source = auto_in_2_c_bits_source; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_2_io_in_c_bits_address = auto_in_2_c_bits_address; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_2_io_in_c_bits_corrupt = auto_in_2_c_bits_corrupt; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_2_io_in_d_ready = auto_in_2_d_ready; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_2_io_in_d_valid = auto_out_2_d_valid; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign monitor_2_io_in_d_bits_opcode = auto_out_2_d_bits_opcode; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign monitor_2_io_in_d_bits_param = auto_out_2_d_bits_param; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign monitor_2_io_in_d_bits_size = auto_out_2_d_bits_size; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign monitor_2_io_in_d_bits_source = auto_out_2_d_bits_source; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign monitor_2_io_in_d_bits_sink = auto_out_2_d_bits_sink; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign monitor_2_io_in_d_bits_denied = auto_out_2_d_bits_denied; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign monitor_2_io_in_d_bits_corrupt = auto_out_2_d_bits_corrupt; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign monitor_2_io_in_e_ready = auto_out_2_e_ready; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign monitor_2_io_in_e_valid = auto_in_2_e_valid; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_2_io_in_e_bits_sink = auto_in_2_e_bits_sink; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_3_clock = clock;
  assign monitor_3_reset = reset;
  assign monitor_3_io_in_a_ready = auto_out_3_a_ready; // @[FIFOFixer.scala 88:33]
  assign monitor_3_io_in_a_valid = auto_in_3_a_valid; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_3_io_in_a_bits_opcode = auto_in_3_a_bits_opcode; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_3_io_in_a_bits_param = auto_in_3_a_bits_param; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_3_io_in_a_bits_size = auto_in_3_a_bits_size; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_3_io_in_a_bits_source = auto_in_3_a_bits_source; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_3_io_in_a_bits_address = auto_in_3_a_bits_address; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_3_io_in_a_bits_mask = auto_in_3_a_bits_mask; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_3_io_in_a_bits_corrupt = auto_in_3_a_bits_corrupt; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_3_io_in_b_ready = auto_in_3_b_ready; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_3_io_in_b_valid = auto_out_3_b_valid; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign monitor_3_io_in_b_bits_param = auto_out_3_b_bits_param; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign monitor_3_io_in_b_bits_source = auto_out_3_b_bits_source; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign monitor_3_io_in_b_bits_address = auto_out_3_b_bits_address; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign monitor_3_io_in_c_ready = auto_out_3_c_ready; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign monitor_3_io_in_c_valid = auto_in_3_c_valid; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_3_io_in_c_bits_opcode = auto_in_3_c_bits_opcode; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_3_io_in_c_bits_param = auto_in_3_c_bits_param; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_3_io_in_c_bits_size = auto_in_3_c_bits_size; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_3_io_in_c_bits_source = auto_in_3_c_bits_source; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_3_io_in_c_bits_address = auto_in_3_c_bits_address; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_3_io_in_c_bits_corrupt = auto_in_3_c_bits_corrupt; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_3_io_in_d_ready = auto_in_3_d_ready; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_3_io_in_d_valid = auto_out_3_d_valid; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign monitor_3_io_in_d_bits_opcode = auto_out_3_d_bits_opcode; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign monitor_3_io_in_d_bits_param = auto_out_3_d_bits_param; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign monitor_3_io_in_d_bits_size = auto_out_3_d_bits_size; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign monitor_3_io_in_d_bits_source = auto_out_3_d_bits_source; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign monitor_3_io_in_d_bits_sink = auto_out_3_d_bits_sink; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign monitor_3_io_in_d_bits_denied = auto_out_3_d_bits_denied; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign monitor_3_io_in_d_bits_corrupt = auto_out_3_d_bits_corrupt; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign monitor_3_io_in_e_ready = auto_out_3_e_ready; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign monitor_3_io_in_e_valid = auto_in_3_e_valid; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_3_io_in_e_bits_sink = auto_in_3_e_bits_sink; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_4_clock = clock;
  assign monitor_4_reset = reset;
  assign monitor_4_io_in_a_ready = auto_out_4_a_ready; // @[FIFOFixer.scala 88:33]
  assign monitor_4_io_in_a_valid = auto_in_4_a_valid; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_4_io_in_a_bits_opcode = auto_in_4_a_bits_opcode; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_4_io_in_a_bits_param = auto_in_4_a_bits_param; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_4_io_in_a_bits_size = auto_in_4_a_bits_size; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_4_io_in_a_bits_source = auto_in_4_a_bits_source; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_4_io_in_a_bits_address = auto_in_4_a_bits_address; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_4_io_in_a_bits_mask = auto_in_4_a_bits_mask; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_4_io_in_a_bits_corrupt = auto_in_4_a_bits_corrupt; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_4_io_in_b_ready = auto_in_4_b_ready; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_4_io_in_b_valid = auto_out_4_b_valid; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign monitor_4_io_in_b_bits_param = auto_out_4_b_bits_param; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign monitor_4_io_in_b_bits_source = auto_out_4_b_bits_source; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign monitor_4_io_in_b_bits_address = auto_out_4_b_bits_address; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign monitor_4_io_in_c_ready = auto_out_4_c_ready; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign monitor_4_io_in_c_valid = auto_in_4_c_valid; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_4_io_in_c_bits_opcode = auto_in_4_c_bits_opcode; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_4_io_in_c_bits_param = auto_in_4_c_bits_param; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_4_io_in_c_bits_size = auto_in_4_c_bits_size; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_4_io_in_c_bits_source = auto_in_4_c_bits_source; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_4_io_in_c_bits_address = auto_in_4_c_bits_address; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_4_io_in_c_bits_corrupt = auto_in_4_c_bits_corrupt; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_4_io_in_d_ready = auto_in_4_d_ready; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_4_io_in_d_valid = auto_out_4_d_valid; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign monitor_4_io_in_d_bits_opcode = auto_out_4_d_bits_opcode; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign monitor_4_io_in_d_bits_param = auto_out_4_d_bits_param; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign monitor_4_io_in_d_bits_size = auto_out_4_d_bits_size; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign monitor_4_io_in_d_bits_source = auto_out_4_d_bits_source; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign monitor_4_io_in_d_bits_sink = auto_out_4_d_bits_sink; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign monitor_4_io_in_d_bits_denied = auto_out_4_d_bits_denied; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign monitor_4_io_in_d_bits_corrupt = auto_out_4_d_bits_corrupt; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign monitor_4_io_in_e_ready = auto_out_4_e_ready; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign monitor_4_io_in_e_valid = auto_in_4_e_valid; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_4_io_in_e_bits_sink = auto_in_4_e_bits_sink; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  always @(posedge clock) begin
    if (reset) begin // @[Edges.scala 228:27]
      a_first_counter <= 9'h0; // @[Edges.scala 228:27]
    end else if (_a_first_T) begin // @[Edges.scala 234:17]
      if (a_first) begin // @[Edges.scala 235:21]
        if (a_first_beats1_opdata) begin // @[Edges.scala 220:14]
          a_first_counter <= a_first_beats1_decode;
        end else begin
          a_first_counter <= 9'h0;
        end
      end else begin
        a_first_counter <= a_first_counter1;
      end
    end
    if (reset) begin // @[FIFOFixer.scala 71:27]
      flight__0 <= 1'h0; // @[FIFOFixer.scala 71:27]
    end else if (d_first & _d_first_T) begin // @[FIFOFixer.scala 73:37]
      if (4'h0 == auto_out_0_d_bits_source) begin // @[FIFOFixer.scala 73:64]
        flight__0 <= 1'h0; // @[FIFOFixer.scala 73:64]
      end else begin
        flight__0 <= _GEN_18;
      end
    end else begin
      flight__0 <= _GEN_18;
    end
    if (reset) begin // @[FIFOFixer.scala 71:27]
      flight__1 <= 1'h0; // @[FIFOFixer.scala 71:27]
    end else if (d_first & _d_first_T) begin // @[FIFOFixer.scala 73:37]
      if (4'h1 == auto_out_0_d_bits_source) begin // @[FIFOFixer.scala 73:64]
        flight__1 <= 1'h0; // @[FIFOFixer.scala 73:64]
      end else begin
        flight__1 <= _GEN_19;
      end
    end else begin
      flight__1 <= _GEN_19;
    end
    if (reset) begin // @[FIFOFixer.scala 71:27]
      flight__2 <= 1'h0; // @[FIFOFixer.scala 71:27]
    end else if (d_first & _d_first_T) begin // @[FIFOFixer.scala 73:37]
      if (4'h2 == auto_out_0_d_bits_source) begin // @[FIFOFixer.scala 73:64]
        flight__2 <= 1'h0; // @[FIFOFixer.scala 73:64]
      end else begin
        flight__2 <= _GEN_20;
      end
    end else begin
      flight__2 <= _GEN_20;
    end
    if (reset) begin // @[FIFOFixer.scala 71:27]
      flight__3 <= 1'h0; // @[FIFOFixer.scala 71:27]
    end else if (d_first & _d_first_T) begin // @[FIFOFixer.scala 73:37]
      if (4'h3 == auto_out_0_d_bits_source) begin // @[FIFOFixer.scala 73:64]
        flight__3 <= 1'h0; // @[FIFOFixer.scala 73:64]
      end else begin
        flight__3 <= _GEN_21;
      end
    end else begin
      flight__3 <= _GEN_21;
    end
    if (reset) begin // @[FIFOFixer.scala 71:27]
      flight__4 <= 1'h0; // @[FIFOFixer.scala 71:27]
    end else if (d_first & _d_first_T) begin // @[FIFOFixer.scala 73:37]
      if (4'h4 == auto_out_0_d_bits_source) begin // @[FIFOFixer.scala 73:64]
        flight__4 <= 1'h0; // @[FIFOFixer.scala 73:64]
      end else begin
        flight__4 <= _GEN_22;
      end
    end else begin
      flight__4 <= _GEN_22;
    end
    if (reset) begin // @[FIFOFixer.scala 71:27]
      flight__5 <= 1'h0; // @[FIFOFixer.scala 71:27]
    end else if (d_first & _d_first_T) begin // @[FIFOFixer.scala 73:37]
      if (4'h5 == auto_out_0_d_bits_source) begin // @[FIFOFixer.scala 73:64]
        flight__5 <= 1'h0; // @[FIFOFixer.scala 73:64]
      end else begin
        flight__5 <= _GEN_23;
      end
    end else begin
      flight__5 <= _GEN_23;
    end
    if (reset) begin // @[FIFOFixer.scala 71:27]
      flight__6 <= 1'h0; // @[FIFOFixer.scala 71:27]
    end else if (d_first & _d_first_T) begin // @[FIFOFixer.scala 73:37]
      if (4'h6 == auto_out_0_d_bits_source) begin // @[FIFOFixer.scala 73:64]
        flight__6 <= 1'h0; // @[FIFOFixer.scala 73:64]
      end else begin
        flight__6 <= _GEN_24;
      end
    end else begin
      flight__6 <= _GEN_24;
    end
    if (reset) begin // @[FIFOFixer.scala 71:27]
      flight__7 <= 1'h0; // @[FIFOFixer.scala 71:27]
    end else if (d_first & _d_first_T) begin // @[FIFOFixer.scala 73:37]
      if (4'h7 == auto_out_0_d_bits_source) begin // @[FIFOFixer.scala 73:64]
        flight__7 <= 1'h0; // @[FIFOFixer.scala 73:64]
      end else begin
        flight__7 <= _GEN_25;
      end
    end else begin
      flight__7 <= _GEN_25;
    end
    if (_stalls_id_T_3) begin // @[Reg.scala 16:19]
      stalls_id <= a_id; // @[Reg.scala 16:23]
    end
    if (reset) begin // @[FIFOFixer.scala 71:27]
      flight__8 <= 1'h0; // @[FIFOFixer.scala 71:27]
    end else if (d_first & _d_first_T) begin // @[FIFOFixer.scala 73:37]
      if (4'h8 == auto_out_0_d_bits_source) begin // @[FIFOFixer.scala 73:64]
        flight__8 <= 1'h0; // @[FIFOFixer.scala 73:64]
      end else begin
        flight__8 <= _GEN_26;
      end
    end else begin
      flight__8 <= _GEN_26;
    end
    if (reset) begin // @[FIFOFixer.scala 71:27]
      flight__9 <= 1'h0; // @[FIFOFixer.scala 71:27]
    end else if (d_first & _d_first_T) begin // @[FIFOFixer.scala 73:37]
      if (4'h9 == auto_out_0_d_bits_source) begin // @[FIFOFixer.scala 73:64]
        flight__9 <= 1'h0; // @[FIFOFixer.scala 73:64]
      end else begin
        flight__9 <= _GEN_27;
      end
    end else begin
      flight__9 <= _GEN_27;
    end
    if (reset) begin // @[FIFOFixer.scala 71:27]
      flight__10 <= 1'h0; // @[FIFOFixer.scala 71:27]
    end else if (d_first & _d_first_T) begin // @[FIFOFixer.scala 73:37]
      if (4'ha == auto_out_0_d_bits_source) begin // @[FIFOFixer.scala 73:64]
        flight__10 <= 1'h0; // @[FIFOFixer.scala 73:64]
      end else begin
        flight__10 <= _GEN_28;
      end
    end else begin
      flight__10 <= _GEN_28;
    end
    if (reset) begin // @[FIFOFixer.scala 71:27]
      flight__11 <= 1'h0; // @[FIFOFixer.scala 71:27]
    end else if (d_first & _d_first_T) begin // @[FIFOFixer.scala 73:37]
      if (4'hb == auto_out_0_d_bits_source) begin // @[FIFOFixer.scala 73:64]
        flight__11 <= 1'h0; // @[FIFOFixer.scala 73:64]
      end else begin
        flight__11 <= _GEN_29;
      end
    end else begin
      flight__11 <= _GEN_29;
    end
    if (reset) begin // @[FIFOFixer.scala 71:27]
      flight__12 <= 1'h0; // @[FIFOFixer.scala 71:27]
    end else if (d_first & _d_first_T) begin // @[FIFOFixer.scala 73:37]
      if (4'hc == auto_out_0_d_bits_source) begin // @[FIFOFixer.scala 73:64]
        flight__12 <= 1'h0; // @[FIFOFixer.scala 73:64]
      end else begin
        flight__12 <= _GEN_30;
      end
    end else begin
      flight__12 <= _GEN_30;
    end
    if (reset) begin // @[FIFOFixer.scala 71:27]
      flight__13 <= 1'h0; // @[FIFOFixer.scala 71:27]
    end else if (d_first & _d_first_T) begin // @[FIFOFixer.scala 73:37]
      if (4'hd == auto_out_0_d_bits_source) begin // @[FIFOFixer.scala 73:64]
        flight__13 <= 1'h0; // @[FIFOFixer.scala 73:64]
      end else begin
        flight__13 <= _GEN_31;
      end
    end else begin
      flight__13 <= _GEN_31;
    end
    if (reset) begin // @[FIFOFixer.scala 71:27]
      flight__14 <= 1'h0; // @[FIFOFixer.scala 71:27]
    end else if (d_first & _d_first_T) begin // @[FIFOFixer.scala 73:37]
      if (4'he == auto_out_0_d_bits_source) begin // @[FIFOFixer.scala 73:64]
        flight__14 <= 1'h0; // @[FIFOFixer.scala 73:64]
      end else begin
        flight__14 <= _GEN_32;
      end
    end else begin
      flight__14 <= _GEN_32;
    end
    if (reset) begin // @[FIFOFixer.scala 71:27]
      flight__15 <= 1'h0; // @[FIFOFixer.scala 71:27]
    end else if (d_first & _d_first_T) begin // @[FIFOFixer.scala 73:37]
      if (4'hf == auto_out_0_d_bits_source) begin // @[FIFOFixer.scala 73:64]
        flight__15 <= 1'h0; // @[FIFOFixer.scala 73:64]
      end else begin
        flight__15 <= _GEN_33;
      end
    end else begin
      flight__15 <= _GEN_33;
    end
    if (_stalls_id_T_7) begin // @[Reg.scala 16:19]
      stalls_id_1 <= a_id; // @[Reg.scala 16:23]
    end
    if (reset) begin // @[Edges.scala 228:27]
      d_first_counter <= 9'h0; // @[Edges.scala 228:27]
    end else if (_d_first_T) begin // @[Edges.scala 234:17]
      if (d_first_first) begin // @[Edges.scala 235:21]
        if (d_first_beats1_opdata) begin // @[Edges.scala 220:14]
          d_first_counter <= d_first_beats1_decode;
        end else begin
          d_first_counter <= 9'h0;
        end
      end else begin
        d_first_counter <= d_first_counter1;
      end
    end
  end
// Register and memory initialization
`ifdef RANDOMIZE_GARBAGE_ASSIGN
`define RANDOMIZE
`endif
`ifdef RANDOMIZE_INVALID_ASSIGN
`define RANDOMIZE
`endif
`ifdef RANDOMIZE_REG_INIT
`define RANDOMIZE
`endif
`ifdef RANDOMIZE_MEM_INIT
`define RANDOMIZE
`endif
`ifndef RANDOM
`define RANDOM $random
`endif
`ifdef RANDOMIZE_MEM_INIT
  integer initvar;
`endif
`ifndef SYNTHESIS
`ifdef FIRRTL_BEFORE_INITIAL
`FIRRTL_BEFORE_INITIAL
`endif
initial begin
  `ifdef RANDOMIZE
    `ifdef INIT_RANDOM
      `INIT_RANDOM
    `endif
    `ifndef VERILATOR
      `ifdef RANDOMIZE_DELAY
        #`RANDOMIZE_DELAY begin end
      `else
        #0.002 begin end
      `endif
    `endif
`ifdef RANDOMIZE_REG_INIT
  _RAND_0 = {1{`RANDOM}};
  a_first_counter = _RAND_0[8:0];
  _RAND_1 = {1{`RANDOM}};
  flight__0 = _RAND_1[0:0];
  _RAND_2 = {1{`RANDOM}};
  flight__1 = _RAND_2[0:0];
  _RAND_3 = {1{`RANDOM}};
  flight__2 = _RAND_3[0:0];
  _RAND_4 = {1{`RANDOM}};
  flight__3 = _RAND_4[0:0];
  _RAND_5 = {1{`RANDOM}};
  flight__4 = _RAND_5[0:0];
  _RAND_6 = {1{`RANDOM}};
  flight__5 = _RAND_6[0:0];
  _RAND_7 = {1{`RANDOM}};
  flight__6 = _RAND_7[0:0];
  _RAND_8 = {1{`RANDOM}};
  flight__7 = _RAND_8[0:0];
  _RAND_9 = {1{`RANDOM}};
  stalls_id = _RAND_9[1:0];
  _RAND_10 = {1{`RANDOM}};
  flight__8 = _RAND_10[0:0];
  _RAND_11 = {1{`RANDOM}};
  flight__9 = _RAND_11[0:0];
  _RAND_12 = {1{`RANDOM}};
  flight__10 = _RAND_12[0:0];
  _RAND_13 = {1{`RANDOM}};
  flight__11 = _RAND_13[0:0];
  _RAND_14 = {1{`RANDOM}};
  flight__12 = _RAND_14[0:0];
  _RAND_15 = {1{`RANDOM}};
  flight__13 = _RAND_15[0:0];
  _RAND_16 = {1{`RANDOM}};
  flight__14 = _RAND_16[0:0];
  _RAND_17 = {1{`RANDOM}};
  flight__15 = _RAND_17[0:0];
  _RAND_18 = {1{`RANDOM}};
  stalls_id_1 = _RAND_18[1:0];
  _RAND_19 = {1{`RANDOM}};
  d_first_counter = _RAND_19[8:0];
`endif // RANDOMIZE_REG_INIT
  `endif // RANDOMIZE
end // initial
`ifdef FIRRTL_AFTER_INITIAL
`FIRRTL_AFTER_INITIAL
`endif
`endif // SYNTHESIS
endmodule
module TLMonitor_10(
  input         clock,
  input         reset,
  input         io_in_a_ready,
  input         io_in_a_valid,
  input  [2:0]  io_in_a_bits_opcode,
  input  [2:0]  io_in_a_bits_param,
  input  [2:0]  io_in_a_bits_size,
  input  [4:0]  io_in_a_bits_source,
  input  [31:0] io_in_a_bits_address,
  input  [7:0]  io_in_a_bits_mask,
  input         io_in_a_bits_corrupt,
  input         io_in_b_ready,
  input         io_in_b_valid,
  input  [1:0]  io_in_b_bits_param,
  input  [4:0]  io_in_b_bits_source,
  input  [31:0] io_in_b_bits_address,
  input         io_in_c_ready,
  input         io_in_c_valid,
  input  [2:0]  io_in_c_bits_opcode,
  input  [2:0]  io_in_c_bits_param,
  input  [2:0]  io_in_c_bits_size,
  input  [4:0]  io_in_c_bits_source,
  input  [31:0] io_in_c_bits_address,
  input         io_in_c_bits_corrupt,
  input         io_in_d_ready,
  input         io_in_d_valid,
  input  [2:0]  io_in_d_bits_opcode,
  input  [1:0]  io_in_d_bits_param,
  input  [2:0]  io_in_d_bits_size,
  input  [4:0]  io_in_d_bits_source,
  input  [1:0]  io_in_d_bits_sink,
  input         io_in_d_bits_denied,
  input         io_in_d_bits_corrupt,
  input         io_in_e_valid,
  input  [1:0]  io_in_e_bits_sink
);
`ifdef RANDOMIZE_REG_INIT
  reg [31:0] _RAND_0;
  reg [31:0] _RAND_1;
  reg [31:0] _RAND_2;
  reg [31:0] _RAND_3;
  reg [31:0] _RAND_4;
  reg [31:0] _RAND_5;
  reg [31:0] _RAND_6;
  reg [31:0] _RAND_7;
  reg [31:0] _RAND_8;
  reg [31:0] _RAND_9;
  reg [31:0] _RAND_10;
  reg [31:0] _RAND_11;
  reg [31:0] _RAND_12;
  reg [31:0] _RAND_13;
  reg [31:0] _RAND_14;
  reg [31:0] _RAND_15;
  reg [31:0] _RAND_16;
  reg [31:0] _RAND_17;
  reg [31:0] _RAND_18;
  reg [31:0] _RAND_19;
  reg [31:0] _RAND_20;
  reg [31:0] _RAND_21;
  reg [31:0] _RAND_22;
  reg [31:0] _RAND_23;
  reg [127:0] _RAND_24;
  reg [127:0] _RAND_25;
  reg [31:0] _RAND_26;
  reg [31:0] _RAND_27;
  reg [31:0] _RAND_28;
  reg [31:0] _RAND_29;
  reg [127:0] _RAND_30;
  reg [31:0] _RAND_31;
  reg [31:0] _RAND_32;
  reg [31:0] _RAND_33;
  reg [31:0] _RAND_34;
  reg [31:0] _RAND_35;
`endif // RANDOMIZE_REG_INIT
  wire [31:0] plusarg_reader_out; // @[PlusArg.scala 80:11]
  wire [31:0] plusarg_reader_1_out; // @[PlusArg.scala 80:11]
  wire  _source_ok_T_1 = io_in_a_bits_source[4:3] == 2'h0; // @[Parameters.scala 54:32]
  wire  _source_ok_T_7 = io_in_a_bits_source[4:3] == 2'h1; // @[Parameters.scala 54:32]
  wire  _source_ok_T_12 = io_in_a_bits_source == 5'h1c; // @[Parameters.scala 46:9]
  wire  _source_ok_T_13 = io_in_a_bits_source == 5'h1d; // @[Parameters.scala 46:9]
  wire  _source_ok_T_14 = io_in_a_bits_source == 5'h1e; // @[Parameters.scala 46:9]
  wire  _source_ok_T_15 = io_in_a_bits_source == 5'h18; // @[Parameters.scala 46:9]
  wire  _source_ok_T_16 = io_in_a_bits_source == 5'h19; // @[Parameters.scala 46:9]
  wire  _source_ok_T_17 = io_in_a_bits_source == 5'h1a; // @[Parameters.scala 46:9]
  wire  _source_ok_T_18 = io_in_a_bits_source == 5'h14; // @[Parameters.scala 46:9]
  wire  _source_ok_T_19 = io_in_a_bits_source == 5'h15; // @[Parameters.scala 46:9]
  wire  _source_ok_T_20 = io_in_a_bits_source == 5'h16; // @[Parameters.scala 46:9]
  wire  _source_ok_T_21 = io_in_a_bits_source == 5'h10; // @[Parameters.scala 46:9]
  wire  _source_ok_T_22 = io_in_a_bits_source == 5'h11; // @[Parameters.scala 46:9]
  wire  _source_ok_T_23 = io_in_a_bits_source == 5'h12; // @[Parameters.scala 46:9]
  wire  source_ok = _source_ok_T_1 | _source_ok_T_7 | _source_ok_T_12 | _source_ok_T_13 | _source_ok_T_14 |
    _source_ok_T_15 | _source_ok_T_16 | _source_ok_T_17 | _source_ok_T_18 | _source_ok_T_19 | _source_ok_T_20 |
    _source_ok_T_21 | _source_ok_T_22 | _source_ok_T_23; // @[Parameters.scala 1125:46]
  wire [12:0] _is_aligned_mask_T_1 = 13'h3f << io_in_a_bits_size; // @[package.scala 234:77]
  wire [5:0] is_aligned_mask = ~_is_aligned_mask_T_1[5:0]; // @[package.scala 234:46]
  wire [31:0] _GEN_86 = {{26'd0}, is_aligned_mask}; // @[Edges.scala 20:16]
  wire [31:0] _is_aligned_T = io_in_a_bits_address & _GEN_86; // @[Edges.scala 20:16]
  wire  is_aligned = _is_aligned_T == 32'h0; // @[Edges.scala 20:24]
  wire [1:0] mask_sizeOH_shiftAmount = io_in_a_bits_size[1:0]; // @[OneHot.scala 64:49]
  wire [3:0] _mask_sizeOH_T_1 = 4'h1 << mask_sizeOH_shiftAmount; // @[OneHot.scala 65:12]
  wire [2:0] mask_sizeOH = _mask_sizeOH_T_1[2:0] | 3'h1; // @[Misc.scala 201:81]
  wire  _mask_T = io_in_a_bits_size >= 3'h3; // @[Misc.scala 205:21]
  wire  mask_size = mask_sizeOH[2]; // @[Misc.scala 208:26]
  wire  mask_bit = io_in_a_bits_address[2]; // @[Misc.scala 209:26]
  wire  mask_nbit = ~mask_bit; // @[Misc.scala 210:20]
  wire  mask_acc = _mask_T | mask_size & mask_nbit; // @[Misc.scala 214:29]
  wire  mask_acc_1 = _mask_T | mask_size & mask_bit; // @[Misc.scala 214:29]
  wire  mask_size_1 = mask_sizeOH[1]; // @[Misc.scala 208:26]
  wire  mask_bit_1 = io_in_a_bits_address[1]; // @[Misc.scala 209:26]
  wire  mask_nbit_1 = ~mask_bit_1; // @[Misc.scala 210:20]
  wire  mask_eq_2 = mask_nbit & mask_nbit_1; // @[Misc.scala 213:27]
  wire  mask_acc_2 = mask_acc | mask_size_1 & mask_eq_2; // @[Misc.scala 214:29]
  wire  mask_eq_3 = mask_nbit & mask_bit_1; // @[Misc.scala 213:27]
  wire  mask_acc_3 = mask_acc | mask_size_1 & mask_eq_3; // @[Misc.scala 214:29]
  wire  mask_eq_4 = mask_bit & mask_nbit_1; // @[Misc.scala 213:27]
  wire  mask_acc_4 = mask_acc_1 | mask_size_1 & mask_eq_4; // @[Misc.scala 214:29]
  wire  mask_eq_5 = mask_bit & mask_bit_1; // @[Misc.scala 213:27]
  wire  mask_acc_5 = mask_acc_1 | mask_size_1 & mask_eq_5; // @[Misc.scala 214:29]
  wire  mask_size_2 = mask_sizeOH[0]; // @[Misc.scala 208:26]
  wire  mask_bit_2 = io_in_a_bits_address[0]; // @[Misc.scala 209:26]
  wire  mask_nbit_2 = ~mask_bit_2; // @[Misc.scala 210:20]
  wire  mask_eq_6 = mask_eq_2 & mask_nbit_2; // @[Misc.scala 213:27]
  wire  mask_lo_lo_lo = mask_acc_2 | mask_size_2 & mask_eq_6; // @[Misc.scala 214:29]
  wire  mask_eq_7 = mask_eq_2 & mask_bit_2; // @[Misc.scala 213:27]
  wire  mask_lo_lo_hi = mask_acc_2 | mask_size_2 & mask_eq_7; // @[Misc.scala 214:29]
  wire  mask_eq_8 = mask_eq_3 & mask_nbit_2; // @[Misc.scala 213:27]
  wire  mask_lo_hi_lo = mask_acc_3 | mask_size_2 & mask_eq_8; // @[Misc.scala 214:29]
  wire  mask_eq_9 = mask_eq_3 & mask_bit_2; // @[Misc.scala 213:27]
  wire  mask_lo_hi_hi = mask_acc_3 | mask_size_2 & mask_eq_9; // @[Misc.scala 214:29]
  wire  mask_eq_10 = mask_eq_4 & mask_nbit_2; // @[Misc.scala 213:27]
  wire  mask_hi_lo_lo = mask_acc_4 | mask_size_2 & mask_eq_10; // @[Misc.scala 214:29]
  wire  mask_eq_11 = mask_eq_4 & mask_bit_2; // @[Misc.scala 213:27]
  wire  mask_hi_lo_hi = mask_acc_4 | mask_size_2 & mask_eq_11; // @[Misc.scala 214:29]
  wire  mask_eq_12 = mask_eq_5 & mask_nbit_2; // @[Misc.scala 213:27]
  wire  mask_hi_hi_lo = mask_acc_5 | mask_size_2 & mask_eq_12; // @[Misc.scala 214:29]
  wire  mask_eq_13 = mask_eq_5 & mask_bit_2; // @[Misc.scala 213:27]
  wire  mask_hi_hi_hi = mask_acc_5 | mask_size_2 & mask_eq_13; // @[Misc.scala 214:29]
  wire [7:0] mask = {mask_hi_hi_hi,mask_hi_hi_lo,mask_hi_lo_hi,mask_hi_lo_lo,mask_lo_hi_hi,mask_lo_hi_lo,mask_lo_lo_hi,
    mask_lo_lo_lo}; // @[Cat.scala 30:58]
  wire  _T_142 = io_in_a_bits_opcode == 3'h6; // @[Monitor.scala 81:25]
  wire  _T_186 = io_in_a_bits_size <= 3'h6; // @[Parameters.scala 92:42]
  wire [31:0] _T_189 = io_in_a_bits_address ^ 32'h80000000; // @[Parameters.scala 137:31]
  wire [32:0] _T_190 = {1'b0,$signed(_T_189)}; // @[Parameters.scala 137:49]
  wire [32:0] _T_192 = $signed(_T_190) & -33'sh80000000; // @[Parameters.scala 137:52]
  wire  _T_193 = $signed(_T_192) == 33'sh0; // @[Parameters.scala 137:67]
  wire  _T_194 = _T_186 & _T_193; // @[Parameters.scala 670:56]
  wire  _T_196 = source_ok & _T_194; // @[Monitor.scala 82:72]
  wire  _T_224 = 3'h6 == io_in_a_bits_size; // @[Parameters.scala 91:48]
  wire  _T_252 = _source_ok_T_12 & _T_224 | _source_ok_T_15 & _T_224 | _source_ok_T_18 & _T_224 | _source_ok_T_21 &
    _T_224; // @[Mux.scala 27:72]
  wire  _T_266 = _T_252 & _T_193; // @[Monitor.scala 83:78]
  wire  _T_280 = io_in_a_bits_param <= 3'h2; // @[Bundles.scala 108:27]
  wire [7:0] _T_284 = ~io_in_a_bits_mask; // @[Monitor.scala 88:18]
  wire  _T_285 = _T_284 == 8'h0; // @[Monitor.scala 88:31]
  wire  _T_289 = ~io_in_a_bits_corrupt; // @[Monitor.scala 89:18]
  wire  _T_293 = io_in_a_bits_opcode == 3'h7; // @[Monitor.scala 92:25]
  wire  _T_435 = io_in_a_bits_param != 3'h0; // @[Monitor.scala 99:31]
  wire  _T_448 = io_in_a_bits_opcode == 3'h4; // @[Monitor.scala 104:25]
  wire  _T_514 = io_in_a_bits_param == 3'h0; // @[Monitor.scala 109:31]
  wire  _T_518 = io_in_a_bits_mask == mask; // @[Monitor.scala 110:30]
  wire  _T_526 = io_in_a_bits_opcode == 3'h0; // @[Monitor.scala 114:25]
  wire  _T_598 = io_in_a_bits_opcode == 3'h1; // @[Monitor.scala 122:25]
  wire [7:0] _T_666 = ~mask; // @[Monitor.scala 127:33]
  wire [7:0] _T_667 = io_in_a_bits_mask & _T_666; // @[Monitor.scala 127:31]
  wire  _T_668 = _T_667 == 8'h0; // @[Monitor.scala 127:40]
  wire  _T_672 = io_in_a_bits_opcode == 3'h2; // @[Monitor.scala 130:25]
  wire  _T_733 = io_in_a_bits_param <= 3'h4; // @[Bundles.scala 138:33]
  wire  _T_741 = io_in_a_bits_opcode == 3'h3; // @[Monitor.scala 138:25]
  wire  _T_802 = io_in_a_bits_param <= 3'h3; // @[Bundles.scala 145:30]
  wire  _T_810 = io_in_a_bits_opcode == 3'h5; // @[Monitor.scala 146:25]
  wire  _T_871 = io_in_a_bits_param <= 3'h1; // @[Bundles.scala 158:28]
  wire  _T_883 = io_in_d_bits_opcode <= 3'h6; // @[Bundles.scala 42:24]
  wire  _source_ok_T_37 = io_in_d_bits_source[4:3] == 2'h0; // @[Parameters.scala 54:32]
  wire  _source_ok_T_43 = io_in_d_bits_source[4:3] == 2'h1; // @[Parameters.scala 54:32]
  wire  _source_ok_T_48 = io_in_d_bits_source == 5'h1c; // @[Parameters.scala 46:9]
  wire  _source_ok_T_49 = io_in_d_bits_source == 5'h1d; // @[Parameters.scala 46:9]
  wire  _source_ok_T_50 = io_in_d_bits_source == 5'h1e; // @[Parameters.scala 46:9]
  wire  _source_ok_T_51 = io_in_d_bits_source == 5'h18; // @[Parameters.scala 46:9]
  wire  _source_ok_T_52 = io_in_d_bits_source == 5'h19; // @[Parameters.scala 46:9]
  wire  _source_ok_T_53 = io_in_d_bits_source == 5'h1a; // @[Parameters.scala 46:9]
  wire  _source_ok_T_54 = io_in_d_bits_source == 5'h14; // @[Parameters.scala 46:9]
  wire  _source_ok_T_55 = io_in_d_bits_source == 5'h15; // @[Parameters.scala 46:9]
  wire  _source_ok_T_56 = io_in_d_bits_source == 5'h16; // @[Parameters.scala 46:9]
  wire  _source_ok_T_57 = io_in_d_bits_source == 5'h10; // @[Parameters.scala 46:9]
  wire  _source_ok_T_58 = io_in_d_bits_source == 5'h11; // @[Parameters.scala 46:9]
  wire  _source_ok_T_59 = io_in_d_bits_source == 5'h12; // @[Parameters.scala 46:9]
  wire  source_ok_1 = _source_ok_T_37 | _source_ok_T_43 | _source_ok_T_48 | _source_ok_T_49 | _source_ok_T_50 |
    _source_ok_T_51 | _source_ok_T_52 | _source_ok_T_53 | _source_ok_T_54 | _source_ok_T_55 | _source_ok_T_56 |
    _source_ok_T_57 | _source_ok_T_58 | _source_ok_T_59; // @[Parameters.scala 1125:46]
  wire  _T_887 = io_in_d_bits_opcode == 3'h6; // @[Monitor.scala 310:25]
  wire  _T_891 = io_in_d_bits_size >= 3'h3; // @[Monitor.scala 312:27]
  wire  _T_895 = io_in_d_bits_param == 2'h0; // @[Monitor.scala 313:28]
  wire  _T_899 = ~io_in_d_bits_corrupt; // @[Monitor.scala 314:15]
  wire  _T_903 = ~io_in_d_bits_denied; // @[Monitor.scala 315:15]
  wire  _T_907 = io_in_d_bits_opcode == 3'h4; // @[Monitor.scala 318:25]
  wire  _T_918 = io_in_d_bits_param <= 2'h2; // @[Bundles.scala 102:26]
  wire  _T_922 = io_in_d_bits_param != 2'h2; // @[Monitor.scala 323:28]
  wire  _T_935 = io_in_d_bits_opcode == 3'h5; // @[Monitor.scala 328:25]
  wire  _T_955 = _T_903 | io_in_d_bits_corrupt; // @[Monitor.scala 334:30]
  wire  _T_964 = io_in_d_bits_opcode == 3'h0; // @[Monitor.scala 338:25]
  wire  _T_981 = io_in_d_bits_opcode == 3'h1; // @[Monitor.scala 346:25]
  wire  _T_999 = io_in_d_bits_opcode == 3'h2; // @[Monitor.scala 354:25]
  wire  _T_1034 = io_in_b_bits_source[4:3] == 2'h1; // @[Parameters.scala 54:32]
  wire  _T_1046 = io_in_b_bits_source == 5'h1c; // @[Parameters.scala 46:9]
  wire  _T_1054 = io_in_b_bits_source == 5'h1d; // @[Parameters.scala 46:9]
  wire  _T_1062 = io_in_b_bits_source == 5'h1e; // @[Parameters.scala 46:9]
  wire  _T_1070 = io_in_b_bits_source == 5'h18; // @[Parameters.scala 46:9]
  wire  _T_1078 = io_in_b_bits_source == 5'h19; // @[Parameters.scala 46:9]
  wire  _T_1086 = io_in_b_bits_source == 5'h1a; // @[Parameters.scala 46:9]
  wire  _T_1094 = io_in_b_bits_source == 5'h14; // @[Parameters.scala 46:9]
  wire  _T_1102 = io_in_b_bits_source == 5'h15; // @[Parameters.scala 46:9]
  wire  _T_1110 = io_in_b_bits_source == 5'h16; // @[Parameters.scala 46:9]
  wire  _T_1118 = io_in_b_bits_source == 5'h10; // @[Parameters.scala 46:9]
  wire  _T_1126 = io_in_b_bits_source == 5'h11; // @[Parameters.scala 46:9]
  wire  _T_1134 = io_in_b_bits_source == 5'h12; // @[Parameters.scala 46:9]
  wire [31:0] _address_ok_T = io_in_b_bits_address ^ 32'h80000000; // @[Parameters.scala 137:31]
  wire [32:0] _address_ok_T_1 = {1'b0,$signed(_address_ok_T)}; // @[Parameters.scala 137:49]
  wire [32:0] _address_ok_T_3 = $signed(_address_ok_T_1) & -33'sh80000000; // @[Parameters.scala 137:52]
  wire  _address_ok_T_4 = $signed(_address_ok_T_3) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _is_aligned_T_1 = io_in_b_bits_address & 32'h3f; // @[Edges.scala 20:16]
  wire  is_aligned_1 = _is_aligned_T_1 == 32'h0; // @[Edges.scala 20:24]
  wire [3:0] _legal_source_T_25 = _T_1034 ? 4'h8 : 4'h0; // @[Mux.scala 27:72]
  wire [4:0] _legal_source_T_26 = _T_1046 ? 5'h1c : 5'h0; // @[Mux.scala 27:72]
  wire [4:0] _legal_source_T_27 = _T_1054 ? 5'h1d : 5'h0; // @[Mux.scala 27:72]
  wire [4:0] _legal_source_T_28 = _T_1062 ? 5'h1e : 5'h0; // @[Mux.scala 27:72]
  wire [4:0] _legal_source_T_29 = _T_1070 ? 5'h18 : 5'h0; // @[Mux.scala 27:72]
  wire [4:0] _legal_source_T_30 = _T_1078 ? 5'h19 : 5'h0; // @[Mux.scala 27:72]
  wire [4:0] _legal_source_T_31 = _T_1086 ? 5'h1a : 5'h0; // @[Mux.scala 27:72]
  wire [4:0] _legal_source_T_32 = _T_1094 ? 5'h14 : 5'h0; // @[Mux.scala 27:72]
  wire [4:0] _legal_source_T_33 = _T_1102 ? 5'h15 : 5'h0; // @[Mux.scala 27:72]
  wire [4:0] _legal_source_T_34 = _T_1110 ? 5'h16 : 5'h0; // @[Mux.scala 27:72]
  wire [4:0] _legal_source_T_35 = _T_1118 ? 5'h10 : 5'h0; // @[Mux.scala 27:72]
  wire [4:0] _legal_source_T_36 = _T_1126 ? 5'h11 : 5'h0; // @[Mux.scala 27:72]
  wire [4:0] _legal_source_T_37 = _T_1134 ? 5'h12 : 5'h0; // @[Mux.scala 27:72]
  wire [4:0] _GEN_87 = {{1'd0}, _legal_source_T_25}; // @[Mux.scala 27:72]
  wire [4:0] _legal_source_T_39 = _GEN_87 | _legal_source_T_26; // @[Mux.scala 27:72]
  wire [4:0] _legal_source_T_40 = _legal_source_T_39 | _legal_source_T_27; // @[Mux.scala 27:72]
  wire [4:0] _legal_source_T_41 = _legal_source_T_40 | _legal_source_T_28; // @[Mux.scala 27:72]
  wire [4:0] _legal_source_T_42 = _legal_source_T_41 | _legal_source_T_29; // @[Mux.scala 27:72]
  wire [4:0] _legal_source_T_43 = _legal_source_T_42 | _legal_source_T_30; // @[Mux.scala 27:72]
  wire [4:0] _legal_source_T_44 = _legal_source_T_43 | _legal_source_T_31; // @[Mux.scala 27:72]
  wire [4:0] _legal_source_T_45 = _legal_source_T_44 | _legal_source_T_32; // @[Mux.scala 27:72]
  wire [4:0] _legal_source_T_46 = _legal_source_T_45 | _legal_source_T_33; // @[Mux.scala 27:72]
  wire [4:0] _legal_source_T_47 = _legal_source_T_46 | _legal_source_T_34; // @[Mux.scala 27:72]
  wire [4:0] _legal_source_T_48 = _legal_source_T_47 | _legal_source_T_35; // @[Mux.scala 27:72]
  wire [4:0] _legal_source_T_49 = _legal_source_T_48 | _legal_source_T_36; // @[Mux.scala 27:72]
  wire [4:0] _legal_source_T_50 = _legal_source_T_49 | _legal_source_T_37; // @[Mux.scala 27:72]
  wire  legal_source = _legal_source_T_50 == io_in_b_bits_source; // @[Monitor.scala 165:113]
  wire  _T_1211 = _T_1046 | _T_1070 | _T_1094 | _T_1118; // @[Mux.scala 27:72]
  wire  _T_1225 = _T_1211 & _address_ok_T_4; // @[Monitor.scala 168:75]
  wire  _T_1238 = io_in_b_bits_param <= 2'h2; // @[Bundles.scala 102:26]
  wire  _source_ok_T_73 = io_in_c_bits_source[4:3] == 2'h0; // @[Parameters.scala 54:32]
  wire  _source_ok_T_79 = io_in_c_bits_source[4:3] == 2'h1; // @[Parameters.scala 54:32]
  wire  _source_ok_T_84 = io_in_c_bits_source == 5'h1c; // @[Parameters.scala 46:9]
  wire  _source_ok_T_85 = io_in_c_bits_source == 5'h1d; // @[Parameters.scala 46:9]
  wire  _source_ok_T_86 = io_in_c_bits_source == 5'h1e; // @[Parameters.scala 46:9]
  wire  _source_ok_T_87 = io_in_c_bits_source == 5'h18; // @[Parameters.scala 46:9]
  wire  _source_ok_T_88 = io_in_c_bits_source == 5'h19; // @[Parameters.scala 46:9]
  wire  _source_ok_T_89 = io_in_c_bits_source == 5'h1a; // @[Parameters.scala 46:9]
  wire  _source_ok_T_90 = io_in_c_bits_source == 5'h14; // @[Parameters.scala 46:9]
  wire  _source_ok_T_91 = io_in_c_bits_source == 5'h15; // @[Parameters.scala 46:9]
  wire  _source_ok_T_92 = io_in_c_bits_source == 5'h16; // @[Parameters.scala 46:9]
  wire  _source_ok_T_93 = io_in_c_bits_source == 5'h10; // @[Parameters.scala 46:9]
  wire  _source_ok_T_94 = io_in_c_bits_source == 5'h11; // @[Parameters.scala 46:9]
  wire  _source_ok_T_95 = io_in_c_bits_source == 5'h12; // @[Parameters.scala 46:9]
  wire  source_ok_2 = _source_ok_T_73 | _source_ok_T_79 | _source_ok_T_84 | _source_ok_T_85 | _source_ok_T_86 |
    _source_ok_T_87 | _source_ok_T_88 | _source_ok_T_89 | _source_ok_T_90 | _source_ok_T_91 | _source_ok_T_92 |
    _source_ok_T_93 | _source_ok_T_94 | _source_ok_T_95; // @[Parameters.scala 1125:46]
  wire [12:0] _is_aligned_mask_T_7 = 13'h3f << io_in_c_bits_size; // @[package.scala 234:77]
  wire [5:0] is_aligned_mask_2 = ~_is_aligned_mask_T_7[5:0]; // @[package.scala 234:46]
  wire [31:0] _GEN_88 = {{26'd0}, is_aligned_mask_2}; // @[Edges.scala 20:16]
  wire [31:0] _is_aligned_T_2 = io_in_c_bits_address & _GEN_88; // @[Edges.scala 20:16]
  wire  is_aligned_2 = _is_aligned_T_2 == 32'h0; // @[Edges.scala 20:24]
  wire [31:0] _address_ok_T_5 = io_in_c_bits_address ^ 32'h80000000; // @[Parameters.scala 137:31]
  wire [32:0] _address_ok_T_6 = {1'b0,$signed(_address_ok_T_5)}; // @[Parameters.scala 137:49]
  wire [32:0] _address_ok_T_8 = $signed(_address_ok_T_6) & -33'sh80000000; // @[Parameters.scala 137:52]
  wire  _address_ok_T_9 = $signed(_address_ok_T_8) == 33'sh0; // @[Parameters.scala 137:67]
  wire  _T_1596 = io_in_c_bits_opcode == 3'h4; // @[Monitor.scala 242:25]
  wire  _T_1603 = io_in_c_bits_size >= 3'h3; // @[Monitor.scala 245:30]
  wire  _T_1610 = io_in_c_bits_param <= 3'h5; // @[Bundles.scala 120:29]
  wire  _T_1614 = ~io_in_c_bits_corrupt; // @[Monitor.scala 248:18]
  wire  _T_1618 = io_in_c_bits_opcode == 3'h5; // @[Monitor.scala 251:25]
  wire  _T_1636 = io_in_c_bits_opcode == 3'h6; // @[Monitor.scala 259:25]
  wire  _T_1680 = io_in_c_bits_size <= 3'h6; // @[Parameters.scala 92:42]
  wire  _T_1688 = _T_1680 & _address_ok_T_9; // @[Parameters.scala 670:56]
  wire  _T_1690 = source_ok_2 & _T_1688; // @[Monitor.scala 260:78]
  wire  _T_1718 = 3'h6 == io_in_c_bits_size; // @[Parameters.scala 91:48]
  wire  _T_1746 = _source_ok_T_84 & _T_1718 | _source_ok_T_87 & _T_1718 | _source_ok_T_90 & _T_1718 | _source_ok_T_93 &
    _T_1718; // @[Mux.scala 27:72]
  wire  _T_1760 = _T_1746 & _address_ok_T_9; // @[Monitor.scala 261:78]
  wire  _T_1782 = io_in_c_bits_opcode == 3'h7; // @[Monitor.scala 269:25]
  wire  _T_1924 = io_in_c_bits_opcode == 3'h0; // @[Monitor.scala 278:25]
  wire  _T_1934 = io_in_c_bits_param == 3'h0; // @[Monitor.scala 282:31]
  wire  _T_1942 = io_in_c_bits_opcode == 3'h1; // @[Monitor.scala 286:25]
  wire  _T_1956 = io_in_c_bits_opcode == 3'h2; // @[Monitor.scala 293:25]
  wire  _a_first_T = io_in_a_ready & io_in_a_valid; // @[Decoupled.scala 40:37]
  wire [2:0] a_first_beats1_decode = is_aligned_mask[5:3]; // @[Edges.scala 219:59]
  wire  a_first_beats1_opdata = ~io_in_a_bits_opcode[2]; // @[Edges.scala 91:28]
  reg [2:0] a_first_counter; // @[Edges.scala 228:27]
  wire [2:0] a_first_counter1 = a_first_counter - 3'h1; // @[Edges.scala 229:28]
  wire  a_first = a_first_counter == 3'h0; // @[Edges.scala 230:25]
  reg [2:0] opcode; // @[Monitor.scala 384:22]
  reg [2:0] param; // @[Monitor.scala 385:22]
  reg [2:0] size; // @[Monitor.scala 386:22]
  reg [4:0] source; // @[Monitor.scala 387:22]
  reg [31:0] address; // @[Monitor.scala 388:22]
  wire  _T_1978 = io_in_a_valid & ~a_first; // @[Monitor.scala 389:19]
  wire  _T_1979 = io_in_a_bits_opcode == opcode; // @[Monitor.scala 390:32]
  wire  _T_1983 = io_in_a_bits_param == param; // @[Monitor.scala 391:32]
  wire  _T_1987 = io_in_a_bits_size == size; // @[Monitor.scala 392:32]
  wire  _T_1991 = io_in_a_bits_source == source; // @[Monitor.scala 393:32]
  wire  _T_1995 = io_in_a_bits_address == address; // @[Monitor.scala 394:32]
  wire  _d_first_T = io_in_d_ready & io_in_d_valid; // @[Decoupled.scala 40:37]
  wire [12:0] _d_first_beats1_decode_T_1 = 13'h3f << io_in_d_bits_size; // @[package.scala 234:77]
  wire [5:0] _d_first_beats1_decode_T_3 = ~_d_first_beats1_decode_T_1[5:0]; // @[package.scala 234:46]
  wire [2:0] d_first_beats1_decode = _d_first_beats1_decode_T_3[5:3]; // @[Edges.scala 219:59]
  wire  d_first_beats1_opdata = io_in_d_bits_opcode[0]; // @[Edges.scala 105:36]
  reg [2:0] d_first_counter; // @[Edges.scala 228:27]
  wire [2:0] d_first_counter1 = d_first_counter - 3'h1; // @[Edges.scala 229:28]
  wire  d_first = d_first_counter == 3'h0; // @[Edges.scala 230:25]
  reg [2:0] opcode_1; // @[Monitor.scala 535:22]
  reg [1:0] param_1; // @[Monitor.scala 536:22]
  reg [2:0] size_1; // @[Monitor.scala 537:22]
  reg [4:0] source_1; // @[Monitor.scala 538:22]
  reg [1:0] sink; // @[Monitor.scala 539:22]
  reg  denied; // @[Monitor.scala 540:22]
  wire  _T_2002 = io_in_d_valid & ~d_first; // @[Monitor.scala 541:19]
  wire  _T_2003 = io_in_d_bits_opcode == opcode_1; // @[Monitor.scala 542:29]
  wire  _T_2007 = io_in_d_bits_param == param_1; // @[Monitor.scala 543:29]
  wire  _T_2011 = io_in_d_bits_size == size_1; // @[Monitor.scala 544:29]
  wire  _T_2015 = io_in_d_bits_source == source_1; // @[Monitor.scala 545:29]
  wire  _T_2019 = io_in_d_bits_sink == sink; // @[Monitor.scala 546:29]
  wire  _T_2023 = io_in_d_bits_denied == denied; // @[Monitor.scala 547:29]
  wire  b_first_done = io_in_b_ready & io_in_b_valid; // @[Decoupled.scala 40:37]
  reg [2:0] b_first_counter; // @[Edges.scala 228:27]
  wire [2:0] b_first_counter1 = b_first_counter - 3'h1; // @[Edges.scala 229:28]
  wire  b_first = b_first_counter == 3'h0; // @[Edges.scala 230:25]
  reg [1:0] param_2; // @[Monitor.scala 408:22]
  reg [4:0] source_2; // @[Monitor.scala 410:22]
  reg [31:0] address_1; // @[Monitor.scala 411:22]
  wire  _T_2030 = io_in_b_valid & ~b_first; // @[Monitor.scala 412:19]
  wire  _T_2035 = io_in_b_bits_param == param_2; // @[Monitor.scala 414:32]
  wire  _T_2043 = io_in_b_bits_source == source_2; // @[Monitor.scala 416:32]
  wire  _T_2047 = io_in_b_bits_address == address_1; // @[Monitor.scala 417:32]
  wire  _c_first_T = io_in_c_ready & io_in_c_valid; // @[Decoupled.scala 40:37]
  wire [2:0] c_first_beats1_decode = is_aligned_mask_2[5:3]; // @[Edges.scala 219:59]
  wire  c_first_beats1_opdata = io_in_c_bits_opcode[0]; // @[Edges.scala 101:36]
  reg [2:0] c_first_counter; // @[Edges.scala 228:27]
  wire [2:0] c_first_counter1 = c_first_counter - 3'h1; // @[Edges.scala 229:28]
  wire  c_first = c_first_counter == 3'h0; // @[Edges.scala 230:25]
  reg [2:0] opcode_3; // @[Monitor.scala 512:22]
  reg [2:0] param_3; // @[Monitor.scala 513:22]
  reg [2:0] size_3; // @[Monitor.scala 514:22]
  reg [4:0] source_3; // @[Monitor.scala 515:22]
  reg [31:0] address_2; // @[Monitor.scala 516:22]
  wire  _T_2054 = io_in_c_valid & ~c_first; // @[Monitor.scala 517:19]
  wire  _T_2055 = io_in_c_bits_opcode == opcode_3; // @[Monitor.scala 518:32]
  wire  _T_2059 = io_in_c_bits_param == param_3; // @[Monitor.scala 519:32]
  wire  _T_2063 = io_in_c_bits_size == size_3; // @[Monitor.scala 520:32]
  wire  _T_2067 = io_in_c_bits_source == source_3; // @[Monitor.scala 521:32]
  wire  _T_2071 = io_in_c_bits_address == address_2; // @[Monitor.scala 522:32]
  reg [30:0] inflight; // @[Monitor.scala 611:27]
  reg [123:0] inflight_opcodes; // @[Monitor.scala 613:35]
  reg [123:0] inflight_sizes; // @[Monitor.scala 615:33]
  reg [2:0] a_first_counter_1; // @[Edges.scala 228:27]
  wire [2:0] a_first_counter1_1 = a_first_counter_1 - 3'h1; // @[Edges.scala 229:28]
  wire  a_first_1 = a_first_counter_1 == 3'h0; // @[Edges.scala 230:25]
  reg [2:0] d_first_counter_1; // @[Edges.scala 228:27]
  wire [2:0] d_first_counter1_1 = d_first_counter_1 - 3'h1; // @[Edges.scala 229:28]
  wire  d_first_1 = d_first_counter_1 == 3'h0; // @[Edges.scala 230:25]
  wire [6:0] _GEN_89 = {io_in_d_bits_source, 2'h0}; // @[Monitor.scala 634:69]
  wire [7:0] _a_opcode_lookup_T = {{1'd0}, _GEN_89}; // @[Monitor.scala 634:69]
  wire [123:0] _a_opcode_lookup_T_1 = inflight_opcodes >> _a_opcode_lookup_T; // @[Monitor.scala 634:44]
  wire [15:0] _a_opcode_lookup_T_5 = 16'h10 - 16'h1; // @[Monitor.scala 609:57]
  wire [123:0] _GEN_90 = {{108'd0}, _a_opcode_lookup_T_5}; // @[Monitor.scala 634:97]
  wire [123:0] _a_opcode_lookup_T_6 = _a_opcode_lookup_T_1 & _GEN_90; // @[Monitor.scala 634:97]
  wire [123:0] _a_opcode_lookup_T_7 = {{1'd0}, _a_opcode_lookup_T_6[123:1]}; // @[Monitor.scala 634:152]
  wire [123:0] _a_size_lookup_T_1 = inflight_sizes >> _a_opcode_lookup_T; // @[Monitor.scala 638:40]
  wire [123:0] _a_size_lookup_T_6 = _a_size_lookup_T_1 & _GEN_90; // @[Monitor.scala 638:91]
  wire [123:0] _a_size_lookup_T_7 = {{1'd0}, _a_size_lookup_T_6[123:1]}; // @[Monitor.scala 638:144]
  wire  _T_2077 = io_in_a_valid & a_first_1; // @[Monitor.scala 648:26]
  wire [31:0] _a_set_wo_ready_T = 32'h1 << io_in_a_bits_source; // @[OneHot.scala 58:35]
  wire [31:0] _GEN_27 = io_in_a_valid & a_first_1 ? _a_set_wo_ready_T : 32'h0; // @[Monitor.scala 648:71 Monitor.scala 649:22]
  wire  _T_2080 = _a_first_T & a_first_1; // @[Monitor.scala 652:27]
  wire [3:0] _a_opcodes_set_interm_T = {io_in_a_bits_opcode, 1'h0}; // @[Monitor.scala 654:53]
  wire [3:0] _a_opcodes_set_interm_T_1 = _a_opcodes_set_interm_T | 4'h1; // @[Monitor.scala 654:61]
  wire [3:0] _a_sizes_set_interm_T = {io_in_a_bits_size, 1'h0}; // @[Monitor.scala 655:51]
  wire [3:0] _a_sizes_set_interm_T_1 = _a_sizes_set_interm_T | 4'h1; // @[Monitor.scala 655:59]
  wire [6:0] _GEN_95 = {io_in_a_bits_source, 2'h0}; // @[Monitor.scala 656:79]
  wire [7:0] _a_opcodes_set_T = {{1'd0}, _GEN_95}; // @[Monitor.scala 656:79]
  wire [3:0] a_opcodes_set_interm = _a_first_T & a_first_1 ? _a_opcodes_set_interm_T_1 : 4'h0; // @[Monitor.scala 652:72 Monitor.scala 654:28]
  wire [258:0] _GEN_96 = {{255'd0}, a_opcodes_set_interm}; // @[Monitor.scala 656:54]
  wire [258:0] _a_opcodes_set_T_1 = _GEN_96 << _a_opcodes_set_T; // @[Monitor.scala 656:54]
  wire [3:0] a_sizes_set_interm = _a_first_T & a_first_1 ? _a_sizes_set_interm_T_1 : 4'h0; // @[Monitor.scala 652:72 Monitor.scala 655:28]
  wire [258:0] _GEN_98 = {{255'd0}, a_sizes_set_interm}; // @[Monitor.scala 657:52]
  wire [258:0] _a_sizes_set_T_1 = _GEN_98 << _a_opcodes_set_T; // @[Monitor.scala 657:52]
  wire [30:0] _T_2082 = inflight >> io_in_a_bits_source; // @[Monitor.scala 658:26]
  wire  _T_2084 = ~_T_2082[0]; // @[Monitor.scala 658:17]
  wire [31:0] _GEN_28 = _a_first_T & a_first_1 ? _a_set_wo_ready_T : 32'h0; // @[Monitor.scala 652:72 Monitor.scala 653:28]
  wire [258:0] _GEN_31 = _a_first_T & a_first_1 ? _a_opcodes_set_T_1 : 259'h0; // @[Monitor.scala 652:72 Monitor.scala 656:28]
  wire [258:0] _GEN_32 = _a_first_T & a_first_1 ? _a_sizes_set_T_1 : 259'h0; // @[Monitor.scala 652:72 Monitor.scala 657:28]
  wire  _T_2088 = io_in_d_valid & d_first_1; // @[Monitor.scala 671:26]
  wire  _T_2090 = ~_T_887; // @[Monitor.scala 671:74]
  wire  _T_2091 = io_in_d_valid & d_first_1 & ~_T_887; // @[Monitor.scala 671:71]
  wire [31:0] _d_clr_wo_ready_T = 32'h1 << io_in_d_bits_source; // @[OneHot.scala 58:35]
  wire [31:0] _GEN_33 = io_in_d_valid & d_first_1 & ~_T_887 ? _d_clr_wo_ready_T : 32'h0; // @[Monitor.scala 671:90 Monitor.scala 672:22]
  wire [270:0] _GEN_100 = {{255'd0}, _a_opcode_lookup_T_5}; // @[Monitor.scala 677:76]
  wire [270:0] _d_opcodes_clr_T_5 = _GEN_100 << _a_opcode_lookup_T; // @[Monitor.scala 677:76]
  wire [31:0] _GEN_34 = _d_first_T & d_first_1 & _T_2090 ? _d_clr_wo_ready_T : 32'h0; // @[Monitor.scala 675:91 Monitor.scala 676:21]
  wire [270:0] _GEN_35 = _d_first_T & d_first_1 & _T_2090 ? _d_opcodes_clr_T_5 : 271'h0; // @[Monitor.scala 675:91 Monitor.scala 677:21]
  wire  _same_cycle_resp_T_2 = io_in_a_bits_source == io_in_d_bits_source; // @[Monitor.scala 681:113]
  wire  same_cycle_resp = _T_2077 & io_in_a_bits_source == io_in_d_bits_source; // @[Monitor.scala 681:88]
  wire [30:0] _T_2101 = inflight >> io_in_d_bits_source; // @[Monitor.scala 682:25]
  wire  _T_2103 = _T_2101[0] | same_cycle_resp; // @[Monitor.scala 682:49]
  wire [2:0] _GEN_39 = 3'h2 == io_in_a_bits_opcode ? 3'h1 : 3'h0; // @[Monitor.scala 685:38 Monitor.scala 685:38]
  wire [2:0] _GEN_40 = 3'h3 == io_in_a_bits_opcode ? 3'h1 : _GEN_39; // @[Monitor.scala 685:38 Monitor.scala 685:38]
  wire [2:0] _GEN_41 = 3'h4 == io_in_a_bits_opcode ? 3'h1 : _GEN_40; // @[Monitor.scala 685:38 Monitor.scala 685:38]
  wire [2:0] _GEN_42 = 3'h5 == io_in_a_bits_opcode ? 3'h2 : _GEN_41; // @[Monitor.scala 685:38 Monitor.scala 685:38]
  wire [2:0] _GEN_43 = 3'h6 == io_in_a_bits_opcode ? 3'h4 : _GEN_42; // @[Monitor.scala 685:38 Monitor.scala 685:38]
  wire [2:0] _GEN_44 = 3'h7 == io_in_a_bits_opcode ? 3'h4 : _GEN_43; // @[Monitor.scala 685:38 Monitor.scala 685:38]
  wire [2:0] _GEN_51 = 3'h6 == io_in_a_bits_opcode ? 3'h5 : _GEN_42; // @[Monitor.scala 686:39 Monitor.scala 686:39]
  wire [2:0] _GEN_52 = 3'h7 == io_in_a_bits_opcode ? 3'h4 : _GEN_51; // @[Monitor.scala 686:39 Monitor.scala 686:39]
  wire  _T_2108 = io_in_d_bits_opcode == _GEN_52; // @[Monitor.scala 686:39]
  wire  _T_2109 = io_in_d_bits_opcode == _GEN_44 | _T_2108; // @[Monitor.scala 685:77]
  wire  _T_2113 = io_in_a_bits_size == io_in_d_bits_size; // @[Monitor.scala 687:36]
  wire [3:0] a_opcode_lookup = _a_opcode_lookup_T_7[3:0];
  wire [2:0] _GEN_55 = 3'h2 == a_opcode_lookup[2:0] ? 3'h1 : 3'h0; // @[Monitor.scala 689:38 Monitor.scala 689:38]
  wire [2:0] _GEN_56 = 3'h3 == a_opcode_lookup[2:0] ? 3'h1 : _GEN_55; // @[Monitor.scala 689:38 Monitor.scala 689:38]
  wire [2:0] _GEN_57 = 3'h4 == a_opcode_lookup[2:0] ? 3'h1 : _GEN_56; // @[Monitor.scala 689:38 Monitor.scala 689:38]
  wire [2:0] _GEN_58 = 3'h5 == a_opcode_lookup[2:0] ? 3'h2 : _GEN_57; // @[Monitor.scala 689:38 Monitor.scala 689:38]
  wire [2:0] _GEN_59 = 3'h6 == a_opcode_lookup[2:0] ? 3'h4 : _GEN_58; // @[Monitor.scala 689:38 Monitor.scala 689:38]
  wire [2:0] _GEN_60 = 3'h7 == a_opcode_lookup[2:0] ? 3'h4 : _GEN_59; // @[Monitor.scala 689:38 Monitor.scala 689:38]
  wire [2:0] _GEN_67 = 3'h6 == a_opcode_lookup[2:0] ? 3'h5 : _GEN_58; // @[Monitor.scala 690:38 Monitor.scala 690:38]
  wire [2:0] _GEN_68 = 3'h7 == a_opcode_lookup[2:0] ? 3'h4 : _GEN_67; // @[Monitor.scala 690:38 Monitor.scala 690:38]
  wire  _T_2120 = io_in_d_bits_opcode == _GEN_68; // @[Monitor.scala 690:38]
  wire  _T_2121 = io_in_d_bits_opcode == _GEN_60 | _T_2120; // @[Monitor.scala 689:72]
  wire [3:0] a_size_lookup = _a_size_lookup_T_7[3:0];
  wire [3:0] _GEN_103 = {{1'd0}, io_in_d_bits_size}; // @[Monitor.scala 691:36]
  wire  _T_2125 = _GEN_103 == a_size_lookup; // @[Monitor.scala 691:36]
  wire  _T_2135 = _T_2088 & a_first_1 & io_in_a_valid & _same_cycle_resp_T_2 & _T_2090; // @[Monitor.scala 694:116]
  wire  _T_2136 = ~io_in_d_ready; // @[Monitor.scala 695:15]
  wire  _T_2137 = ~io_in_d_ready | io_in_a_ready; // @[Monitor.scala 695:32]
  wire [30:0] a_set_wo_ready = _GEN_27[30:0];
  wire [30:0] d_clr_wo_ready = _GEN_33[30:0];
  wire  _T_2144 = a_set_wo_ready != d_clr_wo_ready | ~(|a_set_wo_ready); // @[Monitor.scala 699:48]
  wire [30:0] a_set = _GEN_28[30:0];
  wire [30:0] _inflight_T = inflight | a_set; // @[Monitor.scala 702:27]
  wire [30:0] d_clr = _GEN_34[30:0];
  wire [30:0] _inflight_T_1 = ~d_clr; // @[Monitor.scala 702:38]
  wire [30:0] _inflight_T_2 = _inflight_T & _inflight_T_1; // @[Monitor.scala 702:36]
  wire [123:0] a_opcodes_set = _GEN_31[123:0];
  wire [123:0] _inflight_opcodes_T = inflight_opcodes | a_opcodes_set; // @[Monitor.scala 703:43]
  wire [123:0] d_opcodes_clr = _GEN_35[123:0];
  wire [123:0] _inflight_opcodes_T_1 = ~d_opcodes_clr; // @[Monitor.scala 703:62]
  wire [123:0] _inflight_opcodes_T_2 = _inflight_opcodes_T & _inflight_opcodes_T_1; // @[Monitor.scala 703:60]
  wire [123:0] a_sizes_set = _GEN_32[123:0];
  wire [123:0] _inflight_sizes_T = inflight_sizes | a_sizes_set; // @[Monitor.scala 704:39]
  wire [123:0] _inflight_sizes_T_2 = _inflight_sizes_T & _inflight_opcodes_T_1; // @[Monitor.scala 704:54]
  reg [31:0] watchdog; // @[Monitor.scala 706:27]
  wire  _T_2153 = ~(|inflight) | plusarg_reader_out == 32'h0 | watchdog < plusarg_reader_out; // @[Monitor.scala 709:47]
  wire [31:0] _watchdog_T_1 = watchdog + 32'h1; // @[Monitor.scala 711:26]
  reg [30:0] inflight_1; // @[Monitor.scala 723:35]
  reg [123:0] inflight_sizes_1; // @[Monitor.scala 725:35]
  reg [2:0] c_first_counter_1; // @[Edges.scala 228:27]
  wire [2:0] c_first_counter1_1 = c_first_counter_1 - 3'h1; // @[Edges.scala 229:28]
  wire  c_first_1 = c_first_counter_1 == 3'h0; // @[Edges.scala 230:25]
  reg [2:0] d_first_counter_2; // @[Edges.scala 228:27]
  wire [2:0] d_first_counter1_2 = d_first_counter_2 - 3'h1; // @[Edges.scala 229:28]
  wire  d_first_2 = d_first_counter_2 == 3'h0; // @[Edges.scala 230:25]
  wire [123:0] _c_size_lookup_T_1 = inflight_sizes_1 >> _a_opcode_lookup_T; // @[Monitor.scala 747:42]
  wire [123:0] _c_size_lookup_T_6 = _c_size_lookup_T_1 & _GEN_90; // @[Monitor.scala 747:93]
  wire [123:0] _c_size_lookup_T_7 = {{1'd0}, _c_size_lookup_T_6[123:1]}; // @[Monitor.scala 747:146]
  wire  _T_2163 = io_in_c_bits_opcode[2] & io_in_c_bits_opcode[1]; // @[Edges.scala 67:40]
  wire  _T_2164 = io_in_c_valid & c_first_1 & _T_2163; // @[Monitor.scala 756:37]
  wire [31:0] _c_set_wo_ready_T = 32'h1 << io_in_c_bits_source; // @[OneHot.scala 58:35]
  wire [31:0] _GEN_72 = io_in_c_valid & c_first_1 & _T_2163 ? _c_set_wo_ready_T : 32'h0; // @[Monitor.scala 756:71 Monitor.scala 757:22]
  wire  _T_2170 = _c_first_T & c_first_1 & _T_2163; // @[Monitor.scala 760:38]
  wire [3:0] _c_sizes_set_interm_T = {io_in_c_bits_size, 1'h0}; // @[Monitor.scala 763:51]
  wire [3:0] _c_sizes_set_interm_T_1 = _c_sizes_set_interm_T | 4'h1; // @[Monitor.scala 763:59]
  wire [6:0] _GEN_110 = {io_in_c_bits_source, 2'h0}; // @[Monitor.scala 764:79]
  wire [7:0] _c_opcodes_set_T = {{1'd0}, _GEN_110}; // @[Monitor.scala 764:79]
  wire [3:0] c_sizes_set_interm = _c_first_T & c_first_1 & _T_2163 ? _c_sizes_set_interm_T_1 : 4'h0; // @[Monitor.scala 760:72 Monitor.scala 763:28]
  wire [258:0] _GEN_113 = {{255'd0}, c_sizes_set_interm}; // @[Monitor.scala 765:52]
  wire [258:0] _c_sizes_set_T_1 = _GEN_113 << _c_opcodes_set_T; // @[Monitor.scala 765:52]
  wire [30:0] _T_2171 = inflight_1 >> io_in_c_bits_source; // @[Monitor.scala 766:26]
  wire  _T_2173 = ~_T_2171[0]; // @[Monitor.scala 766:17]
  wire [31:0] _GEN_73 = _c_first_T & c_first_1 & _T_2163 ? _c_set_wo_ready_T : 32'h0; // @[Monitor.scala 760:72 Monitor.scala 761:28]
  wire [258:0] _GEN_77 = _c_first_T & c_first_1 & _T_2163 ? _c_sizes_set_T_1 : 259'h0; // @[Monitor.scala 760:72 Monitor.scala 765:28]
  wire  _T_2177 = io_in_d_valid & d_first_2; // @[Monitor.scala 779:26]
  wire  _T_2179 = io_in_d_valid & d_first_2 & _T_887; // @[Monitor.scala 779:71]
  wire [31:0] _GEN_78 = io_in_d_valid & d_first_2 & _T_887 ? _d_clr_wo_ready_T : 32'h0; // @[Monitor.scala 779:89 Monitor.scala 780:22]
  wire [31:0] _GEN_79 = _d_first_T & d_first_2 & _T_887 ? _d_clr_wo_ready_T : 32'h0; // @[Monitor.scala 783:90 Monitor.scala 784:21]
  wire [270:0] _GEN_80 = _d_first_T & d_first_2 & _T_887 ? _d_opcodes_clr_T_5 : 271'h0; // @[Monitor.scala 783:90 Monitor.scala 785:21]
  wire  _same_cycle_resp_T_8 = io_in_c_bits_source == io_in_d_bits_source; // @[Monitor.scala 790:113]
  wire  same_cycle_resp_1 = _T_2164 & io_in_c_bits_source == io_in_d_bits_source; // @[Monitor.scala 790:88]
  wire [30:0] _T_2187 = inflight_1 >> io_in_d_bits_source; // @[Monitor.scala 791:25]
  wire  _T_2189 = _T_2187[0] | same_cycle_resp_1; // @[Monitor.scala 791:49]
  wire  _T_2193 = io_in_d_bits_size == io_in_c_bits_size; // @[Monitor.scala 793:36]
  wire [3:0] c_size_lookup = _c_size_lookup_T_7[3:0];
  wire  _T_2197 = _GEN_103 == c_size_lookup; // @[Monitor.scala 795:36]
  wire  _T_2206 = _T_2177 & c_first_1 & io_in_c_valid & _same_cycle_resp_T_8 & _T_887; // @[Monitor.scala 799:116]
  wire  _T_2208 = _T_2136 | io_in_c_ready; // @[Monitor.scala 800:32]
  wire [30:0] c_set_wo_ready = _GEN_72[30:0];
  wire  _T_2212 = |c_set_wo_ready; // @[Monitor.scala 804:28]
  wire [30:0] d_clr_wo_ready_1 = _GEN_78[30:0];
  wire  _T_2213 = c_set_wo_ready != d_clr_wo_ready_1; // @[Monitor.scala 805:31]
  wire [30:0] c_set = _GEN_73[30:0];
  wire [30:0] _inflight_T_3 = inflight_1 | c_set; // @[Monitor.scala 809:35]
  wire [30:0] d_clr_1 = _GEN_79[30:0];
  wire [30:0] _inflight_T_4 = ~d_clr_1; // @[Monitor.scala 809:46]
  wire [30:0] _inflight_T_5 = _inflight_T_3 & _inflight_T_4; // @[Monitor.scala 809:44]
  wire [123:0] d_opcodes_clr_1 = _GEN_80[123:0];
  wire [123:0] _inflight_opcodes_T_4 = ~d_opcodes_clr_1; // @[Monitor.scala 810:62]
  wire [123:0] c_sizes_set = _GEN_77[123:0];
  wire [123:0] _inflight_sizes_T_3 = inflight_sizes_1 | c_sizes_set; // @[Monitor.scala 811:41]
  wire [123:0] _inflight_sizes_T_5 = _inflight_sizes_T_3 & _inflight_opcodes_T_4; // @[Monitor.scala 811:56]
  reg [31:0] watchdog_1; // @[Monitor.scala 813:27]
  wire  _T_2222 = ~(|inflight_1) | plusarg_reader_1_out == 32'h0 | watchdog_1 < plusarg_reader_1_out; // @[Monitor.scala 816:47]
  wire [31:0] _watchdog_T_3 = watchdog_1 + 32'h1; // @[Monitor.scala 818:26]
  reg [3:0] inflight_2; // @[Monitor.scala 823:27]
  reg [2:0] d_first_counter_3; // @[Edges.scala 228:27]
  wire [2:0] d_first_counter1_3 = d_first_counter_3 - 3'h1; // @[Edges.scala 229:28]
  wire  d_first_3 = d_first_counter_3 == 3'h0; // @[Edges.scala 230:25]
  wire  _T_2234 = io_in_d_bits_opcode[2] & ~io_in_d_bits_opcode[1]; // @[Edges.scala 70:40]
  wire  _T_2235 = _d_first_T & d_first_3 & _T_2234; // @[Monitor.scala 829:38]
  wire [3:0] _d_set_T = 4'h1 << io_in_d_bits_sink; // @[OneHot.scala 58:35]
  wire [3:0] _T_2236 = inflight_2 >> io_in_d_bits_sink; // @[Monitor.scala 831:23]
  wire  _T_2238 = ~_T_2236[0]; // @[Monitor.scala 831:14]
  wire [3:0] d_set = _d_first_T & d_first_3 & _T_2234 ? _d_set_T : 4'h0; // @[Monitor.scala 829:72 Monitor.scala 830:13]
  wire [3:0] _e_clr_T = 4'h1 << io_in_e_bits_sink; // @[OneHot.scala 58:35]
  wire [3:0] _T_2245 = d_set | inflight_2; // @[Monitor.scala 837:24]
  wire [3:0] _T_2246 = _T_2245 >> io_in_e_bits_sink; // @[Monitor.scala 837:35]
  wire [3:0] e_clr = io_in_e_valid ? _e_clr_T : 4'h0; // @[Monitor.scala 835:73 Monitor.scala 836:13]
  wire [3:0] _inflight_T_6 = inflight_2 | d_set; // @[Monitor.scala 842:27]
  wire [3:0] _inflight_T_7 = ~e_clr; // @[Monitor.scala 842:38]
  wire [3:0] _inflight_T_8 = _inflight_T_6 & _inflight_T_7; // @[Monitor.scala 842:36]
  plusarg_reader #(.FORMAT("tilelink_timeout=%d"), .DEFAULT(0), .WIDTH(32)) plusarg_reader ( // @[PlusArg.scala 80:11]
    .out(plusarg_reader_out)
  );
  plusarg_reader #(.FORMAT("tilelink_timeout=%d"), .DEFAULT(0), .WIDTH(32)) plusarg_reader_1 ( // @[PlusArg.scala 80:11]
    .out(plusarg_reader_1_out)
  );
  always @(posedge clock) begin
    if (reset) begin // @[Edges.scala 228:27]
      a_first_counter <= 3'h0; // @[Edges.scala 228:27]
    end else if (_a_first_T) begin // @[Edges.scala 234:17]
      if (a_first) begin // @[Edges.scala 235:21]
        if (a_first_beats1_opdata) begin // @[Edges.scala 220:14]
          a_first_counter <= a_first_beats1_decode;
        end else begin
          a_first_counter <= 3'h0;
        end
      end else begin
        a_first_counter <= a_first_counter1;
      end
    end
    if (_a_first_T & a_first) begin // @[Monitor.scala 396:32]
      opcode <= io_in_a_bits_opcode; // @[Monitor.scala 397:15]
    end
    if (_a_first_T & a_first) begin // @[Monitor.scala 396:32]
      param <= io_in_a_bits_param; // @[Monitor.scala 398:15]
    end
    if (_a_first_T & a_first) begin // @[Monitor.scala 396:32]
      size <= io_in_a_bits_size; // @[Monitor.scala 399:15]
    end
    if (_a_first_T & a_first) begin // @[Monitor.scala 396:32]
      source <= io_in_a_bits_source; // @[Monitor.scala 400:15]
    end
    if (_a_first_T & a_first) begin // @[Monitor.scala 396:32]
      address <= io_in_a_bits_address; // @[Monitor.scala 401:15]
    end
    if (reset) begin // @[Edges.scala 228:27]
      d_first_counter <= 3'h0; // @[Edges.scala 228:27]
    end else if (_d_first_T) begin // @[Edges.scala 234:17]
      if (d_first) begin // @[Edges.scala 235:21]
        if (d_first_beats1_opdata) begin // @[Edges.scala 220:14]
          d_first_counter <= d_first_beats1_decode;
        end else begin
          d_first_counter <= 3'h0;
        end
      end else begin
        d_first_counter <= d_first_counter1;
      end
    end
    if (_d_first_T & d_first) begin // @[Monitor.scala 549:32]
      opcode_1 <= io_in_d_bits_opcode; // @[Monitor.scala 550:15]
    end
    if (_d_first_T & d_first) begin // @[Monitor.scala 549:32]
      param_1 <= io_in_d_bits_param; // @[Monitor.scala 551:15]
    end
    if (_d_first_T & d_first) begin // @[Monitor.scala 549:32]
      size_1 <= io_in_d_bits_size; // @[Monitor.scala 552:15]
    end
    if (_d_first_T & d_first) begin // @[Monitor.scala 549:32]
      source_1 <= io_in_d_bits_source; // @[Monitor.scala 553:15]
    end
    if (_d_first_T & d_first) begin // @[Monitor.scala 549:32]
      sink <= io_in_d_bits_sink; // @[Monitor.scala 554:15]
    end
    if (_d_first_T & d_first) begin // @[Monitor.scala 549:32]
      denied <= io_in_d_bits_denied; // @[Monitor.scala 555:15]
    end
    if (reset) begin // @[Edges.scala 228:27]
      b_first_counter <= 3'h0; // @[Edges.scala 228:27]
    end else if (b_first_done) begin // @[Edges.scala 234:17]
      if (b_first) begin // @[Edges.scala 235:21]
        b_first_counter <= 3'h0;
      end else begin
        b_first_counter <= b_first_counter1;
      end
    end
    if (b_first_done & b_first) begin // @[Monitor.scala 419:32]
      param_2 <= io_in_b_bits_param; // @[Monitor.scala 421:15]
    end
    if (b_first_done & b_first) begin // @[Monitor.scala 419:32]
      source_2 <= io_in_b_bits_source; // @[Monitor.scala 423:15]
    end
    if (b_first_done & b_first) begin // @[Monitor.scala 419:32]
      address_1 <= io_in_b_bits_address; // @[Monitor.scala 424:15]
    end
    if (reset) begin // @[Edges.scala 228:27]
      c_first_counter <= 3'h0; // @[Edges.scala 228:27]
    end else if (_c_first_T) begin // @[Edges.scala 234:17]
      if (c_first) begin // @[Edges.scala 235:21]
        if (c_first_beats1_opdata) begin // @[Edges.scala 220:14]
          c_first_counter <= c_first_beats1_decode;
        end else begin
          c_first_counter <= 3'h0;
        end
      end else begin
        c_first_counter <= c_first_counter1;
      end
    end
    if (_c_first_T & c_first) begin // @[Monitor.scala 524:32]
      opcode_3 <= io_in_c_bits_opcode; // @[Monitor.scala 525:15]
    end
    if (_c_first_T & c_first) begin // @[Monitor.scala 524:32]
      param_3 <= io_in_c_bits_param; // @[Monitor.scala 526:15]
    end
    if (_c_first_T & c_first) begin // @[Monitor.scala 524:32]
      size_3 <= io_in_c_bits_size; // @[Monitor.scala 527:15]
    end
    if (_c_first_T & c_first) begin // @[Monitor.scala 524:32]
      source_3 <= io_in_c_bits_source; // @[Monitor.scala 528:15]
    end
    if (_c_first_T & c_first) begin // @[Monitor.scala 524:32]
      address_2 <= io_in_c_bits_address; // @[Monitor.scala 529:15]
    end
    if (reset) begin // @[Monitor.scala 611:27]
      inflight <= 31'h0; // @[Monitor.scala 611:27]
    end else begin
      inflight <= _inflight_T_2; // @[Monitor.scala 702:14]
    end
    if (reset) begin // @[Monitor.scala 613:35]
      inflight_opcodes <= 124'h0; // @[Monitor.scala 613:35]
    end else begin
      inflight_opcodes <= _inflight_opcodes_T_2; // @[Monitor.scala 703:22]
    end
    if (reset) begin // @[Monitor.scala 615:33]
      inflight_sizes <= 124'h0; // @[Monitor.scala 615:33]
    end else begin
      inflight_sizes <= _inflight_sizes_T_2; // @[Monitor.scala 704:20]
    end
    if (reset) begin // @[Edges.scala 228:27]
      a_first_counter_1 <= 3'h0; // @[Edges.scala 228:27]
    end else if (_a_first_T) begin // @[Edges.scala 234:17]
      if (a_first_1) begin // @[Edges.scala 235:21]
        if (a_first_beats1_opdata) begin // @[Edges.scala 220:14]
          a_first_counter_1 <= a_first_beats1_decode;
        end else begin
          a_first_counter_1 <= 3'h0;
        end
      end else begin
        a_first_counter_1 <= a_first_counter1_1;
      end
    end
    if (reset) begin // @[Edges.scala 228:27]
      d_first_counter_1 <= 3'h0; // @[Edges.scala 228:27]
    end else if (_d_first_T) begin // @[Edges.scala 234:17]
      if (d_first_1) begin // @[Edges.scala 235:21]
        if (d_first_beats1_opdata) begin // @[Edges.scala 220:14]
          d_first_counter_1 <= d_first_beats1_decode;
        end else begin
          d_first_counter_1 <= 3'h0;
        end
      end else begin
        d_first_counter_1 <= d_first_counter1_1;
      end
    end
    if (reset) begin // @[Monitor.scala 706:27]
      watchdog <= 32'h0; // @[Monitor.scala 706:27]
    end else if (_a_first_T | _d_first_T) begin // @[Monitor.scala 712:47]
      watchdog <= 32'h0; // @[Monitor.scala 712:58]
    end else begin
      watchdog <= _watchdog_T_1; // @[Monitor.scala 711:14]
    end
    if (reset) begin // @[Monitor.scala 723:35]
      inflight_1 <= 31'h0; // @[Monitor.scala 723:35]
    end else begin
      inflight_1 <= _inflight_T_5; // @[Monitor.scala 809:22]
    end
    if (reset) begin // @[Monitor.scala 725:35]
      inflight_sizes_1 <= 124'h0; // @[Monitor.scala 725:35]
    end else begin
      inflight_sizes_1 <= _inflight_sizes_T_5; // @[Monitor.scala 811:22]
    end
    if (reset) begin // @[Edges.scala 228:27]
      c_first_counter_1 <= 3'h0; // @[Edges.scala 228:27]
    end else if (_c_first_T) begin // @[Edges.scala 234:17]
      if (c_first_1) begin // @[Edges.scala 235:21]
        if (c_first_beats1_opdata) begin // @[Edges.scala 220:14]
          c_first_counter_1 <= c_first_beats1_decode;
        end else begin
          c_first_counter_1 <= 3'h0;
        end
      end else begin
        c_first_counter_1 <= c_first_counter1_1;
      end
    end
    if (reset) begin // @[Edges.scala 228:27]
      d_first_counter_2 <= 3'h0; // @[Edges.scala 228:27]
    end else if (_d_first_T) begin // @[Edges.scala 234:17]
      if (d_first_2) begin // @[Edges.scala 235:21]
        if (d_first_beats1_opdata) begin // @[Edges.scala 220:14]
          d_first_counter_2 <= d_first_beats1_decode;
        end else begin
          d_first_counter_2 <= 3'h0;
        end
      end else begin
        d_first_counter_2 <= d_first_counter1_2;
      end
    end
    if (reset) begin // @[Monitor.scala 813:27]
      watchdog_1 <= 32'h0; // @[Monitor.scala 813:27]
    end else if (_c_first_T | _d_first_T) begin // @[Monitor.scala 819:47]
      watchdog_1 <= 32'h0; // @[Monitor.scala 819:58]
    end else begin
      watchdog_1 <= _watchdog_T_3; // @[Monitor.scala 818:14]
    end
    if (reset) begin // @[Monitor.scala 823:27]
      inflight_2 <= 4'h0; // @[Monitor.scala 823:27]
    end else begin
      inflight_2 <= _inflight_T_8; // @[Monitor.scala 842:14]
    end
    if (reset) begin // @[Edges.scala 228:27]
      d_first_counter_3 <= 3'h0; // @[Edges.scala 228:27]
    end else if (_d_first_T) begin // @[Edges.scala 234:17]
      if (d_first_3) begin // @[Edges.scala 235:21]
        if (d_first_beats1_opdata) begin // @[Edges.scala 220:14]
          d_first_counter_3 <= d_first_beats1_decode;
        end else begin
          d_first_counter_3 <= 3'h0;
        end
      end else begin
        d_first_counter_3 <= d_first_counter1_3;
      end
    end
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_142 & ~(_T_196 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries AcquireBlock type which is unexpected using diplomatic parameters (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_142 & ~(_T_196 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_142 & ~(_T_266 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries AcquireBlock from a client which does not support Probe (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_142 & ~(_T_266 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_142 & ~(source_ok | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquireBlock carries invalid source ID (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_142 & ~(source_ok | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_142 & ~(_mask_T | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquireBlock smaller than a beat (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_142 & ~(_mask_T | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_142 & ~(is_aligned | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquireBlock address not aligned to size (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_142 & ~(is_aligned | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_142 & ~(_T_280 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquireBlock carries invalid grow param (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_142 & ~(_T_280 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_142 & ~(_T_285 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquireBlock contains invalid mask (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_142 & ~(_T_285 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_142 & ~(_T_289 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquireBlock is corrupt (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_142 & ~(_T_289 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_293 & ~(_T_196 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries AcquirePerm type which is unexpected using diplomatic parameters (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_293 & ~(_T_196 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_293 & ~(_T_266 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries AcquirePerm from a client which does not support Probe (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_293 & ~(_T_266 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_293 & ~(source_ok | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquirePerm carries invalid source ID (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_293 & ~(source_ok | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_293 & ~(_mask_T | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquirePerm smaller than a beat (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_293 & ~(_mask_T | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_293 & ~(is_aligned | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquirePerm address not aligned to size (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_293 & ~(is_aligned | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_293 & ~(_T_280 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquirePerm carries invalid grow param (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_293 & ~(_T_280 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_293 & ~(_T_435 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquirePerm requests NtoB (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_293 & ~(_T_435 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_293 & ~(_T_285 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquirePerm contains invalid mask (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_293 & ~(_T_285 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_293 & ~(_T_289 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquirePerm is corrupt (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_293 & ~(_T_289 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_448 & ~(source_ok | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries Get type which master claims it can't emit (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_448 & ~(source_ok | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_448 & ~(_T_194 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries Get type which slave claims it can't support (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_448 & ~(_T_194 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_448 & ~(source_ok | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Get carries invalid source ID (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_448 & ~(source_ok | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_448 & ~(is_aligned | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Get address not aligned to size (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_448 & ~(is_aligned | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_448 & ~(_T_514 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Get carries invalid param (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_448 & ~(_T_514 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_448 & ~(_T_518 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Get contains invalid mask (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_448 & ~(_T_518 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_448 & ~(_T_289 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Get is corrupt (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_448 & ~(_T_289 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_526 & ~(_T_196 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries PutFull type which is unexpected using diplomatic parameters (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_526 & ~(_T_196 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_526 & ~(source_ok | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel PutFull carries invalid source ID (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_526 & ~(source_ok | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_526 & ~(is_aligned | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel PutFull address not aligned to size (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_526 & ~(is_aligned | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_526 & ~(_T_514 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel PutFull carries invalid param (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_526 & ~(_T_514 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_526 & ~(_T_518 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel PutFull contains invalid mask (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_526 & ~(_T_518 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_598 & ~(_T_196 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries PutPartial type which is unexpected using diplomatic parameters (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_598 & ~(_T_196 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_598 & ~(source_ok | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel PutPartial carries invalid source ID (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_598 & ~(source_ok | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_598 & ~(is_aligned | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel PutPartial address not aligned to size (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_598 & ~(is_aligned | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_598 & ~(_T_514 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel PutPartial carries invalid param (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_598 & ~(_T_514 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_598 & ~(_T_668 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel PutPartial contains invalid mask (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_598 & ~(_T_668 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_672 & ~reset) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries Arithmetic type which is unexpected using diplomatic parameters (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_672 & ~reset) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_672 & ~(source_ok | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Arithmetic carries invalid source ID (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_672 & ~(source_ok | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_672 & ~(is_aligned | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Arithmetic address not aligned to size (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_672 & ~(is_aligned | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_672 & ~(_T_733 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Arithmetic carries invalid opcode param (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_672 & ~(_T_733 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_672 & ~(_T_518 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Arithmetic contains invalid mask (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_672 & ~(_T_518 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_741 & ~reset) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries Logical type which is unexpected using diplomatic parameters (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_741 & ~reset) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_741 & ~(source_ok | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Logical carries invalid source ID (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_741 & ~(source_ok | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_741 & ~(is_aligned | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Logical address not aligned to size (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_741 & ~(is_aligned | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_741 & ~(_T_802 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Logical carries invalid opcode param (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_741 & ~(_T_802 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_741 & ~(_T_518 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Logical contains invalid mask (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_741 & ~(_T_518 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_810 & ~reset) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries Hint type which is unexpected using diplomatic parameters (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_810 & ~reset) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_810 & ~(source_ok | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Hint carries invalid source ID (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_810 & ~(source_ok | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_810 & ~(is_aligned | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Hint address not aligned to size (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_810 & ~(is_aligned | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_810 & ~(_T_871 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Hint carries invalid opcode param (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_810 & ~(_T_871 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_810 & ~(_T_518 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Hint contains invalid mask (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_810 & ~(_T_518 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_810 & ~(_T_289 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Hint is corrupt (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_810 & ~(_T_289 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & ~(_T_883 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel has invalid opcode (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & ~(_T_883 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_887 & ~(source_ok_1 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel ReleaseAck carries invalid source ID (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_887 & ~(source_ok_1 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_887 & ~(_T_891 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel ReleaseAck smaller than a beat (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_887 & ~(_T_891 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_887 & ~(_T_895 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel ReleaseeAck carries invalid param (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_887 & ~(_T_895 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_887 & ~(_T_899 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel ReleaseAck is corrupt (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_887 & ~(_T_899 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_887 & ~(_T_903 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel ReleaseAck is denied (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_887 & ~(_T_903 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_907 & ~(source_ok_1 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel Grant carries invalid source ID (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_907 & ~(source_ok_1 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_907 & ~(_T_891 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel Grant smaller than a beat (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_907 & ~(_T_891 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_907 & ~(_T_918 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel Grant carries invalid cap param (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_907 & ~(_T_918 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_907 & ~(_T_922 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel Grant carries toN param (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_907 & ~(_T_922 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_907 & ~(_T_899 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel Grant is corrupt (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_907 & ~(_T_899 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_935 & ~(source_ok_1 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel GrantData carries invalid source ID (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_935 & ~(source_ok_1 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_935 & ~(_T_891 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel GrantData smaller than a beat (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_935 & ~(_T_891 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_935 & ~(_T_918 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel GrantData carries invalid cap param (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_935 & ~(_T_918 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_935 & ~(_T_922 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel GrantData carries toN param (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_935 & ~(_T_922 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_935 & ~(_T_955 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel GrantData is denied but not corrupt (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_935 & ~(_T_955 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_964 & ~(source_ok_1 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel AccessAck carries invalid source ID (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_964 & ~(source_ok_1 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_964 & ~(_T_895 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel AccessAck carries invalid param (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_964 & ~(_T_895 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_964 & ~(_T_899 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel AccessAck is corrupt (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_964 & ~(_T_899 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_981 & ~(source_ok_1 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel AccessAckData carries invalid source ID (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_981 & ~(source_ok_1 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_981 & ~(_T_895 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel AccessAckData carries invalid param (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_981 & ~(_T_895 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_981 & ~(_T_955 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel AccessAckData is denied but not corrupt (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_981 & ~(_T_955 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_999 & ~(source_ok_1 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel HintAck carries invalid source ID (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_999 & ~(source_ok_1 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_999 & ~(_T_895 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel HintAck carries invalid param (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_999 & ~(_T_895 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_999 & ~(_T_899 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel HintAck is corrupt (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_999 & ~(_T_899 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_b_valid & ~(_T_1225 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'B' channel carries Probe type which is unexpected using diplomatic parameters (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_b_valid & ~(_T_1225 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_b_valid & ~(_address_ok_T_4 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'B' channel Probe carries unmanaged address (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_b_valid & ~(_address_ok_T_4 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_b_valid & ~(legal_source | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'B' channel Probe carries source that is not first source (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_b_valid & ~(legal_source | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_b_valid & ~(is_aligned_1 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'B' channel Probe address not aligned to size (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_b_valid & ~(is_aligned_1 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_b_valid & ~(_T_1238 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'B' channel Probe carries invalid cap param (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_b_valid & ~(_T_1238 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1596 & ~(_address_ok_T_9 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel ProbeAck carries unmanaged address (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1596 & ~(_address_ok_T_9 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1596 & ~(source_ok_2 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel ProbeAck carries invalid source ID (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1596 & ~(source_ok_2 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1596 & ~(_T_1603 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel ProbeAck smaller than a beat (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1596 & ~(_T_1603 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1596 & ~(is_aligned_2 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel ProbeAck address not aligned to size (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1596 & ~(is_aligned_2 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1596 & ~(_T_1610 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel ProbeAck carries invalid report param (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1596 & ~(_T_1610 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1596 & ~(_T_1614 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel ProbeAck is corrupt (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1596 & ~(_T_1614 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1618 & ~(_address_ok_T_9 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel ProbeAckData carries unmanaged address (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1618 & ~(_address_ok_T_9 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1618 & ~(source_ok_2 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel ProbeAckData carries invalid source ID (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1618 & ~(source_ok_2 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1618 & ~(_T_1603 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel ProbeAckData smaller than a beat (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1618 & ~(_T_1603 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1618 & ~(is_aligned_2 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel ProbeAckData address not aligned to size (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1618 & ~(is_aligned_2 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1618 & ~(_T_1610 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel ProbeAckData carries invalid report param (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1618 & ~(_T_1610 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1636 & ~(_T_1690 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel carries Release type unsupported by manager (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1636 & ~(_T_1690 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1636 & ~(_T_1760 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel carries Release from a client which does not support Probe (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1636 & ~(_T_1760 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1636 & ~(source_ok_2 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel Release carries invalid source ID (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1636 & ~(source_ok_2 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1636 & ~(_T_1603 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel Release smaller than a beat (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1636 & ~(_T_1603 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1636 & ~(is_aligned_2 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel Release address not aligned to size (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1636 & ~(is_aligned_2 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1636 & ~(_T_1610 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel Release carries invalid report param (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1636 & ~(_T_1610 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1636 & ~(_T_1614 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel Release is corrupt (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1636 & ~(_T_1614 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1782 & ~(_T_1690 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel carries ReleaseData type unsupported by manager (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1782 & ~(_T_1690 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1782 & ~(_T_1760 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel carries Release from a client which does not support Probe (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1782 & ~(_T_1760 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1782 & ~(source_ok_2 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel ReleaseData carries invalid source ID (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1782 & ~(source_ok_2 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1782 & ~(_T_1603 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel ReleaseData smaller than a beat (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1782 & ~(_T_1603 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1782 & ~(is_aligned_2 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel ReleaseData address not aligned to size (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1782 & ~(is_aligned_2 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1782 & ~(_T_1610 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel ReleaseData carries invalid report param (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1782 & ~(_T_1610 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1924 & ~(_address_ok_T_9 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel AccessAck carries unmanaged address (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1924 & ~(_address_ok_T_9 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1924 & ~(source_ok_2 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel AccessAck carries invalid source ID (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1924 & ~(source_ok_2 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1924 & ~(is_aligned_2 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel AccessAck address not aligned to size (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1924 & ~(is_aligned_2 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1924 & ~(_T_1934 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel AccessAck carries invalid param (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1924 & ~(_T_1934 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1924 & ~(_T_1614 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel AccessAck is corrupt (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1924 & ~(_T_1614 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1942 & ~(_address_ok_T_9 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel AccessAckData carries unmanaged address (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1942 & ~(_address_ok_T_9 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1942 & ~(source_ok_2 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel AccessAckData carries invalid source ID (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1942 & ~(source_ok_2 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1942 & ~(is_aligned_2 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel AccessAckData address not aligned to size (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1942 & ~(is_aligned_2 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1942 & ~(_T_1934 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel AccessAckData carries invalid param (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1942 & ~(_T_1934 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1956 & ~(_address_ok_T_9 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel HintAck carries unmanaged address (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1956 & ~(_address_ok_T_9 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1956 & ~(source_ok_2 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel HintAck carries invalid source ID (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1956 & ~(source_ok_2 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1956 & ~(is_aligned_2 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel HintAck address not aligned to size (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1956 & ~(is_aligned_2 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1956 & ~(_T_1934 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel HintAck carries invalid param (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1956 & ~(_T_1934 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1956 & ~(_T_1614 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel HintAck is corrupt (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1956 & ~(_T_1614 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1978 & ~(_T_1979 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel opcode changed within multibeat operation (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1978 & ~(_T_1979 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1978 & ~(_T_1983 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel param changed within multibeat operation (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1978 & ~(_T_1983 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1978 & ~(_T_1987 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel size changed within multibeat operation (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1978 & ~(_T_1987 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1978 & ~(_T_1991 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel source changed within multibeat operation (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1978 & ~(_T_1991 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1978 & ~(_T_1995 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel address changed with multibeat operation (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:42 assert(cond, message)\n"
            ); // @[Monitor.scala 42:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1978 & ~(_T_1995 | reset)) begin
          $fatal; // @[Monitor.scala 42:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_2002 & ~(_T_2003 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel opcode changed within multibeat operation (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_2002 & ~(_T_2003 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_2002 & ~(_T_2007 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel param changed within multibeat operation (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // @[Monitor.scala 49:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_2002 & ~(_T_2007 | reset)) begin
          $fatal; // @[Monitor.scala 49:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_2002 & ~(_T_2011 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel size changed within multibeat operation (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:49 assert(cond, message)\n"
            ); // 