'use strict';

var Node = require('../nodes/Node.js');
var map = require('./common/map.js');
var seq = require('./common/seq.js');
var string = require('./common/string.js');
var tags = require('./tags.js');

const sortMapEntriesByKey = (a, b) => a.key < b.key ? -1 : a.key > b.key ? 1 : 0;
class Schema {
    constructor({ customTags, merge, resolveKnownTags, schema, sortMapEntries }) {
        this.merge = !!merge;
        this.name = schema || 'core';
        this.knownTags = resolveKnownTags ? tags.coreKnownTags : {};
        this.tags = tags.getTags(customTags, this.name);
        Object.defineProperty(this, Node.MAP, { value: map.map });
        Object.defineProperty(this, Node.SCALAR, { value: string.string });
        Object.defineProperty(this, Node.SEQ, { value: seq.seq });
        // Used by createMap()
        this.sortMapEntries =
            sortMapEntries === true ? sortMapEntriesByKey : sortMapEntries || null;
    }
}

exports.Schema = Schema;
