"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Testing = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs = require("fs");
const os = require("os");
const path = require("path");
const app_1 = require("./app");
const chart_1 = require("./chart");
/**
 * Testing utilities for cdk8s applications.
 *
 * @stability stable
 */
class Testing {
    /* istanbul ignore next */
    constructor() {
        return;
    }
    /**
     * Returns an app for testing with the following properties: - Output directory is a temp dir.
     *
     * @stability stable
     */
    static app(props) {
        var _b;
        let outdir;
        if (props) {
            outdir = (_b = props.outdir) !== null && _b !== void 0 ? _b : fs.mkdtempSync(path.join(os.tmpdir(), 'cdk8s.outdir.'));
        }
        else {
            outdir = fs.mkdtempSync(path.join(os.tmpdir(), 'cdk8s.outdir.'));
        }
        return new app_1.App({ outdir, ...props });
    }
    /**
     * @returns a Chart that can be used for tests
     * @stability stable
     */
    static chart() {
        return new chart_1.Chart(this.app(), 'test');
    }
    /**
     * Returns the Kubernetes manifest synthesized from this chart.
     *
     * @stability stable
     */
    static synth(chart) {
        return chart.toJson();
    }
}
exports.Testing = Testing;
_a = JSII_RTTI_SYMBOL_1;
Testing[_a] = { fqn: "cdk8s.Testing", version: "2.1.2" };
//# sourceMappingURL=data:application/json;base64,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