import { App, AppProps } from './app';
import { Chart } from './chart';
/**
 * Testing utilities for cdk8s applications.
 *
 * @stability stable
 */
export declare class Testing {
    /**
     * Returns an app for testing with the following properties: - Output directory is a temp dir.
     *
     * @stability stable
     */
    static app(props?: AppProps): App;
    /**
     * @returns a Chart that can be used for tests
     * @stability stable
     */
    static chart(): Chart;
    /**
     * Returns the Kubernetes manifest synthesized from this chart.
     *
     * @stability stable
     */
    static synth(chart: Chart): any[];
    private constructor();
}
