"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Include = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const constructs_1 = require("constructs");
const api_object_1 = require("./api-object");
const yaml_1 = require("./yaml");
/**
 * Reads a YAML manifest from a file or a URL and defines all resources as API objects within the defined scope.
 *
 * The names (`metadata.name`) of imported resources will be preserved as-is
 * from the manifest.
 *
 * @stability stable
 */
class Include extends constructs_1.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _b, _c, _d, _e;
        super(scope, id);
        const objects = yaml_1.Yaml.load(props.url);
        let order = 0;
        for (const obj of objects) {
            const objname = (_c = (_b = obj.metadata) === null || _b === void 0 ? void 0 : _b.name) !== null && _c !== void 0 ? _c : `object${order++}`;
            // render an id: name[-kind][-namespace]
            const objid = [objname, (_d = obj.kind) === null || _d === void 0 ? void 0 : _d.toLowerCase(), (_e = obj.metadata) === null || _e === void 0 ? void 0 : _e.namespace].filter(x => x).join('-');
            new api_object_1.ApiObject(this, objid, obj);
        }
    }
    /**
     * Returns all the included API objects.
     *
     * @stability stable
     */
    get apiObjects() {
        return constructs_1.Node.of(this).children.filter(o => o instanceof api_object_1.ApiObject);
    }
}
exports.Include = Include;
_a = JSII_RTTI_SYMBOL_1;
Include[_a] = { fqn: "cdk8s.Include", version: "2.1.2" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5jbHVkZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy9pbmNsdWRlLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQUEsMkNBQTZDO0FBQzdDLDZDQUF5QztBQUN6QyxpQ0FBOEI7Ozs7Ozs7OztBQVE5QixNQUFhLE9BQVEsU0FBUSxzQkFBUzs7OztJQUNwQyxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFFLEtBQW1COztRQUMzRCxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBRWpCLE1BQU0sT0FBTyxHQUFHLFdBQUksQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLEdBQUcsQ0FBQyxDQUFDO1FBRXJDLElBQUksS0FBSyxHQUFHLENBQUMsQ0FBQztRQUNkLEtBQUssTUFBTSxHQUFHLElBQUksT0FBTyxFQUFFO1lBQ3pCLE1BQU0sT0FBTyxlQUFHLEdBQUcsQ0FBQyxRQUFRLDBDQUFFLElBQUksbUNBQUksU0FBUyxLQUFLLEVBQUUsRUFBRSxDQUFDO1lBRXpELHdDQUF3QztZQUN4QyxNQUFNLEtBQUssR0FBRyxDQUFDLE9BQU8sUUFBRSxHQUFHLENBQUMsSUFBSSwwQ0FBRSxXQUFXLFVBQUksR0FBRyxDQUFDLFFBQVEsMENBQUUsU0FBUyxDQUFDLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDLEdBQUcsQ0FBQyxDQUFDO1lBQ25HLElBQUksc0JBQVMsQ0FBQyxJQUFJLEVBQUUsS0FBSyxFQUFFLEdBQUcsQ0FBQyxDQUFDO1NBQ2pDO0lBQ0gsQ0FBQzs7Ozs7O0lBR0QsSUFBVyxVQUFVO1FBQ25CLE9BQU8saUJBQUksQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLENBQUMsUUFBUSxDQUFDLE1BQU0sQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsWUFBWSxzQkFBUyxDQUFnQixDQUFDO0lBQ25GLENBQUM7O0FBbkJILDBCQW9CQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IENvbnN0cnVjdCwgTm9kZSB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuaW1wb3J0IHsgQXBpT2JqZWN0IH0gZnJvbSAnLi9hcGktb2JqZWN0JztcbmltcG9ydCB7IFlhbWwgfSBmcm9tICcuL3lhbWwnO1xuXG5leHBvcnQgaW50ZXJmYWNlIEluY2x1ZGVQcm9wcyB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgdXJsOiBzdHJpbmc7XG59XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGNsYXNzIEluY2x1ZGUgZXh0ZW5kcyBDb25zdHJ1Y3Qge1xuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogSW5jbHVkZVByb3BzKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkKTtcblxuICAgIGNvbnN0IG9iamVjdHMgPSBZYW1sLmxvYWQocHJvcHMudXJsKTtcblxuICAgIGxldCBvcmRlciA9IDA7XG4gICAgZm9yIChjb25zdCBvYmogb2Ygb2JqZWN0cykge1xuICAgICAgY29uc3Qgb2JqbmFtZSA9IG9iai5tZXRhZGF0YT8ubmFtZSA/PyBgb2JqZWN0JHtvcmRlcisrfWA7XG5cbiAgICAgIC8vIHJlbmRlciBhbiBpZDogbmFtZVsta2luZF1bLW5hbWVzcGFjZV1cbiAgICAgIGNvbnN0IG9iamlkID0gW29iam5hbWUsIG9iai5raW5kPy50b0xvd2VyQ2FzZSgpLCBvYmoubWV0YWRhdGE/Lm5hbWVzcGFjZV0uZmlsdGVyKHggPT4geCkuam9pbignLScpO1xuICAgICAgbmV3IEFwaU9iamVjdCh0aGlzLCBvYmppZCwgb2JqKTtcbiAgICB9XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBnZXQgYXBpT2JqZWN0cygpOiBBcGlPYmplY3RbXSB7XG4gICAgcmV0dXJuIE5vZGUub2YodGhpcykuY2hpbGRyZW4uZmlsdGVyKG8gPT4gbyBpbnN0YW5jZW9mIEFwaU9iamVjdCkgYXMgQXBpT2JqZWN0W107XG4gIH1cbn1cbiJdfQ==