"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Helm = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs = require("fs");
const os = require("os");
const path = require("path");
const yaml = require("yaml");
const _child_process_1 = require("./_child_process");
const include_1 = require("./include");
const names_1 = require("./names");
const MAX_HELM_BUFFER = 10 * 1024 * 1024;
/**
 * Represents a Helm deployment.
 *
 * Use this construct to import an existing Helm chart and incorporate it into your constructs.
 *
 * @stability stable
 */
class Helm extends include_1.Include {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _b, _c;
        const workdir = fs.mkdtempSync(path.join(os.tmpdir(), 'cdk8s-helm-'));
        const args = new Array();
        args.push('template');
        // values
        if (props.values && Object.keys(props.values).length > 0) {
            const valuesPath = path.join(workdir, 'overrides.yaml');
            fs.writeFileSync(valuesPath, yaml.stringify(props.values));
            args.push('-f', valuesPath);
        }
        // custom flags
        if (props.helmFlags) {
            args.push(...props.helmFlags);
        }
        // release name
        // constraints: https://github.com/helm/helm/issues/6006
        const releaseName = (_b = props.releaseName) !== null && _b !== void 0 ? _b : names_1.Names.toDnsLabel(scope, { maxLen: 53, extra: [id] });
        args.push(releaseName);
        // chart
        args.push(props.chart);
        const prog = (_c = props.helmExecutable) !== null && _c !== void 0 ? _c : 'helm';
        const outputFile = renderTemplate(workdir, prog, args);
        super(scope, id, { url: outputFile });
        this.releaseName = releaseName;
    }
}
exports.Helm = Helm;
_a = JSII_RTTI_SYMBOL_1;
Helm[_a] = { fqn: "cdk8s.Helm", version: "2.1.2" };
function renderTemplate(workdir, prog, args) {
    const helm = _child_process_1._child_process.spawnSync(prog, args, {
        maxBuffer: MAX_HELM_BUFFER,
    });
    if (helm.error) {
        const err = helm.error.message;
        if (err.includes('ENOENT')) {
            throw new Error(`unable to execute '${prog}' to render Helm chart. Is it installed on your system?`);
        }
        throw new Error(`error while rendering a helm chart: ${err}`);
    }
    if (helm.status !== 0) {
        throw new Error(helm.stderr.toString());
    }
    const outputFile = path.join(workdir, 'chart.yaml');
    const stdout = helm.stdout;
    fs.writeFileSync(outputFile, stdout);
    return outputFile;
}
//# sourceMappingURL=data:application/json;base64,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