"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Chart = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const constructs_1 = require("constructs");
const app_1 = require("./app");
const names_1 = require("./names");
/**
 * @stability stable
 */
class Chart extends constructs_1.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props = {}) {
        var _b;
        super(scope, id);
        this.namespace = props.namespace;
        this._labels = (_b = props.labels) !== null && _b !== void 0 ? _b : {};
    }
    /**
     * Finds the chart in which a node is defined.
     *
     * @param c a construct node.
     * @stability stable
     */
    static of(c) {
        if (c instanceof Chart) {
            return c;
        }
        const parent = constructs_1.Node.of(c).scope;
        if (!parent) {
            throw new Error('cannot find a parent chart (directly or indirectly)');
        }
        return Chart.of(parent);
    }
    /**
     * Labels applied to all resources in this chart.
     *
     * This is an immutable copy.
     *
     * @stability stable
     */
    get labels() {
        return { ...this._labels };
    }
    /**
     * Generates a app-unique name for an object given it's construct node path.
     *
     * Different resource types may have different constraints on names
     * (`metadata.name`). The previous version of the name generator was
     * compatible with DNS_SUBDOMAIN but not with DNS_LABEL.
     *
     * For example, `Deployment` names must comply with DNS_SUBDOMAIN while
     * `Service` names must comply with DNS_LABEL.
     *
     * Since there is no formal specification for this, the default name
     * generation scheme for kubernetes objects in cdk8s was changed to DNS_LABEL,
     * since it’s the common denominator for all kubernetes resources
     * (supposedly).
     *
     * You can override this method if you wish to customize object names at the
     * chart level.
     *
     * @param apiObject The API object to generate a name for.
     * @stability stable
     */
    generateObjectName(apiObject) {
        return names_1.Names.toDnsLabel(apiObject);
    }
    /**
     * Create a dependency between this Chart and other constructs.
     *
     * These can be other ApiObjects, Charts, or custom.
     *
     * @param dependencies the dependencies to add.
     * @stability stable
     */
    addDependency(...dependencies) {
        constructs_1.Node.of(this).addDependency(...dependencies);
    }
    /**
     * Renders this chart to a set of Kubernetes JSON resources.
     *
     * @returns array of resource manifests
     * @stability stable
     */
    toJson() {
        return app_1.App._synthChart(this);
    }
}
exports.Chart = Chart;
_a = JSII_RTTI_SYMBOL_1;
Chart[_a] = { fqn: "cdk8s.Chart", version: "2.1.2" };
//# sourceMappingURL=data:application/json;base64,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