"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApiObject = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const constructs_1 = require("constructs");
const _resolve_1 = require("./_resolve");
const _util_1 = require("./_util");
const chart_1 = require("./chart");
const json_patch_1 = require("./json-patch");
const metadata_1 = require("./metadata");
/**
 * @stability stable
 */
class ApiObject extends constructs_1.Construct {
    /**
     * Defines an API object.
     *
     * @param scope the construct scope.
     * @param id namespace.
     * @param props options.
     * @stability stable
     */
    constructor(scope, id, props) {
        var _b, _c, _d, _e, _f;
        super(scope, id);
        this.props = props;
        this.patches = new Array();
        this.chart = chart_1.Chart.of(this);
        this.kind = props.kind;
        this.apiVersion = props.apiVersion;
        this.apiGroup = parseApiGroup(this.apiVersion);
        this.name = (_c = (_b = props.metadata) === null || _b === void 0 ? void 0 : _b.name) !== null && _c !== void 0 ? _c : this.chart.generateObjectName(this);
        this.metadata = new metadata_1.ApiObjectMetadataDefinition({
            name: this.name,
            // user defined values
            ...props.metadata,
            namespace: (_e = (_d = props.metadata) === null || _d === void 0 ? void 0 : _d.namespace) !== null && _e !== void 0 ? _e : this.chart.namespace,
            labels: {
                ...this.chart.labels,
                ...(_f = props.metadata) === null || _f === void 0 ? void 0 : _f.labels,
            },
        });
    }
    /**
     * Returns the `ApiObject` named `Resource` which is a child of the given construct.
     *
     * If `c` is an `ApiObject`, it is returned directly. Throws an
     * exception if the construct does not have a child named `Default` _or_ if
     * this child is not an `ApiObject`.
     *
     * @param c The higher-level construct.
     * @stability stable
     */
    static of(c) {
        if (c instanceof ApiObject) {
            return c;
        }
        const child = constructs_1.Node.of(c).defaultChild;
        if (!child) {
            throw new Error(`cannot find a (direct or indirect) child of type ApiObject for construct ${constructs_1.Node.of(c).path}`);
        }
        return ApiObject.of(child);
    }
    /**
     * Create a dependency between this ApiObject and other constructs.
     *
     * These can be other ApiObjects, Charts, or custom.
     *
     * @param dependencies the dependencies to add.
     * @stability stable
     */
    addDependency(...dependencies) {
        constructs_1.Node.of(this).addDependency(...dependencies);
    }
    /**
     * Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object.
     *
     * @param ops The JSON-Patch operations to apply.
     * @stability stable
     * @example
     *
     *   kubePod.addJsonPatch(JsonPatch.replace('/spec/enableServiceLinks', true));
     */
    addJsonPatch(...ops) {
        this.patches.push(...ops);
    }
    /**
     * Renders the object to Kubernetes JSON.
     *
     * To disable sorting of dictionary keys in output object set the
     * `CDK8S_DISABLE_SORT` environment variable to any non-empty value.
     *
     * @stability stable
     */
    toJson() {
        const data = {
            ...this.props,
            metadata: this.metadata.toJson(),
        };
        const sortKeys = process.env.CDK8S_DISABLE_SORT ? false : true;
        const json = _util_1.sanitizeValue(_resolve_1.resolve(data), { sortKeys });
        const patched = json_patch_1.JsonPatch.apply(json, ...this.patches);
        // reorder top-level keys so that we first have "apiVersion", "kind" and
        // "metadata" and then all the rest
        const result = {};
        const orderedKeys = ['apiVersion', 'kind', 'metadata', ...Object.keys(patched)];
        for (const k of orderedKeys) {
            if (k in patched) {
                result[k] = patched[k];
            }
        }
        return result;
    }
}
exports.ApiObject = ApiObject;
_a = JSII_RTTI_SYMBOL_1;
ApiObject[_a] = { fqn: "cdk8s.ApiObject", version: "2.1.2" };
function parseApiGroup(apiVersion) {
    const v = apiVersion.split('/');
    // no group means "core"
    // https://kubernetes.io/docs/reference/using-api/api-overview/#api-groups
    if (v.length === 1) {
        return 'core';
    }
    if (v.length === 2) {
        return v[0];
    }
    throw new Error(`invalid apiVersion ${apiVersion}, expecting GROUP/VERSION. See https://kubernetes.io/docs/reference/using-api/api-overview/#api-groups`);
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXBpLW9iamVjdC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy9hcGktb2JqZWN0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQUEsMkNBQXlEO0FBQ3pELHlDQUFxQztBQUNyQyxtQ0FBd0M7QUFDeEMsbUNBQWdDO0FBQ2hDLDZDQUF5QztBQUN6Qyx5Q0FBNEU7Ozs7QUEyQjVFLE1BQWEsU0FBVSxTQUFRLHNCQUFTOzs7Ozs7Ozs7SUF1Q3RDLFlBQVksS0FBZ0IsRUFBRSxFQUFVLEVBQW1CLEtBQXFCOztRQUM5RSxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBRHdDLFVBQUssR0FBTCxLQUFLLENBQWdCO1FBRTlFLElBQUksQ0FBQyxPQUFPLEdBQUcsSUFBSSxLQUFLLEVBQWEsQ0FBQztRQUN0QyxJQUFJLENBQUMsS0FBSyxHQUFHLGFBQUssQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLENBQUM7UUFDNUIsSUFBSSxDQUFDLElBQUksR0FBRyxLQUFLLENBQUMsSUFBSSxDQUFDO1FBQ3ZCLElBQUksQ0FBQyxVQUFVLEdBQUcsS0FBSyxDQUFDLFVBQVUsQ0FBQztRQUNuQyxJQUFJLENBQUMsUUFBUSxHQUFHLGFBQWEsQ0FBQyxJQUFJLENBQUMsVUFBVSxDQUFDLENBQUM7UUFFL0MsSUFBSSxDQUFDLElBQUksZUFBRyxLQUFLLENBQUMsUUFBUSwwQ0FBRSxJQUFJLG1DQUFJLElBQUksQ0FBQyxLQUFLLENBQUMsa0JBQWtCLENBQUMsSUFBSSxDQUFDLENBQUM7UUFFeEUsSUFBSSxDQUFDLFFBQVEsR0FBRyxJQUFJLHNDQUEyQixDQUFDO1lBQzlDLElBQUksRUFBRSxJQUFJLENBQUMsSUFBSTtZQUVmLHNCQUFzQjtZQUN0QixHQUFHLEtBQUssQ0FBQyxRQUFRO1lBRWpCLFNBQVMsY0FBRSxLQUFLLENBQUMsUUFBUSwwQ0FBRSxTQUFTLG1DQUFJLElBQUksQ0FBQyxLQUFLLENBQUMsU0FBUztZQUM1RCxNQUFNLEVBQUU7Z0JBQ04sR0FBRyxJQUFJLENBQUMsS0FBSyxDQUFDLE1BQU07Z0JBQ3BCLFNBQUcsS0FBSyxDQUFDLFFBQVEsMENBQUUsTUFBTTthQUMxQjtTQUNGLENBQUMsQ0FBQztJQUNMLENBQUM7Ozs7Ozs7Ozs7O0lBM0RNLE1BQU0sQ0FBQyxFQUFFLENBQUMsQ0FBYTtRQUM1QixJQUFJLENBQUMsWUFBWSxTQUFTLEVBQUU7WUFDMUIsT0FBTyxDQUFDLENBQUM7U0FDVjtRQUVELE1BQU0sS0FBSyxHQUFHLGlCQUFJLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLFlBQVksQ0FBQztRQUN0QyxJQUFJLENBQUMsS0FBSyxFQUFFO1lBQ1YsTUFBTSxJQUFJLEtBQUssQ0FBQyw0RUFBNEUsaUJBQUksQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsSUFBSSxFQUFFLENBQUMsQ0FBQztTQUNoSDtRQUVELE9BQU8sU0FBUyxDQUFDLEVBQUUsQ0FBQyxLQUFLLENBQUMsQ0FBQztJQUM3QixDQUFDOzs7Ozs7Ozs7SUFtRE0sYUFBYSxDQUFDLEdBQUcsWUFBMEI7UUFDaEQsaUJBQUksQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLENBQUMsYUFBYSxDQUFDLEdBQUcsWUFBWSxDQUFDLENBQUM7SUFDL0MsQ0FBQzs7Ozs7Ozs7OztJQUdNLFlBQVksQ0FBQyxHQUFHLEdBQWdCO1FBQ3JDLElBQUksQ0FBQyxPQUFPLENBQUMsSUFBSSxDQUFDLEdBQUcsR0FBRyxDQUFDLENBQUM7SUFDNUIsQ0FBQzs7Ozs7Ozs7O0lBR00sTUFBTTtRQUNYLE1BQU0sSUFBSSxHQUFRO1lBQ2hCLEdBQUcsSUFBSSxDQUFDLEtBQUs7WUFDYixRQUFRLEVBQUUsSUFBSSxDQUFDLFFBQVEsQ0FBQyxNQUFNLEVBQUU7U0FDakMsQ0FBQztRQUVGLE1BQU0sUUFBUSxHQUFHLE9BQU8sQ0FBQyxHQUFHLENBQUMsa0JBQWtCLENBQUMsQ0FBQyxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDO1FBQy9ELE1BQU0sSUFBSSxHQUFHLHFCQUFhLENBQUMsa0JBQU8sQ0FBQyxJQUFJLENBQUMsRUFBRSxFQUFFLFFBQVEsRUFBRSxDQUFDLENBQUM7UUFDeEQsTUFBTSxPQUFPLEdBQUcsc0JBQVMsQ0FBQyxLQUFLLENBQUMsSUFBSSxFQUFFLEdBQUcsSUFBSSxDQUFDLE9BQU8sQ0FBQyxDQUFDO1FBRXZELHdFQUF3RTtRQUN4RSxtQ0FBbUM7UUFDbkMsTUFBTSxNQUFNLEdBQVEsRUFBRSxDQUFDO1FBQ3ZCLE1BQU0sV0FBVyxHQUFHLENBQUMsWUFBWSxFQUFFLE1BQU0sRUFBRSxVQUFVLEVBQUUsR0FBRyxNQUFNLENBQUMsSUFBSSxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUM7UUFDaEYsS0FBSyxNQUFNLENBQUMsSUFBSSxXQUFXLEVBQUU7WUFDM0IsSUFBSSxDQUFDLElBQUksT0FBTyxFQUFFO2dCQUNoQixNQUFNLENBQUMsQ0FBQyxDQUFDLEdBQUcsT0FBTyxDQUFDLENBQUMsQ0FBQyxDQUFDO2FBQ3hCO1NBQ0Y7UUFFRCxPQUFPLE1BQU0sQ0FBQztJQUNoQixDQUFDOztBQS9GSCw4QkFnR0M7OztBQUVELFNBQVMsYUFBYSxDQUFDLFVBQWtCO0lBQ3ZDLE1BQU0sQ0FBQyxHQUFHLFVBQVUsQ0FBQyxLQUFLLENBQUMsR0FBRyxDQUFDLENBQUM7SUFFaEMsd0JBQXdCO0lBQ3hCLDBFQUEwRTtJQUMxRSxJQUFJLENBQUMsQ0FBQyxNQUFNLEtBQUssQ0FBQyxFQUFFO1FBQ2xCLE9BQU8sTUFBTSxDQUFDO0tBQ2Y7SUFFRCxJQUFJLENBQUMsQ0FBQyxNQUFNLEtBQUssQ0FBQyxFQUFFO1FBQ2xCLE9BQU8sQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0tBQ2I7SUFFRCxNQUFNLElBQUksS0FBSyxDQUFDLHNCQUFzQixVQUFVLHdHQUF3RyxDQUFDLENBQUM7QUFDNUosQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IENvbnN0cnVjdCwgSUNvbnN0cnVjdCwgTm9kZSB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuaW1wb3J0IHsgcmVzb2x2ZSB9IGZyb20gJy4vX3Jlc29sdmUnO1xuaW1wb3J0IHsgc2FuaXRpemVWYWx1ZSB9IGZyb20gJy4vX3V0aWwnO1xuaW1wb3J0IHsgQ2hhcnQgfSBmcm9tICcuL2NoYXJ0JztcbmltcG9ydCB7IEpzb25QYXRjaCB9IGZyb20gJy4vanNvbi1wYXRjaCc7XG5pbXBvcnQgeyBBcGlPYmplY3RNZXRhZGF0YSwgQXBpT2JqZWN0TWV0YWRhdGFEZWZpbml0aW9uIH0gZnJvbSAnLi9tZXRhZGF0YSc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgaW50ZXJmYWNlIEFwaU9iamVjdFByb3BzIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgbWV0YWRhdGE/OiBBcGlPYmplY3RNZXRhZGF0YTtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgYXBpVmVyc2lvbjogc3RyaW5nO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGtpbmQ6IHN0cmluZztcblxuICAvKipcbiAgICogQWRkaXRpb25hbCBhdHRyaWJ1dGVzIGZvciB0aGlzIEFQSSBvYmplY3QuXG4gICAqL1xuICByZWFkb25seSBba2V5OiBzdHJpbmddOiBhbnk7XG59XG5cbmV4cG9ydCBpbnRlcmZhY2UgR3JvdXBWZXJzaW9uS2luZCB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBhcGlWZXJzaW9uOiBzdHJpbmc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBraW5kOiBzdHJpbmc7XG59XG5cbmV4cG9ydCBjbGFzcyBBcGlPYmplY3QgZXh0ZW5kcyBDb25zdHJ1Y3Qge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBzdGF0aWMgb2YoYzogSUNvbnN0cnVjdCk6IEFwaU9iamVjdCB7XG4gICAgaWYgKGMgaW5zdGFuY2VvZiBBcGlPYmplY3QpIHtcbiAgICAgIHJldHVybiBjO1xuICAgIH1cblxuICAgIGNvbnN0IGNoaWxkID0gTm9kZS5vZihjKS5kZWZhdWx0Q2hpbGQ7XG4gICAgaWYgKCFjaGlsZCkge1xuICAgICAgdGhyb3cgbmV3IEVycm9yKGBjYW5ub3QgZmluZCBhIChkaXJlY3Qgb3IgaW5kaXJlY3QpIGNoaWxkIG9mIHR5cGUgQXBpT2JqZWN0IGZvciBjb25zdHJ1Y3QgJHtOb2RlLm9mKGMpLnBhdGh9YCk7XG4gICAgfVxuXG4gICAgcmV0dXJuIEFwaU9iamVjdC5vZihjaGlsZCk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyByZWFkb25seSBuYW1lOiBzdHJpbmc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyByZWFkb25seSBhcGlWZXJzaW9uOiBzdHJpbmc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyByZWFkb25seSBhcGlHcm91cDogc3RyaW5nO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHJlYWRvbmx5IGtpbmQ6IHN0cmluZztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHJlYWRvbmx5IGNoYXJ0OiBDaGFydDtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgcmVhZG9ubHkgbWV0YWRhdGE6IEFwaU9iamVjdE1ldGFkYXRhRGVmaW5pdGlvbjtcblxuICAvKipcbiAgICogQSBzZXQgb2YgSlNPTiBwYXRjaCBvcGVyYXRpb25zIHRvIGFwcGx5IHRvIHRoZSBkb2N1bWVudCBhZnRlciBzeW50aGVzaXMuXG4gICAqL1xuICBwcml2YXRlIHJlYWRvbmx5IHBhdGNoZXM6IEFycmF5PEpzb25QYXRjaD47XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJpdmF0ZSByZWFkb25seSBwcm9wczogQXBpT2JqZWN0UHJvcHMpIHtcbiAgICBzdXBlcihzY29wZSwgaWQpO1xuICAgIHRoaXMucGF0Y2hlcyA9IG5ldyBBcnJheTxKc29uUGF0Y2g+KCk7XG4gICAgdGhpcy5jaGFydCA9IENoYXJ0Lm9mKHRoaXMpO1xuICAgIHRoaXMua2luZCA9IHByb3BzLmtpbmQ7XG4gICAgdGhpcy5hcGlWZXJzaW9uID0gcHJvcHMuYXBpVmVyc2lvbjtcbiAgICB0aGlzLmFwaUdyb3VwID0gcGFyc2VBcGlHcm91cCh0aGlzLmFwaVZlcnNpb24pO1xuXG4gICAgdGhpcy5uYW1lID0gcHJvcHMubWV0YWRhdGE/Lm5hbWUgPz8gdGhpcy5jaGFydC5nZW5lcmF0ZU9iamVjdE5hbWUodGhpcyk7XG5cbiAgICB0aGlzLm1ldGFkYXRhID0gbmV3IEFwaU9iamVjdE1ldGFkYXRhRGVmaW5pdGlvbih7XG4gICAgICBuYW1lOiB0aGlzLm5hbWUsXG5cbiAgICAgIC8vIHVzZXIgZGVmaW5lZCB2YWx1ZXNcbiAgICAgIC4uLnByb3BzLm1ldGFkYXRhLFxuXG4gICAgICBuYW1lc3BhY2U6IHByb3BzLm1ldGFkYXRhPy5uYW1lc3BhY2UgPz8gdGhpcy5jaGFydC5uYW1lc3BhY2UsXG4gICAgICBsYWJlbHM6IHtcbiAgICAgICAgLi4udGhpcy5jaGFydC5sYWJlbHMsXG4gICAgICAgIC4uLnByb3BzLm1ldGFkYXRhPy5sYWJlbHMsXG4gICAgICB9LFxuICAgIH0pO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBhZGREZXBlbmRlbmN5KC4uLmRlcGVuZGVuY2llczogSUNvbnN0cnVjdFtdKSB7XG4gICAgTm9kZS5vZih0aGlzKS5hZGREZXBlbmRlbmN5KC4uLmRlcGVuZGVuY2llcyk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgYWRkSnNvblBhdGNoKC4uLm9wczogSnNvblBhdGNoW10pIHtcbiAgICB0aGlzLnBhdGNoZXMucHVzaCguLi5vcHMpO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHRvSnNvbigpOiBhbnkge1xuICAgIGNvbnN0IGRhdGE6IGFueSA9IHtcbiAgICAgIC4uLnRoaXMucHJvcHMsXG4gICAgICBtZXRhZGF0YTogdGhpcy5tZXRhZGF0YS50b0pzb24oKSxcbiAgICB9O1xuXG4gICAgY29uc3Qgc29ydEtleXMgPSBwcm9jZXNzLmVudi5DREs4U19ESVNBQkxFX1NPUlQgPyBmYWxzZSA6IHRydWU7XG4gICAgY29uc3QganNvbiA9IHNhbml0aXplVmFsdWUocmVzb2x2ZShkYXRhKSwgeyBzb3J0S2V5cyB9KTtcbiAgICBjb25zdCBwYXRjaGVkID0gSnNvblBhdGNoLmFwcGx5KGpzb24sIC4uLnRoaXMucGF0Y2hlcyk7XG5cbiAgICAvLyByZW9yZGVyIHRvcC1sZXZlbCBrZXlzIHNvIHRoYXQgd2UgZmlyc3QgaGF2ZSBcImFwaVZlcnNpb25cIiwgXCJraW5kXCIgYW5kXG4gICAgLy8gXCJtZXRhZGF0YVwiIGFuZCB0aGVuIGFsbCB0aGUgcmVzdFxuICAgIGNvbnN0IHJlc3VsdDogYW55ID0ge307XG4gICAgY29uc3Qgb3JkZXJlZEtleXMgPSBbJ2FwaVZlcnNpb24nLCAna2luZCcsICdtZXRhZGF0YScsIC4uLk9iamVjdC5rZXlzKHBhdGNoZWQpXTtcbiAgICBmb3IgKGNvbnN0IGsgb2Ygb3JkZXJlZEtleXMpIHtcbiAgICAgIGlmIChrIGluIHBhdGNoZWQpIHtcbiAgICAgICAgcmVzdWx0W2tdID0gcGF0Y2hlZFtrXTtcbiAgICAgIH1cbiAgICB9XG5cbiAgICByZXR1cm4gcmVzdWx0O1xuICB9XG59XG5cbmZ1bmN0aW9uIHBhcnNlQXBpR3JvdXAoYXBpVmVyc2lvbjogc3RyaW5nKSB7XG4gIGNvbnN0IHYgPSBhcGlWZXJzaW9uLnNwbGl0KCcvJyk7XG5cbiAgLy8gbm8gZ3JvdXAgbWVhbnMgXCJjb3JlXCJcbiAgLy8gaHR0cHM6Ly9rdWJlcm5ldGVzLmlvL2RvY3MvcmVmZXJlbmNlL3VzaW5nLWFwaS9hcGktb3ZlcnZpZXcvI2FwaS1ncm91cHNcbiAgaWYgKHYubGVuZ3RoID09PSAxKSB7XG4gICAgcmV0dXJuICdjb3JlJztcbiAgfVxuXG4gIGlmICh2Lmxlbmd0aCA9PT0gMikge1xuICAgIHJldHVybiB2WzBdO1xuICB9XG5cbiAgdGhyb3cgbmV3IEVycm9yKGBpbnZhbGlkIGFwaVZlcnNpb24gJHthcGlWZXJzaW9ufSwgZXhwZWN0aW5nIEdST1VQL1ZFUlNJT04uIFNlZSBodHRwczovL2t1YmVybmV0ZXMuaW8vZG9jcy9yZWZlcmVuY2UvdXNpbmctYXBpL2FwaS1vdmVydmlldy8jYXBpLWdyb3Vwc2ApO1xufVxuIl19