"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.sanitizeValue = void 0;
function sanitizeValue(obj, options = {}) {
    var _a;
    if (obj == null) {
        return undefined;
    }
    if (typeof (obj) !== 'object') {
        return obj;
    }
    if (Array.isArray(obj)) {
        if (options.filterEmptyArrays && obj.length === 0) {
            return undefined;
        }
        return obj.map(x => sanitizeValue(x, options));
    }
    if (obj.constructor.name !== 'Object') {
        throw new Error(`can't render non-simple object of type '${obj.constructor.name}'`);
    }
    const newObj = {};
    const sortKeys = (_a = options.sortKeys) !== null && _a !== void 0 ? _a : true;
    const keys = sortKeys ? Object.keys(obj).sort() : Object.keys(obj);
    for (const key of keys) {
        const value = obj[key];
        const newValue = sanitizeValue(value, options);
        if (newValue != null) {
            newObj[key] = newValue;
        }
    }
    if (options.filterEmptyObjects && Object.keys(newObj).length === 0) {
        return undefined;
    }
    return newObj;
}
exports.sanitizeValue = sanitizeValue;
//# sourceMappingURL=data:application/json;base64,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