from django.conf import settings
from django.core.cache import cache as default_cache

cache = default_cache
DEFAULT_TIMEOUT = 60 * 60 * 24
DEFAULT_DOWNLOAD_TEMPLATE = "async_downloads/downloads.html"
DEFAULT_PATH_PREFIX = "downloads"
DEFAULT_COLLECTION_KEY_FORMAT = "async_downloads/{}"
DEFAULT_IN_MEMORY_MAX_SIZE_BYTES = 5 * 1e6  # Default of 5MB
DEFAULT_WS_MODE = False
DEFAULT_CACHE_NAME = ''
DEFAULT_CSS_CLASS = None
DEFAULT_WS_CHANNEL_NAME = "downloads"

TIMEOUT = getattr(settings, "ASYNC_DOWNLOADS_TIMEOUT", DEFAULT_TIMEOUT)
DOWNLOAD_TEMPLATE = getattr(settings, "ASYNC_DOWNLOADS_DOWNLOAD_TEMPLATE", DEFAULT_DOWNLOAD_TEMPLATE)
PATH_PREFIX = getattr(settings, "ASYNC_DOWNLOADS_PATH_PREFIX", DEFAULT_PATH_PREFIX)
COLLECTION_KEY_FORMAT = getattr(settings, "ASYNC_DOWNLOADS_COLLECTION_KEY_FORMAT", DEFAULT_COLLECTION_KEY_FORMAT)
IN_MEMORY_MAX_SIZE_BYTES = getattr(settings, "ASYNC_DOWNLOADS_IN_MEMORY_MAX_SIZE_BYTES", DEFAULT_IN_MEMORY_MAX_SIZE_BYTES)
WS_MODE = getattr(settings, "ASYNC_DOWNLOADS_WS_MODE", DEFAULT_WS_MODE)
CACHE_NAME = getattr(settings, "ASYNC_DOWNLOADS_CACHE_NAME", DEFAULT_CACHE_NAME)
CSS_CLASS = getattr(settings, "ASYNC_DOWNLOADS_CSS_CLASS", DEFAULT_CSS_CLASS)
WS_CHANNEL_NAME = getattr(settings, "ASYNC_DOWNLOADS_WS_CHANNEL_NAME", DEFAULT_WS_CHANNEL_NAME)

if CACHE_NAME != DEFAULT_CACHE_NAME:
    from django.core.cache import caches
    cache = caches[CACHE_NAME]

# WS DEFINITIONS
EVENT_TYPE_REFRESH_DOWNLOADS = 'refreshDownloads'
EVENT_TYPE_UPDATE_DOWNLOAD = 'updateDownload'
EVENT_TYPE_INIT_DOWNLOAD = 'initDownload'
EVENT_TYPE_REMOVE_DOWNLOAD = 'removeDownload'
EVENT_TYPE_INIT_ALL_DOWNLOADS = 'initAllDownloads'

USE_WS = False
if WS_MODE:
    USE_WS = True
