from __future__ import annotations

from typing import Any
from typing import Callable
from typing import Dict
from typing import List
from typing import Optional
from typing import Tuple
from typing import Union

from collections.abc import Iterator

from gi.repository import Gio
from gi.repository import GLib
from gi.repository import GObject

COOKIE_MAX_AGE_ONE_DAY: int = ...
COOKIE_MAX_AGE_ONE_HOUR: int = ...
COOKIE_MAX_AGE_ONE_WEEK: int = ...
COOKIE_MAX_AGE_ONE_YEAR: int = ...
FORM_MIME_TYPE_MULTIPART: str = ...
FORM_MIME_TYPE_URLENCODED: str = ...
HSTS_POLICY_MAX_AGE_PAST: int = ...
HTTP_URI_FLAGS: int = ...
MAJOR_VERSION: int = ...
MICRO_VERSION: int = ...
MINOR_VERSION: int = ...
VERSION_MIN_REQUIRED: int = ...
_namespace: str = ...
_version: str = ...

def check_version(major: int, minor: int, micro: int) -> bool: ...
def cookie_parse(header: str, origin: Optional[GLib.Uri]) -> Cookie: ...
def cookies_from_request(msg: Message) -> List[Cookie]: ...
def cookies_from_response(msg: Message) -> List[Cookie]: ...
def cookies_to_cookie_header(cookies: List[Cookie]) -> str: ...
def cookies_to_request(cookies: List[Cookie], msg: Message) -> None: ...
def cookies_to_response(cookies: List[Cookie], msg: Message) -> None: ...
def date_time_new_from_http_string(date_string: str) -> GLib.DateTime: ...
def date_time_to_string(date: GLib.DateTime, format: DateFormat) -> str: ...
def form_decode(encoded_form: str) -> Dict[str, str]: ...
def form_decode_multipart(
    multipart: Multipart, file_control_name: Optional[str]
) -> Tuple[Optional[Dict[str, str]], str, str, GLib.Bytes]: ...
def form_encode_datalist(form_data_set: GLib.Data) -> str: ...
def form_encode_hash(form_data_set: Dict[str, str]) -> str: ...
def get_major_version() -> int: ...
def get_micro_version() -> int: ...
def get_minor_version() -> int: ...
def header_contains(header: str, token: str) -> bool: ...
def header_free_param_list(param_list: Dict[str, str]) -> None: ...
def header_g_string_append_param(
    string: GLib.String, name: str, value: Optional[str]
) -> None: ...
def header_g_string_append_param_quoted(
    string: GLib.String, name: str, value: Optional[str]
) -> None: ...
def header_parse_list(header: str) -> List[str]: ...
def header_parse_param_list(header: str) -> Dict[str, str]: ...
def header_parse_param_list_strict(header: str) -> Dict[str, str]: ...
def header_parse_quality_list(header: str) -> Tuple[List[str], List[str]]: ...
def header_parse_semi_param_list(header: str) -> Dict[str, str]: ...
def header_parse_semi_param_list_strict(header: str) -> Dict[str, str]: ...
def headers_parse(str: str, len: int, dest: MessageHeaders) -> bool: ...
def headers_parse_request(
    str: str, len: int, req_headers: MessageHeaders
) -> Tuple[int, str, str, HTTPVersion]: ...
def headers_parse_response(
    str: str, len: int, headers: MessageHeaders
) -> Tuple[bool, HTTPVersion, int, str]: ...
def headers_parse_status_line(
    status_line: str,
) -> Tuple[bool, HTTPVersion, int, str]: ...
def message_headers_iter_init(hdrs: MessageHeaders) -> Iterator[MessageHeaders]: ...
def session_error_quark() -> int: ...
def status_get_phrase(status_code: int) -> str: ...
def tld_domain_is_public_suffix(domain: str) -> bool: ...
def tld_error_quark() -> int: ...
def tld_get_base_domain(hostname: str) -> str: ...
def uri_decode_data_uri(uri: str) -> Tuple[GLib.Bytes, Optional[str]]: ...
def uri_equal(uri1: GLib.Uri, uri2: GLib.Uri) -> bool: ...
def websocket_client_prepare_handshake(
    msg: Message,
    origin: Optional[str],
    protocols: Optional[List[str]],
    supported_extensions: Optional[List[Any]],
) -> None: ...
def websocket_client_verify_handshake(
    msg: Message, supported_extensions: Optional[List[Any]]
) -> Tuple[bool, List[WebsocketExtension]]: ...
def websocket_error_quark() -> int: ...
def websocket_server_check_handshake(
    msg: ServerMessage,
    origin: Optional[str],
    protocols: Optional[List[str]],
    supported_extensions: Optional[List[Any]],
) -> bool: ...
def websocket_server_process_handshake(
    msg: ServerMessage,
    expected_origin: Optional[str],
    protocols: Optional[List[str]],
    supported_extensions: Optional[List[Any]],
) -> Tuple[bool, List[WebsocketExtension]]: ...

class Auth:
    parent_instance = ...

    def authenticate(*args, **kwargs): ...
    def can_authenticate(*args, **kwargs): ...
    def cancel(*args, **kwargs): ...
    def get_authority(*args, **kwargs): ...
    def get_authorization(*args, **kwargs): ...
    def get_info(*args, **kwargs): ...
    def get_protection_space(*args, **kwargs): ...
    def get_realm(*args, **kwargs): ...
    def get_scheme_name(*args, **kwargs): ...
    def is_authenticated(*args, **kwargs): ...
    def is_cancelled(*args, **kwargs): ...
    def is_for_proxy(*args, **kwargs): ...
    def is_ready(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def update(*args, **kwargs): ...
    def do_authenticate(self, *args, **kwargs): ...
    def do_can_authenticate(self, *args, **kwargs): ...
    def do_get_authorization(self, *args, **kwargs): ...
    def do_get_protection_space(self, *args, **kwargs): ...
    def do_is_authenticated(self, *args, **kwargs): ...
    def do_is_ready(self, *args, **kwargs): ...
    def do_update(self, *args, **kwargs): ...

class AuthBasic: ...
class AuthDigest: ...

class AuthDomain:
    parent_instance = ...

    def accepts(*args, **kwargs): ...
    def add_path(*args, **kwargs): ...
    def challenge(*args, **kwargs): ...
    def check_password(*args, **kwargs): ...
    def covers(*args, **kwargs): ...
    def get_realm(*args, **kwargs): ...
    def remove_path(*args, **kwargs): ...
    def set_filter(*args, **kwargs): ...
    def set_generic_auth_callback(*args, **kwargs): ...
    def do_accepts(self, *args, **kwargs): ...
    def do_challenge(self, *args, **kwargs): ...
    def do_check_password(self, *args, **kwargs): ...

class AuthDomainBasic:
    def set_auth_callback(*args, **kwargs): ...

class AuthDomainDigest:
    def encode_password(*args, **kwargs): ...
    def set_auth_callback(*args, **kwargs): ...

class AuthManager:
    def clear_cached_credentials(*args, **kwargs): ...
    def use_auth(*args, **kwargs): ...

class AuthNTLM: ...

class AuthNegotiate:
    def supported(*args, **kwargs): ...

class Cache:
    parent_instance = ...

    def clear(*args, **kwargs): ...
    def dump(*args, **kwargs): ...
    def flush(*args, **kwargs): ...
    def get_max_size(*args, **kwargs): ...
    def load(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def set_max_size(*args, **kwargs): ...
    def do_get_cacheability(self, *args, **kwargs): ...

class ContentDecoder: ...

class ContentSniffer:
    def new(*args, **kwargs): ...
    def sniff(*args, **kwargs): ...

class Cookie:
    def applies_to_uri(*args, **kwargs): ...
    def domain_matches(*args, **kwargs): ...
    def equal(*args, **kwargs): ...
    def free(*args, **kwargs): ...
    def get_domain(*args, **kwargs): ...
    def get_expires(*args, **kwargs): ...
    def get_http_only(*args, **kwargs): ...
    def get_name(*args, **kwargs): ...
    def get_path(*args, **kwargs): ...
    def get_same_site_policy(*args, **kwargs): ...
    def get_secure(*args, **kwargs): ...
    def get_value(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def parse(*args, **kwargs): ...
    def set_domain(*args, **kwargs): ...
    def set_expires(*args, **kwargs): ...
    def set_http_only(*args, **kwargs): ...
    def set_max_age(*args, **kwargs): ...
    def set_name(*args, **kwargs): ...
    def set_path(*args, **kwargs): ...
    def set_same_site_policy(*args, **kwargs): ...
    def set_secure(*args, **kwargs): ...
    def set_value(*args, **kwargs): ...
    def to_cookie_header(*args, **kwargs): ...
    def to_set_cookie_header(*args, **kwargs): ...

class CookieJar:
    parent_instance = ...

    def add_cookie(*args, **kwargs): ...
    def add_cookie_full(*args, **kwargs): ...
    def add_cookie_with_first_party(*args, **kwargs): ...
    def all_cookies(*args, **kwargs): ...
    def delete_cookie(*args, **kwargs): ...
    def get_accept_policy(*args, **kwargs): ...
    def get_cookie_list(*args, **kwargs): ...
    def get_cookie_list_with_same_site_info(*args, **kwargs): ...
    def get_cookies(*args, **kwargs): ...
    def is_persistent(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def set_accept_policy(*args, **kwargs): ...
    def set_cookie(*args, **kwargs): ...
    def set_cookie_with_first_party(*args, **kwargs): ...
    def do_changed(self, *args, **kwargs): ...
    def do_is_persistent(self, *args, **kwargs): ...
    def do_save(self, *args, **kwargs): ...

class CookieJarDB: ...
class CookieJarText: ...

class HSTSEnforcer:
    parent_instance = ...

    def get_domains(*args, **kwargs): ...
    def get_policies(*args, **kwargs): ...
    def has_valid_policy(*args, **kwargs): ...
    def is_persistent(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def set_policy(*args, **kwargs): ...
    def set_session_policy(*args, **kwargs): ...
    def do_changed(self, *args, **kwargs): ...
    def do_has_valid_policy(self, *args, **kwargs): ...
    def do_is_persistent(self, *args, **kwargs): ...

class HSTSEnforcerDB: ...

class HSTSPolicy:
    def equal(*args, **kwargs): ...
    def free(*args, **kwargs): ...
    def get_domain(*args, **kwargs): ...
    def get_expires(*args, **kwargs): ...
    def get_max_age(*args, **kwargs): ...
    def includes_subdomains(*args, **kwargs): ...
    def is_expired(*args, **kwargs): ...
    def is_session_policy(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def new_from_response(*args, **kwargs): ...
    def new_full(*args, **kwargs): ...
    def new_session_policy(*args, **kwargs): ...

class Logger:
    def get_max_body_size(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def set_max_body_size(*args, **kwargs): ...
    def set_printer(*args, **kwargs): ...
    def set_request_filter(*args, **kwargs): ...
    def set_response_filter(*args, **kwargs): ...

class Message(GObject.Object):
    @classmethod
    def new(cls, method: str, uri_string: str) -> Message: ...
    @classmethod
    def new_from_encoded_form(
        cls, method: str, uri_string: str, encoded_form: str
    ) -> Message: ...
    @classmethod
    def new_from_multipart(cls, uri_string: str, multipart: Multipart) -> Message: ...
    @classmethod
    def new_from_uri(cls, method: str, uri: GLib.Uri) -> Message: ...
    @classmethod
    def new_options_ping(cls, base_uri: GLib.Uri) -> Message: ...
    def add_flags(self, flags: MessageFlags) -> None: ...
    def disable_feature(self, feature_type: Any) -> None: ...
    def get_connection_id(self) -> int: ...
    def get_first_party(self) -> GLib.Uri: ...
    def get_flags(self) -> MessageFlags: ...
    def get_http_version(self) -> HTTPVersion: ...
    def get_is_options_ping(self) -> bool: ...
    def get_is_top_level_navigation(self) -> bool: ...
    def get_method(self) -> str: ...
    def get_metrics(self) -> Optional[MessageMetrics]: ...
    def get_priority(self) -> MessagePriority: ...
    def get_reason_phrase(self) -> Optional[str]: ...
    def get_remote_address(self) -> Optional[Gio.SocketAddress]: ...
    def get_request_headers(self) -> MessageHeaders: ...
    def get_response_headers(self) -> MessageHeaders: ...
    def get_site_for_cookies(self) -> GLib.Uri: ...
    def get_status(self) -> Status: ...
    def get_tls_ciphersuite_name(self) -> str: ...
    def get_tls_peer_certificate(self) -> Gio.TlsCertificate: ...
    def get_tls_peer_certificate_errors(self) -> Gio.TlsCertificateFlags: ...
    def get_tls_protocol_version(self) -> Gio.TlsProtocolVersion: ...
    def get_uri(self) -> GLib.Uri: ...
    def is_feature_disabled(self, feature_type: Any) -> bool: ...
    def is_keepalive(self) -> bool: ...
    def query_flags(self, flags: MessageFlags) -> bool: ...
    def remove_flags(self, flags: MessageFlags) -> None: ...
    def set_first_party(self, first_party: GLib.Uri) -> None: ...
    def set_flags(self, flags: MessageFlags) -> None: ...
    def set_is_options_ping(self, is_options_ping: bool) -> None: ...
    def set_is_top_level_navigation(self, is_top_level_navigation: bool) -> None: ...
    def set_method(self, method: str) -> None: ...
    def set_priority(self, priority: MessagePriority) -> None: ...
    def set_request_body(
        self,
        content_type: Optional[str],
        stream: Optional[Gio.InputStream],
        content_length: int,
    ) -> None: ...
    def set_request_body_from_bytes(
        self, content_type: Optional[str], bytes: Optional[GLib.Bytes]
    ) -> None: ...
    def set_site_for_cookies(self, site_for_cookies: Optional[GLib.Uri]) -> None: ...
    def set_tls_client_certificate(
        self, certificate: Optional[Gio.TlsCertificate]
    ) -> None: ...
    def set_uri(self, uri: GLib.Uri) -> None: ...
    def tls_client_certificate_password_request_complete(self) -> None: ...

class MessageBody:
    data = ...
    length = ...

    def append(*args, **kwargs): ...
    def append_bytes(*args, **kwargs): ...
    def complete(*args, **kwargs): ...
    def flatten(*args, **kwargs): ...
    def get_accumulate(*args, **kwargs): ...
    def get_chunk(*args, **kwargs): ...
    def got_chunk(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def ref(*args, **kwargs): ...
    def set_accumulate(*args, **kwargs): ...
    def truncate(*args, **kwargs): ...
    def unref(*args, **kwargs): ...
    def wrote_chunk(*args, **kwargs): ...

class MessageHeaders:
    def append(self, name: str, value: str) -> None: ...
    def clean_connection_headers(self) -> None: ...
    def clear(self) -> None: ...
    def foreach(self, func: Callable[[str, str], Any], *user_data: Optional[Any]): ...
    def free_ranges(self, ranges: List[Range]) -> None: ...
    def get_content_disposition(self) -> Tuple[bool, str, Optional[Dict[str, str]]]: ...
    def get_content_length(self) -> int: ...
    def get_content_range(self) -> Tuple[bool, int, int, int]: ...
    def get_content_type(self) -> Tuple[Optional[str], Optional[Dict[str, str]]]: ...
    def get_encoding(self) -> Encoding: ...
    def get_expectations(self) -> Expectation: ...
    def get_headers_type(self) -> MessageHeadersType: ...
    def get_list(self, name: str) -> Optional[str]: ...
    def get_one(self, name: str) -> Optional[str]: ...
    def get_ranges(self, total_length: int) -> Tuple[bool, List[Range]]: ...
    def header_contains(self, name: str, token: str) -> bool: ...
    def header_equals(self, name: str, value: str) -> bool: ...
    @classmethod
    def new(cls, type: MessageHeadersType) -> MessageHeaders: ...
    def ref(self) -> MessageHeaders: ...
    def remove(self, name: str) -> None: ...
    def replace(self, name: str, value: str) -> None: ...
    def set_content_disposition(
        self, disposition: str, params: Optional[Dict[str, str]]
    ) -> None: ...
    def set_content_length(self, content_length: int) -> None: ...
    def set_content_range(self, start: int, end: int, total_length: int) -> None: ...
    def set_content_type(
        self, content_type: str, params: Optional[Dict[str, str]]
    ) -> None: ...
    def set_encoding(self, encoding: Encoding) -> None: ...
    def set_expectations(self, expectation: Expectation) -> None: ...
    def set_range(self, start: int, end: int) -> None: ...
    def set_ranges(self, ranges: List[Range], length: int) -> None: ...
    def unref(self) -> None: ...

class MessageHeadersIter:
    dummy = ...

    def init(*args, **kwargs): ...
    def next(*args, **kwargs): ...

class MessageMetrics:
    def free(*args, **kwargs): ...
    def get_connect_end(*args, **kwargs): ...
    def get_connect_start(*args, **kwargs): ...
    def get_dns_end(*args, **kwargs): ...
    def get_dns_start(*args, **kwargs): ...
    def get_fetch_start(*args, **kwargs): ...
    def get_request_body_bytes_sent(*args, **kwargs): ...
    def get_request_body_size(*args, **kwargs): ...
    def get_request_header_bytes_sent(*args, **kwargs): ...
    def get_request_start(*args, **kwargs): ...
    def get_response_body_bytes_received(*args, **kwargs): ...
    def get_response_body_size(*args, **kwargs): ...
    def get_response_end(*args, **kwargs): ...
    def get_response_header_bytes_received(*args, **kwargs): ...
    def get_response_start(*args, **kwargs): ...
    def get_tls_start(*args, **kwargs): ...

class Multipart:
    def append_form_file(*args, **kwargs): ...
    def append_form_string(*args, **kwargs): ...
    def append_part(*args, **kwargs): ...
    def free(*args, **kwargs): ...
    def get_length(*args, **kwargs): ...
    def get_part(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def new_from_message(*args, **kwargs): ...
    def to_message(*args, **kwargs): ...

class MultipartInputStream:
    def get_headers(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def next_part(*args, **kwargs): ...
    def next_part_async(*args, **kwargs): ...
    def next_part_finish(*args, **kwargs): ...

class Range:
    end = ...
    start = ...

class Server:
    parent_instance = ...

    def accept_iostream(*args, **kwargs): ...
    def add_auth_domain(*args, **kwargs): ...
    def add_early_handler(*args, **kwargs): ...
    def add_handler(*args, **kwargs): ...
    def add_websocket_extension(*args, **kwargs): ...
    def add_websocket_handler(*args, **kwargs): ...
    def get_listeners(*args, **kwargs): ...
    def get_tls_auth_mode(*args, **kwargs): ...
    def get_tls_certificate(*args, **kwargs): ...
    def get_tls_database(*args, **kwargs): ...
    def get_uris(*args, **kwargs): ...
    def is_https(*args, **kwargs): ...
    def listen(*args, **kwargs): ...
    def listen_all(*args, **kwargs): ...
    def listen_local(*args, **kwargs): ...
    def listen_socket(*args, **kwargs): ...
    def pause_message(*args, **kwargs): ...
    def remove_auth_domain(*args, **kwargs): ...
    def remove_handler(*args, **kwargs): ...
    def remove_websocket_extension(*args, **kwargs): ...
    def set_tls_auth_mode(*args, **kwargs): ...
    def set_tls_certificate(*args, **kwargs): ...
    def set_tls_database(*args, **kwargs): ...
    def unpause_message(*args, **kwargs): ...
    def do_request_aborted(self, *args, **kwargs): ...
    def do_request_finished(self, *args, **kwargs): ...
    def do_request_read(self, *args, **kwargs): ...
    def do_request_started(self, *args, **kwargs): ...

class ServerMessage:
    def get_http_version(*args, **kwargs): ...
    def get_local_address(*args, **kwargs): ...
    def get_method(*args, **kwargs): ...
    def get_reason_phrase(*args, **kwargs): ...
    def get_remote_address(*args, **kwargs): ...
    def get_remote_host(*args, **kwargs): ...
    def get_request_body(*args, **kwargs): ...
    def get_request_headers(*args, **kwargs): ...
    def get_response_body(*args, **kwargs): ...
    def get_response_headers(*args, **kwargs): ...
    def get_socket(*args, **kwargs): ...
    def get_status(*args, **kwargs): ...
    def get_uri(*args, **kwargs): ...
    def is_options_ping(*args, **kwargs): ...
    def set_http_version(*args, **kwargs): ...
    def set_redirect(*args, **kwargs): ...
    def set_response(*args, **kwargs): ...
    def set_status(*args, **kwargs): ...
    def steal_connection(*args, **kwargs): ...

class Session:
    parent_instance = ...

    def abort(self) -> None: ...
    def add_feature(self, feature: SessionFeature) -> None: ...
    def add_feature_by_type(self, feature_type: Any) -> None: ...
    def get_accept_language(self) -> Optional[str]: ...
    def get_accept_language_auto(self) -> bool: ...
    def get_async_result_message(*args, **kwargs): ...
    def get_feature(self, feature_type: Any) -> Optional[SessionFeature]: ...
    def get_feature_for_message(
        self, feature_type: Any, msg: Message
    ) -> Optional[SessionFeature]: ...
    def get_idle_timeout(self) -> int: ...
    def get_local_address(self) -> Optional[Gio.InetSocketAddress]: ...
    def get_max_conns(self) -> int: ...
    def get_max_conns_per_host(self) -> int: ...
    def get_proxy_resolver(self) -> Optional[Gio.ProxyResolver]: ...
    def get_remote_connectable(self) -> Optional[Gio.SocketConnectable]: ...
    def get_timeout(self) -> int: ...
    def get_tls_database(self) -> Optional[Gio.TlsDatabase]: ...
    def get_tls_interaction(self) -> Optional[Gio.TlsInteraction]: ...
    def get_user_agent(self) -> Optional[None]: ...
    def has_feature(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def preconnect_async(*args, **kwargs): ...
    def preconnect_finish(*args, **kwargs): ...
    def remove_feature(*args, **kwargs): ...
    def remove_feature_by_type(*args, **kwargs): ...
    def send(*args, **kwargs): ...
    def send_and_read(*args, **kwargs): ...
    def send_and_read_async(*args, **kwargs): ...
    def send_and_read_finish(*args, **kwargs): ...
    def send_async(
        self,
        msg: Message,
        io_priority: int,
        cancellable: Optional[Gio.Cancellable] = ...,
        callback: Optional[
            Union[Gio.AsyncReadyCallbackU, Gio.AsyncReadyCallback]
        ] = ...,
        *user_data: Optional[Any],
    ) -> None: ...
    def send_finish(self, result: Gio.AsyncResult) -> Gio.InputStream: ...
    def set_accept_language(self, accept_language: str) -> None: ...
    def set_accept_language_auto(self, accept_language_auto: bool) -> None: ...
    def set_idle_timeout(self, timeout: int) -> None: ...
    def set_proxy_resolver(
        self, proxy_resolver: Optional[Gio.ProxyResolver]
    ) -> None: ...
    def set_timeout(self, timeout: int) -> None: ...
    def set_tls_database(self, database: Optional[Gio.TlsDatabase]) -> None: ...
    def set_tls_interaction(
        self, interaction: Optional[Gio.TlsInteraction]
    ) -> None: ...
    def set_user_agent(self, user_agent: str) -> None: ...
    def websocket_connect_async(*args, **kwargs): ...
    def websocket_connect_finish(*args, **kwargs): ...
    def do_request_queued(self, *args, **kwargs): ...
    def do_request_unqueued(self, *args, **kwargs): ...

class SessionFeature: ...
class SessionFeatureInterface: ...

class WebsocketConnection:
    def close(*args, **kwargs): ...
    def get_close_code(*args, **kwargs): ...
    def get_close_data(*args, **kwargs): ...
    def get_connection_type(*args, **kwargs): ...
    def get_extensions(*args, **kwargs): ...
    def get_io_stream(*args, **kwargs): ...
    def get_keepalive_interval(*args, **kwargs): ...
    def get_max_incoming_payload_size(*args, **kwargs): ...
    def get_origin(*args, **kwargs): ...
    def get_protocol(*args, **kwargs): ...
    def get_state(*args, **kwargs): ...
    def get_uri(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def send_binary(*args, **kwargs): ...
    def send_message(*args, **kwargs): ...
    def send_text(*args, **kwargs): ...
    def set_keepalive_interval(*args, **kwargs): ...
    def set_max_incoming_payload_size(*args, **kwargs): ...

class WebsocketExtension:
    parent_instance = ...

    def configure(*args, **kwargs): ...
    def get_request_params(*args, **kwargs): ...
    def get_response_params(*args, **kwargs): ...
    def process_incoming_message(*args, **kwargs): ...
    def process_outgoing_message(*args, **kwargs): ...
    def do_configure(self, *args, **kwargs): ...
    def do_get_request_params(self, *args, **kwargs): ...
    def do_get_response_params(self, *args, **kwargs): ...
    def do_process_incoming_message(self, *args, **kwargs): ...
    def do_process_outgoing_message(self, *args, **kwargs): ...

class WebsocketExtensionDeflate: ...
class WebsocketExtensionManager: ...

class Cacheability(GObject.GFlags):
    CACHEABLE = ...
    INVALIDATES = ...
    UNCACHEABLE = ...
    VALIDATES = ...

class Expectation(GObject.GFlags):
    CONTINUE = ...
    UNRECOGNIZED = ...

class MessageFlags(GObject.GFlags):
    COLLECT_METRICS = ...
    DO_NOT_USE_AUTH_CACHE = ...
    IDEMPOTENT = ...
    NEW_CONNECTION = ...
    NO_REDIRECT = ...

class ServerListenOptions(GObject.GFlags):
    HTTPS = ...
    IPV4_ONLY = ...
    IPV6_ONLY = ...

class CacheType(GObject.GEnum):
    SHARED = ...
    SINGLE_USER = ...

class CookieJarAcceptPolicy(GObject.GEnum):
    ALWAYS = ...
    GRANDFATHERED_THIRD_PARTY = ...
    NEVER = ...
    NO_THIRD_PARTY = ...

class DateFormat(GObject.GEnum):
    COOKIE = ...
    HTTP = ...

class Encoding(GObject.GEnum):
    BYTERANGES = ...
    CHUNKED = ...
    CONTENT_LENGTH = ...
    EOF = ...
    NONE = ...
    UNRECOGNIZED = ...

class HTTPVersion(GObject.GEnum):
    HTTP_1_0 = ...
    HTTP_1_1 = ...
    HTTP_2_0 = ...

class LoggerLogLevel(GObject.GEnum):
    BODY = ...
    HEADERS = ...
    MINIMAL = ...
    NONE = ...

class MemoryUse(GObject.GEnum):
    COPY = ...
    STATIC = ...
    TAKE = ...

class MessageHeadersType(GObject.GEnum):
    MULTIPART = ...
    REQUEST = ...
    RESPONSE = ...

class MessagePriority(GObject.GEnum):
    HIGH = ...
    LOW = ...
    NORMAL = ...
    VERY_HIGH = ...
    VERY_LOW = ...

class SameSitePolicy(GObject.GEnum):
    LAX = ...
    NONE = ...
    STRICT = ...

class SessionError(GObject.GEnum):
    ENCODING = ...
    MESSAGE_ALREADY_IN_QUEUE = ...
    PARSING = ...
    REDIRECT_BAD_URI = ...
    REDIRECT_NO_LOCATION = ...
    TOO_MANY_REDIRECTS = ...
    TOO_MANY_RESTARTS = ...
    quark = ...

class Status(GObject.GEnum):
    ACCEPTED = ...
    BAD_GATEWAY = ...
    BAD_REQUEST = ...
    CONFLICT = ...
    CONTINUE = ...
    CREATED = ...
    EXPECTATION_FAILED = ...
    FAILED_DEPENDENCY = ...
    FORBIDDEN = ...
    FOUND = ...
    GATEWAY_TIMEOUT = ...
    GONE = ...
    HTTP_VERSION_NOT_SUPPORTED = ...
    INSUFFICIENT_STORAGE = ...
    INTERNAL_SERVER_ERROR = ...
    INVALID_RANGE = ...
    LENGTH_REQUIRED = ...
    LOCKED = ...
    METHOD_NOT_ALLOWED = ...
    MISDIRECTED_REQUEST = ...
    MOVED_PERMANENTLY = ...
    MOVED_TEMPORARILY = ...
    MULTIPLE_CHOICES = ...
    MULTI_STATUS = ...
    NONE = ...
    NON_AUTHORITATIVE = ...
    NOT_ACCEPTABLE = ...
    NOT_APPEARING_IN_THIS_PROTOCOL = ...
    NOT_EXTENDED = ...
    NOT_FOUND = ...
    NOT_IMPLEMENTED = ...
    NOT_MODIFIED = ...
    NO_CONTENT = ...
    OK = ...
    PARTIAL_CONTENT = ...
    PAYMENT_REQUIRED = ...
    PERMANENT_REDIRECT = ...
    PRECONDITION_FAILED = ...
    PROCESSING = ...
    PROXY_AUTHENTICATION_REQUIRED = ...
    PROXY_UNAUTHORIZED = ...
    REQUESTED_RANGE_NOT_SATISFIABLE = ...
    REQUEST_ENTITY_TOO_LARGE = ...
    REQUEST_TIMEOUT = ...
    REQUEST_URI_TOO_LONG = ...
    RESET_CONTENT = ...
    SEE_OTHER = ...
    SERVICE_UNAVAILABLE = ...
    SWITCHING_PROTOCOLS = ...
    TEMPORARY_REDIRECT = ...
    UNAUTHORIZED = ...
    UNPROCESSABLE_ENTITY = ...
    UNSUPPORTED_MEDIA_TYPE = ...
    USE_PROXY = ...
    get_phrase = ...

class TLDError(GObject.GEnum):
    INVALID_HOSTNAME = ...
    IS_IP_ADDRESS = ...
    NOT_ENOUGH_DOMAINS = ...
    NO_BASE_DOMAIN = ...
    NO_PSL_DATA = ...
    quark = ...

class URIComponent(GObject.GEnum):
    AUTH_PARAMS = ...
    FRAGMENT = ...
    HOST = ...
    NONE = ...
    PASSWORD = ...
    PATH = ...
    PORT = ...
    QUERY = ...
    SCHEME = ...
    USER = ...

class WebsocketCloseCode(GObject.GEnum):
    ABNORMAL = ...
    BAD_DATA = ...
    GOING_AWAY = ...
    NORMAL = ...
    NO_EXTENSION = ...
    NO_STATUS = ...
    POLICY_VIOLATION = ...
    PROTOCOL_ERROR = ...
    SERVER_ERROR = ...
    TLS_HANDSHAKE = ...
    TOO_BIG = ...
    UNSUPPORTED_DATA = ...

class WebsocketConnectionType(GObject.GEnum):
    CLIENT = ...
    SERVER = ...
    UNKNOWN = ...

class WebsocketDataType(GObject.GEnum):
    BINARY = ...
    TEXT = ...

class WebsocketError(GObject.GEnum):
    BAD_HANDSHAKE = ...
    BAD_ORIGIN = ...
    FAILED = ...
    NOT_WEBSOCKET = ...
    quark = ...

class WebsocketState(GObject.GEnum):
    CLOSED = ...
    CLOSING = ...
    OPEN = ...
