from typing import Union

from gi.repository import Gio
from gi.repository import GObject

_lock = ...
_namespace: str = ...
_version: str = ...

def get_resource() -> Gio.Resource: ...

class Device(GObject.Object):
    def get_name(self) -> str: ...
    def has_input(self, type: int, code: int) -> bool: ...
    def has_rumble(self) -> bool: ...
    def has_user_mapping(self) -> bool: ...
    def remove_user_mapping(self) -> None: ...
    def rumble(
        self, strong_magnitude: int, weak_magnitude: int, milliseconds: int
    ) -> bool: ...
    def save_user_mapping(self, mapping_string: str) -> None: ...

class Event:
    def get_absolute(self) -> tuple[bool, int, float]: ...
    def get_button(self) -> tuple[bool, int]: ...
    def get_device(self) -> Device: ...
    def get_event_type(self) -> EventType: ...
    def get_hardware_code(self) -> int: ...
    def get_hardware_index(self) -> int: ...
    def get_hardware_type(self) -> int: ...
    def get_hardware_value(self) -> int: ...
    def get_hat(self) -> tuple[bool, int, int]: ...
    def get_time(self) -> int: ...

class Monitor(GObject.Object):
    def iterate(self) -> MonitorIter: ...
    @classmethod
    def new() -> Monitor: ...

class MonitorIter:
    def next(self) -> tuple[bool, Union[Device, None]]: ...

class EventType(GObject.GEnum):
    EVENT_ABSOLUTE = ...
    EVENT_BUTTON_PRESS = ...
    EVENT_BUTTON_RELEASE = ...
    EVENT_HAT = ...
    EVENT_NOTHING = ...
