from __future__ import annotations

from typing import Union

from gi.repository import Gdk
from gi.repository import Gio
from gi.repository import GLib
from gi.repository import GObject
from gi.repository import Gtk
from gi.repository import Pango

DURATION_INFINITE: int = ...
MAJOR_VERSION: int = ...
MICRO_VERSION = ...
MINOR_VERSION: int = ...
VERSION_S: str = ...
_lock = ...
_namespace: str = ...
_version: str = ...

def easing_ease(value: float) -> float: ...
def get_enable_animations(widget: Gtk.Widget) -> bool: ...
def get_major_version() -> int: ...
def get_micro_version() -> int: ...
def get_minor_version() -> int: ...
def init() -> None: ...
def is_initialized() -> bool: ...
def lerp(a: float, b: float, t: float) -> float: ...

class AboutWindow(Window):
    def add_acknowledgement_section(
        self, name: Union[str, None], people: list[str]
    ) -> None: ...
    def add_credit_section(self, name: Union[str, None], people: list[str]) -> None: ...
    def add_legal_section(
        self,
        title: str,
        copyright: Union[str, None],
        license_type: Gtk.License,
        license: Union[str, None],
    ): ...
    def add_link(self, title: str, url: str): ...
    def get_application_icon(self) -> str: ...
    def get_application_name(self) -> str: ...
    def get_artists(self) -> Union[list[str], None]: ...
    def get_comments(self) -> str: ...
    def get_copyright(self) -> str: ...
    def get_debug_info(self) -> str: ...
    def get_debug_info_filename(self) -> str: ...
    def get_designers(self) -> Union[list[str], None]: ...
    def get_developer_name(self) -> str: ...
    def get_developers(self) -> Union[list[str], None]: ...
    def get_documenters(self) -> Union[list[str], None]: ...
    def get_issue_url(self) -> str: ...
    def get_license(self) -> str: ...
    def get_license_type(self) -> Gtk.License: ...
    def get_release_notes(self) -> str: ...
    def get_release_notes_version(self) -> str: ...
    def get_support_url(self) -> str: ...
    def get_translator_credits(self) -> str: ...
    def get_version(self) -> str: ...
    def get_website(self) -> str: ...
    def set_application_icon(self, application_icon: str) -> None: ...
    def set_application_name(self, application_name: str) -> None: ...
    def set_artists(self, artists: Union[list[str], None]) -> None: ...
    def set_comments(self, comments: str) -> None: ...
    def set_copyright(self, copyright: str) -> None: ...
    def set_debug_info(self, debug_info: str) -> None: ...
    def set_debug_info_filename(self, filename: str) -> None: ...
    def set_designers(self, designers: Union[list[str], None]) -> None: ...
    def set_developer_name(self, developer_name: str) -> None: ...
    def set_developers(self, developers: Union[list[str], None]) -> None: ...
    def set_documenters(self, documenters: Union[list[str], None]) -> None: ...
    def set_issue_url(self, issue_url: str) -> None: ...
    def set_license(self, license: str) -> None: ...
    def set_license_type(self, license_type: Gtk.License) -> None: ...
    def set_release_notes(self, release_notes: str) -> None: ...
    def set_release_notes_version(self, version: str) -> None: ...
    def set_support_url(self, support_url: str) -> None: ...
    def set_translator_credits(self, translator_credits: str) -> None: ...
    def set_version(self, version: str) -> None: ...
    def set_website(self, website: str) -> None: ...

class ActionRow(PreferencesRow):
    def add_prefix(self, widget: Gtk.Widget) -> None: ...
    def add_suffix(self, widget: Gtk.Widget) -> None: ...
    def get_activatable_widget(self) -> Union[Gtk.Widget, None]: ...
    def get_icon_name(self) -> Union[str, None]: ...
    def get_subtitle(self) -> Union[str, None]: ...
    def get_subtitle_lines(self) -> int: ...
    def get_title_lines(self) -> int: ...
    def remove(self, widget: Gtk.Widget) -> None: ...
    def set_activatable_widget(self, widget: Union[Gtk.Widget, None]) -> None: ...
    def set_icon_name(self, icon_name: Union[str, None]) -> None: ...
    def set_subtitle(self, subtitle: str) -> None: ...
    def set_subtitle_lines(self, subtitle_lines: int) -> None: ...
    def set_title_lines(self, title_lines: int) -> None: ...

class Animation(GObject.Object):
    parent_instance: GObject.Object = ...

    def get_state(self) -> AnimationState: ...
    def get_target(self) -> AnimationTarget: ...
    def get_value(self) -> float: ...
    def get_widget(self) -> Gtk.Widget: ...
    def pause(self) -> None: ...
    def play(self) -> None: ...
    def reset(self) -> None: ...
    def resume(self) -> None: ...
    def set_target(self, target: AnimationTarget) -> None: ...
    def skip(self) -> None: ...

class AnimationTarget(GObject.Object): ...
class AnimationTargetFunc: ...

class Application(Gtk.Application):
    def get_style_manager(self) -> StyleManager: ...

class ApplicationWindow(Gtk.ApplicationWindow):
    def get_content(self) -> Gtk.Widget: ...
    def set_content(self, widget: Union[Gtk.Widget, None]) -> None: ...

class Avatar(Gtk.Widget):
    def draw_to_texture(self, scale_factor: int) -> Gdk.Texture: ...
    def get_custom_image(self) -> Union[Gdk.Paintable, None]: ...
    def get_icon_name(self) -> Union[str, None]: ...
    def get_show_initials(self) -> bool: ...
    def get_text(self) -> Union[str, None]: ...
    @classmethod
    def new(
        cls, size: int, text: Union[str, None], show_initials: bool
    ) -> Gtk.Widget: ...
    def set_custom_image(self, custom_image: Union[Gdk.Paintable, None]) -> None: ...
    def set_icon_name(self, icon_name: Union[str, None]) -> None: ...
    def set_show_initials(self, show_initials: bool) -> None: ...
    def set_size(self, size: int) -> None: ...
    def set_text(self, text: Union[str, None]) -> None: ...

class Bin(Gtk.Widget):
    def get_child(self) -> Union[Gtk.Widget, None]: ...
    @classmethod
    def new(cls) -> Gtk.Widget: ...
    def set_child(self, child: Union[Gtk.Widget, None]) -> None: ...

class ButtonContent(Gtk.Widget):
    def get_icon_name(self) -> str: ...
    def get_label(self) -> str: ...
    def get_use_underline(self) -> bool: ...
    @classmethod
    def new(cls) -> Gtk.Widget: ...
    def set_icon_name(self, icon_name: str) -> None: ...
    def set_label(self, label: str) -> None: ...
    def set_use_underline(self, use_underline: bool) -> None: ...

class CallbackAnimationTarget(AnimationTarget):
    @classmethod
    def new(cls, callback: Union[AnimationTargetFunc, None]) -> AnimationTarget: ...

class Carousel(Swipeable, Gtk.Widget, Gtk.Orientable):
    def append(self, child: Gtk.Widget) -> None: ...
    def get_allow_long_swipes(self) -> bool: ...
    def get_allow_mouse_drag(self) -> bool: ...
    def get_allow_scroll_wheel(self) -> bool: ...
    def get_interactive(self) -> bool: ...
    def get_n_pages(self) -> int: ...
    def get_nth_page(self, n: int) -> Gtk.Widget: ...
    def get_position(self) -> float: ...
    def get_reveal_duration(self) -> int: ...
    def get_scroll_params(self) -> SpringParams: ...
    def get_spacing(self) -> int: ...
    def insert(self, child: Gtk.Widget, position: int) -> None: ...
    @classmethod
    def new(cls) -> Gtk.Widget: ...
    def prepend(self, child: Gtk.Widget) -> None: ...
    def remove(self, child: Gtk.Widget) -> None: ...
    def reorder(self, child: Gtk.Widget, position: int) -> None: ...
    def scroll_to(self, widget: Gtk.Widget, animate: bool) -> None: ...
    def set_allow_long_swipes(self, allow_long_swipes: bool) -> None: ...
    def set_allow_mouse_drag(self, allow_mouse_drag: bool) -> None: ...
    def set_allow_scroll_wheel(self, allow_scroll_wheel: bool) -> None: ...
    def set_interactive(self, interactive: bool) -> None: ...
    def set_reveal_duration(self, reveal_duration: int) -> None: ...
    def set_scroll_params(self, params: SpringParams) -> None: ...
    def set_spacing(self, spacing: int) -> None: ...

class CarouselIndicatorDots(Gtk.Widget, Gtk.Orientable):
    def get_carousel(self) -> Union[Carousel, None]: ...
    @classmethod
    def new(cls) -> Gtk.Widget: ...
    def set_carousel(self, carousel: Union[Carousel, None]) -> None: ...

class CarouselIndicatorLines(Gtk.Widget, Gtk.Orientable):
    def get_carousel(self) -> Union[Carousel, None]: ...
    @classmethod
    def new(cls) -> Gtk.Widget: ...
    def set_carousel(self, carousel: Union[Carousel, None]) -> None: ...

class Clamp(Gtk.Widget, Gtk.Orientable):
    def get_child(self) -> Union[Gtk.Widget, None]: ...
    def get_maximum_size(self) -> int: ...
    def get_tightening_threshold(self) -> int: ...
    @classmethod
    def new(cls) -> Gtk.Widget: ...
    def set_child(self, child: Union[Gtk.Widget, None]) -> None: ...
    def set_maximum_size(self, maximum_size: int) -> None: ...
    def set_tightening_threshold(self, tightening_threshold: int) -> None: ...

class ClampLayout(Gtk.LayoutManager, Gtk.Orientable):
    def get_maximum_size(self) -> int: ...
    def get_tightening_threshold(self) -> int: ...
    @classmethod
    def new(cls) -> Gtk.Widget: ...
    def set_maximum_size(self, maximum_size: int) -> None: ...
    def set_tightening_threshold(self, tightening_threshold: int) -> None: ...

class ClampScrollable(Gtk.Widget, Gtk.Orientable, Gtk.Scrollable):
    def get_child(self) -> Union[Gtk.Widget, None]: ...
    def get_maximum_size(self) -> int: ...
    def get_tightening_threshold(self) -> int: ...
    @classmethod
    def new(cls) -> Gtk.Widget: ...
    def set_child(self, child: Union[Gtk.Widget, None]) -> None: ...
    def set_maximum_size(self, maximum_size: int) -> None: ...
    def set_tightening_threshold(self, tightening_threshold: int) -> None: ...

class ComboRow(ActionRow):
    def get_expression(self) -> Gtk.Expression: ...
    def get_factory(self) -> Union[Gtk.ListItemFactory, None]: ...
    def get_list_factory(self) -> Union[Gtk.ListItemFactory, None]: ...
    def get_model(self) -> Union[Gio.ListModel, None]: ...
    def get_selected(self) -> int: ...
    def get_selected_item(self) -> Union[GObject.Object, None]: ...
    def get_use_subtitle(self) -> bool: ...
    def set_expression(self, expression: Union[Gtk.Expression, None]) -> None: ...
    def set_factory(self, factory: Union[Gtk.ListItemFactory, None]) -> None: ...
    def set_list_factory(self, factory: Union[Gtk.ListItemFactory, None]) -> None: ...
    def set_model(self, model: Union[Gio.ListModel, None]) -> None: ...
    def set_selected(self, position: int) -> None: ...
    def set_use_subtitle(self, use_subtitle: bool) -> None: ...

class EntryRow(PreferencesRow, Gtk.Editable):
    def add_prefix(self, widget: Gtk.Widget) -> None: ...
    def add_suffix(self, widget: Gtk.Widget) -> None: ...
    def get_activates_default(self) -> bool: ...
    def get_attributes(self) -> Union[Pango.AttrList, None]: ...
    def get_enable_emoji_completion(self) -> bool: ...
    def get_input_hints(self) -> Gtk.InputHints: ...
    def get_input_purpose(self) -> Gtk.InputPurpose: ...
    def get_show_apply_button(self) -> bool: ...
    def remove(self, widget: Gtk.Widget) -> None: ...
    def set_activates_default(self, activates: bool) -> None: ...
    def set_attributes(self, attributes: Union[Pango.AttrList, None]) -> None: ...
    def set_enable_emoji_completion(self, enable_emoji_completion: bool) -> None: ...
    def set_input_hints(self, hints: Gtk.InputHints) -> None: ...
    def set_input_purpose(self, purpose: Gtk.InputPurpose) -> None: ...
    def set_show_apply_button(self, show_apply_button: bool) -> None: ...

class EnumListItem(GObject.Object):
    def get_name(self) -> str: ...
    def get_nick(self) -> str: ...
    def get_value(self) -> int: ...

class EnumListModel(GObject.Object, Gio.ListModel):
    def find_position(self, value: int) -> int: ...
    def get_enum_type(self) -> GObject.GType: ...
    @classmethod
    def new(cls, enum_type: GObject.GType) -> EnumListModel: ...

class ExpanderRow(PreferencesRow):
    def add_action(self, widget: Gtk.Widget) -> None: ...
    def add_prefix(self, widget: Gtk.Widget) -> None: ...
    def add_row(self, child: Gtk.Widget) -> None: ...
    def get_enable_expansion(self) -> bool: ...
    def get_expanded(self) -> bool: ...
    def get_icon_name(self) -> Union[str, None]: ...
    def get_show_enable_switch(self) -> bool: ...
    def get_subtitle(self) -> str: ...
    def remove(self, child: Gtk.Widget) -> None: ...
    def set_enable_expansion(self, enable_expansion: bool) -> None: ...
    def set_expanded(self, expanded: bool) -> None: ...
    def set_icon_name(self, icon_name: Union[str, None]) -> None: ...
    def set_show_enable_switch(self, show_enable_switch: bool) -> None: ...
    def set_subtitle(self, subtitle: str) -> None: ...

class Flap(Gtk.Widget, Swipeable, Gtk.Orientable):
    def get_content(self) -> Union[Gtk.Widget, None]: ...
    def get_flap(self) -> Union[Gtk.Widget, None]: ...
    def get_flap_position(self) -> Gtk.PackType: ...
    def get_fold_duration(self) -> int: ...
    def get_fold_policy(self) -> FlapFoldPolicy: ...
    def get_fold_threshold_policy(self) -> FoldThresholdPolicy: ...
    def get_folded(self) -> bool: ...
    def get_locked(self) -> bool: ...
    def get_modal(self) -> bool: ...
    def get_reveal_flap(self) -> bool: ...
    def get_reveal_params(self) -> SpringParams: ...
    def get_reveal_progress(self) -> float: ...
    def get_separator(self) -> Union[Gtk.Widget, None]: ...
    def get_swipe_to_close(self) -> bool: ...
    def get_swipe_to_open(self) -> bool: ...
    def get_transition_type(self) -> FlapTransitionType: ...
    @classmethod
    def new(cls) -> Gtk.Widget: ...
    def set_content(self, content: Union[Gtk.Widget, None]) -> None: ...
    def set_flap(self, flap: Union[Gtk.Widget, None]) -> None: ...
    def set_flap_position(self, position: Gtk.PackType) -> None: ...
    def set_fold_duration(self, duration: int) -> None: ...
    def set_fold_policy(self, policy: FlapFoldPolicy) -> None: ...
    def set_fold_threshold_policy(self, policy: FoldThresholdPolicy) -> None: ...
    def set_locked(self, locked: bool) -> None: ...
    def set_modal(self, modal: bool) -> None: ...
    def set_reveal_flap(self, reveal_flap: bool) -> None: ...
    def set_reveal_params(self, params: SpringParams) -> None: ...
    def set_separator(self, separator: Union[Gtk.Widget, None]) -> None: ...
    def set_swipe_to_close(self, swipe_to_close: bool) -> None: ...
    def set_swipe_to_open(self, swipe_to_open: bool) -> None: ...
    def set_transition_type(self, transition_type: FlapTransitionType) -> None: ...

class HeaderBar(Gtk.Widget):
    def get_centering_policy(self) -> CenteringPolicy: ...
    def get_decoration_layout(self) -> Union[str, None]: ...
    def get_show_end_title_buttons(self) -> bool: ...
    def get_show_start_title_buttons(self) -> bool: ...
    def get_title_widget(self) -> Union[Gtk.Widget, None]: ...
    @classmethod
    def new(cls) -> HeaderBar: ...
    def pack_end(self, child: Gtk.Widget) -> None: ...
    def pack_start(self, child: Gtk.Widget) -> None: ...
    def remove(self, child: Gtk.Widget) -> None: ...
    def set_centering_policy(self, centering_policy: CenteringPolicy) -> None: ...
    def set_decoration_layout(self, layout: Union[str, None]) -> None: ...
    def set_show_end_title_buttons(self, setting: bool) -> None: ...
    def set_show_start_title_buttons(self, setting: bool) -> None: ...
    def set_title_widget(self, title_widget: Union[Gtk.Widget, None]) -> None: ...

class Leaflet(Gtk.Widget, Swipeable, Gtk.Orientable):
    def append(self, child: Gtk.Widget) -> LeafletPage: ...
    def get_adjacent_child(
        self, direction: NavigationDirection
    ) -> Union[Gtk.Widget, None]: ...
    def get_can_navigate_back(self) -> bool: ...
    def get_can_navigate_forward(self) -> bool: ...
    def get_can_unfold(self) -> bool: ...
    def get_child_by_name(self, name: str) -> Union[Gtk.Widget, None]: ...
    def get_child_transition_params(self) -> SpringParams: ...
    def get_child_transition_running(self) -> bool: ...
    def get_fold_threshold_policy(self) -> FoldThresholdPolicy: ...
    def get_folded(self) -> bool: ...
    def get_homogeneous(self) -> bool: ...
    def get_mode_transition_duration(self) -> int: ...
    def get_page(self, child: Gtk.Widget) -> Leaflet: ...
    def get_pages(self) -> Gtk.SelectionModel: ...
    def get_transition_type(self) -> LeafletTransitionType: ...
    def get_visible_child(self) -> Union[Gtk.Widget, None]: ...
    def get_visible_child_name(self) -> Union[str, None]: ...
    def insert_child_after(
        self, child: Gtk.Widget, sibling: Union[Gtk.Widget, None]
    ) -> LeafletPage: ...
    def navigate(self, direction: NavigationDirection) -> bool: ...
    @classmethod
    def new(cls) -> Gtk.Widget: ...
    def prepend(self, child: Gtk.Widget) -> LeafletPage: ...
    def remove(self, child: Gtk.Widget) -> None: ...
    def reorder_child_after(
        self, child: Gtk.Widget, sibling: Union[Gtk.Widget, None]
    ) -> None: ...
    def set_can_navigate_back(self, can_navigate_back: bool) -> None: ...
    def set_can_navigate_forward(self, can_navigate_forward: bool) -> None: ...
    def set_can_unfold(self, can_unfold: bool) -> None: ...
    def set_child_transition_params(self, params: SpringParams) -> None: ...
    def set_fold_threshold_policy(self, policy: FoldThresholdPolicy) -> None: ...
    def set_homogeneous(self, homogeneous: bool) -> None: ...
    def set_mode_transition_duration(self, duration: int) -> None: ...
    def set_transition_type(self, transition: LeafletTransitionType) -> None: ...
    def set_visible_child(self, visible_child: Gtk.Widget) -> None: ...
    def set_visible_child_name(self, name: str) -> None: ...

class LeafletPage(GObject.Object):
    def get_child(self) -> Gtk.Widget: ...
    def get_name(self) -> Union[str, None]: ...
    def get_navigatable(self) -> bool: ...
    def set_name(self, name: Union[str, None]) -> None: ...
    def set_navigatable(self, navigatable: bool) -> None: ...

class MessageDialog(Gtk.Window):
    def add_response(self, id: str, label: str) -> None: ...
    def get_body(self) -> str: ...
    def get_body_use_markup(self) -> bool: ...
    def get_close_response(self) -> str: ...
    def get_default_response(self) -> str: ...
    def get_extra_child(self) -> Union[Gtk.Widget, None]: ...
    def get_heading(self) -> Union[str, None]: ...
    def get_heading_use_markup(self) -> bool: ...
    def get_response_appearance(self, response: str) -> ResponseAppearance: ...
    def get_response_enabled(self, response: str) -> bool: ...
    def get_response_label(self, response: str) -> str: ...
    def has_response(self, response: str) -> bool: ...
    def response(self, response: str) -> None: ...
    def set_body(self, body: str) -> None: ...
    def set_body_use_markup(self, use_markup: bool) -> None: ...
    def set_close_response(self, response: str) -> None: ...
    def set_default_response(self, response: Union[str, None]) -> None: ...
    def set_extra_child(self, child: Union[Gtk.Widget, None]) -> None: ...
    def set_heading(self, heading: Union[str, None]) -> None: ...
    def set_heading_use_markup(self, use_markup: bool) -> None: ...
    def set_response_appearance(
        self, response: str, appearance: ResponseAppearance
    ) -> None: ...
    def set_response_enabled(self, response: str, enabled: bool) -> None: ...
    def set_response_label(self, response: str, label: str) -> None: ...
    def do_response(self, response: str): ...

class PasswordEntryRow(EntryRow): ...

class PreferencesGroup(Gtk.Widget):
    def __init__(self, title: str = ...) -> None: ...
    def add(self, child: Gtk.Widget) -> None: ...
    def get_description(self) -> Union[str, None]: ...
    def get_header_suffix(self) -> Union[Gtk.Widget, None]: ...
    def get_title(self) -> str: ...
    @classmethod
    def new(cls) -> Gtk.Widget: ...
    def remove(self, child: Gtk.Widget) -> None: ...
    def set_description(self, description: Union[str, None]) -> None: ...
    def set_header_suffix(self, suffix: Union[Gtk.Widget, None]) -> None: ...
    def set_title(self, title: str) -> None: ...

class PreferencesPage(Gtk.Widget):
    def add(self, group: PreferencesGroup) -> None: ...
    def get_icon_name(self) -> Union[str, None]: ...
    def get_title(self) -> str: ...
    def get_use_underline(self) -> bool: ...
    @classmethod
    def new(cls) -> Gtk.Widget: ...
    def remove(self, group: PreferencesGroup) -> None: ...
    def set_icon_name(self, icon_name: Union[str, None]) -> None: ...
    def set_title(self, title: str) -> None: ...
    def set_use_underline(self, user_underline: bool) -> None: ...

class PreferencesRow(Gtk.ListBoxRow):
    def __init__(self, title: str = ...) -> None: ...
    def get_title(self) -> str: ...
    def get_title_selectable(self) -> bool: ...
    def get_use_markup(self) -> bool: ...
    def get_use_underline(self) -> bool: ...
    def set_title(self, title: str) -> None: ...
    def set_title_selectable(self, title_selectable: bool) -> None: ...
    def set_use_markup(self, use_markup: bool): ...
    def set_use_underline(self, use_underline: bool): ...

class PreferencesWindow(Window):
    def add(self, page: PreferencesPage) -> None: ...
    def add_toast(self, toast: Toast) -> None: ...
    def close_subpage(self) -> None: ...
    def get_can_navigate_back(self) -> bool: ...
    def get_search_enabled(self) -> bool: ...
    def get_visible_page(self) -> Union[PreferencesPage, None]: ...
    def get_visible_page_name(self) -> Union[str, None]: ...
    def present_subpage(self, subpage: Gtk.Widget) -> None: ...
    def remove(self, page: PreferencesPage) -> None: ...
    def set_can_navigate_back(self, can_navigate_back: bool) -> None: ...
    def set_search_enabled(self, search_enabled: bool) -> None: ...
    def set_visible_page(self, page: PreferencesPage) -> None: ...
    def set_visible_page_name(self, name: str) -> None: ...

class PropertyAnimationTarget(AnimationTarget):
    def get_object(self) -> GObject.Object: ...
    def get_pspec(self) -> GObject.ParamSpec: ...
    @classmethod
    def new(cls, object: GObject.Object, property_name: str) -> AnimationTarget: ...
    @classmethod
    def new_for_pspec(
        cls, object: GObject.Object, pspec: GObject.ParamSpec
    ) -> AnimationTarget: ...

class SplitButton(Gtk.Widget, Gtk.Actionable):
    def get_child(self) -> Union[Gtk.Widget, None]: ...
    def get_dropdown_tooltip(self) -> str: ...
    def get_icon_name(self) -> Union[str, None]: ...
    def get_label(self) -> Union[str, None]: ...
    def get_menu_model(self) -> Union[Gio.MenuModel, None]: ...
    def get_popover(self) -> Union[Gtk.Popover, None]: ...
    def get_use_underline(self) -> bool: ...
    @classmethod
    def new(cls) -> Gtk.Widget: ...
    def popdown(self) -> None: ...
    def popup(self) -> None: ...
    def set_child(self, child: Union[Gtk.Widget, None]) -> None: ...
    def set_dropdown_tooltip(self, tooltip: str) -> None: ...
    def set_icon_name(self, icon_name: str) -> None: ...
    def set_label(self, label: str) -> None: ...
    def set_menu_model(self, menu_model: Union[Gio.MenuModel, None]) -> None: ...
    def set_popover(self, popover: Union[Gtk.Popover, None]) -> None: ...
    def set_use_underline(self, use_underline: bool) -> None: ...

class SpringAnimation(Animation):
    def get_clamp(self) -> bool: ...
    def get_epsilon(self) -> float: ...
    def get_estimated_duration(self) -> int: ...
    def get_initial_velocity(self) -> float: ...
    def get_spring_params(self) -> SpringParams: ...
    def get_value_from(self) -> float: ...
    def get_value_to(self) -> float: ...
    def get_velocity(self) -> float: ...
    @classmethod
    def new(
        cls,
        widget: Gtk.Widget,
        from_: float,
        to: float,
        spring_params: SpringParams,
        target: AnimationTarget,
    ) -> Animation: ...
    def set_clamp(self, clamp: bool) -> None: ...
    def set_epsilon(self, epsilon: float) -> None: ...
    def set_initial_velocity(self, velocity: float) -> None: ...
    def set_spring_params(self, spring_params: SpringParams) -> None: ...
    def set_value_from(self, value: float) -> None: ...
    def set_value_to(self, value: float) -> None: ...

class SpringParams:
    def get_damping(self) -> float: ...
    def get_damping_ratio(self) -> float: ...
    def get_mass(self) -> float: ...
    def get_stiffness(self) -> float: ...
    @classmethod
    def new(
        cls, damping_ratio: float, mass: float, stiffness: float
    ) -> SpringParams: ...
    @classmethod
    def new_full(
        cls, damping: float, mass: float, stiffness: float
    ) -> SpringParams: ...
    def ref(self) -> SpringParams: ...
    def unref(self) -> None: ...

class Squeezer(Gtk.Widget, Gtk.Orientable):
    def add(self, child: Gtk.Widget) -> None: ...
    def get_allow_none(self) -> bool: ...
    def get_homogeneous(self) -> bool: ...
    def get_interpolate_size(self) -> bool: ...
    def get_page(self, child: Gtk.Widget) -> SqueezerPage: ...
    def get_pages(self) -> Gtk.SelectionModel: ...
    def get_switch_threshold_policy(self) -> FoldThresholdPolicy: ...
    def get_transition_duration(self) -> int: ...
    def get_transition_running(self) -> bool: ...
    def get_transition_type(self) -> SqueezerTransitionType: ...
    def get_visible_child(self) -> Union[Gtk.Widget, None]: ...
    def get_xalign(self) -> float: ...
    def get_yalign(self) -> float: ...
    @classmethod
    def new(cls) -> Gtk.Widget: ...
    def remove(self, child: Gtk.Widget) -> None: ...
    def set_allow_none(self, allow_none: bool) -> None: ...
    def set_homogeneous(self, homogeneous: bool) -> None: ...
    def set_interpolate_size(self, interpolate_size: bool) -> None: ...
    def set_switch_threshold_policy(self, policy: FoldThresholdPolicy) -> None: ...
    def set_transition_duration(self, duration: int) -> None: ...
    def set_transition_type(self, transition: SqueezerTransitionType) -> None: ...
    def set_xalign(self, xalign: float) -> None: ...
    def set_yalign(self, yalign: float) -> None: ...

class SqueezerPage(GObject.Object):
    def get_child(self) -> Gtk.Widget: ...
    def get_enabled(self) -> bool: ...
    def set_enabled(self, enabled: bool) -> None: ...

class StatusPage(Gtk.Widget):
    def get_child(self) -> Union[Gtk.Widget, None]: ...
    def get_description(self) -> Union[str, None]: ...
    def get_icon_name(self) -> Union[str, None]: ...
    def get_paintable(self) -> Union[Gdk.Paintable, None]: ...
    def get_title(self) -> str: ...
    @classmethod
    def new(cls) -> Gtk.Widget: ...
    def set_child(self, child: Union[Gtk.Widget, None]) -> None: ...
    def set_description(self, description: Union[str, None]) -> None: ...
    def set_icon_name(self, icon_name: Union[str, None]) -> None: ...
    def set_paintable(self, paintable: Union[Gdk.Paintable, None]) -> None: ...
    def set_title(self, title: str) -> None: ...

class StyleManager(GObject.Object):
    def get_color_scheme(self) -> ColorScheme: ...
    def get_dark(self) -> bool: ...
    @classmethod
    def get_default(cls) -> StyleManager: ...
    def get_display(self) -> Gdk.Display: ...
    @classmethod
    def get_for_display(cls, display: Gdk.Display) -> StyleManager: ...
    def get_high_contrast(self) -> bool: ...
    def get_system_supports_color_schemes(self) -> bool: ...
    def set_color_scheme(self, color_scheme: ColorScheme) -> None: ...

class SwipeTracker(GObject.Object, Gtk.Orientable):
    def get_allow_long_swipes(self) -> bool: ...
    def get_allow_mouse_drag(self) -> bool: ...
    def get_enabled(self) -> bool: ...
    def get_reversed(self) -> bool: ...
    def get_swipeable(self) -> Swipeable: ...
    @classmethod
    def new(cls, swipeable: Swipeable) -> SwipeTracker: ...
    def set_allow_long_swipes(self, allow_long_swipes: bool) -> None: ...
    def set_allow_mouse_drag(self, allow_mouse_drag: bool) -> None: ...
    def set_enabled(self, enabled: bool) -> None: ...
    def set_reversed(self, reversed: bool) -> None: ...
    def shift_position(self, delta: float) -> None: ...

class Swipeable(GObject.GInterface):
    def get_cancel_progress(self) -> float: ...
    def get_distance(self) -> float: ...
    def get_progress(self) -> float: ...
    def get_snap_points(self) -> list[float]: ...
    def get_swipe_area(
        self, navigation_direction: NavigationDirection, is_drag: bool
    ) -> Gdk.Rectangle: ...

class SwipeableInterface:
    get_cancel_progress = ...
    get_distance = ...
    get_progress = ...
    get_snap_points = ...
    get_swipe_area = ...
    padding = ...
    parent = ...

class TabBar(Gtk.Widget):
    def get_autohide(self) -> bool: ...
    def get_end_action_widget(self) -> Union[Gtk.Widget, None]: ...
    def get_expand_tabs(self) -> bool: ...
    def get_inverted(self) -> bool: ...
    def get_is_overflowing(self) -> bool: ...
    def get_start_action_widget(self) -> Union[Gtk.Widget, None]: ...
    def get_tabs_revealed(self) -> bool: ...
    def get_view(self) -> Union[TabView, None]: ...
    @classmethod
    def new(cls) -> TabBar: ...
    def set_autohide(self, autohide: bool) -> None: ...
    def set_end_action_widget(self, widget: Union[Gtk.Widget, None]) -> None: ...
    def set_expand_tabs(self, expand_tabs: bool) -> None: ...
    def set_inverted(self, inverted: bool) -> None: ...
    def set_start_action_widget(self, widget: Union[Gtk.Widget, None]) -> None: ...
    def set_view(self, view: Union[TabView, None]) -> None: ...
    def setup_extra_drop_target(
        self, actions: Gdk.DragAction, types: Union[list[GObject.GType], None]
    ) -> None: ...

class TabPage(GObject.Object):
    def get_child(self) -> Gtk.Widget: ...
    def get_icon(self) -> Union[Gio.Icon, None]: ...
    def get_indicator_activatable(self) -> bool: ...
    def get_indicator_icon(self) -> Union[Gio.Icon, None]: ...
    def get_indicator_tooltip(self) -> str: ...
    def get_loading(self) -> bool: ...
    def get_needs_attention(self) -> bool: ...
    def get_parent(self) -> Union[TabPage, None]: ...
    def get_pinned(self) -> bool: ...
    def get_selected(self) -> bool: ...
    def get_title(self) -> str: ...
    def get_tooltip(self) -> Union[str, None]: ...
    def set_icon(self, icon: Union[Gio.Icon, None]) -> None: ...
    def set_indicator_activatable(self, activatable: bool) -> None: ...
    def set_indicator_icon(self, indicator_icon: Union[Gio.Icon, None]) -> None: ...
    def set_indicator_tooltip(self, tooltip: str) -> None: ...
    def set_loading(self, loading: bool) -> None: ...
    def set_needs_attention(self, needs_attention: bool) -> None: ...
    def set_title(self, title: str) -> None: ...
    def set_tooltip(self, tooltip: str) -> None: ...

class TabView(Gtk.Widget):
    def add_page(self, child: Gtk.Widget, parent: Union[TabPage, None]) -> TabPage: ...
    def add_shortcuts(self, shortcuts: TabViewShortcuts) -> None: ...
    def append(self, child: Gtk.Widget) -> TabPage: ...
    def append_pinned(self, child: Gtk.Widget) -> TabPage: ...
    def close_other_pages(self, page: TabPage) -> None: ...
    def close_page(self, page: TabPage) -> None: ...
    def close_page_finish(self, page: TabPage, confirm: bool) -> None: ...
    def close_pages_after(self, page: TabPage) -> None: ...
    def close_pages_before(self, page: TabPage) -> None: ...
    def get_default_icon(self) -> Gio.Icon: ...
    def get_is_transferring_page(self) -> bool: ...
    def get_menu_model(self) -> Gio.MenuModel: ...
    def get_n_pages(self) -> int: ...
    def get_n_pinned_pages(self) -> int: ...
    def get_nth_page(self, position: int) -> TabPage: ...
    def get_page(self, child: Gtk.Widget) -> TabPage: ...
    def get_page_position(self, page: TabPage) -> int: ...
    def get_pages(self) -> Gtk.SelectionModel: ...
    def get_selected_page(self) -> Union[TabPage, None]: ...
    def get_shortcuts(self) -> TabViewShortcuts: ...
    def insert(self, child: Gtk.Widget, position: int) -> TabPage: ...
    def insert_pinned(self, child: Gtk.Widget, position: int) -> TabPage: ...
    @classmethod
    def new(cls) -> TabView: ...
    def prepend(self, child: Gtk.Widget) -> TabPage: ...
    def prepend_pinned(self, child: Gtk.Widget) -> TabPage: ...
    def remove_shortcuts(self, shortcuts: TabViewShortcuts) -> None: ...
    def reorder_backward(self, page: TabPage) -> bool: ...
    def reorder_first(self, page: TabPage) -> bool: ...
    def reorder_forward(self, page: TabPage) -> bool: ...
    def reorder_last(self, page: TabPage) -> bool: ...
    def reorder_page(self, page: TabPage, position: int) -> bool: ...
    def select_next_page(self) -> bool: ...
    def select_previous_page(self) -> bool: ...
    def set_default_icon(self, default_icon: Gio.Icon) -> None: ...
    def set_menu_model(self, menu_model: Union[Gio.MenuModel, None]) -> None: ...
    def set_page_pinned(self, page: TabPage, pinned: bool) -> None: ...
    def set_selected_page(self, selected_page: TabPage) -> None: ...
    def set_shortcuts(self, shortcuts: TabViewShortcuts) -> None: ...
    def transfer_page(
        self, page: TabPage, other_view: TabView, position: int
    ) -> None: ...

class TimedAnimation(Animation):
    def get_alternate(self) -> bool: ...
    def get_duration(self) -> int: ...
    def get_easing(self) -> Easing: ...
    def get_repeat_count(self) -> int: ...
    def get_reverse(self) -> bool: ...
    def get_value_from(self) -> float: ...
    def get_value_to(self) -> float: ...
    @classmethod
    def new(
        cls,
        widget: Gtk.Widget,
        from_: float,
        to: float,
        duration: int,
        target: AnimationTarget,
    ) -> Animation: ...
    def set_alternate(self, alternate: bool) -> None: ...
    def set_duration(self, duration: int) -> None: ...
    def set_easing(self, easing: Easing) -> None: ...
    def set_repeat_count(self, repeat_count: int) -> None: ...
    def set_reverse(self, reverse: bool) -> None: ...
    def set_value_from(self, value: float) -> None: ...
    def set_value_to(self, value: float) -> None: ...

class Toast(GObject.Object):
    def dismiss(self) -> None: ...
    def get_action_name(self) -> Union[str, None]: ...
    def get_action_target_value(self) -> Union[GLib.Variant, None]: ...
    def get_button_label(self) -> Union[str, None]: ...
    def get_custom_title(self) -> Union[Gtk.Widget, None]: ...
    def get_priority(self) -> ToastPriority: ...
    def get_timeout(self) -> int: ...
    def get_title(self) -> str: ...
    @classmethod
    def new(cls, title: str) -> Toast: ...
    def set_action_name(self, action_name: Union[str, None]) -> None: ...
    def set_action_target_value(
        self, action_target: Union[GLib.Variant, None]
    ) -> None: ...
    def set_button_label(self, button_label: Union[str, None]) -> None: ...
    def set_custom_title(self, widget: Union[Gtk.Widget, None]) -> None: ...
    def set_detailed_action_name(
        self, detailed_action_name: Union[str, None]
    ) -> None: ...
    def set_priority(self, priority: ToastPriority) -> None: ...
    def set_timeout(self, timeout: int) -> None: ...
    def set_title(self, title: str) -> None: ...

class ToastOverlay(Gtk.Widget):
    def add_toast(self, toast: Toast) -> None: ...
    def get_child(self) -> Union[Gtk.Widget, None]: ...
    @classmethod
    def new(cls) -> Gtk.Widget: ...
    def set_child(self, child: Union[Gtk.Widget, None]) -> None: ...

class ViewStack(Gtk.Widget):
    def add(self, child: Gtk.Widget) -> ViewStackPage: ...
    def add_named(self, child: Gtk.Widget, name: Union[str, None]) -> ViewStackPage: ...
    def add_titled(
        self, child: Gtk.Widget, name: Union[str, None], title: str
    ) -> ViewStackPage: ...
    def add_titled_with_icon(
        self, child: Gtk.Widget, name: Union[str, None], title: str, icon_name: str
    ) -> ViewStackPage: ...
    def get_child_by_name(self, name: str) -> Union[Gtk.Widget, None]: ...
    def get_hhomogeneous(self) -> bool: ...
    def get_page(self, child: Gtk.Widget) -> ViewStackPage: ...
    def get_pages(self) -> Gtk.SelectionMode: ...
    def get_vhomogeneous(self) -> bool: ...
    def get_visible_child(self) -> Union[Gtk.Widget, None]: ...
    def get_visible_child_name(self) -> Union[str, None]: ...
    @classmethod
    def new(cls) -> Gtk.Widget: ...
    def remove(self, child: Gtk.Widget) -> None: ...
    def set_hhomogeneous(self, hhomogeneous: bool) -> None: ...
    def set_vhomogeneous(self, vhomogeneous: bool) -> None: ...
    def set_visible_child(self, child: Gtk.Widget) -> None: ...
    def set_visible_child_name(self, name: str) -> None: ...

class ViewStackPage(GObject.Object):
    def get_badge_number(self) -> int: ...
    def get_child(self) -> Gtk.Widget: ...
    def get_icon_name(self) -> Union[str, None]: ...
    def get_name(self) -> Union[str, None]: ...
    def get_needs_attention(self) -> bool: ...
    def get_title(self) -> Union[str, None]: ...
    def get_use_underline(self) -> bool: ...
    def get_visible(self) -> bool: ...
    def set_badge_number(self, badge_number: int) -> None: ...
    def set_icon_name(self, icon_name: Union[str, None]) -> None: ...
    def set_name(self, name: Union[str, None]) -> None: ...
    def set_needs_attention(self, needs_attention: bool) -> None: ...
    def set_title(self, title: Union[str, None]) -> None: ...
    def set_use_underline(self, use_underline: bool) -> None: ...
    def set_visible(self, visible: bool) -> None: ...

class ViewSwitcher(Gtk.Widget):
    def get_policy(self) -> ViewSwitcherPolicy: ...
    def get_stack(self) -> Union[ViewStack, None]: ...
    @classmethod
    def new(cls) -> Gtk.Widget: ...
    def set_policy(self, policy: ViewSwitcherPolicy) -> None: ...
    def set_stack(self, stack: Union[ViewStack, None]) -> None: ...

class ViewSwitcherBar(Gtk.Widget):
    def get_reveal(self) -> bool: ...
    def get_stack(self) -> Union[ViewStack, None]: ...
    @classmethod
    def new(cls) -> Gtk.Widget: ...
    def set_reveal(self, reveal: bool) -> None: ...
    def set_stack(self, stack: Union[ViewStack, None]) -> None: ...

class ViewSwitcherTitle(Gtk.Widget):
    def get_stack(self) -> Union[ViewStack, None]: ...
    def get_subtitle(self) -> str: ...
    def get_title(self) -> str: ...
    def get_title_visible(self) -> bool: ...
    def get_view_switcher_enabled(self) -> bool: ...
    @classmethod
    def new(cls) -> Gtk.Widget: ...
    def set_stack(self, stack: Union[ViewStack, None]) -> None: ...
    def set_subtitle(self, subtitle: str) -> None: ...
    def set_title(self, title: str) -> None: ...
    def set_view_switcher_enabled(self, enabled: bool) -> None: ...

class Window(Gtk.Window):
    def get_content(self) -> Union[Gtk.Widget, None]: ...
    def set_content(self, content: Union[Gtk.Widget, None]) -> None: ...

class WindowTitle(Gtk.Widget):
    def get_subtitle(self) -> str: ...
    def get_title(self) -> str: ...
    @classmethod
    def new(cls, title: str, subtitle: str) -> Gtk.Widget: ...
    def set_subtitle(self, subtitle: str) -> None: ...
    def set_title(self, title: str) -> None: ...

class TabViewShortcuts(GObject.GFlags):
    ALL_SHORTCUTS = ...
    ALT_DIGITS = ...
    ALT_ZERO = ...
    CONTROL_END = ...
    CONTROL_HOME = ...
    CONTROL_PAGE_DOWN = ...
    CONTROL_PAGE_UP = ...
    CONTROL_SHIFT_END = ...
    CONTROL_SHIFT_HOME = ...
    CONTROL_SHIFT_PAGE_DOWN = ...
    CONTROL_SHIFT_PAGE_UP = ...
    CONTROL_SHIFT_TAB = ...
    CONTROL_TAB = ...
    NONE = ...

class AnimationState(GObject.GEnum):
    FINISHED = ...
    IDLE = ...
    PAUSED = ...
    PLAYING = ...

class CenteringPolicy(GObject.GEnum):
    LOOSE = ...
    STRICT = ...

class ColorScheme(GObject.GEnum):
    DEFAULT = ...
    FORCE_DARK = ...
    FORCE_LIGHT = ...
    PREFER_DARK = ...
    PREFER_LIGHT = ...

class Easing(GObject.GEnum):
    EASE_IN_BACK = ...
    EASE_IN_BOUNCE = ...
    EASE_IN_CIRC = ...
    EASE_IN_CUBIC = ...
    EASE_IN_ELASTIC = ...
    EASE_IN_EXPO = ...
    EASE_IN_OUT_BACK = ...
    EASE_IN_OUT_BOUNCE = ...
    EASE_IN_OUT_CIRC = ...
    EASE_IN_OUT_CUBIC = ...
    EASE_IN_OUT_ELASTIC = ...
    EASE_IN_OUT_EXPO = ...
    EASE_IN_OUT_QUAD = ...
    EASE_IN_OUT_QUART = ...
    EASE_IN_OUT_QUINT = ...
    EASE_IN_OUT_SINE = ...
    EASE_IN_QUAD = ...
    EASE_IN_QUART = ...
    EASE_IN_QUINT = ...
    EASE_IN_SINE = ...
    EASE_OUT_BACK = ...
    EASE_OUT_BOUNCE = ...
    EASE_OUT_CIRC = ...
    EASE_OUT_CUBIC = ...
    EASE_OUT_ELASTIC = ...
    EASE_OUT_EXPO = ...
    EASE_OUT_QUAD = ...
    EASE_OUT_QUART = ...
    EASE_OUT_QUINT = ...
    EASE_OUT_SINE = ...
    LINEAR = ...
    ease = ...

class FlapFoldPolicy(GObject.GEnum):
    ALWAYS = ...
    AUTO = ...
    NEVER = ...

class FlapTransitionType(GObject.GEnum):
    OVER = ...
    SLIDE = ...
    UNDER = ...

class FoldThresholdPolicy(GObject.GEnum):
    MINIMUM = ...
    NATURAL = ...

class LeafletTransitionType(GObject.GEnum):
    OVER = ...
    SLIDE = ...
    UNDER = ...

class NavigationDirection(GObject.GEnum):
    BACK = ...
    FORWARD = ...

class ResponseAppearance(GObject.GEnum):
    DEFAULT = ...
    DESTRUCTIVE = ...
    SUGGESTED = ...

class SqueezerTransitionType(GObject.GEnum):
    CROSSFADE = ...
    NONE = ...

class ToastPriority(GObject.GEnum):
    HIGH = ...
    NORMAL = ...

class ViewSwitcherPolicy(GObject.GEnum):
    NARROW = ...
    WIDE = ...
