# Generated by Django 4.0.1 on 2022-01-24 13:43

from django.db import migrations, models
import django.db.models.deletion
import mentions.models.webmention


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("contenttypes", "0002_remove_content_type_name"),
    ]

    operations = [
        migrations.CreateModel(
            name="HCard",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True, null=True)),
                (
                    "name",
                    models.CharField(
                        blank=True,
                        help_text="Name of the person/organisation",
                        max_length=50,
                    ),
                ),
                (
                    "avatar",
                    models.URLField(
                        blank=True, help_text="Link to their profile image"
                    ),
                ),
                (
                    "homepage",
                    models.URLField(
                        blank=True, help_text="Link to their homepage", null=True
                    ),
                ),
                (
                    "json",
                    models.TextField(
                        blank=True, help_text="Raw json representation of this hcard"
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="OutgoingWebmentionStatus",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True, null=True)),
                (
                    "source_url",
                    models.URLField(
                        help_text="The URL on your server where this mention originates"
                    ),
                ),
                (
                    "target_url",
                    models.URLField(help_text="The URL that you mentioned."),
                ),
                (
                    "target_webmention_endpoint",
                    models.URLField(
                        blank=True,
                        help_text="The endpoint URL to which we sent the webmention",
                        null=True,
                    ),
                ),
                (
                    "status_message",
                    models.CharField(
                        help_text="Success, or an explanation of what went wrong.",
                        max_length=1024,
                    ),
                ),
                ("response_code", models.PositiveIntegerField(default=0)),
                ("successful", models.BooleanField(default=False)),
            ],
            options={
                "verbose_name_plural": "Outgoing Webmention Statuses",
                "ordering": ["-created_at"],
            },
        ),
        migrations.CreateModel(
            name="Webmention",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True, null=True)),
                ("target_url", models.URLField(help_text="Our URL that is mentioned")),
                (
                    "source_url",
                    models.URLField(help_text="The URL that mentions our content"),
                ),
                (
                    "quote",
                    models.CharField(
                        blank=True,
                        help_text="A short excerpt from the quoted piece",
                        max_length=300,
                        null=True,
                    ),
                ),
                ("published", models.DateTimeField(auto_now_add=True)),
                ("object_id", models.PositiveIntegerField(blank=True, null=True)),
                (
                    "sent_by",
                    models.URLField(
                        blank=True,
                        help_text="Source address of the HTTP request that sent this webmention",
                    ),
                ),
                (
                    "approved",
                    models.BooleanField(
                        default=mentions.models.webmention._approve_default,
                        help_text="Allow this webmention to appear publicly",
                    ),
                ),
                (
                    "validated",
                    models.BooleanField(
                        default=False,
                        help_text="True if both source and target have been validated, confirmed to exist, and source really does link to target",
                    ),
                ),
                ("notes", models.CharField(blank=True, max_length=1024)),
                (
                    "content_type",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="contenttypes.contenttype",
                    ),
                ),
                (
                    "hcard",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="mentions.hcard",
                    ),
                ),
            ],
            options={
                "ordering": ["-created_at"],
                "permissions": [
                    (
                        "approve_webmention",
                        "Can approve received Webmentions for publishing.",
                    )
                ],
            },
        ),
        migrations.CreateModel(
            name="SimpleMention",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True, null=True)),
                ("target_url", models.URLField(help_text="Our URL that is mentioned")),
                (
                    "source_url",
                    models.URLField(help_text="The URL that mentions our content"),
                ),
                (
                    "quote",
                    models.CharField(
                        blank=True,
                        help_text="A short excerpt from the quoted piece",
                        max_length=300,
                        null=True,
                    ),
                ),
                ("published", models.DateTimeField(auto_now_add=True)),
                ("object_id", models.PositiveIntegerField(blank=True, null=True)),
                (
                    "content_type",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="contenttypes.contenttype",
                    ),
                ),
                (
                    "hcard",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="mentions.hcard",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
    ]
