import numpy as np
import matplotlib.pyplot as plt
from random import randint


__all__ = ['STD_COLORS', 'generate_colors', 'plot_colors']


LIGHTEST_THRESHOLD = 2.5

# pre-generated colors, has the color set of <= 100 variables, use STD_COLORS[i] to get the color set of i variables
STD_COLORS = [
    [],
    ['#ff0000'],
    ['#ff0080', '#007dff'],
    ['#ff0000', '#0000ff', '#82ff00'],
    ['#b800fa', '#43ff00', '#00bcff', '#ff4600'],
    ['#ff8000', '#00ff00', '#ff00ff', '#00ffff', '#0000ff'],
    ['#ff0000', '#00ff00', '#ff00ff', '#0000ff', '#ffff00', '#00ffff'],
    ['#00877f', '#ff00ab', '#0000ff', '#8a70ff', '#8bff72', '#ba0000', '#ffac00'],
    ['#42ffff', '#ff00ff', '#3e00ff', '#ff0000', '#008580', '#bf8182', '#ffff00', '#42ff00'],
    ['#00ff38', '#807e00', '#80007d', '#ff35ff', '#00ffff', '#0000ff', '#ff0000', '#80aaa8', '#ffff36'],
    ['#807f00', '#008a85', '#45ffff', '#0000ff', '#ffff00', '#00ff00', '#ff0000', '#82007f', '#ff00ff', '#ff7f7f'],
    ['#00aca0', '#a00000', '#7fff00', '#71009b', '#cb7eae', '#00a200', '#002cff', '#ff7d00', '#ff00ff', '#60ffff', '#ffff5d'],
    ['#e866ff', '#9bff00', '#ffd96d', '#000099', '#007aff', '#7500ff', '#ff6e00', '#628b76', '#00ff00', '#ff008e', '#980020', '#5affff'],
    ['#6c0068', '#ff69ff', '#0093ff', '#96ff00', '#6b7000', '#69ffff', '#0000d3', '#9300ff', '#7e9293', '#ff4200', '#00ff5c', '#ffd968', '#ff008c'],
    ['#ff0094', '#6d6a00', '#ff0000', '#946a94', '#00ffff', '#ffff6b', '#ff67ff', '#0066ff', '#009669', '#ff9800', '#6eff92', '#9000ff', '#240095', '#8fff00'],
    ['#ff76c1', '#00729d', '#ff8e00', '#00ffff', '#8b9267', '#ba00ff', '#5f0088', '#8eff00', '#ffff67', '#00ff6a', '#932200', '#ff0066', '#0000ff', '#1a9400', '#7497ff'],
    ['#9600ff', '#64ff90', '#007d80', '#ff0095', '#670070', '#00ffff', '#ff0000', '#ff6bff', '#0000ff', '#b47f7f', '#96ff00', '#637000', '#6590ff', '#00ff00', '#ff9500', '#ffff6a'],
    ['#6800ff', '#82ff00', '#00ff6c', '#a20077', '#4a7f81', '#00ffff', '#ff0000', '#ff00ff', '#000094', '#7effb3', '#ff9a00', '#825100', '#a386ff', '#009a00', '#ff718e', '#ffff6b', '#0069ff'],
    ['#9b0000', '#000087', '#ffff73', '#7e4078', '#9e5eff', '#0079ff', '#ff7ba1', '#ff00ff', '#81dde4', '#708600', '#b4ff00', '#00ffff', '#008254', '#ff6e00', '#2cff7f', '#00ff00', '#3b00ff', '#ff0063'],
    ['#8d00ff', '#87ff00', '#00d180', '#ff00b6', '#31007f', '#00ffff', '#ff0000', '#ff72ff', '#0000ff', '#7cff99', '#ffc500', '#23811a', '#84a6ff', '#00ff00', '#a26300', '#ffff7b', '#007fff', '#777483', '#ff7870'],
    ['#ff00ff', '#730043', '#00ff00', '#8500c9', '#0000ff', '#4e6bff', '#89b000', '#7fe3e3', '#ff007a', '#daff7e', '#ff7ed8', '#57ff68', '#009fa0', '#00ffff', '#008023', '#00217f', '#ffff00', '#7e7a81', '#ff8751', '#df2400'],
    ['#7f2600', '#00237f', '#ff207f', '#2481ff', '#dd7eff', '#00db7d', '#7e22ff', '#ff00ff', '#81ffe0', '#6e888b', '#ffff00', '#00ffff', '#00ff00', '#ff0000', '#a7ff64', '#6fbb00', '#0000ff', '#7f0080', '#e37e00', '#ffa287', '#008121'],
    ['#ff00ff', '#830017', '#007d00', '#7e009e', '#2700ff', '#825fff', '#00ff00', '#7f7e7f', '#ff007c', '#e3ff7c', '#ff80df', '#5eff81', '#00ffdd', '#007eff', '#00a07e', '#000083', '#ffda00', '#82ff00', '#ff7e5b', '#ff2300', '#a17d00', '#7de3ff'],
    ['#ff00ff', '#71007d', '#00ff00', '#f1117f', '#8000ff', '#897dff', '#82ff00', '#98877f', '#ff0000', '#f6e382', '#ff79cd', '#6eff7f', '#00ffe4', '#007eff', '#003d75', '#0000e7', '#ffff00', '#8a8000', '#ff7733', '#800000', '#087f00', '#80ffff', '#00be74'],
    ['#ff00ff', '#7f0000', '#00ff00', '#7f00ff', '#0000ff', '#7f82ff', '#7dff00', '#91418e', '#ff0080', '#ddff81', '#ff7fff', '#81ffe0', '#00ff7f', '#007fff', '#007f00', '#007d80', '#ffff00', '#ff7f00', '#ff8382', '#ff0000', '#7e8100', '#03ffff', '#70bf71', '#22007f'],
    ['#ff79ff', '#840000', '#00ff00', '#bea1a4', '#7a00ff', '#7b79ff', '#7aff00', '#7ffdfb', '#ff00f0', '#ffff00', '#ffff7a', '#00ff83', '#008787', '#0083ff', '#000083', '#0000ff', '#ff8600', '#878600', '#ff4e6a', '#ff0000', '#59445b', '#00ffff', '#057d00', '#ab0093', '#7bff7c'],
    ['#6c4f00', '#003998', '#ff7377', '#7677ff', '#ff75ff', '#0086f6', '#915190', '#ff00eb', '#75ff79', '#369a69', '#ffff00', '#00ffff', '#00ff87', '#ff0000', '#77ff00', '#00ff00', '#8600ff', '#e40074', '#a5a23c', '#bab8bc', '#008400', '#0000ff', '#530057', '#ffff77', '#76ffff', '#ff7600'],
    ['#ff54ff', '#840000', '#00ff00', '#a953af', '#a900ff', '#5654ff', '#bcff00', '#54a8a8', '#ff00ac', '#ffff62', '#ffaaae', '#a5ffac', '#00539a', '#00a8ff', '#007716', '#0000ff', '#ff9d00', '#62b100', '#ff4f59', '#ff0000', '#604f52', '#51ffff', '#56ff56', '#5400a9', '#ada85b', '#a9a9ff', '#00ffa9'],
    ['#906e00', '#000073', '#ff7674', '#3755ab', '#ff80ff', '#008dff', '#ba3eba', '#ff00ff', '#75ffff', '#489851', '#ffff00', '#00ffff', '#00cf97', '#ff0000', '#65ff86', '#00e800', '#7500ff', '#ff0075', '#b3c247', '#b5bdbb', '#007500', '#0000ff', '#740000', '#ffff80', '#767cff', '#ff8b00', '#740074', '#71ff00'],
    ['#ff4fff', '#720000', '#00ff00', '#ac5ca8', '#af00ff', '#6455ff', '#acff00', '#5eafac', '#ff00ad', '#73ffff', '#ffa9a7', '#b6ffa2', '#008f71', '#008dff', '#001c71', '#5700b3', '#ffb300', '#65a800', '#ff515c', '#b95700', '#5f5852', '#00ffff', '#62ff55', '#a80061', '#b1aa55', '#b7a3ff', '#00ff8e', '#0000ff', '#007400'],
    ['#ff52ff', '#730000', '#00ff00', '#b056aa', '#ad00ff', '#584bff', '#afff00', '#5dafac', '#ff00aa', '#b4ffa8', '#ffa8b1', '#ffff52', '#006b98', '#0096ff', '#00711d', '#000072', '#ffae00', '#a86600', '#ff5252', '#eb0000', '#5d5458', '#69ffff', '#64ff56', '#6300a5', '#b1a95b', '#aba1ff', '#00ffd3', '#0000ff', '#57b300', '#00d16c'],
    ['#9b00ff', '#80ff00', '#007093', '#ff00d6', '#5a5aff', '#00ffff', '#ff1f00', '#ff64ff', '#0000ff', '#98ff99', '#ffff00', '#007600', '#a7a6ff', '#767f00', '#ff8e00', '#ffff70', '#0093ff', '#37b943', '#62a2a8', '#780000', '#3f3c47', '#ad414a', '#6affff', '#00008e', '#b4b24c', '#29ff98', '#ff0068', '#ff9b9c', '#00ff00', '#6f0098', '#af53b5'],
    ['#ff54ff', '#6d0000', '#48ff00', '#b34bb2', '#ab00ff', '#737cff', '#e8ff00', '#98b39d', '#ff00bb', '#4dffaf', '#ffa9bc', '#9bff51', '#4c6499', '#006dff', '#00624c', '#5600bc', '#ff9600', '#9ab500', '#ff004e', '#cb3800', '#00007a', '#00ffff', '#4db34e', '#960066', '#ff6a64', '#94e6ff', '#00b0a8', '#0000ff', '#00af00', '#00ff5b', '#ffff78', '#506600'],
    ['#ff2fff', '#6c0000', '#00ff00', '#b250b6', '#9e00ff', '#504cff', '#6cff00', '#999666', '#ff009c', '#b0ffb8', '#ff97e4', '#b5ff4d', '#004fb5', '#009dff', '#00006d', '#5300b2', '#ff9400', '#719000', '#ff0032', '#bc4100', '#4e484e', '#63ffff', '#4cb5ae', '#9c0062', '#ff6067', '#949fff', '#00ffd4', '#0000ff', '#009564', '#00ff6c', '#ffff00', '#096d00', '#ffc883'],
    ['#a100ff', '#96ff00', '#00c54c', '#ff00d0', '#5117bf', '#00ffff', '#ff2200', '#ff62ff', '#0000ff', '#a6ffa9', '#ffff00', '#005f2d', '#6a67ff', '#4c9b00', '#ff9400', '#ffff6d', '#00b5b3', '#a6af48', '#70a2a3', '#6c0000', '#2b0060', '#a55c00', '#b5b3ff', '#004e97', '#f66a60', '#3fff88', '#ff0066', '#ffafb2', '#2bff00', '#93006f', '#b54db4', '#6affff', '#645b54', '#006cff'],
    ['#9c9500', '#004e4e', '#ff5776', '#4164a0', '#ff50ff', '#00b5b1', '#8c5653', '#ff00b8', '#93ffec', '#4fae48', '#cbff8f', '#00ffff', '#00ff61', '#ff6c00', '#63ff8d', '#29ff00', '#684dff', '#970000', '#e6b446', '#96a599', '#009d00', '#0000ff', '#4a4e00', '#ffacb7', '#4bb4ff', '#ffff00', '#4b004a', '#94ff00', '#b49bff', '#006bff', '#b000ff', '#6700b2', '#ff0000', '#000096', '#c9005c'],
    ['#6800ff', '#67ff00', '#00ae3f', '#ff00ff', '#4a4d9d', '#00d1ff', '#ff0000', '#ff6aff', '#0000ff', '#adffb5', '#ffff00', '#00484e', '#6869ff', '#367000', '#ff6600', '#ffff70', '#0095a5', '#629756', '#62b5b8', '#7c2500', '#500056', '#9d8800', '#b3b5ff', '#000096', '#ff9c56', '#5bff6d', '#ff0098', '#ffb4b9', '#00ff00', '#b7004c', '#b234d1', '#60ffff', '#b25f73', '#0068ff', '#00ff9f', '#aed93e'],
    ['#ff00ff', '#690000', '#49b300', '#6349b3', '#6100ff', '#7a9cff', '#90ff00', '#b48aa9', '#b000b1', '#a8ffbd', '#fb8ff4', '#c5ff57', '#3eaead', '#00c0ff', '#005c99', '#0000d1', '#ff5b00', '#af9a00', '#ff005e', '#cf0000', '#000069', '#56ffff', '#80b25b', '#690067', '#ffac3e', '#b245ff', '#00ffac', '#005cff', '#006900', '#00aa51', '#ffff00', '#485e4a', '#ffd1a0', '#ff43ae', '#3bff55', '#b44d4c', '#00ff00'],
    ['#ff00ff', '#650000', '#47b600', '#7e51a5', '#6700ff', '#4f64ff', '#96ff00', '#99adff', '#c300ad', '#aaffbd', '#fc8bf6', '#d0ff5b', '#3fb0ab', '#00a5ff', '#00995e', '#005bb9', '#ff5a00', '#ab9b00', '#ff005a', '#ce0000', '#00335a', '#5bffff', '#9caa7d', '#7c0061', '#ffa846', '#b245ff', '#00ffce', '#0000ff', '#006900', '#00ff66', '#ffff00', '#575c35', '#ffcaa4', '#ff54a0', '#69ff5d', '#bb514f', '#00ff00', '#3000a6'],
    ['#614d00', '#006665', '#ff949e', '#585195', '#b853b9', '#00aab2', '#a1574f', '#ff3cff', '#4dffbe', '#569d4e', '#ffff54', '#00ffff', '#00ff79', '#ff6700', '#6fff5d', '#45ff00', '#6c55ff', '#9c0018', '#b8b85f', '#81aab0', '#00c02a', '#0000ff', '#430c4a', '#c1ffa4', '#43b3ff', '#ffcc00', '#a00084', '#a8ff08', '#df9dff', '#0065ff', '#b000ff', '#ff00ac', '#ff0000', '#000097', '#ff3357', '#006400', '#5800cd', '#a69a00', '#99e7fe'],
    ['#6300ff', '#4fff43', '#00b33f', '#b000c1', '#6062b1', '#00ffff', '#ff3b00', '#ff00ff', '#0000ff', '#b3ffa8', '#ffff00', '#000864', '#9d4fff', '#006600', '#ff9c00', '#ffff63', '#00a1a2', '#50b200', '#a2c757', '#563300', '#50009e', '#a17600', '#61a1ff', '#0042b5', '#ff8362', '#56daa7', '#ff0050', '#c2b2ff', '#00ff00', '#9c0062', '#ff36a5', '#7effff', '#9e6362', '#0085ff', '#00ff7f', '#99fa00', '#ffc0b3', '#365f57', '#ae0000', '#ff65ff'],
    ['#8400ff', '#48ff4b', '#00ba4f', '#bd00ae', '#623db8', '#00deff', '#ff7600', '#ff00ff', '#2000ff', '#c0ffaf', '#ffdc00', '#003f4b', '#9d62ff', '#008000', '#af3c00', '#ffff5f', '#009fb3', '#4bbf00', '#a9cf57', '#630000', '#430070', '#595f1c', '#4d9eff', '#002aae', '#ff9e5c', '#65daa3', '#ff0065', '#afc4ff', '#00ff00', '#a0004d', '#ff539e', '#5effff', '#ac6365', '#0060ff', '#00ff98', '#96ff00', '#ffb1be', '#498478', '#ff0000', '#ff65ff', '#a59f00'],
    ['#635400', '#005761', '#ff607c', '#5b478b', '#b648b9', '#00a69d', '#b34f3d', '#ff51ff', '#5aff9c', '#63924b', '#a7ff62', '#00ffdc', '#00ff00', '#ff6400', '#00ff78', '#4ef23a', '#a88fff', '#9c0000', '#ffb140', '#b4a083', '#00b13a', '#0000ff', '#4e003d', '#fef38c', '#00a1ff', '#ffff00', '#9e0077', '#9bff00', '#ffa9cf', '#5156ff', '#af00ff', '#ff00c4', '#ff0000', '#004fc4', '#ff0063', '#006100', '#5800ce', '#a99d00', '#60a0bd', '#0f008b', '#ade4cc', '#5effff'],
    ['#ff73ff', '#610000', '#009c00', '#ae56d3', '#9800ff', '#5e7dff', '#9eb100', '#a0a79f', '#ff0077', '#baffba', '#ffb8b9', '#50ff71', '#4b5c80', '#00cbff', '#00009c', '#4c26d0', '#ff9d00', '#af5100', '#ff4b39', '#ff0000', '#4f0060', '#75ffff', '#57a945', '#af003b', '#e7a35f', '#b5b4ff', '#4bc5bf', '#0000ff', '#004e41', '#008da7', '#a8ff47', '#4f6000', '#ffff75', '#ff5b9d', '#00d056', '#ab566c', '#00ff00', '#9e009d', '#ff00ff', '#00ffab', '#61ff00', '#ffff00', '#0061ff'],
    ['#ff6fff', '#630000', '#009a00', '#ac53d2', '#9200ff', '#5d7aff', '#a1b300', '#9ca8a0', '#ff0077', '#b1ffc6', '#ffb9bb', '#6cff83', '#57639f', '#00ffff', '#00007b', '#4800bd', '#ff9d00', '#af5000', '#ff4f3b', '#ff0000', '#5a1b5d', '#62ffff', '#6c954c', '#b1003b', '#e4a55d', '#b4adff', '#40bebe', '#0000ff', '#004e3c', '#009282', '#b1ff3d', '#4d5f00', '#ffff76', '#ff5ba0', '#27d84c', '#ab536d', '#00ff00', '#a600a0', '#ff00ff', '#00ff9c', '#62ff00', '#ffff00', '#004fc6', '#009eff'],
    ['#7000ff', '#43ff45', '#00b252', '#9f00ab', '#625cae', '#0084ff', '#ff6e00', '#ff00ff', '#3300b5', '#b8ffc0', '#ffff00', '#007e00', '#9c56ff', '#5b5f00', '#b13600', '#fefe81', '#0054a9', '#4bbd00', '#5ca45b', '#610000', '#62005f', '#a99f00', '#5fa0ff', '#000063', '#b5a67e', '#5cffa0', '#ff009d', '#bab8ff', '#00ff00', '#c7004f', '#cf55ad', '#6fffff', '#955258', '#0023ff', '#00ffff', '#a4ff5e', '#ffb3bb', '#25574f', '#ff0000', '#ff6bff', '#94ff00', '#28adae', '#ff4e5a', '#ffb540', '#00ff8c'],
    ['#690000', '#00684d', '#ff9e69', '#3ab25b', '#bd55ff', '#00ff61', '#c35270', '#ff4bba', '#a3ffc6', '#6f6745', '#a8ff5f', '#00ffc0', '#00ff00', '#ff5825', '#55ff8e', '#58ff29', '#6165ff', '#b90040', '#afac34', '#adab94', '#009f00', '#0000ff', '#00005f', '#f5f198', '#11bbff', '#ffb200', '#5d0061', '#b0ff00', '#ffa6d6', '#005eff', '#ff00ff', '#a400a2', '#ff0000', '#0041a3', '#ff0080', '#334f00', '#5d59a0', '#5da800', '#5bb0c3', '#4700c0', '#a7b1ff', '#56ffff', '#ffff38', '#9000ff', '#00a0a4', '#aa4700'],
    ['#ff45a2', '#4d0035', '#44a400', '#a440ff', '#5f00ff', '#7592ff', '#a2b700', '#9dacab', '#ff0060', '#cdfcad', '#ffa5ac', '#76ff8f', '#5a66ad', '#00ffff', '#00006c', '#54009f', '#ffa000', '#604b00', '#ff0000', '#9e0000', '#2f525b', '#8ff8f6', '#6aa158', '#a10063', '#d0ab59', '#cfaffe', '#42d1d0', '#0000ff', '#00a143', '#009ea0', '#a6ff3e', '#006000', '#ffff5c', '#ff5a45', '#31f150', '#aa5a7c', '#00ff00', '#bb00bc', '#ff00ff', '#00ff9e', '#5fff00', '#ffff00', '#0041b0', '#3250ff', '#c05a00', '#ff5dff', '#00a0ff'],
    ['#4e33ff', '#00ff5e', '#00a351', '#ae00ff', '#645ead', '#00c1ff', '#ffa200', '#ff30ff', '#7000b7', '#c3ffb8', '#ffff00', '#005d0f', '#a45fff', '#2fad00', '#d05000', '#ffff5e', '#0063ff', '#4ff82c', '#5ea95e', '#5e0000', '#5d005e', '#5e5d00', '#97d1ff', '#00005d', '#b9c156', '#7bff7c', '#ff00ae', '#e99cf8', '#00ff00', '#ae0032', '#b63092', '#47ffff', '#98644a', '#0000ff', '#00ffba', '#a0ff00', '#a6a4ae', '#2f5260', '#ff0000', '#ff62af', '#a0a100', '#0031af', '#ff2557', '#ff8258', '#4bc7b3', '#ffbda1', '#5392ff', '#0091ad'],
    ['#5f00ff', '#52ff34', '#009e00', '#ff00ff', '#6b49c0', '#00bdff', '#ff6700', '#ff5dff', '#2d00af', '#7fb2b5', '#ffff00', '#005233', '#b02fff', '#4b5a00', '#a74d00', '#ffff6a', '#0060ff', '#5bb500', '#7aad56', '#600000', '#5e0060', '#a45160', '#97e5ff', '#00005e', '#a5ff5f', '#56ff94', '#ff005f', '#ae8cff', '#00ff00', '#af0033', '#ff2ead', '#40ffff', '#aa00a1', '#0000ff', '#00ffbb', '#a0ff00', '#cca282', '#48636b', '#ff0000', '#ffaed0', '#b7a700', '#004da4', '#ff5e5d', '#ffb338', '#00ff5e', '#c9ffb6', '#24a1b1', '#00a25d', '#518cff'],
    ['#5e0000', '#005c5f', '#ffa35e', '#774d8b', '#c689ad', '#00b38f', '#aa008c', '#ff5087', '#aaffca', '#519e5c', '#aeff2a', '#00ffff', '#00ff5c', '#ff5329', '#61ff5e', '#00ff00', '#5b98ff', '#ad002e', '#ac7f51', '#b3d279', '#00ae33', '#0000ff', '#4e4f2f', '#fed1af', '#2bffad', '#ffa400', '#5d005d', '#ffff00', '#ff82f6', '#433eff', '#e62cff', '#ff00b4', '#ff0000', '#0028ac', '#ff0058', '#005f00', '#9958ea', '#a3ad00', '#6dbfae', '#5200ba', '#b4b4ff', '#5cffff', '#ffff5d', '#9300ff', '#3173b6', '#ad5000', '#00005c', '#499d00', '#5cff00', '#00a2ff'],
    ['#ac27ff', '#51ff33', '#25ae00', '#ff00ff', '#55619d', '#00ffff', '#ff5b00', '#ff5aff', '#5b00ff', '#abffd4', '#ffff00', '#005a00', '#5b5aff', '#522600', '#a50000', '#ffff5d', '#005bff', '#80ad00', '#9ab0aa', '#000062', '#98009e', '#a45a00', '#7fadff', '#3b00a9', '#a2ff62', '#5effa4', '#d10051', '#daacf8', '#00ff00', '#590053', '#ad58b1', '#5bffff', '#93445c', '#0000ff', '#00ffa2', '#a4ff00', '#a69d52', '#517132', '#ff0000', '#ff7ead', '#daad00', '#4fb275', '#ff4c60', '#ffa651', '#00d251', '#f5d7af', '#00a2ab', '#007759', '#26adff', '#0045a6', '#ff00a1'],
    ['#403f00', '#00807e', '#ff7f7f', '#817f7d', '#bf7fc0', '#00c0c0', '#bf3f7f', '#ff3fbf', '#c0ffbe', '#40bd7f', '#bfff41', '#00ffff', '#00ff7f', '#ff3f3e', '#81ff81', '#40ff41', '#8180ff', '#955429', '#aead11', '#bfc07f', '#00c13f', '#0000ff', '#00413e', '#fffe7e', '#40ffc0', '#ff7e00', '#5f0060', '#ffff00', '#ff7eff', '#413fff', '#c03fff', '#bf00bd', '#bf0040', '#0040be', '#ff007d', '#008200', '#7e3fbf', '#40c200', '#80bec0', '#3e00bc', '#c0c0fe', '#80ffff', '#ffbf3f', '#8100ff', '#407fc0', '#7e0000', '#00007d', '#40803e', '#80ff00', '#007eff', '#00ff00', '#ff0000'],
    ['#522100', '#456738', '#ff55b9', '#69937b', '#884fbb', '#00ccb0', '#8e3a4e', '#ff00ff', '#8eff78', '#9daa37', '#ffff59', '#00ffff', '#00ff66', '#ff5900', '#49ffb3', '#49d74c', '#8a87ff', '#4b0053', '#ffa653', '#bc7680', '#00ad27', '#0000ff', '#002d4d', '#ffabac', '#4fcfff', '#e1ab00', '#3d458b', '#afff28', '#df9fff', '#4e3fff', '#c947ff', '#ff009c', '#d1004e', '#004acd', '#ff4b59', '#005b00', '#a3009d', '#57a800', '#a1b4b8', '#5200c1', '#d9fba9', '#98fee7', '#ffff00', '#9400ff', '#4186cc', '#a60000', '#00009b', '#a46200', '#60ff00', '#00a3ff', '#00ff00', '#ff0000', '#008578'],
    ['#ff4ed2', '#7c0000', '#54ce00', '#795460', '#a700ff', '#5d53ff', '#a3ff00', '#aab5a9', '#ff00a5', '#a6ffd9', '#f0a0ed', '#5cffa5', '#4452ab', '#00e1ff', '#00521d', '#53008e', '#ffa600', '#a3a200', '#ff004d', '#d60000', '#3d143c', '#4fa99b', '#88b158', '#a6004f', '#d58848', '#b25ba5', '#00ffad', '#0000ff', '#3e8c38', '#00a971', '#ffff00', '#574e00', '#e8f5a0', '#ff4b79', '#57ff4a', '#aa4a18', '#00ff00', '#a600a7', '#ff00ff', '#00ff57', '#afff5a', '#ffd751', '#0000a6', '#0059ff', '#ff4d00', '#b45aff', '#009cc9', '#43a8ff', '#00a700', '#ff9f97', '#54ffff', '#5300e5', '#9bafff', '#004a74'],
    ['#522800', '#4b7533', '#ff6a6b', '#8c7275', '#cc74b5', '#00bec1', '#be3942', '#ff00ff', '#80ff81', '#3ebf81', '#bdff40', '#00ffff', '#00ff81', '#ff6600', '#40ffbf', '#3eff41', '#837bff', '#71004e', '#80bd41', '#c1bc7d', '#00be3f', '#0000ff', '#004140', '#ffff7d', '#42bcff', '#bdba00', '#433e7e', '#ffff00', '#ff80ff', '#413eff', '#c23fff', '#b2008d', '#ff005a', '#003fbd', '#ff29ae', '#007f00', '#843dbd', '#41bf00', '#80bcbf', '#4200bf', '#ffbebe', '#7fffff', '#ffb93c', '#8100ff', '#3f7cbe', '#a20000', '#00007c', '#956700', '#7fff00', '#007cff', '#00ff00', '#ff0000', '#008081', '#c1febe', '#bfc0ff'],
    ['#541700', '#4c9d74', '#ffa88e', '#98667e', '#e254ab', '#00a5a7', '#b74436', '#ff00a7', '#70ffaa', '#77b92c', '#afff59', '#00ffff', '#00ff57', '#ff5700', '#18ffad', '#58ff58', '#ac75ff', '#7e0049', '#ceae47', '#9dbb90', '#00a84c', '#0000ff', '#534c50', '#ffff7e', '#17acff', '#ffaf00', '#520893', '#aeff00', '#ff59ff', '#576bff', '#ff00ff', '#aa0094', '#e50053', '#001eac', '#ff625a', '#005f00', '#883bc8', '#2ab300', '#5bafc9', '#5400eb', '#ecade5', '#58ffff', '#ffff26', '#a800ff', '#3b5cac', '#a80000', '#000058', '#5d6d00', '#59ff00', '#0056ff', '#00ff00', '#ff0000', '#00566b', '#c3f9be', '#9dccff', '#b08800'],
    ['#a15aff', '#1dff51', '#00a800', '#ad00ff', '#4955ff', '#0097ff', '#ff5600', '#ff1cff', '#5700ff', '#91d6be', '#ffff00', '#004e27', '#b385b8', '#457200', '#914f00', '#ffff56', '#004ad3', '#5db631', '#a9b671', '#580056', '#ac006f', '#b0991e', '#6bffff', '#094c7f', '#87ff4c', '#54a687', '#ff0056', '#ff76ff', '#00ff00', '#ab0018', '#b42fb7', '#54ff91', '#a95b6a', '#0000ff', '#00ffff', '#56ff00', '#ffaa67', '#535953', '#ff0000', '#ff59ac', '#aaec00', '#6757ac', '#ff5655', '#ffab00', '#00ffa4', '#ffb0bd', '#0097aa', '#009754', '#6fa2ff', '#000055', '#ff00ac', '#36ced1', '#c6b9ff', '#570d00', '#dcfca6', '#1500a9', '#6b00ac'],
    ['#531100', '#004864', '#ffac56', '#866a8f', '#b544ca', '#00baba', '#bf2f75', '#ff57ff', '#7effa1', '#4f634d', '#abff57', '#00ffff', '#00f456', '#ff564b', '#56ff56', '#52ad1d', '#917aff', '#83004d', '#a96f41', '#57b074', '#00a800', '#0000ff', '#2c004c', '#ffff6c', '#4dadff', '#ff9a00', '#472f92', '#afff00', '#dea5fb', '#4553ff', '#ff00ff', '#ff00aa', '#ff0055', '#0044c9', '#ff56a1', '#1a5500', '#8c00a7', '#a8a800', '#83b0bf', '#5200e9', '#ffacad', '#53ffec', '#ffed17', '#a600ff', '#3c7db6', '#a80000', '#000095', '#736300', '#56ff00', '#0087ff', '#00ff00', '#ff0000', '#009f65', '#d1f6b7', '#9fe0fe', '#d64c00', '#b1b177', '#28ffa0'],
    ['#560000', '#007c83', '#ff7496', '#7a3ec3', '#b94289', '#00b6c4', '#7b7b85', '#ff00ff', '#bbff53', '#3d7e49', '#ffff21', '#00ffff', '#00ff94', '#bc7a48', '#72ff7f', '#2cff4c', '#777cff', '#85393c', '#ffb156', '#78bcc1', '#00b836', '#0000ff', '#292941', '#fef887', '#3cbdff', '#ff5800', '#630074', '#b0ff00', '#ff7aff', '#3e3cff', '#bf3cff', '#ff0090', '#c40053', '#003cc1', '#ff3f52', '#007400', '#b900c0', '#43ac00', '#b87cc6', '#3f00c2', '#ffbbc3', '#84fbfe', '#ffae00', '#7c00ff', '#3c7ac1', '#aa0000', '#000081', '#505600', '#58ff00', '#0078ff', '#00ff00', '#ff0000', '#3abf83', '#b7ffb8', '#bfbdff', '#a7a800', '#b7b886', '#44ffc9', '#76bf45'],
    ['#560000', '#005c73', '#ff7a8c', '#7141a4', '#be4387', '#00b27e', '#bc7c48', '#ff35bc', '#a8ff89', '#31843a', '#dfff43', '#00ffff', '#00ff53', '#ac5400', '#51ff8f', '#48d547', '#479dff', '#7b464c', '#ffb04b', '#70c0be', '#00aa00', '#0000ff', '#2b2a3d', '#fbf192', '#00b4d5', '#ff7700', '#5e0072', '#abff00', '#ff6eff', '#4c44ff', '#ff00ff', '#ff0078', '#b00056', '#0036bd', '#ff4446', '#005600', '#ab00b8', '#63a900', '#8c74e2', '#4300c3', '#ffb3cb', '#54ffff', '#ffd900', '#7d00ff', '#337bb1', '#aa0000', '#000079', '#575400', '#57ff00', '#0069ff', '#00ff00', '#ff0000', '#6d9075', '#a1ffde', '#bbb6ff', '#b8a900', '#b9aa95', '#00ffa9', '#9dcb49', '#be37ff'],
    ['#ff4acb', '#000055', '#8b9300', '#5c2ab7', '#aa00ff', '#6b52ff', '#caca00', '#806782', '#ff00a4', '#8cf5fc', '#ffc5b5', '#81ff84', '#009555', '#00a9ff', '#004a26', '#51006e', '#ff8a00', '#c15200', '#f30050', '#550000', '#334f69', '#4dffc7', '#6aa34b', '#9e0053', '#b87f47', '#bc7fb8', '#00a8aa', '#0000ff', '#436c00', '#00f954', '#ffff24', '#7a4633', '#c2ffba', '#ff5140', '#4ac700', '#c93d7d', '#00ff00', '#a400ab', '#ff00ff', '#00ffa9', '#8aff00', '#ffb44a', '#0000ab', '#0055ff', '#ac0000', '#bd52ff', '#487dc0', '#a4a5ff', '#009e00', '#ff7c88', '#00ffff', '#5400ff', '#81bbb5', '#0054aa', '#f691f7', '#ffff78', '#3dd280', '#ff1800', '#b1d24f', '#51b8ff', '#51ff3c'],
    ['#550000', '#33407e', '#ff8a8f', '#8141b8', '#d74ab5', '#00b384', '#a94668', '#ff54ff', '#8cff96', '#454c2f', '#beff4f', '#00ffff', '#00a900', '#de4e00', '#52ff58', '#34b543', '#5ca8ff', '#80004c', '#d78146', '#51c293', '#007050', '#0000ff', '#2c0048', '#ffcc45', '#18bed3', '#ff9c00', '#4e00ac', '#a7f300', '#b0a9ff', '#5852ff', '#ff00ff', '#ff00a9', '#d40048', '#0042c4', '#ff3d6d', '#005500', '#ad0098', '#569200', '#8c93b6', '#5500ff', '#fca1e0', '#4cffcc', '#ffff00', '#aa00ff', '#3d78bb', '#a90000', '#00008e', '#895000', '#54ff00', '#007dff', '#00ff00', '#ff0000', '#6a7f69', '#c8e2c9', '#8bf3ff', '#aa9d00', '#bebc7f', '#00ffa6', '#86c342', '#ab54ff', '#f9f98b', '#00ff53'],
    ['#546000', '#2b3f77', '#ffb5b4', '#bd4485', '#ab4dff', '#00809a', '#724348', '#ff00b2', '#85ffa6', '#4ca13a', '#ffff00', '#00ffff', '#00a800', '#ff5454', '#94ff53', '#42ff57', '#3dc2ff', '#48002a', '#ffa762', '#38bc88', '#007d47', '#0000ff', '#000052', '#ffff55', '#00c5c6', '#ff5400', '#62007b', '#c3c830', '#ff4cff', '#4a42ff', '#de00ff', '#ac00b2', '#ac0050', '#0044d4', '#ff61ad', '#005400', '#7b42bb', '#4cdd00', '#b381bc', '#4b00cb', '#e49aff', '#3affc5', '#ffa700', '#8b00ff', '#4582c9', '#920000', '#0000a5', '#8ba200', '#9bff00', '#008bff', '#00ff00', '#ff0000', '#738083', '#b5d4dc', '#76ffff', '#aa4f00', '#afbe81', '#00ff8a', '#b07a47', '#8799ff', '#dbffa1', '#00d049', '#ff005d'],
    ['#4f2300', '#2b4272', '#ff9baf', '#6e6f85', '#f04aa5', '#008096', '#7c5239', '#ff00c2', '#9fffae', '#3fba37', '#ffff00', '#00ffff', '#00ac00', '#ff5053', '#55ff5e', '#53ff00', '#7e93ff', '#830033', '#b87b61', '#75b6b6', '#007f43', '#0000ff', '#300042', '#ffff52', '#00b8d1', '#ffa300', '#690081', '#c0be2e', '#ff3dff', '#3a39ff', '#ca00ff', '#ad00b1', '#ff001b', '#003cc5', '#b52767', '#005300', '#763cc4', '#7db800', '#b17dba', '#3a00c5', '#f18efe', '#4dffbf', '#ffa75e', '#7700ff', '#407acc', '#b82500', '#000089', '#4a7600', '#a9ff00', '#0075ff', '#00ff00', '#ff5000', '#30c389', '#87f9fe', '#c3cadf', '#b57800', '#acff5d', '#00ffa5', '#82b964', '#ae4fff', '#efeda1', '#00ff54', '#ff0070', '#41cbff'],
    ['#c43cff', '#7bff4f', '#00ac00', '#ff00ff', '#421ada', '#1eaaff', '#ff003c', '#ff3ac6', '#8800ff', '#a8b79b', '#ffc600', '#005400', '#a37ad4', '#468300', '#834a00', '#ffff3a', '#0054ff', '#809438', '#c38063', '#413f2c', '#7b00a3', '#c13d36', '#97f6f0', '#0058ad', '#bbcd40', '#52a7b5', '#b50068', '#ff77ff', '#3fc62e', '#670053', '#ba459b', '#82ffa1', '#804c62', '#0000ff', '#00ffff', '#c2ff00', '#ffbc6b', '#45826c', '#b00000', '#ff86a6', '#bb9600', '#6559af', '#ff4a6b', '#ff802b', '#00ffab', '#eed4bc', '#00abb1', '#00ae5e', '#5262ff', '#005c55', '#ff008f', '#73aeff', '#c8b5ff', '#5d0000', '#cdff7d', '#0000ae', '#c400c7', '#ff3900', '#66ff00', '#00ff00', '#342b80', '#3ee07d', '#000052', '#48ffd9', '#00ff51'],
    ['#4a2300', '#414c87', '#ff899c', '#ab4a7b', '#de46be', '#009286', '#6f4d42', '#ff00ff', '#7eff92', '#388f4d', '#acff4d', '#00ffff', '#00a600', '#cb3028', '#41ff42', '#47cc00', '#3cc4ff', '#a0005a', '#b68845', '#41cd83', '#005353', '#0000ff', '#4f004a', '#ffac53', '#00c4c7', '#ff6200', '#56009c', '#ddff00', '#ff6fff', '#2e46ff', '#ab00ff', '#ac00ac', '#ff0054', '#0052ba', '#ff5b57', '#005300', '#7342c9', '#abb500', '#6a7eff', '#0400ad', '#ecb7da', '#3cffc5', '#ffb500', '#5a00ff', '#4090bc', '#960000', '#00005a', '#4b7800', '#89ff00', '#0089ff', '#00ff00', '#ff0000', '#788b81', '#bcf8ca', '#a2bdff', '#9c6400', '#b8c183', '#00ff8b', '#7abf41', '#af52ff', '#fee699', '#00cb49', '#ff00a6', '#74ffff', '#ad88c0', '#ffff4c'],
    ['#932eff', '#7fff41', '#00ae00', '#be00ce', '#2635cf', '#1fb3ff', '#ff0000', '#ff43d1', '#5000ff', '#9cb9b8', '#ffff00', '#005200', '#a778e6', '#438000', '#8f4900', '#ffff51', '#0069ff', '#81be00', '#947b82', '#4d402f', '#452c7d', '#7e8336', '#9bffe0', '#00528f', '#bece46', '#48c4b9', '#b7007d', '#fa85ff', '#36ca36', '#76004c', '#ff4778', '#94ff8f', '#a8404d', '#0000ff', '#00ffff', '#aeff00', '#ffb878', '#42828b', '#ad0000', '#da7da7', '#c08a00', '#6e4eba', '#d9814d', '#ffb41b', '#00e9af', '#f8bfc6', '#0096bb', '#00ff51', '#516cff', '#00b571', '#ff00a0', '#71b5ff', '#bfc0ff', '#5b0000', '#e3ff9b', '#0000a1', '#7300ad', '#ff5300', '#51ff00', '#00ff00', '#147447', '#6ec06f', '#000051', '#51ffff', '#41ff83', '#ff0052', '#ff00ff'],
    ['#501600', '#423789', '#ff7789', '#896f88', '#c56dc1', '#0051b6', '#89394b', '#ff34c0', '#3fff85', '#425532', '#b6ff00', '#00ffbe', '#00ac00', '#ff3741', '#80ff3f', '#3ac946', '#4aa7ff', '#50004e', '#d17945', '#c1ad8d', '#005263', '#0000ff', '#000051', '#ffe391', '#3cbbb3', '#ff8000', '#8c0085', '#b29c00', '#ff6bff', '#3c38ff', '#c136ff', '#c300c3', '#c30049', '#0075ff', '#c83b83', '#005800', '#8737c2', '#52a400', '#88a4c4', '#4c00c6', '#ffa9ca', '#7dffb8', '#ffd200', '#8400ff', '#4c6cc5', '#9e0000', '#0000a5', '#825a00', '#50ff00', '#00c8ff', '#00ff00', '#ff0000', '#3c8773', '#c7e3cd', '#88dcff', '#cf4100', '#c0ca40', '#00ff52', '#818f40', '#836cff', '#b4ff7e', '#00bc7c', '#ff0080', '#3cffff', '#c2a2ff', '#ffff46', '#77c77a', '#ff00ff'],
    ['#ff2084', '#4a002d', '#878200', '#3e35c2', '#a200ff', '#7349ff', '#c2bf00', '#95b2b5', '#cd00bc', '#9be3ff', '#dac0dc', '#83ffb7', '#4cb573', '#00ffff', '#004f42', '#43007f', '#ff8800', '#bc4500', '#d70045', '#8f0000', '#000052', '#4ac7c8', '#80bd36', '#8a005c', '#ffb543', '#8b51b1', '#00d4af', '#0000ff', '#408136', '#009877', '#c0ff35', '#7c4635', '#d2ffab', '#ff7271', '#44be00', '#b7426c', '#00ff00', '#7d00b8', '#ff00ff', '#00ff5c', '#85ff00', '#ffff66', '#0000ae', '#0055ff', '#ff0000', '#c349ff', '#1d84c0', '#a191ff', '#007b00', '#bbc66e', '#4fffff', '#5200ff', '#cf7cb2', '#004a91', '#ff3fcc', '#ffbb95', '#3dff91', '#ff442e', '#c37e39', '#508eff', '#43ff31', '#00adff', '#00bc2e', '#8b8373', '#3e4400', '#4d5176', '#80ff67', '#ffff00', '#ff80ff'],
    ['#313f00', '#343e7e', '#ff568f', '#687f87', '#bd68cb', '#00759f', '#812e42', '#ff06a6', '#00ffaf', '#4b6940', '#8aff43', '#00ffff', '#00ff52', '#db4745', '#46ff79', '#2dbe00', '#50b0ff', '#770000', '#ff8f49', '#bf9689', '#00313d', '#0000ff', '#400039', '#ffc587', '#00b5db', '#ff5200', '#66007f', '#b0e900', '#ff59ff', '#3b36ff', '#bd2bff', '#b100be', '#b2006d', '#002cbc', '#a64b83', '#007c00', '#7939c3', '#7bac00', '#8ca9c8', '#4300c6', '#ff93c5', '#7bffbb', '#ffae00', '#7900ff', '#4174cc', '#b92900', '#00007a', '#7b5c00', '#5dff00', '#006eff', '#00ff00', '#ff0000', '#42c3b0', '#d2dbc6', '#9be2ff', '#c08100', '#c5c748', '#41b94f', '#978745', '#806eff', '#c0ff82', '#00bf80', '#ff0052', '#52ffff', '#caa3ff', '#ffff4f', '#83c97e', '#ff00ff', '#ffff00', '#008050'],
    ['#ff00af', '#3c002e', '#7b9400', '#7f43e6', '#ac00ff', '#b674ff', '#bec200', '#839175', '#c70078', '#aec6ff', '#dce5bd', '#74bdb5', '#397a77', '#00a3ff', '#004f4e', '#460085', '#ff4000', '#9c4b00', '#ff003c', '#7d0000', '#000060', '#2bcfcf', '#88c83a', '#85004f', '#ff9100', '#b65587', '#00ffa1', '#0000ff', '#388128', '#00af4e', '#c2ff34', '#724e47', '#95ffcf', '#ffaf8c', '#44cf00', '#ff7e4e', '#00ff00', '#8d00b3', '#ff00ff', '#00ff51', '#85ff00', '#ffcd3e', '#0000af', '#3432cf', '#cc0000', '#ca35cd', '#00a39e', '#62aaff', '#005400', '#bbd277', '#54ffff', '#5b00ff', '#bb99af', '#00539d', '#ff69b3', '#ffff7b', '#3ace7d', '#ff3976', '#b48536', '#3b82c7', '#4fff40', '#0055ff', '#00a700', '#c6363e', '#4c4000', '#6a4598', '#7cff83', '#ffff00', '#f3a4e7', '#00ffff', '#ff52ff'],
    ['#ff00ff', '#500000', '#638a00', '#7f5ac1', '#5000ff', '#8892ff', '#a1b800', '#829278', '#ff0061', '#9be1ff', '#f5c5c4', '#7eceb6', '#427095', '#00afff', '#00573c', '#4a007f', '#ff9000', '#803f00', '#ff0000', '#b10000', '#000055', '#449fd5', '#71c83e', '#7e0042', '#d8b938', '#cb3bb8', '#00cbb3', '#0000ff', '#418848', '#009173', '#aaff45', '#493a49', '#bdffbc', '#ffa67a', '#3ed100', '#ca6b78', '#00ff00', '#b80087', '#af00ff', '#00ff77', '#7cff00', '#ffff3b', '#0000af', '#3f2ec0', '#d14d00', '#b04fff', '#007cc0', '#4be3ff', '#008e00', '#b8cc81', '#3cffb5', '#7f00be', '#b594b9', '#004389', '#ff77b9', '#fafb89', '#40bf85', '#ff5d3f', '#a27a33', '#4e5cff', '#38ff3f', '#004eff', '#00c838', '#c22b46', '#304b00', '#893c78', '#6fff7a', '#cdff00', '#db97ff', '#00ffff', '#ff51ff', '#ff00af'],
    ['#344000', '#2a427d', '#ff684d', '#784888', '#ff4faf', '#00b5b4', '#874c3a', '#ff00b0', '#47ffc2', '#417144', '#9eff4d', '#00ffa0', '#00ff51', '#ff4f00', '#4fff4d', '#4dbb24', '#487dff', '#610000', '#b7874b', '#cd8aac', '#00403a', '#0000ff', '#31003e', '#f0e8a5', '#009dff', '#ff9f00', '#580082', '#d6cb32', '#ff4dff', '#5100ff', '#b73bc9', '#b9008a', '#8f0046', '#0067b5', '#c44c7d', '#007900', '#8100c1', '#9fb200', '#3eceff', '#2700bd', '#fe99e7', '#82fffb', '#ffaf6f', '#b000ff', '#4746c9', '#b10000', '#000079', '#677a00', '#b0ff00', '#004dff', '#60ff00', '#ff0000', '#43869b', '#c4d0e4', '#85aeff', '#b36700', '#b7c67e', '#29c575', '#74a466', '#8041ff', '#a4ffae', '#00846a', '#ff0060', '#00ffff', '#ba75ff', '#ffff5d', '#75c2ae', '#ff00ff', '#ffff00', '#00b92f', '#d03037', '#8477c5', '#00ff00'],
    ['#7e3eff', '#c6ff48', '#009d00', '#be00b1', '#3837c8', '#47c3ff', '#ff0000', '#ff4dff', '#7100b9', '#bfc97c', '#adff00', '#004e00', '#835eb8', '#457300', '#7f3f00', '#ffa500', '#009dff', '#746d40', '#7ba772', '#363634', '#3d0080', '#be4f2a', '#7dfbff', '#0073ba', '#bc9e38', '#83ff79', '#be004f', '#fe96e9', '#41ba20', '#710047', '#cd4ac5', '#a9ffbd', '#ba6d73', '#0000ff', '#00ffff', '#86d636', '#ffc847', '#4d507c', '#af0000', '#ff9f8c', '#889c00', '#4691aa', '#ff4e8a', '#ff7747', '#43d78d', '#ebd4bf', '#00cec2', '#00a87e', '#4674ff', '#007245', '#ff0086', '#7ec0c9', '#bac9fb', '#500000', '#ffff80', '#0050ff', '#912b7f', '#ff5500', '#5fff00', '#00d840', '#003e80', '#43ff49', '#00004e', '#3fffcf', '#00ff84', '#ff2942', '#ff00ff', '#b379ff', '#ffff09', '#bd94b7', '#b000ff', '#4e00ff', '#10ff00', '#0000b0'],
    ['#ff00b0', '#5a0000', '#5b8200', '#856ac1', '#823bff', '#ba73ff', '#bfcc00', '#7ab392', '#c2007e', '#91faf2', '#ebabe8', '#8cffa3', '#47798c', '#00b1ff', '#00343b', '#000077', '#b77c00', '#864100', '#ff0000', '#b10000', '#3e0049', '#36b6bb', '#43bb5a', '#8b0046', '#bb9749', '#be8e99', '#00eeb0', '#5000ff', '#2c7441', '#00a983', '#cbff3a', '#7a6b43', '#d0ebc3', '#ffb99a', '#37c700', '#f93c7e', '#00ff00', '#8e00b9', '#b300ff', '#00ff64', '#7aff00', '#ffc046', '#0026ba', '#4641cd', '#ff5000', '#c739c8', '#007fc2', '#5dc5ff', '#008100', '#bed579', '#41ffd5', '#4000a5', '#9fb1d9', '#005980', '#ff71b8', '#ffff00', '#46fc87', '#ff7348', '#7ebb27', '#3f7eff', '#3dff34', '#004fff', '#00bc35', '#ac4a78', '#c53a2e', '#623376', '#83ff56', '#ff9f00', '#ff50ff', '#00ffff', '#ff00ff', '#ff004d', '#0000ff', '#314100', '#ffff77'],
    ['#c344ff', '#89ff42', '#008a34', '#b800b7', '#7b48d9', '#41cbff', '#ff0000', '#ff3bcb', '#6a00b6', '#c0ff7b', '#b0ff00', '#004e00', '#b381d3', '#447400', '#7e3f00', '#ffb100', '#006cc3', '#817c31', '#88b565', '#493e3f', '#80327e', '#ae3f41', '#7affff', '#3d5493', '#c1c734', '#3bcb8a', '#b9006a', '#f0b4d9', '#1fb800', '#7d003d', '#ff466f', '#73ff8c', '#c28165', '#0000ff', '#00ffff', '#7cb700', '#ffe29c', '#438c5c', '#ae0000', '#ff839f', '#bb8b00', '#807c97', '#ff732e', '#ffb25d', '#00c9bf', '#b5ffc9', '#4194c1', '#009881', '#7793ff', '#004b64', '#ff009a', '#7bc8c5', '#b0c7ff', '#4f0000', '#ffff4d', '#3765ff', '#c24b9e', '#d84300', '#5eff00', '#00d743', '#430073', '#4cd23b', '#00004d', '#3affc4', '#00ff86', '#ff004c', '#ff00ff', '#ff73ff', '#ffff00', '#bcb89d', '#a000ff', '#5200ff', '#00ff00', '#00009c', '#009dff', '#292bcf'],
    ['#b561ff', '#9fff00', '#008639', '#cb00c3', '#6e42ea', '#3bc4ff', '#ff0000', '#ff37b5', '#7400ba', '#9bff56', '#edff00', '#005000', '#b391c3', '#378400', '#6a4800', '#ffb500', '#006cb9', '#636f42', '#73ba4f', '#343434', '#a8007e', '#a23c49', '#75ffff', '#2d7a79', '#c8cd32', '#75ff9a', '#d0003c', '#ed97fa', '#2bc729', '#730046', '#d65d7f', '#b0ffce', '#b0894c', '#0000ff', '#00ffff', '#70b900', '#ffbe77', '#723584', '#9b0000', '#ff86b0', '#b69600', '#7b8288', '#ff8a41', '#ff6100', '#00bbc0', '#eccfc3', '#4788c2', '#00bb73', '#758cff', '#003b7d', '#ff007c', '#75c6cb', '#b0c4ff', '#4d0000', '#d5ff8c', '#2148ff', '#a844b9', '#b74900', '#4eff00', '#00ff4e', '#3b007d', '#4fff56', '#00004c', '#39ffcd', '#00ff9b', '#ff3e45', '#ff00ff', '#ff4cff', '#ffff4a', '#a9c083', '#9b00ff', '#4e00ff', '#00ff00', '#0000af', '#008fff', '#3637b6', '#47c28e'],
    ['#ff00b3', '#4f0000', '#476e00', '#846fc7', '#7d3dff', '#b76dff', '#8fbd00', '#81b8b5', '#ff0066', '#8af1ff', '#ffb6c5', '#9eff8b', '#4287a5', '#00d2ff', '#005364', '#440094', '#ddbb00', '#997100', '#b90046', '#9b0000', '#2a2836', '#3fbadf', '#6fc86b', '#6a0053', '#c16e41', '#cc7db7', '#00ffc0', '#4c00ff', '#268a3f', '#009a81', '#d8ff4f', '#72893d', '#c3f0ca', '#ff897d', '#43ba00', '#e04382', '#00ff00', '#b80092', '#b300ff', '#00ff70', '#64ff00', '#ffbe46', '#0000b3', '#493cc7', '#ff0000', '#b534c9', '#008fd4', '#80a2ff', '#009800', '#c5bd90', '#64ffbc', '#7e00c5', '#c9b7fe', '#004db1', '#ff49cb', '#ffff0c', '#31d297', '#ff7600', '#b2ba44', '#4471ff', '#40ff43', '#004dff', '#00cc38', '#973a6b', '#723a22', '#4c4876', '#8eff40', '#b4ff00', '#ff80fd', '#3effff', '#ff0fff', '#ff403c', '#0000ff', '#004c00', '#fef090', '#97847f', '#cf3a00', '#000067'],
    ['#7342ff', '#a6ff46', '#00a900', '#d200c2', '#3435cb', '#39cdff', '#ff0000', '#ff3dc6', '#6900ba', '#b4ff90', '#c6ff00', '#004d00', '#a576e7', '#3b7900', '#b34900', '#ffcc00', '#0074ba', '#848600', '#93bf69', '#6b4219', '#6e3e78', '#ab8142', '#73ffff', '#347185', '#d4c03e', '#69ff88', '#c20041', '#ff74ff', '#43bc23', '#750044', '#a43cb5', '#b3efdb', '#a1808f', '#0000ff', '#00ffff', '#8bd00f', '#ffab7c', '#607f46', '#980000', '#e182b9', '#d28f00', '#676cbd', '#bb4167', '#ff813c', '#00d7be', '#f2cbc1', '#3cabbb', '#00a881', '#4881ff', '#007e40', '#ff0082', '#82b6ff', '#ceb1fe', '#4b0000', '#fffa85', '#004cff', '#9e0086', '#ff5200', '#50ff00', '#00d240', '#2b3f40', '#3eff4a', '#00004e', '#40ffc7', '#00ff7e', '#ff2c43', '#ff00ff', '#cd3aff', '#ffff39', '#86c0b2', '#9b00ff', '#4c00ff', '#00ff00', '#0000b3', '#009bff', '#003981', '#46bd70', '#3e007a', '#ff5d7f'],
    ['#b548ff', '#84ff31', '#008743', '#cb00c8', '#6b42ee', '#35caff', '#ff0000', '#ff35b7', '#7000bb', '#b6ff6a', '#c7ff00', '#00461d', '#a588d9', '#3b6900', '#b74500', '#ffcc00', '#0066c1', '#857f00', '#87bc57', '#723b1b', '#723e7e', '#b48244', '#72ffff', '#2e767f', '#cacb36', '#4dcf90', '#c6003e', '#e599ff', '#4db200', '#71004d', '#a53eb6', '#b5ffc6', '#be7c94', '#0000ff', '#00ffff', '#95c800', '#ffaf7f', '#68754b', '#980000', '#ff82bb', '#cb9500', '#738b94', '#bd3f65', '#ff903b', '#00c9ca', '#edcbc6', '#3798c2', '#00b481', '#628cff', '#003980', '#ff007d', '#75c3cf', '#aecdff', '#4c0000', '#fcfa88', '#2046ff', '#a40086', '#ff5e00', '#4bff00', '#00ad00', '#38374e', '#44ff58', '#00004d', '#3affca', '#05ff91', '#ff313e', '#ff00ff', '#ff51ff', '#ffff3b', '#a9c599', '#9700ff', '#4b00ff', '#00ff00', '#0000b3', '#0092ff', '#3b39b5', '#3cb54b', '#390082', '#ff607a', '#00e648'],
    ['#b54bff', '#b4ff46', '#009700', '#ff00b5', '#7467c1', '#3dc1ff', '#ff0000', '#ff4cb6', '#7034ff', '#bbff91', '#e3ff00', '#004c00', '#bf72bd', '#477e00', '#754200', '#ffb900', '#0083ff', '#798439', '#91bf5f', '#444c3c', '#822f90', '#a0423d', '#67ffff', '#006db4', '#c58347', '#49d789', '#ca0036', '#daa0ff', '#73bc00', '#880056', '#be25be', '#7bffb7', '#947980', '#0038ff', '#00ffff', '#b8c01c', '#ffb24b', '#478574', '#960000', '#ff97bf', '#ac7a00', '#3f9dbc', '#cf3a76', '#ff6d00', '#00ff92', '#dbd8ca', '#00c1d2', '#00ad8b', '#908eff', '#007357', '#ff006a', '#8bb3bb', '#a6d5ff', '#4b0000', '#ffdf88', '#3837cc', '#7e00cc', '#cb3500', '#98ff00', '#00ff00', '#002a44', '#6bff4e', '#000082', '#32ffc9', '#1fff4d', '#ff3e3c', '#ff00ff', '#ff5eff', '#ffff44', '#c9ab8e', '#b500ff', '#3900ff', '#4bff00', '#0000cc', '#4b75ff', '#274283', '#49bd40', '#480095', '#ff7575', '#00bd42', '#3e004a'],
    ['#4c0000', '#424834', '#ff4860', '#3e2595', '#ca73c9', '#0083c6', '#7a396b', '#ff39d0', '#41ffbf', '#48a440', '#96ff41', '#00ffff', '#00ff51', '#ff4714', '#48ff3f', '#3ccc00', '#418bff', '#84003a', '#d67f40', '#74ad7b', '#004f80', '#0000ff', '#002540', '#feec93', '#00b5ff', '#ff8f00', '#3e0054', '#c0b60e', '#ff74ff', '#5b3dff', '#c62fff', '#80009c', '#bc006c', '#002ac1', '#ce3a97', '#004b00', '#913cc3', '#78a300', '#82b3ff', '#4300d8', '#ff8193', '#85fefa', '#ffb85d', '#8a00ff', '#4261c1', '#b30000', '#000081', '#783d00', '#bdff00', '#0051ff', '#71ff00', '#ff0000', '#456e77', '#ffb6c7', '#cdabff', '#b46b00', '#b3bd58', '#00ff9c', '#837139', '#956bff', '#b5ff8b', '#009a80', '#ff0099', '#42daff', '#bdb1a1', '#ffff43', '#6bff80', '#ff00ff', '#ffdc00', '#00bd2b', '#bc3637', '#8287bb', '#00ff00', '#c2e8d3', '#3ab3bd', '#a7747b', '#c100c5', '#368000', '#7fd4ba', '#00743f', '#ff004c', '#31d377'],
    ['#ff26a4', '#4a0000', '#449400', '#7d3ad3', '#434aff', '#8874ff', '#ffff00', '#73d1c4', '#c9007f', '#b3ffc7', '#ff91b4', '#c3b498', '#4796b6', '#00b4ff', '#007849', '#41006d', '#d58900', '#7d7a49', '#c80034', '#940000', '#2c3d45', '#41dcff', '#84bb70', '#87005b', '#bea342', '#c046b7', '#00c8b7', '#4b00ff', '#3db641', '#00ba6e', '#b5ff39', '#3f7b72', '#ffdda2', '#ffab69', '#42dd00', '#d85d3c', '#00ff00', '#8c00a7', '#cc00ca', '#00ff84', '#6aff46', '#ffbd20', '#000095', '#0034ca', '#ff0000', '#c03bff', '#007db8', '#9cbaff', '#006800', '#b66f79', '#82fefe', '#4200b7', '#ddc4dd', '#004983', '#ff627a', '#fffd4c', '#31ffbe', '#ff4a00', '#81bf25', '#4594ff', '#21ff43', '#006aff', '#00b400', '#78437a', '#7b362d', '#414baa', '#7eff8d', '#bfd000', '#d084ff', '#00ffff', '#ff00ff', '#ff2156', '#0000ff', '#8b7f00', '#c6ff7f', '#9085b5', '#b54300', '#00004b', '#ff52e0', '#9600ff', '#444a00', '#84ff00', '#41d186'],
    ['#ff0098', '#4a0000', '#3cac00', '#842ec5', '#5c48ff', '#8487ff', '#ffff00', '#6bc5cc', '#be0079', '#adffce', '#ecb0e2', '#b0b7b6', '#44a199', '#0096ff', '#007b53', '#43004c', '#ff8000', '#b18333', '#ff004e', '#b30000', '#003635', '#34cbff', '#81be79', '#8e003e', '#bfc84d', '#c0439e', '#00c9ca', '#4900ff', '#40a24e', '#00b881', '#b9ff1b', '#5a5e3a', '#ebe5ae', '#ffbe72', '#3fe72b', '#ff7f4c', '#00ff00', '#751d7d', '#c000c4', '#00ff96', '#7bff52', '#ffbf26', '#0000b3', '#2d43c4', '#ff0000', '#c835ff', '#007fb6', '#abc6ff', '#007f00', '#cb8d7e', '#70ffff', '#4b00b4', '#c174d6', '#004488', '#ff7caf', '#ffff4c', '#38ffc8', '#ff3f28', '#7ebf2a', '#4289de', '#00ff4c', '#004aff', '#00bc2c', '#8e646f', '#7d3700', '#475983', '#75ff9c', '#beb800', '#ff6dff', '#00ffff', '#ff00ff', '#ff4076', '#0000ff', '#7b8200', '#baff7e', '#7e79b3', '#c35000', '#00006b', '#ff36cb', '#9300ff', '#314700', '#75ff00', '#3de376', '#be3a48'],
    ['#8049ff', '#b7ff5b', '#00b200', '#db00be', '#b43dca', '#0cb5ff', '#ff0000', '#ff41b4', '#8d00be', '#c1bf83', '#ffff00', '#006a00', '#cdc1f0', '#497c00', '#690000', '#ffb700', '#0090c1', '#7faf00', '#85a348', '#634537', '#823678', '#915300', '#48ffff', '#006c80', '#c88556', '#75ff77', '#da0040', '#ff8de4', '#41bc29', '#8f003f', '#c74a84', '#6fffc1', '#887f89', '#0000ff', '#00ffff', '#c3c72f', '#ffb757', '#468059', '#b40000', '#ffbcac', '#c18c00', '#4489a2', '#b5403e', '#ff7925', '#00ff7e', '#baffc4', '#47c1d5', '#00b681', '#497dff', '#008d40', '#ff007f', '#8ba0ff', '#90eaff', '#353400', '#efff8f', '#3716ce', '#b30080', '#dc4200', '#b4ff00', '#00ff00', '#00443f', '#7fe92f', '#000059', '#24ffbd', '#3dff48', '#ff3e53', '#ff00ff', '#ff4aff', '#ffff4a', '#8ebbb9', '#b600ff', '#6b00ff', '#4aff00', '#0000a2', '#006aff', '#353d71', '#48c476', '#55008d', '#ff7b88', '#00d740', '#460041', '#c387b6', '#674cb9', '#0045be', '#c071ff'],
    ['#ff0089', '#480000', '#43ba00', '#8c33bd', '#4941ff', '#944fff', '#dcff00', '#83c2c1', '#b50045', '#c5fdbc', '#f6c1c6', '#bdc093', '#2b7c7c', '#00ffff', '#006247', '#3a0074', '#da8200', '#b38042', '#ff0041', '#920000', '#363035', '#40b6ff', '#76be79', '#6c0041', '#d5c345', '#b97fd3', '#00c8cd', '#2000ff', '#3ab64d', '#00b97d', '#80ff4a', '#6e7c5d', '#fff08e', '#ff8140', '#45ff1d', '#db4140', '#00ff00', '#820088', '#c500b7', '#00ff94', '#40ff6c', '#ffbf00', '#0000b6', '#233ebe', '#dc0000', '#b500ff', '#0080b7', '#8399ff', '#007700', '#c87989', '#93f7f3', '#4a00bd', '#c3bffc', '#00327f', '#ffa97e', '#ffff43', '#42ffb7', '#ff4200', '#7db82f', '#497cd1', '#00ff48', '#0090ff', '#00bb1e', '#b93081', '#674300', '#5a4088', '#86ff97', '#b5c300', '#f68afe', '#4bffff', '#ff00ff', '#ff497d', '#0044ff', '#908200', '#c2ff6c', '#837ea3', '#b34200', '#00004a', '#ff78b8', '#6b00ff', '#427a22', '#8aff00', '#3db6a7', '#903f42', '#ff2ec3', '#db44ff'],
    ['#7f33ff', '#b7ff3c', '#009137', '#ff48fc', '#5039c6', '#00dcff', '#ff0000', '#ff6fbc', '#8200c8', '#b4ca86', '#ffff00', '#004c00', '#808eff', '#378f00', '#ab4700', '#ffad05', '#0093fb', '#76b600', '#8b8784', '#624600', '#6f3f57', '#b46444', '#41ffff', '#008ab2', '#d0b33f', '#82ff6f', '#ff006b', '#b8bfff', '#40b73e', '#7e0033', '#d036c6', '#81ffb8', '#a94585', '#0000ff', '#00ffbe', '#c2d500', '#febfc0', '#737f2f', '#b60000', '#f192fa', '#bd8c00', '#457975', '#be174e', '#ff7d45', '#00ff71', '#c6eec9', '#4a80bd', '#00b676', '#4365ff', '#006071', '#ff00b4', '#80b7c0', '#88f6ff', '#4b0000', '#eefe91', '#2200be', '#ba0098', '#ff6400', '#86ff00', '#00c200', '#335d34', '#87c146', '#002840', '#40ff96', '#42ff4b', '#ff3336', '#ff00ff', '#b960ff', '#ffff49', '#c296c3', '#b600ff', '#4900ff', '#3cff00', '#00007e', '#42b6ff', '#363283', '#5bbf82', '#74007f', '#ff497e', '#00ff2a', '#3b004e', '#d3827f', '#0041b4', '#0049ff', '#8d62c5', '#2cc4bb', '#ffbc77'],
    ['#ff00f7', '#490000', '#4a7e00', '#8a36cf', '#655dff', '#7ba5ff', '#b7ff00', '#89baba', '#ff00ad', '#bfffc0', '#f0c9c5', '#bcce89', '#3ba09d', '#00b5ff', '#007c4a', '#2b0085', '#ff6b00', '#8a853d', '#ff0064', '#c0003e', '#283d49', '#2dffc8', '#7bb474', '#500046', '#c7ad30', '#b77fb8', '#00c0b7', '#4000ff', '#40b547', '#00bd6f', '#90dd34', '#4f7366', '#f6f98e', '#ff8344', '#3ec500', '#bc5141', '#00ff00', '#82007d', '#b900c1', '#00ff8f', '#4aff40', '#ffff00', '#0000bf', '#2e49d4', '#ff0000', '#c228ff', '#0076b1', '#45d5ff', '#007f00', '#c48970', '#82fdff', '#5d00bc', '#bacdf7', '#003c87', '#ffb181', '#ffd742', '#73ffb7', '#ff3731', '#81ac00', '#3993e5', '#00ff47', '#006bff', '#00be25', '#935682', '#7d4900', '#513d94', '#84ff72', '#ffb500', '#eb95fe', '#00ffff', '#ff4fff', '#ff4f7c', '#0023ff', '#b67800', '#c7ff54', '#6c75b9', '#ca3100', '#000049', '#ff81b9', '#8800ff', '#234100', '#6bff00', '#44e686', '#753d47', '#de40be', '#ad6fff', '#c42081', '#930000'],
    ['#694600', '#414b69', '#b8ba6f', '#691e3e', '#b54dbe', '#008388', '#b24b00', '#ff73b7', '#5effb9', '#3f9b6b', '#a5ff7c', '#00ffff', '#00ff49', '#ff7647', '#76ff43', '#3bd63d', '#4b7dff', '#990000', '#be9131', '#818782', '#003482', '#0000ff', '#293320', '#fde799', '#00afc3', '#ff8b00', '#500000', '#beef3a', '#fe7cff', '#253fff', '#ff2cc6', '#7c007d', '#ab0046', '#0000b5', '#bb2681', '#006c00', '#7b05c6', '#cec500', '#af7bff', '#4c00ff', '#f5b8d0', '#13ffb8', '#ffbc35', '#a800ff', '#0055c2', '#e20000', '#00004c', '#45772c', '#94ff00', '#007fff', '#4bff00', '#ff4400', '#3f6fa7', '#bdc4fd', '#72baff', '#878800', '#7fb737', '#39ff7a', '#896142', '#7b41ff', '#c3fcbf', '#00d283', '#ff008b', '#26bfff', '#bf95af', '#ffff55', '#71cf7b', '#ff00ff', '#ffff00', '#00a846', '#d53b3e', '#77439a', '#00ff00', '#90faf3', '#7e80c9', '#c36d71', '#c600be', '#4bb100', '#8ecabd', '#005f48', '#ff0041', '#48b9b4', '#00b600', '#320080', '#d33dff', '#ff477e', '#ffa37f', '#4affff', '#3c29bc'],
    ['#834300', '#3a2b48', '#c7bc61', '#923c76', '#b637b7', '#007dca', '#c13f25', '#ff41d1', '#47ffc3', '#458445', '#b6ff76', '#00ffff', '#00ff48', '#ff8f58', '#6eff3f', '#36cf41', '#377dff', '#b70000', '#c5892b', '#84a069', '#003284', '#0000ff', '#3b2900', '#d9efb5', '#00aeff', '#ff9100', '#710015', '#c9ff30', '#ff77ff', '#4534ff', '#ba00e8', '#70005e', '#b60048', '#0000b6', '#bf7572', '#006c00', '#6e3bc4', '#cfc800', '#b991ff', '#4600c8', '#f0b4da', '#21bfc0', '#ffd037', '#7600ff', '#2540bf', '#ff0000', '#00004b', '#4a7100', '#92ff00', '#004bff', '#4aff00', '#ff4700', '#0e7b82', '#b6d8f0', '#73a5ff', '#8c8c00', '#96c52c', '#31ff7d', '#87673f', '#8360ff', '#aeb5a6', '#00ffb5', '#da247a', '#3cd7ff', '#cf78be', '#ffff6f', '#74e37f', '#ff00ff', '#ffff00', '#00c980', '#ff4948', '#8c75a4', '#00ff00', '#91ffbb', '#477fb9', '#ff5e8f', '#8800a3', '#53b700', '#6abebd', '#009f44', '#ff0048', '#41ae82', '#00b700', '#340083', '#c644ff', '#ff00ae', '#ffbb92', '#79ffff', '#4f577e', '#005745'],
    ['#734800', '#484841', '#ff725c', '#6c4780', '#da3ac2', '#0090bc', '#914542', '#ff49ff', '#52ffb9', '#3dbe46', '#c1ff60', '#00ffff', '#00ff49', '#ff4700', '#7cff49', '#3fff24', '#3e92ff', '#6e0000', '#b85c00', '#93848d', '#00347f', '#0000ff', '#2c3900', '#fffa84', '#00b6ff', '#ff8d00', '#4f003f', '#9dbf3f', '#e78dff', '#2d36ff', '#ff00b5', '#7a007c', '#a80046', '#0000b7', '#ba487f', '#007200', '#700aff', '#bfb300', '#9e8bff', '#4700c7', '#fabbc9', '#1ad4c2', '#e5bb3d', '#b600ff', '#0047c5', '#b70000', '#00004a', '#408318', '#c4ff00', '#006eff', '#7cff00', '#ff0000', '#257071', '#d1f2bb', '#c0caf4', '#818d00', '#be7e40', '#41ff71', '#73864d', '#6f54ff', '#92ff98', '#00ff90', '#c90087', '#72c3ff', '#c48cc1', '#ffff3b', '#71c977', '#ff00ff', '#ffd600', '#00b87e', '#d93b3c', '#9249bf', '#00ff00', '#91ffe3', '#6c85ca', '#ff70a4', '#9800bc', '#52c400', '#90c2bf', '#009540', '#ff004c', '#3fa49c', '#0bb800', '#320082', '#b747ff', '#ff3280', '#ffb181', '#48ffff', '#4747be', '#004738', '#b8bf84'],
    ['#bf20bd', '#490000', '#419000', '#8246c5', '#5339ff', '#8073ff', '#c2ff00', '#adacac', '#bb0077', '#c9d5e0', '#ff97c0', '#b0ffaa', '#00a58e', '#00a8ff', '#006f5d', '#400091', '#be9a00', '#83923e', '#ff003c', '#c50000', '#093135', '#3dbbe1', '#79b87a', '#3f0047', '#cdcc33', '#c26ac0', '#00d2c6', '#0000ff', '#47b73f', '#00b648', '#87db3d', '#436f40', '#f8dcaa', '#ff993d', '#3cd800', '#c57146', '#00ff00', '#842e82', '#7e00b8', '#00ff90', '#47ff3e', '#ffff23', '#0000b4', '#3c52bf', '#ff2b00', '#c700ff', '#0079c7', '#80bcff', '#006a00', '#dab475', '#4affff', '#3f00da', '#bf95ff', '#004297', '#ff787f', '#ffff6a', '#75d6bb', '#ff7500', '#7eb700', '#6c8fbe', '#00ff47', '#3779ff', '#00b100', '#937680', '#7f493f', '#404378', '#70ff7b', '#ffc000', '#ff76ff', '#00ffff', '#ff2fff', '#ff1382', '#004aff', '#806c00', '#b7ff62', '#428983', '#c34f00', '#00006a', '#ff46b5', '#8000ff', '#3f4700', '#7aff00', '#36d281', '#86003f', '#ff00c8', '#ba46ff', '#c1293b', '#872400', '#91ffee', '#cb4681', '#3affb9', '#ff4948'],
    ['#c445d5', '#b7ff3c', '#198e00', '#da00c2', '#6d3cbf', '#00b7ff', '#ff2400', '#ff3bae', '#4700bc', '#8fff78', '#ffff00', '#004b00', '#fc90f1', '#475200', '#822c00', '#ffb600', '#0084cc', '#52882c', '#96c034', '#68413e', '#7e547f', '#967a46', '#4affff', '#00437a', '#dcc23e', '#47ff81', '#bd0068', '#c5befb', '#34ca30', '#8c0037', '#c03c8e', '#6cffbf', '#cb8078', '#0000ff', '#00ffff', '#c1da00', '#ffbb7d', '#89988d', '#be0000', '#ff83aa', '#877200', '#3c6d6b', '#c03f48', '#c39010', '#00c5af', '#f2c9c2', '#40a29a', '#00c45f', '#4541ff', '#007d3f', '#ff0086', '#4ac0db', '#90effe', '#480000', '#eefe91', '#0c27c6', '#9200bf', '#c34a00', '#66be00', '#00d200', '#233e3d', '#61ff3f', '#000046', '#24ffc2', '#00ff85', '#ff003d', '#ff00ff', '#ff49ff', '#ffff4a', '#90c1c8', '#b400ff', '#6400ff', '#3aff00', '#00008e', '#3585ff', '#432982', '#63c365', '#79007d', '#ff4367', '#00ff37', '#470049', '#bccb8e', '#315faf', '#0051ff', '#bc87be', '#008985', '#ff8346', '#9d82ff', '#8d3cff', '#ff6f00', '#b8ffc2', '#83ff00', '#6b82cc'],
    ['#700000', '#446043', '#ffad49', '#9e4171', '#c655a7', '#00ab92', '#814430', '#ff78c2', '#3eff81', '#66c133', '#c0ff6d', '#00ffec', '#00ff5d', '#ff673f', '#3eff3a', '#39d700', '#368dff', '#b80000', '#c18328', '#938492', '#008d53', '#0000ff', '#40162f', '#fef090', '#0086d0', '#ff8c00', '#94003e', '#85ff46', '#e996fe', '#4121ff', '#c224ff', '#8400a9', '#bb007a', '#002ac5', '#ff467d', '#034700', '#3c00bb', '#95c100', '#7f9fff', '#00008d', '#eacac9', '#27c6c5', '#dac312', '#8300ff', '#3657ce', '#ff0000', '#000046', '#4c4900', '#b9ff00', '#0052ff', '#74ff00', '#ff4500', '#006390', '#b9ffc2', '#b7cafc', '#b74800', '#abc049', '#2fc261', '#82864d', '#6a5aff', '#82ff92', '#00ffa5', '#ff008e', '#00baff', '#b998cc', '#ffff49', '#6fbe7d', '#ff00ff', '#ffff00', '#00c82b', '#ce3340', '#674e9b', '#00ff00', '#88fef7', '#5a93c0', '#d07f6f', '#c900c0', '#877c00', '#86ccc5', '#008e00', '#ff0048', '#3f8580', '#449200', '#5d006e', '#b067ff', '#ff30c2', '#ffa88f', '#51ffc6', '#2d3379', '#004845', '#bbc090', '#923bcf', '#ff53ff', '#4dd4ff'],
    ['#c141df', '#c1ff28', '#008224', '#c900ba', '#8453c0', '#00b7ff', '#ff4600', '#ff36bc', '#3f00b8', '#bbff6f', '#ffff00', '#004600', '#ff8cf1', '#3d8800', '#bb000e', '#ffba35', '#0080b9', '#608a3e', '#84cf63', '#63413d', '#83447b', '#a06a3f', '#40e3ff', '#004589', '#baab44', '#81ff98', '#bc0075', '#bdd1ef', '#3ec427', '#8b0044', '#c33e9a', '#84ffe6', '#cf7b76', '#0000ff', '#00ffff', '#d3c700', '#ffaf7b', '#898a7a', '#ff0000', '#ff7cac', '#776100', '#426472', '#cc3343', '#af8c00', '#42f17a', '#f6c3c4', '#588aad', '#00c247', '#4347ff', '#00876c', '#ff008c', '#2ebac8', '#7cbbff', '#423200', '#faf390', '#0031cc', '#8400c8', '#b94600', '#84bd1a', '#00c000', '#144645', '#61ff3d', '#00004a', '#47ffbf', '#00ff6b', '#ff0047', '#ff00ff', '#ff48ff', '#ffff4a', '#84c1b9', '#ba00ff', '#4c00ff', '#3dff00', '#00009a', '#398eff', '#351b73', '#3dac73', '#730086', '#ff4475', '#00ff24', '#440032', '#bbbe8e', '#4048b3', '#0063ff', '#b784b8', '#00c493', '#ff7342', '#bb8cff', '#852eff', '#ff8d00', '#c0ffb9', '#86ff00', '#7a72ff', '#00ffb7', '#760000'],
    ['#3b2900', '#77565b', '#ff3a71', '#7b3f9d', '#b850bb', '#00bca8', '#933425', '#ff47b8', '#77ff86', '#7a9437', '#b5ff65', '#00ffd7', '#00ff48', '#ff6000', '#47ff51', '#37c828', '#477cff', '#740000', '#ff7244', '#7bb575', '#007274', '#0000ff', '#28003a', '#e8ff96', '#00c5ff', '#ffa800', '#6f0047', '#b6ab00', '#da7dff', '#1d40ff', '#8f00ff', '#930084', '#b70047', '#0036a1', '#b73b76', '#005100', '#6d00c0', '#71c000', '#947bff', '#2200c1', '#ff8cc4', '#36bdd3', '#ffb945', '#4800ff', '#0077b9', '#b90000', '#000075', '#6f6300', '#90ff00', '#007eff', '#47ff00', '#ff0e00', '#3f799a', '#e3cfcb', '#b5c9ff', '#b96500', '#bbb555', '#00ff90', '#b77047', '#6b3fff', '#b0ffcb', '#00bb5d', '#db0085', '#3cffff', '#b997c6', '#ffff52', '#83df3e', '#da00ff', '#ffff00', '#3e9559', '#dc382d', '#9e7b8b', '#00ff00', '#82fdff', '#738fc5', '#e47886', '#b500c3', '#388e00', '#77d5c0', '#3c5b31', '#ff0046', '#3ace83', '#00b800', '#470082', '#b63dff', '#ff00c2', '#ffba8c', '#3effb5', '#344071', '#003a42', '#b2ce98', '#3f3fc3', '#ff3fff', '#6eb9ff', '#c7e824', '#008530'],
    ['#705300', '#5c6178', '#ff6c64', '#913388', '#bf42c9', '#00be89', '#89393d', '#ff6bbf', '#3bff93', '#3bb03d', '#c0ff45', '#00ffb9', '#00d538', '#ff4700', '#7aff50', '#3ad300', '#00b9ff', '#7a0000', '#d7953c', '#8a957f', '#003382', '#0000ff', '#420030', '#eaeca7', '#0095c2', '#ff9f00', '#760060', '#beb800', '#f08ffe', '#2938ff', '#ba00ff', '#bd0073', '#bc002d', '#0000b1', '#dc3d8b', '#313100', '#6d00a7', '#76af00', '#47b9ff', '#3b00d8', '#ffb0c4', '#2ecac0', '#ffce33', '#7300ff', '#0045c6', '#ad3300', '#000046', '#927e2a', '#b9ff00', '#0071ff', '#72ff00', '#ff0000', '#0e7984', '#c6c5f3', '#889dff', '#c87400', '#bcc268', '#39ff37', '#b36362', '#5072ff', '#b3fdcd', '#00ff70', '#ff008d', '#00ffff', '#bb88d5', '#ffff67', '#74d68a', '#ff00ff', '#ffff00', '#008c42', '#dd3c3c', '#8469b4', '#00ff00', '#88e4ff', '#3f76ba', '#d48b92', '#b200b8', '#3d8500', '#6daac0', '#425b36', '#ff0047', '#44a482', '#00ac00', '#330075', '#995aff', '#ff26c6', '#ffbc78', '#6cffc4', '#3d34a4', '#00463f', '#aec1ac', '#663bdc', '#ff4cff', '#46ffff', '#80bc45', '#006400', '#aeff87'],
    ['#af1dc1', '#470000', '#31bd00', '#6e3bca', '#4233ff', '#737aff', '#ffff00', '#84bc86', '#f600b8', '#c3d2e8', '#fcb0d2', '#99ffb9', '#0c7288', '#00b8ff', '#004600', '#35008a', '#ff4500', '#828709', '#ff005e', '#ca002e', '#253738', '#45babe', '#47bb43', '#4c0047', '#c57800', '#8abacc', '#00b9b8', '#0000ff', '#007443', '#00b471', '#d3ff34', '#467544', '#def0af', '#ff816d', '#47ff00', '#c07f46', '#00ff00', '#c60087', '#883e8a', '#00ff72', '#7bff37', '#ffc945', '#0000b6', '#233db9', '#ff0000', '#b900ff', '#0077ce', '#5bbcff', '#008c00', '#c5bc68', '#45ffff', '#4100cf', '#c4a4a9', '#002d7e', '#ff73b1', '#ffff72', '#50ffb9', '#ff7e27', '#74cb00', '#4974c1', '#34ff45', '#2f85ff', '#00cc2e', '#8c7aac', '#6f3c47', '#41467c', '#75ff7d', '#b9bc00', '#ff79ff', '#00ffff', '#ff00ff', '#ff368e', '#0046ff', '#774300', '#b9ff76', '#489783', '#bd3300', '#000047', '#c45fd0', '#7200ff', '#3d6a00', '#a5ff00', '#39db80', '#8f0058', '#ff3cdd', '#9b40ff', '#b63b52', '#8e0000', '#8af4ff', '#c66389', '#09ffb9', '#fa4247', '#ffb900', '#8cb43d', '#847b67', '#b790ff', '#7700a3', '#ffbe8e'],
    ['#620000', '#815350', '#d97581', '#733a90', '#ba54ff', '#00ab77', '#75113f', '#ff45ba', '#47ff88', '#7c8823', '#bfff34', '#00ffba', '#00d33d', '#ff7a45', '#7aff55', '#41a53c', '#14bbff', '#a80000', '#b88e00', '#829667', '#005b6a', '#0000ff', '#330033', '#f7f393', '#00b9bc', '#ff8b00', '#4d0077', '#c7d200', '#f48bff', '#3236ff', '#b10eff', '#93007d', '#b90043', '#003ace', '#b43b78', '#323400', '#7400bb', '#5cbc00', '#5dbcff', '#3600d3', '#e8cacb', '#3edbc5', '#ffc428', '#6c00ff', '#0076aa', '#ef0000', '#000062', '#74460b', '#8eff00', '#006dff', '#46ff00', '#ff4500', '#486e7d', '#bcb8ff', '#8b89ff', '#b84600', '#cabf55', '#36ff43', '#b97d45', '#457cff', '#beffc0', '#00ff74', '#dc0080', '#00ffff', '#bd85cd', '#ffff4f', '#82d38b', '#ff00ff', '#ffff00', '#008c38', '#da3e3c', '#7e7da9', '#00ff00', '#91eeff', '#3c95be', '#a744bd', '#ba00bc', '#437a00', '#8dbbcb', '#3b573c', '#ff0045', '#44b481', '#00b400', '#0000a8', '#7646ff', '#ff00b9', '#ff8abb', '#79ffc1', '#2a3494', '#003232', '#beb299', '#4e53c7', '#ff46ff', '#46ffff', '#90ca2d', '#006400', '#b7ff7b', '#ffb080', '#ff3a76'],
    ['#463a00', '#57597a', '#ff7a59', '#95428c', '#c046c3', '#00ba92', '#943225', '#ff6dc2', '#42ffb6', '#619937', '#bbff3a', '#00ffd2', '#00ff47', '#ff4032', '#75ff43', '#3ed636', '#188cff', '#760000', '#c9762f', '#89908a', '#007f6c', '#0000ff', '#3b0024', '#ffe485', '#0083be', '#ff7000', '#74004c', '#c4da00', '#f193fa', '#4125ff', '#c424ff', '#a50087', '#ba0045', '#0026c6', '#c9405c', '#004600', '#61008d', '#68c200', '#55c2ff', '#3a00c6', '#eec6ca', '#2ac0c9', '#ffb500', '#8a00e9', '#3355d0', '#bc0000', '#000047', '#7a6700', '#8aff00', '#004bff', '#45ff00', '#ff0e00', '#18488f', '#b4e0e9', '#96a5ff', '#a69a00', '#c3a762', '#3fff6f', '#8e6950', '#5d7dff', '#cffeb0', '#00ff8c', '#ff008d', '#00cdff', '#c093c8', '#ffff45', '#6fcf7e', '#ff00ff', '#ffff00', '#00ba47', '#cb4400', '#8570c8', '#00ff00', '#7bffff', '#498aaa', '#ca718c', '#c600c4', '#3b8400', '#74bbc1', '#3e5d3a', '#ff0047', '#37a86d', '#10bc00', '#00008b', '#8042ff', '#ff27c5', '#ffa192', '#88ffb9', '#382261', '#004547', '#afc49c', '#6b30c0', '#ff4dff', '#35ffff', '#97c536', '#008022', '#a2ff7b', '#ffba44', '#ff4587', '#b968ff'],
]


def initialize_colors(n, seed=42):
    # Set the seed for reproducibility
    np.random.seed(seed)
    # Initialize n random colors
    colors = np.random.rand(n, 3)
    for i in range(0, n):
        if (np.sum(colors[i]) > LIGHTEST_THRESHOLD):
            colors[i] = colors[i] / np.sum(colors[i]) * LIGHTEST_THRESHOLD
    return colors


def maximize_color_separation(colors, iterations=2000):
    n = len(colors)
    black = np.array([0, 0, 0])
    white = np.array([1, 1, 1])
    for _ in range(iterations):
        for i in range(n):
            current_color = colors[i]
            # Calculate distances from the current color to all other colors
            distances = np.sqrt(np.sum((colors - current_color) ** 2, axis=1))
            distances[i] = np.inf  # Ignore self-distance

            # Calculate distances from the extremes (black and white)
            distance_to_black = np.sqrt(np.sum((current_color - black) ** 2))
            distance_to_white = np.sqrt(np.sum((current_color - white) ** 2))

            # Find the closest color or extreme
            closest_distance = np.min(distances)
            closest_color = colors[np.argmin(distances)]

            # Determine the repulsion from closest color or extreme
            if closest_distance < distance_to_black and closest_distance < distance_to_white:
                direction = current_color - closest_color
            elif distance_to_black < distance_to_white:
                direction = current_color - black
            else:
                direction = current_color - white

            # Push away slightly from the closest threat
            colors[i] += direction * 0.02

            # Keep the color components within the adjusted range
            # colors[i] = np.clip(colors[i], 0, 0.9)
            colors[i] = np.clip(colors[i], 0, 1)
            if (np.sum(colors[i]) > LIGHTEST_THRESHOLD):
                colors[i] = colors[i] / np.sum(colors[i]) * LIGHTEST_THRESHOLD
    return colors


def plot_colors(hex_colors:list[str]) -> None:
    """
    Plot the generated colors. hex_colors is a list of hex str, in #rrggbb format
    """
    plt.figure(figsize=(12, 2), facecolor='#b8b8b8')
    for i, hex_color in enumerate(hex_colors):
        plt.fill_between([i, i+1], 0, 1, color=hex_color)
    plt.xlim(0, len(hex_colors))
    plt.axis('off')
    plt.show()

def score_colors(colors):
    black = np.array([0, 0, 0])
    white = np.array([1, 1, 1])
    score = 0

    for color in colors:
        distances = np.linalg.norm(colors - color, axis=1)
        distance_to_black = np.linalg.norm(color - black)
        distance_to_white = np.linalg.norm(color - white)

        min_distance = min(np.min(distances[distances > 0]), distance_to_black, distance_to_white)
        score += 1 / min_distance**5  # Add more penalty to very close colors

    return score

def np_to_hex(colors):
    result = []
    for color in colors:
        r = round(color[0] * 255)
        g = round(color[1] * 255)
        b = round(color[2] * 255)
        result.append(f'#{r:02x}{g:02x}{b:02x}')
    return result

def generate_colors(num: int, trial: int = 10, fixed=False) -> list[str]:
    '''
    Generate the colors of num variables, each of them as different as possible
    
    Colors are put in RGB 3D space, will try to make the straight-line distance between each two of them as large as possible
    
    Will return a list of str, each str is a color in hex format (#rrggbb), can be passed in to add_graph directly
    
    Parameters:
    
    1. num: the number of variables
    2. trail: will try to generate trail times, and find the best one
    3. fixed: if True, the result will become deterministic
    '''
    best_score = 10 * 100000000000
    best_colors = None
    if (fixed):
        seeds = list(range(1000, 1000 + trial * 10, 10))
    else:
        seeds = []
        for i in range(0, trial):
            seeds.append(randint(0, 1000000))
    for seed in seeds:
        colors = initialize_colors(num, seed)
        colors = maximize_color_separation(colors)
        score = score_colors(colors)
        if score < best_score:
            best_score = score
            best_colors = colors
    return np_to_hex(best_colors)

if __name__ == "__main__":
    colors = generate_colors(10, 10)
    plot_colors(colors)

