# flake8: noqa
# generated by datamodel-codegen:
#   filename:  signhost_openapi.yml
#   timestamp: 2023-02-09T16:34:43+00:00

from __future__ import annotations

from datetime import date
from datetime import datetime
from typing import Any
from typing import Dict
from typing import List
from typing import Optional

from pydantic import BaseModel
from pydantic import Field

from signhost.models.enums import Betrouwbaarheidsniveau1
from signhost.models.enums import Code
from signhost.models.enums import FormSetType
from signhost.models.enums import Language
from signhost.models.enums import Rel
from signhost.models.enums import Status
from signhost.models.enums import Type
from signhost.models.verifications import Verification
from signhost.models.verifications import VerificationAnnotatedType


class Activity(BaseModel):
    Id: Optional[str] = None
    Code: Optional[Code] = Field(
        None,
        description="* 101 -\tInvitation sent\n"
        "* 102 -\tReceived\n"
        "* 103 -\tOpened\n"
        "* 104 -\tReminder sent\n"
        "* 105 -\tDocument opened, Info property contains the file id of the opened document.\n"
        "* 201 -\tCancelled\n"
        "* 202 -\tRejected\n"
        "* 203 -\tSigned\n"
        "* 301 -\tSigned document sent\n"
        "* 302 -\tSigned document opended\n"
        "* 303 -\tSigned document downloaded\n"
        "* 401 -\tReceipt sent\n"
        "* 402 -\tReceipt opened\n"
        "* 403 -\tReceipt downloaded\n",
    )
    Info: Optional[str] = Field(
        None,
        description="May contain additional information belonging to this activity",
    )
    CreatedDateTime: Optional[datetime] = None


class Receiver(BaseModel):
    Name: str = Field(..., description="The name of the receiver.")
    Email: str = Field(..., description="The e-mail address of the reveiver.")
    Language: Optional[str] = Field(
        "nl-NL",
        description="The language of the receiver, only de-DE, en-US, es-ES, fr-FR, it-IT and nl-NL are allowed.",
    )
    Subject: Optional[str] = Field(
        None,
        description="The subject of the receiver email in plain text.\n"
        "Maximum of 64 characters allowed.\n"
        "Omitting this parameter will enable the default subject.\n",
    )
    Message: str = Field(
        ...,
        description="The email message towards the receiver in plain text."
        " Newlines can be created by including a \\n in the json, HTML is not allowed.",
    )
    Reference: Optional[str] = Field(None, description="The reference of the receiver.")
    Context: Optional[Dict[str, Any]] = Field(
        None,
        description="Any valid json object which we will return back to you when "
        "doing a GET on the transaction or when we send a postback.",
    )


class Authentication(BaseModel):
    Type: Type = Field(
        ...,
        description="Type of the authentication object.\n"
        "The `Type` property **must** be the first property in the json!\n\n"
        "The order in which the authentications are provided determine "
        "in which order the signer will have to perform the specified method.\n",
    )


class Link(BaseModel):
    Rel: Optional[Rel] = Field(None, description="The type of file you can download.")
    Type: Optional[str] = Field(
        None,
        description="The type of the file you can expect to download. "
        "Include this in your 'Accept' header when requesting the file.",
    )
    Link: Optional[str] = Field(
        None, description="Url containing the link to the file."
    )


class Signers(BaseModel):
    FormSets: Optional[List[str]] = Field(
        None, description="List of formset keys to be assigned to this signer."
    )


class Location(BaseModel):
    Search: Optional[str] = Field(
        None,
        description="The text to search in the pdf document to use as "
        "the position for the field. For example `{{Signer1}}`.",
    )
    Occurence: Optional[int] = Field(
        None, description="When using text search, only match this matched occurence."
    )
    Top: Optional[int] = Field(
        None, description="Offset from the top of the search text or the page"
    )
    Right: Optional[int] = Field(
        None, description="Offset from the right of the search or the page"
    )
    Bottom: Optional[int] = Field(
        None, description="Offset from the bottom of the search or the page"
    )
    Left: Optional[int] = Field(
        None, description="Offset from the left of the search or the page"
    )
    Width: Optional[int] = Field(
        None,
        description="The width of the field, can’t be used when both Left and Right are specified.\n"
        "For signature and seal fields we suggest a width of 140.\n",
    )
    Height: Optional[int] = Field(
        None,
        description="The height of the field, can’t be used when both Bottom and Top are specified.\n"
        "For signature and seal fields we suggest a height of 70.\n",
    )
    PageNumber: Optional[int] = Field(
        None, description="On which page the field should be placed."
    )


class FormSets(BaseModel):
    Type: Optional[FormSetType] = Field(
        None,
        description="Field type to create.\n"
        "\n"
        "* Seal is not yet implemented, this will specify the properties of a seal.\n"
        "* Signature, specifies a signature field\n"
        "* Check, specifies a checkbox. You'll have to set the `value` property\n"
        "* SingleLine, specifies a single line textbox\n",
    )
    Location: Optional[Location] = Field(
        None,
        description="Specify where the field should be placed within the document.",
    )


class FileMetaData(BaseModel):
    DisplayOrder: Optional[int] = Field(
        None, description="With what order number we'll display the file to the signer"
    )
    DisplayName: Optional[str] = Field(
        None, description="With what name we'll display the file to the signer"
    )
    SetParaph: Optional[bool] = Field(
        None,
        description=(
            "Places a copy of the signer's scribble image on the bottom right of every page where no signature is "
            "present.\n"
            "Note: due to the nature of advanced or qualified digital signatures, paraphs are merely a cosmetic "
            "addition.\n"
        ),
    )
    Signers: Optional[Dict[str, Signers]] = Field(
        None,
        description="Map of array of formsets.\nEach key should be a valid signer id.\n",
    )
    FormSets: Optional[Dict[str, Dict[str, FormSets]]] = Field(
        None,
        description="Map of one or more form set definitions.\n"
        "The key of the map will be the formset name.\n"
        "The value will be the formset definition\n",
    )


class ErrorModel(BaseModel):
    Message: Optional[str] = Field(
        None, description="Message describing the error in the request."
    )


class DigiDAuthentication(Authentication):
    Bsn: Optional[str] = Field(
        None,
        description="The provided value must match the BSN of the credentials returned by DigiD.\n"
        "The BSN is required to match an '11-proef'.\n",
    )
    Betrouwbaarheidsniveau: Optional[Betrouwbaarheidsniveau1] = Field(
        None,
        description="The level of confidence with which the identity of the signer has been determined.\n"
        "For further information, please refer to [Logius](https://www.logius.nl/diensten/digid/hoe-werkt-het).\n",
    )


class PhoneNumberAuthentication(Authentication):
    Number: Optional[str] = Field(
        None,
        description="The mobile phone number of the signer.\n"
        "Must conform to E.164,\n"
        "[the international public telecommunication numbering plan](https://en.wikipedia.org/wiki/E.164),\n"
        "which requires the country calling code (e.g. +31).\n",
        example="+31123456789",
    )


class EIDASLogin(Verification):
    Uid: Optional[str] = Field(
        None, description="The unique identifier returned by eIDAS Login."
    )
    Level: Optional[str] = Field(None, description="The Level of Assurance.")
    FirstName: Optional[str] = Field(
        None, description="The first name of the signer as returned by eIDAS Login."
    )
    LastName: Optional[str] = Field(
        None, description="The last name of the signer as returned by eIDAS Login."
    )
    DateOfBirth: Optional[date] = Field(
        None, description="The date of birth of the signer as returned by eIDAS Login."
    )
    Attributes: Optional[List[str]] = Field(
        None,
        description="Contains all available eIDAS Login attributes.\n"
        "These attributes may change, therefore we cannot guarantee the availability of any of these attributes.\n",
    )


class ItsmeIdentification(Verification):
    PhoneNumber: Optional[str] = Field(
        None,
        description="The mobile phone number of the signer.\n"
        "Must be conform E.164,\n"
        "[the international public telecommunication numbering plan](https://en.wikipedia.org/wiki/E.164),\n"
        "which requires the country calling code (Only the Belgian country calling code is supported: +32).\n",
        example="+32123456789",
    )
    Attributes: Optional[List[str]] = Field(
        None,
        description="Contains all available itsme Identification attributes.\n"
        "These attributes may change, therefore we cannot guarantee the availability of any of these attributes.\n",
    )


class ItsmeSign(Verification):
    Issuer: Optional[str] = None
    Subject: Optional[str] = None
    Thumbprint: Optional[str] = None


class ZealiDQualified(Verification):
    Issuer: Optional[str] = None
    Subject: Optional[str] = None
    Thumbprint: Optional[str] = None


class Signer(BaseModel):
    Id: Optional[str] = Field(
        None,
        description="The id of the signer, must be unique within a transaction.\n"
        "If you don't provide an id we will generate one for you.\n",
    )
    Email: str = Field(
        ...,
        description="The e-mail address of the signer",
        example="john.doe@example.com",
    )
    IntroText: Optional[str] = Field(
        None,
        description="An intro text to show to the user during the sign proces.\n"
        "This will be shown on the first screen to the signer and supports limitted markdown markup.\n\n"
        "The following markup is supported:"
        "\n- `# Headings`"
        "\n- `*Emphasis*` / `_Emphasis_`"
        "\n- `**Stong**` / `__Strong__`"
        "\n- `1. Ordered` and `- Unordered` lists\n",
    )
    Authentications: Optional[List[Authentication]] = Field(
        None,
        description="List of authentications that the signer has to authenticate with.\n"
        "The order in which the authentications are provided determine in which order "
        "the signer will have to perform the specified method.\n\n"
        "Authentications must be performed before the document(s) can be viewed.\n\n"
        "You **must** explicitly specify the API-version when using this feature.\n"
        "This is done with the header: 'Accept: application/vnd.signhost.v1+json'.\n",
    )
    Verifications: Optional[List[VerificationAnnotatedType]] = Field(
        None,
        description="List of verifications that the signer has to verify with.\n"
        "The order in which the verifications are provided determine in "
        "which order the signer will have to perform the specified method.\n\n"
        "Verifications must be performed before the document(s) can be signed.\n\n"
        "You **must** use one of the following verifications as the last method:"
        "\n- Consent\n"
        "- itsme sign*\n"
        "- PhoneNumber\n"
        "- Scribble\n"
        "- SigningCertificate*\n"
        "- ZealiD Qualified*\n\n"
        "* These verifications can not be used in any other position than the last.\n",
    )
    SendSignRequest: Optional[bool] = Field(
        True, description="Send a sign invitation to the signer his e-mail address."
    )
    SignUrl: Optional[str] = Field(
        None,
        description="A unique URL per signer that provides the signing flow for the signer."
        "\nAvailable / valid if `SendSignRequest` is set to false.\n",
    )
    SignRequestSubject: Optional[str] = Field(
        None,
        description="The subject of the sign request email in plain text."
        "\nMaximum of 64 characters allowed."
        "\nOmitting this parameter will enable the default subject.\n",
    )
    SignRequestMessage: Optional[str] = Field(
        None,
        description="The message of the sign request in plain text."
        "\nNewlines can be created by including a \\n in the json, HTML is not allowed."
        "\nRequired if `SendSignRequest` is true\n",
    )
    SendSignConfirmation: Optional[bool] = Field(
        None,
        description="Send the sign confirmation to the signer his e-mail address."
        "\nDefault value is the value of `SendSignRequest`\n",
    )
    Language: Optional[Language] = Field(
        "nl-NL",
        description="The language of the receiving user, "
        "only de-DE, en-US, es-ES, fr-FR, it-IT, pl-PL and nl-NL are allowed.",
    )
    ScribbleName: Optional[str] = Field(
        None,
        description="The name of the signer, this will be pre filled in the scribble form.",
    )
    DaysToRemind: Optional[int] = Field(
        7,
        description="Amount of days before reminding the signers. -1 to disable reminders.\n"
        "Ignored if `SendSignRequest` is set to false."
        "\nBy default your organisation's setting will be used.\n",
    )
    Expires: Optional[datetime] = Field(
        None,
        description="When set the signer is no longer allowed to sign the transaction after this date.",
    )
    Reference: Optional[str] = Field(None, description="The reference of the signer.")
    RejectReason: Optional[str] = Field(
        None,
        description="The rejection reason that was given by the signer when the transaction was rejected.",
    )
    ReturnUrl: Optional[str] = Field(
        "https://signhost.com",
        description="The url to redirect the user to after signing, rejecting or cancelling.",
    )
    Context: Optional[Dict[str, Any]] = Field(
        None,
        description="Any valid json object which we will return back to you"
        " when doing a GET on the transaction or when we send a postback.",
    )
    Activities: Optional[List[Activity]] = Field(
        None,
        description="List of activities attached to this signer.\n"
        "Activities are added by signhost when a signer event occured.\n",
    )


class FileEntry(BaseModel):
    Links: Optional[List[Link]] = None
    DisplayName: Optional[str] = Field(
        None,
        description="The name of the document that was displayed to the user while signing the documents.",
    )


class Transaction(BaseModel):
    Id: Optional[str] = Field(
        None,
        description="The id of the transaction.\n"
        "Currently this property is read only but this may change in the future.\n",
    )
    Files: Optional[Dict[str, FileEntry]] = Field(
        None, description="A map of files attached to this transaction."
    )
    Language: Optional[Language] = Field(
        None,
        description="The language of the sender notifications and the receipt,"
        " only de-DE, en-US, es-ES, fr-FR, it-IT, pl-PL and nl-NL are allowed.",
    )
    Seal: Optional[bool] = Field(
        False, description="Seal the document before sending to the signers."
    )
    Signers: Optional[List[Signer]] = Field(None, description="The signer information.")
    Receivers: Optional[List[Receiver]] = None
    Reference: Optional[str] = Field(
        None, description='The reference of the transaction. For example "1234"'
    )
    PostbackUrl: Optional[str] = Field(
        None,
        description="The absolute url to postback the status updates. For example https://example.com/postback.php",
    )
    SignRequestMode: Optional[int] = Field(
        2,
        description="Set to 1 for sending at once, to 2 for sequential.\n"
        "Ignored if `SendSignRequest` is set to false.\n",
    )
    DaysToExpire: Optional[int] = Field(
        60, description="Amount of days before expiration. Max 90 days."
    )
    SendEmailNotifications: Optional[bool] = Field(
        True, description="Send e-mail notifications to the sender."
    )
    Status: Optional[Status] = Field(
        None,
        description="Current transaction status.\n\n"
        "* 5 - Waiting for document\n"
        "* 10 - Waiting for signer\n"
        "* 20 - In progress\n"
        "* 30 - Signed (end state)\n"
        "* 40 - Rejected (end state)\n"
        "* 50 - Expired (end state)\n"
        "* 60 - Cancelled (end state)\n"
        "* 70 - Failed (end state)\n",
    )
    CancelationReason: Optional[str] = Field(
        None, description="The original cancellation reason given during a DELETE call."
    )
    Context: Optional[Dict[str, Any]] = Field(
        None,
        description="Any valid json object which we will return back to you "
        "when doing a GET on the transaction or when we send a postback.",
    )
