# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.

from aliyunsdkcore.request import RpcRequest
from aliyunsdkccc.endpoint import endpoint_data

class ListAgentEventsRequest(RpcRequest):

	def __init__(self):
		RpcRequest.__init__(self, 'CCC', '2017-07-05', 'ListAgentEvents')
		self.set_method('POST')
		if hasattr(self, "endpoint_map"):
			setattr(self, "endpoint_map", endpoint_data.getEndpointMap())
		if hasattr(self, "endpoint_regional"):
			setattr(self, "endpoint_regional", endpoint_data.getEndpointRegional())


	def get_StartTime(self):
		return self.get_query_params().get('StartTime')

	def set_StartTime(self,StartTime):
		self.add_query_param('StartTime',StartTime)

	def get_StopTime(self):
		return self.get_query_params().get('StopTime')

	def set_StopTime(self,StopTime):
		self.add_query_param('StopTime',StopTime)

	def get_RamIds(self):
		return self.get_query_params().get('RamId')

	def set_RamIds(self, RamIds):
		for depth1 in range(len(RamIds)):
			if RamIds[depth1] is not None:
				self.add_query_param('RamId.' + str(depth1 + 1) , RamIds[depth1])

	def get_InstanceId(self):
		return self.get_query_params().get('InstanceId')

	def set_InstanceId(self,InstanceId):
		self.add_query_param('InstanceId',InstanceId)

	def get_Events(self):
		return self.get_query_params().get('Event')

	def set_Events(self, Events):
		for depth1 in range(len(Events)):
			if Events[depth1] is not None:
				self.add_query_param('Event.' + str(depth1 + 1) , Events[depth1])