"""
Exceptions for the Nextcloud API.
"""
from httpx import codes


class NextcloudException(Exception):
    status_code: int
    reason: str

    def __init__(self, status_code: int = 0, reason: str = "", info: str = ""):
        super(BaseException, self).__init__()
        self.status_code = status_code
        self.reason = reason
        self.info = info

    def __str__(self):
        reason = f" {self.reason}" if self.reason else ""
        info = f" <{self.info}>" if self.info else ""
        return f"[{self.status_code}]{reason}{info}"


def check_error(code: int, info: str = ""):
    if 996 <= code <= 999:
        if code == 996:
            phrase = "Server error"
        elif code == 997:
            phrase = "Unauthorised"
        elif code == 998:
            phrase = "Not found"
        else:
            phrase = "Unknown error"
        raise NextcloudException(code, reason=phrase, info=info)
    if not codes.is_error(code):
        return
    raise NextcloudException(code, reason=codes(code).phrase, info=info)
