# Official Nextcloud Python Framework

[![Analysis & Coverage](https://github.com/cloud-py-api/nc_py_api/actions/workflows/analysis-coverage.yml/badge.svg)](https://github.com/cloud-py-api/nc_py_api/actions/workflows/analysis-coverage.yml)
[![Docs](https://github.com/cloud-py-api/nc_py_api/actions/workflows/docs.yml/badge.svg)](https://cloud-py-api.github.io/nc_py_api/)
[![codecov](https://codecov.io/github/cloud-py-api/nc_py_api/branch/main/graph/badge.svg?token=C91PL3FYDQ)](https://codecov.io/github/cloud-py-api/nc_py_api)

![NextcloudVersion](https://img.shields.io/badge/Nextcloud-26%20%7C%2027%20%7C%2028-blue)
![PythonVersion](https://img.shields.io/badge/python-3.9%20%7C%203.10%20%7C%203.11%20%7C%203.12-blue)
![impl](https://img.shields.io/pypi/implementation/nc_py_api)
![pypi](https://img.shields.io/pypi/v/nc_py_api.svg)

### Remark

Project cloud-py-api was **abandoned** and divided into two parts:
 * `nc_py_api` - this repository, which contains Python Framework to work with Nextcloud and `app_ecosystem_v2`
 * `app_ecosystem_v2` - New [Nextcloud Application Ecosystem](https://github.com/cloud-py-api/app_ecosystem_v2) that allows writing applications for Nextcloud in any language

**_Projects stage: under heavy prototyping and developing_**

### Basic Features:
 * Listing, enabling and disabling of the applications
 * Operations with Files and Folders
 * ~~Operations with Trash bin and File versions~~
 * Operations with Users and User Groups
 * User status manipulation
 * Weather status
 * ~~Nextcloud notifications support~~
 * ~~Shares operations support~~
 * ~~Talk support~~

### Extended Features with installed App_ecosystem_v2:
 * Defining callback routes with FastAPI for Nextcloud
 * Registering UI elements in Nextcloud
 * Storing logs to the `nextcloud.log` file
 * Get/save key-value pairs in AppConfigEx/PreferencesEx tables.
 * **Tons of the cool stuff that is coming soon**

### 🚀 How to start

In very close near future we will publish examples

### More Information

- [Documentation](https://nc_py_api.readthedocs.io/)
  - [Using it as a simple client](to-do)
  - [Writing a simple Nextcloud application](to-do)
  - [Writing a Nextcloud system application](to-do)
- [Examples](https://github.com/cloud-py-api/nc_py_api/tree/main/examples)
- [Contribute](https://github.com/cloud-py-api/nc_py_api/blob/main/.github/CONTRIBUTING.md)
  - [Discussions](https://github.com/cloud-py-api/nc_py_api/discussions)
  - [Issues](https://github.com/cloud-py-api/nc_py_api/issues)
  - [Setting up dev environment](to-do)
- [Changelog](https://github.com/cloud-py-api/nc_py_api/blob/main/CHANGELOG.md)
