# nuaudit-python-autogen
Nanaged Audit Trails for Cloud Applications.

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.15.0
- Package version: 0.15.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python >= 3.6

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import nuaudit_python_autogen
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import nuaudit_python_autogen
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import nuaudit_python_autogen
from pprint import pprint
from nuaudit_python_autogen.api import api_clients_api
from nuaudit_python_autogen.model.api_client import APIClient
from nuaudit_python_autogen.model.api_client_mutation import APIClientMutation
from nuaudit_python_autogen.model.error_message import ErrorMessage
from nuaudit_python_autogen.model.http_validation_error import HTTPValidationError
from nuaudit_python_autogen.model.role import Role
# Defining the host is optional and defaults to https://api.nuaudit.com/api
# See configuration.py for a list of all supported configuration parameters.
configuration = nuaudit_python_autogen.Configuration(
    host = "https://api.nuaudit.com/api"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: APIKeyHeader
configuration.api_key['APIKeyHeader'] = 'YOUR_API_KEY'

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['APIKeyHeader'] = 'Bearer'


# Enter a context with an instance of the API client
with nuaudit_python_autogen.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = api_clients_api.APIClientsApi(api_client)
    organization_id = "organization_id_example" # str | 
api_client_mutation = APIClientMutation(
        name="name_example",
    ) # APIClientMutation | 

    try:
        # Create Api Client
        api_response = api_instance.create_api_client(organization_id, api_client_mutation)
        pprint(api_response)
    except nuaudit_python_autogen.ApiException as e:
        print("Exception when calling APIClientsApi->create_api_client: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *https://api.nuaudit.com/api*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*APIClientsApi* | [**create_api_client**](docs/APIClientsApi.md#create_api_client) | **POST** /{organization_id}/api_clients | Create Api Client
*APIClientsApi* | [**delete_api_client**](docs/APIClientsApi.md#delete_api_client) | **DELETE** /{organization_id}/api_clients/{api_client_id} | Delete Api Client
*APIClientsApi* | [**get_api_client**](docs/APIClientsApi.md#get_api_client) | **GET** /{organization_id}/api_clients/{api_client_id} | Get Api Client
*APIClientsApi* | [**list_api_clients**](docs/APIClientsApi.md#list_api_clients) | **GET** /{organization_id}/api_clients | List Api Clients
*APIClientsApi* | [**list_roles_for_api_client**](docs/APIClientsApi.md#list_roles_for_api_client) | **GET** /{organization_id}/api_clients/{api_client_id}/roles | List Roles For Api Client
*APIClientsApi* | [**update_api_client**](docs/APIClientsApi.md#update_api_client) | **PUT** /{organization_id}/api_clients/{api_client_id} | Update Api Client
*APIKeysApi* | [**create_api_key**](docs/APIKeysApi.md#create_api_key) | **POST** /{organization_id}/api_clients/{api_client_id}/api_keys | Create Api Key
*APIKeysApi* | [**delete_api_key**](docs/APIKeysApi.md#delete_api_key) | **DELETE** /{organization_id}/api_clients/{api_client_id}/api_keys/{api_key_id} | Delete Api Key
*APIKeysApi* | [**list_api_keys_for_api_client**](docs/APIKeysApi.md#list_api_keys_for_api_client) | **GET** /{organization_id}/api_clients/{api_client_id}/api_keys | List Api Keys For Api Client
*APIKeysApi* | [**update_api_key**](docs/APIKeysApi.md#update_api_key) | **PUT** /{organization_id}/api_clients/{api_client_id}/api_keys/{api_key_id} | Update Api Key
*ActorsApi* | [**get_actor**](docs/ActorsApi.md#get_actor) | **GET** /{organization_id}/actors/{actor_id} | Get Actor
*ActorsApi* | [**list_actors**](docs/ActorsApi.md#list_actors) | **GET** /{organization_id}/actors | List Actors
*InvitesApi* | [**accept_invite**](docs/InvitesApi.md#accept_invite) | **POST** /accept_invite | Accept Invite
*InvitesApi* | [**create_invite**](docs/InvitesApi.md#create_invite) | **POST** /{organization_id}/invites | Create Invite
*InvitesApi* | [**delete_invite**](docs/InvitesApi.md#delete_invite) | **DELETE** /{organization_id}/invites/{invite_id} | Delete Invite
*InvitesApi* | [**list_invites**](docs/InvitesApi.md#list_invites) | **GET** /{organization_id}/invites | List Invites
*OrganizationsApi* | [**create_organization**](docs/OrganizationsApi.md#create_organization) | **POST** /organizations | Create Organization
*OrganizationsApi* | [**delete_organization**](docs/OrganizationsApi.md#delete_organization) | **DELETE** /organizations/{organization_id} | Delete Organization
*OrganizationsApi* | [**list_organizations**](docs/OrganizationsApi.md#list_organizations) | **GET** /organizations | List Organizations
*PermissionsApi* | [**add_permissions**](docs/PermissionsApi.md#add_permissions) | **POST** /{organization_id}/roles/{role_id}/permissions | Add Permissions
*PermissionsApi* | [**remove_permissions**](docs/PermissionsApi.md#remove_permissions) | **DELETE** /{organization_id}/roles/{role_id}/permissions | Remove Permissions
*RecordsApi* | [**create_record**](docs/RecordsApi.md#create_record) | **POST** /{organization_id}/trails/{trail_id}/records | Create Record
*RecordsApi* | [**list_actor_records**](docs/RecordsApi.md#list_actor_records) | **GET** /{organization_id}/actors/{actor_id}/records | List Actor Records
*RecordsApi* | [**list_records**](docs/RecordsApi.md#list_records) | **GET** /{organization_id}/records | List Records
*RecordsApi* | [**list_resource_records**](docs/RecordsApi.md#list_resource_records) | **GET** /{organization_id}/resources/{resource_id}/records | List Resource Records
*RecordsApi* | [**list_trail_records**](docs/RecordsApi.md#list_trail_records) | **GET** /{organization_id}/trails/{trail_id}/records | List Trail Records
*ResourcesApi* | [**get_resource**](docs/ResourcesApi.md#get_resource) | **GET** /{organization_id}/resources/{resource_id} | Get Resource
*ResourcesApi* | [**list_resources**](docs/ResourcesApi.md#list_resources) | **GET** /{organization_id}/resources | List Resources
*RolesApi* | [**add_api_client_to_role**](docs/RolesApi.md#add_api_client_to_role) | **PUT** /{organization_id}/roles/{role_id}/api_clients/{api_client_id} | Add Api Client To Role
*RolesApi* | [**add_user_to_role**](docs/RolesApi.md#add_user_to_role) | **PUT** /{organization_id}/roles/{role_id}/users/{user_id} | Add User To Role
*RolesApi* | [**create_role**](docs/RolesApi.md#create_role) | **POST** /{organization_id}/roles | Create Role
*RolesApi* | [**delete_role**](docs/RolesApi.md#delete_role) | **DELETE** /{organization_id}/roles/{role_id} | Delete Role
*RolesApi* | [**list_api_clients_for_role**](docs/RolesApi.md#list_api_clients_for_role) | **GET** /{organization_id}/roles/{role_id}/api_clients | List Api Clients For Role
*RolesApi* | [**list_roles**](docs/RolesApi.md#list_roles) | **GET** /{organization_id}/roles | List Roles
*RolesApi* | [**list_users_for_role**](docs/RolesApi.md#list_users_for_role) | **GET** /{organization_id}/roles/{role_id}/users | List Users For Role
*RolesApi* | [**remove_api_client_from_role**](docs/RolesApi.md#remove_api_client_from_role) | **DELETE** /{organization_id}/roles/{role_id}/api_clients/{api_client_id} | Remove Api Client From Role
*RolesApi* | [**remove_user_from_role**](docs/RolesApi.md#remove_user_from_role) | **DELETE** /{organization_id}/roles/{role_id}/users/{user_id} | Remove User From Role
*RolesApi* | [**update_role**](docs/RolesApi.md#update_role) | **PUT** /{organization_id}/roles/{role_id} | Update Role
*SettingsApi* | [**get_settings_for_organization**](docs/SettingsApi.md#get_settings_for_organization) | **GET** /{organization_id}/settings | Get Settings For Organization
*SettingsApi* | [**update_settings_for_organization**](docs/SettingsApi.md#update_settings_for_organization) | **PUT** /{organization_id}/settings | Update Settings For Organization
*TrailsApi* | [**create_trail**](docs/TrailsApi.md#create_trail) | **POST** /{organization_id}/trails | Create Trail
*TrailsApi* | [**delete_trail**](docs/TrailsApi.md#delete_trail) | **DELETE** /{organization_id}/trails/{trail_id} | Delete Trail
*TrailsApi* | [**get_trail**](docs/TrailsApi.md#get_trail) | **GET** /{organization_id}/trails/{trail_id} | Get Trail
*TrailsApi* | [**list_trails**](docs/TrailsApi.md#list_trails) | **GET** /{organization_id}/trails | List Trails
*TrailsApi* | [**update_trail**](docs/TrailsApi.md#update_trail) | **PUT** /{organization_id}/trails/{trail_id} | Update Trail
*UsageAndBillingApi* | [**create_stripe_setup_intent**](docs/UsageAndBillingApi.md#create_stripe_setup_intent) | **POST** /organizations/{organization_id}/billing/stripe_setup_intent | Create Stripe Setup Intent
*UsageAndBillingApi* | [**delete_payment_method**](docs/UsageAndBillingApi.md#delete_payment_method) | **DELETE** /organizations/{organization_id}/billing/payment_methods/{payment_method_id} | Delete Payment Method
*UsageAndBillingApi* | [**get_billing**](docs/UsageAndBillingApi.md#get_billing) | **GET** /organizations/{organization_id}/billing | Get Billing
*UsageAndBillingApi* | [**list_usage**](docs/UsageAndBillingApi.md#list_usage) | **GET** /organizations/{organization_id}/usage | List Usage
*UsageAndBillingApi* | [**update_billing**](docs/UsageAndBillingApi.md#update_billing) | **PUT** /organizations/{organization_id}/billing | Update Billing
*UsersApi* | [**list_roles_for_user**](docs/UsersApi.md#list_roles_for_user) | **GET** /{organization_id}/users/{user_id}/roles | List Roles For User
*UsersApi* | [**list_users**](docs/UsersApi.md#list_users) | **GET** /{organization_id}/users | List Users


## Documentation For Models

 - [APIClient](docs/APIClient.md)
 - [APIClientMutation](docs/APIClientMutation.md)
 - [APIKey](docs/APIKey.md)
 - [APIKeyMutation](docs/APIKeyMutation.md)
 - [AcceptInviteMutation](docs/AcceptInviteMutation.md)
 - [Actor](docs/Actor.md)
 - [ActorRecord](docs/ActorRecord.md)
 - [ActorRecordMutation](docs/ActorRecordMutation.md)
 - [Billing](docs/Billing.md)
 - [BillingMutation](docs/BillingMutation.md)
 - [ErrorMessage](docs/ErrorMessage.md)
 - [HTTPValidationError](docs/HTTPValidationError.md)
 - [Indexes](docs/Indexes.md)
 - [Invite](docs/Invite.md)
 - [InviteMutation](docs/InviteMutation.md)
 - [InviteStatus](docs/InviteStatus.md)
 - [Metadata](docs/Metadata.md)
 - [Organization](docs/Organization.md)
 - [OrganizationMutation](docs/OrganizationMutation.md)
 - [PaymentMethod](docs/PaymentMethod.md)
 - [Permission](docs/Permission.md)
 - [PermissionDeletion](docs/PermissionDeletion.md)
 - [PermissionMutation](docs/PermissionMutation.md)
 - [Record](docs/Record.md)
 - [RecordMutation](docs/RecordMutation.md)
 - [Resource](docs/Resource.md)
 - [ResourceRecord](docs/ResourceRecord.md)
 - [ResourceRecordMutation](docs/ResourceRecordMutation.md)
 - [Role](docs/Role.md)
 - [RoleMutation](docs/RoleMutation.md)
 - [Scope](docs/Scope.md)
 - [Settings](docs/Settings.md)
 - [Trail](docs/Trail.md)
 - [TrailMutation](docs/TrailMutation.md)
 - [Usage](docs/Usage.md)
 - [User](docs/User.md)
 - [ValidationError](docs/ValidationError.md)


## Documentation For Authorization


## APIKeyHeader

- **Type**: API key
- **API key parameter name**: X-API-Key
- **Location**: HTTP header


## Author

support@nuaudit.com


## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in nuaudit_python_autogen.apis and nuaudit_python_autogen.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from nuaudit_python_autogen.api.default_api import DefaultApi`
- `from nuaudit_python_autogen.model.pet import Pet`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import nuaudit_python_autogen
from nuaudit_python_autogen.apis import *
from nuaudit_python_autogen.models import *
```

