"""
    Digital Model API (WIP)

    Digital Model API documentation  # noqa: E501

    The version of the OpenAPI document: 0.8.12
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from swx_sdk.api_client import ApiClient, Endpoint as _Endpoint
from swx_sdk.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from swx_sdk.model.thing_status_list_response import ThingStatusListResponse
from swx_sdk.model.thing_status_response import ThingStatusResponse


class ItemsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __list_items(
            self,
            space,
            collection_name,
            **kwargs
        ):
            """List items  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_items(space, collection_name, async_req=True)
            >>> result = thread.get()

            Args:
                space (str):
                collection_name (str):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ThingStatusListResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['space'] = \
                space
            kwargs['collection_name'] = \
                collection_name
            return self.call_with_http_info(**kwargs)

        self.list_items = _Endpoint(
            settings={
                'response_type': (ThingStatusListResponse,),
                'auth': [],
                'endpoint_path': '/spaces/{space}/collections/{collection-name}/things-status',
                'operation_id': 'list_items',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'space',
                    'collection_name',
                ],
                'required': [
                    'space',
                    'collection_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'space':
                        (str,),
                    'collection_name':
                        (str,),
                },
                'attribute_map': {
                    'space': 'space',
                    'collection_name': 'collection-name',
                },
                'location_map': {
                    'space': 'path',
                    'collection_name': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__list_items
        )

        def __show_item(
            self,
            space,
            collection_name,
            thing_id,
            **kwargs
        ):
            """Show item  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.show_item(space, collection_name, thing_id, async_req=True)
            >>> result = thread.get()

            Args:
                space (str):
                collection_name (str):
                thing_id (str):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ThingStatusResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['space'] = \
                space
            kwargs['collection_name'] = \
                collection_name
            kwargs['thing_id'] = \
                thing_id
            return self.call_with_http_info(**kwargs)

        self.show_item = _Endpoint(
            settings={
                'response_type': (ThingStatusResponse,),
                'auth': [],
                'endpoint_path': '/spaces/{space}/collections/{collection-name}/things-status/{thing-id}',
                'operation_id': 'show_item',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'space',
                    'collection_name',
                    'thing_id',
                ],
                'required': [
                    'space',
                    'collection_name',
                    'thing_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'space':
                        (str,),
                    'collection_name':
                        (str,),
                    'thing_id':
                        (str,),
                },
                'attribute_map': {
                    'space': 'space',
                    'collection_name': 'collection-name',
                    'thing_id': 'thing-id',
                },
                'location_map': {
                    'space': 'path',
                    'collection_name': 'path',
                    'thing_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__show_item
        )
