# coding: utf-8

"""
    CyberSource Merged Spec

    All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html

    OpenAPI spec version: 0.0.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class Ptsv2paymentsRecurringPaymentInformation(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'end_date': 'str',
        'frequency': 'int',
        'number_of_payments': 'int',
        'original_purchase_date': 'str',
        'sequence_number': 'int'
    }

    attribute_map = {
        'end_date': 'endDate',
        'frequency': 'frequency',
        'number_of_payments': 'numberOfPayments',
        'original_purchase_date': 'originalPurchaseDate',
        'sequence_number': 'sequenceNumber'
    }

    def __init__(self, end_date=None, frequency=None, number_of_payments=None, original_purchase_date=None, sequence_number=None):
        """
        Ptsv2paymentsRecurringPaymentInformation - a model defined in Swagger
        """

        self._end_date = None
        self._frequency = None
        self._number_of_payments = None
        self._original_purchase_date = None
        self._sequence_number = None

        if end_date is not None:
          self.end_date = end_date
        if frequency is not None:
          self.frequency = frequency
        if number_of_payments is not None:
          self.number_of_payments = number_of_payments
        if original_purchase_date is not None:
          self.original_purchase_date = original_purchase_date
        if sequence_number is not None:
          self.sequence_number = sequence_number

    @property
    def end_date(self):
        """
        Gets the end_date of this Ptsv2paymentsRecurringPaymentInformation.
        The date after which no further recurring authorizations should be performed. Format: `YYYY-MM-DD` **Note** This field is required for recurring transactions. 

        :return: The end_date of this Ptsv2paymentsRecurringPaymentInformation.
        :rtype: str
        """
        return self._end_date

    @end_date.setter
    def end_date(self, end_date):
        """
        Sets the end_date of this Ptsv2paymentsRecurringPaymentInformation.
        The date after which no further recurring authorizations should be performed. Format: `YYYY-MM-DD` **Note** This field is required for recurring transactions. 

        :param end_date: The end_date of this Ptsv2paymentsRecurringPaymentInformation.
        :type: str
        """

        self._end_date = end_date

    @property
    def frequency(self):
        """
        Gets the frequency of this Ptsv2paymentsRecurringPaymentInformation.
        Integer value indicating the minimum number of days between recurring authorizations. A frequency of monthly is indicated by the value 28. Multiple of 28 days will be used to indicate months.  Example: 6 months = 168  Example values accepted (31 days): - 31 - 031 - 0031  **Note** This field is required for recurring transactions. 

        :return: The frequency of this Ptsv2paymentsRecurringPaymentInformation.
        :rtype: int
        """
        return self._frequency

    @frequency.setter
    def frequency(self, frequency):
        """
        Sets the frequency of this Ptsv2paymentsRecurringPaymentInformation.
        Integer value indicating the minimum number of days between recurring authorizations. A frequency of monthly is indicated by the value 28. Multiple of 28 days will be used to indicate months.  Example: 6 months = 168  Example values accepted (31 days): - 31 - 031 - 0031  **Note** This field is required for recurring transactions. 

        :param frequency: The frequency of this Ptsv2paymentsRecurringPaymentInformation.
        :type: int
        """

        self._frequency = frequency

    @property
    def number_of_payments(self):
        """
        Gets the number_of_payments of this Ptsv2paymentsRecurringPaymentInformation.
        Total number of payments for the duration of the recurring subscription. 

        :return: The number_of_payments of this Ptsv2paymentsRecurringPaymentInformation.
        :rtype: int
        """
        return self._number_of_payments

    @number_of_payments.setter
    def number_of_payments(self, number_of_payments):
        """
        Sets the number_of_payments of this Ptsv2paymentsRecurringPaymentInformation.
        Total number of payments for the duration of the recurring subscription. 

        :param number_of_payments: The number_of_payments of this Ptsv2paymentsRecurringPaymentInformation.
        :type: int
        """

        self._number_of_payments = number_of_payments

    @property
    def original_purchase_date(self):
        """
        Gets the original_purchase_date of this Ptsv2paymentsRecurringPaymentInformation.
        Date of original purchase. Required for recurring transactions. Format: `YYYY-MM-DDTHH:MM:SSZ` **Note**: If this field is empty, the current date is used. 

        :return: The original_purchase_date of this Ptsv2paymentsRecurringPaymentInformation.
        :rtype: str
        """
        return self._original_purchase_date

    @original_purchase_date.setter
    def original_purchase_date(self, original_purchase_date):
        """
        Sets the original_purchase_date of this Ptsv2paymentsRecurringPaymentInformation.
        Date of original purchase. Required for recurring transactions. Format: `YYYY-MM-DDTHH:MM:SSZ` **Note**: If this field is empty, the current date is used. 

        :param original_purchase_date: The original_purchase_date of this Ptsv2paymentsRecurringPaymentInformation.
        :type: str
        """

        self._original_purchase_date = original_purchase_date

    @property
    def sequence_number(self):
        """
        Gets the sequence_number of this Ptsv2paymentsRecurringPaymentInformation.
        This field is mandatory for Cartes Bancaires recurring transactions on Credit Mutuel-CIC.       This field records recurring sequence, e.g. 1st for initial,  2 for subsequent, 3 etc 

        :return: The sequence_number of this Ptsv2paymentsRecurringPaymentInformation.
        :rtype: int
        """
        return self._sequence_number

    @sequence_number.setter
    def sequence_number(self, sequence_number):
        """
        Sets the sequence_number of this Ptsv2paymentsRecurringPaymentInformation.
        This field is mandatory for Cartes Bancaires recurring transactions on Credit Mutuel-CIC.       This field records recurring sequence, e.g. 1st for initial,  2 for subsequent, 3 etc 

        :param sequence_number: The sequence_number of this Ptsv2paymentsRecurringPaymentInformation.
        :type: int
        """

        self._sequence_number = sequence_number

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, Ptsv2paymentsRecurringPaymentInformation):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
