"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BitBucketSourceCredentials = exports.GitHubEnterpriseSourceCredentials = exports.GitHubSourceCredentials = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const codebuild_generated_1 = require("./codebuild.generated");
/**
 * The source credentials used when contacting the GitHub API.
 *
 * **Note**: CodeBuild only allows a single credential for GitHub
 * to be saved in a given AWS account in a given region -
 * any attempt to add more than one will result in an error.
 *
 * @stability stable
 * @resource AWS::CodeBuild::SourceCredential
 */
class GitHubSourceCredentials extends core_1.Resource {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        super(scope, id);
        new codebuild_generated_1.CfnSourceCredential(this, 'Resource', {
            serverType: 'GITHUB',
            authType: 'PERSONAL_ACCESS_TOKEN',
            token: props.accessToken.toString(),
        });
    }
}
exports.GitHubSourceCredentials = GitHubSourceCredentials;
_a = JSII_RTTI_SYMBOL_1;
GitHubSourceCredentials[_a] = { fqn: "@aws-cdk/aws-codebuild.GitHubSourceCredentials", version: "1.94.0" };
/**
 * The source credentials used when contacting the GitHub Enterprise API.
 *
 * **Note**: CodeBuild only allows a single credential for GitHub Enterprise
 * to be saved in a given AWS account in a given region -
 * any attempt to add more than one will result in an error.
 *
 * @stability stable
 * @resource AWS::CodeBuild::SourceCredential
 */
class GitHubEnterpriseSourceCredentials extends core_1.Resource {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        super(scope, id);
        new codebuild_generated_1.CfnSourceCredential(this, 'Resource', {
            serverType: 'GITHUB_ENTERPRISE',
            authType: 'PERSONAL_ACCESS_TOKEN',
            token: props.accessToken.toString(),
        });
    }
}
exports.GitHubEnterpriseSourceCredentials = GitHubEnterpriseSourceCredentials;
_b = JSII_RTTI_SYMBOL_1;
GitHubEnterpriseSourceCredentials[_b] = { fqn: "@aws-cdk/aws-codebuild.GitHubEnterpriseSourceCredentials", version: "1.94.0" };
/**
 * The source credentials used when contacting the BitBucket API.
 *
 * **Note**: CodeBuild only allows a single credential for BitBucket
 * to be saved in a given AWS account in a given region -
 * any attempt to add more than one will result in an error.
 *
 * @stability stable
 * @resource AWS::CodeBuild::SourceCredential
 */
class BitBucketSourceCredentials extends core_1.Resource {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        super(scope, id);
        new codebuild_generated_1.CfnSourceCredential(this, 'Resource', {
            serverType: 'BITBUCKET',
            authType: 'BASIC_AUTH',
            username: props.username.toString(),
            token: props.password.toString(),
        });
    }
}
exports.BitBucketSourceCredentials = BitBucketSourceCredentials;
_c = JSII_RTTI_SYMBOL_1;
BitBucketSourceCredentials[_c] = { fqn: "@aws-cdk/aws-codebuild.BitBucketSourceCredentials", version: "1.94.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic291cmNlLWNyZWRlbnRpYWxzLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsic291cmNlLWNyZWRlbnRpYWxzLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQUEsd0NBQXNEO0FBRXRELCtEQUE0RDs7Ozs7Ozs7Ozs7QUFxQjVELE1BQWEsdUJBQXdCLFNBQVEsZUFBUTs7OztJQUNuRCxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFFLEtBQW1DO1FBQzNFLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFFakIsSUFBSSx5Q0FBbUIsQ0FBQyxJQUFJLEVBQUUsVUFBVSxFQUFFO1lBQ3hDLFVBQVUsRUFBRSxRQUFRO1lBQ3BCLFFBQVEsRUFBRSx1QkFBdUI7WUFDakMsS0FBSyxFQUFFLEtBQUssQ0FBQyxXQUFXLENBQUMsUUFBUSxFQUFFO1NBQ3BDLENBQUMsQ0FBQztJQUNMLENBQUM7O0FBVEgsMERBVUM7Ozs7Ozs7Ozs7Ozs7QUFzQkQsTUFBYSxpQ0FBa0MsU0FBUSxlQUFROzs7O0lBQzdELFlBQVksS0FBZ0IsRUFBRSxFQUFVLEVBQUUsS0FBNkM7UUFDckYsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztRQUVqQixJQUFJLHlDQUFtQixDQUFDLElBQUksRUFBRSxVQUFVLEVBQUU7WUFDeEMsVUFBVSxFQUFFLG1CQUFtQjtZQUMvQixRQUFRLEVBQUUsdUJBQXVCO1lBQ2pDLEtBQUssRUFBRSxLQUFLLENBQUMsV0FBVyxDQUFDLFFBQVEsRUFBRTtTQUNwQyxDQUFDLENBQUM7SUFDTCxDQUFDOztBQVRILDhFQVVDOzs7Ozs7Ozs7Ozs7O0FBc0JELE1BQWEsMEJBQTJCLFNBQVEsZUFBUTs7OztJQUN0RCxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFFLEtBQXNDO1FBQzlFLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFFakIsSUFBSSx5Q0FBbUIsQ0FBQyxJQUFJLEVBQUUsVUFBVSxFQUFFO1lBQ3hDLFVBQVUsRUFBRSxXQUFXO1lBQ3ZCLFFBQVEsRUFBRSxZQUFZO1lBQ3RCLFFBQVEsRUFBRSxLQUFLLENBQUMsUUFBUSxDQUFDLFFBQVEsRUFBRTtZQUNuQyxLQUFLLEVBQUUsS0FBSyxDQUFDLFFBQVEsQ0FBQyxRQUFRLEVBQUU7U0FDakMsQ0FBQyxDQUFDO0lBQ0wsQ0FBQzs7QUFWSCxnRUFXQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IFJlc291cmNlLCBTZWNyZXRWYWx1ZSB9IGZyb20gJ0Bhd3MtY2RrL2NvcmUnO1xuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnY29uc3RydWN0cyc7XG5pbXBvcnQgeyBDZm5Tb3VyY2VDcmVkZW50aWFsIH0gZnJvbSAnLi9jb2RlYnVpbGQuZ2VuZXJhdGVkJztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGludGVyZmFjZSBHaXRIdWJTb3VyY2VDcmVkZW50aWFsc1Byb3BzIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBhY2Nlc3NUb2tlbjogU2VjcmV0VmFsdWU7XG59XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBjbGFzcyBHaXRIdWJTb3VyY2VDcmVkZW50aWFscyBleHRlbmRzIFJlc291cmNlIHtcbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IEdpdEh1YlNvdXJjZUNyZWRlbnRpYWxzUHJvcHMpIHtcbiAgICBzdXBlcihzY29wZSwgaWQpO1xuXG4gICAgbmV3IENmblNvdXJjZUNyZWRlbnRpYWwodGhpcywgJ1Jlc291cmNlJywge1xuICAgICAgc2VydmVyVHlwZTogJ0dJVEhVQicsXG4gICAgICBhdXRoVHlwZTogJ1BFUlNPTkFMX0FDQ0VTU19UT0tFTicsXG4gICAgICB0b2tlbjogcHJvcHMuYWNjZXNzVG9rZW4udG9TdHJpbmcoKSxcbiAgICB9KTtcbiAgfVxufVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGludGVyZmFjZSBHaXRIdWJFbnRlcnByaXNlU291cmNlQ3JlZGVudGlhbHNQcm9wcyB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBhY2Nlc3NUb2tlbjogU2VjcmV0VmFsdWU7XG59XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgY2xhc3MgR2l0SHViRW50ZXJwcmlzZVNvdXJjZUNyZWRlbnRpYWxzIGV4dGVuZHMgUmVzb3VyY2Uge1xuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogR2l0SHViRW50ZXJwcmlzZVNvdXJjZUNyZWRlbnRpYWxzUHJvcHMpIHtcbiAgICBzdXBlcihzY29wZSwgaWQpO1xuXG4gICAgbmV3IENmblNvdXJjZUNyZWRlbnRpYWwodGhpcywgJ1Jlc291cmNlJywge1xuICAgICAgc2VydmVyVHlwZTogJ0dJVEhVQl9FTlRFUlBSSVNFJyxcbiAgICAgIGF1dGhUeXBlOiAnUEVSU09OQUxfQUNDRVNTX1RPS0VOJyxcbiAgICAgIHRva2VuOiBwcm9wcy5hY2Nlc3NUb2tlbi50b1N0cmluZygpLFxuICAgIH0pO1xuICB9XG59XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBpbnRlcmZhY2UgQml0QnVja2V0U291cmNlQ3JlZGVudGlhbHNQcm9wcyB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgdXNlcm5hbWU6IFNlY3JldFZhbHVlO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgcGFzc3dvcmQ6IFNlY3JldFZhbHVlO1xufVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgY2xhc3MgQml0QnVja2V0U291cmNlQ3JlZGVudGlhbHMgZXh0ZW5kcyBSZXNvdXJjZSB7XG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBCaXRCdWNrZXRTb3VyY2VDcmVkZW50aWFsc1Byb3BzKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkKTtcblxuICAgIG5ldyBDZm5Tb3VyY2VDcmVkZW50aWFsKHRoaXMsICdSZXNvdXJjZScsIHtcbiAgICAgIHNlcnZlclR5cGU6ICdCSVRCVUNLRVQnLFxuICAgICAgYXV0aFR5cGU6ICdCQVNJQ19BVVRIJyxcbiAgICAgIHVzZXJuYW1lOiBwcm9wcy51c2VybmFtZS50b1N0cmluZygpLFxuICAgICAgdG9rZW46IHByb3BzLnBhc3N3b3JkLnRvU3RyaW5nKCksXG4gICAgfSk7XG4gIH1cbn1cbiJdfQ==