"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ScheduledEc2Task = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_ecs_1 = require("@aws-cdk/aws-ecs");
const scheduled_task_base_1 = require("../base/scheduled-task-base");
/**
 * A scheduled EC2 task that will be initiated off of CloudWatch Events.
 *
 * @stability stable
 */
class ScheduledEc2Task extends scheduled_task_base_1.ScheduledTaskBase {
    /**
     * Constructs a new instance of the ScheduledEc2Task class.
     *
     * @stability stable
     */
    constructor(scope, id, props) {
        var _b;
        super(scope, id, props);
        if (props.scheduledEc2TaskDefinitionOptions && props.scheduledEc2TaskImageOptions) {
            throw new Error('You must specify either a scheduledEc2TaskDefinitionOptions or scheduledEc2TaskOptions, not both.');
        }
        else if (props.scheduledEc2TaskDefinitionOptions) {
            this.taskDefinition = props.scheduledEc2TaskDefinitionOptions.taskDefinition;
        }
        else if (props.scheduledEc2TaskImageOptions) {
            const taskImageOptions = props.scheduledEc2TaskImageOptions;
            // Create a Task Definition for the container to start, also creates a log driver
            this.taskDefinition = new aws_ecs_1.Ec2TaskDefinition(this, 'ScheduledTaskDef');
            this.taskDefinition.addContainer('ScheduledContainer', {
                image: taskImageOptions.image,
                memoryLimitMiB: taskImageOptions.memoryLimitMiB,
                memoryReservationMiB: taskImageOptions.memoryReservationMiB,
                cpu: taskImageOptions.cpu,
                command: taskImageOptions.command,
                environment: taskImageOptions.environment,
                secrets: taskImageOptions.secrets,
                logging: (_b = taskImageOptions.logDriver) !== null && _b !== void 0 ? _b : this.createAWSLogDriver(this.node.id),
            });
        }
        else {
            throw new Error('You must specify a taskDefinition or image');
        }
        this.addTaskDefinitionToEventTarget(this.taskDefinition);
    }
}
exports.ScheduledEc2Task = ScheduledEc2Task;
_a = JSII_RTTI_SYMBOL_1;
ScheduledEc2Task[_a] = { fqn: "@aws-cdk/aws-ecs-patterns.ScheduledEc2Task", version: "1.101.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic2NoZWR1bGVkLWVjcy10YXNrLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsic2NoZWR1bGVkLWVjcy10YXNrLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQUEsOENBQXFEO0FBRXJELHFFQUFpSDs7Ozs7O0FBOEVqSCxNQUFhLGdCQUFpQixTQUFRLHVDQUFpQjs7Ozs7O0lBVXJELFlBQVksS0FBZ0IsRUFBRSxFQUFVLEVBQUUsS0FBNEI7O1FBQ3BFLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFLEtBQUssQ0FBQyxDQUFDO1FBRXhCLElBQUksS0FBSyxDQUFDLGlDQUFpQyxJQUFJLEtBQUssQ0FBQyw0QkFBNEIsRUFBRTtZQUNqRixNQUFNLElBQUksS0FBSyxDQUFDLG1HQUFtRyxDQUFDLENBQUM7U0FDdEg7YUFBTSxJQUFJLEtBQUssQ0FBQyxpQ0FBaUMsRUFBRTtZQUNsRCxJQUFJLENBQUMsY0FBYyxHQUFHLEtBQUssQ0FBQyxpQ0FBaUMsQ0FBQyxjQUFjLENBQUM7U0FDOUU7YUFBTSxJQUFJLEtBQUssQ0FBQyw0QkFBNEIsRUFBRTtZQUM3QyxNQUFNLGdCQUFnQixHQUFHLEtBQUssQ0FBQyw0QkFBNEIsQ0FBQztZQUM1RCxpRkFBaUY7WUFDakYsSUFBSSxDQUFDLGNBQWMsR0FBRyxJQUFJLDJCQUFpQixDQUFDLElBQUksRUFBRSxrQkFBa0IsQ0FBQyxDQUFDO1lBQ3RFLElBQUksQ0FBQyxjQUFjLENBQUMsWUFBWSxDQUFDLG9CQUFvQixFQUFFO2dCQUNyRCxLQUFLLEVBQUUsZ0JBQWdCLENBQUMsS0FBSztnQkFDN0IsY0FBYyxFQUFFLGdCQUFnQixDQUFDLGNBQWM7Z0JBQy9DLG9CQUFvQixFQUFFLGdCQUFnQixDQUFDLG9CQUFvQjtnQkFDM0QsR0FBRyxFQUFFLGdCQUFnQixDQUFDLEdBQUc7Z0JBQ3pCLE9BQU8sRUFBRSxnQkFBZ0IsQ0FBQyxPQUFPO2dCQUNqQyxXQUFXLEVBQUUsZ0JBQWdCLENBQUMsV0FBVztnQkFDekMsT0FBTyxFQUFFLGdCQUFnQixDQUFDLE9BQU87Z0JBQ2pDLE9BQU8sUUFBRSxnQkFBZ0IsQ0FBQyxTQUFTLG1DQUFJLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLEVBQUUsQ0FBQzthQUM3RSxDQUFDLENBQUM7U0FDSjthQUFNO1lBQ0wsTUFBTSxJQUFJLEtBQUssQ0FBQyw0Q0FBNEMsQ0FBQyxDQUFDO1NBQy9EO1FBRUQsSUFBSSxDQUFDLDhCQUE4QixDQUFDLElBQUksQ0FBQyxjQUFjLENBQUMsQ0FBQztJQUMzRCxDQUFDOztBQXBDSCw0Q0FxQ0MiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBFYzJUYXNrRGVmaW5pdGlvbiB9IGZyb20gJ0Bhd3MtY2RrL2F3cy1lY3MnO1xuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnY29uc3RydWN0cyc7XG5pbXBvcnQgeyBTY2hlZHVsZWRUYXNrQmFzZSwgU2NoZWR1bGVkVGFza0Jhc2VQcm9wcywgU2NoZWR1bGVkVGFza0ltYWdlUHJvcHMgfSBmcm9tICcuLi9iYXNlL3NjaGVkdWxlZC10YXNrLWJhc2UnO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGludGVyZmFjZSBTY2hlZHVsZWRFYzJUYXNrUHJvcHMgZXh0ZW5kcyBTY2hlZHVsZWRUYXNrQmFzZVByb3BzIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBzY2hlZHVsZWRFYzJUYXNrRGVmaW5pdGlvbk9wdGlvbnM/OiBTY2hlZHVsZWRFYzJUYXNrRGVmaW5pdGlvbk9wdGlvbnM7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHNjaGVkdWxlZEVjMlRhc2tJbWFnZU9wdGlvbnM/OiBTY2hlZHVsZWRFYzJUYXNrSW1hZ2VPcHRpb25zO1xufVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBpbnRlcmZhY2UgU2NoZWR1bGVkRWMyVGFza0ltYWdlT3B0aW9ucyBleHRlbmRzIFNjaGVkdWxlZFRhc2tJbWFnZVByb3BzIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBjcHU/OiBudW1iZXI7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBtZW1vcnlMaW1pdE1pQj86IG51bWJlcjtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgbWVtb3J5UmVzZXJ2YXRpb25NaUI/OiBudW1iZXI7XG59XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGludGVyZmFjZSBTY2hlZHVsZWRFYzJUYXNrRGVmaW5pdGlvbk9wdGlvbnMge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgdGFza0RlZmluaXRpb246IEVjMlRhc2tEZWZpbml0aW9uO1xufVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGNsYXNzIFNjaGVkdWxlZEVjMlRhc2sgZXh0ZW5kcyBTY2hlZHVsZWRUYXNrQmFzZSB7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyByZWFkb25seSB0YXNrRGVmaW5pdGlvbjogRWMyVGFza0RlZmluaXRpb247XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IFNjaGVkdWxlZEVjMlRhc2tQcm9wcykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCwgcHJvcHMpO1xuXG4gICAgaWYgKHByb3BzLnNjaGVkdWxlZEVjMlRhc2tEZWZpbml0aW9uT3B0aW9ucyAmJiBwcm9wcy5zY2hlZHVsZWRFYzJUYXNrSW1hZ2VPcHRpb25zKSB7XG4gICAgICB0aHJvdyBuZXcgRXJyb3IoJ1lvdSBtdXN0IHNwZWNpZnkgZWl0aGVyIGEgc2NoZWR1bGVkRWMyVGFza0RlZmluaXRpb25PcHRpb25zIG9yIHNjaGVkdWxlZEVjMlRhc2tPcHRpb25zLCBub3QgYm90aC4nKTtcbiAgICB9IGVsc2UgaWYgKHByb3BzLnNjaGVkdWxlZEVjMlRhc2tEZWZpbml0aW9uT3B0aW9ucykge1xuICAgICAgdGhpcy50YXNrRGVmaW5pdGlvbiA9IHByb3BzLnNjaGVkdWxlZEVjMlRhc2tEZWZpbml0aW9uT3B0aW9ucy50YXNrRGVmaW5pdGlvbjtcbiAgICB9IGVsc2UgaWYgKHByb3BzLnNjaGVkdWxlZEVjMlRhc2tJbWFnZU9wdGlvbnMpIHtcbiAgICAgIGNvbnN0IHRhc2tJbWFnZU9wdGlvbnMgPSBwcm9wcy5zY2hlZHVsZWRFYzJUYXNrSW1hZ2VPcHRpb25zO1xuICAgICAgLy8gQ3JlYXRlIGEgVGFzayBEZWZpbml0aW9uIGZvciB0aGUgY29udGFpbmVyIHRvIHN0YXJ0LCBhbHNvIGNyZWF0ZXMgYSBsb2cgZHJpdmVyXG4gICAgICB0aGlzLnRhc2tEZWZpbml0aW9uID0gbmV3IEVjMlRhc2tEZWZpbml0aW9uKHRoaXMsICdTY2hlZHVsZWRUYXNrRGVmJyk7XG4gICAgICB0aGlzLnRhc2tEZWZpbml0aW9uLmFkZENvbnRhaW5lcignU2NoZWR1bGVkQ29udGFpbmVyJywge1xuICAgICAgICBpbWFnZTogdGFza0ltYWdlT3B0aW9ucy5pbWFnZSxcbiAgICAgICAgbWVtb3J5TGltaXRNaUI6IHRhc2tJbWFnZU9wdGlvbnMubWVtb3J5TGltaXRNaUIsXG4gICAgICAgIG1lbW9yeVJlc2VydmF0aW9uTWlCOiB0YXNrSW1hZ2VPcHRpb25zLm1lbW9yeVJlc2VydmF0aW9uTWlCLFxuICAgICAgICBjcHU6IHRhc2tJbWFnZU9wdGlvbnMuY3B1LFxuICAgICAgICBjb21tYW5kOiB0YXNrSW1hZ2VPcHRpb25zLmNvbW1hbmQsXG4gICAgICAgIGVudmlyb25tZW50OiB0YXNrSW1hZ2VPcHRpb25zLmVudmlyb25tZW50LFxuICAgICAgICBzZWNyZXRzOiB0YXNrSW1hZ2VPcHRpb25zLnNlY3JldHMsXG4gICAgICAgIGxvZ2dpbmc6IHRhc2tJbWFnZU9wdGlvbnMubG9nRHJpdmVyID8/IHRoaXMuY3JlYXRlQVdTTG9nRHJpdmVyKHRoaXMubm9kZS5pZCksXG4gICAgICB9KTtcbiAgICB9IGVsc2Uge1xuICAgICAgdGhyb3cgbmV3IEVycm9yKCdZb3UgbXVzdCBzcGVjaWZ5IGEgdGFza0RlZmluaXRpb24gb3IgaW1hZ2UnKTtcbiAgICB9XG5cbiAgICB0aGlzLmFkZFRhc2tEZWZpbml0aW9uVG9FdmVudFRhcmdldCh0aGlzLnRhc2tEZWZpbml0aW9uKTtcbiAgfVxufVxuIl19